/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Mod;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat512;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SecP521R1Field {
    public static final int[] P = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 511};
    private static final int P16 = 511;

    public static void add(int[] nArray, int[] nArray2, int[] nArray3) {
        int n3 = Nat.add(16, nArray, nArray2, nArray3) + nArray[16] + nArray2[16];
        if (n3 > 511 || n3 == 511 && Nat.eq(16, nArray3, nArray2 = P)) {
            n3 = Nat.inc(16, nArray3) + n3 & 0x1FF;
        }
        nArray3[16] = n3;
    }

    public static void addOne(int[] nArray, int[] nArray2) {
        int[] nArray3;
        int n3 = Nat.inc(16, nArray, nArray2) + nArray[16];
        if (n3 > 511 || n3 == 511 && Nat.eq(16, nArray2, nArray3 = P)) {
            n3 = Nat.inc(16, nArray2) + n3 & 0x1FF;
        }
        nArray2[16] = n3;
    }

    public static int[] fromBigInteger(BigInteger object) {
        int[] nArray;
        if (Nat.eq(17, (int[])(object = (Object)Nat.fromBigInteger(521, (BigInteger)object)), nArray = P)) {
            Nat.zero(17, (int[])object);
        }
        return object;
    }

    public static void half(int[] nArray, int[] nArray2) {
        int n3 = nArray[16];
        int n4 = Nat.shiftDownBit(16, nArray, n3, nArray2);
        nArray2[16] = n3 >>> 1 | n4 >>> 23;
    }

    public static void inv(int[] nArray, int[] nArray2) {
        Mod.checkedModOddInverse(P, nArray, nArray2);
    }

    public static int isZero(int[] nArray) {
        int n3 = 0;
        for (int i3 = 0; i3 < 17; ++i3) {
            n3 |= nArray[i3];
        }
        return (n3 >>> 1 | n3 & 1) - 1 >> 31;
    }

    public static void multiply(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = Nat.create(33);
        SecP521R1Field.implMultiply(nArray, nArray2, nArray4);
        SecP521R1Field.reduce(nArray4, nArray3);
    }

    public static void negate(int[] nArray, int[] nArray2) {
        if (SecP521R1Field.isZero(nArray) != 0) {
            int[] nArray3 = P;
            Nat.sub(17, nArray3, nArray3, nArray2);
        } else {
            Nat.sub(17, P, nArray, nArray2);
        }
    }

    public static void random(SecureRandom secureRandom, int[] nArray) {
        int[] nArray2;
        byte[] byArray = new byte[68];
        do {
            secureRandom.nextBytes(byArray);
            Pack.littleEndianToInt(byArray, 0, nArray, 0, 17);
            nArray[16] = nArray[16] & 0x1FF;
        } while (Nat.lessThan(17, nArray, nArray2 = P) == 0);
    }

    public static void randomMult(SecureRandom secureRandom, int[] nArray) {
        do {
            SecP521R1Field.random(secureRandom, nArray);
        } while (SecP521R1Field.isZero(nArray) != 0);
    }

    public static void reduce(int[] nArray, int[] nArray2) {
        int[] nArray3;
        int n3 = nArray[32];
        int n4 = Nat.addTo(16, nArray, nArray2) + ((Nat.shiftDownBits(16, nArray, 16, 9, n3, nArray2, 0) >>> 23) + (n3 >>> 9));
        if (n4 > 511 || n4 == 511 && Nat.eq(16, nArray2, nArray3 = P)) {
            n4 = Nat.inc(16, nArray2) + n4 & 0x1FF;
        }
        nArray2[16] = n4;
    }

    public static void reduce23(int[] nArray) {
        int[] nArray2;
        int n3 = nArray[16];
        if ((n3 = Nat.addWordTo(16, n3 >>> 9, nArray) + (n3 & 0x1FF)) > 511 || n3 == 511 && Nat.eq(16, nArray, nArray2 = P)) {
            n3 = Nat.inc(16, nArray) + n3 & 0x1FF;
        }
        nArray[16] = n3;
    }

    public static void square(int[] nArray, int[] nArray2) {
        int[] nArray3 = Nat.create(33);
        SecP521R1Field.implSquare(nArray, nArray3);
        SecP521R1Field.reduce(nArray3, nArray2);
    }

    public static void squareN(int[] nArray, int n3, int[] nArray2) {
        int[] nArray3 = Nat.create(33);
        SecP521R1Field.implSquare(nArray, nArray3);
        SecP521R1Field.reduce(nArray3, nArray2);
        while ((n3 += -1) > 0) {
            SecP521R1Field.implSquare(nArray2, nArray3);
            SecP521R1Field.reduce(nArray3, nArray2);
        }
    }

    public static void subtract(int[] nArray, int[] nArray2, int[] nArray3) {
        int n3 = Nat.sub(16, nArray, nArray2, nArray3) + nArray[16] - nArray2[16];
        if (n3 < 0) {
            n3 = Nat.dec(16, nArray3) + n3 & 0x1FF;
        }
        nArray3[16] = n3;
    }

    public static void twice(int[] nArray, int[] nArray2) {
        int n3 = nArray[16];
        int n4 = n3 << 23;
        nArray2[16] = (Nat.shiftUpBit(16, nArray, n4, nArray2) | n3 << 1) & 0x1FF;
    }

    public static void implMultiply(int[] nArray, int[] nArray2, int[] nArray3) {
        Nat512.mul(nArray, nArray2, nArray3);
        int n3 = nArray[16];
        int n4 = nArray2[16];
        int n5 = Nat.mul31BothAdd(16, n3, nArray2, n4, nArray, nArray3, 16);
        nArray3[32] = n3 * n4 + n5;
    }

    public static void implSquare(int[] nArray, int[] nArray2) {
        Nat512.square(nArray, nArray2);
        int n3 = nArray[16];
        int n4 = Nat.mulWordAddTo(16, n3 << 1, nArray, 0, nArray2, 16);
        nArray2[32] = n3 * n3 + n4;
    }
}

