/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.AbstractECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECConstants;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecT113FieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecT113R1Point;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat128;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecT113R1Curve
extends ECCurve.AbstractF2m {
    private static final int SECT113R1_DEFAULT_COORDS = 6;
    private static final ECFieldElement[] SECT113R1_AFFINE_ZS;
    public SecT113R1Point infinity;

    public SecT113R1Curve() {
        SecT113R1Curve secT113R1Curve = this;
        super(113, 9, 0, 0);
        secT113R1Curve.infinity = new SecT113R1Point(this, null, null);
        secT113R1Curve.a = secT113R1Curve.fromBigInteger(new BigInteger(1, Hex.decodeStrict("003088250CA6E7C7FE649CE85820F7")));
        secT113R1Curve.b = secT113R1Curve.fromBigInteger(new BigInteger(1, Hex.decodeStrict("00E8BEE4D3E2260744188BE0E9C723")));
        secT113R1Curve.order = new BigInteger(1, Hex.decodeStrict("0100000000000000D9CCEC8A39E56F"));
        secT113R1Curve.cofactor = BigInteger.valueOf(2L);
        secT113R1Curve.coord = 6;
    }

    static {
        SecT113FieldElement secT113FieldElement;
        ECFieldElement[] eCFieldElementArray = new ECFieldElement[1];
        SecT113FieldElement secT113FieldElement2 = secT113FieldElement;
        secT113FieldElement = new SecT113FieldElement(ECConstants.ONE);
        eCFieldElementArray[0] = secT113FieldElement2;
        SECT113R1_AFFINE_ZS = eCFieldElementArray;
    }

    @Override
    public ECCurve cloneCurve() {
        return new SecT113R1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int n3) {
        return n3 == 6;
    }

    @Override
    public int getFieldSize() {
        return 113;
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecT113FieldElement(bigInteger);
    }

    @Override
    public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return new SecT113R1Point(this, eCFieldElement, eCFieldElement2);
    }

    @Override
    public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        return new SecT113R1Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public boolean isKoblitz() {
        return false;
    }

    public int getM() {
        return 113;
    }

    public boolean isTrinomial() {
        return true;
    }

    public int getK1() {
        return 9;
    }

    public int getK2() {
        return 0;
    }

    public int getK3() {
        return 0;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n3, final int n4) {
        final long[] lArray = new long[n4 * 2 * 2];
        int n5 = 0;
        for (int i3 = 0; i3 < n4; ++i3) {
            ECPoint eCPoint = eCPointArray[n3 + i3];
            Nat128.copy64(((SecT113FieldElement)eCPoint.getRawXCoord()).x, 0, lArray, n5);
            Nat128.copy64(((SecT113FieldElement)eCPoint.getRawYCoord()).x, 0, lArray, n5 += 2);
            n5 += 2;
        }
        return new AbstractECLookupTable(){

            private ECPoint createPoint(long[] lArray3, long[] lArray2) {
                SecT113FieldElement secT113FieldElement;
                SecT113FieldElement secT113FieldElement2 = secT113FieldElement;
                secT113FieldElement = new SecT113FieldElement(lArray2);
                return secT113FieldElement2.SecT113R1Curve.this.createRawPoint(new SecT113FieldElement(lArray3), secT113FieldElement2, SECT113R1_AFFINE_ZS);
            }

            @Override
            public int getSize() {
                return n4;
            }

            @Override
            public ECPoint lookup(int n3) {
                long[] lArray4 = Nat128.create64();
                long[] lArray2 = Nat128.create64();
                int n42 = 0;
                for (int i3 = 0; i3 < n4; ++i3) {
                    long l3 = (i3 ^ n3) - 1 >> 31;
                    for (int i4 = 0; i4 < 2; ++i4) {
                        long[] lArray3 = lArray;
                        lArray4[i4] = lArray4[i4] ^ lArray[n42 + i4] & l3;
                        lArray2[i4] = lArray2[i4] ^ lArray3[n42 + 2 + i4] & l3;
                    }
                    n42 += 4;
                }
                return this.createPoint(lArray4, lArray2);
            }

            @Override
            public ECPoint lookupVar(int n3) {
                long[] lArray4 = Nat128.create64();
                long[] lArray2 = Nat128.create64();
                int n42 = n3 * 2 * 2;
                for (int i3 = 0; i3 < 2; ++i3) {
                    long[] lArray3 = lArray;
                    lArray4[i3] = lArray3[n42 + i3];
                    lArray2[i3] = lArray[n42 + 2 + i3];
                }
                return this.createPoint(lArray4, lArray2);
            }
        };
    }
}

