/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Interleave;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat256;
import java.math.BigInteger;

public class SecT193Field {
    private static final long M01 = 1L;
    private static final long M49 = 0x1FFFFFFFFFFFFL;

    public static void add(long[] lArray, long[] lArray2, long[] lArray3) {
        long l3;
        long l4;
        lArray3[0] = l4 = lArray[0] ^ lArray2[0];
        lArray3[1] = l4 = lArray[1] ^ lArray2[1];
        lArray3[2] = l4 = lArray[2] ^ lArray2[2];
        lArray3[3] = l3 = lArray[3] ^ lArray2[3];
    }

    public static void addExt(long[] lArray, long[] lArray2, long[] lArray3) {
        long l3;
        long l4;
        lArray3[0] = l4 = lArray[0] ^ lArray2[0];
        lArray3[1] = l4 = lArray[1] ^ lArray2[1];
        lArray3[2] = l4 = lArray[2] ^ lArray2[2];
        lArray3[3] = l4 = lArray[3] ^ lArray2[3];
        lArray3[4] = l4 = lArray[4] ^ lArray2[4];
        lArray3[5] = l4 = lArray[5] ^ lArray2[5];
        lArray3[6] = l3 = lArray[6] ^ lArray2[6];
    }

    public static void addOne(long[] lArray, long[] lArray2) {
        long l3;
        lArray2[0] = l3 = lArray[0] ^ 1L;
        lArray2[1] = l3 = lArray[1];
        lArray2[2] = l3 = lArray[2];
        lArray2[3] = l3 = lArray[3];
    }

    private static void addTo(long[] lArray, long[] lArray2) {
        long l3;
        long l4;
        long[] lArray3 = lArray2;
        lArray3[0] = l4 = lArray2[0] ^ lArray[0];
        lArray3[1] = l4 = lArray2[1] ^ lArray[1];
        lArray3[2] = l4 = lArray2[2] ^ lArray[2];
        lArray3[3] = l3 = lArray2[3] ^ lArray[3];
    }

    public static long[] fromBigInteger(BigInteger bigInteger) {
        return Nat.fromBigInteger64(193, bigInteger);
    }

    public static void halfTrace(long[] lArray, long[] lArray2) {
        long[] lArray3 = Nat256.createExt64();
        Nat256.copy64(lArray, lArray2);
        for (int i3 = 1; i3 < 193; i3 += 2) {
            SecT193Field.implSquare(lArray2, lArray3);
            SecT193Field.reduce(lArray3, lArray2);
            SecT193Field.implSquare(lArray2, lArray3);
            SecT193Field.reduce(lArray3, lArray2);
            SecT193Field.addTo(lArray, lArray2);
        }
    }

    public static void invert(long[] lArray, long[] lArray2) {
        if (!Nat256.isZero64(lArray)) {
            long[] lArray3 = Nat256.create64();
            long[] lArray4 = Nat256.create64();
            SecT193Field.square(lArray, lArray3);
            SecT193Field.squareN(lArray3, 1, lArray4);
            SecT193Field.multiply(lArray3, lArray4, lArray3);
            SecT193Field.squareN(lArray4, 1, lArray4);
            SecT193Field.multiply(lArray3, lArray4, lArray3);
            SecT193Field.squareN(lArray3, 3, lArray4);
            SecT193Field.multiply(lArray3, lArray4, lArray3);
            SecT193Field.squareN(lArray3, 6, lArray4);
            SecT193Field.multiply(lArray3, lArray4, lArray3);
            SecT193Field.squareN(lArray3, 12, lArray4);
            SecT193Field.multiply(lArray3, lArray4, lArray3);
            SecT193Field.squareN(lArray3, 24, lArray4);
            SecT193Field.multiply(lArray3, lArray4, lArray3);
            SecT193Field.squareN(lArray3, 48, lArray4);
            SecT193Field.multiply(lArray3, lArray4, lArray3);
            SecT193Field.squareN(lArray3, 96, lArray4);
            SecT193Field.multiply(lArray3, lArray4, lArray2);
            return;
        }
        throw new IllegalStateException();
    }

    public static void multiply(long[] lArray, long[] lArray2, long[] lArray3) {
        long[] lArray4 = Nat256.createExt64();
        SecT193Field.implMultiply(lArray, lArray2, lArray4);
        SecT193Field.reduce(lArray4, lArray3);
    }

    public static void multiplyAddToExt(long[] lArray, long[] lArray2, long[] lArray3) {
        long[] lArray4 = lArray;
        lArray = Nat256.createExt64();
        SecT193Field.implMultiply(lArray4, lArray2, lArray);
        SecT193Field.addExt(lArray3, lArray, lArray3);
    }

    public static void reduce(long[] lArray, long[] lArray2) {
        long l3;
        long l4 = lArray[0];
        long l5 = lArray[1];
        long l6 = lArray[2];
        long l7 = lArray[4];
        long l8 = lArray[5];
        long l9 = lArray[6];
        long l10 = l6 ^= l9 << 63;
        long l11 = l5;
        l5 = l7 ^ l9 >>> 50;
        l6 = l11 ^ l8 << 63;
        l7 = l10 ^ (l8 >>> 1 ^ l8 << 14);
        l8 = lArray[3] ^ (l9 >>> 1 ^ l9 << 14) ^ l8 >>> 50;
        l4 ^= l5 << 63;
        long l12 = l6 ^ (l5 >>> 1 ^ l5 << 14);
        l5 = l7 ^ l5 >>> 50;
        l6 = l8 >>> 1;
        lArray2[0] = l3 = l4 ^ l6 ^ l6 << 15;
        lArray2[1] = l3 = l12 ^ l6 >>> 49;
        lArray2[2] = l5;
        lArray2[3] = l3 = l8 & 1L;
    }

    public static void reduce63(long[] lArray, int n3) {
        long l3;
        int n4 = n3 + 3;
        long l4 = lArray[n4];
        long[] lArray2 = lArray;
        long l5 = l3 = l4 >>> 1;
        lArray2[n3] = lArray[n3] ^ (l5 ^ l5 << 15);
        int n5 = n3 + 1;
        lArray[n5] = l3 = lArray2[n5] ^ l3 >>> 49;
        lArray[n4] = l4 & 1L;
    }

    public static void sqrt(long[] lArray, long[] lArray2) {
        long l3;
        long l4 = Interleave.unshuffle(lArray[0]);
        long l5 = Interleave.unshuffle(lArray[1]);
        long l6 = l4 & 0xFFFFFFFFL | l5 << 32;
        l5 = l4 >>> 32 | l5 & 0xFFFFFFFF00000000L;
        long l7 = Interleave.unshuffle(lArray[2]);
        long l8 = l7 & 0xFFFFFFFFL ^ lArray[3] << 32;
        long l9 = l7 >>> 32;
        lArray2[0] = l3 = l6 ^ l5 << 8;
        lArray2[1] = l3 = l8 ^ l9 << 8 ^ l5 >>> 56 ^ l5 << 33;
        lArray2[2] = l3 = l9 >>> 56 ^ l9 << 33 ^ l5 >>> 31;
        lArray2[3] = l3 = l9 >>> 31;
    }

    public static void square(long[] lArray, long[] lArray2) {
        long[] lArray3 = Nat256.createExt64();
        SecT193Field.implSquare(lArray, lArray3);
        SecT193Field.reduce(lArray3, lArray2);
    }

    public static void squareAddToExt(long[] lArray, long[] lArray2) {
        long[] lArray3 = lArray;
        lArray = Nat256.createExt64();
        SecT193Field.implSquare(lArray3, lArray);
        SecT193Field.addExt(lArray2, lArray, lArray2);
    }

    public static void squareN(long[] lArray, int n3, long[] lArray2) {
        long[] lArray3 = Nat256.createExt64();
        SecT193Field.implSquare(lArray, lArray3);
        SecT193Field.reduce(lArray3, lArray2);
        while ((n3 += -1) > 0) {
            SecT193Field.implSquare(lArray2, lArray3);
            SecT193Field.reduce(lArray3, lArray2);
        }
    }

    public static int trace(long[] lArray) {
        return (int)lArray[0] & 1;
    }

    public static void implCompactExt(long[] lArray) {
        long[] lArray2 = lArray;
        long[] lArray3 = lArray;
        long l3 = lArray2[0];
        long l4 = lArray3[1];
        long l5 = lArray2[2];
        long l6 = lArray3[3];
        long l7 = lArray2[4];
        long l8 = lArray3[5];
        long l9 = lArray2[6];
        long l10 = lArray3[7];
        lArray[0] = l3 ^= l4 << 49;
        lArray[1] = l3 = l4 >>> 15 ^ l5 << 34;
        lArray[2] = l3 = l5 >>> 30 ^ l6 << 19;
        lArray[3] = l3 = l6 >>> 45 ^ l7 << 4 ^ l8 << 53;
        lArray[4] = l3 = l7 >>> 60 ^ l9 << 38 ^ l8 >>> 11;
        lArray[5] = l3 = l9 >>> 26 ^ l10 << 23;
        lArray2[6] = l3 = l10 >>> 41;
        lArray3[7] = 0L;
    }

    public static void implExpand(long[] lArray, long[] lArray2) {
        long l3 = lArray[0];
        long l4 = lArray[1];
        long l5 = lArray[2];
        long l6 = l3;
        long l7 = lArray[3];
        lArray2[0] = l3 &= 0x1FFFFFFFFFFFFL;
        lArray2[1] = l3 = (l6 >>> 49 ^ l4 << 15) & 0x1FFFFFFFFFFFFL;
        lArray2[2] = l3 = (l4 >>> 34 ^ l5 << 30) & 0x1FFFFFFFFFFFFL;
        lArray2[3] = l7 = l5 >>> 19 ^ l7 << 45;
    }

    public static void implMultiply(long[] lArray, long[] lArray2, long[] lArray3) {
        long l3;
        long[] lArray4 = lArray2;
        long[] lArray5 = lArray;
        lArray = new long[4];
        lArray2 = new long[4];
        SecT193Field.implExpand(lArray5, lArray);
        SecT193Field.implExpand(lArray4, lArray2);
        long[] lArray6 = new long[8];
        long l4 = lArray[0];
        long l5 = lArray2[0];
        SecT193Field.implMulwAcc(lArray6, l4, l5, lArray3, 0);
        l4 = lArray[1];
        l5 = lArray2[1];
        SecT193Field.implMulwAcc(lArray6, l4, l5, lArray3, 1);
        l4 = lArray[2];
        l5 = lArray2[2];
        SecT193Field.implMulwAcc(lArray6, l4, l5, lArray3, 2);
        l4 = lArray[3];
        l5 = lArray2[3];
        SecT193Field.implMulwAcc(lArray6, l4, l5, lArray3, 3);
        for (int i3 = 5; i3 > 0; --i3) {
            lArray3[i3] = lArray3[i3] ^ lArray3[i3 - 1];
        }
        long l6 = lArray[0] ^ lArray[1];
        l5 = lArray2[0] ^ lArray2[1];
        SecT193Field.implMulwAcc(lArray6, l6, l5, lArray3, 1);
        l6 = lArray[2] ^ lArray[3];
        l5 = lArray2[2] ^ lArray2[3];
        SecT193Field.implMulwAcc(lArray6, l6, l5, lArray3, 3);
        for (int i4 = 7; i4 > 1; --i4) {
            lArray3[i4] = lArray3[i4] ^ lArray3[i4 - 2];
        }
        long[] lArray7 = lArray3;
        long l7 = lArray[0] ^ lArray[2];
        l5 = lArray[1] ^ lArray[3];
        long l8 = lArray2[0] ^ lArray2[2];
        long l9 = lArray2[1] ^ lArray2[3];
        long l10 = l7 ^ l5;
        long l11 = l8 ^ l9;
        SecT193Field.implMulwAcc(lArray6, l10, l11, lArray3, 3);
        lArray3 = new long[3];
        SecT193Field.implMulwAcc(lArray6, l7, l8, lArray3, 0);
        SecT193Field.implMulwAcc(lArray6, l5, l9, lArray3, 1);
        l9 = lArray3[0];
        long l12 = lArray3[1];
        long l13 = lArray3[2];
        lArray7[2] = l3 = lArray7[2] ^ l9;
        lArray7[3] = l9 = lArray7[3] ^ (l9 ^ l12);
        lArray7[4] = l9 = lArray7[4] ^ (l13 ^ l12);
        lArray7[5] = l9 = lArray7[5] ^ l13;
        SecT193Field.implCompactExt(lArray3);
    }

    public static void implMulwAcc(long[] lArray, long l3, long l4, long[] lArray2, int n3) {
        long l5;
        long l6;
        lArray[1] = l4;
        lArray[2] = l6 = l4 << 1;
        lArray[3] = l5 = l6 ^ l4;
        lArray[4] = l6 <<= 1;
        lArray[5] = l6 ^= l4;
        lArray[6] = l6 = l5 << 1;
        lArray[7] = l4 = l6 ^ l4;
        int n4 = (int)l3;
        l6 = 0L;
        long l7 = lArray[n4 & 7] ^ lArray[n4 >>> 3 & 7] << 3;
        int n5 = 36;
        do {
            long l8 = l6;
            int n6 = (int)(l3 >>> n5);
            l6 = lArray[n6 & 7] ^ lArray[n6 >>> 3 & 7] << 3 ^ lArray[n6 >>> 6 & 7] << 6 ^ lArray[n6 >>> 9 & 7] << 9 ^ lArray[n6 >>> 12 & 7] << 12;
            l7 ^= l6 << n5;
            l6 = l8 ^ l6 >>> -n5;
        } while ((n5 += -15) > 0);
        long[] lArray3 = lArray2;
        lArray3[n3] = lArray2[n3] ^ l7 & 0x1FFFFFFFFFFFFL;
        int n7 = n3 + 1;
        lArray2[n7] = l3 = lArray3[n7] ^ (l7 >>> 49 ^ l6 << 15);
    }

    public static void implSquare(long[] lArray, long[] lArray2) {
        long l3;
        Interleave.expand64To128(lArray, 0, 3, lArray2, 0);
        lArray2[6] = l3 = lArray[3] & 1L;
    }
}

