/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Interleave;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat256;
import java.math.BigInteger;

public class SecT233Field {
    private static final long M41 = 0x1FFFFFFFFFFL;
    private static final long M59 = 0x7FFFFFFFFFFFFFFL;

    public static void add(long[] lArray, long[] lArray2, long[] lArray3) {
        long l3;
        long l4;
        lArray3[0] = l4 = lArray[0] ^ lArray2[0];
        lArray3[1] = l4 = lArray[1] ^ lArray2[1];
        lArray3[2] = l4 = lArray[2] ^ lArray2[2];
        lArray3[3] = l3 = lArray[3] ^ lArray2[3];
    }

    public static void addExt(long[] lArray, long[] lArray2, long[] lArray3) {
        long l3;
        long l4;
        lArray3[0] = l4 = lArray[0] ^ lArray2[0];
        lArray3[1] = l4 = lArray[1] ^ lArray2[1];
        lArray3[2] = l4 = lArray[2] ^ lArray2[2];
        lArray3[3] = l4 = lArray[3] ^ lArray2[3];
        lArray3[4] = l4 = lArray[4] ^ lArray2[4];
        lArray3[5] = l4 = lArray[5] ^ lArray2[5];
        lArray3[6] = l4 = lArray[6] ^ lArray2[6];
        lArray3[7] = l3 = lArray[7] ^ lArray2[7];
    }

    public static void addOne(long[] lArray, long[] lArray2) {
        long l3;
        lArray2[0] = l3 = lArray[0] ^ 1L;
        lArray2[1] = l3 = lArray[1];
        lArray2[2] = l3 = lArray[2];
        lArray2[3] = l3 = lArray[3];
    }

    private static void addTo(long[] lArray, long[] lArray2) {
        long l3;
        long l4;
        long[] lArray3 = lArray2;
        lArray3[0] = l4 = lArray2[0] ^ lArray[0];
        lArray3[1] = l4 = lArray2[1] ^ lArray[1];
        lArray3[2] = l4 = lArray2[2] ^ lArray[2];
        lArray3[3] = l3 = lArray2[3] ^ lArray[3];
    }

    public static long[] fromBigInteger(BigInteger bigInteger) {
        return Nat.fromBigInteger64(233, bigInteger);
    }

    public static void halfTrace(long[] lArray, long[] lArray2) {
        long[] lArray3 = Nat256.createExt64();
        Nat256.copy64(lArray, lArray2);
        for (int i3 = 1; i3 < 233; i3 += 2) {
            SecT233Field.implSquare(lArray2, lArray3);
            SecT233Field.reduce(lArray3, lArray2);
            SecT233Field.implSquare(lArray2, lArray3);
            SecT233Field.reduce(lArray3, lArray2);
            SecT233Field.addTo(lArray, lArray2);
        }
    }

    public static void invert(long[] lArray, long[] lArray2) {
        if (!Nat256.isZero64(lArray)) {
            long[] lArray3;
            long[] lArray4 = Nat256.create64();
            long[] lArray5 = lArray3 = Nat256.create64();
            long[] lArray6 = lArray3;
            long[] lArray7 = lArray3;
            long[] lArray8 = lArray3;
            long[] lArray9 = lArray4;
            long[] lArray10 = lArray4;
            SecT233Field.square(lArray, lArray4);
            SecT233Field.multiply(lArray9, lArray, lArray4);
            SecT233Field.square(lArray10, lArray4);
            SecT233Field.multiply(lArray9, lArray, lArray4);
            SecT233Field.squareN(lArray10, 3, lArray3);
            SecT233Field.multiply(lArray7, lArray4, lArray3);
            SecT233Field.square(lArray8, lArray3);
            SecT233Field.multiply(lArray7, lArray, lArray3);
            SecT233Field.squareN(lArray8, 7, lArray4);
            SecT233Field.multiply(lArray4, lArray3, lArray4);
            SecT233Field.squareN(lArray4, 14, lArray3);
            SecT233Field.multiply(lArray5, lArray4, lArray3);
            SecT233Field.square(lArray6, lArray3);
            SecT233Field.multiply(lArray5, lArray, lArray3);
            SecT233Field.squareN(lArray6, 29, lArray4);
            SecT233Field.multiply(lArray4, lArray3, lArray4);
            SecT233Field.squareN(lArray4, 58, lArray3);
            SecT233Field.multiply(lArray3, lArray4, lArray3);
            SecT233Field.squareN(lArray3, 116, lArray4);
            SecT233Field.multiply(lArray4, lArray3, lArray4);
            SecT233Field.square(lArray4, lArray2);
            return;
        }
        throw new IllegalStateException();
    }

    public static void multiply(long[] lArray, long[] lArray2, long[] lArray3) {
        long[] lArray4 = Nat256.createExt64();
        SecT233Field.implMultiply(lArray, lArray2, lArray4);
        SecT233Field.reduce(lArray4, lArray3);
    }

    public static void multiplyAddToExt(long[] lArray, long[] lArray2, long[] lArray3) {
        long[] lArray4 = lArray;
        lArray = Nat256.createExt64();
        SecT233Field.implMultiply(lArray4, lArray2, lArray);
        SecT233Field.addExt(lArray3, lArray, lArray3);
    }

    public static void reduce(long[] lArray, long[] lArray2) {
        long l3;
        long l4 = lArray[0];
        long l5 = lArray[1];
        long l6 = lArray[2];
        long l7 = lArray[4];
        long l8 = lArray[5];
        long l9 = lArray[6];
        long l10 = lArray[7];
        long l11 = l6;
        l6 = l7 ^ (l10 >>> 41 ^ l10 << 33);
        l7 = l8 ^ l10 >>> 31;
        l8 = l11 ^ l9 << 23;
        long l12 = l7;
        long l13 = l5;
        l5 = l6 ^ l9 >>> 31;
        l6 = l13 ^ l7 << 23;
        l7 = l8 ^ (l7 >>> 41 ^ l7 << 33);
        l8 = lArray[3] ^ l10 << 23 ^ (l9 >>> 41 ^ l9 << 33) ^ l12 >>> 31;
        l4 ^= l5 << 23;
        long l14 = l6 ^ (l5 >>> 41 ^ l5 << 33);
        l5 = l7 ^ l5 >>> 31;
        l6 = l8 >>> 41;
        lArray2[0] = l3 = l4 ^ l6;
        lArray2[1] = l3 = l14 ^ l6 << 10;
        lArray2[2] = l5;
        lArray2[3] = l3 = l8 & 0x1FFFFFFFFFFL;
    }

    public static void reduce23(long[] lArray, int n3) {
        int n4 = n3 + 3;
        long l3 = lArray[n4];
        long[] lArray2 = lArray;
        long l4 = l3 >>> 41;
        lArray2[n3] = lArray[n3] ^ l4;
        int n5 = n3 + 1;
        lArray[n5] = l4 = lArray2[n5] ^ l4 << 10;
        lArray[n4] = l3 & 0x1FFFFFFFFFFL;
    }

    public static void sqrt(long[] lArray, long[] lArray2) {
        long l3;
        long l4 = Interleave.unshuffle(lArray[0]);
        long l5 = Interleave.unshuffle(lArray[1]);
        long l6 = l4 & 0xFFFFFFFFL | l5 << 32;
        long l7 = l4 >>> 32 | l5 & 0xFFFFFFFF00000000L;
        l5 = l7;
        long l8 = Interleave.unshuffle(lArray[2]);
        long l9 = Interleave.unshuffle(lArray[3]);
        long l10 = l8 & 0xFFFFFFFFL | l9 << 32;
        l9 = l8 >>> 32 | l9 & 0xFFFFFFFF00000000L;
        long l11 = l5;
        l5 = l9 >>> 27;
        l9 ^= l11 >>> 27 | l9 << 37;
        long l12 = l7 ^ l7 << 37;
        lArray = Nat256.createExt64();
        int n3 = 3;
        int[] nArray = new int[3];
        int[] nArray2 = nArray;
        nArray[0] = 32;
        nArray[1] = 117;
        nArray[2] = 191;
        for (int i3 = 0; i3 < n3; ++i3) {
            long l13;
            long l14;
            long l15;
            long[] lArray3 = lArray;
            int n4 = nArray2[i3];
            int n5 = n4 >>> 6;
            int n6 = n4 & 0x3F;
            lArray3[n5] = l15 = lArray[n5] ^ l12 << n6;
            int n7 = n5 + 1;
            int n8 = -n6;
            lArray3[n7] = l14 = lArray[n7] ^ (l9 << n6 | l12 >>> n8);
            n7 = n5 + 2;
            lArray3[n7] = l14 = lArray[n7] ^ (l5 << n6 | l9 >>> n8);
            lArray3[n5 += 3] = l13 = lArray[n5] ^ l5 >>> n8;
        }
        long[] lArray4 = lArray2;
        SecT233Field.reduce(lArray, lArray2);
        lArray4[0] = l3 = lArray2[0] ^ l6;
        lArray4[1] = l3 = lArray2[1] ^ l10;
    }

    public static void square(long[] lArray, long[] lArray2) {
        long[] lArray3 = Nat256.createExt64();
        SecT233Field.implSquare(lArray, lArray3);
        SecT233Field.reduce(lArray3, lArray2);
    }

    public static void squareAddToExt(long[] lArray, long[] lArray2) {
        long[] lArray3 = lArray;
        lArray = Nat256.createExt64();
        SecT233Field.implSquare(lArray3, lArray);
        SecT233Field.addExt(lArray2, lArray, lArray2);
    }

    public static void squareN(long[] lArray, int n3, long[] lArray2) {
        long[] lArray3 = Nat256.createExt64();
        SecT233Field.implSquare(lArray, lArray3);
        SecT233Field.reduce(lArray3, lArray2);
        while ((n3 += -1) > 0) {
            SecT233Field.implSquare(lArray2, lArray3);
            SecT233Field.reduce(lArray3, lArray2);
        }
    }

    public static int trace(long[] lArray) {
        return (int)(lArray[0] ^ lArray[2] >>> 31) & 1;
    }

    public static void implCompactExt(long[] lArray) {
        long l3 = lArray[0];
        long l4 = lArray[1];
        long l5 = lArray[2];
        long l6 = lArray[3];
        long l7 = lArray[4];
        long l8 = lArray[5];
        long l9 = lArray[6];
        long l10 = lArray[7];
        lArray[0] = l3 ^= l4 << 59;
        lArray[1] = l3 = l4 >>> 5 ^ l5 << 54;
        lArray[2] = l3 = l5 >>> 10 ^ l6 << 49;
        lArray[3] = l3 = l6 >>> 15 ^ l7 << 44;
        lArray[4] = l3 = l7 >>> 20 ^ l8 << 39;
        lArray[5] = l3 = l8 >>> 25 ^ l9 << 34;
        lArray[6] = l3 = l9 >>> 30 ^ l10 << 29;
        lArray[7] = l3 = l10 >>> 35;
    }

    public static void implExpand(long[] lArray, long[] lArray2) {
        long l3 = lArray[0];
        long l4 = lArray[1];
        long l5 = lArray[2];
        long l6 = l3;
        long l7 = lArray[3];
        lArray2[0] = l3 &= 0x7FFFFFFFFFFFFFFL;
        lArray2[1] = l3 = (l6 >>> 59 ^ l4 << 5) & 0x7FFFFFFFFFFFFFFL;
        lArray2[2] = l3 = (l4 >>> 54 ^ l5 << 10) & 0x7FFFFFFFFFFFFFFL;
        lArray2[3] = l7 = l5 >>> 49 ^ l7 << 15;
    }

    public static void implMultiply(long[] lArray, long[] lArray2, long[] lArray3) {
        long l3;
        long[] lArray4 = lArray2;
        long[] lArray5 = lArray;
        lArray = new long[4];
        lArray2 = new long[4];
        SecT233Field.implExpand(lArray5, lArray);
        SecT233Field.implExpand(lArray4, lArray2);
        long[] lArray6 = new long[8];
        long l4 = lArray[0];
        long l5 = lArray2[0];
        SecT233Field.implMulwAcc(lArray6, l4, l5, lArray3, 0);
        l4 = lArray[1];
        l5 = lArray2[1];
        SecT233Field.implMulwAcc(lArray6, l4, l5, lArray3, 1);
        l4 = lArray[2];
        l5 = lArray2[2];
        SecT233Field.implMulwAcc(lArray6, l4, l5, lArray3, 2);
        l4 = lArray[3];
        l5 = lArray2[3];
        SecT233Field.implMulwAcc(lArray6, l4, l5, lArray3, 3);
        for (int i3 = 5; i3 > 0; --i3) {
            lArray3[i3] = lArray3[i3] ^ lArray3[i3 - 1];
        }
        long l6 = lArray[0] ^ lArray[1];
        l5 = lArray2[0] ^ lArray2[1];
        SecT233Field.implMulwAcc(lArray6, l6, l5, lArray3, 1);
        l6 = lArray[2] ^ lArray[3];
        l5 = lArray2[2] ^ lArray2[3];
        SecT233Field.implMulwAcc(lArray6, l6, l5, lArray3, 3);
        for (int i4 = 7; i4 > 1; --i4) {
            lArray3[i4] = lArray3[i4] ^ lArray3[i4 - 2];
        }
        long[] lArray7 = lArray3;
        long l7 = lArray[0] ^ lArray[2];
        l5 = lArray[1] ^ lArray[3];
        long l8 = lArray2[0] ^ lArray2[2];
        long l9 = lArray2[1] ^ lArray2[3];
        long l10 = l7 ^ l5;
        long l11 = l8 ^ l9;
        SecT233Field.implMulwAcc(lArray6, l10, l11, lArray3, 3);
        lArray3 = new long[3];
        SecT233Field.implMulwAcc(lArray6, l7, l8, lArray3, 0);
        SecT233Field.implMulwAcc(lArray6, l5, l9, lArray3, 1);
        l9 = lArray3[0];
        long l12 = lArray3[1];
        long l13 = lArray3[2];
        lArray7[2] = l3 = lArray7[2] ^ l9;
        lArray7[3] = l9 = lArray7[3] ^ (l9 ^ l12);
        lArray7[4] = l9 = lArray7[4] ^ (l13 ^ l12);
        lArray7[5] = l9 = lArray7[5] ^ l13;
        SecT233Field.implCompactExt(lArray3);
    }

    public static void implMulwAcc(long[] lArray, long l3, long l4, long[] lArray2, int n3) {
        long l5;
        long l6;
        lArray[1] = l4;
        lArray[2] = l6 = l4 << 1;
        lArray[3] = l5 = l6 ^ l4;
        lArray[4] = l6 <<= 1;
        lArray[5] = l6 ^= l4;
        lArray[6] = l6 = l5 << 1;
        lArray[7] = l4 = l6 ^ l4;
        int n4 = (int)l3;
        l6 = 0L;
        long l7 = lArray[n4 & 7] ^ lArray[n4 >>> 3 & 7] << 3;
        int n5 = 54;
        do {
            long l8 = l6;
            int n6 = (int)(l3 >>> n5);
            l6 = lArray[n6 & 7] ^ lArray[n6 >>> 3 & 7] << 3;
            l7 ^= l6 << n5;
            l6 = l8 ^ l6 >>> -n5;
        } while ((n5 += -6) > 0);
        long[] lArray3 = lArray2;
        lArray3[n3] = lArray2[n3] ^ l7 & 0x7FFFFFFFFFFFFFFL;
        int n7 = n3 + 1;
        lArray2[n7] = l3 = lArray3[n7] ^ (l7 >>> 59 ^ l6 << 5);
    }

    public static void implSquare(long[] lArray, long[] lArray2) {
        Interleave.expand64To128(lArray, 0, 4, lArray2, 0);
    }
}

