/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecT233Field;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat256;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class SecT233FieldElement
extends ECFieldElement.AbstractF2m {
    public long[] x;

    public SecT233FieldElement(BigInteger bigInteger) {
        if (bigInteger != null && bigInteger.signum() >= 0 && bigInteger.bitLength() <= 233) {
            this.x = SecT233Field.fromBigInteger(bigInteger);
            return;
        }
        throw new IllegalArgumentException("x value invalid for SecT233FieldElement");
    }

    public SecT233FieldElement() {
        this.x = Nat256.create64();
    }

    public SecT233FieldElement(long[] lArray) {
        this.x = lArray;
    }

    @Override
    public boolean isOne() {
        return Nat256.isOne64(this.x);
    }

    @Override
    public boolean isZero() {
        return Nat256.isZero64(this.x);
    }

    @Override
    public boolean testBitZero() {
        return (this.x[0] & 1L) != 0L;
    }

    @Override
    public BigInteger toBigInteger() {
        return Nat256.toBigInteger64(this.x);
    }

    @Override
    public String getFieldName() {
        return "SecT233Field";
    }

    @Override
    public int getFieldSize() {
        return 233;
    }

    @Override
    public ECFieldElement add(ECFieldElement eCFieldElement) {
        SecT233FieldElement secT233FieldElement = object;
        Object object = Nat256.create64();
        SecT233Field.add(secT233FieldElement.x, ((SecT233FieldElement)eCFieldElement).x, (long[])object);
        return new SecT233FieldElement((long[])object);
    }

    @Override
    public ECFieldElement addOne() {
        SecT233FieldElement secT233FieldElement = object;
        Object object = Nat256.create64();
        SecT233Field.addOne(secT233FieldElement.x, (long[])object);
        return new SecT233FieldElement((long[])object);
    }

    @Override
    public ECFieldElement subtract(ECFieldElement eCFieldElement) {
        return this.add(eCFieldElement);
    }

    @Override
    public ECFieldElement multiply(ECFieldElement eCFieldElement) {
        SecT233FieldElement secT233FieldElement = object;
        Object object = Nat256.create64();
        SecT233Field.multiply(secT233FieldElement.x, ((SecT233FieldElement)eCFieldElement).x, (long[])object);
        return new SecT233FieldElement((long[])object);
    }

    @Override
    public ECFieldElement multiplyMinusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement eCFieldElement3) {
        return this.multiplyPlusProduct(eCFieldElement, eCFieldElement2, eCFieldElement3);
    }

    @Override
    public ECFieldElement multiplyPlusProduct(ECFieldElement object, ECFieldElement object2, ECFieldElement object3) {
        Object object4 = ((SecT233FieldElement)object4).x;
        object = ((SecT233FieldElement)object).x;
        object2 = ((SecT233FieldElement)object2).x;
        object3 = ((SecT233FieldElement)object3).x;
        long[] lArray = Nat256.createExt64();
        SecT233Field.multiplyAddToExt((long[])object4, (long[])object, lArray);
        SecT233Field.multiplyAddToExt((long[])object2, (long[])object3, lArray);
        long[] lArray2 = Nat256.create64();
        object4 = lArray2;
        SecT233Field.reduce(lArray, lArray2);
        return new SecT233FieldElement((long[])object4);
    }

    @Override
    public ECFieldElement divide(ECFieldElement eCFieldElement) {
        return this.multiply(eCFieldElement.invert());
    }

    @Override
    public ECFieldElement negate() {
        return this;
    }

    @Override
    public ECFieldElement square() {
        SecT233FieldElement secT233FieldElement = object;
        Object object = Nat256.create64();
        SecT233Field.square(secT233FieldElement.x, (long[])object);
        return new SecT233FieldElement((long[])object);
    }

    @Override
    public ECFieldElement squareMinusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return this.squarePlusProduct(eCFieldElement, eCFieldElement2);
    }

    @Override
    public ECFieldElement squarePlusProduct(ECFieldElement object, ECFieldElement object2) {
        Object object3 = ((SecT233FieldElement)object3).x;
        object = ((SecT233FieldElement)object).x;
        object2 = ((SecT233FieldElement)object2).x;
        long[] lArray = Nat256.createExt64();
        SecT233Field.squareAddToExt((long[])object3, lArray);
        SecT233Field.multiplyAddToExt((long[])object, (long[])object2, lArray);
        long[] lArray2 = Nat256.create64();
        object3 = lArray2;
        SecT233Field.reduce(lArray, lArray2);
        return new SecT233FieldElement((long[])object3);
    }

    @Override
    public ECFieldElement squarePow(int n3) {
        if (n3 < 1) {
            return object;
        }
        SecT233FieldElement secT233FieldElement = object;
        Object object = Nat256.create64();
        SecT233Field.squareN(secT233FieldElement.x, n3, (long[])object);
        return new SecT233FieldElement((long[])object);
    }

    @Override
    public ECFieldElement halfTrace() {
        SecT233FieldElement secT233FieldElement = object;
        Object object = Nat256.create64();
        SecT233Field.halfTrace(secT233FieldElement.x, (long[])object);
        return new SecT233FieldElement((long[])object);
    }

    @Override
    public boolean hasFastTrace() {
        return true;
    }

    @Override
    public int trace() {
        return SecT233Field.trace(this.x);
    }

    @Override
    public ECFieldElement invert() {
        SecT233FieldElement secT233FieldElement = object;
        Object object = Nat256.create64();
        SecT233Field.invert(secT233FieldElement.x, (long[])object);
        return new SecT233FieldElement((long[])object);
    }

    @Override
    public ECFieldElement sqrt() {
        SecT233FieldElement secT233FieldElement = object;
        Object object = Nat256.create64();
        SecT233Field.sqrt(secT233FieldElement.x, (long[])object);
        return new SecT233FieldElement((long[])object);
    }

    public int getRepresentation() {
        return 2;
    }

    public int getM() {
        return 233;
    }

    public int getK1() {
        return 74;
    }

    public int getK2() {
        return 0;
    }

    public int getK3() {
        return 0;
    }

    public boolean equals(Object object) {
        if (object == secT233FieldElement2) {
            return true;
        }
        if (!(object instanceof SecT233FieldElement)) {
            return false;
        }
        SecT233FieldElement secT233FieldElement = secT233FieldElement2;
        SecT233FieldElement secT233FieldElement2 = (SecT233FieldElement)object;
        return Nat256.eq64(secT233FieldElement.x, secT233FieldElement2.x);
    }

    public int hashCode() {
        return Arrays.hashCode(this.x, 0, 4) ^ 0x238DDA;
    }
}

