/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.AbstractECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECConstants;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECMultiplier;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.WTauNafMultiplier;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecT233FieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecT233K1Point;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat256;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecT233K1Curve
extends ECCurve.AbstractF2m {
    private static final int SECT233K1_DEFAULT_COORDS = 6;
    private static final ECFieldElement[] SECT233K1_AFFINE_ZS;
    public SecT233K1Point infinity;

    public SecT233K1Curve() {
        SecT233K1Curve secT233K1Curve = this;
        super(233, 74, 0, 0);
        secT233K1Curve.infinity = new SecT233K1Point(this, null, null);
        secT233K1Curve.a = secT233K1Curve.fromBigInteger(BigInteger.valueOf(0L));
        secT233K1Curve.b = secT233K1Curve.fromBigInteger(BigInteger.valueOf(1L));
        secT233K1Curve.order = new BigInteger(1, Hex.decodeStrict("8000000000000000000000000000069D5BB915BCD46EFB1AD5F173ABDF"));
        secT233K1Curve.cofactor = BigInteger.valueOf(4L);
        secT233K1Curve.coord = 6;
    }

    static {
        SecT233FieldElement secT233FieldElement;
        ECFieldElement[] eCFieldElementArray = new ECFieldElement[1];
        SecT233FieldElement secT233FieldElement2 = secT233FieldElement;
        secT233FieldElement = new SecT233FieldElement(ECConstants.ONE);
        eCFieldElementArray[0] = secT233FieldElement2;
        SECT233K1_AFFINE_ZS = eCFieldElementArray;
    }

    @Override
    public ECCurve cloneCurve() {
        return new SecT233K1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int n3) {
        return n3 == 6;
    }

    @Override
    public ECMultiplier createDefaultMultiplier() {
        return new WTauNafMultiplier();
    }

    @Override
    public int getFieldSize() {
        return 233;
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecT233FieldElement(bigInteger);
    }

    @Override
    public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return new SecT233K1Point(this, eCFieldElement, eCFieldElement2);
    }

    @Override
    public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        return new SecT233K1Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public boolean isKoblitz() {
        return true;
    }

    public int getM() {
        return 233;
    }

    public boolean isTrinomial() {
        return true;
    }

    public int getK1() {
        return 74;
    }

    public int getK2() {
        return 0;
    }

    public int getK3() {
        return 0;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n3, final int n4) {
        final long[] lArray = new long[n4 * 4 * 2];
        int n5 = 0;
        for (int i3 = 0; i3 < n4; ++i3) {
            ECPoint eCPoint = eCPointArray[n3 + i3];
            Nat256.copy64(((SecT233FieldElement)eCPoint.getRawXCoord()).x, 0, lArray, n5);
            Nat256.copy64(((SecT233FieldElement)eCPoint.getRawYCoord()).x, 0, lArray, n5 += 4);
            n5 += 4;
        }
        return new AbstractECLookupTable(){

            private ECPoint createPoint(long[] lArray3, long[] lArray2) {
                SecT233FieldElement secT233FieldElement;
                SecT233FieldElement secT233FieldElement2 = secT233FieldElement;
                secT233FieldElement = new SecT233FieldElement(lArray2);
                return secT233FieldElement2.SecT233K1Curve.this.createRawPoint(new SecT233FieldElement(lArray3), secT233FieldElement2, SECT233K1_AFFINE_ZS);
            }

            @Override
            public int getSize() {
                return n4;
            }

            @Override
            public ECPoint lookup(int n3) {
                long[] lArray4 = Nat256.create64();
                long[] lArray2 = Nat256.create64();
                int n42 = 0;
                for (int i3 = 0; i3 < n4; ++i3) {
                    long l3 = (i3 ^ n3) - 1 >> 31;
                    for (int i4 = 0; i4 < 4; ++i4) {
                        long[] lArray3 = lArray;
                        lArray4[i4] = lArray4[i4] ^ lArray[n42 + i4] & l3;
                        lArray2[i4] = lArray2[i4] ^ lArray3[n42 + 4 + i4] & l3;
                    }
                    n42 += 8;
                }
                return this.createPoint(lArray4, lArray2);
            }

            @Override
            public ECPoint lookupVar(int n3) {
                long[] lArray4 = Nat256.create64();
                long[] lArray2 = Nat256.create64();
                int n42 = n3 * 4 * 2;
                for (int i3 = 0; i3 < 4; ++i3) {
                    long[] lArray3 = lArray;
                    lArray4[i3] = lArray3[n42 + i3];
                    lArray2[i3] = lArray[n42 + 4 + i3];
                }
                return this.createPoint(lArray4, lArray2);
            }
        };
    }
}

