/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.AbstractECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECConstants;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecT233FieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecT233R1Point;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat256;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecT233R1Curve
extends ECCurve.AbstractF2m {
    private static final int SECT233R1_DEFAULT_COORDS = 6;
    private static final ECFieldElement[] SECT233R1_AFFINE_ZS;
    public SecT233R1Point infinity;

    public SecT233R1Curve() {
        SecT233R1Curve secT233R1Curve = this;
        super(233, 74, 0, 0);
        secT233R1Curve.infinity = new SecT233R1Point(this, null, null);
        secT233R1Curve.a = secT233R1Curve.fromBigInteger(BigInteger.valueOf(1L));
        secT233R1Curve.b = secT233R1Curve.fromBigInteger(new BigInteger(1, Hex.decodeStrict("0066647EDE6C332C7F8C0923BB58213B333B20E9CE4281FE115F7D8F90AD")));
        secT233R1Curve.order = new BigInteger(1, Hex.decodeStrict("01000000000000000000000000000013E974E72F8A6922031D2603CFE0D7"));
        secT233R1Curve.cofactor = BigInteger.valueOf(2L);
        secT233R1Curve.coord = 6;
    }

    static {
        SecT233FieldElement secT233FieldElement;
        ECFieldElement[] eCFieldElementArray = new ECFieldElement[1];
        SecT233FieldElement secT233FieldElement2 = secT233FieldElement;
        secT233FieldElement = new SecT233FieldElement(ECConstants.ONE);
        eCFieldElementArray[0] = secT233FieldElement2;
        SECT233R1_AFFINE_ZS = eCFieldElementArray;
    }

    @Override
    public ECCurve cloneCurve() {
        return new SecT233R1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int n3) {
        return n3 == 6;
    }

    @Override
    public int getFieldSize() {
        return 233;
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecT233FieldElement(bigInteger);
    }

    @Override
    public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return new SecT233R1Point(this, eCFieldElement, eCFieldElement2);
    }

    @Override
    public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        return new SecT233R1Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public boolean isKoblitz() {
        return false;
    }

    public int getM() {
        return 233;
    }

    public boolean isTrinomial() {
        return true;
    }

    public int getK1() {
        return 74;
    }

    public int getK2() {
        return 0;
    }

    public int getK3() {
        return 0;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n3, final int n4) {
        final long[] lArray = new long[n4 * 4 * 2];
        int n5 = 0;
        for (int i3 = 0; i3 < n4; ++i3) {
            ECPoint eCPoint = eCPointArray[n3 + i3];
            Nat256.copy64(((SecT233FieldElement)eCPoint.getRawXCoord()).x, 0, lArray, n5);
            Nat256.copy64(((SecT233FieldElement)eCPoint.getRawYCoord()).x, 0, lArray, n5 += 4);
            n5 += 4;
        }
        return new AbstractECLookupTable(){

            private ECPoint createPoint(long[] lArray3, long[] lArray2) {
                SecT233FieldElement secT233FieldElement;
                SecT233FieldElement secT233FieldElement2 = secT233FieldElement;
                secT233FieldElement = new SecT233FieldElement(lArray2);
                return secT233FieldElement2.SecT233R1Curve.this.createRawPoint(new SecT233FieldElement(lArray3), secT233FieldElement2, SECT233R1_AFFINE_ZS);
            }

            @Override
            public int getSize() {
                return n4;
            }

            @Override
            public ECPoint lookup(int n3) {
                long[] lArray4 = Nat256.create64();
                long[] lArray2 = Nat256.create64();
                int n42 = 0;
                for (int i3 = 0; i3 < n4; ++i3) {
                    long l3 = (i3 ^ n3) - 1 >> 31;
                    for (int i4 = 0; i4 < 4; ++i4) {
                        long[] lArray3 = lArray;
                        lArray4[i4] = lArray4[i4] ^ lArray[n42 + i4] & l3;
                        lArray2[i4] = lArray2[i4] ^ lArray3[n42 + 4 + i4] & l3;
                    }
                    n42 += 8;
                }
                return this.createPoint(lArray4, lArray2);
            }

            @Override
            public ECPoint lookupVar(int n3) {
                long[] lArray4 = Nat256.create64();
                long[] lArray2 = Nat256.create64();
                int n42 = n3 * 4 * 2;
                for (int i3 = 0; i3 < 4; ++i3) {
                    long[] lArray3 = lArray;
                    lArray4[i3] = lArray3[n42 + i3];
                    lArray2[i3] = lArray[n42 + 4 + i3];
                }
                return this.createPoint(lArray4, lArray2);
            }
        };
    }
}

