/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Interleave;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat448;
import java.math.BigInteger;

public class SecT409Field {
    private static final long M25 = 0x1FFFFFFL;
    private static final long M59 = 0x7FFFFFFFFFFFFFFL;

    public static void add(long[] lArray, long[] lArray2, long[] lArray3) {
        long l3;
        long l4;
        lArray3[0] = l4 = lArray[0] ^ lArray2[0];
        lArray3[1] = l4 = lArray[1] ^ lArray2[1];
        lArray3[2] = l4 = lArray[2] ^ lArray2[2];
        lArray3[3] = l4 = lArray[3] ^ lArray2[3];
        lArray3[4] = l4 = lArray[4] ^ lArray2[4];
        lArray3[5] = l4 = lArray[5] ^ lArray2[5];
        lArray3[6] = l3 = lArray[6] ^ lArray2[6];
    }

    public static void addExt(long[] lArray, long[] lArray2, long[] lArray3) {
        for (int i3 = 0; i3 < 13; ++i3) {
            lArray3[i3] = lArray[i3] ^ lArray2[i3];
        }
    }

    public static void addOne(long[] lArray, long[] lArray2) {
        long l3;
        lArray2[0] = l3 = lArray[0] ^ 1L;
        lArray2[1] = l3 = lArray[1];
        lArray2[2] = l3 = lArray[2];
        lArray2[3] = l3 = lArray[3];
        lArray2[4] = l3 = lArray[4];
        lArray2[5] = l3 = lArray[5];
        lArray2[6] = l3 = lArray[6];
    }

    private static void addTo(long[] lArray, long[] lArray2) {
        long l3;
        long l4;
        long[] lArray3 = lArray2;
        lArray3[0] = l4 = lArray2[0] ^ lArray[0];
        lArray3[1] = l4 = lArray2[1] ^ lArray[1];
        lArray3[2] = l4 = lArray2[2] ^ lArray[2];
        lArray3[3] = l4 = lArray2[3] ^ lArray[3];
        lArray3[4] = l4 = lArray2[4] ^ lArray[4];
        lArray3[5] = l4 = lArray2[5] ^ lArray[5];
        lArray3[6] = l3 = lArray2[6] ^ lArray[6];
    }

    public static long[] fromBigInteger(BigInteger bigInteger) {
        return Nat.fromBigInteger64(409, bigInteger);
    }

    public static void halfTrace(long[] lArray, long[] lArray2) {
        long[] lArray3 = Nat.create64(13);
        Nat448.copy64(lArray, lArray2);
        for (int i3 = 1; i3 < 409; i3 += 2) {
            SecT409Field.implSquare(lArray2, lArray3);
            SecT409Field.reduce(lArray3, lArray2);
            SecT409Field.implSquare(lArray2, lArray3);
            SecT409Field.reduce(lArray3, lArray2);
            SecT409Field.addTo(lArray, lArray2);
        }
    }

    public static void invert(long[] lArray, long[] lArray2) {
        if (!Nat448.isZero64(lArray)) {
            long[] lArray3 = Nat448.create64();
            long[] lArray4 = Nat448.create64();
            long[] lArray5 = Nat448.create64();
            long[] lArray6 = lArray3;
            SecT409Field.square(lArray, lArray3);
            SecT409Field.squareN(lArray3, 1, lArray4);
            SecT409Field.multiply(lArray3, lArray4, lArray3);
            SecT409Field.squareN(lArray4, 1, lArray4);
            SecT409Field.multiply(lArray6, lArray4, lArray3);
            SecT409Field.squareN(lArray6, 3, lArray4);
            SecT409Field.multiply(lArray6, lArray4, lArray3);
            SecT409Field.squareN(lArray6, 6, lArray4);
            SecT409Field.multiply(lArray6, lArray4, lArray3);
            SecT409Field.squareN(lArray6, 12, lArray4);
            SecT409Field.multiply(lArray3, lArray4, lArray5);
            SecT409Field.squareN(lArray5, 24, lArray3);
            SecT409Field.squareN(lArray3, 24, lArray4);
            SecT409Field.multiply(lArray3, lArray4, lArray3);
            SecT409Field.squareN(lArray3, 48, lArray4);
            SecT409Field.multiply(lArray3, lArray4, lArray3);
            SecT409Field.squareN(lArray3, 96, lArray4);
            SecT409Field.multiply(lArray3, lArray4, lArray3);
            SecT409Field.squareN(lArray3, 192, lArray4);
            SecT409Field.multiply(lArray3, lArray4, lArray3);
            SecT409Field.multiply(lArray3, lArray5, lArray2);
            return;
        }
        throw new IllegalStateException();
    }

    public static void multiply(long[] lArray, long[] lArray2, long[] lArray3) {
        long[] lArray4 = Nat448.createExt64();
        SecT409Field.implMultiply(lArray, lArray2, lArray4);
        SecT409Field.reduce(lArray4, lArray3);
    }

    public static void multiplyAddToExt(long[] lArray, long[] lArray2, long[] lArray3) {
        long[] lArray4 = lArray;
        lArray = Nat448.createExt64();
        SecT409Field.implMultiply(lArray4, lArray2, lArray);
        SecT409Field.addExt(lArray3, lArray, lArray3);
    }

    public static void reduce(long[] lArray, long[] lArray2) {
        long l3;
        long l4 = lArray[0];
        long l5 = lArray[1];
        long l6 = lArray[2];
        long l7 = lArray[3];
        long l8 = lArray[4];
        long l9 = lArray[5];
        long l10 = lArray[7];
        long l11 = lArray[12];
        l9 ^= l11 << 39;
        long l12 = lArray[6] ^ (l11 >>> 25 ^ l11 << 62);
        l10 ^= l11 >>> 2;
        l11 = lArray[11];
        l8 ^= l11 << 39;
        l9 ^= l11 >>> 25 ^ l11 << 62;
        l11 = l12 ^ l11 >>> 2;
        long[] lArray3 = lArray2;
        long l13 = l5;
        l5 = lArray[10];
        l7 ^= l5 << 39;
        long l14 = l8 ^ (l5 >>> 25 ^ l5 << 62);
        l5 = l9 ^ l5 >>> 2;
        l8 = lArray[9];
        l6 ^= l8 << 39;
        l7 ^= l8 >>> 25 ^ l8 << 62;
        l8 = l14 ^ l8 >>> 2;
        long l15 = lArray[8];
        l9 = l15;
        long l16 = l4;
        l4 = l6 ^ (l9 >>> 25 ^ l9 << 62);
        l6 = l7 ^ l9 >>> 2;
        l7 = l16 ^ l10 << 39;
        l9 = l11 >>> 25;
        lArray2[0] = l3 = l7 ^ l9;
        lArray3[1] = l3 = l13 ^ l15 << 39 ^ (l10 >>> 25 ^ l10 << 62) ^ l9 << 23;
        lArray3[2] = l4 ^= l10 >>> 2;
        lArray3[3] = l6;
        lArray3[4] = l8;
        lArray2[5] = l5;
        lArray2[6] = l3 = l11 & 0x1FFFFFFL;
    }

    public static void reduce39(long[] lArray, int n3) {
        int n4 = n3 + 6;
        long l3 = lArray[n4];
        long[] lArray2 = lArray;
        long l4 = l3 >>> 25;
        lArray2[n3] = lArray[n3] ^ l4;
        int n5 = n3 + 1;
        lArray[n5] = l4 = lArray2[n5] ^ l4 << 23;
        lArray[n4] = l3 & 0x1FFFFFFL;
    }

    public static void sqrt(long[] lArray, long[] lArray2) {
        long l3;
        long l4 = Interleave.unshuffle(lArray[0]);
        long l5 = Interleave.unshuffle(lArray[1]);
        long l6 = l4 & 0xFFFFFFFFL | l5 << 32;
        l5 = l4 >>> 32 | l5 & 0xFFFFFFFF00000000L;
        long l7 = Interleave.unshuffle(lArray[2]);
        long l8 = Interleave.unshuffle(lArray[3]);
        long l9 = l7 & 0xFFFFFFFFL | l8 << 32;
        l8 = l7 >>> 32 | l8 & 0xFFFFFFFF00000000L;
        long l10 = Interleave.unshuffle(lArray[4]);
        long l11 = Interleave.unshuffle(lArray[5]);
        long l12 = l10 & 0xFFFFFFFFL | l11 << 32;
        l11 = l10 >>> 32 | l11 & 0xFFFFFFFF00000000L;
        long l13 = Interleave.unshuffle(lArray[6]);
        long l14 = l13 & 0xFFFFFFFFL;
        long l15 = l13 >>> 32;
        lArray2[0] = l3 = l6 ^ l5 << 44;
        lArray2[1] = l3 = l9 ^ l8 << 44 ^ l5 >>> 20;
        lArray2[2] = l3 = l12 ^ l11 << 44 ^ l8 >>> 20;
        lArray2[3] = l3 = l14 ^ l15 << 44 ^ l11 >>> 20 ^ l5 << 13;
        lArray2[4] = l3 = l15 >>> 20 ^ l8 << 13 ^ l5 >>> 51;
        lArray2[5] = l3 = l11 << 13 ^ l8 >>> 51;
        lArray2[6] = l3 = l15 << 13 ^ l11 >>> 51;
    }

    public static void square(long[] lArray, long[] lArray2) {
        long[] lArray3 = Nat.create64(13);
        SecT409Field.implSquare(lArray, lArray3);
        SecT409Field.reduce(lArray3, lArray2);
    }

    public static void squareAddToExt(long[] lArray, long[] lArray2) {
        long[] lArray3 = lArray;
        lArray = Nat.create64(13);
        SecT409Field.implSquare(lArray3, lArray);
        SecT409Field.addExt(lArray2, lArray, lArray2);
    }

    public static void squareN(long[] lArray, int n3, long[] lArray2) {
        long[] lArray3 = Nat.create64(13);
        SecT409Field.implSquare(lArray, lArray3);
        SecT409Field.reduce(lArray3, lArray2);
        while ((n3 += -1) > 0) {
            SecT409Field.implSquare(lArray2, lArray3);
            SecT409Field.reduce(lArray3, lArray2);
        }
    }

    public static int trace(long[] lArray) {
        return (int)lArray[0] & 1;
    }

    public static void implCompactExt(long[] lArray) {
        long l3 = lArray[0];
        long l4 = lArray[1];
        long l5 = lArray[2];
        long l6 = lArray[3];
        long l7 = lArray[4];
        long l8 = lArray[5];
        long l9 = lArray[6];
        long l10 = lArray[7];
        long l11 = lArray[8];
        long l12 = lArray[9];
        long l13 = lArray[10];
        long l14 = lArray[11];
        long l15 = lArray[12];
        long l16 = lArray[13];
        lArray[0] = l3 ^= l4 << 59;
        lArray[1] = l3 = l4 >>> 5 ^ l5 << 54;
        lArray[2] = l3 = l5 >>> 10 ^ l6 << 49;
        lArray[3] = l3 = l6 >>> 15 ^ l7 << 44;
        lArray[4] = l3 = l7 >>> 20 ^ l8 << 39;
        lArray[5] = l3 = l8 >>> 25 ^ l9 << 34;
        lArray[6] = l3 = l9 >>> 30 ^ l10 << 29;
        lArray[7] = l3 = l10 >>> 35 ^ l11 << 24;
        lArray[8] = l3 = l11 >>> 40 ^ l12 << 19;
        lArray[9] = l3 = l12 >>> 45 ^ l13 << 14;
        lArray[10] = l3 = l13 >>> 50 ^ l14 << 9;
        lArray[11] = l3 = l14 >>> 55 ^ l15 << 4 ^ l16 << 63;
        lArray[12] = l3 = l16 >>> 1;
    }

    public static void implExpand(long[] lArray, long[] lArray2) {
        long l3 = lArray[0];
        long l4 = lArray[1];
        long l5 = lArray[2];
        long l6 = lArray[3];
        long l7 = lArray[4];
        long l8 = lArray[5];
        long l9 = l3;
        long l10 = lArray[6];
        lArray2[0] = l3 &= 0x7FFFFFFFFFFFFFFL;
        lArray2[1] = l3 = (l9 >>> 59 ^ l4 << 5) & 0x7FFFFFFFFFFFFFFL;
        lArray2[2] = l3 = (l4 >>> 54 ^ l5 << 10) & 0x7FFFFFFFFFFFFFFL;
        lArray2[3] = l3 = (l5 >>> 49 ^ l6 << 15) & 0x7FFFFFFFFFFFFFFL;
        lArray2[4] = l3 = (l6 >>> 44 ^ l7 << 20) & 0x7FFFFFFFFFFFFFFL;
        lArray2[5] = l3 = (l7 >>> 39 ^ l8 << 25) & 0x7FFFFFFFFFFFFFFL;
        lArray2[6] = l10 = l8 >>> 34 ^ l10 << 30;
    }

    public static void implMultiply(long[] lArray, long[] lArray2, long[] lArray3) {
        long l3;
        long l4;
        long[] lArray4 = lArray2;
        long[] lArray5 = lArray;
        lArray = new long[7];
        lArray2 = new long[7];
        SecT409Field.implExpand(lArray5, lArray);
        SecT409Field.implExpand(lArray4, lArray2);
        long[] lArray6 = new long[8];
        for (int i3 = 0; i3 < 7; ++i3) {
            l4 = lArray[i3];
            l3 = lArray2[i3];
            int n3 = i3 << 1;
            SecT409Field.implMulwAcc(lArray6, l4, l3, lArray3, n3);
        }
        long l5 = lArray3[0];
        l4 = lArray3[1];
        long l6 = l5 ^ lArray3[2];
        l3 = l6;
        long l7 = l4;
        lArray3[1] = l4 = l3 ^ l4;
        l3 = l7 ^ lArray3[3];
        long l8 = l6 ^ lArray3[4];
        long l9 = l8;
        long l10 = l3;
        lArray3[2] = l3 = l9 ^ l3;
        l9 = l10 ^ lArray3[5];
        long l11 = l8 ^ lArray3[6];
        long l12 = l11;
        long l13 = l9;
        lArray3[3] = l9 = l12 ^ l9;
        l12 = l13 ^ lArray3[7];
        long l14 = l11 ^ lArray3[8];
        long l15 = l14;
        long l16 = l12;
        lArray3[4] = l12 = l15 ^ l12;
        l15 = l16 ^ lArray3[9];
        long l17 = l14 ^ lArray3[10];
        long l18 = l17;
        long l19 = l15;
        lArray3[5] = l15 = l18 ^ l15;
        l18 = l19 ^ lArray3[11];
        long l20 = l17 ^ lArray3[12];
        long l21 = l20 ^ l18;
        long l22 = l4;
        long l23 = l5;
        lArray3[6] = l21;
        l5 = l20 ^ (l18 ^ lArray3[13]);
        lArray3[7] = l4 = l23 ^ l5;
        lArray3[8] = l4 = l22 ^ l5;
        lArray3[9] = l4 = l3 ^ l5;
        lArray3[10] = l4 = l9 ^ l5;
        lArray3[11] = l4 = l12 ^ l5;
        lArray3[12] = l4 = l15 ^ l5;
        lArray3[13] = l5 = l21 ^ l5;
        l5 = lArray[0] ^ lArray[1];
        l4 = lArray2[0] ^ lArray2[1];
        SecT409Field.implMulwAcc(lArray6, l5, l4, lArray3, 1);
        l5 = lArray[0] ^ lArray[2];
        l4 = lArray2[0] ^ lArray2[2];
        SecT409Field.implMulwAcc(lArray6, l5, l4, lArray3, 2);
        l5 = lArray[0] ^ lArray[3];
        l4 = lArray2[0] ^ lArray2[3];
        SecT409Field.implMulwAcc(lArray6, l5, l4, lArray3, 3);
        l5 = lArray[1] ^ lArray[2];
        l4 = lArray2[1] ^ lArray2[2];
        SecT409Field.implMulwAcc(lArray6, l5, l4, lArray3, 3);
        l5 = lArray[0] ^ lArray[4];
        l4 = lArray2[0] ^ lArray2[4];
        SecT409Field.implMulwAcc(lArray6, l5, l4, lArray3, 4);
        l5 = lArray[1] ^ lArray[3];
        l4 = lArray2[1] ^ lArray2[3];
        SecT409Field.implMulwAcc(lArray6, l5, l4, lArray3, 4);
        l5 = lArray[0] ^ lArray[5];
        l4 = lArray2[0] ^ lArray2[5];
        SecT409Field.implMulwAcc(lArray6, l5, l4, lArray3, 5);
        l5 = lArray[1] ^ lArray[4];
        l4 = lArray2[1] ^ lArray2[4];
        SecT409Field.implMulwAcc(lArray6, l5, l4, lArray3, 5);
        l5 = lArray[2] ^ lArray[3];
        l4 = lArray2[2] ^ lArray2[3];
        SecT409Field.implMulwAcc(lArray6, l5, l4, lArray3, 5);
        l5 = lArray[0] ^ lArray[6];
        l4 = lArray2[0] ^ lArray2[6];
        SecT409Field.implMulwAcc(lArray6, l5, l4, lArray3, 6);
        l5 = lArray[1] ^ lArray[5];
        l4 = lArray2[1] ^ lArray2[5];
        SecT409Field.implMulwAcc(lArray6, l5, l4, lArray3, 6);
        l5 = lArray[2] ^ lArray[4];
        l4 = lArray2[2] ^ lArray2[4];
        SecT409Field.implMulwAcc(lArray6, l5, l4, lArray3, 6);
        l5 = lArray[1] ^ lArray[6];
        l4 = lArray2[1] ^ lArray2[6];
        SecT409Field.implMulwAcc(lArray6, l5, l4, lArray3, 7);
        l5 = lArray[2] ^ lArray[5];
        l4 = lArray2[2] ^ lArray2[5];
        SecT409Field.implMulwAcc(lArray6, l5, l4, lArray3, 7);
        l5 = lArray[3] ^ lArray[4];
        l4 = lArray2[3] ^ lArray2[4];
        SecT409Field.implMulwAcc(lArray6, l5, l4, lArray3, 7);
        l5 = lArray[2] ^ lArray[6];
        l4 = lArray2[2] ^ lArray2[6];
        SecT409Field.implMulwAcc(lArray6, l5, l4, lArray3, 8);
        l5 = lArray[3] ^ lArray[5];
        l4 = lArray2[3] ^ lArray2[5];
        SecT409Field.implMulwAcc(lArray6, l5, l4, lArray3, 8);
        l5 = lArray[3] ^ lArray[6];
        l4 = lArray2[3] ^ lArray2[6];
        SecT409Field.implMulwAcc(lArray6, l5, l4, lArray3, 9);
        l5 = lArray[4] ^ lArray[5];
        l4 = lArray2[4] ^ lArray2[5];
        SecT409Field.implMulwAcc(lArray6, l5, l4, lArray3, 9);
        l5 = lArray[4] ^ lArray[6];
        l4 = lArray2[4] ^ lArray2[6];
        SecT409Field.implMulwAcc(lArray6, l5, l4, lArray3, 10);
        l5 = lArray[5] ^ lArray[6];
        long l24 = lArray2[5] ^ lArray2[6];
        SecT409Field.implMulwAcc(lArray6, l5, l24, lArray3, 11);
        SecT409Field.implCompactExt(lArray3);
    }

    public static void implMulwAcc(long[] lArray, long l3, long l4, long[] lArray2, int n3) {
        long l5;
        long l6;
        lArray[1] = l4;
        lArray[2] = l6 = l4 << 1;
        lArray[3] = l5 = l6 ^ l4;
        lArray[4] = l6 <<= 1;
        lArray[5] = l6 ^= l4;
        lArray[6] = l6 = l5 << 1;
        lArray[7] = l4 = l6 ^ l4;
        int n4 = (int)l3;
        l6 = 0L;
        long l7 = lArray[n4 & 7] ^ lArray[n4 >>> 3 & 7] << 3;
        int n5 = 54;
        do {
            long l8 = l6;
            int n6 = (int)(l3 >>> n5);
            l6 = lArray[n6 & 7] ^ lArray[n6 >>> 3 & 7] << 3;
            l7 ^= l6 << n5;
            l6 = l8 ^ l6 >>> -n5;
        } while ((n5 += -6) > 0);
        long[] lArray3 = lArray2;
        lArray3[n3] = lArray2[n3] ^ l7 & 0x7FFFFFFFFFFFFFFL;
        int n7 = n3 + 1;
        lArray2[n7] = l3 = lArray3[n7] ^ (l7 >>> 59 ^ l6 << 5);
    }

    public static void implSquare(long[] lArray, long[] lArray2) {
        long l3;
        Interleave.expand64To128(lArray, 0, 6, lArray2, 0);
        lArray2[12] = l3 = Interleave.expand32to64((int)lArray[6]);
    }
}

