/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecT409Field;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat448;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class SecT409FieldElement
extends ECFieldElement.AbstractF2m {
    public long[] x;

    public SecT409FieldElement(BigInteger bigInteger) {
        if (bigInteger != null && bigInteger.signum() >= 0 && bigInteger.bitLength() <= 409) {
            this.x = SecT409Field.fromBigInteger(bigInteger);
            return;
        }
        throw new IllegalArgumentException("x value invalid for SecT409FieldElement");
    }

    public SecT409FieldElement() {
        this.x = Nat448.create64();
    }

    public SecT409FieldElement(long[] lArray) {
        this.x = lArray;
    }

    @Override
    public boolean isOne() {
        return Nat448.isOne64(this.x);
    }

    @Override
    public boolean isZero() {
        return Nat448.isZero64(this.x);
    }

    @Override
    public boolean testBitZero() {
        return (this.x[0] & 1L) != 0L;
    }

    @Override
    public BigInteger toBigInteger() {
        return Nat448.toBigInteger64(this.x);
    }

    @Override
    public String getFieldName() {
        return "SecT409Field";
    }

    @Override
    public int getFieldSize() {
        return 409;
    }

    @Override
    public ECFieldElement add(ECFieldElement eCFieldElement) {
        SecT409FieldElement secT409FieldElement = object;
        Object object = Nat448.create64();
        SecT409Field.add(secT409FieldElement.x, ((SecT409FieldElement)eCFieldElement).x, (long[])object);
        return new SecT409FieldElement((long[])object);
    }

    @Override
    public ECFieldElement addOne() {
        SecT409FieldElement secT409FieldElement = object;
        Object object = Nat448.create64();
        SecT409Field.addOne(secT409FieldElement.x, (long[])object);
        return new SecT409FieldElement((long[])object);
    }

    @Override
    public ECFieldElement subtract(ECFieldElement eCFieldElement) {
        return this.add(eCFieldElement);
    }

    @Override
    public ECFieldElement multiply(ECFieldElement eCFieldElement) {
        SecT409FieldElement secT409FieldElement = object;
        Object object = Nat448.create64();
        SecT409Field.multiply(secT409FieldElement.x, ((SecT409FieldElement)eCFieldElement).x, (long[])object);
        return new SecT409FieldElement((long[])object);
    }

    @Override
    public ECFieldElement multiplyMinusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement eCFieldElement3) {
        return this.multiplyPlusProduct(eCFieldElement, eCFieldElement2, eCFieldElement3);
    }

    @Override
    public ECFieldElement multiplyPlusProduct(ECFieldElement object, ECFieldElement object2, ECFieldElement object3) {
        Object object4 = ((SecT409FieldElement)object4).x;
        object = ((SecT409FieldElement)object).x;
        object2 = ((SecT409FieldElement)object2).x;
        object3 = ((SecT409FieldElement)object3).x;
        long[] lArray = Nat.create64(13);
        SecT409Field.multiplyAddToExt((long[])object4, (long[])object, lArray);
        SecT409Field.multiplyAddToExt((long[])object2, (long[])object3, lArray);
        long[] lArray2 = Nat448.create64();
        object4 = lArray2;
        SecT409Field.reduce(lArray, lArray2);
        return new SecT409FieldElement((long[])object4);
    }

    @Override
    public ECFieldElement divide(ECFieldElement eCFieldElement) {
        return this.multiply(eCFieldElement.invert());
    }

    @Override
    public ECFieldElement negate() {
        return this;
    }

    @Override
    public ECFieldElement square() {
        SecT409FieldElement secT409FieldElement = object;
        Object object = Nat448.create64();
        SecT409Field.square(secT409FieldElement.x, (long[])object);
        return new SecT409FieldElement((long[])object);
    }

    @Override
    public ECFieldElement squareMinusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return this.squarePlusProduct(eCFieldElement, eCFieldElement2);
    }

    @Override
    public ECFieldElement squarePlusProduct(ECFieldElement object, ECFieldElement object2) {
        Object object3 = ((SecT409FieldElement)object3).x;
        object = ((SecT409FieldElement)object).x;
        object2 = ((SecT409FieldElement)object2).x;
        long[] lArray = Nat.create64(13);
        SecT409Field.squareAddToExt((long[])object3, lArray);
        SecT409Field.multiplyAddToExt((long[])object, (long[])object2, lArray);
        long[] lArray2 = Nat448.create64();
        object3 = lArray2;
        SecT409Field.reduce(lArray, lArray2);
        return new SecT409FieldElement((long[])object3);
    }

    @Override
    public ECFieldElement squarePow(int n3) {
        if (n3 < 1) {
            return object;
        }
        SecT409FieldElement secT409FieldElement = object;
        Object object = Nat448.create64();
        SecT409Field.squareN(secT409FieldElement.x, n3, (long[])object);
        return new SecT409FieldElement((long[])object);
    }

    @Override
    public ECFieldElement halfTrace() {
        SecT409FieldElement secT409FieldElement = object;
        Object object = Nat448.create64();
        SecT409Field.halfTrace(secT409FieldElement.x, (long[])object);
        return new SecT409FieldElement((long[])object);
    }

    @Override
    public boolean hasFastTrace() {
        return true;
    }

    @Override
    public int trace() {
        return SecT409Field.trace(this.x);
    }

    @Override
    public ECFieldElement invert() {
        SecT409FieldElement secT409FieldElement = object;
        Object object = Nat448.create64();
        SecT409Field.invert(secT409FieldElement.x, (long[])object);
        return new SecT409FieldElement((long[])object);
    }

    @Override
    public ECFieldElement sqrt() {
        SecT409FieldElement secT409FieldElement = object;
        Object object = Nat448.create64();
        SecT409Field.sqrt(secT409FieldElement.x, (long[])object);
        return new SecT409FieldElement((long[])object);
    }

    public int getRepresentation() {
        return 2;
    }

    public int getM() {
        return 409;
    }

    public int getK1() {
        return 87;
    }

    public int getK2() {
        return 0;
    }

    public int getK3() {
        return 0;
    }

    public boolean equals(Object object) {
        if (object == secT409FieldElement2) {
            return true;
        }
        if (!(object instanceof SecT409FieldElement)) {
            return false;
        }
        SecT409FieldElement secT409FieldElement = secT409FieldElement2;
        SecT409FieldElement secT409FieldElement2 = (SecT409FieldElement)object;
        return Nat448.eq64(secT409FieldElement.x, secT409FieldElement2.x);
    }

    public int hashCode() {
        return Arrays.hashCode(this.x, 0, 7) ^ 0x3E68E7;
    }
}

