/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.AbstractECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECConstants;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECMultiplier;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.WTauNafMultiplier;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecT409FieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecT409K1Point;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat448;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecT409K1Curve
extends ECCurve.AbstractF2m {
    private static final int SECT409K1_DEFAULT_COORDS = 6;
    private static final ECFieldElement[] SECT409K1_AFFINE_ZS;
    public SecT409K1Point infinity;

    public SecT409K1Curve() {
        SecT409K1Curve secT409K1Curve = this;
        super(409, 87, 0, 0);
        secT409K1Curve.infinity = new SecT409K1Point(this, null, null);
        secT409K1Curve.a = secT409K1Curve.fromBigInteger(BigInteger.valueOf(0L));
        secT409K1Curve.b = secT409K1Curve.fromBigInteger(BigInteger.valueOf(1L));
        secT409K1Curve.order = new BigInteger(1, Hex.decodeStrict("7FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE5F83B2D4EA20400EC4557D5ED3E3E7CA5B4B5C83B8E01E5FCF"));
        secT409K1Curve.cofactor = BigInteger.valueOf(4L);
        secT409K1Curve.coord = 6;
    }

    static {
        SecT409FieldElement secT409FieldElement;
        ECFieldElement[] eCFieldElementArray = new ECFieldElement[1];
        SecT409FieldElement secT409FieldElement2 = secT409FieldElement;
        secT409FieldElement = new SecT409FieldElement(ECConstants.ONE);
        eCFieldElementArray[0] = secT409FieldElement2;
        SECT409K1_AFFINE_ZS = eCFieldElementArray;
    }

    @Override
    public ECCurve cloneCurve() {
        return new SecT409K1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int n3) {
        return n3 == 6;
    }

    @Override
    public ECMultiplier createDefaultMultiplier() {
        return new WTauNafMultiplier();
    }

    @Override
    public int getFieldSize() {
        return 409;
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecT409FieldElement(bigInteger);
    }

    @Override
    public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return new SecT409K1Point(this, eCFieldElement, eCFieldElement2);
    }

    @Override
    public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        return new SecT409K1Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public boolean isKoblitz() {
        return true;
    }

    public int getM() {
        return 409;
    }

    public boolean isTrinomial() {
        return true;
    }

    public int getK1() {
        return 87;
    }

    public int getK2() {
        return 0;
    }

    public int getK3() {
        return 0;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n3, final int n4) {
        final long[] lArray = new long[n4 * 7 * 2];
        int n5 = 0;
        for (int i3 = 0; i3 < n4; ++i3) {
            ECPoint eCPoint = eCPointArray[n3 + i3];
            Nat448.copy64(((SecT409FieldElement)eCPoint.getRawXCoord()).x, 0, lArray, n5);
            Nat448.copy64(((SecT409FieldElement)eCPoint.getRawYCoord()).x, 0, lArray, n5 += 7);
            n5 += 7;
        }
        return new AbstractECLookupTable(){

            private ECPoint createPoint(long[] lArray3, long[] lArray2) {
                SecT409FieldElement secT409FieldElement;
                SecT409FieldElement secT409FieldElement2 = secT409FieldElement;
                secT409FieldElement = new SecT409FieldElement(lArray2);
                return secT409FieldElement2.SecT409K1Curve.this.createRawPoint(new SecT409FieldElement(lArray3), secT409FieldElement2, SECT409K1_AFFINE_ZS);
            }

            @Override
            public int getSize() {
                return n4;
            }

            @Override
            public ECPoint lookup(int n3) {
                long[] lArray4 = Nat448.create64();
                long[] lArray2 = Nat448.create64();
                int n42 = 0;
                for (int i3 = 0; i3 < n4; ++i3) {
                    long l3 = (i3 ^ n3) - 1 >> 31;
                    for (int i4 = 0; i4 < 7; ++i4) {
                        long[] lArray3 = lArray;
                        lArray4[i4] = lArray4[i4] ^ lArray[n42 + i4] & l3;
                        lArray2[i4] = lArray2[i4] ^ lArray3[n42 + 7 + i4] & l3;
                    }
                    n42 += 14;
                }
                return this.createPoint(lArray4, lArray2);
            }

            @Override
            public ECPoint lookupVar(int n3) {
                long[] lArray4 = Nat448.create64();
                long[] lArray2 = Nat448.create64();
                int n42 = n3 * 7 * 2;
                for (int i3 = 0; i3 < 7; ++i3) {
                    long[] lArray3 = lArray;
                    lArray4[i3] = lArray3[n42 + i3];
                    lArray2[i3] = lArray[n42 + 7 + i3];
                }
                return this.createPoint(lArray4, lArray2);
            }
        };
    }
}

