/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.AbstractECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECConstants;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecT409FieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecT409R1Point;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat448;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecT409R1Curve
extends ECCurve.AbstractF2m {
    private static final int SECT409R1_DEFAULT_COORDS = 6;
    private static final ECFieldElement[] SECT409R1_AFFINE_ZS;
    public SecT409R1Point infinity;

    public SecT409R1Curve() {
        SecT409R1Curve secT409R1Curve = this;
        super(409, 87, 0, 0);
        secT409R1Curve.infinity = new SecT409R1Point(this, null, null);
        secT409R1Curve.a = secT409R1Curve.fromBigInteger(BigInteger.valueOf(1L));
        secT409R1Curve.b = secT409R1Curve.fromBigInteger(new BigInteger(1, Hex.decodeStrict("0021A5C2C8EE9FEB5C4B9A753B7B476B7FD6422EF1F3DD674761FA99D6AC27C8A9A197B272822F6CD57A55AA4F50AE317B13545F")));
        secT409R1Curve.order = new BigInteger(1, Hex.decodeStrict("010000000000000000000000000000000000000000000000000001E2AAD6A612F33307BE5FA47C3C9E052F838164CD37D9A21173"));
        secT409R1Curve.cofactor = BigInteger.valueOf(2L);
        secT409R1Curve.coord = 6;
    }

    static {
        SecT409FieldElement secT409FieldElement;
        ECFieldElement[] eCFieldElementArray = new ECFieldElement[1];
        SecT409FieldElement secT409FieldElement2 = secT409FieldElement;
        secT409FieldElement = new SecT409FieldElement(ECConstants.ONE);
        eCFieldElementArray[0] = secT409FieldElement2;
        SECT409R1_AFFINE_ZS = eCFieldElementArray;
    }

    @Override
    public ECCurve cloneCurve() {
        return new SecT409R1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int n3) {
        return n3 == 6;
    }

    @Override
    public int getFieldSize() {
        return 409;
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecT409FieldElement(bigInteger);
    }

    @Override
    public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return new SecT409R1Point(this, eCFieldElement, eCFieldElement2);
    }

    @Override
    public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        return new SecT409R1Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public boolean isKoblitz() {
        return false;
    }

    public int getM() {
        return 409;
    }

    public boolean isTrinomial() {
        return true;
    }

    public int getK1() {
        return 87;
    }

    public int getK2() {
        return 0;
    }

    public int getK3() {
        return 0;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n3, final int n4) {
        final long[] lArray = new long[n4 * 7 * 2];
        int n5 = 0;
        for (int i3 = 0; i3 < n4; ++i3) {
            ECPoint eCPoint = eCPointArray[n3 + i3];
            Nat448.copy64(((SecT409FieldElement)eCPoint.getRawXCoord()).x, 0, lArray, n5);
            Nat448.copy64(((SecT409FieldElement)eCPoint.getRawYCoord()).x, 0, lArray, n5 += 7);
            n5 += 7;
        }
        return new AbstractECLookupTable(){

            private ECPoint createPoint(long[] lArray3, long[] lArray2) {
                SecT409FieldElement secT409FieldElement;
                SecT409FieldElement secT409FieldElement2 = secT409FieldElement;
                secT409FieldElement = new SecT409FieldElement(lArray2);
                return secT409FieldElement2.SecT409R1Curve.this.createRawPoint(new SecT409FieldElement(lArray3), secT409FieldElement2, SECT409R1_AFFINE_ZS);
            }

            @Override
            public int getSize() {
                return n4;
            }

            @Override
            public ECPoint lookup(int n3) {
                long[] lArray4 = Nat448.create64();
                long[] lArray2 = Nat448.create64();
                int n42 = 0;
                for (int i3 = 0; i3 < n4; ++i3) {
                    long l3 = (i3 ^ n3) - 1 >> 31;
                    for (int i4 = 0; i4 < 7; ++i4) {
                        long[] lArray3 = lArray;
                        lArray4[i4] = lArray4[i4] ^ lArray[n42 + i4] & l3;
                        lArray2[i4] = lArray2[i4] ^ lArray3[n42 + 7 + i4] & l3;
                    }
                    n42 += 14;
                }
                return this.createPoint(lArray4, lArray2);
            }

            @Override
            public ECPoint lookupVar(int n3) {
                long[] lArray4 = Nat448.create64();
                long[] lArray2 = Nat448.create64();
                int n42 = n3 * 7 * 2;
                for (int i3 = 0; i3 < 7; ++i3) {
                    long[] lArray3 = lArray;
                    lArray4[i3] = lArray3[n42 + i3];
                    lArray2[i3] = lArray[n42 + 7 + i3];
                }
                return this.createPoint(lArray4, lArray2);
            }
        };
    }
}

