/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Interleave;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat576;
import java.math.BigInteger;

public class SecT571Field {
    private static final long M59 = 0x7FFFFFFFFFFFFFFL;
    private static final long[] ROOT_Z = new long[]{3161836309350906777L, -7642453882179322845L, -3821226941089661423L, 7312758566309945096L, -556661012383879292L, 8945041530681231562L, -4750851271514160027L, 6847946401097695794L, 541669439031730457L};

    public static void add(long[] lArray, long[] lArray2, long[] lArray3) {
        for (int i3 = 0; i3 < 9; ++i3) {
            lArray3[i3] = lArray[i3] ^ lArray2[i3];
        }
    }

    private static void add(long[] lArray, int n3, long[] lArray2, int n4, long[] lArray3, int n5) {
        for (int i3 = 0; i3 < 9; ++i3) {
            long l3;
            int n6 = n5 + i3;
            lArray3[n6] = l3 = lArray[n3 + i3] ^ lArray2[n4 + i3];
        }
    }

    public static void addBothTo(long[] lArray, long[] lArray2, long[] lArray3) {
        for (int i3 = 0; i3 < 9; ++i3) {
            lArray3[i3] = lArray3[i3] ^ (lArray[i3] ^ lArray2[i3]);
        }
    }

    private static void addBothTo(long[] lArray, int n3, long[] lArray2, int n4, long[] lArray3, int n5) {
        for (int i3 = 0; i3 < 9; ++i3) {
            long l3;
            int n6 = n5 + i3;
            lArray3[n6] = l3 = lArray3[n6] ^ (lArray[n3 + i3] ^ lArray2[n4 + i3]);
        }
    }

    public static void addExt(long[] lArray, long[] lArray2, long[] lArray3) {
        for (int i3 = 0; i3 < 18; ++i3) {
            lArray3[i3] = lArray[i3] ^ lArray2[i3];
        }
    }

    public static void addOne(long[] lArray, long[] lArray2) {
        long l3;
        lArray2[0] = l3 = lArray[0] ^ 1L;
        for (int i3 = 1; i3 < 9; ++i3) {
            long l4;
            lArray2[i3] = l4 = lArray[i3];
        }
    }

    private static void addTo(long[] lArray, long[] lArray2) {
        for (int i3 = 0; i3 < 9; ++i3) {
            lArray2[i3] = lArray2[i3] ^ lArray[i3];
        }
    }

    public static long[] fromBigInteger(BigInteger bigInteger) {
        return Nat.fromBigInteger64(571, bigInteger);
    }

    public static void halfTrace(long[] lArray, long[] lArray2) {
        long[] lArray3 = Nat576.createExt64();
        Nat576.copy64(lArray, lArray2);
        for (int i3 = 1; i3 < 571; i3 += 2) {
            SecT571Field.implSquare(lArray2, lArray3);
            SecT571Field.reduce(lArray3, lArray2);
            SecT571Field.implSquare(lArray2, lArray3);
            SecT571Field.reduce(lArray3, lArray2);
            SecT571Field.addTo(lArray, lArray2);
        }
    }

    public static void invert(long[] lArray, long[] lArray2) {
        if (!Nat576.isZero64(lArray)) {
            long[] lArray3 = Nat576.create64();
            long[] lArray4 = Nat576.create64();
            long[] lArray5 = lArray3;
            long[] lArray6 = lArray3;
            long[] lArray7 = lArray3;
            long[] lArray8 = Nat576.create64();
            long[] lArray9 = lArray3;
            long[] lArray10 = lArray3;
            SecT571Field.square(lArray, lArray8);
            SecT571Field.square(lArray8, lArray3);
            SecT571Field.square(lArray10, lArray4);
            SecT571Field.multiply(lArray10, lArray4, lArray3);
            SecT571Field.squareN(lArray10, 2, lArray4);
            SecT571Field.multiply(lArray10, lArray4, lArray3);
            SecT571Field.multiply(lArray10, lArray8, lArray3);
            SecT571Field.squareN(lArray10, 5, lArray4);
            SecT571Field.multiply(lArray3, lArray4, lArray3);
            SecT571Field.squareN(lArray4, 5, lArray4);
            SecT571Field.multiply(lArray9, lArray4, lArray3);
            SecT571Field.squareN(lArray9, 15, lArray4);
            SecT571Field.multiply(lArray3, lArray4, lArray8);
            SecT571Field.squareN(lArray8, 30, lArray3);
            SecT571Field.squareN(lArray6, 30, lArray4);
            SecT571Field.multiply(lArray7, lArray4, lArray3);
            SecT571Field.squareN(lArray6, 60, lArray4);
            SecT571Field.multiply(lArray7, lArray4, lArray3);
            SecT571Field.squareN(lArray4, 60, lArray4);
            SecT571Field.multiply(lArray5, lArray4, lArray3);
            SecT571Field.squareN(lArray5, 180, lArray4);
            SecT571Field.multiply(lArray3, lArray4, lArray3);
            SecT571Field.squareN(lArray4, 180, lArray4);
            SecT571Field.multiply(lArray3, lArray4, lArray3);
            SecT571Field.multiply(lArray3, lArray8, lArray2);
            return;
        }
        throw new IllegalStateException();
    }

    public static void multiply(long[] lArray, long[] lArray2, long[] lArray3) {
        long[] lArray4 = Nat576.createExt64();
        SecT571Field.implMultiply(lArray, lArray2, lArray4);
        SecT571Field.reduce(lArray4, lArray3);
    }

    public static void multiplyAddToExt(long[] lArray, long[] lArray2, long[] lArray3) {
        long[] lArray4 = lArray;
        lArray = Nat576.createExt64();
        SecT571Field.implMultiply(lArray4, lArray2, lArray);
        SecT571Field.addExt(lArray3, lArray, lArray3);
    }

    public static void multiplyPrecomp(long[] lArray, long[] lArray2, long[] lArray3) {
        long[] lArray4 = Nat576.createExt64();
        SecT571Field.implMultiplyPrecomp(lArray, lArray2, lArray4);
        SecT571Field.reduce(lArray4, lArray3);
    }

    public static void multiplyPrecompAddToExt(long[] lArray, long[] lArray2, long[] lArray3) {
        long[] lArray4 = lArray;
        lArray = Nat576.createExt64();
        SecT571Field.implMultiplyPrecomp(lArray4, lArray2, lArray);
        SecT571Field.addExt(lArray3, lArray, lArray3);
    }

    public static long[] precompMultiplicand(long[] lArray) {
        long[] lArray2 = lArray;
        lArray = new long[288];
        System.arraycopy(lArray2, 0, lArray, 9, 9);
        int n3 = 0;
        for (int i3 = 7; i3 > 0; --i3) {
            int n4 = (n3 += 18) >>> 1;
            Nat.shiftUpBit64(9, lArray, n4, 0L, lArray, n3);
            SecT571Field.reduce5(lArray, n3);
            n4 = n3 + 9;
            SecT571Field.add(lArray, 9, lArray, n3, lArray, n4);
        }
        Nat.shiftUpBits64(144, lArray, 0, 4, 0L, lArray, 144);
        return lArray;
    }

    public static void reduce(long[] lArray, long[] lArray2) {
        long l3 = lArray[17];
        long l4 = lArray[9] ^ l3 >>> 59 ^ l3 >>> 57 ^ l3 >>> 54 ^ l3 >>> 49;
        l3 = lArray[8] ^ l3 << 5 ^ l3 << 7 ^ l3 << 10 ^ l3 << 15;
        for (int i3 = 16; i3 >= 10; --i3) {
            long l5;
            long l6 = l3;
            l3 = lArray[i3];
            int n3 = i3 - 8;
            lArray2[n3] = l5 = l6 ^ l3 >>> 59 ^ l3 >>> 57 ^ l3 >>> 54 ^ l3 >>> 49;
            l3 = lArray[i3 - 9] ^ l3 << 5 ^ l3 << 7 ^ l3 << 10 ^ l3 << 15;
        }
        lArray2[1] = l3 = l3 ^ l4 >>> 59 ^ l4 >>> 57 ^ l4 >>> 54 ^ l4 >>> 49;
        l3 = lArray[0] ^ l4 << 5 ^ l4 << 7 ^ l4 << 10 ^ l4 << 15;
        l4 = lArray2[8];
        long l7 = l4 >>> 59;
        lArray2[0] = l7 = l3 ^ l7 ^ l7 << 2 ^ l7 << 5 ^ l7 << 10;
        lArray2[8] = l7 = l4 & 0x7FFFFFFFFFFFFFFL;
    }

    public static void reduce5(long[] lArray, int n3) {
        long l3;
        int n4 = n3 + 8;
        long l4 = lArray[n4];
        long l5 = l3 = l4 >>> 59;
        lArray[n3] = lArray[n3] ^ (l5 ^ l5 << 2 ^ l3 << 5 ^ l3 << 10);
        lArray[n4] = l4 & 0x7FFFFFFFFFFFFFFL;
    }

    public static void sqrt(long[] lArray, long[] lArray2) {
        long l3;
        long[] lArray3 = Nat576.create64();
        long[] lArray4 = Nat576.create64();
        int n3 = 0;
        for (int i3 = 0; i3 < 4; ++i3) {
            long l4;
            long l5 = Interleave.unshuffle(lArray[n3++]);
            long l6 = l4 = l5;
            l4 = Interleave.unshuffle(lArray[n3++]);
            lArray3[i3] = l6 & 0xFFFFFFFFL | l4 << 32;
            lArray4[i3] = l5 >>> 32 | l4 & 0xFFFFFFFF00000000L;
        }
        long l7 = Interleave.unshuffle(lArray[n3]);
        lArray3[4] = l3 = l7 & 0xFFFFFFFFL;
        lArray4[4] = l3 = l7 >>> 32;
        SecT571Field.multiply(lArray4, ROOT_Z, lArray2);
        SecT571Field.add(lArray2, lArray3, lArray2);
    }

    public static void square(long[] lArray, long[] lArray2) {
        long[] lArray3 = Nat576.createExt64();
        SecT571Field.implSquare(lArray, lArray3);
        SecT571Field.reduce(lArray3, lArray2);
    }

    public static void squareAddToExt(long[] lArray, long[] lArray2) {
        long[] lArray3 = lArray;
        lArray = Nat576.createExt64();
        SecT571Field.implSquare(lArray3, lArray);
        SecT571Field.addExt(lArray2, lArray, lArray2);
    }

    public static void squareN(long[] lArray, int n3, long[] lArray2) {
        long[] lArray3 = Nat576.createExt64();
        SecT571Field.implSquare(lArray, lArray3);
        SecT571Field.reduce(lArray3, lArray2);
        while ((n3 += -1) > 0) {
            SecT571Field.implSquare(lArray2, lArray3);
            SecT571Field.reduce(lArray3, lArray2);
        }
    }

    public static int trace(long[] lArray) {
        long l3 = lArray[8];
        return (int)(lArray[0] ^ l3 >>> 49 ^ l3 >>> 57) & 1;
    }

    public static void implMultiply(long[] lArray, long[] lArray2, long[] lArray3) {
        long l3;
        long l4;
        long[] lArray4 = new long[16];
        for (int i3 = 0; i3 < 9; ++i3) {
            l4 = lArray[i3];
            l3 = lArray2[i3];
            int n3 = i3 << 1;
            SecT571Field.implMulwAcc(lArray4, l4, l3, lArray3, n3);
        }
        long l5 = lArray3[0];
        l4 = lArray3[1];
        long l6 = l5 ^ lArray3[2];
        l3 = l6;
        long l7 = l4;
        lArray3[1] = l4 = l3 ^ l4;
        l3 = l7 ^ lArray3[3];
        long l8 = l6 ^ lArray3[4];
        long l9 = l8;
        long l10 = l3;
        lArray3[2] = l3 = l9 ^ l3;
        l9 = l10 ^ lArray3[5];
        long l11 = l8 ^ lArray3[6];
        long l12 = l11;
        long l13 = l9;
        lArray3[3] = l9 = l12 ^ l9;
        l12 = l13 ^ lArray3[7];
        long l14 = l11 ^ lArray3[8];
        long l15 = l14;
        long l16 = l12;
        lArray3[4] = l12 = l15 ^ l12;
        l15 = l16 ^ lArray3[9];
        long l17 = l14 ^ lArray3[10];
        long l18 = l17;
        long l19 = l15;
        lArray3[5] = l15 = l18 ^ l15;
        l18 = l19 ^ lArray3[11];
        long l20 = l17 ^ lArray3[12];
        long l21 = l20;
        long l22 = l18;
        lArray3[6] = l18 = l21 ^ l18;
        l21 = l22 ^ lArray3[13];
        long l23 = l20 ^ lArray3[14];
        long l24 = l23;
        long l25 = l21;
        lArray3[7] = l21 = l24 ^ l21;
        l24 = l25 ^ lArray3[15];
        long l26 = l23 ^ lArray3[16];
        long l27 = l26 ^ l24;
        long l28 = l4;
        long l29 = l5;
        lArray3[8] = l27;
        l5 = l26 ^ (l24 ^ lArray3[17]);
        lArray3[9] = l4 = l29 ^ l5;
        lArray3[10] = l4 = l28 ^ l5;
        lArray3[11] = l4 = l3 ^ l5;
        lArray3[12] = l4 = l9 ^ l5;
        lArray3[13] = l4 = l12 ^ l5;
        lArray3[14] = l4 = l15 ^ l5;
        lArray3[15] = l4 = l18 ^ l5;
        lArray3[16] = l4 = l21 ^ l5;
        lArray3[17] = l5 = l27 ^ l5;
        l5 = lArray[0] ^ lArray[1];
        l4 = lArray2[0] ^ lArray2[1];
        SecT571Field.implMulwAcc(lArray4, l5, l4, lArray3, 1);
        l5 = lArray[0] ^ lArray[2];
        l4 = lArray2[0] ^ lArray2[2];
        SecT571Field.implMulwAcc(lArray4, l5, l4, lArray3, 2);
        l5 = lArray[0] ^ lArray[3];
        l4 = lArray2[0] ^ lArray2[3];
        SecT571Field.implMulwAcc(lArray4, l5, l4, lArray3, 3);
        l5 = lArray[1] ^ lArray[2];
        l4 = lArray2[1] ^ lArray2[2];
        SecT571Field.implMulwAcc(lArray4, l5, l4, lArray3, 3);
        l5 = lArray[0] ^ lArray[4];
        l4 = lArray2[0] ^ lArray2[4];
        SecT571Field.implMulwAcc(lArray4, l5, l4, lArray3, 4);
        l5 = lArray[1] ^ lArray[3];
        l4 = lArray2[1] ^ lArray2[3];
        SecT571Field.implMulwAcc(lArray4, l5, l4, lArray3, 4);
        l5 = lArray[0] ^ lArray[5];
        l4 = lArray2[0] ^ lArray2[5];
        SecT571Field.implMulwAcc(lArray4, l5, l4, lArray3, 5);
        l5 = lArray[1] ^ lArray[4];
        l4 = lArray2[1] ^ lArray2[4];
        SecT571Field.implMulwAcc(lArray4, l5, l4, lArray3, 5);
        l5 = lArray[2] ^ lArray[3];
        l4 = lArray2[2] ^ lArray2[3];
        SecT571Field.implMulwAcc(lArray4, l5, l4, lArray3, 5);
        l5 = lArray[0] ^ lArray[6];
        l4 = lArray2[0] ^ lArray2[6];
        SecT571Field.implMulwAcc(lArray4, l5, l4, lArray3, 6);
        l5 = lArray[1] ^ lArray[5];
        l4 = lArray2[1] ^ lArray2[5];
        SecT571Field.implMulwAcc(lArray4, l5, l4, lArray3, 6);
        l5 = lArray[2] ^ lArray[4];
        l4 = lArray2[2] ^ lArray2[4];
        SecT571Field.implMulwAcc(lArray4, l5, l4, lArray3, 6);
        l5 = lArray[0] ^ lArray[7];
        l4 = lArray2[0] ^ lArray2[7];
        SecT571Field.implMulwAcc(lArray4, l5, l4, lArray3, 7);
        l5 = lArray[1] ^ lArray[6];
        l4 = lArray2[1] ^ lArray2[6];
        SecT571Field.implMulwAcc(lArray4, l5, l4, lArray3, 7);
        l5 = lArray[2] ^ lArray[5];
        l4 = lArray2[2] ^ lArray2[5];
        SecT571Field.implMulwAcc(lArray4, l5, l4, lArray3, 7);
        l5 = lArray[3] ^ lArray[4];
        l4 = lArray2[3] ^ lArray2[4];
        SecT571Field.implMulwAcc(lArray4, l5, l4, lArray3, 7);
        l5 = lArray[0] ^ lArray[8];
        l4 = lArray2[0] ^ lArray2[8];
        SecT571Field.implMulwAcc(lArray4, l5, l4, lArray3, 8);
        l5 = lArray[1] ^ lArray[7];
        l4 = lArray2[1] ^ lArray2[7];
        SecT571Field.implMulwAcc(lArray4, l5, l4, lArray3, 8);
        l5 = lArray[2] ^ lArray[6];
        l4 = lArray2[2] ^ lArray2[6];
        SecT571Field.implMulwAcc(lArray4, l5, l4, lArray3, 8);
        l5 = lArray[3] ^ lArray[5];
        l4 = lArray2[3] ^ lArray2[5];
        SecT571Field.implMulwAcc(lArray4, l5, l4, lArray3, 8);
        l5 = lArray[1] ^ lArray[8];
        l4 = lArray2[1] ^ lArray2[8];
        SecT571Field.implMulwAcc(lArray4, l5, l4, lArray3, 9);
        l5 = lArray[2] ^ lArray[7];
        l4 = lArray2[2] ^ lArray2[7];
        SecT571Field.implMulwAcc(lArray4, l5, l4, lArray3, 9);
        l5 = lArray[3] ^ lArray[6];
        l4 = lArray2[3] ^ lArray2[6];
        SecT571Field.implMulwAcc(lArray4, l5, l4, lArray3, 9);
        l5 = lArray[4] ^ lArray[5];
        l4 = lArray2[4] ^ lArray2[5];
        SecT571Field.implMulwAcc(lArray4, l5, l4, lArray3, 9);
        l5 = lArray[2] ^ lArray[8];
        l4 = lArray2[2] ^ lArray2[8];
        SecT571Field.implMulwAcc(lArray4, l5, l4, lArray3, 10);
        l5 = lArray[3] ^ lArray[7];
        l4 = lArray2[3] ^ lArray2[7];
        SecT571Field.implMulwAcc(lArray4, l5, l4, lArray3, 10);
        l5 = lArray[4] ^ lArray[6];
        l4 = lArray2[4] ^ lArray2[6];
        SecT571Field.implMulwAcc(lArray4, l5, l4, lArray3, 10);
        l5 = lArray[3] ^ lArray[8];
        l4 = lArray2[3] ^ lArray2[8];
        SecT571Field.implMulwAcc(lArray4, l5, l4, lArray3, 11);
        l5 = lArray[4] ^ lArray[7];
        l4 = lArray2[4] ^ lArray2[7];
        SecT571Field.implMulwAcc(lArray4, l5, l4, lArray3, 11);
        l5 = lArray[5] ^ lArray[6];
        l4 = lArray2[5] ^ lArray2[6];
        SecT571Field.implMulwAcc(lArray4, l5, l4, lArray3, 11);
        l5 = lArray[4] ^ lArray[8];
        l4 = lArray2[4] ^ lArray2[8];
        SecT571Field.implMulwAcc(lArray4, l5, l4, lArray3, 12);
        l5 = lArray[5] ^ lArray[7];
        l4 = lArray2[5] ^ lArray2[7];
        SecT571Field.implMulwAcc(lArray4, l5, l4, lArray3, 12);
        l5 = lArray[5] ^ lArray[8];
        l4 = lArray2[5] ^ lArray2[8];
        SecT571Field.implMulwAcc(lArray4, l5, l4, lArray3, 13);
        l5 = lArray[6] ^ lArray[7];
        l4 = lArray2[6] ^ lArray2[7];
        SecT571Field.implMulwAcc(lArray4, l5, l4, lArray3, 13);
        l5 = lArray[6] ^ lArray[8];
        l4 = lArray2[6] ^ lArray2[8];
        SecT571Field.implMulwAcc(lArray4, l5, l4, lArray3, 14);
        l5 = lArray[7] ^ lArray[8];
        long l30 = lArray2[7] ^ lArray2[8];
        SecT571Field.implMulwAcc(lArray4, l5, l30, lArray3, 15);
    }

    public static void implMultiplyPrecomp(long[] lArray, long[] lArray2, long[] lArray3) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = 15;
        for (n6 = 56; n6 >= 0; n6 -= 8) {
            for (n5 = 1; n5 < 9; n5 += 2) {
                int n8 = (int)(lArray[n5] >>> n6);
                n4 = n8 & n7;
                n3 = ((n8 >>> 4 & n7) + 16) * 9;
                int n9 = n5 - 1;
                SecT571Field.addBothTo(lArray2, n4 *= 9, lArray2, n3, lArray3, n9);
            }
            Nat.shiftUpBits64(16, lArray3, 0, 8, 0L);
        }
        for (n6 = 56; n6 >= 0; n6 -= 8) {
            for (n5 = 0; n5 < 9; n5 += 2) {
                int n10 = (int)(lArray[n5] >>> n6);
                n4 = n10 & n7;
                n3 = ((n10 >>> 4 & n7) + 16) * 9;
                SecT571Field.addBothTo(lArray2, n4 *= 9, lArray2, n3, lArray3, n5);
            }
            if (n6 <= 0) continue;
            Nat.shiftUpBits64(18, lArray3, 0, 8, 0L);
        }
    }

    public static void implMulwAcc(long[] lArray, long l3, long l4, long[] lArray2, int n3) {
        int n4;
        int n5;
        lArray[1] = l4;
        for (n5 = 2; n5 < 16; n5 += 2) {
            long l5;
            long l6;
            lArray[n5] = l6 = lArray[n5 >>> 1] << 1;
            int n6 = n5 + 1;
            lArray[n6] = l5 = l6 ^ l4;
        }
        n5 = (int)l3;
        long l7 = 0L;
        long l8 = lArray[n5 & 0xF] ^ lArray[n5 >>> 4 & 0xF] << 4;
        n5 = 56;
        do {
            long l9 = l7;
            int n7 = (int)(l3 >>> n5);
            l7 = lArray[n7 & 0xF] ^ lArray[n7 >>> 4 & 0xF] << 4;
            l8 ^= l7 << n5;
            l7 = l9 ^ l7 >>> -n5;
        } while ((n5 += -8) > 0);
        for (n4 = 0; n4 < 7; ++n4) {
            l3 = (l3 & 0xFEFEFEFEFEFEFEFEL) >>> 1;
            l7 ^= l3 & l4 << n4 >> 63;
        }
        long[] lArray3 = lArray2;
        lArray3[n3] = lArray2[n3] ^ l8;
        n4 = n3 + 1;
        lArray2[n4] = l3 = lArray3[n4] ^ l7;
    }

    public static void implSquare(long[] lArray, long[] lArray2) {
        Interleave.expand64To128(lArray, 0, 9, lArray2, 0);
    }
}

