/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecT571Field;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat576;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class SecT571FieldElement
extends ECFieldElement.AbstractF2m {
    public long[] x;

    public SecT571FieldElement(BigInteger bigInteger) {
        if (bigInteger != null && bigInteger.signum() >= 0 && bigInteger.bitLength() <= 571) {
            this.x = SecT571Field.fromBigInteger(bigInteger);
            return;
        }
        throw new IllegalArgumentException("x value invalid for SecT571FieldElement");
    }

    public SecT571FieldElement() {
        this.x = Nat576.create64();
    }

    public SecT571FieldElement(long[] lArray) {
        this.x = lArray;
    }

    @Override
    public boolean isOne() {
        return Nat576.isOne64(this.x);
    }

    @Override
    public boolean isZero() {
        return Nat576.isZero64(this.x);
    }

    @Override
    public boolean testBitZero() {
        return (this.x[0] & 1L) != 0L;
    }

    @Override
    public BigInteger toBigInteger() {
        return Nat576.toBigInteger64(this.x);
    }

    @Override
    public String getFieldName() {
        return "SecT571Field";
    }

    @Override
    public int getFieldSize() {
        return 571;
    }

    @Override
    public ECFieldElement add(ECFieldElement eCFieldElement) {
        SecT571FieldElement secT571FieldElement = object;
        Object object = Nat576.create64();
        SecT571Field.add(secT571FieldElement.x, ((SecT571FieldElement)eCFieldElement).x, (long[])object);
        return new SecT571FieldElement((long[])object);
    }

    @Override
    public ECFieldElement addOne() {
        SecT571FieldElement secT571FieldElement = object;
        Object object = Nat576.create64();
        SecT571Field.addOne(secT571FieldElement.x, (long[])object);
        return new SecT571FieldElement((long[])object);
    }

    @Override
    public ECFieldElement subtract(ECFieldElement eCFieldElement) {
        return this.add(eCFieldElement);
    }

    @Override
    public ECFieldElement multiply(ECFieldElement eCFieldElement) {
        SecT571FieldElement secT571FieldElement = object;
        Object object = Nat576.create64();
        SecT571Field.multiply(secT571FieldElement.x, ((SecT571FieldElement)eCFieldElement).x, (long[])object);
        return new SecT571FieldElement((long[])object);
    }

    @Override
    public ECFieldElement multiplyMinusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement eCFieldElement3) {
        return this.multiplyPlusProduct(eCFieldElement, eCFieldElement2, eCFieldElement3);
    }

    @Override
    public ECFieldElement multiplyPlusProduct(ECFieldElement object, ECFieldElement object2, ECFieldElement object3) {
        Object object4 = ((SecT571FieldElement)object4).x;
        object = ((SecT571FieldElement)object).x;
        object2 = ((SecT571FieldElement)object2).x;
        object3 = ((SecT571FieldElement)object3).x;
        long[] lArray = Nat576.createExt64();
        SecT571Field.multiplyAddToExt((long[])object4, (long[])object, lArray);
        SecT571Field.multiplyAddToExt((long[])object2, (long[])object3, lArray);
        long[] lArray2 = Nat576.create64();
        object4 = lArray2;
        SecT571Field.reduce(lArray, lArray2);
        return new SecT571FieldElement((long[])object4);
    }

    @Override
    public ECFieldElement divide(ECFieldElement eCFieldElement) {
        return this.multiply(eCFieldElement.invert());
    }

    @Override
    public ECFieldElement negate() {
        return this;
    }

    @Override
    public ECFieldElement square() {
        SecT571FieldElement secT571FieldElement = object;
        Object object = Nat576.create64();
        SecT571Field.square(secT571FieldElement.x, (long[])object);
        return new SecT571FieldElement((long[])object);
    }

    @Override
    public ECFieldElement squareMinusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return this.squarePlusProduct(eCFieldElement, eCFieldElement2);
    }

    @Override
    public ECFieldElement squarePlusProduct(ECFieldElement object, ECFieldElement object2) {
        Object object3 = ((SecT571FieldElement)object3).x;
        object = ((SecT571FieldElement)object).x;
        object2 = ((SecT571FieldElement)object2).x;
        long[] lArray = Nat576.createExt64();
        SecT571Field.squareAddToExt((long[])object3, lArray);
        SecT571Field.multiplyAddToExt((long[])object, (long[])object2, lArray);
        long[] lArray2 = Nat576.create64();
        object3 = lArray2;
        SecT571Field.reduce(lArray, lArray2);
        return new SecT571FieldElement((long[])object3);
    }

    @Override
    public ECFieldElement squarePow(int n3) {
        if (n3 < 1) {
            return object;
        }
        SecT571FieldElement secT571FieldElement = object;
        Object object = Nat576.create64();
        SecT571Field.squareN(secT571FieldElement.x, n3, (long[])object);
        return new SecT571FieldElement((long[])object);
    }

    @Override
    public ECFieldElement halfTrace() {
        SecT571FieldElement secT571FieldElement = object;
        Object object = Nat576.create64();
        SecT571Field.halfTrace(secT571FieldElement.x, (long[])object);
        return new SecT571FieldElement((long[])object);
    }

    @Override
    public boolean hasFastTrace() {
        return true;
    }

    @Override
    public int trace() {
        return SecT571Field.trace(this.x);
    }

    @Override
    public ECFieldElement invert() {
        SecT571FieldElement secT571FieldElement = object;
        Object object = Nat576.create64();
        SecT571Field.invert(secT571FieldElement.x, (long[])object);
        return new SecT571FieldElement((long[])object);
    }

    @Override
    public ECFieldElement sqrt() {
        SecT571FieldElement secT571FieldElement = object;
        Object object = Nat576.create64();
        SecT571Field.sqrt(secT571FieldElement.x, (long[])object);
        return new SecT571FieldElement((long[])object);
    }

    public int getRepresentation() {
        return 3;
    }

    public int getM() {
        return 571;
    }

    public int getK1() {
        return 2;
    }

    public int getK2() {
        return 5;
    }

    public int getK3() {
        return 10;
    }

    public boolean equals(Object object) {
        if (object == secT571FieldElement2) {
            return true;
        }
        if (!(object instanceof SecT571FieldElement)) {
            return false;
        }
        SecT571FieldElement secT571FieldElement = secT571FieldElement2;
        SecT571FieldElement secT571FieldElement2 = (SecT571FieldElement)object;
        return Nat576.eq64(secT571FieldElement.x, secT571FieldElement2.x);
    }

    public int hashCode() {
        return Arrays.hashCode(this.x, 0, 9) ^ 0x5724CC;
    }
}

