/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.rfc7748;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.rfc7748.X25519Field;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.rfc8032.Ed25519;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public abstract class X25519 {
    public static final int POINT_SIZE = 32;
    public static final int SCALAR_SIZE = 32;
    private static final int C_A = 486662;
    private static final int C_A24 = 121666;

    public static boolean calculateAgreement(byte[] byArray, int n3, byte[] byArray2, int n4, byte[] byArray3, int n5) {
        X25519.scalarMult(byArray, n3, byArray2, n4, byArray3, n5);
        return Arrays.areAllZeroes(byArray3, n5, 32) ^ true;
    }

    private static int decode32(byte[] byArray, int n3) {
        int n4 = byArray[n3] & 0xFF;
        n3 = n3 + 1;
        return n4 | (byArray[n3] & 0xFF) << 8 | (byArray[++n3] & 0xFF) << 16 | byArray[n3 + 1] << 24;
    }

    private static void decodeScalar(byte[] byArray, int n3, int[] nArray) {
        int n4;
        for (int i3 = 0; i3 < 8; ++i3) {
            nArray[i3] = X25519.decode32(byArray, i3 * 4 + n3);
        }
        int[] nArray2 = nArray;
        nArray2[0] = nArray[0] & 0xFFFFFFF8;
        nArray[7] = n4 = nArray[7] & Integer.MAX_VALUE;
        nArray2[7] = n4 | 0x40000000;
    }

    public static void generatePrivateKey(SecureRandom secureRandom, byte[] byArray) {
        byte by;
        byte[] byArray2 = byArray;
        secureRandom.nextBytes(byArray);
        byArray2[0] = (byte)(byArray[0] & 0xF8);
        byArray[31] = by = (byte)(byArray[31] & 0x7F);
        byArray2[31] = (byte)(by | 0x40);
    }

    public static void generatePublicKey(byte[] byArray, int n3, byte[] byArray2, int n4) {
        X25519.scalarMultBase(byArray, n3, byArray2, n4);
    }

    private static void pointDouble(int[] nArray, int[] nArray2) {
        int[] nArray3 = X25519Field.create();
        int[] nArray4 = X25519Field.create();
        X25519Field.apm(nArray, nArray2, nArray3, nArray4);
        X25519Field.sqr(nArray3, nArray3);
        X25519Field.sqr(nArray4, nArray4);
        X25519Field.mul(nArray3, nArray4, nArray);
        X25519Field.sub(nArray3, nArray4, nArray3);
        X25519Field.mul(nArray3, 121666, nArray2);
        X25519Field.add(nArray2, nArray4, nArray2);
        X25519Field.mul(nArray2, nArray3, nArray2);
    }

    public static void precompute() {
        Ed25519.precompute();
    }

    public static void scalarMult(byte[] objectArray, int n3, byte[] objectArray2, int n4, byte[] byArray, int n5) {
        byte[] byArray2 = objectArray;
        objectArray = new int[8];
        X25519.decodeScalar(byArray2, n3, objectArray);
        int[] nArray = X25519Field.create();
        X25519Field.decode(objectArray2, n4, nArray);
        objectArray2 = X25519Field.create();
        X25519Field.copy(nArray, 0, objectArray2, 0);
        int[] nArray2 = X25519Field.create();
        int[] nArray3 = nArray2;
        nArray2[0] = 1;
        int[] nArray4 = X25519Field.create();
        int[] nArray5 = nArray4;
        nArray4[0] = 1;
        int[] nArray6 = X25519Field.create();
        int[] nArray7 = X25519Field.create();
        int[] nArray8 = X25519Field.create();
        int n6 = 254;
        int n7 = 1;
        do {
            Object[] objectArray3 = objectArray2;
            X25519Field.apm(nArray5, nArray6, nArray7, nArray5);
            X25519Field.apm(objectArray2, nArray3, nArray6, objectArray2);
            X25519Field.mul(nArray7, objectArray2, nArray7);
            X25519Field.mul(nArray5, nArray6, nArray5);
            X25519Field.sqr(nArray6, nArray6);
            X25519Field.sqr(objectArray3, objectArray3);
            X25519Field.sub(nArray6, objectArray2, nArray8);
            X25519Field.mul(nArray8, 121666, nArray3);
            X25519Field.add(nArray3, objectArray2, nArray3);
            X25519Field.mul(nArray3, nArray8, nArray3);
            X25519Field.mul((int[])objectArray2, nArray6, (int[])objectArray2);
            X25519Field.apm(nArray7, nArray5, nArray5, nArray6);
            X25519Field.sqr(nArray5, nArray5);
            X25519Field.sqr(nArray6, nArray6);
            X25519Field.mul(nArray6, nArray, nArray6);
            int n8 = n7;
            int n9 = n6 += -1;
            n7 = n9 >>> 5;
            int n10 = n9 & 0x1F;
            n7 = objectArray[n7] >>> n10 & 1;
            int n11 = n8 ^ n7;
            X25519Field.cswap(n11, objectArray2, nArray5);
            X25519Field.cswap(n11, nArray3, nArray6);
        } while (n6 >= 3);
        for (int i3 = 0; i3 < 3; ++i3) {
            X25519.pointDouble(objectArray2, nArray3);
        }
        Object[] objectArray4 = objectArray2;
        X25519Field.inv(nArray3, nArray3);
        X25519Field.mul((int[])objectArray4, nArray3, (int[])objectArray2);
        X25519Field.normalize(objectArray4);
        X25519Field.encode((int[])objectArray2, byArray, n5);
    }

    public static void scalarMultBase(byte[] byArray, int n3, byte[] objectArray, int n4) {
        int[] nArray = X25519Field.create();
        byte[] byArray2 = objectArray;
        int[] nArray2 = X25519Field.create();
        objectArray = nArray2;
        Ed25519.scalarMultBaseYZ(Friend.INSTANCE, byArray, n3, nArray, objectArray);
        X25519Field.apm(nArray2, nArray, nArray, objectArray);
        X25519Field.inv(nArray2, nArray2);
        X25519Field.mul(nArray, nArray2, nArray);
        X25519Field.normalize(nArray);
        X25519Field.encode(nArray, byArray2, n4);
    }

    public static class F
    extends X25519Field {
        private F() {
        }
    }

    public static class Friend {
        private static final Friend INSTANCE = new Friend();

        private Friend() {
        }
    }
}

