/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.rfc7748;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Mod;

public abstract class X25519Field {
    public static final int SIZE = 10;
    private static final int M24 = 0xFFFFFF;
    private static final int M25 = 0x1FFFFFF;
    private static final int M26 = 0x3FFFFFF;
    private static final int[] P32 = new int[]{-19, -1, -1, -1, -1, -1, -1, Integer.MAX_VALUE};
    private static final int[] ROOT_NEG_ONE = new int[]{34513072, 59165138, 4688974, 3500415, 6194736, 33281959, 54535759, 32551604, 163342, 5703241};

    public static void add(int[] nArray, int[] nArray2, int[] nArray3) {
        for (int i3 = 0; i3 < 10; ++i3) {
            nArray3[i3] = nArray[i3] + nArray2[i3];
        }
    }

    public static void addOne(int[] nArray) {
        nArray[0] = nArray[0] + 1;
    }

    public static void addOne(int[] nArray, int n3) {
        nArray[n3] = nArray[n3] + 1;
    }

    public static void apm(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        for (int i3 = 0; i3 < 10; ++i3) {
            int n3 = nArray[i3];
            int n4 = nArray2[i3];
            nArray3[i3] = n3 + n4;
            nArray4[i3] = n3 - n4;
        }
    }

    public static void carry(int[] nArray) {
        int[] nArray2 = nArray;
        int n3 = nArray2[0];
        int n4 = nArray2[1];
        int n5 = nArray2[2];
        int n6 = nArray2[3];
        int n7 = nArray2[4];
        int n8 = nArray2[5];
        int n9 = nArray2[6];
        int n10 = nArray2[7];
        int n11 = nArray2[8];
        int n12 = n5 + (n4 >> 26);
        n4 &= 0x3FFFFFF;
        n5 = n7 + (n6 >> 26);
        n6 &= 0x3FFFFFF;
        n7 = n10 + (n9 >> 26);
        n9 &= 0x3FFFFFF;
        n10 = nArray[9] + (n11 >> 26);
        int n13 = n5;
        int n14 = n5;
        int n15 = n12;
        n12 = n6 + (n12 >> 25);
        n5 = n15 & 0x1FFFFFF;
        n6 = n8 + (n14 >> 25);
        n8 = n13 & 0x1FFFFFF;
        int n16 = (n11 & 0x3FFFFFF) + (n7 >> 25);
        int n17 = n10;
        n7 &= 0x1FFFFFF;
        int n18 = n3 = (n17 >> 25) * 38 + n3;
        n3 = n4 + (n3 >> 26);
        n4 = n18 & 0x3FFFFFF;
        int n19 = n9 + (n6 >> 26);
        int n20 = n12;
        int n21 = n12;
        int n22 = n3;
        n12 = n6 & 0x3FFFFFF;
        n3 = n5 + (n3 >> 26);
        n5 = n22 & 0x3FFFFFF;
        n6 = n8 + (n21 >> 26);
        n7 = n20 & 0x3FFFFFF;
        n8 = n7 + (n19 >> 26);
        n9 = n19 & 0x3FFFFFF;
        n10 = (n17 & 0x1FFFFFF) + (n16 >> 26);
        int n23 = n16 & 0x3FFFFFF;
        nArray2[0] = n4;
        nArray2[1] = n5;
        nArray2[2] = n3;
        nArray2[3] = n7;
        nArray2[4] = n6;
        nArray2[5] = n12;
        nArray2[6] = n9;
        nArray2[7] = n8;
        nArray2[8] = n23;
        nArray[9] = n10;
    }

    public static void cmov(int n3, int[] nArray, int n4, int[] nArray2, int n5) {
        for (int i3 = 0; i3 < 10; ++i3) {
            int n6 = n5 + i3;
            int n7 = nArray2[n6];
            nArray2[n6] = n7 ^ (n7 ^ nArray[n4 + i3]) & n3;
        }
    }

    public static void cnegate(int n3, int[] nArray) {
        n3 = 0 - n3;
        for (int i3 = 0; i3 < 10; ++i3) {
            nArray[i3] = (nArray[i3] ^ n3) - n3;
        }
    }

    public static void copy(int[] nArray, int n3, int[] nArray2, int n4) {
        for (int i3 = 0; i3 < 10; ++i3) {
            int n5 = n4 + i3;
            nArray2[n5] = nArray[n3 + i3];
        }
    }

    public static int[] create() {
        return new int[10];
    }

    public static int[] createTable(int n3) {
        return new int[n3 * 10];
    }

    public static void cswap(int n3, int[] nArray, int[] nArray2) {
        n3 = 0 - n3;
        for (int i3 = 0; i3 < 10; ++i3) {
            int n4 = nArray[i3];
            int n5 = nArray2[i3];
            int n6 = n4;
            n4 = n3 & (n4 ^ n5);
            nArray[i3] = n6 ^ n4;
            nArray2[i3] = n5 ^ n4;
        }
    }

    public static void decode(int[] nArray, int n3, int[] nArray2) {
        X25519Field.decode128(nArray, n3, nArray2, 0);
        X25519Field.decode128(nArray, n3 + 4, nArray2, 5);
        nArray2[9] = nArray2[9] & 0xFFFFFF;
    }

    public static void decode(byte[] byArray, int n3, int[] nArray) {
        X25519Field.decode128(byArray, n3, nArray, 0);
        X25519Field.decode128(byArray, n3 + 16, nArray, 5);
        nArray[9] = nArray[9] & 0xFFFFFF;
    }

    private static void decode128(int[] nArray, int n3, int[] nArray2, int n4) {
        int n5 = n3;
        int n6 = n3;
        int n7 = nArray[n3 + 0];
        n3 = nArray[n3 + 1];
        int n8 = nArray[n6 + 2];
        int n9 = nArray[n5 + 3];
        int n10 = n4 + 0;
        nArray2[n10] = n7 & 0x3FFFFFF;
        n10 = n4 + 1;
        nArray2[n10] = (n3 << 6 | n7 >>> 26) & 0x3FFFFFF;
        n7 = n4 + 2;
        nArray2[n7] = (n8 << 12 | n3 >>> 20) & 0x1FFFFFF;
        n7 = n4 + 3;
        nArray2[n7] = (n9 << 19 | n8 >>> 13) & 0x3FFFFFF;
        n7 = n4 + 4;
        nArray2[n7] = n9 >>> 7;
    }

    private static void decode128(byte[] byArray, int n3, int[] nArray, int n4) {
        int n5 = n3;
        int n6 = n3;
        int n7 = X25519Field.decode32(byArray, n3 + 0);
        n3 = X25519Field.decode32(byArray, n3 + 4);
        int n8 = X25519Field.decode32(byArray, n6 + 8);
        int n9 = X25519Field.decode32(byArray, n5 + 12);
        int n10 = n4 + 0;
        nArray[n10] = n7 & 0x3FFFFFF;
        n10 = n4 + 1;
        nArray[n10] = (n3 << 6 | n7 >>> 26) & 0x3FFFFFF;
        n7 = n4 + 2;
        nArray[n7] = (n8 << 12 | n3 >>> 20) & 0x1FFFFFF;
        n7 = n4 + 3;
        nArray[n7] = (n9 << 19 | n8 >>> 13) & 0x3FFFFFF;
        n7 = n4 + 4;
        nArray[n7] = n9 >>> 7;
    }

    private static int decode32(byte[] byArray, int n3) {
        int n4 = byArray[n3] & 0xFF;
        n3 = n3 + 1;
        return n4 | (byArray[n3] & 0xFF) << 8 | (byArray[++n3] & 0xFF) << 16 | byArray[n3 + 1] << 24;
    }

    public static void encode(int[] nArray, int[] nArray2, int n3) {
        X25519Field.encode128(nArray, 0, nArray2, n3);
        int n4 = n3 + 4;
        X25519Field.encode128(nArray, 5, nArray2, n4);
    }

    public static void encode(int[] nArray, byte[] byArray, int n3) {
        X25519Field.encode128(nArray, 0, byArray, n3);
        int n4 = n3 + 16;
        X25519Field.encode128(nArray, 5, byArray, n4);
    }

    private static void encode128(int[] nArray, int n3, int[] nArray2, int n4) {
        int n5 = nArray[n3 + 0];
        int n6 = nArray[n3 + 1];
        int n7 = nArray[n3 + 2];
        int n8 = nArray[n3 + 3];
        int n9 = nArray[n3 + 4];
        n3 = n4 + 0;
        nArray2[n3] = n5 | n6 << 26;
        n3 = n4 + 1;
        nArray2[n3] = n6 >>> 6 | n7 << 20;
        n3 = n4 + 2;
        nArray2[n3] = n7 >>> 12 | n8 << 13;
        n3 = n4 + 3;
        nArray2[n3] = n8 >>> 19 | n9 << 7;
    }

    private static void encode128(int[] nArray, int n3, byte[] byArray, int n4) {
        int n5 = nArray[n3 + 0];
        int n6 = nArray[n3 + 1];
        int n7 = nArray[n3 + 2];
        int n8 = nArray[n3 + 3];
        int n9 = nArray[n3 + 4];
        X25519Field.encode32(n5 | n6 << 26, byArray, n4 + 0);
        X25519Field.encode32(n6 >>> 6 | n7 << 20, byArray, n4 + 4);
        X25519Field.encode32(n7 >>> 12 | n8 << 13, byArray, n4 + 8);
        X25519Field.encode32(n8 >>> 19 | n9 << 7, byArray, n4 + 12);
    }

    private static void encode32(int n3, byte[] byArray, int n4) {
        int n5 = n3;
        int n6 = n3;
        int n7 = n3;
        byArray[n4] = (byte)n3;
        n3 = n4 + 1;
        byArray[n3] = (byte)(n7 >>> 8);
        byArray[++n3] = (byte)(n6 >>> 16);
        byArray[++n3] = (byte)(n5 >>> 24);
    }

    public static void inv(int[] nArray, int[] nArray2) {
        int[] nArray3 = X25519Field.create();
        int[] nArray4 = new int[8];
        X25519Field.copy(nArray, 0, nArray3, 0);
        X25519Field.normalize(nArray3);
        X25519Field.encode(nArray3, nArray4, 0);
        Mod.modOddInverse(P32, nArray4, nArray4);
        X25519Field.decode(nArray4, 0, nArray2);
    }

    public static void invVar(int[] nArray, int[] nArray2) {
        int[] nArray3 = X25519Field.create();
        int[] nArray4 = new int[8];
        X25519Field.copy(nArray, 0, nArray3, 0);
        X25519Field.normalize(nArray3);
        X25519Field.encode(nArray3, nArray4, 0);
        Mod.modOddInverseVar(P32, nArray4, nArray4);
        X25519Field.decode(nArray4, 0, nArray2);
    }

    public static int isZero(int[] nArray) {
        int n3 = 0;
        for (int i3 = 0; i3 < 10; ++i3) {
            n3 |= nArray[i3];
        }
        return (n3 >>> 1 | n3 & 1) - 1 >> 31;
    }

    public static boolean isZeroVar(int[] nArray) {
        return X25519Field.isZero(nArray) != 0;
    }

    public static void mul(int[] nArray, int n3, int[] nArray2) {
        int n4 = nArray[0];
        int n5 = nArray[1];
        int n6 = nArray[2];
        int n7 = nArray[3];
        int n8 = nArray[4];
        int n9 = nArray[5];
        int n10 = nArray[6];
        int n11 = nArray[7];
        int n12 = nArray[8];
        long l3 = n3;
        long l4 = (long)n6 * l3;
        n3 = (int)l4 & 0x1FFFFFF;
        long l5 = l4 >> 25;
        long l6 = (long)n8 * l3;
        n6 = (int)l6 & 0x1FFFFFF;
        long l7 = l6 >> 25;
        long l8 = (long)n11 * l3;
        n8 = (int)l8 & 0x1FFFFFF;
        long l9 = l8 >> 25;
        long l10 = (long)nArray[9] * l3;
        long l11 = (l10 >> 25) * 38L;
        l11 = (long)n4 * l3 + l11;
        nArray2[0] = (int)l11 & 0x3FFFFFF;
        long l12 = (long)n9 * l3 + l7;
        nArray2[5] = (int)l12 & 0x3FFFFFF;
        l12 >>= 26;
        long l13 = (long)n5 * l3 + (l11 >>= 26);
        l11 = l13;
        nArray2[1] = (int)l11 & 0x3FFFFFF;
        l11 = (long)n7 * l3 + l5;
        nArray2[3] = (int)l11 & 0x3FFFFFF;
        l11 >>= 26;
        l12 = (long)n10 * l3 + l12;
        nArray2[6] = (int)l12 & 0x3FFFFFF;
        long l14 = (long)n12 * l3 + l9;
        nArray2[8] = (int)l14 & 0x3FFFFFF;
        nArray2[2] = n3 + (int)(l13 >> 26);
        nArray2[4] = n6 + (int)l11;
        nArray2[7] = n8 + (int)(l12 >>= 26);
        nArray2[9] = ((int)l10 & 0x1FFFFFF) + (int)(l14 >>= 26);
    }

    public static void mul(int[] nArray, int[] nArray2, int[] nArray3) {
        int n3 = nArray[0];
        int n4 = nArray2[0];
        int n5 = nArray[1];
        int n6 = nArray2[1];
        int n7 = nArray[2];
        int n8 = nArray2[2];
        int n9 = nArray[3];
        int n10 = nArray2[3];
        int n11 = nArray[4];
        int n12 = n11;
        int n13 = n10;
        int n14 = n9;
        int n15 = n8;
        int n16 = n3;
        int n17 = n12;
        int n18 = n9;
        int n19 = n3;
        int n20 = nArray2[4];
        int n21 = nArray[5];
        n3 = nArray2[5];
        n9 = nArray[6];
        n12 = nArray2[6];
        int n22 = nArray[7];
        int n23 = nArray2[7];
        int n24 = nArray[8];
        int n25 = nArray2[8];
        int n26 = nArray[9];
        int n27 = nArray2[9];
        long l3 = n19;
        long l4 = n4;
        long l5 = l3 * l4;
        long l6 = n6;
        long l7 = l3 * l6;
        long l8 = n5;
        l7 = l8 * l4 + l7;
        long l9 = n8;
        long l10 = l3 * l9;
        l10 = l8 * l6 + l10;
        long l11 = n7;
        l10 = l11 * l4 + l10;
        long l12 = l8 * l9;
        l12 = l11 * l6 + l12 << 1;
        long l13 = n10;
        long l14 = l3 * l13;
        long l15 = n18;
        long l16 = l3;
        l3 = a.a(l15, l4, l14, l12);
        l12 = l11 * l9 << 1;
        l14 = n20;
        long l17 = l16 * l14;
        l17 = l8 * l13 + l17;
        l17 = l15 * l6 + l17;
        long l18 = n17;
        long l19 = l6;
        l4 = a.a(l18, l4, l17, l12);
        l6 = l8 * l14;
        l6 = l11 * l13 + l6;
        l6 = l15 * l9 + l6;
        l6 = l18 * l19 + l6 << 1;
        l8 = l11 * l14;
        l8 = l18 * l9 + l8 << 1;
        l8 = l15 * l13 + l8;
        l9 = l15 * l14;
        l9 = l18 * l13 + l9;
        long l20 = l18 * l14 << 1;
        long l21 = l9;
        long l22 = l8;
        long l23 = l6;
        long l24 = l3;
        l3 = n21;
        l6 = n3;
        l8 = l3 * l6;
        l9 = n12;
        l11 = l3 * l9;
        l12 = n9;
        l11 = l12 * l6 + l11;
        l13 = n23;
        l14 = l3 * l13;
        l14 = l12 * l9 + l14;
        l15 = n22;
        l14 = l15 * l6 + l14;
        l17 = l12 * l13;
        l17 = l15 * l9 + l17 << 1;
        l18 = n25;
        long l25 = l3 * l18;
        long l26 = n24;
        long l27 = l3;
        l3 = a.a(l26, l6, l25, l17);
        l17 = l15 * l13 << 1;
        l25 = n27;
        long l28 = l27 * l25;
        l28 = l12 * l18 + l28;
        l28 = l26 * l9 + l28;
        long l29 = n26;
        long l30 = l9;
        l6 = a.a(l29, l6, l28, l17);
        l9 = l12 * l25;
        l9 = l15 * l18 + l9;
        l9 = l26 * l13 + l9;
        l9 = l29 * l30 + l9;
        l12 = l15 * l25;
        l12 = l29 * l13 + l12 << 1;
        l12 = l26 * l18 + l12;
        l13 = l26 * l25;
        l13 = l29 * l18 + l13;
        l5 -= l9 * 76L;
        l7 -= l12 * 38L;
        l9 = l10 - l13 * 38L;
        l10 = l24 - l29 * l25 * 76L;
        l8 = l23 - l8;
        l11 = l22 - l11;
        l12 = l21 - l14;
        l3 = l20 - l3;
        n21 = n16 + n21;
        n3 = n4 + n3;
        n8 = n5 + n9;
        n9 = n6 + n12;
        n10 = n7 + n22;
        n12 = n15 + n23;
        n22 = n14 + n24;
        n23 = n13 + n25;
        n20 += n27;
        long l31 = n21;
        long l32 = n3;
        long l33 = l31 * l32;
        long l34 = n9;
        l13 = l31 * l34;
        l14 = n8;
        long l35 = l14 * l32 + l13;
        l13 = n12;
        l15 = l31 * l13;
        l15 = l14 * l34 + l15;
        l17 = n10;
        l15 = l17 * l32 + l15;
        l18 = l14 * l13;
        l18 = l17 * l34 + l18 << 1;
        l25 = n23;
        l26 = l31 * l25;
        l28 = n22;
        long l36 = l31;
        long l37 = a.a(l28, l32, l26, l18);
        l31 = l17 * l13 << 1;
        l18 = n20;
        l26 = l36 * l18;
        l26 = l14 * l25 + l26;
        l26 = l28 * l34 + l26;
        l29 = n11 + n26;
        long l38 = a.a(l29, l32, l26, l31);
        long l39 = l37;
        l37 = l14 * l18;
        l37 = l17 * l25 + l37;
        l37 = l28 * l13 + l37;
        l37 = l29 * l34 + l37 << 1;
        l32 = l17 * l18;
        l32 = l29 * l13 + l32 << 1;
        l32 = l28 * l25 + l32;
        l31 = l28 * l18;
        l31 = l29 * l25 + l31;
        l34 = l29 * l18 << 1;
        long l40 = l39 - l10 + l3;
        n3 = (int)l40 & 0x3FFFFFF;
        l13 = l40 >> 26;
        l13 = l38 - l4 - l6 + l13;
        l37 = ((l13 >> 25) + l37 - l8) * 38L + l5;
        nArray3[0] = (int)l37 & 0x3FFFFFF;
        l37 >>= 26;
        l37 = (l32 - l11) * 38L + l7 + l37;
        nArray3[1] = (int)l37 & 0x3FFFFFF;
        l37 >>= 26;
        l37 = (l31 - l12) * 38L + l9 + l37;
        nArray3[2] = (int)l37 & 0x1FFFFFF;
        l37 >>= 25;
        l37 = (l34 - l3) * 38L + l10 + l37;
        nArray3[3] = (int)l37 & 0x3FFFFFF;
        l37 >>= 26;
        l37 = a.a(l6, 38L, l4, l37);
        nArray3[4] = (int)l37 & 0x1FFFFFF;
        l37 >>= 25;
        l37 = l33 - l5 + l8 + l37;
        nArray3[5] = (int)l37 & 0x3FFFFFF;
        l37 >>= 26;
        l37 = l35 - l7 + l11 + l37;
        nArray3[6] = (int)l37 & 0x3FFFFFF;
        l37 >>= 26;
        l37 = l15 - l9 + l12 + l37;
        nArray3[7] = (int)l37 & 0x1FFFFFF;
        l37 = (l37 >> 25) + (long)n3;
        nArray3[8] = (int)l37 & 0x3FFFFFF;
        nArray3[9] = ((int)l13 & 0x1FFFFFF) + (int)(l37 >> 26);
    }

    public static void negate(int[] nArray, int[] nArray2) {
        for (int i3 = 0; i3 < 10; ++i3) {
            nArray2[i3] = -nArray[i3];
        }
    }

    public static void normalize(int[] nArray) {
        int n3 = nArray[9] >>> 23 & 1;
        X25519Field.reduce(nArray, n3);
        X25519Field.reduce(nArray, -n3);
    }

    public static void one(int[] nArray) {
        nArray[0] = 1;
        for (int i3 = 1; i3 < 10; ++i3) {
            nArray[i3] = 0;
        }
    }

    private static void powPm5d8(int[] nArray, int[] nArray2, int[] nArray3) {
        X25519Field.sqr(nArray, nArray2);
        X25519Field.mul(nArray, nArray2, nArray2);
        int[] nArray4 = X25519Field.create();
        X25519Field.sqr(nArray2, nArray4);
        X25519Field.mul(nArray, nArray4, nArray4);
        X25519Field.sqr(nArray4, 2, nArray4);
        X25519Field.mul(nArray2, nArray4, nArray4);
        nArray2 = X25519Field.create();
        X25519Field.sqr(nArray4, 5, nArray2);
        X25519Field.mul(nArray4, nArray2, nArray2);
        int[] nArray5 = X25519Field.create();
        X25519Field.sqr(nArray2, 5, nArray5);
        X25519Field.mul(nArray4, nArray5, nArray5);
        X25519Field.sqr(nArray5, 10, nArray4);
        X25519Field.mul(nArray2, nArray4, nArray4);
        X25519Field.sqr(nArray4, 25, nArray2);
        X25519Field.mul(nArray4, nArray2, nArray2);
        X25519Field.sqr(nArray2, 25, nArray5);
        X25519Field.mul(nArray4, nArray5, nArray5);
        X25519Field.sqr(nArray5, 50, nArray4);
        X25519Field.mul(nArray2, nArray4, nArray4);
        X25519Field.sqr(nArray4, 125, nArray2);
        X25519Field.mul(nArray4, nArray2, nArray2);
        X25519Field.sqr(nArray2, 2, nArray4);
        X25519Field.mul(nArray4, nArray, nArray3);
    }

    private static void reduce(int[] nArray, int n3) {
        int n4 = nArray[9];
        long l3 = (long)(((n4 >> 24) + n3) * 19) + (long)nArray[0];
        nArray[0] = (int)l3 & 0x3FFFFFF;
        l3 = (l3 >> 26) + (long)nArray[1];
        nArray[1] = (int)l3 & 0x3FFFFFF;
        l3 = (l3 >> 26) + (long)nArray[2];
        nArray[2] = (int)l3 & 0x1FFFFFF;
        l3 = (l3 >> 25) + (long)nArray[3];
        nArray[3] = (int)l3 & 0x3FFFFFF;
        l3 = (l3 >> 26) + (long)nArray[4];
        nArray[4] = (int)l3 & 0x1FFFFFF;
        l3 = (l3 >> 25) + (long)nArray[5];
        nArray[5] = (int)l3 & 0x3FFFFFF;
        l3 = (l3 >> 26) + (long)nArray[6];
        nArray[6] = (int)l3 & 0x3FFFFFF;
        l3 = (l3 >> 26) + (long)nArray[7];
        nArray[7] = (int)l3 & 0x1FFFFFF;
        l3 = (l3 >> 25) + (long)nArray[8];
        nArray[8] = (int)l3 & 0x3FFFFFF;
        nArray[9] = (n4 & 0xFFFFFF) + (int)(l3 >> 26);
    }

    public static void sqr(int[] nArray, int[] nArray2) {
        long l3;
        long l4;
        int n3 = nArray[0];
        int n4 = nArray[1];
        int n5 = n3;
        int n6 = nArray[2];
        int n7 = nArray[3];
        int n8 = nArray[4];
        int n9 = nArray[5];
        int n10 = nArray[6];
        int n11 = nArray[7];
        int n12 = nArray[8];
        int n13 = nArray[9];
        int n14 = n4 * 2;
        int n15 = n3;
        n3 = n7 * 2;
        int n16 = n8 * 2;
        long l5 = l4 = (long)n15;
        long l6 = l5 * l5;
        long l7 = n14;
        long l8 = l4 * l7;
        long l9 = n6 * 2;
        long l10 = l9;
        long l11 = l7;
        long l12 = l4 * l10;
        long l13 = n4;
        long l14 = l4;
        long l15 = l4;
        long l16 = l13;
        long l17 = l16 * l16 + l12;
        long l18 = l7 * l10;
        l4 = n3;
        l18 = l15 * l4 + l18;
        l7 = (long)n6 * l10;
        l10 = n16;
        l7 = l14 * l10 + l7;
        l7 = l13 * l4 + l7;
        l12 = l11 * l10;
        l4 = l9 * l4 + l12;
        l12 = l9 * l10;
        l13 = n7;
        int n17 = n9;
        long l19 = l13;
        l12 = l19 * l19 + l12;
        long l20 = (long)n8 * l10;
        long l21 = l13 *= l10;
        long l22 = l12;
        long l23 = l4;
        int n18 = n10 * 2;
        int n19 = n9;
        n9 = n12 * 2;
        n16 = n13 * 2;
        long l24 = l4 = (long)n19;
        l10 = l24 * l24;
        l12 = n18;
        l13 = l4 * l12;
        long l25 = n11 * 2;
        long l26 = l25;
        long l27 = l12;
        long l28 = l4 * l26;
        long l29 = n10;
        long l30 = l4;
        long l31 = l4;
        long l32 = l29;
        long l33 = l32 * l32 + l28;
        l4 = l12 * l26;
        l12 = n9;
        l4 = l31 * l12 + l4;
        l26 = (long)n11 * l26;
        l28 = n16;
        l26 = l30 * l28 + l26;
        l26 = l29 * l12 + l26;
        l29 = l27 * l28;
        l12 = l25 * l12 + l29;
        l29 = l25 * l28;
        long l34 = l3 = (long)n12;
        l29 = l34 * l34 + l29;
        long l35 = l17;
        l17 = l6 - l12 * 38L;
        l6 = l8 - l29 * 38L;
        l8 = l35 - (l3 *= l28) * 38L;
        l12 = l18 - (long)n13 * l28 * 38L;
        l10 = l23 - l10;
        l13 = l22 - l13;
        l33 = l21 - l33;
        l4 = l20 - l4;
        n9 = n5 + n17;
        int n20 = n4 + n10;
        n10 = n20;
        int n21 = n9;
        int n22 = n8;
        n8 = n6 + n11;
        n6 = n7 + n12;
        n7 = n22 + n13;
        n9 = n10 * 2;
        n10 = n8 * 2;
        n11 = n6 * 2;
        n12 = n7 * 2;
        long l36 = l28 = (long)n21;
        long l37 = l36 * l36;
        l29 = n9;
        l3 = l28 * l29;
        long l38 = n10;
        long l39 = l28 * l38;
        long l40 = n20;
        long l41 = l40;
        long l42 = l28;
        long l43 = l28;
        long l44 = l41;
        long l45 = l44 * l44 + l39;
        l28 = l29 * l38;
        l39 = n11;
        l28 = l43 * l39 + l28;
        l41 = (long)n8 * l38;
        long l46 = n12;
        l41 = l42 * l46 + l41;
        long l47 = l40 * l39 + l41;
        long l48 = l28;
        long l49 = l29 * l46;
        l49 = l38 * l39 + l49;
        l28 = l38 * l46;
        long l50 = l29 = (long)n6;
        l28 = l50 * l50 + l28;
        l29 *= l46;
        l38 = (long)n7 * l46;
        long l51 = l48 - l12 + l4;
        n8 = (int)l51 & 0x3FFFFFF;
        l39 = l51 >> 26;
        l39 = l47 - l7 - l26 + l39;
        long l52 = l17;
        l17 = ((l39 >> 25) + l49 - l10) * 38L + l17;
        nArray2[0] = (int)l17 & 0x3FFFFFF;
        l17 >>= 26;
        l17 = (l28 - l13) * 38L + l6 + l17;
        nArray2[1] = (int)l17 & 0x3FFFFFF;
        l17 >>= 26;
        l17 = (l29 - l33) * 38L + l8 + l17;
        nArray2[2] = (int)l17 & 0x1FFFFFF;
        l17 >>= 25;
        l17 = (l38 - l4) * 38L + l12 + l17;
        nArray2[3] = (int)l17 & 0x3FFFFFF;
        l17 >>= 26;
        l17 = a.a(l26, 38L, l7, l17);
        nArray2[4] = (int)l17 & 0x1FFFFFF;
        l17 >>= 25;
        l17 = l37 - l52 + l10 + l17;
        nArray2[5] = (int)l17 & 0x3FFFFFF;
        l17 >>= 26;
        l17 = l3 - l6 + l13 + l17;
        nArray2[6] = (int)l17 & 0x3FFFFFF;
        l17 >>= 26;
        l17 = l45 - l8 + l33 + l17;
        nArray2[7] = (int)l17 & 0x1FFFFFF;
        l17 = (l17 >> 25) + (long)n8;
        nArray2[8] = (int)l17 & 0x3FFFFFF;
        nArray2[9] = ((int)l39 & 0x1FFFFFF) + (int)(l17 >> 26);
    }

    public static void sqr(int[] nArray, int n3, int[] nArray2) {
        X25519Field.sqr(nArray, nArray2);
        while ((n3 += -1) > 0) {
            X25519Field.sqr(nArray2, nArray2);
        }
    }

    public static boolean sqrtRatioVar(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = X25519Field.create();
        int[] nArray5 = X25519Field.create();
        X25519Field.mul(nArray, nArray2, nArray4);
        X25519Field.sqr(nArray2, nArray5);
        X25519Field.mul(nArray4, nArray5, nArray4);
        X25519Field.sqr(nArray5, nArray5);
        X25519Field.mul(nArray5, nArray4, nArray5);
        int[] nArray6 = X25519Field.create();
        int[] nArray7 = X25519Field.create();
        X25519Field.powPm5d8(nArray5, nArray6, nArray7);
        X25519Field.mul(nArray7, nArray4, nArray7);
        nArray4 = X25519Field.create();
        X25519Field.sqr(nArray7, nArray4);
        X25519Field.mul(nArray4, nArray2, nArray4);
        X25519Field.sub(nArray4, nArray, nArray6);
        X25519Field.normalize(nArray6);
        if (X25519Field.isZeroVar(nArray6)) {
            X25519Field.copy(nArray7, 0, nArray3, 0);
            return true;
        }
        X25519Field.add(nArray4, nArray, nArray6);
        X25519Field.normalize(nArray6);
        if (X25519Field.isZeroVar(nArray6)) {
            X25519Field.mul(nArray7, ROOT_NEG_ONE, nArray3);
            return true;
        }
        return false;
    }

    public static void sub(int[] nArray, int[] nArray2, int[] nArray3) {
        for (int i3 = 0; i3 < 10; ++i3) {
            nArray3[i3] = nArray[i3] - nArray2[i3];
        }
    }

    public static void subOne(int[] nArray) {
        nArray[0] = nArray[0] - 1;
    }

    public static void zero(int[] nArray) {
        for (int i3 = 0; i3 < 10; ++i3) {
            nArray[i3] = 0;
        }
    }
}

