/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.rfc7748;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Mod;

public abstract class X448Field {
    public static final int SIZE = 16;
    private static final int M28 = 0xFFFFFFF;
    private static final long U32 = 0xFFFFFFFFL;
    private static final int[] P32 = new int[]{-1, -1, -1, -1, -1, -1, -1, -2, -1, -1, -1, -1, -1, -1};

    public static void add(int[] nArray, int[] nArray2, int[] nArray3) {
        for (int i3 = 0; i3 < 16; ++i3) {
            nArray3[i3] = nArray[i3] + nArray2[i3];
        }
    }

    public static void addOne(int[] nArray) {
        nArray[0] = nArray[0] + 1;
    }

    public static void addOne(int[] nArray, int n3) {
        nArray[n3] = nArray[n3] + 1;
    }

    public static void carry(int[] nArray) {
        int[] nArray2 = nArray;
        int n3 = nArray2[0];
        int n4 = nArray2[1];
        int n5 = nArray2[2];
        int n6 = nArray2[3];
        int n7 = nArray2[4];
        int n8 = nArray2[5];
        int n9 = nArray2[6];
        int n10 = nArray2[7];
        int n11 = nArray2[8];
        int n12 = nArray2[9];
        int n13 = nArray2[10];
        int n14 = nArray2[11];
        int n15 = nArray2[12];
        int n16 = n11;
        int n17 = n11;
        int n18 = n7;
        int n19 = n7;
        int n20 = n3;
        int n21 = n3;
        int n22 = nArray[14];
        n3 = nArray[15];
        n4 += n21 >>> 28;
        n7 = n20 & 0xFFFFFFF;
        n8 += n19 >>> 28;
        n11 = n18 & 0xFFFFFFF;
        n12 += n17 >>> 28;
        int n23 = n16 & 0xFFFFFFF;
        int n24 = nArray[13] + (n15 >>> 28);
        int n25 = n14;
        int n26 = n8;
        int n27 = n4;
        n4 = n5 + (n4 >>> 28);
        n5 = n27 & 0xFFFFFFF;
        n8 = n9 + (n8 >>> 28);
        n9 = n26 & 0xFFFFFFF;
        n13 += n12 >>> 28;
        int n28 = n8;
        int n29 = n10;
        int n30 = n8;
        int n31 = n4;
        int n32 = n6;
        int n33 = n4;
        int n34 = n22;
        n22 = n12 & 0xFFFFFFF;
        n4 = n34 + (n24 >>> 28);
        n6 = n24 & 0xFFFFFFF;
        n8 = n32 + (n33 >>> 28);
        n10 = n31 & 0xFFFFFFF;
        n12 = n29 + (n30 >>> 28);
        n14 = n28 & 0xFFFFFFF;
        n24 = n25 + (n13 >>> 28);
        int n35 = n23;
        int n36 = n7;
        int n37 = n3;
        n3 = n13 & 0xFFFFFFF;
        int n38 = n37 + (n4 >>> 28);
        n4 &= 0xFFFFFFF;
        n7 = n38 >>> 28;
        n13 = n38 & 0xFFFFFFF;
        n23 = n36 + n7;
        int n39 = n35 + n7;
        n7 = n11 + (n8 >>> 28);
        n8 &= 0xFFFFFFF;
        n11 = n39 + (n12 >>> 28);
        n12 &= 0xFFFFFFF;
        int n40 = (n15 & 0xFFFFFFF) + (n24 >>> 28);
        int n41 = n11;
        int n42 = n22;
        int n43 = n7;
        n22 = n24 & 0xFFFFFFF;
        n5 += n23 >>> 28;
        n6 = n23 & 0xFFFFFFF;
        n7 = n9 + (n7 >>> 28);
        n9 = n43 & 0xFFFFFFF;
        n11 = n42 + (n11 >>> 28);
        n23 = n41 & 0xFFFFFFF;
        n24 = n6 + (n40 >>> 28);
        int n44 = n40 & 0xFFFFFFF;
        nArray2[0] = n6;
        nArray2[1] = n5;
        nArray2[2] = n10;
        nArray2[3] = n8;
        nArray2[4] = n9;
        nArray2[5] = n7;
        nArray2[6] = n14;
        nArray2[7] = n12;
        nArray2[8] = n23;
        nArray2[9] = n11;
        nArray2[10] = n3;
        nArray2[11] = n22;
        nArray2[12] = n44;
        nArray2[13] = n24;
        nArray2[14] = n4;
        nArray[15] = n13;
    }

    public static void cmov(int n3, int[] nArray, int n4, int[] nArray2, int n5) {
        for (int i3 = 0; i3 < 16; ++i3) {
            int n6 = n5 + i3;
            int n7 = nArray2[n6];
            nArray2[n6] = n7 ^ (n7 ^ nArray[n4 + i3]) & n3;
        }
    }

    public static void cnegate(int n3, int[] nArray) {
        int[] nArray2 = X448Field.create();
        X448Field.sub(nArray2, nArray, nArray2);
        X448Field.cmov(-n3, nArray2, 0, nArray, 0);
    }

    public static void copy(int[] nArray, int n3, int[] nArray2, int n4) {
        for (int i3 = 0; i3 < 16; ++i3) {
            int n5 = n4 + i3;
            nArray2[n5] = nArray[n3 + i3];
        }
    }

    public static int[] create() {
        return new int[16];
    }

    public static int[] createTable(int n3) {
        return new int[n3 * 16];
    }

    public static void cswap(int n3, int[] nArray, int[] nArray2) {
        n3 = 0 - n3;
        for (int i3 = 0; i3 < 16; ++i3) {
            int n4 = nArray[i3];
            int n5 = nArray2[i3];
            int n6 = n4;
            n4 = n3 & (n4 ^ n5);
            nArray[i3] = n6 ^ n4;
            nArray2[i3] = n5 ^ n4;
        }
    }

    public static void decode(int[] nArray, int n3, int[] nArray2) {
        X448Field.decode224(nArray, n3, nArray2, 0);
        X448Field.decode224(nArray, n3 + 7, nArray2, 8);
    }

    public static void decode(byte[] byArray, int n3, int[] nArray) {
        X448Field.decode56(byArray, n3, nArray, 0);
        X448Field.decode56(byArray, n3 + 7, nArray, 2);
        X448Field.decode56(byArray, n3 + 14, nArray, 4);
        X448Field.decode56(byArray, n3 + 21, nArray, 6);
        X448Field.decode56(byArray, n3 + 28, nArray, 8);
        X448Field.decode56(byArray, n3 + 35, nArray, 10);
        X448Field.decode56(byArray, n3 + 42, nArray, 12);
        X448Field.decode56(byArray, n3 + 49, nArray, 14);
    }

    private static void decode224(int[] nArray, int n3, int[] nArray2, int n4) {
        int n5 = n3;
        int n6 = n3;
        int n7 = n3;
        int n8 = n3;
        int n9 = n3;
        int n10 = nArray[n3 + 0];
        n3 = nArray[n3 + 1];
        int n11 = nArray[n9 + 2];
        int n12 = nArray[n8 + 3];
        int n13 = nArray[n7 + 4];
        int n14 = nArray[n6 + 5];
        int n15 = nArray[n5 + 6];
        int n16 = n10;
        int n17 = n10;
        n10 = n4 + 0;
        nArray2[n10] = n17 & 0xFFFFFFF;
        n10 = n4 + 1;
        nArray2[n10] = (n16 >>> 28 | n3 << 4) & 0xFFFFFFF;
        n10 = n4 + 2;
        nArray2[n10] = (n3 >>> 24 | n11 << 8) & 0xFFFFFFF;
        n10 = n4 + 3;
        nArray2[n10] = (n11 >>> 20 | n12 << 12) & 0xFFFFFFF;
        n10 = n4 + 4;
        nArray2[n10] = (n12 >>> 16 | n13 << 16) & 0xFFFFFFF;
        n10 = n4 + 5;
        nArray2[n10] = (n13 >>> 12 | n14 << 20) & 0xFFFFFFF;
        n10 = n4 + 6;
        nArray2[n10] = (n14 >>> 8 | n15 << 24) & 0xFFFFFFF;
        n10 = n4 + 7;
        nArray2[n10] = n15 >>> 4;
    }

    private static int decode24(byte[] byArray, int n3) {
        return byArray[n3] & 0xFF | (byArray[++n3] & 0xFF) << 8 | (byArray[n3 + 1] & 0xFF) << 16;
    }

    private static int decode32(byte[] byArray, int n3) {
        int n4 = byArray[n3] & 0xFF;
        n3 = n3 + 1;
        return n4 | (byArray[n3] & 0xFF) << 8 | (byArray[++n3] & 0xFF) << 16 | byArray[n3 + 1] << 24;
    }

    private static void decode56(byte[] byArray, int n3, int[] nArray, int n4) {
        int n5 = X448Field.decode32(byArray, n3);
        int n6 = X448Field.decode24(byArray, n3 + 4);
        nArray[n4] = n5 & 0xFFFFFFF;
        n3 = n4 + 1;
        nArray[n3] = n5 >>> 28 | n6 << 4;
    }

    public static void encode(int[] nArray, int[] nArray2, int n3) {
        X448Field.encode224(nArray, 0, nArray2, n3);
        int n4 = n3 + 7;
        X448Field.encode224(nArray, 8, nArray2, n4);
    }

    public static void encode(int[] nArray, byte[] byArray, int n3) {
        int[] nArray2 = nArray;
        int[] nArray3 = nArray;
        X448Field.encode56(nArray2, 0, byArray, n3);
        int n4 = n3 + 7;
        X448Field.encode56(nArray3, 2, byArray, n4);
        n4 = n3 + 14;
        X448Field.encode56(nArray2, 4, byArray, n4);
        n4 = n3 + 21;
        X448Field.encode56(nArray3, 6, byArray, n4);
        n4 = n3 + 28;
        X448Field.encode56(nArray2, 8, byArray, n4);
        n4 = n3 + 35;
        X448Field.encode56(nArray3, 10, byArray, n4);
        n4 = n3 + 42;
        X448Field.encode56(nArray2, 12, byArray, n4);
        n4 = n3 + 49;
        X448Field.encode56(nArray3, 14, byArray, n4);
    }

    private static void encode224(int[] nArray, int n3, int[] nArray2, int n4) {
        int n5 = nArray[n3 + 0];
        int n6 = nArray[n3 + 1];
        int n7 = nArray[n3 + 2];
        int n8 = nArray[n3 + 3];
        int n9 = nArray[n3 + 4];
        int n10 = nArray[n3 + 5];
        int n11 = nArray[n3 + 6];
        int n12 = nArray[n3 + 7];
        n3 = n4 + 0;
        nArray2[n3] = n5 | n6 << 28;
        n3 = n4 + 1;
        nArray2[n3] = n6 >>> 4 | n7 << 24;
        n3 = n4 + 2;
        nArray2[n3] = n7 >>> 8 | n8 << 20;
        n3 = n4 + 3;
        nArray2[n3] = n8 >>> 12 | n9 << 16;
        n3 = n4 + 4;
        nArray2[n3] = n9 >>> 16 | n10 << 12;
        n3 = n4 + 5;
        nArray2[n3] = n10 >>> 20 | n11 << 8;
        n3 = n4 + 6;
        nArray2[n3] = n11 >>> 24 | n12 << 4;
    }

    private static void encode24(int n3, byte[] byArray, int n4) {
        int n5 = n3;
        int n6 = n3;
        byArray[n4] = (byte)n3;
        n3 = n4 + 1;
        byArray[n3] = (byte)(n6 >>> 8);
        byArray[++n3] = (byte)(n5 >>> 16);
    }

    private static void encode32(int n3, byte[] byArray, int n4) {
        int n5 = n3;
        int n6 = n3;
        int n7 = n3;
        byArray[n4] = (byte)n3;
        n3 = n4 + 1;
        byArray[n3] = (byte)(n7 >>> 8);
        byArray[++n3] = (byte)(n6 >>> 16);
        byArray[++n3] = (byte)(n5 >>> 24);
    }

    private static void encode56(int[] nArray, int n3, byte[] byArray, int n4) {
        int n5 = nArray[n3];
        int n6 = nArray[n3 + 1];
        X448Field.encode32(n5 | n6 << 28, byArray, n4);
        X448Field.encode24(n6 >>> 4, byArray, n4 + 4);
    }

    public static void inv(int[] nArray, int[] nArray2) {
        int[] nArray3 = X448Field.create();
        int[] nArray4 = new int[14];
        X448Field.copy(nArray, 0, nArray3, 0);
        X448Field.normalize(nArray3);
        X448Field.encode(nArray3, nArray4, 0);
        Mod.modOddInverse(P32, nArray4, nArray4);
        X448Field.decode(nArray4, 0, nArray2);
    }

    public static void invVar(int[] nArray, int[] nArray2) {
        int[] nArray3 = X448Field.create();
        int[] nArray4 = new int[14];
        X448Field.copy(nArray, 0, nArray3, 0);
        X448Field.normalize(nArray3);
        X448Field.encode(nArray3, nArray4, 0);
        Mod.modOddInverseVar(P32, nArray4, nArray4);
        X448Field.decode(nArray4, 0, nArray2);
    }

    public static int isZero(int[] nArray) {
        int n3 = 0;
        for (int i3 = 0; i3 < 16; ++i3) {
            n3 |= nArray[i3];
        }
        return (n3 >>> 1 | n3 & 1) - 1 >> 31;
    }

    public static boolean isZeroVar(int[] nArray) {
        return X448Field.isZero(nArray) != 0;
    }

    public static void mul(int[] nArray, int n3, int[] nArray2) {
        int n4 = nArray[0];
        int n5 = nArray[1];
        int n6 = nArray[2];
        int n7 = nArray[3];
        int n8 = nArray[4];
        int n9 = nArray[5];
        int n10 = nArray[6];
        int n11 = nArray[7];
        int n12 = nArray[8];
        int n13 = nArray[9];
        int n14 = nArray[10];
        int n15 = nArray[11];
        int n16 = nArray[12];
        int n17 = nArray[13];
        int n18 = nArray[14];
        int n19 = nArray[15];
        long l3 = n3;
        long l4 = (long)n5 * l3;
        n3 = (int)l4 & 0xFFFFFFF;
        long l5 = l4 >>> 28;
        long l6 = (long)n9 * l3;
        n5 = (int)l6 & 0xFFFFFFF;
        long l7 = l6 >>> 28;
        long l8 = (long)n13 * l3;
        n9 = (int)l8 & 0xFFFFFFF;
        long l9 = l8 >>> 28;
        long l10 = (long)n17 * l3;
        long l11 = l10 >>> 28;
        long l12 = (long)n6 * l3 + l5;
        nArray2[2] = (int)l12 & 0xFFFFFFF;
        l12 >>>= 28;
        long l13 = (long)n10 * l3 + l7;
        nArray2[6] = (int)l13 & 0xFFFFFFF;
        l13 >>>= 28;
        long l14 = (long)n14 * l3 + l9;
        nArray2[10] = (int)l14 & 0xFFFFFFF;
        l14 >>>= 28;
        l11 = (long)n18 * l3 + l11;
        nArray2[14] = (int)l11 & 0xFFFFFFF;
        l11 >>>= 28;
        l12 = (long)n7 * l3 + l12;
        nArray2[3] = (int)l12 & 0xFFFFFFF;
        l12 >>>= 28;
        long l15 = (long)n11 * l3 + l13;
        l13 = l15;
        nArray2[7] = (int)l13 & 0xFFFFFFF;
        l13 = (long)n15 * l3 + l14;
        nArray2[11] = (int)l13 & 0xFFFFFFF;
        l13 >>>= 28;
        l11 = (long)n19 * l3 + l11;
        nArray2[15] = (int)l11 & 0xFFFFFFF;
        l14 = (l15 >>> 28) + (l11 >>>= 28);
        l12 = (long)n8 * l3 + l12;
        nArray2[4] = (int)l12 & 0xFFFFFFF;
        l12 >>>= 28;
        l14 = (long)n12 * l3 + l14;
        nArray2[8] = (int)l14 & 0xFFFFFFF;
        l14 >>>= 28;
        l13 = (long)n16 * l3 + l13;
        nArray2[12] = (int)l13 & 0xFFFFFFF;
        l13 >>>= 28;
        l11 = (long)n4 * l3 + l11;
        nArray2[0] = (int)l11 & 0xFFFFFFF;
        nArray2[1] = n3 + (int)(l11 >>> 28);
        nArray2[5] = n5 + (int)l12;
        nArray2[9] = n9 + (int)l14;
        nArray2[13] = ((int)l10 & 0xFFFFFFF) + (int)l13;
    }

    public static void mul(int[] nArray, int[] nArray2, int[] nArray3) {
        long l3;
        int[] nArray4 = nArray3;
        int[] nArray5 = nArray3;
        int n3 = nArray[0];
        int n4 = n3;
        int n5 = nArray[1];
        int n6 = nArray[2];
        int n7 = nArray[3];
        int n8 = nArray[4];
        int n9 = nArray[5];
        int n10 = nArray[6];
        int n11 = nArray[7];
        int n12 = nArray[8];
        int n13 = nArray[9];
        int n14 = nArray[10];
        int n15 = nArray[11];
        int n16 = nArray[12];
        int n17 = nArray[13];
        int n18 = nArray[14];
        int n19 = nArray[15];
        int n20 = nArray2[0];
        int n21 = nArray2[1];
        int n22 = nArray2[2];
        int n23 = nArray2[3];
        int n24 = nArray2[4];
        int n25 = nArray2[5];
        int n26 = nArray2[6];
        int n27 = nArray2[7];
        int n28 = n4;
        int n29 = nArray2[8];
        n4 = nArray2[9];
        int n30 = nArray2[10];
        int n31 = nArray2[11];
        int n32 = nArray2[12];
        int n33 = nArray2[13];
        int n34 = nArray2[14];
        int n35 = nArray2[15];
        int n36 = n28 + n12;
        int n37 = n5 + n13;
        int n38 = n6 + n14;
        int n39 = n7 + n15;
        int n40 = n8 + n16;
        int n41 = n9 + n17;
        int n42 = n10 + n18;
        int n43 = n11 + n19;
        int n44 = n20 + n29;
        int n45 = n21 + n4;
        int n46 = n22 + n30;
        int n47 = n23 + n31;
        int n48 = n24 + n32;
        int n49 = n25 + n33;
        int n50 = n26 + n34;
        int n51 = n27 + n35;
        long l4 = n3;
        long l5 = n20;
        long l6 = l4 * l5;
        long l7 = n11;
        long l8 = n21;
        long l9 = l7 * l8;
        long l10 = n10;
        long l11 = n22;
        l9 = l10 * l11 + l9;
        long l12 = n9;
        long l13 = n23;
        l9 = l12 * l13 + l9;
        long l14 = n8;
        long l15 = n24;
        l9 = l14 * l15 + l9;
        long l16 = n7;
        long l17 = n25;
        l9 = l16 * l17 + l9;
        long l18 = n6;
        long l19 = n26;
        l9 = l18 * l19 + l9;
        long l20 = n5;
        long l21 = n27;
        long l22 = l20 * l21 + l9;
        long l23 = n12;
        long l24 = n29;
        long l25 = l23 * l24;
        long l26 = n19;
        l9 = n4;
        long l27 = l26 * l9;
        long l28 = n18;
        long l29 = n30;
        l27 = l28 * l29 + l27;
        long l30 = n17;
        long l31 = n31;
        l27 = l30 * l31 + l27;
        long l32 = n16;
        long l33 = n32;
        l27 = l32 * l33 + l27;
        long l34 = n15;
        long l35 = n33;
        l27 = l34 * l35 + l27;
        long l36 = n14;
        long l37 = n34;
        l27 = l36 * l37 + l27;
        long l38 = n13;
        long l39 = n35;
        long l40 = l38 * l39 + l27;
        long l41 = l25;
        l25 = n36;
        long l42 = n44;
        long l43 = l25 * l42;
        long l44 = n43;
        long l45 = n45;
        long l46 = l44 * l45;
        l27 = n42;
        long l47 = n46;
        l46 = l27 * l47 + l46;
        long l48 = n41;
        long l49 = n47;
        l46 = l48 * l49 + l46;
        long l50 = n40;
        long l51 = n48;
        l46 = l50 * l51 + l46;
        long l52 = n39;
        long l53 = n49;
        l46 = l52 * l53 + l46;
        long l54 = n38;
        long l55 = n50;
        l46 = l54 * l55 + l46;
        long l56 = n37;
        long l57 = n51;
        l46 = l56 * l57 + l46;
        long l58 = l22 = l6 + l41 + l46 - l22;
        n4 = (int)l58 & 0xFFFFFFF;
        l22 = l58 >>> 28;
        long l59 = l40 + l43 - l6 + l46;
        int n52 = (int)l59 & 0xFFFFFFF;
        l43 = l59 >>> 28;
        l46 = l20 * l5;
        l46 = l4 * l8 + l46;
        long l60 = l7 * l11;
        l60 = l10 * l13 + l60;
        l60 = l12 * l15 + l60;
        l60 = l14 * l17 + l60;
        l60 = l16 * l19 + l60;
        l60 = l18 * l21 + l60;
        long l61 = l38 * l24;
        l61 = l23 * l9 + l61;
        long l62 = l26 * l29;
        l62 = l28 * l31 + l62;
        l62 = l30 * l33 + l62;
        l62 = l32 * l35 + l62;
        l62 = l34 * l37 + l62;
        l62 = l36 * l39 + l62;
        long l63 = l56 * l42;
        l63 = l25 * l45 + l63;
        long l64 = l44 * l47;
        l64 = l27 * l49 + l64;
        l64 = l48 * l51 + l64;
        l64 = l50 * l53 + l64;
        l64 = l52 * l55 + l64;
        l64 = l54 * l57 + l64;
        long l65 = l46 + l61 + l64 - l60 + l22;
        l22 = l65;
        l22 >>>= 28;
        l43 = l62 + l63 - l46 + l64 + l43;
        long l66 = l25;
        long l67 = l23;
        long l68 = l24;
        long l69 = l21;
        long l70 = l17;
        long l71 = l13;
        long l72 = l8;
        long l73 = l7;
        long l74 = l5;
        long l75 = l23;
        long l76 = l24;
        long l77 = l7;
        long l78 = l21;
        long l79 = l17;
        long l80 = l13;
        long l81 = l8;
        long l82 = l5;
        long l83 = l23;
        long l84 = l24;
        long l85 = l21;
        long l86 = l7;
        long l87 = l13;
        long l88 = l8;
        long l89 = l5;
        long l90 = l23;
        long l91 = l24;
        long l92 = l21;
        long l93 = l7;
        long l94 = l8;
        long l95 = l5;
        long l96 = l23;
        long l97 = l24;
        long l98 = l21;
        long l99 = l7;
        long l100 = l5;
        long l101 = l24;
        l24 = l43 >>> 28;
        l5 = l18 * l5;
        l5 = l20 * l8 + l5;
        l5 = l4 * l11 + l5;
        long l102 = l7 * l13;
        l102 = l10 * l15 + l102;
        l102 = l12 * l17 + l102;
        l102 = l14 * l19 + l102;
        l102 = l16 * l21 + l102;
        long l103 = l36 * l101;
        l103 = l38 * l9 + l103;
        l103 = l23 * l29 + l103;
        l23 = l26 * l31;
        l23 = l28 * l33 + l23;
        l23 = l30 * l35 + l23;
        l23 = l32 * l37 + l23;
        long l104 = l34 * l39 + l23;
        long l105 = l103;
        l103 = l54 * l42;
        l103 = l56 * l45 + l103;
        l103 = l25 * l47 + l103;
        l23 = l44 * l49;
        l23 = l27 * l51 + l23;
        l23 = l48 * l53 + l23;
        l23 = l50 * l55 + l23;
        l23 = l52 * l57 + l23;
        long l106 = l102 = l5 + l105 + l23 - l102 + l22;
        int n53 = (int)l106 & 0xFFFFFFF;
        l7 = l106 >>> 28;
        long l107 = l104 + l103 - l5 + l23 + l24;
        int n54 = (int)l107 & 0xFFFFFFF;
        l5 = l107 >>> 28;
        l21 = l16 * l100;
        l21 = l18 * l8 + l21;
        l21 = l20 * l11 + l21;
        l21 = l4 * l13 + l21;
        l22 = l99 * l15;
        l22 = l10 * l17 + l22;
        l22 = l12 * l19 + l22;
        l22 = l14 * l98 + l22;
        l23 = l34 * l97;
        l23 = l36 * l9 + l23;
        l23 = l38 * l29 + l23;
        l23 = l96 * l31 + l23;
        l8 = l26 * l33;
        l8 = l28 * l35 + l8;
        l8 = l30 * l37 + l8;
        long l108 = l32 * l39 + l8;
        long l109 = l23;
        l23 = l52 * l42;
        l23 = l54 * l45 + l23;
        l23 = l56 * l47 + l23;
        l23 = l25 * l49 + l23;
        l8 = l44 * l51;
        l8 = l27 * l53 + l8;
        l8 = l48 * l55 + l8;
        l8 = l50 * l57 + l8;
        long l110 = l7 = l21 + l109 + l8 - l22 + l7;
        n29 = (int)l110 & 0xFFFFFFF;
        l7 = l110 >>> 28;
        long l111 = l108 + l23 - l21 + l8 + l5;
        int n55 = (int)l111 & 0xFFFFFFF;
        l21 = l111 >>> 28;
        l22 = l14 * l95;
        l22 = l16 * l94 + l22;
        l22 = l18 * l11 + l22;
        l22 = l20 * l13 + l22;
        l22 = l4 * l15 + l22;
        l23 = l93 * l17;
        l23 = l10 * l19 + l23;
        l23 = l12 * l92 + l23;
        l8 = l32 * l91;
        l8 = l34 * l9 + l8;
        l8 = l36 * l29 + l8;
        l8 = l38 * l31 + l8;
        l8 = l90 * l33 + l8;
        l13 = l26 * l35;
        l13 = l28 * l37 + l13;
        long l112 = l30 * l39 + l13;
        long l113 = l8;
        l8 = l50 * l42;
        l8 = l52 * l45 + l8;
        l8 = l54 * l47 + l8;
        l8 = l56 * l49 + l8;
        l8 = l25 * l51 + l8;
        l13 = l44 * l53;
        l13 = l27 * l55 + l13;
        l13 = l48 * l57 + l13;
        long l114 = l7 = l22 + l113 + l13 - l23 + l7;
        n7 = (int)l114 & 0xFFFFFFF;
        l7 = l114 >>> 28;
        long l115 = l112 + l8 - l22 + l13 + l21;
        int n56 = (int)l115 & 0xFFFFFFF;
        long l116 = l115 >>> 28;
        long l117 = l12 * l89;
        l117 = l14 * l88 + l117;
        l117 = l16 * l11 + l117;
        l117 = l18 * l87 + l117;
        l117 = l20 * l15 + l117;
        l117 = l4 * l17 + l117;
        l8 = l86 * l19;
        l8 = l10 * l85 + l8;
        l13 = l30 * l84;
        l13 = l32 * l9 + l13;
        l13 = l34 * l29 + l13;
        l13 = l36 * l31 + l13;
        l13 = l38 * l33 + l13;
        l13 = l83 * l35 + l13;
        l17 = l26 * l37;
        long l118 = l28 * l39 + l17;
        long l119 = l13;
        l13 = l48 * l42;
        l13 = l50 * l45 + l13;
        l13 = l52 * l47 + l13;
        l13 = l54 * l49 + l13;
        l13 = l56 * l51 + l13;
        l13 = l25 * l53 + l13;
        l17 = l44 * l55;
        l17 = l27 * l57 + l17;
        long l120 = l7 = l117 + l119 + l17 - l8 + l7;
        int n57 = (int)l120 & 0xFFFFFFF;
        l8 = l120 >>> 28;
        long l121 = l118 + l13 - l117 + l17 + l116;
        int n58 = (int)l121 & 0xFFFFFFF;
        l116 = l121 >>> 28;
        l117 = l10 * l82;
        l117 = l12 * l81 + l117;
        l117 = l14 * l11 + l117;
        l117 = l16 * l80 + l117;
        l117 = l18 * l15 + l117;
        l117 = l20 * l79 + l117;
        l117 = l4 * l19 + l117;
        l13 = l77 * l78;
        l17 = l28 * l76;
        l17 = l30 * l9 + l17;
        l17 = l32 * l29 + l17;
        l17 = l34 * l31 + l17;
        l17 = l36 * l33 + l17;
        l17 = l38 * l35 + l17;
        long l122 = l17 = l75 * l37 + l17;
        long l123 = l27 * l42;
        l123 = l48 * l45 + l123;
        l123 = l50 * l47 + l123;
        l123 = l52 * l49 + l123;
        l123 = l54 * l51 + l123;
        l123 = l56 * l53 + l123;
        l123 = l25 * l55 + l123;
        l17 = l44 * l57;
        long l124 = l3 = l117 + l122 + l17 - l13 + l8;
        int n59 = (int)l124 & 0xFFFFFFF;
        l25 = l124 >>> 28;
        long l125 = l26 * l39 + l123 - l117 + l17 + l116;
        int n60 = (int)l125 & 0xFFFFFFF;
        l22 = l125 >>> 28;
        l8 = l73 * l74;
        l8 = l10 * l72 + l8;
        l8 = l12 * l11 + l8;
        l8 = l14 * l71 + l8;
        l8 = l16 * l15 + l8;
        l8 = l18 * l70 + l8;
        l8 = l20 * l19 + l8;
        l8 = l4 * l69 + l8;
        l13 = l26 * l68;
        l13 = l28 * l9 + l13;
        l13 = l30 * l29 + l13;
        l13 = l32 * l31 + l13;
        l13 = l34 * l33 + l13;
        l13 = l36 * l35 + l13;
        l13 = l38 * l37 + l13;
        l13 = l67 * l39 + l13;
        l17 = l44 * l42;
        l17 = l27 * l45 + l17;
        l17 = l48 * l47 + l17;
        l17 = l50 * l49 + l17;
        l17 = l52 * l51 + l17;
        l17 = l54 * l53 + l17;
        l17 = l56 * l55 + l17;
        long l126 = l8;
        long l127 = l126 + l13 + l25;
        int n61 = (int)l127 & 0xFFFFFFF;
        l25 = l127 >>> 28;
        long l128 = l66 * l57 + l17 - l126 + l22;
        int n62 = (int)l128 & 0xFFFFFFF;
        l8 = l128 >>> 28;
        int n63 = n4;
        long l129 = l25 + l8 + (long)n52;
        n4 = (int)l129 & 0xFFFFFFF;
        l25 = l129 >>> 28;
        long l130 = l25;
        long l131 = l8 += (long)n63;
        n52 = (int)l131 & 0xFFFFFFF;
        l25 = l131 >>> 28;
        int n64 = ((int)l43 & 0xFFFFFFF) + (int)l130;
        int n65 = ((int)l65 & 0xFFFFFFF) + (int)l25;
        nArray4[0] = n52;
        nArray5[1] = n65;
        nArray4[2] = n53;
        nArray5[3] = n29;
        nArray4[4] = n7;
        nArray5[5] = n57;
        nArray4[6] = n59;
        nArray5[7] = n61;
        nArray4[8] = n4;
        nArray5[9] = n64;
        nArray4[10] = n54;
        nArray5[11] = n55;
        nArray4[12] = n56;
        nArray5[13] = n58;
        nArray4[14] = n60;
        nArray5[15] = n62;
    }

    public static void negate(int[] nArray, int[] nArray2) {
        X448Field.sub(X448Field.create(), nArray, nArray2);
    }

    public static void normalize(int[] nArray) {
        X448Field.reduce(nArray, 1);
        X448Field.reduce(nArray, -1);
    }

    public static void one(int[] nArray) {
        nArray[0] = 1;
        for (int i3 = 1; i3 < 16; ++i3) {
            nArray[i3] = 0;
        }
    }

    private static void powPm3d4(int[] nArray, int[] nArray2) {
        int[] nArray3 = nArray;
        int[] nArray4 = nArray;
        int[] nArray5 = X448Field.create();
        X448Field.sqr(nArray3, nArray5);
        X448Field.mul(nArray4, nArray5, nArray5);
        int[] nArray6 = X448Field.create();
        X448Field.sqr(nArray5, nArray6);
        X448Field.mul(nArray, nArray6, nArray6);
        int[] nArray7 = X448Field.create();
        nArray = nArray7;
        X448Field.sqr(nArray6, 3, nArray);
        X448Field.mul(nArray6, nArray, nArray);
        nArray = X448Field.create();
        X448Field.sqr(nArray7, 3, nArray);
        X448Field.mul(nArray6, nArray, nArray);
        nArray5 = X448Field.create();
        X448Field.sqr(nArray, 9, nArray5);
        X448Field.mul(nArray, nArray5, nArray5);
        nArray = X448Field.create();
        X448Field.sqr(nArray5, nArray);
        X448Field.mul(nArray3, nArray, nArray);
        nArray6 = X448Field.create();
        X448Field.sqr(nArray, 18, nArray6);
        X448Field.mul(nArray5, nArray6, nArray6);
        int[] nArray8 = X448Field.create();
        nArray = nArray8;
        X448Field.sqr(nArray6, 37, nArray);
        X448Field.mul(nArray6, nArray, nArray);
        nArray = X448Field.create();
        X448Field.sqr(nArray8, 37, nArray);
        X448Field.mul(nArray6, nArray, nArray);
        nArray5 = X448Field.create();
        X448Field.sqr(nArray, 111, nArray5);
        X448Field.mul(nArray, nArray5, nArray5);
        nArray = X448Field.create();
        X448Field.sqr(nArray5, nArray);
        X448Field.mul(nArray4, nArray, nArray);
        nArray6 = X448Field.create();
        X448Field.sqr(nArray, 223, nArray6);
        X448Field.mul(nArray6, nArray5, nArray2);
    }

    private static void reduce(int[] nArray, int n3) {
        int n4 = nArray[15];
        int n5 = n4 & 0xFFFFFFF;
        long l3 = (n4 >>> 28) + n3;
        long l4 = l3;
        for (n3 = 0; n3 < 8; ++n3) {
            nArray[n3] = (int)(l4 += (long)nArray[n3] & 0xFFFFFFFFL) & 0xFFFFFFF;
            l4 >>= 28;
        }
        l3 = l4 + l3;
        for (n3 = 8; n3 < 15; ++n3) {
            nArray[n3] = (int)(l3 += (long)nArray[n3] & 0xFFFFFFFFL) & 0xFFFFFFF;
            l3 >>= 28;
        }
        nArray[15] = n5 + (int)l3;
    }

    public static void sqr(int[] nArray, int[] nArray2) {
        long l3;
        long l4;
        int[] nArray3 = nArray2;
        int[] nArray4 = nArray2;
        int n3 = nArray[0];
        int n4 = nArray[1];
        int n5 = n4;
        int n6 = nArray[2];
        int n7 = nArray[3];
        int n8 = nArray[4];
        int n9 = nArray[5];
        int n10 = nArray[6];
        int n11 = nArray[7];
        int n12 = nArray[8];
        int n13 = nArray[9];
        int n14 = nArray[10];
        int n15 = nArray[11];
        int n16 = nArray[12];
        int n17 = n16;
        int n18 = nArray[13];
        int n19 = n18;
        int n20 = nArray[14];
        int n21 = n20;
        int n22 = nArray[15];
        int n23 = n22;
        int n24 = n12;
        int n25 = n8;
        int n26 = n9;
        int n27 = n10;
        int n28 = n11;
        int n29 = n3;
        int n30 = n10;
        int n31 = n21;
        int n32 = n9;
        int n33 = n19;
        int n34 = n8;
        int n35 = n17;
        int n36 = n5;
        int n37 = n3;
        int n38 = n12;
        int n39 = n21;
        int n40 = n19;
        int n41 = n17;
        int n42 = n12;
        int n43 = n10;
        int n44 = n9;
        int n45 = n8;
        n3 *= 2;
        n5 *= 2;
        n8 = n6 * 2;
        n9 = n7 * 2;
        n10 = n45 * 2;
        n12 = n44 * 2;
        n17 = n43 * 2;
        n19 = n42 * 2;
        n21 = n13 * 2;
        int n46 = n14 * 2;
        int n47 = n15 * 2;
        int n48 = n41 * 2;
        int n49 = n40 * 2;
        int n50 = n39 * 2;
        int n51 = n37 + n38;
        int n52 = n36 + n13;
        int n53 = n6 + n14;
        int n54 = n7 + n15;
        int n55 = n34 + n35;
        int n56 = n32 + n33;
        int n57 = n30 + n31;
        n23 = n11 + n23;
        n11 = n51 * 2;
        int n58 = n52 * 2;
        int n59 = n53 * 2;
        int n60 = n54 * 2;
        int n61 = n55 * 2;
        int n62 = n56 * 2;
        int n63 = n57 * 2;
        long l5 = n29;
        long l6 = l5 * l5;
        long l7 = n28;
        long l8 = n5;
        long l9 = l7 * l8;
        long l10 = n27;
        long l11 = n8;
        l9 = l10 * l11 + l9;
        long l12 = n26;
        long l13 = n9;
        l9 = l12 * l13 + l9;
        long l14 = n25;
        l9 = l14 * l14 + l9;
        long l15 = n24;
        long l16 = l15 * l15;
        long l17 = n22;
        long l18 = n21;
        long l19 = l17 * l18;
        long l20 = n20;
        long l21 = n46;
        l19 = l20 * l21 + l19;
        long l22 = n18;
        long l23 = n47;
        l19 = l22 * l23 + l19;
        long l24 = n16;
        long l25 = l24 * l24 + l19;
        long l26 = l16;
        long l27 = n51;
        long l28 = l27 * l27;
        l16 = n23;
        long l29 = (long)n58 & 0xFFFFFFFFL;
        l19 = l16 * l29;
        long l30 = n57;
        long l31 = (long)n59 & 0xFFFFFFFFL;
        l19 = l30 * l31 + l19;
        long l32 = n56;
        long l33 = (long)n60 & 0xFFFFFFFFL;
        l19 = l32 * l33 + l19;
        long l34 = n55;
        l19 = l34 * l34 + l19;
        l9 = l6 + l26 + l19 - l9;
        long l35 = l28;
        long l36 = l9;
        n23 = (int)l36 & 0xFFFFFFF;
        l28 = l36 >>> 28;
        long l37 = l25 + l35 - l6 + l19;
        n5 = (int)l37 & 0xFFFFFFF;
        l6 = l37 >>> 28;
        l9 = n4;
        l19 = n3;
        long l38 = l9 * l19;
        long l39 = l7 * l11;
        l39 = l10 * l13 + l39;
        long l40 = n10;
        l39 = l12 * l40 + l39;
        long l41 = n13;
        long l42 = n19;
        long l43 = l41 * l42;
        long l44 = l17 * l21;
        l44 = l20 * l23 + l44;
        long l45 = n48;
        l44 = l22 * l45 + l44;
        long l46 = n52;
        long l47 = (long)n11 & 0xFFFFFFFFL;
        long l48 = l46 * l47;
        long l49 = l16 * l31;
        l49 = l30 * l33 + l49;
        long l50 = (long)n61 & 0xFFFFFFFFL;
        l49 = l32 * l50 + l49;
        long l51 = l38 + l43 + l49 - l39 + l28;
        l39 = l51;
        l39 >>>= 28;
        long l52 = l44 + l48 - l38 + l49 + l6;
        l28 = l52;
        long l53 = l33;
        long l54 = l47;
        long l55 = l23;
        long l56 = l21;
        long l57 = l13;
        long l58 = l17;
        long l59 = l40;
        long l60 = l28 >>> 28;
        l28 = n6;
        long l61 = l22;
        long l62 = l41;
        long l63 = l12;
        long l64 = l9;
        long l65 = l28 * l19;
        l65 = l64 * l64 + l65;
        l13 = l7 * l13;
        l13 = l10 * l40 + l13;
        l13 = l63 * l63 + l13;
        long l66 = n14;
        l40 = l66 * l42;
        l40 = l62 * l62 + l40;
        l6 = l17 * l23;
        l6 = l20 * l45 + l6;
        long l67 = l61 * l61 + l6;
        long l68 = l40;
        long l69 = l32;
        long l70 = l33;
        long l71 = l46;
        l40 = n53;
        l33 = l40 * l47;
        l33 = l71 * l71 + l33;
        l6 = l16 * l70;
        l6 = l30 * l50 + l6;
        l6 = l69 * l69 + l6;
        long l72 = l13 = l65 + l68 + l6 - l13 + l39;
        n3 = (int)l72 & 0xFFFFFFF;
        l13 = l72 >>> 28;
        long l73 = l67 + l33 - l65 + l6 + l60;
        int n64 = (int)l73 & 0xFFFFFFF;
        l60 = l73 >>> 28;
        l39 = n7;
        l33 = l39 * l19;
        l33 = l28 * l8 + l33;
        l6 = l7 * l59;
        l9 = n12;
        l6 = l10 * l9 + l6;
        l23 = n15;
        long l74 = l21;
        long l75 = l7;
        long l76 = l39;
        long l77 = l21;
        long l78 = l39;
        long l79 = l20;
        long l80 = l66;
        long l81 = l10;
        long l82 = l28;
        long l83 = l39;
        long l84 = l66;
        l66 = l23 * l42;
        l66 = l84 * l18 + l66;
        long l85 = l17 * l45;
        l21 = n49;
        long l86 = l20 * l21 + l85;
        long l87 = l66;
        l66 = n54;
        l85 = l66 * l47;
        l85 = l40 * l29 + l85;
        l39 = l16 * l50;
        long l88 = (long)n62 & 0xFFFFFFFFL;
        l39 = l30 * l88 + l39;
        long l89 = l4 = l33 + l87 + l39 - l6 + l13;
        int n65 = (int)l89 & 0xFFFFFFF;
        l13 = l89 >>> 28;
        long l90 = l86 + l85 - l33 + l39 + l60;
        int n66 = (int)l90 & 0xFFFFFFF;
        l85 = l90 >>> 28;
        l39 = l14 * l19;
        l39 = l83 * l8 + l39;
        l39 = l82 * l82 + l39;
        long l91 = l7 * l9;
        l91 = l81 * l81 + l91;
        l28 = l24 * l42;
        l28 = l23 * l18 + l28;
        l28 = l80 * l80 + l28;
        l21 = l17 * l21;
        long l92 = l79 * l79 + l21;
        long l93 = l30;
        long l94 = l40;
        l21 = l34 * l47;
        l21 = l66 * l29 + l21;
        l21 = l94 * l94 + l21;
        l88 = l16 * l88;
        l88 = l93 * l93 + l88;
        l13 = l39 + l28 + l88 - l91 + l13;
        long l95 = l21;
        long l96 = l13;
        int n67 = (int)l96 & 0xFFFFFFF;
        l21 = l96 >>> 28;
        long l97 = l92 + l95 - l39 + l88 + l85;
        n9 = (int)l97 & 0xFFFFFFF;
        l85 = l97 >>> 28;
        l39 = l12 * l19;
        l39 = l14 * l8 + l39;
        l39 = l78 * l11 + l39;
        l88 = l7 * (long)n17;
        l40 = l22 * l42;
        l40 = l24 * l18 + l40;
        long l98 = l40 = l23 * l77 + l40;
        l40 = l32 * l47;
        l40 = l34 * l29 + l40;
        l40 = l66 * l31 + l40;
        l91 = l16 * ((long)n63 & 0xFFFFFFFFL);
        long l99 = l21 = l39 + l98 + l91 - l88 + l21;
        n13 = (int)l99 & 0xFFFFFFF;
        l21 = l99 >>> 28;
        long l100 = l17 * (long)n50 + l40 - l39 + l91 + l85;
        int n68 = (int)l100 & 0xFFFFFFF;
        l39 = l100 >>> 28;
        l88 = l10 * l19;
        l88 = l12 * l8 + l88;
        l88 = l14 * l11 + l88;
        l88 = l76 * l76 + l88;
        l40 = l75 * l75;
        l91 = l20 * l42;
        l91 = l22 * l18 + l91;
        l91 = l24 * l74 + l91;
        l91 = l23 * l23 + l91;
        long l101 = l16;
        long l102 = l66;
        l47 = l30 * l47;
        l47 = l32 * l29 + l47;
        l47 = l34 * l31 + l47;
        l47 = l102 * l102 + l47;
        l66 = l101 * l101;
        long l103 = l3 = l88 + l91 + l66 - l40 + l21;
        int n69 = (int)l103 & 0xFFFFFFF;
        l3 = l103 >>> 28;
        long l104 = l58 * l58 + l47 - l88 + l66 + l39;
        n11 = (int)l104 & 0xFFFFFFF;
        l66 = l104 >>> 28;
        long l105 = l7 * l19;
        l105 = l10 * l8 + l105;
        l105 = l12 * l11 + l105;
        l105 = l14 * l57 + l105;
        long l106 = l17 * l42;
        l106 = l20 * l18 + l106;
        l106 = l22 * l56 + l106;
        l106 = l24 * l55 + l106;
        long l107 = l16 * l54;
        l107 = l30 * l29 + l107;
        l107 = l32 * l31 + l107;
        long l108 = l105;
        long l109 = l108 + l106 + l3;
        int n70 = (int)l109 & 0xFFFFFFF;
        l21 = l109 >>> 28;
        long l110 = l34 * l53 + l107 - l108 + l66;
        int n71 = (int)l110 & 0xFFFFFFF;
        l39 = l110 >>> 28;
        int n72 = n23;
        long l111 = l21 + l39 + (long)n5;
        n23 = (int)l111 & 0xFFFFFFF;
        l21 = l111 >>> 28;
        long l112 = l21;
        long l113 = l39 += (long)n72;
        n5 = (int)l113 & 0xFFFFFFF;
        l21 = l113 >>> 28;
        n15 = ((int)l52 & 0xFFFFFFF) + (int)l112;
        int n73 = ((int)l51 & 0xFFFFFFF) + (int)l21;
        nArray3[0] = n5;
        nArray4[1] = n73;
        nArray3[2] = n3;
        nArray4[3] = n65;
        nArray3[4] = n67;
        nArray4[5] = n13;
        nArray3[6] = n69;
        nArray4[7] = n70;
        nArray3[8] = n23;
        nArray4[9] = n15;
        nArray3[10] = n64;
        nArray4[11] = n66;
        nArray3[12] = n9;
        nArray4[13] = n68;
        nArray3[14] = n11;
        nArray4[15] = n71;
    }

    public static void sqr(int[] nArray, int n3, int[] nArray2) {
        X448Field.sqr(nArray, nArray2);
        while ((n3 += -1) > 0) {
            X448Field.sqr(nArray2, nArray2);
        }
    }

    public static boolean sqrtRatioVar(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = X448Field.create();
        int[] nArray5 = X448Field.create();
        X448Field.sqr(nArray, nArray4);
        X448Field.mul(nArray4, nArray2, nArray4);
        X448Field.sqr(nArray4, nArray5);
        X448Field.mul(nArray4, nArray, nArray4);
        X448Field.mul(nArray5, nArray, nArray5);
        X448Field.mul(nArray5, nArray2, nArray5);
        int[] nArray6 = X448Field.create();
        X448Field.powPm3d4(nArray5, nArray6);
        X448Field.mul(nArray6, nArray4, nArray6);
        nArray4 = X448Field.create();
        X448Field.sqr(nArray6, nArray4);
        X448Field.mul(nArray4, nArray2, nArray4);
        X448Field.sub(nArray, nArray4, nArray4);
        X448Field.normalize(nArray4);
        if (X448Field.isZeroVar(nArray4)) {
            X448Field.copy(nArray6, 0, nArray3, 0);
            return true;
        }
        return false;
    }

    public static void sub(int[] nArray, int[] nArray2, int[] nArray3) {
        int n3;
        int[] nArray4 = nArray3;
        int[] nArray5 = nArray3;
        int n4 = nArray[0];
        int n5 = nArray[1];
        int n6 = nArray[2];
        int n7 = nArray[3];
        int n8 = nArray[4];
        int n9 = nArray[5];
        int n10 = nArray[6];
        int n11 = nArray[7];
        int n12 = nArray[8];
        int n13 = nArray[9];
        int n14 = nArray[10];
        int n15 = n3 = nArray[11];
        int n16 = n14;
        int n17 = n13;
        int n18 = n12;
        int n19 = n11;
        int n20 = n10;
        int n21 = n9;
        int n22 = n8;
        int n23 = n7;
        int n24 = n6;
        int n25 = n5;
        int n26 = n4;
        int n27 = nArray[13];
        int n28 = nArray[14];
        n4 = nArray[15];
        n5 = nArray2[0];
        n6 = nArray2[1];
        n7 = nArray2[2];
        n8 = nArray2[3];
        n9 = nArray2[4];
        n10 = nArray2[5];
        n11 = nArray2[6];
        n12 = nArray2[7];
        n13 = nArray2[8];
        n14 = nArray2[9];
        n3 = nArray2[10];
        int n29 = nArray2[11];
        int n30 = nArray2[12];
        int n31 = nArray2[13];
        int n32 = nArray2[14];
        int n33 = nArray2[15];
        n5 = n26 + 0x1FFFFFFE - n5;
        n6 = n25 + 0x1FFFFFFE - n6;
        n7 = n24 + 0x1FFFFFFE - n7;
        n8 = n23 + 0x1FFFFFFE - n8;
        n9 = n22 + 0x1FFFFFFE - n9;
        n10 = n21 + 0x1FFFFFFE - n10;
        n11 = n20 + 0x1FFFFFFE - n11;
        n12 = n19 + 0x1FFFFFFE - n12;
        n13 = n18 + 0x1FFFFFFC - n13;
        n14 = n17 + 0x1FFFFFFE - n14;
        n3 = n16 + 0x1FFFFFFE - n3;
        n29 = n15 + 0x1FFFFFFE - n29;
        int n34 = n10;
        int n35 = n6;
        n27 = n27 + 0x1FFFFFFE - n31;
        n28 = n28 + 0x1FFFFFFE - n32;
        n4 = n4 + 0x1FFFFFFE - n33;
        n6 = n7 + (n6 >>> 28);
        n7 = n35 & 0xFFFFFFF;
        n10 = n11 + (n10 >>> 28);
        n11 = n34 & 0xFFFFFFF;
        n3 += n14 >>> 28;
        int n36 = n10;
        int n37 = n10;
        int n38 = n6;
        int n39 = n6;
        int n40 = n27;
        int n41 = n27;
        n27 = n14 & 0xFFFFFFF;
        n28 += n41 >>> 28;
        n6 = n40 & 0xFFFFFFF;
        n8 += n39 >>> 28;
        n10 = n38 & 0xFFFFFFF;
        n12 += n37 >>> 28;
        n14 = n36 & 0xFFFFFFF;
        n29 += n3 >>> 28;
        int n42 = n13;
        int n43 = n5;
        int n44 = n4;
        n4 = n3 & 0xFFFFFFF;
        int n45 = n44 + (n28 >>> 28);
        n28 &= 0xFFFFFFF;
        n5 = n45 >>> 28;
        n13 = n45 & 0xFFFFFFF;
        n3 = n43 + n5;
        int n46 = n42 + n5;
        n5 = n9 + (n8 >>> 28);
        n8 &= 0xFFFFFFF;
        n9 = n46 + (n12 >>> 28);
        n12 &= 0xFFFFFFF;
        int n47 = nArray[12] + 0x1FFFFFFE - n30 + (n29 >>> 28);
        int n48 = n9;
        int n49 = n27;
        int n50 = n9;
        int n51 = n5;
        int n52 = n5;
        n27 = n29 & 0xFFFFFFF;
        n5 = n7 + (n3 >>> 28);
        n6 = n3 & 0xFFFFFFF;
        n7 = n11 + (n52 >>> 28);
        n9 = n51 & 0xFFFFFFF;
        n11 = n49 + (n50 >>> 28);
        n3 = n48 & 0xFFFFFFF;
        n29 = n6 + (n47 >>> 28);
        n30 = n47 & 0xFFFFFFF;
        nArray4[0] = n6;
        nArray5[1] = n5;
        nArray4[2] = n10;
        nArray5[3] = n8;
        nArray4[4] = n9;
        nArray5[5] = n7;
        nArray4[6] = n14;
        nArray5[7] = n12;
        nArray4[8] = n3;
        nArray5[9] = n11;
        nArray4[10] = n4;
        nArray5[11] = n27;
        nArray4[12] = n30;
        nArray5[13] = n29;
        nArray4[14] = n28;
        nArray5[15] = n13;
    }

    public static void subOne(int[] nArray) {
        int[] nArray2 = X448Field.create();
        int[] nArray3 = nArray2;
        nArray2[0] = 1;
        X448Field.sub(nArray, nArray3, nArray);
    }

    public static void zero(int[] nArray) {
        for (int i3 = 0; i3 < 16; ++i3) {
            nArray[i3] = 0;
        }
    }
}

