/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.rfc8032;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA512Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.rfc7748.X25519;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.rfc7748.X25519Field;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Interleave;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat256;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public abstract class Ed25519 {
    private static final long M08L = 255L;
    private static final long M28L = 0xFFFFFFFL;
    private static final long M32L = 0xFFFFFFFFL;
    private static final int POINT_BYTES = 32;
    private static final int SCALAR_INTS = 8;
    private static final int SCALAR_BYTES = 32;
    public static final int PREHASH_SIZE = 64;
    public static final int PUBLIC_KEY_SIZE = 32;
    public static final int SECRET_KEY_SIZE = 32;
    public static final int SIGNATURE_SIZE = 64;
    private static final byte[] DOM2_PREFIX = new byte[]{83, 105, 103, 69, 100, 50, 53, 53, 49, 57, 32, 110, 111, 32, 69, 100, 50, 53, 53, 49, 57, 32, 99, 111, 108, 108, 105, 115, 105, 111, 110, 115};
    private static final int[] P = new int[]{-19, -1, -1, -1, -1, -1, -1, Integer.MAX_VALUE};
    private static final int[] L = new int[]{1559614445, 1477600026, -1560830762, 350157278, 0, 0, 0, 0x10000000};
    private static final int L0 = -50998291;
    private static final int L1 = 19280294;
    private static final int L2 = 127719000;
    private static final int L3 = -6428113;
    private static final int L4 = 5343;
    private static final int[] B_x = new int[]{52811034, 25909283, 8072341, 50637101, 13785486, 30858332, 20483199, 20966410, 43936626, 4379245};
    private static final int[] B_y = new int[]{40265304, 0x1999999, 0x666666, 0x3333333, 0xCCCCCC, 0x2666666, 0x1999999, 0x666666, 0x3333333, 0xCCCCCC};
    private static final int[] C_d = new int[]{56195235, 47411844, 25868126, 40503822, 57364, 58321048, 30416477, 31930572, 57760639, 10749657};
    private static final int[] C_d2 = new int[]{45281625, 27714825, 18181821, 0xD4141D, 114729, 49533232, 60832955, 30306712, 48412415, 4722099};
    private static final int[] C_d4 = new int[]{23454386, 55429651, 2809210, 27797563, 229458, 31957600, 54557047, 27058993, 29715967, 9444199};
    private static final int WNAF_WIDTH_BASE = 7;
    private static final int PRECOMP_BLOCKS = 8;
    private static final int PRECOMP_TEETH = 4;
    private static final int PRECOMP_SPACING = 8;
    private static final int PRECOMP_POINTS = 8;
    private static final int PRECOMP_MASK = 7;
    private static final Object precompLock = new Object();
    private static PointExt[] precompBaseTable;
    private static int[] precompBase;

    private static byte[] calculateS(byte[] byArray, byte[] objectArray, byte[] byArray2) {
        int n3 = 16;
        int[] nArray = new int[16];
        Ed25519.decodeScalar(byArray, 0, nArray);
        int[] nArray2 = new int[8];
        Ed25519.decodeScalar(objectArray, 0, nArray2);
        objectArray = new int[8];
        Ed25519.decodeScalar(byArray2, 0, objectArray);
        Nat256.mulAddTo(nArray2, objectArray, nArray);
        objectArray = new byte[64];
        for (int i3 = 0; i3 < n3; ++i3) {
            Ed25519.encode32(nArray[i3], objectArray, i3 * 4);
        }
        return Ed25519.reduceScalar(objectArray);
    }

    private static boolean checkContextVar(byte[] byArray, byte by) {
        return byArray == null && by == 0 || byArray != null && byArray.length < 256;
    }

    private static int checkPoint(int[] nArray, int[] nArray2) {
        int[] nArray3 = X25519Field.create();
        int[] nArray4 = X25519Field.create();
        int[] nArray5 = X25519Field.create();
        X25519Field.sqr(nArray, nArray4);
        X25519Field.sqr(nArray2, nArray5);
        X25519Field.mul(nArray4, nArray5, nArray3);
        X25519Field.sub(nArray5, nArray4, nArray5);
        X25519Field.mul(nArray3, C_d, nArray3);
        X25519Field.addOne(nArray3);
        X25519Field.sub(nArray3, nArray5, nArray3);
        X25519Field.normalize(nArray3);
        return X25519Field.isZero(nArray3);
    }

    private static int checkPoint(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = X25519Field.create();
        int[] nArray5 = X25519Field.create();
        int[] nArray6 = X25519Field.create();
        int[] nArray7 = X25519Field.create();
        X25519Field.sqr(nArray, nArray5);
        X25519Field.sqr(nArray2, nArray6);
        X25519Field.sqr(nArray3, nArray7);
        X25519Field.mul(nArray5, nArray6, nArray4);
        X25519Field.sub(nArray6, nArray5, nArray6);
        X25519Field.mul(nArray6, nArray7, nArray6);
        X25519Field.sqr(nArray7, nArray7);
        X25519Field.mul(nArray4, C_d, nArray4);
        X25519Field.add(nArray4, nArray7, nArray4);
        X25519Field.sub(nArray4, nArray6, nArray4);
        X25519Field.normalize(nArray4);
        return X25519Field.isZero(nArray4);
    }

    private static boolean checkPointVar(byte[] byArray) {
        int[] nArray = new int[8];
        int[] nArray2 = nArray;
        Ed25519.decode32(byArray, 0, nArray2, 0, 8);
        nArray[7] = nArray[7] & Integer.MAX_VALUE;
        return Nat256.gte(nArray, P) ^ true;
    }

    private static boolean checkScalarVar(byte[] byArray) {
        int[] nArray = new int[8];
        Ed25519.decodeScalar(byArray, 0, nArray);
        return Nat256.gte(nArray, L) ^ true;
    }

    private static Digest createDigest() {
        return new SHA512Digest();
    }

    public static Digest createPrehash() {
        return Ed25519.createDigest();
    }

    private static int decode24(byte[] byArray, int n3) {
        return byArray[n3] & 0xFF | (byArray[++n3] & 0xFF) << 8 | (byArray[n3 + 1] & 0xFF) << 16;
    }

    private static int decode32(byte[] byArray, int n3) {
        int n4 = byArray[n3] & 0xFF;
        n3 = n3 + 1;
        return n4 | (byArray[n3] & 0xFF) << 8 | (byArray[++n3] & 0xFF) << 16 | byArray[n3 + 1] << 24;
    }

    private static void decode32(byte[] byArray, int n3, int[] nArray, int n4, int n5) {
        for (int i3 = 0; i3 < n5; ++i3) {
            int n6 = n4 + i3;
            nArray[n6] = Ed25519.decode32(byArray, i3 * 4 + n3);
        }
    }

    private static boolean decodePointVar(byte[] byArray, int n3, boolean bl, PointAffine pointAffine) {
        int n4 = n3;
        if (!Ed25519.checkPointVar(byArray = Arrays.copyOfRange(byArray, n4, n4 + 32))) {
            return false;
        }
        byte by = byArray[31];
        int n5 = (by & 0x80) >>> 7;
        byArray[31] = (byte)(by & 0x7F);
        X25519Field.decode(byArray, 0, pointAffine.y);
        int[] nArray = X25519Field.create();
        int[] nArray2 = X25519Field.create();
        X25519Field.sqr(pointAffine.y, nArray);
        X25519Field.mul(C_d, nArray, nArray2);
        X25519Field.subOne(nArray);
        X25519Field.addOne(nArray2);
        if (!X25519Field.sqrtRatioVar(nArray, nArray2, pointAffine.x)) {
            return false;
        }
        X25519Field.normalize(pointAffine.x);
        if (n5 == 1 && X25519Field.isZeroVar(pointAffine.x)) {
            return false;
        }
        int[] nArray3 = pointAffine.x;
        boolean bl2 = n5 != (pointAffine.x[0] & 1);
        if (bl ^ bl2) {
            X25519Field.negate(nArray3, nArray3);
        }
        return true;
    }

    private static void decodeScalar(byte[] byArray, int n3, int[] nArray) {
        Ed25519.decode32(byArray, n3, nArray, 0, 8);
    }

    private static void dom2(Digest object, byte by, byte[] byArray) {
        if (byArray != null) {
            Digest digest = object;
            object = DOM2_PREFIX;
            int n3 = DOM2_PREFIX.length;
            int n4 = n3 + 2;
            int n5 = n4 + byArray.length;
            byte[] byArray2 = new byte[n5];
            byte[] byArray3 = byArray2;
            System.arraycopy(object, 0, byArray3, 0, n3);
            byArray3[n3] = by;
            byArray2[n3 + 1] = (byte)byArray.length;
            int n6 = byArray.length;
            System.arraycopy(byArray, 0, byArray3, n4, n6);
            digest.update(byArray3, 0, n5);
        }
    }

    private static void encode24(int n3, byte[] byArray, int n4) {
        int n5 = n3;
        int n6 = n3;
        byArray[n4] = (byte)n3;
        n3 = n4 + 1;
        byArray[n3] = (byte)(n6 >>> 8);
        byArray[++n3] = (byte)(n5 >>> 16);
    }

    private static void encode32(int n3, byte[] byArray, int n4) {
        int n5 = n3;
        int n6 = n3;
        int n7 = n3;
        byArray[n4] = (byte)n3;
        n3 = n4 + 1;
        byArray[n3] = (byte)(n7 >>> 8);
        byArray[++n3] = (byte)(n6 >>> 16);
        byArray[++n3] = (byte)(n5 >>> 24);
    }

    private static void encode56(long l3, byte[] byArray, int n3) {
        long l4 = l3;
        Ed25519.encode32((int)l4, byArray, n3);
        Ed25519.encode24((int)(l4 >>> 32), byArray, n3 + 4);
    }

    private static int encodePoint(PointAccum pointAccum, byte[] byArray, int n3) {
        int[] nArray = X25519Field.create();
        int[] nArray2 = X25519Field.create();
        PointAccum pointAccum2 = pointAccum;
        X25519Field.inv(pointAccum2.z, nArray2);
        X25519Field.mul(pointAccum2.x, nArray2, nArray);
        X25519Field.mul(pointAccum2.y, nArray2, nArray2);
        X25519Field.normalize(nArray);
        X25519Field.normalize(nArray2);
        int n4 = Ed25519.checkPoint(nArray, nArray2);
        X25519Field.encode(nArray2, byArray, n3);
        int n5 = n3 + 32 - 1;
        byArray[n5] = (byte)(byArray[n5] | (nArray[0] & 1) << 7);
        return n4;
    }

    public static void generatePrivateKey(SecureRandom secureRandom, byte[] byArray) {
        secureRandom.nextBytes(byArray);
    }

    public static void generatePublicKey(byte[] byArray, int n3, byte[] byArray2, int n4) {
        Digest digest = Ed25519.createDigest();
        byArray = new byte[digest.getDigestSize()];
        digest.update(byArray, n3, 32);
        digest.doFinal(byArray, 0);
        byte[] byArray3 = new byte[32];
        Ed25519.pruneScalar(byArray, 0, byArray3);
        Ed25519.scalarMultBaseEncoded(byArray3, byArray2, n4);
    }

    private static int getWindow4(int[] nArray, int n3) {
        int n4 = n3;
        int n5 = n4 >>> 3;
        n3 = (n4 & 7) << 2;
        return nArray[n5] >>> n3 & 0xF;
    }

    private static byte[] getWnafVar(int[] objectArray, int n3) {
        int n4;
        int n5 = 16;
        int[] nArray = new int[16];
        int n6 = 0;
        int n7 = 8;
        int n8 = n5;
        while ((n7 += -1) >= 0) {
            n4 = objectArray[n7];
            nArray[--n8] = n4 >>> 16 | n6 << 16;
            n6 = n8 + -1;
            nArray[n6] = n4;
            int n9 = n6;
            n6 = n4;
            n8 = n9;
        }
        objectArray = new byte[253];
        int n10 = 1 << n3;
        n6 = n10 - 1;
        n7 = n10 >>> 1;
        n8 = 0;
        n4 = 0;
        int n11 = 0;
        while (n11 < n5) {
            int n12 = nArray[n11];
            while (n8 < 16) {
                int n13 = n12 >>> n8;
                if ((n13 & 1) == n4) {
                    ++n8;
                    continue;
                }
                int n14 = n8;
                int n15 = (n13 & n6) + n4;
                int n16 = n15 & n7;
                n4 = n16;
                n4 >>>= n3 - 1;
                n8 = (n11 << 4) + n8;
                objectArray[n8] = (byte)(n15 - (n16 << 1));
                n8 = n14 + n3;
            }
            ++n11;
            n8 -= 16;
        }
        return objectArray;
    }

    private static void implSign(Digest object, byte[] byArray, byte[] byArray2, byte[] byArray3, int n3, byte[] byArray4, byte by, byte[] byArray5, int n4, int n5, byte[] byArray6, int n6) {
        Ed25519.dom2((Digest)object, by, byArray4);
        object.update(byArray, 32, 32);
        object.update(byArray5, n4, n5);
        object.doFinal(byArray, 0);
        byte[] byArray7 = Ed25519.reduceScalar(byArray);
        Digest digest = object;
        Digest digest2 = object;
        Digest digest3 = object;
        Digest digest4 = object;
        byte[] byArray8 = new byte[32];
        object = byArray8;
        Ed25519.scalarMultBaseEncoded(byArray7, byArray8, 0);
        Ed25519.dom2(digest4, by, byArray4);
        digest4.update((byte[])object, 0, 32);
        digest3.update(byArray3, n3, 32);
        digest2.update(byArray5, n4, n5);
        digest.doFinal(byArray, 0);
        byte[] byArray9 = Ed25519.calculateS(byArray7, Ed25519.reduceScalar(byArray), byArray2);
        System.arraycopy(object, 0, byArray6, n6, 32);
        int n7 = n6 + 32;
        System.arraycopy(byArray9, 0, byArray6, n7, 32);
    }

    private static void implSign(byte[] byArray, int n3, byte[] byArray2, byte by, byte[] byArray3, int n4, int n5, byte[] byArray4, int n6) {
        if (Ed25519.checkContextVar(byArray2, by)) {
            Digest digest = Ed25519.createDigest();
            byArray = new byte[digest.getDigestSize()];
            digest.update(byArray, n3, 32);
            digest.doFinal(byArray, 0);
            byte[] byArray5 = byArray;
            byte[] byArray6 = new byte[32];
            Ed25519.pruneScalar(byArray, 0, byArray6);
            byArray = new byte[32];
            Ed25519.scalarMultBaseEncoded(byArray6, byArray, 0);
            Ed25519.implSign(digest, byArray5, byArray6, byArray, 0, byArray2, by, byArray3, n4, n5, byArray4, n6);
            return;
        }
        throw new IllegalArgumentException("ctx");
    }

    private static void implSign(byte[] byArray, int n3, byte[] byArray2, int n4, byte[] byArray3, byte by, byte[] byArray4, int n5, int n6, byte[] byArray5, int n7) {
        if (Ed25519.checkContextVar(byArray3, by)) {
            Digest digest = Ed25519.createDigest();
            byte[] byArray6 = new byte[digest.getDigestSize()];
            digest.update(byArray, n3, 32);
            digest.doFinal(byArray6, 0);
            byArray = new byte[32];
            Ed25519.pruneScalar(byArray6, 0, byArray);
            Ed25519.implSign(digest, byArray6, byArray, byArray2, n4, byArray3, by, byArray4, n5, n6, byArray5, n7);
            return;
        }
        throw new IllegalArgumentException("ctx");
    }

    private static boolean implVerify(byte[] byArray, int n3, byte[] objectArray, int n4, byte[] byArray2, byte by, byte[] byArray3, int n5, int n6) {
        if (Ed25519.checkContextVar(byArray2, by)) {
            PointAccum pointAccum;
            PointAffine pointAffine;
            int n7 = n3;
            int n8 = n7 + 32;
            byte[] byArray4 = Arrays.copyOfRange(byArray, n7, n8);
            Object[] objectArray2 = Arrays.copyOfRange(byArray, n8, n3 + 64);
            if (!Ed25519.checkPointVar(byArray4)) {
                return false;
            }
            if (!Ed25519.checkScalarVar(objectArray2)) {
                return false;
            }
            PointAffine pointAffine2 = pointAffine;
            pointAffine = new PointAffine(null);
            if (!Ed25519.decodePointVar(objectArray, n4, true, pointAffine2)) {
                return false;
            }
            Digest digest = Ed25519.createDigest();
            byte[] byArray5 = objectArray;
            objectArray = new byte[digest.getDigestSize()];
            Ed25519.dom2(digest, by, byArray2);
            digest.update(byArray4, 0, 32);
            digest.update(byArray5, n4, 32);
            digest.update(byArray3, n5, n6);
            digest.doFinal((byte[])objectArray, 0);
            byte[] byArray6 = Ed25519.reduceScalar(objectArray);
            byte[] byArray7 = objectArray2;
            objectArray2 = new int[8];
            Ed25519.decodeScalar(byArray7, 0, objectArray2);
            objectArray = new int[8];
            Ed25519.decodeScalar(byArray6, 0, objectArray);
            PointAccum pointAccum2 = pointAccum;
            pointAccum2(null);
            Ed25519.scalarMultStrausVar(objectArray2, objectArray, pointAffine2, pointAccum2);
            objectArray2 = new byte[32];
            return Ed25519.encodePoint(pointAccum, objectArray2, 0) != 0 && Arrays.areEqual(objectArray2, byArray4);
        }
        throw new IllegalArgumentException("ctx");
    }

    private static void pointAdd(PointExt pointExt, PointAccum pointAccum) {
        int[] nArray = X25519Field.create();
        int[] nArray2 = X25519Field.create();
        int[] nArray3 = X25519Field.create();
        int[] nArray4 = X25519Field.create();
        int[] nArray5 = pointAccum.u;
        int[] nArray6 = X25519Field.create();
        int[] nArray7 = X25519Field.create();
        int[] nArray8 = nArray4;
        PointAccum pointAccum2 = pointAccum;
        int[] nArray9 = pointAccum2.v;
        X25519Field.apm(pointAccum2.y, pointAccum.x, nArray2, nArray);
        X25519Field.apm(pointExt.y, pointExt.x, nArray4, nArray3);
        X25519Field.mul(nArray, nArray3, nArray);
        X25519Field.mul(nArray2, nArray4, nArray2);
        X25519Field.mul(pointAccum.u, pointAccum.v, nArray3);
        X25519Field.mul(nArray3, pointExt.t, nArray3);
        X25519Field.mul(nArray3, C_d2, nArray3);
        X25519Field.mul(pointAccum.z, pointExt.z, nArray4);
        X25519Field.add(nArray4, nArray8, nArray8);
        X25519Field.apm(nArray2, nArray, nArray9, nArray5);
        X25519Field.apm(nArray4, nArray3, nArray7, nArray6);
        X25519Field.carry(nArray7);
        X25519Field.mul(nArray5, nArray6, pointAccum.x);
        X25519Field.mul(nArray7, nArray9, pointAccum.y);
        X25519Field.mul(nArray6, nArray7, pointAccum.z);
    }

    private static void pointAdd(PointExt pointExt, PointExt pointExt2) {
        int[] nArray = X25519Field.create();
        int[] nArray2 = X25519Field.create();
        int[] nArray3 = X25519Field.create();
        int[] nArray4 = X25519Field.create();
        int[] nArray5 = X25519Field.create();
        int[] nArray6 = X25519Field.create();
        int[] nArray7 = X25519Field.create();
        int[] nArray8 = nArray4;
        int[] nArray9 = X25519Field.create();
        X25519Field.apm(pointExt.y, pointExt.x, nArray2, nArray);
        X25519Field.apm(pointExt2.y, pointExt2.x, nArray4, nArray3);
        X25519Field.mul(nArray, nArray3, nArray);
        X25519Field.mul(nArray2, nArray4, nArray2);
        X25519Field.mul(pointExt.t, pointExt2.t, nArray3);
        X25519Field.mul(nArray3, C_d2, nArray3);
        X25519Field.mul(pointExt.z, pointExt2.z, nArray4);
        X25519Field.add(nArray4, nArray8, nArray8);
        X25519Field.apm(nArray2, nArray, nArray9, nArray5);
        X25519Field.apm(nArray4, nArray3, nArray7, nArray6);
        X25519Field.carry(nArray7);
        X25519Field.mul(nArray5, nArray6, pointExt2.x);
        X25519Field.mul(nArray7, nArray9, pointExt2.y);
        X25519Field.mul(nArray6, nArray7, pointExt2.z);
        X25519Field.mul(nArray5, nArray9, pointExt2.t);
    }

    private static void pointAddVar(boolean bl, PointExt pointExt, PointAccum pointAccum) {
        int[] nArray;
        int[] nArray2;
        int[] nArray3;
        int[] nArray4;
        PointAccum pointAccum2 = pointAccum;
        int[] nArray5 = X25519Field.create();
        int[] nArray6 = X25519Field.create();
        int[] nArray7 = X25519Field.create();
        int[] nArray8 = X25519Field.create();
        int[] nArray9 = pointAccum2.u;
        int[] nArray10 = X25519Field.create();
        int[] nArray11 = X25519Field.create();
        int[] nArray12 = pointAccum2.v;
        if (bl) {
            nArray4 = nArray11;
            nArray3 = nArray10;
            nArray2 = nArray8;
            nArray = nArray7;
        } else {
            nArray4 = nArray10;
            nArray3 = nArray11;
            nArray2 = nArray7;
            nArray = nArray8;
        }
        int[] nArray13 = nArray8;
        X25519Field.apm(pointAccum.y, pointAccum.x, nArray6, nArray5);
        X25519Field.apm(pointExt.y, pointExt.x, nArray, nArray2);
        X25519Field.mul(nArray5, nArray7, nArray5);
        X25519Field.mul(nArray6, nArray8, nArray6);
        X25519Field.mul(pointAccum.u, pointAccum.v, nArray7);
        X25519Field.mul(nArray7, pointExt.t, nArray7);
        X25519Field.mul(nArray7, C_d2, nArray7);
        X25519Field.mul(pointAccum.z, pointExt.z, nArray8);
        X25519Field.add(nArray8, nArray13, nArray13);
        X25519Field.apm(nArray6, nArray5, nArray12, nArray9);
        X25519Field.apm(nArray8, nArray7, nArray3, nArray4);
        X25519Field.carry(nArray3);
        X25519Field.mul(nArray9, nArray10, pointAccum.x);
        X25519Field.mul(nArray11, nArray12, pointAccum.y);
        X25519Field.mul(nArray10, nArray11, pointAccum.z);
    }

    private static void pointAddVar(boolean bl, PointExt pointExt, PointExt pointExt2, PointExt pointExt3) {
        int[] nArray;
        int[] nArray2;
        int[] nArray3;
        int[] nArray4;
        int[] nArray5 = X25519Field.create();
        int[] nArray6 = X25519Field.create();
        int[] nArray7 = X25519Field.create();
        int[] nArray8 = X25519Field.create();
        int[] nArray9 = X25519Field.create();
        int[] nArray10 = X25519Field.create();
        int[] nArray11 = X25519Field.create();
        int[] nArray12 = X25519Field.create();
        if (bl) {
            nArray4 = nArray11;
            nArray3 = nArray10;
            nArray2 = nArray8;
            nArray = nArray7;
        } else {
            nArray4 = nArray10;
            nArray3 = nArray11;
            nArray2 = nArray7;
            nArray = nArray8;
        }
        int[] nArray13 = nArray8;
        X25519Field.apm(pointExt.y, pointExt.x, nArray6, nArray5);
        X25519Field.apm(pointExt2.y, pointExt2.x, nArray, nArray2);
        X25519Field.mul(nArray5, nArray7, nArray5);
        X25519Field.mul(nArray6, nArray8, nArray6);
        X25519Field.mul(pointExt.t, pointExt2.t, nArray7);
        X25519Field.mul(nArray7, C_d2, nArray7);
        X25519Field.mul(pointExt.z, pointExt2.z, nArray8);
        X25519Field.add(nArray8, nArray13, nArray13);
        X25519Field.apm(nArray6, nArray5, nArray12, nArray9);
        X25519Field.apm(nArray8, nArray7, nArray3, nArray4);
        X25519Field.carry(nArray3);
        X25519Field.mul(nArray9, nArray10, pointExt3.x);
        X25519Field.mul(nArray11, nArray12, pointExt3.y);
        X25519Field.mul(nArray10, nArray11, pointExt3.z);
        X25519Field.mul(nArray9, nArray12, pointExt3.t);
    }

    private static void pointAddPrecomp(PointPrecomp object, PointAccum pointAccum) {
        int[] nArray = X25519Field.create();
        int[] nArray2 = X25519Field.create();
        int[] nArray3 = X25519Field.create();
        int[] nArray4 = pointAccum.u;
        int[] nArray5 = X25519Field.create();
        int[] nArray6 = X25519Field.create();
        PointPrecomp pointPrecomp = object;
        PointPrecomp pointPrecomp2 = object;
        PointPrecomp pointPrecomp3 = object;
        PointAccum pointAccum2 = pointAccum;
        object = pointAccum2.v;
        X25519Field.apm(pointAccum2.y, pointAccum.x, nArray2, nArray);
        X25519Field.mul(nArray, pointPrecomp3.ymx_h, nArray);
        X25519Field.mul(nArray2, pointPrecomp2.ypx_h, nArray2);
        X25519Field.mul(pointAccum.u, pointAccum.v, nArray3);
        X25519Field.mul(nArray3, pointPrecomp.xyd, nArray3);
        X25519Field.apm(nArray2, nArray, (int[])object, nArray4);
        X25519Field.apm(pointAccum.z, nArray3, nArray6, nArray5);
        X25519Field.carry(nArray6);
        X25519Field.mul(nArray4, nArray5, pointAccum.x);
        X25519Field.mul(nArray6, (int[])object, pointAccum.y);
        X25519Field.mul(nArray5, nArray6, pointAccum.z);
    }

    private static PointExt pointCopy(PointAccum object) {
        PointExt pointExt;
        PointExt pointExt2 = pointExt;
        PointAccum pointAccum = object;
        pointExt2(null);
        X25519Field.copy(pointAccum.x, 0, pointExt2.x, 0);
        X25519Field.copy(pointAccum.y, 0, pointExt2.y, 0);
        X25519Field.copy(pointAccum.z, 0, pointExt2.z, 0);
        object = ((PointAccum)object).v;
        X25519Field.mul(pointAccum.u, (int[])object, pointExt2.t);
        return pointExt;
    }

    private static PointExt pointCopy(PointAffine pointAffine) {
        PointExt pointExt;
        PointExt pointExt2 = pointExt;
        PointAffine pointAffine2 = pointAffine;
        pointExt2(null);
        X25519Field.copy(pointAffine2.x, 0, pointExt2.x, 0);
        X25519Field.copy(pointAffine2.y, 0, pointExt2.y, 0);
        Ed25519.pointExtendXY(pointExt);
        return pointExt;
    }

    private static PointExt pointCopy(PointExt pointExt) {
        PointExt pointExt2;
        PointExt pointExt3 = pointExt2;
        pointExt3(null);
        Ed25519.pointCopy(pointExt, pointExt3);
        return pointExt2;
    }

    private static void pointCopy(PointAffine pointAffine, PointAccum pointAccum) {
        PointAffine pointAffine2 = pointAffine;
        X25519Field.copy(pointAffine2.x, 0, pointAccum.x, 0);
        X25519Field.copy(pointAffine2.y, 0, pointAccum.y, 0);
        Ed25519.pointExtendXY(pointAccum);
    }

    private static void pointCopy(PointExt pointExt, PointExt pointExt2) {
        PointExt pointExt3 = pointExt;
        X25519Field.copy(pointExt3.x, 0, pointExt2.x, 0);
        X25519Field.copy(pointExt3.y, 0, pointExt2.y, 0);
        X25519Field.copy(pointExt3.z, 0, pointExt2.z, 0);
        X25519Field.copy(pointExt3.t, 0, pointExt2.t, 0);
    }

    private static void pointDouble(PointAccum pointAccum) {
        int[] nArray = X25519Field.create();
        int[] nArray2 = X25519Field.create();
        int[] nArray3 = X25519Field.create();
        int[] nArray4 = pointAccum.u;
        int[] nArray5 = X25519Field.create();
        int[] nArray6 = nArray5;
        int[] nArray7 = X25519Field.create();
        int[] nArray8 = nArray6;
        int[] nArray9 = nArray6;
        int[] nArray10 = nArray6;
        nArray6 = pointAccum.v;
        int[] nArray11 = nArray4;
        int[] nArray12 = nArray4;
        int[] nArray13 = nArray3;
        PointAccum pointAccum2 = pointAccum;
        X25519Field.sqr(pointAccum2.x, nArray);
        X25519Field.sqr(pointAccum2.y, nArray2);
        X25519Field.sqr(pointAccum2.z, nArray3);
        X25519Field.add(nArray3, nArray13, nArray13);
        X25519Field.apm(nArray, nArray2, nArray6, nArray7);
        X25519Field.add(pointAccum.x, pointAccum.y, nArray4);
        X25519Field.sqr(nArray12, nArray11);
        X25519Field.sub(pointAccum.v, nArray12, nArray11);
        X25519Field.add(nArray3, nArray7, nArray10);
        X25519Field.carry(nArray9);
        X25519Field.mul(nArray4, nArray8, pointAccum.x);
        X25519Field.mul(nArray7, nArray6, pointAccum.y);
        X25519Field.mul(nArray5, nArray7, pointAccum.z);
    }

    private static void pointExtendXY(PointAccum pointAccum) {
        PointAccum pointAccum2 = pointAccum;
        X25519Field.one(pointAccum2.z);
        X25519Field.copy(pointAccum2.x, 0, pointAccum.u, 0);
        X25519Field.copy(pointAccum2.y, 0, pointAccum.v, 0);
    }

    private static void pointExtendXY(PointExt object) {
        PointExt pointExt = object;
        X25519Field.one(pointExt.z);
        PointExt pointExt2 = object;
        object = pointExt2.y;
        X25519Field.mul(pointExt.x, (int[])object, pointExt2.t);
    }

    private static void pointLookup(int n3, int n4, PointPrecomp pointPrecomp) {
        n3 = n3 * 8 * 3 * 10;
        for (int i3 = 0; i3 < 8; ++i3) {
            int n5 = (i3 ^ n4) - 1 >> 31;
            int[] nArray = precompBase;
            int[] nArray2 = pointPrecomp.ypx_h;
            X25519Field.cmov(n5, nArray, n3, nArray2, 0);
            nArray = precompBase;
            nArray2 = pointPrecomp.ymx_h;
            X25519Field.cmov(n5, nArray, n3 += 10, nArray2, 0);
            nArray = precompBase;
            nArray2 = pointPrecomp.xyd;
            X25519Field.cmov(n5, nArray, n3 += 10, nArray2, 0);
            n3 += 10;
        }
    }

    private static void pointLookup(int[] nArray, int n3, int[] nArray2, PointExt pointExt) {
        int n4 = Ed25519.getWindow4(nArray, n3);
        int n5 = n4 >>> 3 ^ 1;
        n3 = (n4 ^ -n5) & 7;
        int n6 = 0;
        for (int i3 = 0; i3 < 8; ++i3) {
            int n7 = (i3 ^ n3) - 1 >> 31;
            X25519Field.cmov(n7, nArray2, n6, pointExt.x, 0);
            X25519Field.cmov(n7, nArray2, n6 += 10, pointExt.y, 0);
            X25519Field.cmov(n7, nArray2, n6 += 10, pointExt.z, 0);
            X25519Field.cmov(n7, nArray2, n6 += 10, pointExt.t, 0);
            n6 += 10;
        }
        X25519Field.cnegate(n5, pointExt.x);
        X25519Field.cnegate(n5, pointExt.t);
    }

    private static void pointLookup(int[] nArray, int n3, PointExt pointExt) {
        int n4 = n3 * 40;
        X25519Field.copy(nArray, n4, pointExt.x, 0);
        X25519Field.copy(nArray, n4 += 10, pointExt.y, 0);
        X25519Field.copy(nArray, n4 += 10, pointExt.z, 0);
        X25519Field.copy(nArray, n4 += 10, pointExt.t, 0);
    }

    private static int[] pointPrecompute(PointAffine object, int n3) {
        object = Ed25519.pointCopy((PointAffine)object);
        PointExt pointExt = Ed25519.pointCopy((PointExt)object);
        Ed25519.pointAdd((PointExt)object, pointExt);
        int[] nArray = X25519Field.createTable(n3 * 4);
        int n4 = 0;
        int n5 = 0;
        while (true) {
            Object object2 = object;
            X25519Field.copy(((PointExt)object2).x, 0, nArray, n4);
            X25519Field.copy(((PointExt)object2).y, 0, nArray, n4 += 10);
            X25519Field.copy(((PointExt)object2).z, 0, nArray, n4 += 10);
            X25519Field.copy(((PointExt)object2).t, 0, nArray, n4 += 10);
            n4 += 10;
            if (++n5 == n3) {
                return nArray;
            }
            Ed25519.pointAdd(pointExt, (PointExt)object);
        }
    }

    private static PointExt[] pointPrecomputeVar(PointExt pointExt, int n3) {
        PointExt pointExt2;
        PointExt pointExt3 = pointExt2;
        pointExt2 = new PointExt(null);
        PointExt pointExt4 = pointExt;
        Ed25519.pointAddVar(false, pointExt4, pointExt4, pointExt3);
        PointExt[] pointExtArray = new PointExt[n3];
        PointExt[] pointExtArray2 = pointExtArray;
        pointExtArray[0] = Ed25519.pointCopy(pointExt);
        for (int i3 = 1; i3 < n3; ++i3) {
            PointExt pointExt5;
            PointExt pointExt6 = pointExtArray2[i3 - 1];
            PointExt pointExt7 = pointExt5;
            pointExt5 = new PointExt(null);
            pointExtArray2[i3] = pointExt7;
            Ed25519.pointAddVar(false, pointExt6, pointExt3, pointExt7);
        }
        return pointExtArray2;
    }

    private static void pointSetNeutral(PointAccum pointAccum) {
        PointAccum pointAccum2 = pointAccum;
        X25519Field.zero(pointAccum2.x);
        X25519Field.one(pointAccum2.y);
        X25519Field.one(pointAccum2.z);
        X25519Field.zero(pointAccum2.u);
        X25519Field.one(pointAccum2.v);
    }

    private static void pointSetNeutral(PointExt pointExt) {
        PointExt pointExt2 = pointExt;
        X25519Field.zero(pointExt2.x);
        X25519Field.one(pointExt2.y);
        X25519Field.one(pointExt2.z);
        X25519Field.zero(pointExt2.t);
    }

    /*
     * Exception decompiling
     */
    public static void precompute() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [48[WHILELOOP]], but top level block is 24[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void pruneScalar(byte[] byArray, int n3, byte[] byArray2) {
        byte by;
        byte[] byArray3 = byArray2;
        System.arraycopy(byArray, n3, byArray2, 0, 32);
        byArray3[0] = (byte)(byArray2[0] & 0xF8);
        byArray2[31] = by = (byte)(byArray2[31] & 0x7F);
        byArray3[31] = (byte)(by | 0x40);
    }

    private static byte[] reduceScalar(byte[] byArray) {
        long l3 = (long)Ed25519.decode32(byArray, 0) & 0xFFFFFFFFL;
        long l4 = (long)(Ed25519.decode24(byArray, 4) << 4) & 0xFFFFFFFFL;
        long l5 = (long)Ed25519.decode32(byArray, 7) & 0xFFFFFFFFL;
        long l6 = (long)(Ed25519.decode24(byArray, 11) << 4) & 0xFFFFFFFFL;
        long l7 = (long)Ed25519.decode32(byArray, 14) & 0xFFFFFFFFL;
        long l8 = (long)(Ed25519.decode24(byArray, 18) << 4) & 0xFFFFFFFFL;
        long l9 = (long)Ed25519.decode32(byArray, 21) & 0xFFFFFFFFL;
        long l10 = (long)Ed25519.decode32(byArray, 28) & 0xFFFFFFFFL;
        long l11 = (long)(Ed25519.decode24(byArray, 32) << 4) & 0xFFFFFFFFL;
        long l12 = (long)Ed25519.decode32(byArray, 35) & 0xFFFFFFFFL;
        long l13 = (long)(Ed25519.decode24(byArray, 39) << 4) & 0xFFFFFFFFL;
        long l14 = (long)Ed25519.decode32(byArray, 42) & 0xFFFFFFFFL;
        long l15 = (long)(Ed25519.decode24(byArray, 46) << 4) & 0xFFFFFFFFL;
        long l16 = (long)Ed25519.decode32(byArray, 49) & 0xFFFFFFFFL;
        long l17 = (long)(Ed25519.decode24(byArray, 53) << 4) & 0xFFFFFFFFL;
        long l18 = (long)Ed25519.decode32(byArray, 56) & 0xFFFFFFFFL;
        long l19 = l18;
        long l20 = l15;
        l15 = (long)byArray[63] & 0xFFL;
        l11 -= l15 * -50998291L;
        l12 -= l15 * 19280294L;
        l13 -= l15 * 127719000L;
        l14 -= l15 * -6428113L;
        l15 = l20 - l15 * 5343L;
        l19 = ((long)(Ed25519.decode24(byArray, 60) << 4) & 0xFFFFFFFFL) + (l19 >> 28);
        long l21 = l18 & 0xFFFFFFFL;
        l10 -= l19 * -50998291L;
        l11 -= l19 * 19280294L;
        l12 -= l19 * 127719000L;
        l13 -= l19 * -6428113L;
        l14 -= l19 * 5343L;
        l10 -= l21 * 19280294L;
        l11 -= l21 * 127719000L;
        l12 -= l21 * -6428113L;
        l13 -= l21 * 5343L;
        l17 += l16 >> 28;
        long l22 = l9;
        l9 = l16 & 0xFFFFFFFL;
        l16 = l22 - l17 * -50998291L;
        long l23 = l8;
        l8 = l10 - l17 * 127719000L;
        l10 = l11 - l17 * -6428113L;
        l11 = l12 - l17 * 5343L;
        l12 = l23 - l9 * -50998291L;
        l16 -= l9 * 19280294L;
        long l24 = ((long)(Ed25519.decode24(byArray, 25) << 4) & 0xFFFFFFFFL) - l21 * -50998291L - l17 * 19280294L - l9 * 127719000L;
        l8 -= l9 * -6428113L;
        l9 = l10 - l9 * 5343L;
        long l25 = l15 + (l14 >> 28);
        l10 = l25;
        long l26 = l12;
        long l27 = l7;
        l7 = l14 & 0xFFFFFFFL;
        l12 = l27 - l10 * -50998291L;
        l14 = l26 - l10 * 19280294L;
        l15 = l16 - l10 * 127719000L;
        long l28 = l7;
        l7 = l8 - l10 * 5343L;
        long l29 = l28 + (l13 >> 28);
        long l30 = l8 = l29;
        long l31 = l8;
        long l32 = l8;
        long l33 = l6;
        l6 = l13 & 0xFFFFFFFL;
        l8 = l33 - l8 * -50998291L;
        l10 = l12 - l32 * 19280294L;
        l12 = l14 - l31 * 127719000L;
        l13 = l15 - l30 * -6428113L;
        l14 = l24 - l25 * -6428113L - l29 * 5343L;
        long l34 = l7;
        long l35 = l6 + (l11 >> 28);
        l6 = l35;
        long l36 = l5;
        l5 = l11 & 0xFFFFFFFL;
        l7 = l36 - l6 * -50998291L;
        l8 -= l6 * 19280294L;
        l10 -= l6 * 127719000L;
        long l37 = l5;
        l5 = l13 - l6 * 5343L;
        long l38 = l37 + (l9 >> 28);
        long l39 = l6 = l38;
        long l40 = l6;
        long l41 = l6;
        long l42 = l4;
        l4 = l9 & 0xFFFFFFFL;
        l6 = l42 - l6 * -50998291L;
        l7 -= l41 * 19280294L;
        l8 -= l40 * 127719000L;
        l9 = l10 - l39 * -6428113L;
        l10 = l12 - l35 * -6428113L - l38 * 5343L;
        l11 = l34 + (l14 >> 28);
        long l43 = l5;
        long l44 = l9;
        long l45 = l4 + (l11 >> 28);
        l4 = l11 & 0xFFFFFFFL;
        l5 = l4 >>> 27;
        l9 = l45 + l5;
        l6 -= l9 * 19280294L;
        l7 -= l9 * 127719000L;
        l8 -= l9 * -6428113L;
        l3 &= 0xFFFFFFFL;
        l6 &= 0xFFFFFFFL;
        l8 += (l7 += (l6 += (l3 -= l9 * -50998291L) >> 28) >> 28) >> 28;
        l7 &= 0xFFFFFFFL;
        l9 = l44 - l9 * 5343L + (l8 >> 28);
        l8 &= 0xFFFFFFFL;
        l10 += l9 >> 28;
        l9 &= 0xFFFFFFFL;
        l11 = l43 + (l10 >> 28);
        l10 &= 0xFFFFFFFL;
        l12 = (l14 & 0xFFFFFFFL) + (l11 >> 28);
        long l46 = l4;
        l4 = l11 & 0xFFFFFFFL;
        l11 = l46 + (l12 >> 28);
        long l47 = l4;
        l4 = l11 & 0xFFFFFFFL;
        long l48 = (l11 >> 28) - l5;
        long l49 = l5 = l48;
        long l50 = l5;
        l3 += l5 & 0xFFFFFFFFFCF5D3EDL;
        l5 = l6 + (l5 & 0x12631A6L);
        l6 = l7 + (l50 & 0x79CD658L);
        l7 = l8 + (l49 & 0xFFFFFFFFFF9DEA2FL);
        l5 += l3 >> 28;
        l3 &= 0xFFFFFFFL;
        l6 += l5 >> 28;
        l5 &= 0xFFFFFFFL;
        l7 += l6 >> 28;
        l6 &= 0xFFFFFFFL;
        l8 = l9 + (l48 & 0x14DFL) + (l7 >> 28);
        l7 &= 0xFFFFFFFL;
        l9 = l10 + (l8 >> 28);
        l8 &= 0xFFFFFFFL;
        l10 = l47 + (l9 >> 28);
        l9 &= 0xFFFFFFFL;
        l11 = (l12 & 0xFFFFFFFL) + (l10 >> 28);
        long l51 = l4;
        l4 = l10 & 0xFFFFFFFL;
        l10 = l51 + (l11 >> 28);
        byArray = new byte[32];
        Ed25519.encode56(l3 | l5 << 28, byArray, 0);
        Ed25519.encode56(l6 | l7 << 28, byArray, 7);
        Ed25519.encode56(l8 | l9 << 28, byArray, 14);
        Ed25519.encode56(l4 | (l11 &= 0xFFFFFFFL) << 28, byArray, 21);
        Ed25519.encode32((int)l10, byArray, 28);
        return byArray;
    }

    private static void scalarMult(byte[] objectArray, PointAffine pointAffine, PointAccum pointAccum) {
        PointExt pointExt;
        int[] nArray = new int[8];
        Ed25519.decodeScalar(objectArray, 0, nArray);
        Nat.shiftDownBits(8, nArray, 3, 1);
        objectArray = L;
        Nat.cadd(8, ~nArray[0] & 1, nArray, objectArray, nArray);
        Nat.shiftDownBit(8, nArray, 0);
        objectArray = Ed25519.pointPrecompute(pointAffine, 8);
        PointExt pointExt2 = pointExt;
        pointExt2(null);
        Ed25519.pointCopy(pointAffine, pointAccum);
        Ed25519.pointLookup(objectArray, 7, pointExt2);
        Ed25519.pointAdd(pointExt, pointAccum);
        int n3 = 62;
        while (true) {
            PointAccum pointAccum2 = pointAccum;
            Ed25519.pointLookup(nArray, n3, objectArray, pointExt2);
            Ed25519.pointAdd(pointExt2, pointAccum);
            Ed25519.pointDouble(pointAccum2);
            Ed25519.pointDouble(pointAccum2);
            Ed25519.pointDouble(pointAccum2);
            if ((n3 += -1) < 0) {
                return;
            }
            Ed25519.pointDouble(pointAccum);
        }
    }

    private static void scalarMultBase(byte[] objectArray, PointAccum pointAccum) {
        PointPrecomp pointPrecomp;
        Ed25519.precompute();
        int[] nArray = new int[8];
        Ed25519.decodeScalar(objectArray, 0, nArray);
        objectArray = L;
        Nat.cadd(8, ~nArray[0] & 1, nArray, objectArray, nArray);
        Nat.shiftDownBit(8, nArray, 1);
        for (int i3 = 0; i3 < 8; ++i3) {
            nArray[i3] = Interleave.shuffle2(nArray[i3]);
        }
        PointPrecomp pointPrecomp2 = pointPrecomp;
        pointPrecomp = new PointPrecomp(null);
        Ed25519.pointSetNeutral(pointAccum);
        int n3 = 28;
        while (true) {
            for (int i4 = 0; i4 < 8; ++i4) {
                int n4 = nArray[i4] >>> n3;
                int n5 = n4 >>> 3 & 1;
                PointPrecomp pointPrecomp3 = pointPrecomp2;
                Ed25519.pointLookup(i4, (n4 ^ -n5) & 7, pointPrecomp2);
                int[] nArray2 = pointPrecomp3.ypx_h;
                X25519Field.cswap(n5, nArray2, pointPrecomp3.ymx_h);
                X25519Field.cnegate(n5, pointPrecomp2.xyd);
                Ed25519.pointAddPrecomp(pointPrecomp2, pointAccum);
            }
            if ((n3 += -4) < 0) {
                return;
            }
            Ed25519.pointDouble(pointAccum);
        }
    }

    private static void scalarMultBaseEncoded(byte[] byArray, byte[] byArray2, int n3) {
        PointAccum pointAccum;
        PointAccum pointAccum2;
        PointAccum pointAccum3 = pointAccum2 = pointAccum;
        pointAccum3(null);
        Ed25519.scalarMultBase(byArray, pointAccum3);
        if (Ed25519.encodePoint(pointAccum, byArray2, n3) != 0) {
            return;
        }
        throw new IllegalStateException();
    }

    public static void scalarMultBaseYZ(X25519.Friend object, byte[] objectArray, int n3, int[] nArray, int[] nArray2) {
        if (object != null) {
            PointAccum pointAccum;
            byte[] byArray = new byte[32];
            object = byArray;
            Ed25519.pruneScalar(objectArray, n3, (byte[])object);
            object = pointAccum;
            Ed25519.scalarMultBase(byArray, new PointAccum(null));
            Object object2 = object;
            objectArray = ((PointAccum)object2).y;
            if (Ed25519.checkPoint(((PointAccum)object).x, objectArray, ((PointAccum)object2).z) != 0) {
                Object object3 = object;
                X25519Field.copy(((PointAccum)object3).y, 0, nArray, 0);
                X25519Field.copy(((PointAccum)object3).z, 0, nArray2, 0);
                return;
            }
            throw new IllegalStateException();
        }
        throw new NullPointerException("This method is only for use by X25519");
    }

    private static void scalarMultStrausVar(int[] objectArray, int[] objectArray2, PointAffine pointExtArray, PointAccum pointAccum) {
        Ed25519.precompute();
        objectArray = Ed25519.getWnafVar(objectArray, 7);
        objectArray2 = Ed25519.getWnafVar(objectArray2, 5);
        pointExtArray = Ed25519.pointPrecomputeVar(Ed25519.pointCopy((PointAffine)pointExtArray), 8);
        Ed25519.pointSetNeutral(pointAccum);
        int n3 = 252;
        while (true) {
            int n4;
            if ((n4 = objectArray[n3]) != 0) {
                int n5 = n4 >> 31;
                n4 = (n4 ^ n5) >>> 1;
                Ed25519.pointAddVar(n5 != 0, precompBaseTable[n4], pointAccum);
            }
            if ((n4 = objectArray2[n3]) != 0) {
                int n6 = n4 >> 31;
                n4 = (n4 ^ n6) >>> 1;
                Ed25519.pointAddVar(n6 != 0, pointExtArray[n4], pointAccum);
            }
            if ((n3 += -1) < 0) {
                return;
            }
            Ed25519.pointDouble(pointAccum);
        }
    }

    public static void sign(byte[] byArray, int n3, byte[] byArray2, int n4, int n5, byte[] byArray3, int n6) {
        Ed25519.implSign(byArray, n3, null, (byte)0, byArray2, n4, n5, byArray3, n6);
    }

    public static void sign(byte[] byArray, int n3, byte[] byArray2, int n4, byte[] byArray3, int n5, int n6, byte[] byArray4, int n7) {
        Ed25519.implSign(byArray, n3, byArray2, n4, null, (byte)0, byArray3, n5, n6, byArray4, n7);
    }

    public static void sign(byte[] byArray, int n3, byte[] byArray2, byte[] byArray3, int n4, int n5, byte[] byArray4, int n6) {
        Ed25519.implSign(byArray, n3, byArray2, (byte)0, byArray3, n4, n5, byArray4, n6);
    }

    public static void sign(byte[] byArray, int n3, byte[] byArray2, int n4, byte[] byArray3, byte[] byArray4, int n5, int n6, byte[] byArray5, int n7) {
        Ed25519.implSign(byArray, n3, byArray2, n4, byArray3, (byte)0, byArray4, n5, n6, byArray5, n7);
    }

    public static void signPrehash(byte[] byArray, int n3, byte[] byArray2, byte[] byArray3, int n4, byte[] byArray4, int n5) {
        Ed25519.implSign(byArray, n3, byArray2, (byte)1, byArray3, n4, 64, byArray4, n5);
    }

    public static void signPrehash(byte[] byArray, int n3, byte[] byArray2, int n4, byte[] byArray3, byte[] byArray4, int n5, byte[] byArray5, int n6) {
        Ed25519.implSign(byArray, n3, byArray2, n4, byArray3, (byte)1, byArray4, n5, 64, byArray5, n6);
    }

    public static void signPrehash(byte[] byArray, int n3, byte[] byArray2, Digest object, byte[] byArray3, int n4) {
        Digest digest = object;
        byte[] byArray4 = new byte[64];
        object = byArray4;
        if (64 == digest.doFinal(byArray4, 0)) {
            Ed25519.implSign(byArray, n3, byArray2, (byte)1, (byte[])object, 0, 64, byArray3, n4);
            return;
        }
        throw new IllegalArgumentException("ph");
    }

    public static void signPrehash(byte[] byArray, int n3, byte[] byArray2, int n4, byte[] byArray3, Digest object, byte[] byArray4, int n5) {
        Digest digest = object;
        byte[] byArray5 = new byte[64];
        object = byArray5;
        if (64 == digest.doFinal(byArray5, 0)) {
            Ed25519.implSign(byArray, n3, byArray2, n4, byArray3, (byte)1, (byte[])object, 0, 64, byArray4, n5);
            return;
        }
        throw new IllegalArgumentException("ph");
    }

    public static boolean verify(byte[] byArray, int n3, byte[] byArray2, int n4, byte[] byArray3, int n5, int n6) {
        return Ed25519.implVerify(byArray, n3, byArray2, n4, null, (byte)0, byArray3, n5, n6);
    }

    public static boolean verify(byte[] byArray, int n3, byte[] byArray2, int n4, byte[] byArray3, byte[] byArray4, int n5, int n6) {
        return Ed25519.implVerify(byArray, n3, byArray2, n4, byArray3, (byte)0, byArray4, n5, n6);
    }

    public static boolean verifyPrehash(byte[] byArray, int n3, byte[] byArray2, int n4, byte[] byArray3, byte[] byArray4, int n5) {
        return Ed25519.implVerify(byArray, n3, byArray2, n4, byArray3, (byte)1, byArray4, n5, 64);
    }

    public static boolean verifyPrehash(byte[] byArray, int n3, byte[] byArray2, int n4, byte[] byArray3, Digest object) {
        Digest digest = object;
        byte[] byArray4 = new byte[64];
        object = byArray4;
        if (64 == digest.doFinal(byArray4, 0)) {
            return Ed25519.implVerify(byArray, n3, byArray2, n4, byArray3, (byte)1, (byte[])object, 0, 64);
        }
        throw new IllegalArgumentException("ph");
    }

    public static class PointPrecomp {
        public int[] ypx_h = X25519Field.create();
        public int[] ymx_h = X25519Field.create();
        public int[] xyd = X25519Field.create();

        private PointPrecomp() {
        }

        public /* synthetic */ PointPrecomp(1 var1_1) {
            this();
        }
    }

    public static class PointExt {
        public int[] x = X25519Field.create();
        public int[] y = X25519Field.create();
        public int[] z = X25519Field.create();
        public int[] t = X25519Field.create();

        private PointExt() {
        }

        public /* synthetic */ PointExt(1 var1_1) {
            this();
        }
    }

    public static class PointAffine {
        public int[] x = X25519Field.create();
        public int[] y = X25519Field.create();

        private PointAffine() {
        }

        public /* synthetic */ PointAffine(1 var1_1) {
            this();
        }
    }

    public static class PointAccum {
        public int[] x = X25519Field.create();
        public int[] y = X25519Field.create();
        public int[] z = X25519Field.create();
        public int[] u = X25519Field.create();
        public int[] v = X25519Field.create();

        private PointAccum() {
        }

        public /* synthetic */ PointAccum(1 var1_1) {
            this();
        }
    }

    public static class F
    extends X25519Field {
        private F() {
        }
    }

    public static final class Algorithm {
        public static final int Ed25519 = 0;
        public static final int Ed25519ctx = 1;
        public static final int Ed25519ph = 2;
    }
}

