/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.rfc8032;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Xof;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHAKEDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.rfc7748.X448;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.rfc7748.X448Field;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public abstract class Ed448 {
    private static final long M26L = 0x3FFFFFFL;
    private static final long M28L = 0xFFFFFFFL;
    private static final long M32L = 0xFFFFFFFFL;
    private static final int POINT_BYTES = 57;
    private static final int SCALAR_INTS = 14;
    private static final int SCALAR_BYTES = 57;
    public static final int PREHASH_SIZE = 64;
    public static final int PUBLIC_KEY_SIZE = 57;
    public static final int SECRET_KEY_SIZE = 57;
    public static final int SIGNATURE_SIZE = 114;
    private static final byte[] DOM4_PREFIX = new byte[]{83, 105, 103, 69, 100, 52, 52, 56};
    private static final int[] P = new int[]{-1, -1, -1, -1, -1, -1, -1, -2, -1, -1, -1, -1, -1, -1};
    private static final int[] L = new int[]{-1420278541, 595116690, -1916432555, 560775794, -1361693040, -1001465015, 2093622249, -1, -1, -1, -1, -1, -1, 0x3FFFFFFF};
    private static final int L_0 = 78101261;
    private static final int L_1 = 141809365;
    private static final int L_2 = 175155932;
    private static final int L_3 = 64542499;
    private static final int L_4 = 158326419;
    private static final int L_5 = 191173276;
    private static final int L_6 = 104575268;
    private static final int L_7 = 137584065;
    private static final int L4_0 = 43969588;
    private static final int L4_1 = 30366549;
    private static final int L4_2 = 163752818;
    private static final int L4_3 = 258169998;
    private static final int L4_4 = 96434764;
    private static final int L4_5 = 227822194;
    private static final int L4_6 = 149865618;
    private static final int L4_7 = 550336261;
    private static final int[] B_x = new int[]{118276190, 40534716, 9670182, 135141552, 85017403, 259173222, 68333082, 171784774, 174973732, 15824510, 73756743, 57518561, 94773951, 248652241, 107736333, 82941708};
    private static final int[] B_y = new int[]{36764180, 8885695, 130592152, 20104429, 163904957, 30304195, 121295871, 5901357, 125344798, 171541512, 175338348, 209069246, 3626697, 38307682, 24032956, 110359655};
    private static final int C_d = -39081;
    private static final int WNAF_WIDTH_BASE = 7;
    private static final int PRECOMP_BLOCKS = 5;
    private static final int PRECOMP_TEETH = 5;
    private static final int PRECOMP_SPACING = 18;
    private static final int PRECOMP_POINTS = 16;
    private static final int PRECOMP_MASK = 15;
    private static final Object precompLock = new Object();
    private static PointExt[] precompBaseTable;
    private static int[] precompBase;

    private static byte[] calculateS(byte[] byArray, byte[] objectArray, byte[] objectArray2) {
        byte[] byArray2 = objectArray2;
        byte[] byArray3 = objectArray;
        int n3 = 28;
        objectArray = new int[28];
        Ed448.decodeScalar(byArray, 0, objectArray);
        objectArray2 = new int[14];
        Ed448.decodeScalar(byArray3, 0, objectArray2);
        int[] nArray = new int[14];
        Ed448.decodeScalar(byArray2, 0, nArray);
        Nat.mulAddTo(14, objectArray2, nArray, objectArray);
        objectArray2 = new byte[114];
        for (int i3 = 0; i3 < n3; ++i3) {
            Ed448.encode32(objectArray[i3], objectArray2, i3 * 4);
        }
        return Ed448.reduceScalar(objectArray2);
    }

    private static boolean checkContextVar(byte[] byArray) {
        return byArray != null && byArray.length < 256;
    }

    private static int checkPoint(int[] nArray, int[] nArray2) {
        int[] nArray3 = X448Field.create();
        int[] nArray4 = X448Field.create();
        int[] nArray5 = nArray;
        nArray = X448Field.create();
        X448Field.sqr(nArray5, nArray4);
        X448Field.sqr(nArray2, nArray);
        X448Field.mul(nArray4, nArray, nArray3);
        X448Field.add(nArray4, nArray, nArray4);
        X448Field.mul(nArray3, 39081, nArray3);
        X448Field.subOne(nArray3);
        X448Field.add(nArray3, nArray4, nArray3);
        X448Field.normalize(nArray3);
        return X448Field.isZero(nArray3);
    }

    private static int checkPoint(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = X448Field.create();
        int[] nArray5 = X448Field.create();
        int[] nArray6 = X448Field.create();
        int[] nArray7 = X448Field.create();
        X448Field.sqr(nArray, nArray5);
        X448Field.sqr(nArray2, nArray6);
        X448Field.sqr(nArray3, nArray7);
        X448Field.mul(nArray5, nArray6, nArray4);
        X448Field.add(nArray5, nArray6, nArray5);
        X448Field.mul(nArray5, nArray7, nArray5);
        X448Field.sqr(nArray7, nArray7);
        X448Field.mul(nArray4, 39081, nArray4);
        X448Field.sub(nArray4, nArray7, nArray4);
        X448Field.add(nArray4, nArray5, nArray4);
        X448Field.normalize(nArray4);
        return X448Field.isZero(nArray4);
    }

    private static boolean checkPointVar(byte[] objectArray) {
        if ((objectArray[56] & 0x7F) != 0) {
            return false;
        }
        byte[] byArray = objectArray;
        objectArray = new int[14];
        Ed448.decode32(byArray, 0, objectArray, 0, 14);
        int[] nArray = P;
        return Nat.gte(14, objectArray, nArray) ^ true;
    }

    private static boolean checkScalarVar(byte[] objectArray) {
        if (objectArray[56] != 0) {
            return false;
        }
        byte[] byArray = objectArray;
        objectArray = new int[14];
        Ed448.decodeScalar(byArray, 0, objectArray);
        int[] nArray = L;
        return Nat.gte(14, objectArray, nArray) ^ true;
    }

    public static Xof createPrehash() {
        return Ed448.createXof();
    }

    private static Xof createXof() {
        return new SHAKEDigest(256);
    }

    private static int decode16(byte[] byArray, int n3) {
        return byArray[n3] & 0xFF | (byArray[n3 + 1] & 0xFF) << 8;
    }

    private static int decode24(byte[] byArray, int n3) {
        return byArray[n3] & 0xFF | (byArray[++n3] & 0xFF) << 8 | (byArray[n3 + 1] & 0xFF) << 16;
    }

    private static int decode32(byte[] byArray, int n3) {
        int n4 = byArray[n3] & 0xFF;
        n3 = n3 + 1;
        return n4 | (byArray[n3] & 0xFF) << 8 | (byArray[++n3] & 0xFF) << 16 | byArray[n3 + 1] << 24;
    }

    private static void decode32(byte[] byArray, int n3, int[] nArray, int n4, int n5) {
        for (int i3 = 0; i3 < n5; ++i3) {
            int n6 = n4 + i3;
            nArray[n6] = Ed448.decode32(byArray, i3 * 4 + n3);
        }
    }

    private static boolean decodePointVar(byte[] byArray, int n3, boolean bl, PointExt pointExt) {
        int n4 = n3;
        if (!Ed448.checkPointVar(byArray = Arrays.copyOfRange(byArray, n4, n4 + 57))) {
            return false;
        }
        byte by = byArray[56];
        int n5 = (by & 0x80) >>> 7;
        byArray[56] = (byte)(by & 0x7F);
        X448Field.decode(byArray, 0, pointExt.y);
        int[] nArray = X448Field.create();
        int[] nArray2 = X448Field.create();
        int[] nArray3 = nArray;
        int[] nArray4 = nArray;
        X448Field.sqr(pointExt.y, nArray);
        X448Field.mul(nArray3, 39081, nArray2);
        X448Field.negate(nArray3, nArray4);
        X448Field.addOne(nArray4);
        X448Field.addOne(nArray2);
        if (!X448Field.sqrtRatioVar(nArray, nArray2, pointExt.x)) {
            return false;
        }
        X448Field.normalize(pointExt.x);
        if (n5 == 1 && X448Field.isZeroVar(pointExt.x)) {
            return false;
        }
        int[] nArray5 = pointExt.x;
        boolean bl2 = n5 != (pointExt.x[0] & 1);
        if (bl ^ bl2) {
            X448Field.negate(nArray5, nArray5);
        }
        Ed448.pointExtendXY(pointExt);
        return true;
    }

    private static void decodeScalar(byte[] byArray, int n3, int[] nArray) {
        Ed448.decode32(byArray, n3, nArray, 0, 14);
    }

    private static void dom4(Xof object, byte by, byte[] byArray) {
        Xof xof = object;
        object = DOM4_PREFIX;
        int n3 = DOM4_PREFIX.length;
        int n4 = n3 + 2;
        int n5 = n4 + byArray.length;
        byte[] byArray2 = new byte[n5];
        byte[] byArray3 = byArray2;
        System.arraycopy(object, 0, byArray3, 0, n3);
        byArray3[n3] = by;
        byArray2[n3 + 1] = (byte)byArray.length;
        int n6 = byArray.length;
        System.arraycopy(byArray, 0, byArray3, n4, n6);
        xof.update(byArray3, 0, n5);
    }

    private static void encode24(int n3, byte[] byArray, int n4) {
        int n5 = n3;
        int n6 = n3;
        byArray[n4] = (byte)n3;
        n3 = n4 + 1;
        byArray[n3] = (byte)(n6 >>> 8);
        byArray[++n3] = (byte)(n5 >>> 16);
    }

    private static void encode32(int n3, byte[] byArray, int n4) {
        int n5 = n3;
        int n6 = n3;
        int n7 = n3;
        byArray[n4] = (byte)n3;
        n3 = n4 + 1;
        byArray[n3] = (byte)(n7 >>> 8);
        byArray[++n3] = (byte)(n6 >>> 16);
        byArray[++n3] = (byte)(n5 >>> 24);
    }

    private static void encode56(long l3, byte[] byArray, int n3) {
        long l4 = l3;
        Ed448.encode32((int)l4, byArray, n3);
        Ed448.encode24((int)(l4 >>> 32), byArray, n3 + 4);
    }

    private static int encodePoint(PointExt pointExt, byte[] byArray, int n3) {
        int[] nArray = X448Field.create();
        int[] nArray2 = X448Field.create();
        PointExt pointExt2 = pointExt;
        X448Field.inv(pointExt2.z, nArray2);
        X448Field.mul(pointExt2.x, nArray2, nArray);
        X448Field.mul(pointExt2.y, nArray2, nArray2);
        X448Field.normalize(nArray);
        X448Field.normalize(nArray2);
        int n4 = Ed448.checkPoint(nArray, nArray2);
        X448Field.encode(nArray2, byArray, n3);
        int n5 = n3 + 57 - 1;
        byArray[n5] = (byte)((nArray[0] & 1) << 7);
        return n4;
    }

    public static void generatePrivateKey(SecureRandom secureRandom, byte[] byArray) {
        secureRandom.nextBytes(byArray);
    }

    public static void generatePublicKey(byte[] byArray, int n3, byte[] byArray2, int n4) {
        Xof xof = Ed448.createXof();
        byte[] byArray3 = new byte[114];
        xof.update(byArray, n3, 57);
        xof.doFinal(byArray3, 0, 114);
        byArray = new byte[57];
        Ed448.pruneScalar(byArray3, 0, byArray);
        Ed448.scalarMultBaseEncoded(byArray, byArray2, n4);
    }

    private static int getWindow4(int[] nArray, int n3) {
        int n4 = n3;
        int n5 = n4 >>> 3;
        n3 = (n4 & 7) << 2;
        return nArray[n5] >>> n3 & 0xF;
    }

    private static byte[] getWnafVar(int[] objectArray, int n3) {
        int n4;
        int n5 = 28;
        int[] nArray = new int[28];
        int n6 = 0;
        int n7 = 14;
        int n8 = n5;
        while ((n7 += -1) >= 0) {
            n4 = objectArray[n7];
            nArray[--n8] = n4 >>> 16 | n6 << 16;
            n6 = n8 + -1;
            nArray[n6] = n4;
            int n9 = n6;
            n6 = n4;
            n8 = n9;
        }
        objectArray = new byte[447];
        int n10 = 1 << n3;
        n6 = n10 - 1;
        n7 = n10 >>> 1;
        n8 = 0;
        n4 = 0;
        int n11 = 0;
        while (n11 < n5) {
            int n12 = nArray[n11];
            while (n8 < 16) {
                int n13 = n12 >>> n8;
                if ((n13 & 1) == n4) {
                    ++n8;
                    continue;
                }
                int n14 = n8;
                int n15 = (n13 & n6) + n4;
                int n16 = n15 & n7;
                n4 = n16;
                n4 >>>= n3 - 1;
                n8 = (n11 << 4) + n8;
                objectArray[n8] = (byte)(n15 - (n16 << 1));
                n8 = n14 + n3;
            }
            ++n11;
            n8 -= 16;
        }
        return objectArray;
    }

    private static void implSign(Xof object, byte[] byArray, byte[] byArray2, byte[] byArray3, int n3, byte[] byArray4, byte by, byte[] byArray5, int n4, int n5, byte[] byArray6, int n6) {
        Ed448.dom4((Xof)object, by, byArray4);
        object.update(byArray, 57, 57);
        object.update(byArray5, n4, n5);
        object.doFinal(byArray, 0, byArray.length);
        byte[] byArray7 = Ed448.reduceScalar(byArray);
        Xof xof = object;
        Xof xof2 = object;
        Xof xof3 = object;
        Xof xof4 = object;
        byte[] byArray8 = new byte[57];
        object = byArray8;
        Ed448.scalarMultBaseEncoded(byArray7, byArray8, 0);
        Ed448.dom4(xof4, by, byArray4);
        xof4.update((byte[])object, 0, 57);
        xof3.update(byArray3, n3, 57);
        xof2.update(byArray5, n4, n5);
        xof.doFinal(byArray, 0, byArray.length);
        byte[] byArray9 = Ed448.calculateS(byArray7, Ed448.reduceScalar(byArray), byArray2);
        System.arraycopy(object, 0, byArray6, n6, 57);
        int n7 = n6 + 57;
        System.arraycopy(byArray9, 0, byArray6, n7, 57);
    }

    private static void implSign(byte[] byArray, int n3, byte[] byArray2, byte by, byte[] byArray3, int n4, int n5, byte[] byArray4, int n6) {
        if (Ed448.checkContextVar(byArray2)) {
            Xof xof = Ed448.createXof();
            byte[] byArray5 = new byte[114];
            xof.update(byArray, n3, 57);
            xof.doFinal(byArray5, 0, 114);
            byArray = new byte[57];
            Ed448.pruneScalar(byArray5, 0, byArray);
            byte[] byArray6 = new byte[57];
            Ed448.scalarMultBaseEncoded(byArray, byArray6, 0);
            Ed448.implSign(xof, byArray5, byArray, byArray6, 0, byArray2, by, byArray3, n4, n5, byArray4, n6);
            return;
        }
        throw new IllegalArgumentException("ctx");
    }

    private static void implSign(byte[] byArray, int n3, byte[] byArray2, int n4, byte[] byArray3, byte by, byte[] byArray4, int n5, int n6, byte[] byArray5, int n7) {
        if (Ed448.checkContextVar(byArray3)) {
            Xof xof = Ed448.createXof();
            byte[] byArray6 = new byte[114];
            Xof xof2 = xof;
            xof2.update(byArray, n3, 57);
            xof2.doFinal(byArray6, 0, 114);
            byArray = new byte[57];
            Ed448.pruneScalar(byArray6, 0, byArray);
            Ed448.implSign(xof, byArray6, byArray, byArray2, n4, byArray3, by, byArray4, n5, n6, byArray5, n7);
            return;
        }
        throw new IllegalArgumentException("ctx");
    }

    private static boolean implVerify(byte[] byArray, int n3, byte[] objectArray, int n4, byte[] byArray2, byte by, byte[] byArray3, int n5, int n6) {
        if (Ed448.checkContextVar(byArray2)) {
            PointExt pointExt;
            PointExt pointExt2;
            int n7 = n3;
            int n8 = n7 + 57;
            byte[] byArray4 = Arrays.copyOfRange(byArray, n7, n8);
            Object[] objectArray2 = Arrays.copyOfRange(byArray, n8, n3 + 114);
            if (!Ed448.checkPointVar(byArray4)) {
                return false;
            }
            if (!Ed448.checkScalarVar(objectArray2)) {
                return false;
            }
            PointExt pointExt3 = pointExt2;
            pointExt2 = new PointExt(null);
            if (!Ed448.decodePointVar(objectArray, n4, true, pointExt3)) {
                return false;
            }
            Xof xof = Ed448.createXof();
            byte[] byArray5 = objectArray;
            objectArray = new byte[114];
            Ed448.dom4(xof, by, byArray2);
            xof.update(byArray4, 0, 57);
            xof.update(byArray5, n4, 57);
            xof.update(byArray3, n5, n6);
            xof.doFinal((byte[])objectArray, 0, 114);
            byte[] byArray6 = Ed448.reduceScalar(objectArray);
            byte[] byArray7 = objectArray2;
            objectArray2 = new int[14];
            Ed448.decodeScalar(byArray7, 0, objectArray2);
            objectArray = new int[14];
            Ed448.decodeScalar(byArray6, 0, objectArray);
            PointExt pointExt4 = pointExt;
            pointExt4(null);
            Ed448.scalarMultStrausVar(objectArray2, objectArray, pointExt3, pointExt4);
            objectArray2 = new byte[57];
            return Ed448.encodePoint(pointExt, objectArray2, 0) != 0 && Arrays.areEqual(objectArray2, byArray4);
        }
        throw new IllegalArgumentException("ctx");
    }

    private static void pointAdd(PointExt pointExt, PointExt pointExt2) {
        int[] nArray = X448Field.create();
        int[] nArray2 = X448Field.create();
        int[] nArray3 = X448Field.create();
        int[] nArray4 = X448Field.create();
        int[] nArray5 = X448Field.create();
        int[] nArray6 = X448Field.create();
        int[] nArray7 = X448Field.create();
        int[] nArray8 = X448Field.create();
        PointExt pointExt3 = pointExt;
        X448Field.mul(pointExt.z, pointExt2.z, nArray);
        X448Field.sqr(nArray, nArray2);
        X448Field.mul(pointExt3.x, pointExt2.x, nArray3);
        X448Field.mul(pointExt3.y, pointExt2.y, nArray4);
        X448Field.mul(nArray3, nArray4, nArray5);
        X448Field.mul(nArray5, 39081, nArray5);
        X448Field.add(nArray2, nArray5, nArray6);
        X448Field.sub(nArray2, nArray5, nArray7);
        X448Field.add(pointExt.x, pointExt.y, nArray2);
        X448Field.add(pointExt2.x, pointExt2.y, nArray5);
        X448Field.mul(nArray2, nArray5, nArray8);
        X448Field.add(nArray4, nArray3, nArray2);
        X448Field.sub(nArray4, nArray3, nArray5);
        X448Field.carry(nArray2);
        X448Field.sub(nArray8, nArray2, nArray8);
        X448Field.mul(nArray8, nArray, nArray8);
        X448Field.mul(nArray5, nArray, nArray5);
        X448Field.mul(nArray6, nArray8, pointExt2.x);
        X448Field.mul(nArray5, nArray7, pointExt2.y);
        X448Field.mul(nArray6, nArray7, pointExt2.z);
    }

    private static void pointAddVar(boolean bl, PointExt pointExt, PointExt pointExt2) {
        int[] nArray;
        int[] nArray2;
        int[] nArray3;
        int[] nArray4;
        int[] nArray5 = X448Field.create();
        int[] nArray6 = X448Field.create();
        int[] nArray7 = X448Field.create();
        int[] nArray8 = X448Field.create();
        int[] nArray9 = X448Field.create();
        int[] nArray10 = X448Field.create();
        int[] nArray11 = X448Field.create();
        int[] nArray12 = X448Field.create();
        if (bl) {
            X448Field.sub(pointExt.y, pointExt.x, nArray12);
            nArray4 = nArray6;
            nArray3 = nArray9;
            nArray2 = nArray10;
            nArray = nArray11;
        } else {
            X448Field.add(pointExt.y, pointExt.x, nArray12);
            nArray4 = nArray9;
            nArray3 = nArray6;
            nArray2 = nArray11;
            nArray = nArray10;
        }
        PointExt pointExt3 = pointExt;
        X448Field.mul(pointExt.z, pointExt2.z, nArray5);
        X448Field.sqr(nArray5, nArray6);
        X448Field.mul(pointExt3.x, pointExt2.x, nArray7);
        X448Field.mul(pointExt3.y, pointExt2.y, nArray8);
        X448Field.mul(nArray7, nArray8, nArray9);
        X448Field.mul(nArray9, 39081, nArray9);
        X448Field.add(nArray6, nArray9, nArray);
        X448Field.sub(nArray6, nArray9, nArray2);
        X448Field.add(pointExt2.x, pointExt2.y, nArray9);
        X448Field.mul(nArray12, nArray9, nArray12);
        X448Field.add(nArray8, nArray7, nArray3);
        X448Field.sub(nArray8, nArray7, nArray4);
        X448Field.carry(nArray3);
        X448Field.sub(nArray12, nArray6, nArray12);
        X448Field.mul(nArray12, nArray5, nArray12);
        X448Field.mul(nArray9, nArray5, nArray9);
        X448Field.mul(nArray10, nArray12, pointExt2.x);
        X448Field.mul(nArray9, nArray11, pointExt2.y);
        X448Field.mul(nArray10, nArray11, pointExt2.z);
    }

    private static void pointAddPrecomp(PointPrecomp pointPrecomp, PointExt pointExt) {
        int[] nArray = X448Field.create();
        int[] nArray2 = X448Field.create();
        int[] nArray3 = X448Field.create();
        int[] nArray4 = X448Field.create();
        int[] nArray5 = X448Field.create();
        int[] nArray6 = X448Field.create();
        int[] nArray7 = X448Field.create();
        PointPrecomp pointPrecomp2 = pointPrecomp;
        X448Field.sqr(pointExt.z, nArray);
        X448Field.mul(pointPrecomp2.x, pointExt.x, nArray2);
        X448Field.mul(pointPrecomp2.y, pointExt.y, nArray3);
        X448Field.mul(nArray2, nArray3, nArray4);
        X448Field.mul(nArray4, 39081, nArray4);
        X448Field.add(nArray, nArray4, nArray5);
        X448Field.sub(nArray, nArray4, nArray6);
        X448Field.add(pointPrecomp.x, pointPrecomp.y, nArray);
        X448Field.add(pointExt.x, pointExt.y, nArray4);
        X448Field.mul(nArray, nArray4, nArray7);
        X448Field.add(nArray3, nArray2, nArray);
        X448Field.sub(nArray3, nArray2, nArray4);
        X448Field.carry(nArray);
        X448Field.sub(nArray7, nArray, nArray7);
        X448Field.mul(nArray7, pointExt.z, nArray7);
        X448Field.mul(nArray4, pointExt.z, nArray4);
        X448Field.mul(nArray5, nArray7, pointExt.x);
        X448Field.mul(nArray4, nArray6, pointExt.y);
        X448Field.mul(nArray5, nArray6, pointExt.z);
    }

    private static PointExt pointCopy(PointExt pointExt) {
        PointExt pointExt2;
        PointExt pointExt3 = pointExt2;
        pointExt3(null);
        Ed448.pointCopy(pointExt, pointExt3);
        return pointExt2;
    }

    private static void pointCopy(PointExt pointExt, PointExt pointExt2) {
        PointExt pointExt3 = pointExt;
        X448Field.copy(pointExt3.x, 0, pointExt2.x, 0);
        X448Field.copy(pointExt3.y, 0, pointExt2.y, 0);
        X448Field.copy(pointExt3.z, 0, pointExt2.z, 0);
    }

    private static void pointDouble(PointExt pointExt) {
        int[] nArray;
        int[] nArray2 = X448Field.create();
        int[] nArray3 = X448Field.create();
        int[] nArray4 = X448Field.create();
        int[] nArray5 = X448Field.create();
        int[] nArray6 = nArray = nArray5;
        int[] nArray7 = nArray;
        int[] nArray8 = nArray;
        int[] nArray9 = X448Field.create();
        int[] nArray10 = nArray;
        int[] nArray11 = nArray;
        PointExt pointExt2 = pointExt;
        nArray = X448Field.create();
        X448Field.add(pointExt.x, pointExt.y, nArray2);
        X448Field.sqr(nArray2, nArray2);
        X448Field.sqr(pointExt2.x, nArray3);
        X448Field.sqr(pointExt2.y, nArray4);
        X448Field.add(nArray3, nArray4, nArray11);
        X448Field.carry(nArray10);
        X448Field.sqr(pointExt.z, nArray9);
        X448Field.add(nArray9, nArray9, nArray9);
        X448Field.carry(nArray9);
        X448Field.sub(nArray8, nArray9, nArray);
        X448Field.sub(nArray2, nArray7, nArray2);
        X448Field.sub(nArray3, nArray4, nArray3);
        X448Field.mul(nArray2, nArray, pointExt.x);
        X448Field.mul(nArray6, nArray3, pointExt.y);
        X448Field.mul(nArray5, nArray, pointExt.z);
    }

    private static void pointExtendXY(PointExt pointExt) {
        X448Field.one(pointExt.z);
    }

    private static void pointLookup(int n3, int n4, PointPrecomp pointPrecomp) {
        n3 = n3 * 16 * 2 * 16;
        for (int i3 = 0; i3 < 16; ++i3) {
            int n5 = (i3 ^ n4) - 1 >> 31;
            int[] nArray = precompBase;
            int[] nArray2 = pointPrecomp.x;
            X448Field.cmov(n5, nArray, n3, nArray2, 0);
            nArray = precompBase;
            nArray2 = pointPrecomp.y;
            X448Field.cmov(n5, nArray, n3 += 16, nArray2, 0);
            n3 += 16;
        }
    }

    private static void pointLookup(int[] nArray, int n3, int[] nArray2, PointExt pointExt) {
        int n4 = Ed448.getWindow4(nArray, n3);
        int n5 = n4 >>> 3 ^ 1;
        n3 = (n4 ^ -n5) & 7;
        int n6 = 0;
        for (int i3 = 0; i3 < 8; ++i3) {
            int n7 = (i3 ^ n3) - 1 >> 31;
            X448Field.cmov(n7, nArray2, n6, pointExt.x, 0);
            X448Field.cmov(n7, nArray2, n6 += 16, pointExt.y, 0);
            X448Field.cmov(n7, nArray2, n6 += 16, pointExt.z, 0);
            n6 += 16;
        }
        X448Field.cnegate(n5, pointExt.x);
    }

    private static int[] pointPrecompute(PointExt pointExt, int n3) {
        pointExt = Ed448.pointCopy(pointExt);
        PointExt pointExt2 = Ed448.pointCopy(pointExt);
        Ed448.pointDouble(pointExt2);
        int[] nArray = X448Field.createTable(n3 * 3);
        int n4 = 0;
        int n5 = 0;
        while (true) {
            PointExt pointExt3 = pointExt;
            X448Field.copy(pointExt3.x, 0, nArray, n4);
            X448Field.copy(pointExt3.y, 0, nArray, n4 += 16);
            X448Field.copy(pointExt3.z, 0, nArray, n4 += 16);
            n4 += 16;
            if (++n5 == n3) {
                return nArray;
            }
            Ed448.pointAdd(pointExt2, pointExt);
        }
    }

    private static PointExt[] pointPrecomputeVar(PointExt pointExt, int n3) {
        PointExt pointExt2 = Ed448.pointCopy(pointExt);
        Ed448.pointDouble(pointExt2);
        PointExt[] pointExtArray = new PointExt[n3];
        PointExt[] pointExtArray2 = pointExtArray;
        pointExtArray[0] = Ed448.pointCopy(pointExt);
        for (int i3 = 1; i3 < n3; ++i3) {
            PointExt pointExt3;
            pointExtArray2[i3] = pointExt3 = Ed448.pointCopy(pointExtArray2[i3 - 1]);
            Ed448.pointAddVar(false, pointExt2, pointExt3);
        }
        return pointExtArray2;
    }

    private static void pointSetNeutral(PointExt pointExt) {
        PointExt pointExt2 = pointExt;
        X448Field.zero(pointExt2.x);
        X448Field.one(pointExt2.y);
        X448Field.one(pointExt2.z);
    }

    /*
     * Exception decompiling
     */
    public static void precompute() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [38[WHILELOOP]], but top level block is 19[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void pruneScalar(byte[] byArray, int n3, byte[] byArray2) {
        byte[] byArray3 = byArray2;
        System.arraycopy(byArray, n3, byArray2, 0, 56);
        byArray3[0] = (byte)(byArray3[0] & 0xFC);
        byArray3[55] = (byte)(byArray3[55] | 0x80);
        byArray2[56] = 0;
    }

    private static byte[] reduceScalar(byte[] byArray) {
        long l3 = (long)Ed448.decode32(byArray, 0) & 0xFFFFFFFFL;
        long l4 = (long)(Ed448.decode24(byArray, 4) << 4) & 0xFFFFFFFFL;
        long l5 = (long)Ed448.decode32(byArray, 7) & 0xFFFFFFFFL;
        long l6 = (long)(Ed448.decode24(byArray, 11) << 4) & 0xFFFFFFFFL;
        long l7 = (long)Ed448.decode32(byArray, 14) & 0xFFFFFFFFL;
        long l8 = (long)(Ed448.decode24(byArray, 18) << 4) & 0xFFFFFFFFL;
        long l9 = (long)Ed448.decode32(byArray, 21) & 0xFFFFFFFFL;
        long l10 = (long)(Ed448.decode24(byArray, 25) << 4) & 0xFFFFFFFFL;
        long l11 = (long)Ed448.decode32(byArray, 28) & 0xFFFFFFFFL;
        long l12 = (long)(Ed448.decode24(byArray, 32) << 4) & 0xFFFFFFFFL;
        long l13 = (long)Ed448.decode32(byArray, 35) & 0xFFFFFFFFL;
        long l14 = (long)(Ed448.decode24(byArray, 39) << 4) & 0xFFFFFFFFL;
        long l15 = (long)Ed448.decode32(byArray, 42) & 0xFFFFFFFFL;
        long l16 = (long)(Ed448.decode24(byArray, 46) << 4) & 0xFFFFFFFFL;
        long l17 = (long)Ed448.decode32(byArray, 49) & 0xFFFFFFFFL;
        long l18 = (long)(Ed448.decode24(byArray, 53) << 4) & 0xFFFFFFFFL;
        long l19 = (long)Ed448.decode32(byArray, 56) & 0xFFFFFFFFL;
        long l20 = (long)(Ed448.decode24(byArray, 60) << 4) & 0xFFFFFFFFL;
        long l21 = (long)Ed448.decode32(byArray, 63) & 0xFFFFFFFFL;
        long l22 = (long)(Ed448.decode24(byArray, 67) << 4) & 0xFFFFFFFFL;
        long l23 = (long)Ed448.decode32(byArray, 70) & 0xFFFFFFFFL;
        long l24 = (long)(Ed448.decode24(byArray, 74) << 4) & 0xFFFFFFFFL;
        long l25 = (long)Ed448.decode32(byArray, 77) & 0xFFFFFFFFL;
        long l26 = (long)(Ed448.decode24(byArray, 81) << 4) & 0xFFFFFFFFL;
        long l27 = (long)Ed448.decode32(byArray, 84) & 0xFFFFFFFFL;
        long l28 = (long)(Ed448.decode24(byArray, 88) << 4) & 0xFFFFFFFFL;
        long l29 = (long)Ed448.decode32(byArray, 91) & 0xFFFFFFFFL;
        long l30 = (long)(Ed448.decode24(byArray, 95) << 4) & 0xFFFFFFFFL;
        long l31 = (long)Ed448.decode32(byArray, 98) & 0xFFFFFFFFL;
        long l32 = (long)(Ed448.decode24(byArray, 102) << 4) & 0xFFFFFFFFL;
        long l33 = (long)Ed448.decode32(byArray, 105) & 0xFFFFFFFFL;
        long l34 = (long)(Ed448.decode24(byArray, 109) << 4) & 0xFFFFFFFFL;
        long l35 = (long)Ed448.decode16(byArray, 112) & 0xFFFFFFFFL;
        l19 = l35 * 43969588L + l19;
        l20 = l35 * 30366549L + l20;
        l21 = l35 * 163752818L + l21;
        l22 = l35 * 258169998L + l22;
        l23 = l35 * 96434764L + l23;
        l24 = l35 * 227822194L + l24;
        l25 = l35 * 149865618L + l25;
        long l36 = l35 * 550336261L + l26;
        long l37 = l34 + (l33 >>> 28);
        l26 = l33 & 0xFFFFFFFL;
        l18 = l37 * 43969588L + l18;
        l19 = l37 * 30366549L + l19;
        l20 = l37 * 163752818L + l20;
        l21 = l37 * 258169998L + l21;
        l22 = l37 * 96434764L + l22;
        l23 = l37 * 227822194L + l23;
        l24 = l37 * 149865618L + l24;
        long l38 = l37 * 550336261L + l25;
        long l39 = l26;
        l17 = l39 * 43969588L + l17;
        l18 = l39 * 30366549L + l18;
        l19 = l39 * 163752818L + l19;
        l20 = l39 * 258169998L + l20;
        l21 = l39 * 96434764L + l21;
        l22 = l39 * 227822194L + l22;
        l23 = l39 * 149865618L + l23;
        long l40 = l39 * 550336261L + l24;
        long l41 = l32 + (l31 >>> 28);
        l24 = l31 & 0xFFFFFFFL;
        l16 = l41 * 43969588L + l16;
        l17 = l41 * 30366549L + l17;
        l18 = l41 * 163752818L + l18;
        l19 = l41 * 258169998L + l19;
        l20 = l41 * 96434764L + l20;
        l21 = l41 * 227822194L + l21;
        l22 = l41 * 149865618L + l22;
        l23 = l41 * 550336261L + l23;
        long l42 = l24;
        l15 = l42 * 43969588L + l15;
        l16 = l42 * 30366549L + l16;
        l17 = l42 * 163752818L + l17;
        l18 = l42 * 258169998L + l18;
        l19 = l42 * 96434764L + l19;
        l20 = l42 * 227822194L + l20;
        l21 = l42 * 149865618L + l21;
        l22 = l42 * 550336261L + l22;
        l24 = l30 + (l29 >>> 28);
        long l43 = l29 & 0xFFFFFFFL;
        long l44 = l24;
        l14 = l44 * 43969588L + l14;
        l15 = l44 * 30366549L + l15;
        l16 = l44 * 163752818L + l16;
        l17 = l44 * 258169998L + l17;
        l18 = l44 * 96434764L + l18;
        l19 = l44 * 227822194L + l19;
        l20 = l44 * 149865618L + l20;
        l21 = l44 * 550336261L + l21;
        l13 = l43 * 43969588L + l13;
        l14 = l43 * 30366549L + l14;
        l15 = l43 * 163752818L + l15;
        l16 = l43 * 258169998L + l16;
        l17 = l43 * 96434764L + l17;
        l18 = l43 * 227822194L + l18;
        l19 = l43 * 149865618L + l19;
        l20 = l43 * 550336261L + l20;
        long l45 = l28 + (l27 >>> 28);
        l24 = l27 & 0xFFFFFFFL;
        l12 = l45 * 43969588L + l12;
        l13 = l45 * 30366549L + l13;
        l14 = l45 * 163752818L + l14;
        l15 = l45 * 258169998L + l15;
        l16 = l45 * 96434764L + l16;
        l17 = l45 * 227822194L + l17;
        l18 = l45 * 149865618L + l18;
        l19 = l45 * 550336261L + l19;
        l25 = l40 + (l23 >>> 28);
        l23 &= 0xFFFFFFFL;
        l26 = l38 + (l25 >>> 28);
        l25 &= 0xFFFFFFFL;
        l27 = l36 + (l26 >>> 28);
        long l46 = l24;
        l24 = l26 & 0xFFFFFFFL;
        l26 = l46 + (l27 >>> 28);
        long l47 = l27 & 0xFFFFFFFL;
        long l48 = l26;
        l11 = l48 * 43969588L + l11;
        l12 = l48 * 30366549L + l12;
        l13 = l48 * 163752818L + l13;
        l14 = l48 * 258169998L + l14;
        l15 = l48 * 96434764L + l15;
        l16 = l48 * 227822194L + l16;
        l17 = l48 * 149865618L + l17;
        l18 = l48 * 550336261L + l18;
        l10 = l47 * 43969588L + l10;
        l11 = l47 * 30366549L + l11;
        l12 = l47 * 163752818L + l12;
        l13 = l47 * 258169998L + l13;
        l14 = l47 * 96434764L + l14;
        l15 = l47 * 227822194L + l15;
        l16 = l47 * 149865618L + l16;
        long l49 = l47 * 550336261L + l17;
        l17 = l49;
        long l50 = l18;
        long l51 = l17;
        long l52 = l24;
        l9 = l52 * 43969588L + l9;
        l10 = l52 * 30366549L + l10;
        l11 = l52 * 163752818L + l11;
        l12 = l52 * 258169998L + l12;
        l13 = l52 * 96434764L + l13;
        l14 = l52 * 227822194L + l14;
        l15 = l52 * 149865618L + l15;
        l16 = l52 * 550336261L + l16;
        l17 = l21 + (l20 >>> 28);
        l18 = l20 & 0xFFFFFFFL;
        long l53 = l22 + (l17 >>> 28);
        l20 = l53;
        l17 &= 0xFFFFFFFL;
        l20 = l23 + (l20 >>> 28);
        long l54 = l53 & 0xFFFFFFFL;
        long l55 = l20;
        l20 = l25 + (l20 >>> 28);
        long l56 = l55 & 0xFFFFFFFL;
        long l57 = l20;
        l8 = l57 * 43969588L + l8;
        l9 = l57 * 30366549L + l9;
        l10 = l57 * 163752818L + l10;
        l11 = l57 * 258169998L + l11;
        l12 = l57 * 96434764L + l12;
        l13 = l57 * 227822194L + l13;
        l14 = l57 * 149865618L + l14;
        l15 = l57 * 550336261L + l15;
        l7 = l56 * 43969588L + l7;
        l8 = l56 * 30366549L + l8;
        l9 = l56 * 163752818L + l9;
        l10 = l56 * 258169998L + l10;
        l11 = l56 * 96434764L + l11;
        l12 = l56 * 227822194L + l12;
        l13 = l56 * 149865618L + l13;
        l14 = l56 * 550336261L + l14;
        l6 = l54 * 43969588L + l6;
        l7 = l54 * 30366549L + l7;
        l8 = l54 * 163752818L + l8;
        l9 = l54 * 258169998L + l9;
        l10 = l54 * 96434764L + l10;
        l11 = l54 * 227822194L + l11;
        l12 = l54 * 149865618L + l12;
        l13 = l54 * 550336261L + l13;
        l20 = l50 + (l51 >>> 28);
        long l58 = l16;
        long l59 = l15;
        long l60 = l14;
        long l61 = l13;
        l13 = l19 + (l20 >>> 28);
        l14 = l20 & 0xFFFFFFFL;
        l15 = l18 + (l13 >>> 28);
        l13 &= 0xFFFFFFFL;
        long l62 = l17 + (l15 >>> 28);
        l15 &= 0xFFFFFFFL;
        l5 = l62 * 43969588L + l5;
        l6 = l62 * 30366549L + l6;
        l7 = l62 * 163752818L + l7;
        l8 = l62 * 258169998L + l8;
        l9 = l62 * 96434764L + l9;
        l10 = l62 * 227822194L + l10;
        l11 = l62 * 149865618L + l11;
        long l63 = l62 * 550336261L + l12;
        long l64 = l15;
        l4 = l64 * 43969588L + l4;
        l5 = l64 * 30366549L + l5;
        l6 = l64 * 163752818L + l6;
        l7 = l64 * 258169998L + l7;
        l8 = l64 * 96434764L + l8;
        l9 = l64 * 227822194L + l9;
        l10 = l64 * 149865618L + l10;
        long l65 = l64 * 550336261L + l11;
        l11 = l14 & 0x3FFFFFFL;
        long l66 = l13 * 4L + (l14 >>> 26) + 1L;
        l3 = l66 * 78101261L + l3;
        l4 = l66 * 141809365L + l4;
        l5 = l66 * 175155932L + l5;
        l6 = l66 * 64542499L + l6;
        l7 = l66 * 158326419L + l7;
        l8 = l66 * 191173276L + l8;
        l9 = l66 * 104575268L + l9;
        l4 += l3 >>> 28;
        l3 &= 0xFFFFFFFL;
        l5 += l4 >>> 28;
        l4 &= 0xFFFFFFFL;
        l6 += l5 >>> 28;
        l5 &= 0xFFFFFFFL;
        l7 += l6 >>> 28;
        l6 &= 0xFFFFFFFL;
        l8 += l7 >>> 28;
        l7 &= 0xFFFFFFFL;
        l9 += l8 >>> 28;
        l8 &= 0xFFFFFFFL;
        l10 = l66 * 137584065L + l10 + (l9 >>> 28);
        l9 &= 0xFFFFFFFL;
        l12 = l65 + (l10 >>> 28);
        l10 &= 0xFFFFFFFL;
        l13 = l63 + (l12 >>> 28);
        l12 &= 0xFFFFFFFL;
        l14 = l61 + (l13 >>> 28);
        l13 &= 0xFFFFFFFL;
        l15 = l60 + (l14 >>> 28);
        l14 &= 0xFFFFFFFL;
        l16 = l59 + (l15 >>> 28);
        l15 &= 0xFFFFFFFL;
        l17 = l58 + (l16 >>> 28);
        l16 &= 0xFFFFFFFL;
        l18 = (l49 & 0xFFFFFFFL) + (l17 >>> 28);
        long l67 = l11;
        l11 = l17 & 0xFFFFFFFL;
        l17 = l67 + (l18 >>> 28);
        long l68 = l11;
        long l69 = l10;
        l10 = l17 & 0x3FFFFFFL;
        l11 = (l17 >>> 26) - 1L;
        l3 -= l11 & 0x4A7BB0DL;
        l4 -= l11 & 0x873D6D5L;
        l5 -= l11 & 0xA70AADCL;
        l6 -= l11 & 0x3D8D723L;
        l7 -= l11 & 0x96FDE93L;
        l8 -= l11 & 0xB65129CL;
        l9 -= l11 & 0x63BB124L;
        l4 += l3 >> 28;
        l3 &= 0xFFFFFFFL;
        l5 += l4 >> 28;
        l4 &= 0xFFFFFFFL;
        l6 += l5 >> 28;
        l5 &= 0xFFFFFFFL;
        l7 += l6 >> 28;
        l6 &= 0xFFFFFFFL;
        l8 += l7 >> 28;
        l7 &= 0xFFFFFFFL;
        l9 += l8 >> 28;
        l8 &= 0xFFFFFFFL;
        l11 = l69 - (l11 & 0x8335DC1L) + (l9 >> 28);
        l9 &= 0xFFFFFFFL;
        l12 += l11 >> 28;
        l11 &= 0xFFFFFFFL;
        l13 += l12 >> 28;
        l12 &= 0xFFFFFFFL;
        l14 += l13 >> 28;
        l13 &= 0xFFFFFFFL;
        l15 += l14 >> 28;
        l14 &= 0xFFFFFFFL;
        l16 += l15 >> 28;
        l15 &= 0xFFFFFFFL;
        l17 = l68 + (l16 >> 28);
        l16 &= 0xFFFFFFFL;
        l18 = (l18 & 0xFFFFFFFL) + (l17 >> 28);
        long l70 = l10;
        l10 = l17 & 0xFFFFFFFL;
        l17 = l70 + (l18 >> 28);
        l18 &= 0xFFFFFFFL;
        byArray = new byte[57];
        Ed448.encode56(l3 | l4 << 28, byArray, 0);
        Ed448.encode56(l5 | l6 << 28, byArray, 7);
        Ed448.encode56(l7 | l8 << 28, byArray, 14);
        Ed448.encode56(l9 | l11 << 28, byArray, 21);
        Ed448.encode56(l12 | l13 << 28, byArray, 28);
        Ed448.encode56(l14 | l15 << 28, byArray, 35);
        Ed448.encode56(l16 | l10 << 28, byArray, 42);
        Ed448.encode56(l18 | l17 << 28, byArray, 49);
        return byArray;
    }

    private static void scalarMult(byte[] objectArray, PointExt pointExt, PointExt pointExt2) {
        PointExt pointExt3;
        int[] nArray = new int[14];
        Ed448.decodeScalar(objectArray, 0, nArray);
        Nat.shiftDownBits(14, nArray, 2, 0);
        objectArray = L;
        Nat.cadd(14, ~nArray[0] & 1, nArray, objectArray, nArray);
        Nat.shiftDownBit(14, nArray, 1);
        objectArray = Ed448.pointPrecompute(pointExt, 8);
        pointExt = pointExt3;
        pointExt3 = new PointExt(null);
        Ed448.pointLookup(nArray, 111, objectArray, pointExt2);
        for (int i3 = 110; i3 >= 0; --i3) {
            for (int i4 = 0; i4 < 4; ++i4) {
                Ed448.pointDouble(pointExt2);
            }
            Ed448.pointLookup(nArray, i3, objectArray, pointExt);
            Ed448.pointAdd(pointExt, pointExt2);
        }
        for (int i5 = 0; i5 < 2; ++i5) {
            Ed448.pointDouble(pointExt2);
        }
    }

    private static void scalarMultBase(byte[] object, PointExt pointExt) {
        PointPrecomp pointPrecomp;
        Ed448.precompute();
        int[] nArray = new int[15];
        int[] nArray2 = nArray;
        Ed448.decodeScalar(object, 0, nArray2);
        object = L;
        nArray[14] = Nat.cadd(14, ~nArray[0] & 1, nArray2, object, nArray2) + 4;
        Nat.shiftDownBit(15, nArray2, 0);
        object = pointPrecomp;
        pointPrecomp = new PointPrecomp(null);
        Ed448.pointSetNeutral(pointExt);
        int n3 = 17;
        while (true) {
            int n4 = n3;
            for (int i3 = 0; i3 < 5; ++i3) {
                int n5;
                int n6 = 0;
                for (n5 = 0; n5 < 5; ++n5) {
                    int n7 = n6;
                    n6 = nArray2[n4 >>> 5] >>> (n4 & 0x1F);
                    n6 = n7 & ~(1 << n5) ^ n6 << n5;
                    n4 += 18;
                }
                n5 = n6 >>> 4 & 1;
                Ed448.pointLookup(i3, (n6 ^ -n5) & 0xF, (PointPrecomp)object);
                X448Field.cnegate(n5, object.x);
                Ed448.pointAddPrecomp((PointPrecomp)object, pointExt);
            }
            if ((n3 += -1) < 0) {
                return;
            }
            Ed448.pointDouble(pointExt);
        }
    }

    private static void scalarMultBaseEncoded(byte[] byArray, byte[] byArray2, int n3) {
        PointExt pointExt;
        PointExt pointExt2;
        PointExt pointExt3 = pointExt2 = pointExt;
        pointExt3(null);
        Ed448.scalarMultBase(byArray, pointExt3);
        if (Ed448.encodePoint(pointExt, byArray2, n3) != 0) {
            return;
        }
        throw new IllegalStateException();
    }

    public static void scalarMultBaseXY(X448.Friend object, byte[] objectArray, int n3, int[] nArray, int[] nArray2) {
        if (object != null) {
            PointExt pointExt;
            byte[] byArray = new byte[57];
            object = byArray;
            Ed448.pruneScalar(objectArray, n3, (byte[])object);
            object = pointExt;
            Ed448.scalarMultBase(byArray, new PointExt(null));
            Object object2 = object;
            objectArray = ((PointExt)object2).y;
            if (Ed448.checkPoint(((PointExt)object).x, objectArray, ((PointExt)object2).z) != 0) {
                Object object3 = object;
                X448Field.copy(((PointExt)object3).x, 0, nArray, 0);
                X448Field.copy(((PointExt)object3).y, 0, nArray2, 0);
                return;
            }
            throw new IllegalStateException();
        }
        throw new NullPointerException("This method is only for use by X448");
    }

    private static void scalarMultStrausVar(int[] objectArray, int[] objectArray2, PointExt pointExtArray, PointExt pointExt) {
        Ed448.precompute();
        objectArray = Ed448.getWnafVar(objectArray, 7);
        objectArray2 = Ed448.getWnafVar(objectArray2, 5);
        pointExtArray = Ed448.pointPrecomputeVar((PointExt)pointExtArray, 8);
        Ed448.pointSetNeutral(pointExt);
        int n3 = 446;
        while (true) {
            int n4;
            if ((n4 = objectArray[n3]) != 0) {
                int n5 = n4 >> 31;
                n4 = (n4 ^ n5) >>> 1;
                Ed448.pointAddVar(n5 != 0, precompBaseTable[n4], pointExt);
            }
            if ((n4 = objectArray2[n3]) != 0) {
                int n6 = n4 >> 31;
                n4 = (n4 ^ n6) >>> 1;
                Ed448.pointAddVar(n6 != 0, pointExtArray[n4], pointExt);
            }
            if ((n3 += -1) < 0) {
                return;
            }
            Ed448.pointDouble(pointExt);
        }
    }

    public static void sign(byte[] byArray, int n3, byte[] byArray2, byte[] byArray3, int n4, int n5, byte[] byArray4, int n6) {
        Ed448.implSign(byArray, n3, byArray2, (byte)0, byArray3, n4, n5, byArray4, n6);
    }

    public static void sign(byte[] byArray, int n3, byte[] byArray2, int n4, byte[] byArray3, byte[] byArray4, int n5, int n6, byte[] byArray5, int n7) {
        Ed448.implSign(byArray, n3, byArray2, n4, byArray3, (byte)0, byArray4, n5, n6, byArray5, n7);
    }

    public static void signPrehash(byte[] byArray, int n3, byte[] byArray2, byte[] byArray3, int n4, byte[] byArray4, int n5) {
        Ed448.implSign(byArray, n3, byArray2, (byte)1, byArray3, n4, 64, byArray4, n5);
    }

    public static void signPrehash(byte[] byArray, int n3, byte[] byArray2, int n4, byte[] byArray3, byte[] byArray4, int n5, byte[] byArray5, int n6) {
        Ed448.implSign(byArray, n3, byArray2, n4, byArray3, (byte)1, byArray4, n5, 64, byArray5, n6);
    }

    public static void signPrehash(byte[] byArray, int n3, byte[] byArray2, Xof object, byte[] byArray3, int n4) {
        Xof xof = object;
        byte[] byArray4 = new byte[64];
        object = byArray4;
        if (64 == xof.doFinal(byArray4, 0, 64)) {
            Ed448.implSign(byArray, n3, byArray2, (byte)1, (byte[])object, 0, 64, byArray3, n4);
            return;
        }
        throw new IllegalArgumentException("ph");
    }

    public static void signPrehash(byte[] byArray, int n3, byte[] byArray2, int n4, byte[] byArray3, Xof object, byte[] byArray4, int n5) {
        Xof xof = object;
        byte[] byArray5 = new byte[64];
        object = byArray5;
        if (64 == xof.doFinal(byArray5, 0, 64)) {
            Ed448.implSign(byArray, n3, byArray2, n4, byArray3, (byte)1, (byte[])object, 0, 64, byArray4, n5);
            return;
        }
        throw new IllegalArgumentException("ph");
    }

    public static boolean verify(byte[] byArray, int n3, byte[] byArray2, int n4, byte[] byArray3, byte[] byArray4, int n5, int n6) {
        return Ed448.implVerify(byArray, n3, byArray2, n4, byArray3, (byte)0, byArray4, n5, n6);
    }

    public static boolean verifyPrehash(byte[] byArray, int n3, byte[] byArray2, int n4, byte[] byArray3, byte[] byArray4, int n5) {
        return Ed448.implVerify(byArray, n3, byArray2, n4, byArray3, (byte)1, byArray4, n5, 64);
    }

    public static boolean verifyPrehash(byte[] byArray, int n3, byte[] byArray2, int n4, byte[] byArray3, Xof object) {
        Xof xof = object;
        byte[] byArray4 = new byte[64];
        object = byArray4;
        if (64 == xof.doFinal(byArray4, 0, 64)) {
            return Ed448.implVerify(byArray, n3, byArray2, n4, byArray3, (byte)1, (byte[])object, 0, 64);
        }
        throw new IllegalArgumentException("ph");
    }

    public static class PointPrecomp {
        public int[] x = X448Field.create();
        public int[] y = X448Field.create();

        private PointPrecomp() {
        }

        public /* synthetic */ PointPrecomp(1 var1_1) {
            this();
        }
    }

    public static class PointExt {
        public int[] x = X448Field.create();
        public int[] y = X448Field.create();
        public int[] z = X448Field.create();

        private PointExt() {
        }

        public /* synthetic */ PointExt(1 var1_1) {
            this();
        }
    }

    public static class F
    extends X448Field {
        private F() {
        }
    }

    public static final class Algorithm {
        public static final int Ed448 = 0;
        public static final int Ed448ph = 1;
    }
}

