/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.tools;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.ECNamedCurveTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ECParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.ec.CustomNamedCurves;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECAlgorithms;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECConstants;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.TreeSet;

public class DiscoverEndomorphisms {
    private static final int radix = 16;

    public static void main(String[] object) {
        if (((String[])object).length > 0) {
            for (int i3 = 0; i3 < ((String[])object).length; ++i3) {
                DiscoverEndomorphisms.discoverEndomorphisms(object[i3]);
            }
        } else {
            TreeSet treeSet = new TreeSet(DiscoverEndomorphisms.enumToList(ECNamedCurveTable.getNames()));
            treeSet.addAll(DiscoverEndomorphisms.enumToList(CustomNamedCurves.getNames()));
            object = treeSet.iterator();
            while (object.hasNext()) {
                DiscoverEndomorphisms.discoverEndomorphisms((String)object.next());
            }
        }
    }

    public static void discoverEndomorphisms(X9ECParameters x9ECParameters) {
        if (x9ECParameters != null) {
            DiscoverEndomorphisms.discoverEndomorphisms(x9ECParameters, "<UNKNOWN>");
            return;
        }
        throw new NullPointerException("x9");
    }

    private static void discoverEndomorphisms(String string2) {
        X9ECParameters x9ECParameters = CustomNamedCurves.getByName(string2);
        if (x9ECParameters == null && (x9ECParameters = ECNamedCurveTable.getByName(string2)) == null) {
            System.err.println("Unknown curve: " + string2);
            return;
        }
        DiscoverEndomorphisms.discoverEndomorphisms(x9ECParameters, string2);
    }

    private static void discoverEndomorphisms(X9ECParameters x9ECParameters, String string2) {
        ECCurve eCCurve = x9ECParameters.getCurve();
        if (ECAlgorithms.isFpCurve(eCCurve)) {
            ECCurve eCCurve2 = eCCurve;
            BigInteger bigInteger = eCCurve2.getField().getCharacteristic();
            if (eCCurve2.getB().isZero() && bigInteger.mod(ECConstants.FOUR).equals(ECConstants.ONE)) {
                System.out.println("Curve '" + string2 + "' has a 'GLV Type A' endomorphism with these parameters:");
                DiscoverEndomorphisms.printGLVTypeAParameters(x9ECParameters);
            }
            if (eCCurve.getA().isZero() && bigInteger.mod(ECConstants.THREE).equals(ECConstants.ONE)) {
                System.out.println("Curve '" + string2 + "' has a 'GLV Type B' endomorphism with these parameters:");
                DiscoverEndomorphisms.printGLVTypeBParameters(x9ECParameters);
            }
        }
    }

    private static void printGLVTypeAParameters(X9ECParameters eCFieldElementArray) {
        BigInteger bigInteger = ECConstants.ONE;
        BigInteger[] bigIntegerArray = DiscoverEndomorphisms.solveQuadraticEquation(eCFieldElementArray.getN(), bigInteger, ECConstants.ZERO, bigInteger);
        eCFieldElementArray = DiscoverEndomorphisms.findNonTrivialOrder4FieldElements(eCFieldElementArray.getCurve());
        DiscoverEndomorphisms.printGLVTypeAParameters((X9ECParameters)eCFieldElementArray, bigIntegerArray[0], eCFieldElementArray);
        System.out.println("OR");
        DiscoverEndomorphisms.printGLVTypeAParameters((X9ECParameters)eCFieldElementArray, bigIntegerArray[1], eCFieldElementArray);
    }

    private static void printGLVTypeAParameters(X9ECParameters x9ECParameters, BigInteger bigInteger, ECFieldElement[] eCFieldElementArray) {
        ECPoint eCPoint = x9ECParameters.getG().normalize();
        ECPoint eCPoint2 = eCPoint.multiply(bigInteger).normalize();
        if (eCPoint.getXCoord().negate().equals(eCPoint2.getXCoord())) {
            ECFieldElement eCFieldElement = eCFieldElementArray[0];
            if (!eCPoint.getYCoord().multiply(eCFieldElement).equals(eCPoint2.getYCoord())) {
                eCFieldElement = eCFieldElementArray[1];
                if (!eCPoint.getYCoord().multiply(eCFieldElement).equals(eCPoint2.getYCoord())) {
                    throw new IllegalStateException("Derivation of GLV Type A parameters failed unexpectedly");
                }
            }
            DiscoverEndomorphisms.printProperty("Point map", "lambda * (x, y) = (-x, i * y)");
            DiscoverEndomorphisms.printProperty("i", eCFieldElement.toBigInteger().toString(16));
            DiscoverEndomorphisms.printProperty("lambda", bigInteger.toString(16));
            DiscoverEndomorphisms.printScalarDecompositionParameters(x9ECParameters.getN(), bigInteger);
            return;
        }
        throw new IllegalStateException("Derivation of GLV Type A parameters failed unexpectedly");
    }

    private static void printGLVTypeBParameters(X9ECParameters eCFieldElementArray) {
        BigInteger bigInteger = ECConstants.ONE;
        BigInteger[] bigIntegerArray = DiscoverEndomorphisms.solveQuadraticEquation(eCFieldElementArray.getN(), bigInteger, bigInteger, bigInteger);
        eCFieldElementArray = DiscoverEndomorphisms.findNonTrivialOrder3FieldElements(eCFieldElementArray.getCurve());
        DiscoverEndomorphisms.printGLVTypeBParameters((X9ECParameters)eCFieldElementArray, bigIntegerArray[0], eCFieldElementArray);
        System.out.println("OR");
        DiscoverEndomorphisms.printGLVTypeBParameters((X9ECParameters)eCFieldElementArray, bigIntegerArray[1], eCFieldElementArray);
    }

    private static void printGLVTypeBParameters(X9ECParameters x9ECParameters, BigInteger bigInteger, ECFieldElement[] eCFieldElementArray) {
        ECPoint eCPoint = x9ECParameters.getG().normalize();
        ECPoint eCPoint2 = eCPoint.multiply(bigInteger).normalize();
        if (eCPoint.getYCoord().equals(eCPoint2.getYCoord())) {
            ECFieldElement eCFieldElement = eCFieldElementArray[0];
            if (!eCPoint.getXCoord().multiply(eCFieldElement).equals(eCPoint2.getXCoord())) {
                eCFieldElement = eCFieldElementArray[1];
                if (!eCPoint.getXCoord().multiply(eCFieldElement).equals(eCPoint2.getXCoord())) {
                    throw new IllegalStateException("Derivation of GLV Type B parameters failed unexpectedly");
                }
            }
            DiscoverEndomorphisms.printProperty("Point map", "lambda * (x, y) = (beta * x, y)");
            DiscoverEndomorphisms.printProperty("beta", eCFieldElement.toBigInteger().toString(16));
            DiscoverEndomorphisms.printProperty("lambda", bigInteger.toString(16));
            DiscoverEndomorphisms.printScalarDecompositionParameters(x9ECParameters.getN(), bigInteger);
            return;
        }
        throw new IllegalStateException("Derivation of GLV Type B parameters failed unexpectedly");
    }

    private static void printProperty(String string2, Object object) {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer;
        new StringBuffer("  ").append(string2);
        while (stringBuffer2.length() < 20) {
            stringBuffer2.append(' ');
        }
        stringBuffer2.append(": ");
        stringBuffer2.append(object.toString());
        System.out.println(stringBuffer2.toString());
    }

    private static void printScalarDecompositionParameters(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3;
        BigInteger bigInteger4;
        BigInteger[] bigIntegerArray;
        Object object;
        BigInteger[] bigIntegerArray2 = DiscoverEndomorphisms.extEuclidGLV(bigInteger, bigInteger2);
        BigInteger[] bigIntegerArray3 = new BigInteger[2];
        BigInteger[] bigIntegerArray4 = bigIntegerArray3;
        bigIntegerArray4[0] = bigIntegerArray2[2];
        bigIntegerArray3[1] = bigIntegerArray2[3].negate();
        if (!DiscoverEndomorphisms.isVectorBoundedBySqrt(bigIntegerArray2 = DiscoverEndomorphisms.chooseShortest(new BigInteger[]{bigIntegerArray2[0], bigIntegerArray2[1].negate()}, new BigInteger[]{bigIntegerArray2[4], bigIntegerArray2[5].negate()}), bigInteger) && DiscoverEndomorphisms.areRelativelyPrime(bigIntegerArray4[0], bigIntegerArray4[1]) && (object = DiscoverEndomorphisms.extEuclidBezout(new BigInteger[]{(bigIntegerArray = (bigInteger4 = bigIntegerArray4[0]).add((bigInteger3 = bigIntegerArray4[1]).multiply(bigInteger2)).divide(bigInteger)).abs(), bigInteger3.abs()})) != null) {
            object = object[0];
            BigInteger bigInteger5 = object[1];
            if (bigIntegerArray.signum() < 0) {
                object = ((BigInteger)object).negate();
            }
            if (bigInteger3.signum() > 0) {
                bigInteger5 = bigInteger5.negate();
            }
            if (bigIntegerArray.multiply((BigInteger)object).subtract(bigInteger3.multiply(bigInteger5)).equals(bigIntegerArray = ECConstants.ONE)) {
                bigInteger2 = bigInteger5.multiply(bigInteger).subtract(((BigInteger)object).multiply(bigInteger2));
                bigInteger5 = bigInteger2.negate();
                bigIntegerArray = DiscoverEndomorphisms.isqrt(bigInteger.subtract((BigInteger)bigIntegerArray)).add((BigInteger)bigIntegerArray);
                bigIntegerArray = DiscoverEndomorphisms.intersect(DiscoverEndomorphisms.calculateRange(((BigInteger)object).negate(), (BigInteger)bigIntegerArray, bigInteger3), DiscoverEndomorphisms.calculateRange(bigInteger5, (BigInteger)bigIntegerArray, bigInteger4));
                if (bigIntegerArray != null) {
                    bigInteger5 = bigIntegerArray[0];
                    while (bigInteger5.compareTo(bigIntegerArray[1]) <= 0) {
                        BigInteger[] bigIntegerArray5 = new BigInteger[]{bigInteger2.add(bigInteger5.multiply(bigInteger4)), ((BigInteger)object).add(bigInteger5.multiply(bigInteger3))};
                        if (DiscoverEndomorphisms.isShorter(bigIntegerArray5, bigIntegerArray2)) {
                            bigIntegerArray2 = bigIntegerArray5;
                        }
                        bigInteger5 = bigInteger5.add(ECConstants.ONE);
                    }
                }
            } else {
                throw new IllegalStateException();
            }
        }
        bigInteger2 = bigIntegerArray4[0].multiply(bigIntegerArray2[1]).subtract(bigIntegerArray4[1].multiply(bigIntegerArray2[0]));
        int n3 = bigInteger.bitLength() + 16 - (bigInteger.bitLength() & 7);
        bigInteger4 = DiscoverEndomorphisms.roundQuotient(bigIntegerArray2[1].shiftLeft(n3), bigInteger2);
        BigInteger bigInteger6 = DiscoverEndomorphisms.roundQuotient(bigIntegerArray4[1].shiftLeft(n3), bigInteger2).negate();
        DiscoverEndomorphisms.printProperty("v1", b.a("{ ").append(bigIntegerArray4[0].toString(16)).append(", ").append(bigIntegerArray4[1].toString(16)).append(" }").toString());
        DiscoverEndomorphisms.printProperty("v2", b.a("{ ").append(bigIntegerArray2[0].toString(16)).append(", ").append(bigIntegerArray2[1].toString(16)).append(" }").toString());
        DiscoverEndomorphisms.printProperty("d", bigInteger2.toString(16));
        DiscoverEndomorphisms.printProperty("(OPT) g1", bigInteger4.toString(16));
        DiscoverEndomorphisms.printProperty("(OPT) g2", bigInteger6.toString(16));
        DiscoverEndomorphisms.printProperty("(OPT) bits", Integer.toString(n3));
    }

    private static boolean areRelativelyPrime(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.gcd(bigInteger2).equals(ECConstants.ONE);
    }

    private static BigInteger[] calculateRange(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        return DiscoverEndomorphisms.order(bigInteger.subtract(bigInteger2).divide(bigInteger3), bigInteger.add(bigInteger2).divide(bigInteger3));
    }

    private static ArrayList enumToList(Enumeration enumeration) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        while (enumeration.hasMoreElements()) {
            arrayList2.add(enumeration.nextElement());
        }
        return arrayList2;
    }

    private static BigInteger[] extEuclidBezout(BigInteger[] object) {
        boolean bl = object[0].compareTo(object[1]) < 0;
        if (bl) {
            DiscoverEndomorphisms.swap((BigInteger[])object);
        }
        object = object[0];
        Object object2 = object[1];
        BigInteger bigInteger = ECConstants.ONE;
        BigInteger bigInteger2 = ECConstants.ZERO;
        Object object3 = object2;
        BigInteger bigInteger3 = bigInteger;
        BigInteger bigInteger4 = bigInteger2;
        object2 = object;
        object = object3;
        while (((BigInteger)object).compareTo(ECConstants.ONE) > 0) {
            BigInteger bigInteger5 = bigInteger4;
            object2 = ((BigInteger)object2).divideAndRemainder((BigInteger)object);
            bigInteger4 = object2[0];
            object2 = object2[1];
            bigInteger = bigInteger.subtract(bigInteger4.multiply(bigInteger2));
            bigInteger4 = bigInteger5.subtract(bigInteger4.multiply(bigInteger3));
            Object object4 = object2;
            BigInteger bigInteger6 = bigInteger2;
            BigInteger bigInteger7 = bigInteger3;
            bigInteger3 = bigInteger4;
            bigInteger4 = bigInteger7;
            bigInteger2 = bigInteger;
            bigInteger = bigInteger6;
            object2 = object;
            object = object4;
        }
        if (((BigInteger)object).signum() <= 0) {
            return null;
        }
        BigInteger[] bigIntegerArray = new BigInteger[2];
        object = bigIntegerArray;
        bigIntegerArray[0] = bigInteger2;
        bigIntegerArray[1] = bigInteger3;
        if (bl) {
            DiscoverEndomorphisms.swap((BigInteger[])object);
        }
        return object;
    }

    private static BigInteger[] extEuclidGLV(BigInteger object, BigInteger object2) {
        BigInteger bigInteger = ECConstants.ZERO;
        BigInteger bigInteger2 = ECConstants.ONE;
        Object object3 = object;
        while (true) {
            BigInteger[] bigIntegerArray = object3.divideAndRemainder((BigInteger)object2);
            Object object4 = bigIntegerArray;
            object4 = object4[1];
            BigInteger bigInteger3 = bigInteger.subtract(bigIntegerArray[0].multiply(bigInteger2));
            if (DiscoverEndomorphisms.isLessThanSqrt((BigInteger)object2, (BigInteger)object)) {
                return new BigInteger[]{object3, bigInteger, object2, bigInteger2, object4, bigInteger3};
            }
            Object object5 = object2;
            BigInteger bigInteger4 = bigInteger2;
            bigInteger2 = bigInteger3;
            bigInteger = bigInteger4;
            object2 = object4;
            object3 = object5;
        }
    }

    private static BigInteger[] chooseShortest(BigInteger[] bigIntegerArray, BigInteger[] bigIntegerArray2) {
        if (!DiscoverEndomorphisms.isShorter(bigIntegerArray, bigIntegerArray2)) {
            bigIntegerArray = bigIntegerArray2;
        }
        return bigIntegerArray;
    }

    private static BigInteger[] intersect(BigInteger[] object, BigInteger[] bigIntegerArray) {
        BigInteger bigInteger = object[0].max(bigIntegerArray[0]);
        if (bigInteger.compareTo((BigInteger)(object = object[1].min(bigIntegerArray[1]))) > 0) {
            return null;
        }
        return new BigInteger[]{bigInteger, object};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isLessThanSqrt(BigInteger bigInteger, BigInteger bigInteger2) {
        bigInteger = bigInteger.abs();
        bigInteger2 = bigInteger2.abs();
        int n3 = bigInteger2.bitLength();
        int n4 = bigInteger.bitLength() * 2;
        if (n4 - 1 > n3) return false;
        if (n4 < n3) return true;
        BigInteger bigInteger3 = bigInteger;
        if (bigInteger3.multiply(bigInteger3).compareTo(bigInteger2) >= 0) return false;
        return true;
    }

    private static boolean isShorter(BigInteger[] object, BigInteger[] object2) {
        boolean bl;
        BigInteger bigInteger = object[0].abs();
        object = object[1].abs();
        object2 = object2[0].abs();
        BigInteger bigInteger2 = object2[1].abs();
        boolean bl2 = bigInteger.compareTo((BigInteger)object2) < 0;
        if (bl2 == (bl = ((BigInteger)object).compareTo(bigInteger2) < 0)) {
            return bl2;
        }
        BigInteger bigInteger3 = bigInteger;
        Object object3 = object;
        Object object4 = object2;
        BigInteger bigInteger4 = bigInteger2;
        return bigInteger3.multiply(bigInteger3).add(((BigInteger)object3).multiply((BigInteger)object3)).compareTo(((BigInteger)object4).multiply((BigInteger)object4).add(bigInteger4.multiply(bigInteger4))) < 0;
    }

    private static boolean isVectorBoundedBySqrt(BigInteger[] bigIntegerArray, BigInteger bigInteger) {
        return DiscoverEndomorphisms.isLessThanSqrt(bigIntegerArray[0].abs().max(bigIntegerArray[1].abs()), bigInteger);
    }

    private static BigInteger[] order(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger.compareTo(bigInteger2) <= 0) {
            return new BigInteger[]{bigInteger, bigInteger2};
        }
        return new BigInteger[]{bigInteger2, bigInteger};
    }

    private static BigInteger roundQuotient(BigInteger bigInteger, BigInteger bigInteger2) {
        boolean bl = bigInteger.signum() != bigInteger2.signum();
        BigInteger bigInteger3 = bigInteger.abs();
        bigInteger = bigInteger2.abs();
        bigInteger = bigInteger3.add(bigInteger.shiftRight(1)).divide(bigInteger);
        if (bl) {
            bigInteger = bigInteger.negate();
        }
        return bigInteger;
    }

    private static BigInteger[] solveQuadraticEquation(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger object) {
        BigInteger bigInteger4 = bigInteger3;
        object = bigInteger4.multiply(bigInteger4).subtract(bigInteger2.multiply((BigInteger)object).shiftLeft(2)).mod(bigInteger);
        if ((object = new ECFieldElement.Fp(bigInteger, (BigInteger)object).sqrt()) != null) {
            BigInteger bigInteger5 = ((ECFieldElement)object).toBigInteger();
            bigInteger2 = bigInteger2.shiftLeft(1).modInverse(bigInteger);
            object = bigInteger5.subtract(bigInteger3).multiply(bigInteger2).mod(bigInteger);
            bigInteger = bigInteger5.negate().subtract(bigInteger3).multiply(bigInteger2).mod(bigInteger);
            return new BigInteger[]{object, bigInteger};
        }
        throw new IllegalStateException("Solving quadratic equation failed unexpectedly");
    }

    private static ECFieldElement[] findNonTrivialOrder3FieldElements(ECCurve object) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        SecureRandom secureRandom;
        BigInteger bigInteger3 = ((ECCurve)object).getField().getCharacteristic();
        BigInteger bigInteger4 = bigInteger3.divide(ECConstants.THREE);
        SecureRandom secureRandom2 = secureRandom;
        secureRandom = new SecureRandom();
        do {
            bigInteger = ECConstants.TWO;
        } while ((bigInteger2 = BigIntegers.createRandomInRange(bigInteger, bigInteger3.subtract(bigInteger), secureRandom2).modPow(bigInteger4, bigInteger3)).equals(ECConstants.ONE));
        object = ((ECCurve)object).fromBigInteger(bigInteger2);
        return new ECFieldElement[]{object, ((ECFieldElement)object).square()};
    }

    private static ECFieldElement[] findNonTrivialOrder4FieldElements(ECCurve object) {
        if ((object = ((ECCurve)object).fromBigInteger(ECConstants.ONE).negate().sqrt()) != null) {
            return new ECFieldElement[]{object, ((ECFieldElement)object).negate()};
        }
        throw new IllegalStateException("Calculation of non-trivial order-4  field elements failed unexpectedly");
    }

    private static BigInteger isqrt(BigInteger bigInteger) {
        BigInteger bigInteger2 = bigInteger;
        BigInteger bigInteger3 = bigInteger2.shiftRight(bigInteger2.bitLength() / 2);
        BigInteger bigInteger4;
        while (!(bigInteger4 = bigInteger3.add(bigInteger.divide(bigInteger3)).shiftRight(1)).equals(bigInteger3)) {
            bigInteger3 = bigInteger4;
        }
        return bigInteger4;
    }

    private static void swap(BigInteger[] object) {
        BigInteger[] bigIntegerArray = object;
        BigInteger[] bigIntegerArray2 = object;
        object = bigIntegerArray[0];
        bigIntegerArray[0] = bigIntegerArray2[1];
        bigIntegerArray2[1] = object;
    }
}

