/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.tools;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.ECNamedCurveTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ECParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.ec.CustomNamedCurves;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECAlgorithms;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.TreeSet;

public class F2mSqrtOptimizer {
    public static void main(String[] object) {
        TreeSet treeSet = new TreeSet(F2mSqrtOptimizer.enumToList(ECNamedCurveTable.getNames()));
        treeSet.addAll(F2mSqrtOptimizer.enumToList(CustomNamedCurves.getNames()));
        for (String string2 : treeSet) {
            X9ECParameters x9ECParameters = CustomNamedCurves.getByName(string2);
            if (x9ECParameters == null) {
                x9ECParameters = ECNamedCurveTable.getByName(string2);
            }
            if (x9ECParameters == null || !ECAlgorithms.isF2mCurve(x9ECParameters.getCurve())) continue;
            System.out.print(string2 + ":");
            F2mSqrtOptimizer.implPrintRootZ(x9ECParameters);
        }
    }

    public static void printRootZ(X9ECParameters x9ECParameters) {
        if (ECAlgorithms.isF2mCurve(x9ECParameters.getCurve())) {
            F2mSqrtOptimizer.implPrintRootZ(x9ECParameters);
            return;
        }
        throw new IllegalArgumentException("Sqrt optimization only defined over characteristic-2 fields");
    }

    private static void implPrintRootZ(X9ECParameters object) {
        object = ((X9ECParameters)object).getCurve().fromBigInteger(BigInteger.valueOf(2L));
        ECFieldElement eCFieldElement = ((ECFieldElement)object).sqrt();
        System.out.println(eCFieldElement.toBigInteger().toString(16).toUpperCase());
        if (eCFieldElement.square().equals(object)) {
            return;
        }
        throw new IllegalStateException("Optimized-sqrt sanity check failed");
    }

    private static ArrayList enumToList(Enumeration enumeration) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        while (enumeration.hasMoreElements()) {
            arrayList2.add(enumeration.nextElement());
        }
        return arrayList2;
    }
}

