/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.tools;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.ECNamedCurveTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ECParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.ec.CustomNamedCurves;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECAlgorithms;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Integers;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.TreeSet;

public class TraceOptimizer {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final SecureRandom R = new SecureRandom();

    public static void main(String[] object) {
        TreeSet treeSet = new TreeSet(TraceOptimizer.enumToList(ECNamedCurveTable.getNames()));
        treeSet.addAll(TraceOptimizer.enumToList(CustomNamedCurves.getNames()));
        for (String string2 : treeSet) {
            X9ECParameters x9ECParameters = CustomNamedCurves.getByName(string2);
            if (x9ECParameters == null) {
                x9ECParameters = ECNamedCurveTable.getByName(string2);
            }
            if (x9ECParameters == null || !ECAlgorithms.isF2mCurve(x9ECParameters.getCurve())) continue;
            System.out.print(string2 + ":");
            TraceOptimizer.implPrintNonZeroTraceBits(x9ECParameters);
        }
    }

    public static void printNonZeroTraceBits(X9ECParameters x9ECParameters) {
        if (ECAlgorithms.isF2mCurve(x9ECParameters.getCurve())) {
            TraceOptimizer.implPrintNonZeroTraceBits(x9ECParameters);
            return;
        }
        throw new IllegalArgumentException("Trace only defined over characteristic-2 fields");
    }

    public static void implPrintNonZeroTraceBits(X9ECParameters object) {
        int n3;
        ArrayList<Integer> arrayList;
        object = ((X9ECParameters)object).getCurve();
        int n4 = ((ECCurve)object).getFieldSize();
        ArrayList<Integer> arrayList2 = arrayList;
        arrayList = new ArrayList<Integer>();
        for (n3 = 0; n3 < n4; ++n3) {
            if ((n3 & 1) == 0 && n3 != 0) {
                if (!arrayList2.contains(Integers.valueOf(n3 >>> 1))) continue;
                arrayList2.add(Integers.valueOf(n3));
                System.out.print(" " + n3);
                continue;
            }
            if (TraceOptimizer.calculateTrace(((ECCurve)object).fromBigInteger(ONE.shiftLeft(n3))) == 0) continue;
            arrayList2.add(Integers.valueOf(n3));
            System.out.print(" " + n3);
        }
        System.out.println();
        for (n3 = 0; n3 < 1000; ++n3) {
            BigInteger bigInteger;
            BigInteger bigInteger2 = bigInteger;
            int n5 = TraceOptimizer.calculateTrace(((ECCurve)object).fromBigInteger(new BigInteger(n4, R)));
            int n6 = 0;
            for (int i3 = 0; i3 < arrayList2.size(); ++i3) {
                if (!bigInteger2.testBit((Integer)arrayList2.get(i3))) continue;
                n6 ^= 1;
            }
            if (n5 == n6) {
                continue;
            }
            throw new IllegalStateException("Optimized-trace sanity check failed");
        }
    }

    private static int calculateTrace(ECFieldElement eCFieldElement) {
        int n3 = eCFieldElement.getFieldSize();
        int n4 = 31 - Integers.numberOfLeadingZeros(n3);
        int n5 = 1;
        ECFieldElement eCFieldElement2 = eCFieldElement;
        while (n4 > 0) {
            ECFieldElement eCFieldElement3 = eCFieldElement2.squarePow(n5).add(eCFieldElement2);
            int n6 = n3 >>> (n4 += -1);
            if ((n6 & 1) != 0) {
                eCFieldElement3 = eCFieldElement3.square().add(eCFieldElement);
                n5 = n6;
                eCFieldElement2 = eCFieldElement3;
                continue;
            }
            n5 = n6;
            eCFieldElement2 = eCFieldElement3;
        }
        if (eCFieldElement2.isZero()) {
            return 0;
        }
        if (eCFieldElement2.isOne()) {
            return 1;
        }
        throw new IllegalStateException("Internal error in trace calculation");
    }

    private static ArrayList enumToList(Enumeration enumeration) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        while (enumeration.hasMoreElements()) {
            arrayList2.add(enumeration.nextElement());
        }
        return arrayList2;
    }
}

