/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.field;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.field.FiniteField;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.field.GF2Polynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.field.GenericPolynomialExtensionField;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.field.PolynomialExtensionField;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.field.PrimeField;
import java.math.BigInteger;

public abstract class FiniteFields {
    public static final FiniteField GF_2 = new PrimeField(BigInteger.valueOf(2L));
    public static final FiniteField GF_3 = new PrimeField(BigInteger.valueOf(3L));

    public static PolynomialExtensionField getBinaryExtensionField(int[] nArray) {
        if (nArray[0] == 0) {
            GF2Polynomial gF2Polynomial;
            for (int i3 = 1; i3 < nArray.length; ++i3) {
                if (nArray[i3] > nArray[i3 - 1]) {
                    continue;
                }
                throw new IllegalArgumentException("Polynomial exponents must be monotonically increasing");
            }
            FiniteField finiteField = GF_2;
            GF2Polynomial gF2Polynomial2 = gF2Polynomial;
            gF2Polynomial = new GF2Polynomial(nArray);
            return new GenericPolynomialExtensionField(finiteField, gF2Polynomial2);
        }
        throw new IllegalArgumentException("Irreducible polynomials in GF(2) must have constant term");
    }

    public static FiniteField getPrimeField(BigInteger bigInteger) {
        BigInteger bigInteger2 = bigInteger;
        int n3 = bigInteger2.bitLength();
        if (bigInteger2.signum() > 0 && n3 >= 2) {
            if (n3 < 3) {
                n3 = bigInteger.intValue();
                if (n3 != 2) {
                    if (n3 == 3) {
                        return GF_3;
                    }
                } else {
                    return GF_2;
                }
            }
            return new PrimeField(bigInteger);
        }
        throw new IllegalArgumentException("'characteristic' must be >= 2");
    }
}

