/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.raw;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Bits;

public class Interleave {
    private static final long M32 = 0x55555555L;
    private static final long M64 = 0x5555555555555555L;
    private static final long M64R = -6148914691236517206L;

    public static int expand8to16(int n3) {
        int n4 = n3 & 0xFF;
        int n5 = (n4 | n4 << 4) & 0xF0F;
        int n6 = (n5 | n5 << 2) & 0x3333;
        return (n6 | n6 << 1) & 0x5555;
    }

    public static int expand16to32(int n3) {
        int n4 = n3 & 0xFFFF;
        int n5 = (n4 | n4 << 8) & 0xFF00FF;
        int n6 = (n5 | n5 << 4) & 0xF0F0F0F;
        int n7 = (n6 | n6 << 2) & 0x33333333;
        return (n7 | n7 << 1) & 0x55555555;
    }

    public static long expand32to64(int n3) {
        n3 = Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(n3, 65280, 8), 0xF000F0, 4), 0xC0C0C0C, 2), 0x22222222, 1);
        return ((long)(n3 >>> 1) & 0x55555555L) << 32 | (long)n3 & 0x55555555L;
    }

    public static void expand64To128(long l3, long[] lArray, int n3) {
        long l4;
        l3 = Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(l3, 0xFFFF0000L, 16), 0xFF000000FF00L, 8), 0xF000F000F000F0L, 4), 0xC0C0C0C0C0C0C0CL, 2), 0x2222222222222222L, 1);
        lArray[n3] = l3 & 0x5555555555555555L;
        int n4 = n3 + 1;
        lArray[n4] = l4 = l3 >>> 1 & 0x5555555555555555L;
    }

    public static void expand64To128(long[] lArray, int n3, int n4, long[] lArray2, int n5) {
        for (int i3 = 0; i3 < n4; ++i3) {
            Interleave.expand64To128(lArray[n3 + i3], lArray2, n5);
            n5 += 2;
        }
    }

    public static void expand64To128Rev(long l3, long[] lArray, int n3) {
        long l4;
        l3 = Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(l3, 0xFFFF0000L, 16), 0xFF000000FF00L, 8), 0xF000F000F000F0L, 4), 0xC0C0C0C0C0C0C0CL, 2), 0x2222222222222222L, 1);
        lArray[n3] = l3 & 0xAAAAAAAAAAAAAAAAL;
        int n4 = n3 + 1;
        lArray[n4] = l4 = l3 << 1 & 0xAAAAAAAAAAAAAAAAL;
    }

    public static int shuffle(int n3) {
        return Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(n3, 65280, 8), 0xF000F0, 4), 0xC0C0C0C, 2), 0x22222222, 1);
    }

    public static long shuffle(long l3) {
        return Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(l3, 0xFFFF0000L, 16), 0xFF000000FF00L, 8), 0xF000F000F000F0L, 4), 0xC0C0C0C0C0C0C0CL, 2), 0x2222222222222222L, 1);
    }

    public static int shuffle2(int n3) {
        return Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(n3, 0xAA00AA, 7), 52428, 14), 0xF000F0, 4), 65280, 8);
    }

    public static long shuffle2(long l3) {
        return Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(l3, 0xFF00FF00L, 24), 0xCC00CC00CC00CCL, 6), 0xF0F00000F0F0L, 12), 0xA0A0A0A0A0A0A0AL, 3);
    }

    public static long shuffle3(long l3) {
        return Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(l3, 0xAA00AA00AA00AAL, 7), 0xCCCC0000CCCCL, 14), 0xF0F0F0F0L, 28);
    }

    public static int unshuffle(int n3) {
        return Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(n3, 0x22222222, 1), 0xC0C0C0C, 2), 0xF000F0, 4), 65280, 8);
    }

    public static long unshuffle(long l3) {
        return Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(l3, 0x2222222222222222L, 1), 0xC0C0C0C0C0C0C0CL, 2), 0xF000F000F000F0L, 4), 0xFF000000FF00L, 8), 0xFFFF0000L, 16);
    }

    public static int unshuffle2(int n3) {
        return Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(n3, 65280, 8), 0xF000F0, 4), 52428, 14), 0xAA00AA, 7);
    }

    public static long unshuffle2(long l3) {
        return Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(l3, 0xA0A0A0A0A0A0A0AL, 3), 0xF0F00000F0F0L, 12), 0xCC00CC00CC00CCL, 6), 0xFF00FF00L, 24);
    }

    public static long unshuffle3(long l3) {
        return Interleave.shuffle3(l3);
    }
}

