/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.raw;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Integers;
import java.util.Random;

public abstract class Mod {
    private static final int M30 = 0x3FFFFFFF;
    private static final long M32L = 0xFFFFFFFFL;

    public static void add(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n3 = nArray.length;
        if (Nat.add(n3, nArray2, nArray3, nArray4) != 0) {
            Nat.subFrom(n3, nArray, nArray4);
        }
    }

    public static void checkedModOddInverse(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Mod.modOddInverse(nArray, nArray2, nArray3) != 0) {
            return;
        }
        throw new ArithmeticException("Inverse does not exist.");
    }

    public static void checkedModOddInverseVar(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Mod.modOddInverseVar(nArray, nArray2, nArray3)) {
            return;
        }
        throw new ArithmeticException("Inverse does not exist.");
    }

    public static int inverse32(int n3) {
        int n4 = n3;
        n3 = (2 - n4 * n4) * n3;
        n3 = (2 - n4 * n3) * n3;
        n3 = (2 - n4 * n3) * n3;
        return (2 - n4 * n3) * n3;
    }

    public static void invert(int[] nArray, int[] nArray2, int[] nArray3) {
        Mod.checkedModOddInverseVar(nArray, nArray2, nArray3);
    }

    public static int modOddInverse(int[] nArray, int[] nArray2, int[] nArray3) {
        int n3 = nArray.length;
        n3 = (n3 << 5) - Integers.numberOfLeadingZeros(nArray[n3 - 1]);
        int n4 = (n3 + 29) / 30;
        int n5 = -Mod.inverse32(nArray[0]) << 2;
        int[] nArray4 = new int[4];
        int[] nArray5 = new int[n4];
        int[] nArray6 = new int[n4];
        int[] nArray7 = new int[n4];
        int[] nArray8 = new int[n4];
        int[] nArray9 = new int[n4];
        nArray6[0] = 1;
        Mod.encode30(n3, nArray2, 0, nArray8, 0);
        Mod.encode30(n3, nArray, 0, nArray9, 0);
        System.arraycopy(nArray9, 0, nArray7, 0, n4);
        int n6 = -1;
        int n7 = Mod.getMaximumDivsteps(n3);
        for (int i3 = 0; i3 < n7; i3 += 30) {
            int n8 = n4;
            int n9 = n6;
            n6 = nArray7[0];
            n6 = Mod.divsteps30(n9, n6, nArray8[0], nArray4);
            Mod.updateDE30(n8, nArray5, nArray6, nArray4, n5, nArray9);
            Mod.updateFG30(n8, nArray7, nArray8, nArray4);
        }
        int n10 = n4;
        n6 = nArray7[n4 - 1] >> 31;
        Mod.cnegate30(n10, n6, nArray7);
        Mod.cadd30(n10, Mod.cadd30(n10, Mod.csub30(n10, ~Mod.cnegate30(n10, n6, nArray5), nArray5, nArray9), nArray5, nArray9), nArray5, nArray9);
        Mod.decode30(n3, nArray5, 0, nArray3, 0);
        return Nat.equalTo(n4, nArray7, 1) & Nat.equalToZero(n4, nArray8);
    }

    public static boolean modOddInverseVar(int[] nArray, int[] nArray2, int[] nArray3) {
        int n3 = nArray.length;
        n3 = (n3 << 5) - Integers.numberOfLeadingZeros(nArray[n3 - 1]);
        int n4 = (n3 + 29) / 30;
        int n5 = -Mod.inverse32(nArray[0]) << 2;
        int[] nArray4 = new int[4];
        int[] nArray5 = new int[n4];
        int[] nArray6 = new int[n4];
        int[] nArray7 = new int[n4];
        int[] nArray8 = new int[n4];
        int n6 = n4;
        int[] nArray9 = new int[n6];
        nArray6[0] = 1;
        Mod.encode30(n3, nArray2, 0, nArray8, 0);
        Mod.encode30(n3, nArray, 0, nArray9, 0);
        System.arraycopy(nArray9, 0, nArray7, 0, n4);
        int n7 = n6 - 1;
        int n8 = -1 - (Integers.numberOfLeadingZeros(nArray8[n7] | 1) - (n4 * 30 + 2 - n3));
        int n9 = Mod.getMaximumDivsteps(n3);
        int n10 = 0;
        int n11 = n4;
        while (!Nat.isZero(n11, nArray8)) {
            if (n10 >= n9) {
                return false;
            }
            int n12 = n11;
            int n13 = n8;
            n10 += 30;
            n8 = nArray7[0];
            n8 = Mod.divsteps30Var(n13, n8, nArray8[0], nArray4);
            Mod.updateDE30(n4, nArray5, nArray6, nArray4, n5, nArray9);
            Mod.updateFG30(n12, nArray7, nArray8, nArray4);
            int n14 = n12 - 1;
            int n15 = nArray7[n14];
            n14 = nArray8[n14];
            int n16 = n11 - 2;
            int n17 = n15;
            int n18 = n14;
            if ((n16 >> 31 | n17 ^ n17 >> 31 | n18 ^ n18 >> 31) != 0) continue;
            nArray7[n16] = nArray7[n16] | n15 << 30;
            nArray8[n16] = nArray8[n16] | n14 << 30;
            --n11;
        }
        if (nArray7[n11 - 1] >> 31 != 0) {
            Mod.negate30(n11, nArray7);
            Mod.negate30(n4, nArray5);
        }
        if (!Nat.isOne(n11, nArray7)) {
            return false;
        }
        if ((nArray5[n7] >> 31 < 0 ? Mod.add30(n4, nArray5, nArray9) : Mod.sub30(n4, nArray5, nArray9)) < 0) {
            Mod.add30(n4, nArray5, nArray9);
        }
        Mod.decode30(n3, nArray5, 0, nArray3, 0);
        return true;
    }

    public static int[] random(int[] nArray) {
        Random random;
        int n3 = nArray.length;
        Random random2 = random;
        random = new Random();
        int[] nArray2 = Nat.create(n3);
        int n4 = n3 - 1;
        int n5 = nArray[n4];
        int n6 = n5 | n5 >>> 1;
        int n7 = n6 | n6 >>> 2;
        int n8 = n7 | n7 >>> 4;
        int n9 = n8 | n8 >>> 8;
        int n10 = n9 | n9 >>> 16;
        do {
            for (int i3 = 0; i3 != n3; ++i3) {
                nArray2[i3] = random2.nextInt();
            }
            nArray2[n4] = nArray2[n4] & n10;
        } while (Nat.gte(n3, nArray2, nArray));
        return nArray2;
    }

    public static void subtract(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n3 = nArray.length;
        if (Nat.sub(n3, nArray2, nArray3, nArray4) != 0) {
            Nat.addTo(n3, nArray, nArray4);
        }
    }

    private static int add30(int n3, int[] nArray, int[] nArray2) {
        int n4 = n3;
        n3 = 0;
        int n5 = n4 - 1;
        for (int i3 = 0; i3 < n5; ++i3) {
            n3 = nArray[i3] + nArray2[i3] + n3;
            nArray[i3] = n3 & 0x3FFFFFFF;
            n3 >>= 30;
        }
        nArray[n5] = n3 = nArray[n5] + nArray2[n5] + n3;
        return n3 >> 30;
    }

    private static int cadd30(int n3, int n4, int[] nArray, int[] nArray2) {
        int n5 = n3;
        n3 = 0;
        int n6 = n5 - 1;
        for (int i3 = 0; i3 < n6; ++i3) {
            n3 = nArray[i3] + (nArray2[i3] & n4) + n3;
            nArray[i3] = n3 & 0x3FFFFFFF;
            n3 >>= 30;
        }
        nArray[n6] = n3 = nArray[n6] + (nArray2[n6] & n4) + n3;
        return n3 >> 30;
    }

    private static int cnegate30(int n3, int n4, int[] nArray) {
        int n5 = n3;
        n3 = 0;
        int n6 = n5 - 1;
        for (int i3 = 0; i3 < n6; ++i3) {
            n3 = (nArray[i3] ^ n4) - n4 + n3;
            nArray[i3] = n3 & 0x3FFFFFFF;
            n3 >>= 30;
        }
        nArray[n6] = n3 = (nArray[n6] ^ n4) - n4 + n3;
        return n3 >> 30;
    }

    private static int csub30(int n3, int n4, int[] nArray, int[] nArray2) {
        int n5 = n3;
        n3 = 0;
        int n6 = n5 - 1;
        for (int i3 = 0; i3 < n6; ++i3) {
            n3 = nArray[i3] - (nArray2[i3] & n4) + n3;
            nArray[i3] = n3 & 0x3FFFFFFF;
            n3 >>= 30;
        }
        nArray[n6] = n3 = nArray[n6] - (nArray2[n6] & n4) + n3;
        return n3 >> 30;
    }

    private static void decode30(int n3, int[] nArray, int n4, int[] nArray2, int n5) {
        int n6 = 0;
        long l3 = 0L;
        while (n3 > 0) {
            while (n6 < Math.min(32, n3)) {
                l3 |= (long)nArray[n4++] << n6;
                n6 += 30;
            }
            int n7 = n5 + 1;
            nArray2[n5] = (int)l3;
            long l4 = l3 >>> 32;
            n6 -= 32;
            n3 -= 32;
            l3 = l4;
            n5 = n7;
        }
    }

    private static int divsteps30(int n3, int n4, int n5, int[] nArray) {
        int n6 = 1;
        int n7 = 0;
        int n8 = 0;
        int n9 = 1;
        for (int i3 = 0; i3 < 30; ++i3) {
            int n10 = n7;
            int n11 = n9;
            int n12 = n7;
            n7 = n3 >> 31;
            n9 = -(n5 & 1);
            int n13 = (n4 ^ n7) - n7;
            int n14 = (n6 ^ n7) - n7;
            n5 += n13 & n9;
            n8 += n14 & n9;
            n13 = n11 + ((n12 ^ n7) - n7 & n9);
            int n15 = n6;
            int n16 = n4;
            int n17 = n3;
            n3 = n7 & n9;
            n4 = (n17 ^ n3) - (n3 + 1);
            n6 = n16 + (n5 & n3);
            n7 = n15 + (n8 & n3);
            int n18 = n10 + (n13 & n3);
            n5 >>= 1;
            n3 = n7 << 1;
            n7 = n18 << 1;
            int n19 = n3;
            int n20 = n4;
            n4 = n6;
            n3 = n20;
            n9 = n13;
            n6 = n19;
        }
        int[] nArray2 = nArray;
        int[] nArray3 = nArray;
        nArray2[0] = n6;
        nArray3[1] = n7;
        nArray2[2] = n8;
        nArray3[3] = n9;
        return n3;
    }

    private static int divsteps30Var(int n3, int n4, int n5, int[] nArray) {
        int n6 = 1;
        int n7 = 0;
        int n8 = 0;
        int n9 = 1;
        int n10 = 30;
        while (true) {
            int n11;
            int n12 = n10;
            int n13 = n3;
            int n14 = n5;
            n3 = Integers.numberOfTrailingZeros(n14 | -1 << n10);
            n5 = n14 >> n3;
            n6 <<= n3;
            n7 <<= n3;
            n10 = n13 - n3;
            if ((n3 = n12 - n3) <= 0) {
                int[] nArray2 = nArray;
                int[] nArray3 = nArray;
                nArray2[0] = n6;
                nArray3[1] = n7;
                nArray2[2] = n8;
                nArray3[3] = n9;
                return n10;
            }
            if (n10 < 0) {
                int n15 = n7;
                int n16 = n6;
                int n17 = n4;
                n4 = -n10;
                n6 = -n17;
                n7 = -n16;
                n10 = -n15;
                n11 = n4 + 1;
                if (n11 > n3) {
                    n11 = n3;
                }
                int n18 = n5;
                n11 = -1 >>> 32 - n11 & 0x3F;
                int n19 = n18 * n6;
                n11 = (n18 * n18 - 2) * n19 & n11;
                int n20 = n7;
                int n21 = n8;
                n8 = n9;
                n7 = n21;
                n9 = n20;
            } else {
                n11 = n10 + 1;
                if (n11 > n3) {
                    n11 = n3;
                }
                int n22 = n4;
                n11 = -1 >>> 32 - n11 & 0xF;
                n11 = -(n22 + ((n22 + 1 & 4) << 1)) * n5 & n11;
                int n23 = n5;
                int n24 = n4;
                int n25 = n8;
                n4 = n10;
                n8 = n7;
                n10 = n9;
                n7 = n6;
                n9 = n25;
                n5 = n24;
                n6 = n23;
            }
            n6 = n5 * n11 + n6;
            n9 = n7 * n11 + n9;
            n10 = n8 * n11 + n10;
            int n26 = n6;
            int n27 = n3;
            int n28 = n7;
            int n29 = n8;
            int n30 = n4;
            int n31 = n9;
            n9 = n10;
            n8 = n31;
            n4 = n5;
            n3 = n30;
            n7 = n29;
            n6 = n28;
            n10 = n27;
            n5 = n26;
        }
    }

    private static void encode30(int n3, int[] nArray, int n4, int[] nArray2, int n5) {
        int n6 = 0;
        long l3 = 0L;
        while (n3 > 0) {
            if (n6 < Math.min(30, n3)) {
                l3 |= ((long)nArray[n4++] & 0xFFFFFFFFL) << n6;
                n6 += 32;
            }
            nArray2[n5++] = (int)l3 & 0x3FFFFFFF;
            l3 >>>= 30;
            n6 -= 30;
            n3 -= 30;
        }
    }

    private static int getMaximumDivsteps(int n3) {
        int n4 = n3;
        n3 = n4 * 49;
        int n5 = n4 < 46 ? 80 : 47;
        return (n3 + n5) / 17;
    }

    private static int negate30(int n3, int[] nArray) {
        int n4 = n3;
        n3 = 0;
        int n5 = n4 - 1;
        for (int i3 = 0; i3 < n5; ++i3) {
            nArray[i3] = (n3 -= nArray[i3]) & 0x3FFFFFFF;
            n3 >>= 30;
        }
        nArray[n5] = n3 -= nArray[n5];
        return n3 >> 30;
    }

    private static int sub30(int n3, int[] nArray, int[] nArray2) {
        int n4 = n3;
        n3 = 0;
        int n5 = n4 - 1;
        for (int i3 = 0; i3 < n5; ++i3) {
            n3 = nArray[i3] - nArray2[i3] + n3;
            nArray[i3] = n3 & 0x3FFFFFFF;
            n3 >>= 30;
        }
        nArray[n5] = n3 = nArray[n5] - nArray2[n5] + n3;
        return n3 >> 30;
    }

    private static void updateDE30(int n3, int[] nArray, int[] nArray2, int[] nArray3, int n4, int[] nArray4) {
        int n5 = n4;
        int n6 = nArray3[0];
        n4 = nArray3[1];
        int n7 = nArray3[2];
        int n8 = n4;
        int n9 = n6;
        n6 = nArray[0];
        n4 = nArray2[0];
        long l3 = n9;
        long l4 = n6;
        long l5 = l3 * l4;
        long l6 = n8;
        long l7 = n4;
        l5 = l6 * l7 + l5;
        long l8 = n7;
        l4 = l8 * l4;
        long l9 = nArray3[3];
        l7 = l9 * l7 + l4;
        int n10 = n5 * (int)l5 >> 2;
        int n11 = n5 * (int)l7 >> 2;
        int n12 = nArray4[0];
        long l10 = n10;
        l5 = (long)n12 * l10 + l5;
        long l11 = n11;
        long l12 = (long)n12 * l11 + l7;
        l7 = l5 >> 30;
        l5 = l12 >> 30;
        for (int i3 = 1; i3 < n3; ++i3) {
            int n13 = nArray[i3];
            long l13 = n13;
            long l14 = l3 * l13;
            long l15 = nArray2[i3];
            l7 = a.a(l6, l15, l14, l7);
            l13 = l8 * l13;
            l5 = a.a(l9, l15, l13, l5);
            int n14 = nArray4[i3];
            l7 = (long)n14 * l10 + l7;
            l5 = (long)n14 * l11 + l5;
            n13 = i3 - 1;
            nArray[n13] = (int)l7 & 0x3FFFFFFF;
            l7 >>= 30;
            nArray2[n13] = (int)l5 & 0x3FFFFFFF;
            l5 >>= 30;
        }
        nArray[--n3] = (int)l7;
        nArray2[n3] = (int)l5;
    }

    private static void updateFG30(int n3, int[] nArray, int[] nArray2, int[] nArray3) {
        int n4 = nArray3[0];
        int n5 = nArray3[1];
        int n6 = nArray3[2];
        int n7 = n5;
        int n8 = n4;
        n4 = nArray[0];
        n5 = nArray2[0];
        long l3 = n8;
        long l4 = n4;
        long l5 = l3 * l4;
        long l6 = n7;
        long l7 = n5;
        l5 = l6 * l7 + l5;
        long l8 = n6;
        l4 = l8 * l4;
        long l9 = nArray3[3];
        long l10 = l9 * l7 + l4;
        l4 = l5 >> 30;
        l5 = l10 >> 30;
        for (n4 = 1; n4 < n3; ++n4) {
            n5 = nArray[n4];
            l7 = n5;
            long l11 = l3 * l7;
            long l12 = nArray2[n4];
            l4 = a.a(l6, l12, l11, l4);
            l7 = l8 * l7;
            l5 = a.a(l9, l12, l7, l5);
            n5 = n4 - 1;
            nArray[n5] = (int)l4 & 0x3FFFFFFF;
            l4 >>= 30;
            nArray2[n5] = (int)l5 & 0x3FFFFFFF;
            l5 >>= 30;
        }
        nArray[--n3] = (int)l4;
        nArray2[n3] = (int)l5;
    }
}

