/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.raw;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat256;

public abstract class Mont256 {
    private static final long M = 0xFFFFFFFFL;

    public static int inverse32(int n3) {
        int n4 = n3;
        n3 = (2 - n4 * n4) * n3;
        n3 = (2 - n4 * n3) * n3;
        n3 = (2 - n4 * n3) * n3;
        return (2 - n4 * n3) * n3;
    }

    public static void multAdd(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int n3) {
        int n4 = 0;
        long l3 = (long)nArray2[0] & 0xFFFFFFFFL;
        for (int i3 = 0; i3 < 8; ++i3) {
            long l4 = (long)nArray3[0] & 0xFFFFFFFFL;
            long l5 = (long)nArray[i3] & 0xFFFFFFFFL;
            long l6 = l5 * l3;
            long l7 = (l6 & 0xFFFFFFFFL) + l4;
            l4 = (long)((int)l7 * n3) & 0xFFFFFFFFL;
            long l8 = l4 * ((long)nArray4[0] & 0xFFFFFFFFL);
            l6 = (l7 + (l8 & 0xFFFFFFFFL) >>> 32) + (l6 >>> 32) + (l8 >>> 32);
            for (int i4 = 1; i4 < 8; ++i4) {
                long l9 = l5 * ((long)nArray2[i4] & 0xFFFFFFFFL);
                long l10 = l4 * ((long)nArray4[i4] & 0xFFFFFFFFL);
                l6 = (l9 & 0xFFFFFFFFL) + (l10 & 0xFFFFFFFFL) + ((long)nArray3[i4] & 0xFFFFFFFFL) + l6;
                int n5 = i4 - 1;
                nArray3[n5] = (int)l6;
                l6 = (l6 >>> 32) + (l9 >>> 32) + (l10 >>> 32);
            }
            l4 = l6 + ((long)n4 & 0xFFFFFFFFL);
            nArray3[7] = (int)l4;
            n4 = (int)(l4 >>> 32);
        }
        if (n4 != 0 || Nat256.gte(nArray3, nArray4)) {
            Nat256.sub(nArray3, nArray4, nArray3);
        }
    }

    public static void multAddXF(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n3 = 0;
        long l3 = (long)nArray2[0] & 0xFFFFFFFFL;
        for (int i3 = 0; i3 < 8; ++i3) {
            long l4 = (long)nArray[i3] & 0xFFFFFFFFL;
            long l5 = l4 * l3 + ((long)nArray3[0] & 0xFFFFFFFFL);
            long l6 = l5 & 0xFFFFFFFFL;
            long l7 = (l5 >>> 32) + l6;
            for (int i4 = 1; i4 < 8; ++i4) {
                long l8 = l4 * ((long)nArray2[i4] & 0xFFFFFFFFL);
                long l9 = l6 * ((long)nArray4[i4] & 0xFFFFFFFFL);
                l7 = (l8 & 0xFFFFFFFFL) + (l9 & 0xFFFFFFFFL) + ((long)nArray3[i4] & 0xFFFFFFFFL) + l7;
                int n4 = i4 - 1;
                nArray3[n4] = (int)l7;
                l7 = (l7 >>> 32) + (l8 >>> 32) + (l9 >>> 32);
            }
            l4 = l7 + ((long)n3 & 0xFFFFFFFFL);
            nArray3[7] = (int)l4;
            n3 = (int)(l4 >>> 32);
        }
        if (n3 != 0 || Nat256.gte(nArray3, nArray4)) {
            Nat256.sub(nArray3, nArray4, nArray3);
        }
    }

    public static void reduce(int[] nArray, int[] nArray2, int n3) {
        for (int i3 = 0; i3 < 8; ++i3) {
            int n4 = nArray[0];
            long l3 = (long)(n4 * n3) & 0xFFFFFFFFL;
            long l4 = l3 * ((long)nArray2[0] & 0xFFFFFFFFL) + ((long)n4 & 0xFFFFFFFFL) >>> 32;
            for (n4 = 1; n4 < 8; ++n4) {
                l4 = l3 * ((long)nArray2[n4] & 0xFFFFFFFFL) + ((long)nArray[n4] & 0xFFFFFFFFL) + l4;
                int n5 = n4 - 1;
                nArray[n5] = (int)l4;
                l4 >>>= 32;
            }
            nArray[7] = (int)l4;
        }
        if (Nat256.gte(nArray, nArray2)) {
            Nat256.sub(nArray, nArray2, nArray);
        }
    }

    public static void reduceXF(int[] nArray, int[] nArray2) {
        for (int i3 = 0; i3 < 8; ++i3) {
            long l3 = (long)nArray[0] & 0xFFFFFFFFL;
            long l4 = l3;
            for (int i4 = 1; i4 < 8; ++i4) {
                l4 = l3 * ((long)nArray2[i4] & 0xFFFFFFFFL) + ((long)nArray[i4] & 0xFFFFFFFFL) + l4;
                int n3 = i4 - 1;
                nArray[n3] = (int)l4;
                l4 >>>= 32;
            }
            nArray[7] = (int)l4;
        }
        if (Nat256.gte(nArray, nArray2)) {
            Nat256.sub(nArray, nArray2, nArray);
        }
    }
}

