/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.raw;

import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;
import java.math.BigInteger;

public abstract class Nat {
    private static final long M = 0xFFFFFFFFL;

    public static int add(int n3, int[] nArray, int[] nArray2, int[] nArray3) {
        long l3 = 0L;
        for (int i3 = 0; i3 < n3; ++i3) {
            l3 = ((long)nArray[i3] & 0xFFFFFFFFL) + ((long)nArray2[i3] & 0xFFFFFFFFL) + l3;
            nArray3[i3] = (int)l3;
            l3 >>>= 32;
        }
        return (int)l3;
    }

    public static int add33At(int n3, int n4, int[] nArray, int n5) {
        int n6 = n5 + 0;
        long l3 = ((long)nArray[n6] & 0xFFFFFFFFL) + ((long)n4 & 0xFFFFFFFFL);
        nArray[n6] = (int)l3;
        long l4 = l3 >>> 32;
        n4 = n5 + 1;
        l4 = ((long)nArray[n4] & 0xFFFFFFFFL) + 1L + l4;
        nArray[n4] = (int)l4;
        return l4 >>> 32 == 0L ? 0 : Nat.incAt(n3, nArray, n5 + 2);
    }

    public static int add33At(int n3, int n4, int[] nArray, int n5, int n6) {
        int n7;
        int n8 = n5 + n6;
        long l3 = ((long)nArray[n8] & 0xFFFFFFFFL) + ((long)n4 & 0xFFFFFFFFL);
        nArray[n8] = (int)l3;
        n4 = n8 + 1;
        long l4 = ((long)nArray[n4] & 0xFFFFFFFFL) + 1L + (l3 >>>= 32);
        nArray[n4] = (int)l4;
        if (l4 >>> 32 == 0L) {
            n7 = 0;
        } else {
            int n9 = n3;
            n3 = n6 + 2;
            n7 = Nat.incAt(n9, nArray, n5, n3);
        }
        return n7;
    }

    public static int add33To(int n3, int n4, int[] nArray) {
        long l3 = ((long)nArray[0] & 0xFFFFFFFFL) + ((long)n4 & 0xFFFFFFFFL);
        nArray[0] = (int)l3;
        l3 >>>= 32;
        l3 = ((long)nArray[1] & 0xFFFFFFFFL) + 1L + l3;
        nArray[1] = (int)l3;
        return l3 >>> 32 == 0L ? 0 : Nat.incAt(n3, nArray, 2);
    }

    public static int add33To(int n3, int n4, int[] nArray, int n5) {
        int n6 = n5 + 0;
        long l3 = ((long)nArray[n6] & 0xFFFFFFFFL) + ((long)n4 & 0xFFFFFFFFL);
        nArray[n6] = (int)l3;
        long l4 = l3 >>> 32;
        n4 = n5 + 1;
        l4 = ((long)nArray[n4] & 0xFFFFFFFFL) + 1L + l4;
        nArray[n4] = (int)l4;
        return l4 >>> 32 == 0L ? 0 : Nat.incAt(n3, nArray, n5, 2);
    }

    public static int addBothTo(int n3, int[] nArray, int[] nArray2, int[] nArray3) {
        long l3 = 0L;
        for (int i3 = 0; i3 < n3; ++i3) {
            l3 = ((long)nArray[i3] & 0xFFFFFFFFL) + ((long)nArray2[i3] & 0xFFFFFFFFL) + ((long)nArray3[i3] & 0xFFFFFFFFL) + l3;
            nArray3[i3] = (int)l3;
            l3 >>>= 32;
        }
        return (int)l3;
    }

    public static int addBothTo(int n3, int[] nArray, int n4, int[] nArray2, int n5, int[] nArray3, int n6) {
        long l3 = 0L;
        for (int i3 = 0; i3 < n3; ++i3) {
            int n7 = n6 + i3;
            l3 = ((long)nArray[n4 + i3] & 0xFFFFFFFFL) + ((long)nArray2[n5 + i3] & 0xFFFFFFFFL) + ((long)nArray3[n7] & 0xFFFFFFFFL) + l3;
            nArray3[n7] = (int)l3;
            l3 >>>= 32;
        }
        return (int)l3;
    }

    public static int addDWordAt(int n3, long l3, int[] nArray, int n4) {
        int n5 = n4 + 0;
        long l4 = ((long)nArray[n5] & 0xFFFFFFFFL) + (l3 & 0xFFFFFFFFL);
        nArray[n5] = (int)l4;
        long l5 = l4 >>> 32;
        int n6 = n4 + 1;
        l3 = ((long)nArray[n6] & 0xFFFFFFFFL) + (l3 >>> 32) + l5;
        nArray[n6] = (int)l3;
        return l3 >>> 32 == 0L ? 0 : Nat.incAt(n3, nArray, n4 + 2);
    }

    public static int addDWordAt(int n3, long l3, int[] nArray, int n4, int n5) {
        int n6;
        int n7 = n4 + n5;
        long l4 = ((long)nArray[n7] & 0xFFFFFFFFL) + (l3 & 0xFFFFFFFFL);
        nArray[n7] = (int)l4;
        l3 = ((long)nArray[++n7] & 0xFFFFFFFFL) + (l3 >>> 32) + (l4 >>>= 32);
        nArray[n7] = (int)l3;
        if (l3 >>> 32 == 0L) {
            n6 = 0;
        } else {
            int n8 = n3;
            n3 = n5 + 2;
            n6 = Nat.incAt(n8, nArray, n4, n3);
        }
        return n6;
    }

    public static int addDWordTo(int n3, long l3, int[] nArray) {
        long l4 = ((long)nArray[0] & 0xFFFFFFFFL) + (l3 & 0xFFFFFFFFL);
        nArray[0] = (int)l4;
        l3 = ((long)nArray[1] & 0xFFFFFFFFL) + (l3 >>> 32) + (l4 >>>= 32);
        nArray[1] = (int)l3;
        return l3 >>> 32 == 0L ? 0 : Nat.incAt(n3, nArray, 2);
    }

    public static int addDWordTo(int n3, long l3, int[] nArray, int n4) {
        int n5 = n4 + 0;
        long l4 = ((long)nArray[n5] & 0xFFFFFFFFL) + (l3 & 0xFFFFFFFFL);
        nArray[n5] = (int)l4;
        long l5 = l4 >>> 32;
        int n6 = n4 + 1;
        l3 = ((long)nArray[n6] & 0xFFFFFFFFL) + (l3 >>> 32) + l5;
        nArray[n6] = (int)l3;
        return l3 >>> 32 == 0L ? 0 : Nat.incAt(n3, nArray, n4, 2);
    }

    public static int addTo(int n3, int[] nArray, int[] nArray2) {
        long l3 = 0L;
        for (int i3 = 0; i3 < n3; ++i3) {
            l3 = ((long)nArray[i3] & 0xFFFFFFFFL) + ((long)nArray2[i3] & 0xFFFFFFFFL) + l3;
            nArray2[i3] = (int)l3;
            l3 >>>= 32;
        }
        return (int)l3;
    }

    public static int addTo(int n3, int[] nArray, int n4, int[] nArray2, int n5) {
        long l3 = 0L;
        for (int i3 = 0; i3 < n3; ++i3) {
            int n6 = n5 + i3;
            l3 = ((long)nArray[n4 + i3] & 0xFFFFFFFFL) + ((long)nArray2[n6] & 0xFFFFFFFFL) + l3;
            nArray2[n6] = (int)l3;
            l3 >>>= 32;
        }
        return (int)l3;
    }

    public static int addTo(int n3, int[] nArray, int n4, int[] nArray2, int n5, int n6) {
        long l3 = (long)n6 & 0xFFFFFFFFL;
        for (n6 = 0; n6 < n3; ++n6) {
            int n7 = n5 + n6;
            l3 = ((long)nArray[n4 + n6] & 0xFFFFFFFFL) + ((long)nArray2[n7] & 0xFFFFFFFFL) + l3;
            nArray2[n7] = (int)l3;
            l3 >>>= 32;
        }
        return (int)l3;
    }

    public static int addToEachOther(int n3, int[] nArray, int n4, int[] nArray2, int n5) {
        long l3 = 0L;
        for (int i3 = 0; i3 < n3; ++i3) {
            int n6;
            int n7 = n4 + i3;
            int n8 = n5 + i3;
            l3 = ((long)nArray[n7] & 0xFFFFFFFFL) + ((long)nArray2[n8] & 0xFFFFFFFFL) + l3;
            nArray[n7] = n6 = (int)l3;
            nArray2[n8] = n6;
            l3 >>>= 32;
        }
        return (int)l3;
    }

    public static int addWordAt(int n3, int n4, int[] nArray, int n5) {
        long l3 = ((long)n4 & 0xFFFFFFFFL) + ((long)nArray[n5] & 0xFFFFFFFFL);
        nArray[n5] = (int)l3;
        return l3 >>> 32 == 0L ? 0 : Nat.incAt(n3, nArray, n5 + 1);
    }

    public static int addWordAt(int n3, int n4, int[] nArray, int n5, int n6) {
        int n7;
        long l3 = (long)n4 & 0xFFFFFFFFL;
        n4 = n5 + n6;
        long l4 = l3 + ((long)nArray[n4] & 0xFFFFFFFFL);
        nArray[n4] = (int)l4;
        if (l4 >>> 32 == 0L) {
            n7 = 0;
        } else {
            int n8 = n3;
            n3 = n6 + 1;
            n7 = Nat.incAt(n8, nArray, n5, n3);
        }
        return n7;
    }

    public static int addWordTo(int n3, int n4, int[] nArray) {
        long l3 = ((long)n4 & 0xFFFFFFFFL) + ((long)nArray[0] & 0xFFFFFFFFL);
        nArray[0] = (int)l3;
        return l3 >>> 32 == 0L ? 0 : Nat.incAt(n3, nArray, 1);
    }

    public static int addWordTo(int n3, int n4, int[] nArray, int n5) {
        long l3 = ((long)n4 & 0xFFFFFFFFL) + ((long)nArray[n5] & 0xFFFFFFFFL);
        nArray[n5] = (int)l3;
        return l3 >>> 32 == 0L ? 0 : Nat.incAt(n3, nArray, n5, 1);
    }

    public static int cadd(int n3, int n4, int[] nArray, int[] nArray2, int[] nArray3) {
        long l3 = (long)(-(n4 & 1)) & 0xFFFFFFFFL;
        long l4 = 0L;
        for (n4 = 0; n4 < n3; ++n4) {
            l4 = ((long)nArray[n4] & 0xFFFFFFFFL) + ((long)nArray2[n4] & l3) + l4;
            nArray3[n4] = (int)l4;
            l4 >>>= 32;
        }
        return (int)l4;
    }

    public static void cmov(int n3, int n4, int[] nArray, int n5, int[] nArray2, int n6) {
        n4 = -(n4 & 1);
        for (int i3 = 0; i3 < n3; ++i3) {
            int n7 = n6 + i3;
            int n8 = nArray2[n7];
            nArray2[n7] = n8 ^ (n8 ^ nArray[n5 + i3]) & n4;
        }
    }

    public static int compare(int n3, int[] nArray, int[] nArray2) {
        --n3;
        while (n3 >= 0) {
            int n4 = nArray[n3] ^ Integer.MIN_VALUE;
            int n5 = nArray2[n3] ^ Integer.MIN_VALUE;
            if (n4 < n5) {
                return -1;
            }
            if (n4 > n5) {
                return 1;
            }
            --n3;
        }
        return 0;
    }

    public static int compare(int n3, int[] nArray, int n4, int[] nArray2, int n5) {
        --n3;
        while (n3 >= 0) {
            int n6 = nArray[n4 + n3] ^ Integer.MIN_VALUE;
            int n7 = nArray2[n5 + n3] ^ Integer.MIN_VALUE;
            if (n6 < n7) {
                return -1;
            }
            if (n6 > n7) {
                return 1;
            }
            --n3;
        }
        return 0;
    }

    public static int[] copy(int n3, int[] nArray) {
        int[] nArray2 = new int[n3];
        System.arraycopy(nArray, 0, nArray2, 0, n3);
        return nArray2;
    }

    public static void copy(int n3, int[] nArray, int[] nArray2) {
        System.arraycopy(nArray, 0, nArray2, 0, n3);
    }

    public static void copy(int n3, int[] nArray, int n4, int[] nArray2, int n5) {
        System.arraycopy(nArray, n4, nArray2, n5, n3);
    }

    public static long[] copy64(int n3, long[] lArray) {
        long[] lArray2 = new long[n3];
        System.arraycopy(lArray, 0, lArray2, 0, n3);
        return lArray2;
    }

    public static void copy64(int n3, long[] lArray, long[] lArray2) {
        System.arraycopy(lArray, 0, lArray2, 0, n3);
    }

    public static void copy64(int n3, long[] lArray, int n4, long[] lArray2, int n5) {
        System.arraycopy(lArray, n4, lArray2, n5, n3);
    }

    public static int[] create(int n3) {
        return new int[n3];
    }

    public static long[] create64(int n3) {
        return new long[n3];
    }

    public static int csub(int n3, int n4, int[] nArray, int[] nArray2, int[] nArray3) {
        long l3 = (long)(-(n4 & 1)) & 0xFFFFFFFFL;
        long l4 = 0L;
        for (n4 = 0; n4 < n3; ++n4) {
            l4 = ((long)nArray[n4] & 0xFFFFFFFFL) - ((long)nArray2[n4] & l3) + l4;
            nArray3[n4] = (int)l4;
            l4 >>= 32;
        }
        return (int)l4;
    }

    public static int csub(int n3, int n4, int[] nArray, int n5, int[] nArray2, int n6, int[] nArray3, int n7) {
        long l3 = (long)(-(n4 & 1)) & 0xFFFFFFFFL;
        long l4 = 0L;
        for (n4 = 0; n4 < n3; ++n4) {
            l4 = ((long)nArray[n5 + n4] & 0xFFFFFFFFL) - ((long)nArray2[n6 + n4] & l3) + l4;
            int n8 = n7 + n4;
            nArray3[n8] = (int)l4;
            l4 >>= 32;
        }
        return (int)l4;
    }

    public static int dec(int n3, int[] nArray) {
        for (int i3 = 0; i3 < n3; ++i3) {
            int n4;
            nArray[i3] = n4 = nArray[i3] - 1;
            if (n4 == -1) continue;
            return 0;
        }
        return -1;
    }

    public static int dec(int n3, int[] nArray, int[] nArray2) {
        for (int i3 = 0; i3 < n3; ++i3) {
            int n4;
            nArray2[i3] = n4 = nArray[i3] - 1;
            if (n4 == -1) continue;
            while (i3 < n3) {
                nArray2[i3] = nArray[i3];
                ++i3;
            }
            return 0;
        }
        return -1;
    }

    public static int decAt(int n3, int[] nArray, int n4) {
        while (n4 < n3) {
            int n5;
            nArray[n4] = n5 = nArray[n4] - 1;
            if (n5 != -1) {
                return 0;
            }
            ++n4;
        }
        return -1;
    }

    public static int decAt(int n3, int[] nArray, int n4, int n5) {
        while (n5 < n3) {
            int n6;
            int n7 = n4 + n5;
            nArray[n7] = n6 = nArray[n7] - 1;
            if (n6 != -1) {
                return 0;
            }
            ++n5;
        }
        return -1;
    }

    public static boolean diff(int n3, int[] nArray, int n4, int[] nArray2, int n5, int[] nArray3, int n6) {
        boolean bl = Nat.gte(n3, nArray, n4, nArray2, n5);
        if (bl) {
            Nat.sub(n3, nArray, n4, nArray2, n5, nArray3, n6);
        } else {
            Nat.sub(n3, nArray2, n5, nArray, n4, nArray3, n6);
        }
        return bl;
    }

    public static boolean eq(int n3, int[] nArray, int[] nArray2) {
        --n3;
        while (n3 >= 0) {
            if (nArray[n3] != nArray2[n3]) {
                return false;
            }
            --n3;
        }
        return true;
    }

    public static int equalTo(int n3, int[] nArray, int n4) {
        n4 = nArray[0] ^ n4;
        for (int i3 = 1; i3 < n3; ++i3) {
            n4 |= nArray[i3];
        }
        return (n4 >>> 1 | n4 & 1) - 1 >> 31;
    }

    public static int equalTo(int n3, int[] nArray, int n4, int n5) {
        n5 = nArray[n4] ^ n5;
        for (int i3 = 1; i3 < n3; ++i3) {
            n5 |= nArray[n4 + i3];
        }
        return (n5 >>> 1 | n5 & 1) - 1 >> 31;
    }

    public static int equalTo(int n3, int[] nArray, int[] nArray2) {
        int n4 = 0;
        for (int i3 = 0; i3 < n3; ++i3) {
            n4 |= nArray[i3] ^ nArray2[i3];
        }
        return (n4 >>> 1 | n4 & 1) - 1 >> 31;
    }

    public static int equalTo(int n3, int[] nArray, int n4, int[] nArray2, int n5) {
        int n6 = 0;
        for (int i3 = 0; i3 < n3; ++i3) {
            n6 |= nArray[n4 + i3] ^ nArray2[n5 + i3];
        }
        return (n6 >>> 1 | n6 & 1) - 1 >> 31;
    }

    public static int equalToZero(int n3, int[] nArray) {
        int n4 = 0;
        for (int i3 = 0; i3 < n3; ++i3) {
            n4 |= nArray[i3];
        }
        return (n4 >>> 1 | n4 & 1) - 1 >> 31;
    }

    public static int equalToZero(int n3, int[] nArray, int n4) {
        int n5 = 0;
        for (int i3 = 0; i3 < n3; ++i3) {
            n5 |= nArray[n4 + i3];
        }
        return (n5 >>> 1 | n5 & 1) - 1 >> 31;
    }

    public static int[] fromBigInteger(int n3, BigInteger bigInteger) {
        if (bigInteger.signum() >= 0 && bigInteger.bitLength() <= n3) {
            n3 = n3 + 31 >> 5;
            int[] nArray = Nat.create(n3);
            for (int i3 = 0; i3 < n3; ++i3) {
                nArray[i3] = bigInteger.intValue();
                bigInteger = bigInteger.shiftRight(32);
            }
            return nArray;
        }
        throw new IllegalArgumentException();
    }

    public static long[] fromBigInteger64(int n3, BigInteger bigInteger) {
        if (bigInteger.signum() >= 0 && bigInteger.bitLength() <= n3) {
            n3 = n3 + 63 >> 6;
            long[] lArray = Nat.create64(n3);
            for (int i3 = 0; i3 < n3; ++i3) {
                long l3;
                lArray[i3] = l3 = bigInteger.longValue();
                bigInteger = bigInteger.shiftRight(64);
            }
            return lArray;
        }
        throw new IllegalArgumentException();
    }

    public static int getBit(int[] nArray, int n3) {
        if (n3 == 0) {
            return nArray[0] & 1;
        }
        int n4 = n3 >> 5;
        if (n4 >= 0 && n4 < nArray.length) {
            int n5 = n3 & 0x1F;
            return nArray[n4] >>> n5 & 1;
        }
        return 0;
    }

    public static boolean gte(int n3, int[] nArray, int[] nArray2) {
        --n3;
        while (n3 >= 0) {
            int n4 = nArray[n3] ^ Integer.MIN_VALUE;
            int n5 = nArray2[n3] ^ Integer.MIN_VALUE;
            if (n4 < n5) {
                return false;
            }
            if (n4 > n5) {
                return true;
            }
            --n3;
        }
        return true;
    }

    public static boolean gte(int n3, int[] nArray, int n4, int[] nArray2, int n5) {
        --n3;
        while (n3 >= 0) {
            int n6 = nArray[n4 + n3] ^ Integer.MIN_VALUE;
            int n7 = nArray2[n5 + n3] ^ Integer.MIN_VALUE;
            if (n6 < n7) {
                return false;
            }
            if (n6 > n7) {
                return true;
            }
            --n3;
        }
        return true;
    }

    public static int inc(int n3, int[] nArray) {
        for (int i3 = 0; i3 < n3; ++i3) {
            int n4;
            nArray[i3] = n4 = nArray[i3] + 1;
            if (n4 == 0) continue;
            return 0;
        }
        return 1;
    }

    public static int inc(int n3, int[] nArray, int[] nArray2) {
        for (int i3 = 0; i3 < n3; ++i3) {
            int n4;
            nArray2[i3] = n4 = nArray[i3] + 1;
            if (n4 == 0) continue;
            while (i3 < n3) {
                nArray2[i3] = nArray[i3];
                ++i3;
            }
            return 0;
        }
        return 1;
    }

    public static int incAt(int n3, int[] nArray, int n4) {
        while (n4 < n3) {
            int n5;
            nArray[n4] = n5 = nArray[n4] + 1;
            if (n5 != 0) {
                return 0;
            }
            ++n4;
        }
        return 1;
    }

    public static int incAt(int n3, int[] nArray, int n4, int n5) {
        while (n5 < n3) {
            int n6;
            int n7 = n4 + n5;
            nArray[n7] = n6 = nArray[n7] + 1;
            if (n6 != 0) {
                return 0;
            }
            ++n5;
        }
        return 1;
    }

    public static boolean isOne(int n3, int[] nArray) {
        if (nArray[0] != 1) {
            return false;
        }
        for (int i3 = 1; i3 < n3; ++i3) {
            if (nArray[i3] == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isZero(int n3, int[] nArray) {
        for (int i3 = 0; i3 < n3; ++i3) {
            if (nArray[i3] == 0) continue;
            return false;
        }
        return true;
    }

    public static int lessThan(int n3, int[] nArray, int[] nArray2) {
        long l3 = 0L;
        for (int i3 = 0; i3 < n3; ++i3) {
            l3 = ((long)nArray[i3] & 0xFFFFFFFFL) - ((long)nArray2[i3] & 0xFFFFFFFFL) + l3 >> 32;
        }
        return (int)l3;
    }

    public static int lessThan(int n3, int[] nArray, int n4, int[] nArray2, int n5) {
        long l3 = 0L;
        for (int i3 = 0; i3 < n3; ++i3) {
            l3 = ((long)nArray[n4 + i3] & 0xFFFFFFFFL) - ((long)nArray2[n5 + i3] & 0xFFFFFFFFL) + l3 >> 32;
        }
        return (int)l3;
    }

    public static void mul(int n3, int[] nArray, int[] nArray2, int[] nArray3) {
        int n4 = n3;
        nArray3[n4] = Nat.mulWord(n4, nArray[0], nArray2, nArray3);
        for (int i3 = 1; i3 < n3; ++i3) {
            int n5 = i3;
            int n6 = n5 + n3;
            nArray3[n6] = Nat.mulWordAddTo(n3, nArray[n5], nArray2, 0, nArray3, i3);
        }
    }

    public static void mul(int n3, int[] nArray, int n4, int[] nArray2, int n5, int[] nArray3, int n6) {
        int n7 = n6 + n3;
        nArray3[n7] = Nat.mulWord(n3, nArray[n4], nArray2, n5, nArray3, n6);
        for (n7 = 1; n7 < n3; ++n7) {
            int n8 = n6 + n7;
            int n9 = n8 + n3;
            nArray3[n9] = Nat.mulWordAddTo(n3, nArray[n4 + n7], nArray2, n5, nArray3, n8);
        }
    }

    public static void mul(int[] nArray, int n3, int n4, int[] nArray2, int n5, int n6, int[] nArray3, int n7) {
        int n8 = n7 + n6;
        nArray3[n8] = Nat.mulWord(n6, nArray[n3], nArray2, n5, nArray3, n7);
        for (n8 = 1; n8 < n4; ++n8) {
            int n9 = n7 + n8;
            int n10 = n9 + n6;
            nArray3[n10] = Nat.mulWordAddTo(n6, nArray[n3 + n8], nArray2, n5, nArray3, n9);
        }
    }

    public static int mulAddTo(int n3, int[] nArray, int[] nArray2, int[] nArray3) {
        long l3 = 0L;
        for (int i3 = 0; i3 < n3; ++i3) {
            int n4 = i3 + n3;
            long l4 = l3 + ((long)Nat.mulWordAddTo(n3, nArray[i3], nArray2, 0, nArray3, i3) & 0xFFFFFFFFL) + ((long)nArray3[n4] & 0xFFFFFFFFL);
            nArray3[n4] = (int)l4;
            l3 = l4 >>> 32;
        }
        return (int)l3;
    }

    public static int mulAddTo(int n3, int[] nArray, int n4, int[] nArray2, int n5, int[] nArray3, int n6) {
        long l3 = 0L;
        for (int i3 = 0; i3 < n3; ++i3) {
            int n7 = n6 + n3;
            long l4 = l3 + ((long)Nat.mulWordAddTo(n3, nArray[n4 + i3], nArray2, n5, nArray3, n6) & 0xFFFFFFFFL) + ((long)nArray3[n7] & 0xFFFFFFFFL);
            nArray3[n7] = (int)l4;
            l3 = l4 >>> 32;
            ++n6;
        }
        return (int)l3;
    }

    public static int mul31BothAdd(int n3, int n4, int[] nArray, int n5, int[] nArray2, int[] nArray3, int n6) {
        long l3 = 0L;
        long l4 = (long)n4 & 0xFFFFFFFFL;
        long l5 = (long)n5 & 0xFFFFFFFFL;
        n4 = 0;
        do {
            long l6 = l4 * ((long)nArray[n4] & 0xFFFFFFFFL);
            n5 = n6 + n4;
            l3 = l5 * ((long)nArray2[n4] & 0xFFFFFFFFL) + l6 + ((long)nArray3[n5] & 0xFFFFFFFFL) + l3;
            nArray3[n5] = (int)l3;
            l3 >>>= 32;
        } while (++n4 < n3);
        return (int)l3;
    }

    public static int mulWord(int n3, int n4, int[] nArray, int[] nArray2) {
        long l3 = 0L;
        long l4 = (long)n4 & 0xFFFFFFFFL;
        n4 = 0;
        do {
            l3 = l4 * ((long)nArray[n4] & 0xFFFFFFFFL) + l3;
            nArray2[n4] = (int)l3;
            l3 >>>= 32;
        } while (++n4 < n3);
        return (int)l3;
    }

    public static int mulWord(int n3, int n4, int[] nArray, int n5, int[] nArray2, int n6) {
        long l3 = 0L;
        long l4 = (long)n4 & 0xFFFFFFFFL;
        n4 = 0;
        do {
            l3 = l4 * ((long)nArray[n5 + n4] & 0xFFFFFFFFL) + l3;
            int n7 = n6 + n4;
            nArray2[n7] = (int)l3;
            l3 >>>= 32;
        } while (++n4 < n3);
        return (int)l3;
    }

    public static int mulWordAddTo(int n3, int n4, int[] nArray, int n5, int[] nArray2, int n6) {
        long l3 = 0L;
        long l4 = (long)n4 & 0xFFFFFFFFL;
        n4 = 0;
        do {
            int n7 = n6 + n4;
            l3 = l4 * ((long)nArray[n5 + n4] & 0xFFFFFFFFL) + ((long)nArray2[n7] & 0xFFFFFFFFL) + l3;
            nArray2[n7] = (int)l3;
            l3 >>>= 32;
        } while (++n4 < n3);
        return (int)l3;
    }

    public static int mulWordDwordAddAt(int n3, int n4, long l3, int[] nArray, int n5) {
        long l4 = (long)n4 & 0xFFFFFFFFL;
        long l5 = l3;
        n4 = n5 + 0;
        l3 = l4 * (l3 & 0xFFFFFFFFL) + ((long)nArray[n4] & 0xFFFFFFFFL) + 0L;
        nArray[n4] = (int)l3;
        long l6 = l3 >>> 32;
        int n6 = n5 + 1;
        l6 = l4 * (l5 >>> 32) + ((long)nArray[n6] & 0xFFFFFFFFL) + l6;
        nArray[n6] = (int)l6;
        int n7 = n5 + 2;
        l3 = (l6 >>> 32) + ((long)nArray[n7] & 0xFFFFFFFFL);
        nArray[n7] = (int)l3;
        return l3 >>> 32 == 0L ? 0 : Nat.incAt(n3, nArray, n5 + 3);
    }

    public static int shiftDownBit(int n3, int[] nArray, int n4) {
        while ((n3 += -1) >= 0) {
            int n5 = nArray[n3];
            nArray[n3] = n5 >>> 1 | n4 << 31;
            n4 = n5;
        }
        return n4 << 31;
    }

    public static int shiftDownBit(int n3, int[] nArray, int n4, int n5) {
        while ((n3 += -1) >= 0) {
            int n6 = n4 + n3;
            int n7 = nArray[n6];
            nArray[n6] = n7 >>> 1 | n5 << 31;
            n5 = n7;
        }
        return n5 << 31;
    }

    public static int shiftDownBit(int n3, int[] nArray, int n4, int[] nArray2) {
        while ((n3 += -1) >= 0) {
            int n5 = nArray[n3];
            nArray2[n3] = n5 >>> 1 | n4 << 31;
            n4 = n5;
        }
        return n4 << 31;
    }

    public static int shiftDownBit(int n3, int[] nArray, int n4, int n5, int[] nArray2, int n6) {
        while ((n3 += -1) >= 0) {
            int n7 = nArray[n4 + n3];
            int n8 = n6 + n3;
            nArray2[n8] = n7 >>> 1 | n5 << 31;
            n5 = n7;
        }
        return n5 << 31;
    }

    public static int shiftDownBits(int n3, int[] nArray, int n4, int n5) {
        while ((n3 += -1) >= 0) {
            int n6 = nArray[n3];
            nArray[n3] = n6 >>> n4 | n5 << -n4;
            n5 = n6;
        }
        return n5 << -n4;
    }

    public static int shiftDownBits(int n3, int[] nArray, int n4, int n5, int n6) {
        while ((n3 += -1) >= 0) {
            int n7 = n4 + n3;
            int n8 = nArray[n7];
            nArray[n7] = n8 >>> n5 | n6 << -n5;
            n6 = n8;
        }
        return n6 << -n5;
    }

    public static int shiftDownBits(int n3, int[] nArray, int n4, int n5, int[] nArray2) {
        while ((n3 += -1) >= 0) {
            int n6 = nArray[n3];
            nArray2[n3] = n6 >>> n4 | n5 << -n4;
            n5 = n6;
        }
        return n5 << -n4;
    }

    public static int shiftDownBits(int n3, int[] nArray, int n4, int n5, int n6, int[] nArray2, int n7) {
        while ((n3 += -1) >= 0) {
            int n8 = nArray[n4 + n3];
            int n9 = n7 + n3;
            nArray2[n9] = n8 >>> n5 | n6 << -n5;
            n6 = n8;
        }
        return n6 << -n5;
    }

    public static int shiftDownWord(int n3, int[] nArray, int n4) {
        while ((n3 += -1) >= 0) {
            int n5 = nArray[n3];
            nArray[n3] = n4;
            n4 = n5;
        }
        return n4;
    }

    public static int shiftUpBit(int n3, int[] nArray, int n4) {
        for (int i3 = 0; i3 < n3; ++i3) {
            int n5 = nArray[i3];
            nArray[i3] = n5 << 1 | n4 >>> 31;
            n4 = n5;
        }
        return n4 >>> 31;
    }

    public static int shiftUpBit(int n3, int[] nArray, int n4, int n5) {
        for (int i3 = 0; i3 < n3; ++i3) {
            int n6 = n4 + i3;
            int n7 = nArray[n6];
            nArray[n6] = n7 << 1 | n5 >>> 31;
            n5 = n7;
        }
        return n5 >>> 31;
    }

    public static int shiftUpBit(int n3, int[] nArray, int n4, int[] nArray2) {
        for (int i3 = 0; i3 < n3; ++i3) {
            int n5 = nArray[i3];
            nArray2[i3] = n5 << 1 | n4 >>> 31;
            n4 = n5;
        }
        return n4 >>> 31;
    }

    public static int shiftUpBit(int n3, int[] nArray, int n4, int n5, int[] nArray2, int n6) {
        for (int i3 = 0; i3 < n3; ++i3) {
            int n7 = nArray[n4 + i3];
            int n8 = n6 + i3;
            nArray2[n8] = n7 << 1 | n5 >>> 31;
            n5 = n7;
        }
        return n5 >>> 31;
    }

    public static long shiftUpBit64(int n3, long[] lArray, int n4, long l3, long[] lArray2, int n5) {
        for (int i3 = 0; i3 < n3; ++i3) {
            long l4 = lArray[n4 + i3];
            int n6 = n5 + i3;
            lArray2[n6] = l3 = l4 << 1 | l3 >>> 63;
            l3 = l4;
        }
        return l3 >>> 63;
    }

    public static int shiftUpBits(int n3, int[] nArray, int n4, int n5) {
        for (int i3 = 0; i3 < n3; ++i3) {
            int n6 = nArray[i3];
            nArray[i3] = n6 << n4 | n5 >>> -n4;
            n5 = n6;
        }
        return n5 >>> -n4;
    }

    public static int shiftUpBits(int n3, int[] nArray, int n4, int n5, int n6) {
        for (int i3 = 0; i3 < n3; ++i3) {
            int n7 = n4 + i3;
            int n8 = nArray[n7];
            nArray[n7] = n8 << n5 | n6 >>> -n5;
            n6 = n8;
        }
        return n6 >>> -n5;
    }

    public static long shiftUpBits64(int n3, long[] lArray, int n4, int n5, long l3) {
        for (int i3 = 0; i3 < n3; ++i3) {
            int n6 = n4 + i3;
            long l4 = lArray[n6];
            lArray[n6] = l4 << n5 | l3 >>> -n5;
            l3 = l4;
        }
        return l3 >>> -n5;
    }

    public static int shiftUpBits(int n3, int[] nArray, int n4, int n5, int[] nArray2) {
        for (int i3 = 0; i3 < n3; ++i3) {
            int n6 = nArray[i3];
            nArray2[i3] = n6 << n4 | n5 >>> -n4;
            n5 = n6;
        }
        return n5 >>> -n4;
    }

    public static int shiftUpBits(int n3, int[] nArray, int n4, int n5, int n6, int[] nArray2, int n7) {
        for (int i3 = 0; i3 < n3; ++i3) {
            int n8 = nArray[n4 + i3];
            int n9 = n7 + i3;
            nArray2[n9] = n8 << n5 | n6 >>> -n5;
            n6 = n8;
        }
        return n6 >>> -n5;
    }

    public static long shiftUpBits64(int n3, long[] lArray, int n4, int n5, long l3, long[] lArray2, int n6) {
        for (int i3 = 0; i3 < n3; ++i3) {
            long l4 = lArray[n4 + i3];
            int n7 = n6 + i3;
            lArray2[n7] = l3 = l4 << n5 | l3 >>> -n5;
            l3 = l4;
        }
        return l3 >>> -n5;
    }

    public static void square(int n3, int[] nArray, int[] nArray2) {
        int n4 = n3 << 1;
        int n5 = 0;
        int n6 = n4;
        int n7 = n3;
        while (true) {
            long l3 = (long)nArray[n7 += -1] & 0xFFFFFFFFL;
            long l4 = l3 * l3;
            int n8 = n5;
            n5 = n6 + -1;
            nArray2[n5] = n8 << 31 | (int)(l4 >>> 33);
            nArray2[--n5] = (int)(l4 >>> 1);
            n6 = (int)l4;
            if (n7 <= 0) {
                long l5 = 0L;
                n6 = 2;
                for (int i3 = 1; i3 < n3; ++i3) {
                    l5 = l5 + ((long)Nat.squareWordAddTo(nArray, i3, nArray2) & 0xFFFFFFFFL) + ((long)nArray2[n6] & 0xFFFFFFFFL);
                    int n9 = n6 + 1;
                    nArray2[n6] = (int)l5;
                    long l6 = (l5 >>> 32) + ((long)nArray2[n9] & 0xFFFFFFFFL);
                    n6 = n9 + 1;
                    nArray2[n9] = (int)l6;
                    l5 = l6 >>> 32;
                }
                Nat.shiftUpBit(n4, nArray2, nArray[0] << 31);
                return;
            }
            int n10 = n5;
            n5 = n6;
            n6 = n10;
        }
    }

    public static void square(int n3, int[] nArray, int n4, int[] nArray2, int n5) {
        int n6 = n3 << 1;
        int n7 = 0;
        int n8 = n6;
        int n9 = n3;
        while (true) {
            long l3 = (long)nArray[n4 + (n9 += -1)] & 0xFFFFFFFFL;
            long l4 = l3 * l3;
            int n10 = n7;
            n7 = n8 + -1;
            n8 = n5 + n7;
            nArray2[n8] = n10 << 31 | (int)(l4 >>> 33);
            n8 = n5 + (n7 += -1);
            nArray2[n8] = (int)(l4 >>> 1);
            n8 = (int)l4;
            if (n9 <= 0) {
                long l5 = 0L;
                n8 = n5 + 2;
                for (int i3 = 1; i3 < n3; ++i3) {
                    l5 = l5 + ((long)Nat.squareWordAddTo(nArray, n4, i3, nArray2, n5) & 0xFFFFFFFFL) + ((long)nArray2[n8] & 0xFFFFFFFFL);
                    int n11 = n8 + 1;
                    nArray2[n8] = (int)l5;
                    long l6 = (l5 >>> 32) + ((long)nArray2[n11] & 0xFFFFFFFFL);
                    n8 = n11 + 1;
                    nArray2[n11] = (int)l6;
                    l5 = l6 >>> 32;
                }
                Nat.shiftUpBit(n6, nArray2, n5, nArray[n4] << 31);
                return;
            }
            int n12 = n7;
            n7 = n8;
            n8 = n12;
        }
    }

    public static int squareWordAdd(int[] nArray, int n3, int[] nArray2) {
        long l3 = 0L;
        long l4 = (long)nArray[n3] & 0xFFFFFFFFL;
        int n4 = 0;
        do {
            int n5 = n3 + n4;
            l3 = l4 * ((long)nArray[n4] & 0xFFFFFFFFL) + ((long)nArray2[n5] & 0xFFFFFFFFL) + l3;
            nArray2[n5] = (int)l3;
            l3 >>>= 32;
        } while (++n4 < n3);
        return (int)l3;
    }

    public static int squareWordAdd(int[] nArray, int n3, int n4, int[] nArray2, int n5) {
        long l3 = 0L;
        long l4 = (long)nArray[n3 + n4] & 0xFFFFFFFFL;
        int n6 = 0;
        do {
            int n7 = n4 + n5;
            l3 = l4 * ((long)nArray[n3 + n6] & 0xFFFFFFFFL) + ((long)nArray2[n7] & 0xFFFFFFFFL) + l3;
            nArray2[n7] = (int)l3;
            l3 >>>= 32;
            ++n5;
        } while (++n6 < n4);
        return (int)l3;
    }

    public static int squareWordAddTo(int[] nArray, int n3, int[] nArray2) {
        long l3 = 0L;
        long l4 = (long)nArray[n3] & 0xFFFFFFFFL;
        int n4 = 0;
        do {
            int n5 = n3 + n4;
            l3 = l4 * ((long)nArray[n4] & 0xFFFFFFFFL) + ((long)nArray2[n5] & 0xFFFFFFFFL) + l3;
            nArray2[n5] = (int)l3;
            l3 >>>= 32;
        } while (++n4 < n3);
        return (int)l3;
    }

    public static int squareWordAddTo(int[] nArray, int n3, int n4, int[] nArray2, int n5) {
        long l3 = 0L;
        long l4 = (long)nArray[n3 + n4] & 0xFFFFFFFFL;
        int n6 = 0;
        do {
            int n7 = n4 + n5;
            l3 = l4 * ((long)nArray[n3 + n6] & 0xFFFFFFFFL) + ((long)nArray2[n7] & 0xFFFFFFFFL) + l3;
            nArray2[n7] = (int)l3;
            l3 >>>= 32;
            ++n5;
        } while (++n6 < n4);
        return (int)l3;
    }

    public static int sub(int n3, int[] nArray, int[] nArray2, int[] nArray3) {
        long l3 = 0L;
        for (int i3 = 0; i3 < n3; ++i3) {
            l3 = ((long)nArray[i3] & 0xFFFFFFFFL) - ((long)nArray2[i3] & 0xFFFFFFFFL) + l3;
            nArray3[i3] = (int)l3;
            l3 >>= 32;
        }
        return (int)l3;
    }

    public static int sub(int n3, int[] nArray, int n4, int[] nArray2, int n5, int[] nArray3, int n6) {
        long l3 = 0L;
        for (int i3 = 0; i3 < n3; ++i3) {
            l3 = ((long)nArray[n4 + i3] & 0xFFFFFFFFL) - ((long)nArray2[n5 + i3] & 0xFFFFFFFFL) + l3;
            int n7 = n6 + i3;
            nArray3[n7] = (int)l3;
            l3 >>= 32;
        }
        return (int)l3;
    }

    public static int sub33At(int n3, int n4, int[] nArray, int n5) {
        int n6 = n5 + 0;
        long l3 = ((long)nArray[n6] & 0xFFFFFFFFL) - ((long)n4 & 0xFFFFFFFFL);
        nArray[n6] = (int)l3;
        long l4 = l3 >> 32;
        n4 = n5 + 1;
        l4 = ((long)nArray[n4] & 0xFFFFFFFFL) - 1L + l4;
        nArray[n4] = (int)l4;
        return l4 >> 32 == 0L ? 0 : Nat.decAt(n3, nArray, n5 + 2);
    }

    public static int sub33At(int n3, int n4, int[] nArray, int n5, int n6) {
        int n7;
        int n8 = n5 + n6;
        long l3 = ((long)nArray[n8] & 0xFFFFFFFFL) - ((long)n4 & 0xFFFFFFFFL);
        nArray[n8] = (int)l3;
        n4 = n8 + 1;
        long l4 = ((long)nArray[n4] & 0xFFFFFFFFL) - 1L + (l3 >>= 32);
        nArray[n4] = (int)l4;
        if (l4 >> 32 == 0L) {
            n7 = 0;
        } else {
            int n9 = n3;
            n3 = n6 + 2;
            n7 = Nat.decAt(n9, nArray, n5, n3);
        }
        return n7;
    }

    public static int sub33From(int n3, int n4, int[] nArray) {
        long l3 = ((long)nArray[0] & 0xFFFFFFFFL) - ((long)n4 & 0xFFFFFFFFL);
        nArray[0] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray[1] & 0xFFFFFFFFL) - 1L + l3;
        nArray[1] = (int)l3;
        return l3 >> 32 == 0L ? 0 : Nat.decAt(n3, nArray, 2);
    }

    public static int sub33From(int n3, int n4, int[] nArray, int n5) {
        int n6 = n5 + 0;
        long l3 = ((long)nArray[n6] & 0xFFFFFFFFL) - ((long)n4 & 0xFFFFFFFFL);
        nArray[n6] = (int)l3;
        long l4 = l3 >> 32;
        n4 = n5 + 1;
        l4 = ((long)nArray[n4] & 0xFFFFFFFFL) - 1L + l4;
        nArray[n4] = (int)l4;
        return l4 >> 32 == 0L ? 0 : Nat.decAt(n3, nArray, n5, 2);
    }

    public static int subBothFrom(int n3, int[] nArray, int[] nArray2, int[] nArray3) {
        long l3 = 0L;
        for (int i3 = 0; i3 < n3; ++i3) {
            l3 = ((long)nArray3[i3] & 0xFFFFFFFFL) - ((long)nArray[i3] & 0xFFFFFFFFL) - ((long)nArray2[i3] & 0xFFFFFFFFL) + l3;
            nArray3[i3] = (int)l3;
            l3 >>= 32;
        }
        return (int)l3;
    }

    public static int subBothFrom(int n3, int[] nArray, int n4, int[] nArray2, int n5, int[] nArray3, int n6) {
        long l3 = 0L;
        for (int i3 = 0; i3 < n3; ++i3) {
            int n7 = n6 + i3;
            l3 = ((long)nArray3[n7] & 0xFFFFFFFFL) - ((long)nArray[n4 + i3] & 0xFFFFFFFFL) - ((long)nArray2[n5 + i3] & 0xFFFFFFFFL) + l3;
            nArray3[n7] = (int)l3;
            l3 >>= 32;
        }
        return (int)l3;
    }

    public static int subDWordAt(int n3, long l3, int[] nArray, int n4) {
        int n5 = n4 + 0;
        long l4 = ((long)nArray[n5] & 0xFFFFFFFFL) - (l3 & 0xFFFFFFFFL);
        nArray[n5] = (int)l4;
        long l5 = l4 >> 32;
        int n6 = n4 + 1;
        l3 = ((long)nArray[n6] & 0xFFFFFFFFL) - (l3 >>> 32) + l5;
        nArray[n6] = (int)l3;
        return l3 >> 32 == 0L ? 0 : Nat.decAt(n3, nArray, n4 + 2);
    }

    public static int subDWordAt(int n3, long l3, int[] nArray, int n4, int n5) {
        int n6;
        int n7 = n4 + n5;
        long l4 = ((long)nArray[n7] & 0xFFFFFFFFL) - (l3 & 0xFFFFFFFFL);
        nArray[n7] = (int)l4;
        l3 = ((long)nArray[++n7] & 0xFFFFFFFFL) - (l3 >>> 32) + (l4 >>= 32);
        nArray[n7] = (int)l3;
        if (l3 >> 32 == 0L) {
            n6 = 0;
        } else {
            int n8 = n3;
            n3 = n5 + 2;
            n6 = Nat.decAt(n8, nArray, n4, n3);
        }
        return n6;
    }

    public static int subDWordFrom(int n3, long l3, int[] nArray) {
        long l4 = ((long)nArray[0] & 0xFFFFFFFFL) - (l3 & 0xFFFFFFFFL);
        nArray[0] = (int)l4;
        l3 = ((long)nArray[1] & 0xFFFFFFFFL) - (l3 >>> 32) + (l4 >>= 32);
        nArray[1] = (int)l3;
        return l3 >> 32 == 0L ? 0 : Nat.decAt(n3, nArray, 2);
    }

    public static int subDWordFrom(int n3, long l3, int[] nArray, int n4) {
        int n5 = n4 + 0;
        long l4 = ((long)nArray[n5] & 0xFFFFFFFFL) - (l3 & 0xFFFFFFFFL);
        nArray[n5] = (int)l4;
        long l5 = l4 >> 32;
        int n6 = n4 + 1;
        l3 = ((long)nArray[n6] & 0xFFFFFFFFL) - (l3 >>> 32) + l5;
        nArray[n6] = (int)l3;
        return l3 >> 32 == 0L ? 0 : Nat.decAt(n3, nArray, n4, 2);
    }

    public static int subFrom(int n3, int[] nArray, int[] nArray2) {
        long l3 = 0L;
        for (int i3 = 0; i3 < n3; ++i3) {
            l3 = ((long)nArray2[i3] & 0xFFFFFFFFL) - ((long)nArray[i3] & 0xFFFFFFFFL) + l3;
            nArray2[i3] = (int)l3;
            l3 >>= 32;
        }
        return (int)l3;
    }

    public static int subFrom(int n3, int[] nArray, int n4, int[] nArray2, int n5) {
        long l3 = 0L;
        for (int i3 = 0; i3 < n3; ++i3) {
            int n6 = n5 + i3;
            l3 = ((long)nArray2[n6] & 0xFFFFFFFFL) - ((long)nArray[n4 + i3] & 0xFFFFFFFFL) + l3;
            nArray2[n6] = (int)l3;
            l3 >>= 32;
        }
        return (int)l3;
    }

    public static int subWordAt(int n3, int n4, int[] nArray, int n5) {
        long l3 = ((long)nArray[n5] & 0xFFFFFFFFL) - ((long)n4 & 0xFFFFFFFFL);
        nArray[n5] = (int)l3;
        return l3 >> 32 == 0L ? 0 : Nat.decAt(n3, nArray, n5 + 1);
    }

    public static int subWordAt(int n3, int n4, int[] nArray, int n5, int n6) {
        int n7;
        int n8 = n5 + n6;
        long l3 = ((long)nArray[n8] & 0xFFFFFFFFL) - ((long)n4 & 0xFFFFFFFFL);
        nArray[n8] = (int)l3;
        if (l3 >> 32 == 0L) {
            n7 = 0;
        } else {
            int n9 = n3;
            n3 = n6 + 1;
            n7 = Nat.decAt(n9, nArray, n5, n3);
        }
        return n7;
    }

    public static int subWordFrom(int n3, int n4, int[] nArray) {
        long l3 = ((long)nArray[0] & 0xFFFFFFFFL) - ((long)n4 & 0xFFFFFFFFL);
        nArray[0] = (int)l3;
        return l3 >> 32 == 0L ? 0 : Nat.decAt(n3, nArray, 1);
    }

    public static int subWordFrom(int n3, int n4, int[] nArray, int n5) {
        int n6 = n5 + 0;
        long l3 = ((long)nArray[n6] & 0xFFFFFFFFL) - ((long)n4 & 0xFFFFFFFFL);
        nArray[n6] = (int)l3;
        return l3 >> 32 == 0L ? 0 : Nat.decAt(n3, nArray, n5, 1);
    }

    public static BigInteger toBigInteger(int n3, int[] nArray) {
        byte[] byArray = new byte[n3 << 2];
        for (int i3 = 0; i3 < n3; ++i3) {
            int n4 = nArray[i3];
            if (n4 == 0) continue;
            Pack.intToBigEndian(n4, byArray, n3 - 1 - i3 << 2);
        }
        return new BigInteger(1, byArray);
    }

    public static void zero(int n3, int[] nArray) {
        for (int i3 = 0; i3 < n3; ++i3) {
            nArray[i3] = 0;
        }
    }

    public static void zero(int n3, int[] nArray, int n4) {
        for (int i3 = 0; i3 < n3; ++i3) {
            nArray[n4 + i3] = 0;
        }
    }

    public static void zero64(int n3, long[] lArray) {
        for (int i3 = 0; i3 < n3; ++i3) {
            lArray[i3] = 0L;
        }
    }
}

