/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.raw;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;
import java.math.BigInteger;

public abstract class Nat128 {
    private static final long M = 0xFFFFFFFFL;

    public static int add(int[] nArray, int[] nArray2, int[] nArray3) {
        long l3 = ((long)nArray[0] & 0xFFFFFFFFL) + ((long)nArray2[0] & 0xFFFFFFFFL) + 0L;
        nArray3[0] = (int)l3;
        l3 >>>= 32;
        l3 = ((long)nArray[1] & 0xFFFFFFFFL) + ((long)nArray2[1] & 0xFFFFFFFFL) + l3;
        nArray3[1] = (int)l3;
        l3 >>>= 32;
        l3 = ((long)nArray[2] & 0xFFFFFFFFL) + ((long)nArray2[2] & 0xFFFFFFFFL) + l3;
        nArray3[2] = (int)l3;
        long l4 = ((long)nArray[3] & 0xFFFFFFFFL) + ((long)nArray2[3] & 0xFFFFFFFFL) + (l3 >>>= 32);
        nArray3[3] = (int)l4;
        return (int)(l4 >>> 32);
    }

    public static int addBothTo(int[] nArray, int[] nArray2, int[] nArray3) {
        long l3 = ((long)nArray[0] & 0xFFFFFFFFL) + ((long)nArray2[0] & 0xFFFFFFFFL) + ((long)nArray3[0] & 0xFFFFFFFFL) + 0L;
        nArray3[0] = (int)l3;
        l3 >>>= 32;
        l3 = ((long)nArray[1] & 0xFFFFFFFFL) + ((long)nArray2[1] & 0xFFFFFFFFL) + ((long)nArray3[1] & 0xFFFFFFFFL) + l3;
        nArray3[1] = (int)l3;
        l3 >>>= 32;
        l3 = ((long)nArray[2] & 0xFFFFFFFFL) + ((long)nArray2[2] & 0xFFFFFFFFL) + ((long)nArray3[2] & 0xFFFFFFFFL) + l3;
        nArray3[2] = (int)l3;
        long l4 = ((long)nArray[3] & 0xFFFFFFFFL) + ((long)nArray2[3] & 0xFFFFFFFFL) + ((long)nArray3[3] & 0xFFFFFFFFL) + (l3 >>>= 32);
        nArray3[3] = (int)l4;
        return (int)(l4 >>> 32);
    }

    public static int addTo(int[] nArray, int[] nArray2) {
        long l3 = ((long)nArray[0] & 0xFFFFFFFFL) + ((long)nArray2[0] & 0xFFFFFFFFL) + 0L;
        nArray2[0] = (int)l3;
        l3 >>>= 32;
        l3 = ((long)nArray[1] & 0xFFFFFFFFL) + ((long)nArray2[1] & 0xFFFFFFFFL) + l3;
        nArray2[1] = (int)l3;
        l3 >>>= 32;
        l3 = ((long)nArray[2] & 0xFFFFFFFFL) + ((long)nArray2[2] & 0xFFFFFFFFL) + l3;
        nArray2[2] = (int)l3;
        l3 >>>= 32;
        l3 = ((long)nArray[3] & 0xFFFFFFFFL) + ((long)nArray2[3] & 0xFFFFFFFFL) + l3;
        nArray2[3] = (int)l3;
        return (int)(l3 >>> 32);
    }

    public static int addTo(int[] nArray, int n3, int[] nArray2, int n4, int n5) {
        long l3 = (long)n5 & 0xFFFFFFFFL;
        n5 = n4 + 0;
        l3 = ((long)nArray[n3 + 0] & 0xFFFFFFFFL) + ((long)nArray2[n5] & 0xFFFFFFFFL) + l3;
        nArray2[n5] = (int)l3;
        l3 >>>= 32;
        n5 = n4 + 1;
        l3 = ((long)nArray[n3 + 1] & 0xFFFFFFFFL) + ((long)nArray2[n5] & 0xFFFFFFFFL) + l3;
        nArray2[n5] = (int)l3;
        l3 >>>= 32;
        n5 = n4 + 2;
        l3 = ((long)nArray[n3 + 2] & 0xFFFFFFFFL) + ((long)nArray2[n5] & 0xFFFFFFFFL) + l3;
        nArray2[n5] = (int)l3;
        l3 >>>= 32;
        l3 = ((long)nArray[n3 + 3] & 0xFFFFFFFFL) + ((long)nArray2[n4 += 3] & 0xFFFFFFFFL) + l3;
        nArray2[n4] = (int)l3;
        return (int)(l3 >>> 32);
    }

    public static int addToEachOther(int[] nArray, int n3, int[] nArray2, int n4) {
        int n5;
        int n6;
        int n7;
        int n8 = n3 + 0;
        int n9 = n4 + 0;
        long l3 = ((long)nArray[n8] & 0xFFFFFFFFL) + ((long)nArray2[n9] & 0xFFFFFFFFL) + 0L;
        nArray[n8] = n8 = (int)l3;
        nArray2[n9] = n8;
        long l4 = l3 >>> 32;
        int n10 = n3 + 1;
        int n11 = n4 + 1;
        l4 = ((long)nArray[n10] & 0xFFFFFFFFL) + ((long)nArray2[n11] & 0xFFFFFFFFL) + l4;
        nArray[n10] = n7 = (int)l4;
        nArray2[n11] = n7;
        long l5 = l4 >>> 32;
        n10 = n3 + 2;
        n11 = n4 + 2;
        l5 = ((long)nArray[n10] & 0xFFFFFFFFL) + ((long)nArray2[n11] & 0xFFFFFFFFL) + l5;
        nArray[n10] = n6 = (int)l5;
        nArray2[n11] = n6;
        long l6 = l5 >>> 32;
        l6 = ((long)nArray[n3 += 3] & 0xFFFFFFFFL) + ((long)nArray2[n4 += 3] & 0xFFFFFFFFL) + l6;
        nArray[n3] = n5 = (int)l6;
        nArray2[n4] = n5;
        return (int)(l6 >>> 32);
    }

    public static void copy(int[] nArray, int[] nArray2) {
        nArray2[0] = nArray[0];
        nArray2[1] = nArray[1];
        nArray2[2] = nArray[2];
        nArray2[3] = nArray[3];
    }

    public static void copy(int[] nArray, int n3, int[] nArray2, int n4) {
        int n5 = n4 + 0;
        nArray2[n5] = nArray[n3 + 0];
        n5 = n4 + 1;
        nArray2[n5] = nArray[n3 + 1];
        n5 = n4 + 2;
        nArray2[n5] = nArray[n3 + 2];
        n5 = n4 + 3;
        nArray2[n5] = nArray[n3 + 3];
    }

    public static void copy64(long[] lArray, long[] lArray2) {
        long l3;
        lArray2[0] = l3 = lArray[0];
        lArray2[1] = l3 = lArray[1];
    }

    public static void copy64(long[] lArray, int n3, long[] lArray2, int n4) {
        long l3;
        int n5 = n4 + 0;
        lArray2[n5] = l3 = lArray[n3 + 0];
        n5 = n4 + 1;
        lArray2[n5] = l3 = lArray[n3 + 1];
    }

    public static int[] create() {
        return new int[4];
    }

    public static long[] create64() {
        return new long[2];
    }

    public static int[] createExt() {
        return new int[8];
    }

    public static long[] createExt64() {
        return new long[4];
    }

    public static boolean diff(int[] nArray, int n3, int[] nArray2, int n4, int[] nArray3, int n5) {
        boolean bl = Nat128.gte(nArray, n3, nArray2, n4);
        if (bl) {
            Nat128.sub(nArray, n3, nArray2, n4, nArray3, n5);
        } else {
            Nat128.sub(nArray2, n4, nArray, n3, nArray3, n5);
        }
        return bl;
    }

    public static boolean eq(int[] nArray, int[] nArray2) {
        for (int i3 = 3; i3 >= 0; --i3) {
            if (nArray[i3] == nArray2[i3]) continue;
            return false;
        }
        return true;
    }

    public static boolean eq64(long[] lArray, long[] lArray2) {
        for (int i3 = 1; i3 >= 0; --i3) {
            if (lArray[i3] == lArray2[i3]) continue;
            return false;
        }
        return true;
    }

    public static int[] fromBigInteger(BigInteger bigInteger) {
        if (bigInteger.signum() >= 0 && bigInteger.bitLength() <= 128) {
            int[] nArray = Nat128.create();
            for (int i3 = 0; i3 < 4; ++i3) {
                nArray[i3] = bigInteger.intValue();
                bigInteger = bigInteger.shiftRight(32);
            }
            return nArray;
        }
        throw new IllegalArgumentException();
    }

    public static long[] fromBigInteger64(BigInteger bigInteger) {
        if (bigInteger.signum() >= 0 && bigInteger.bitLength() <= 128) {
            long[] lArray = Nat128.create64();
            for (int i3 = 0; i3 < 2; ++i3) {
                long l3;
                lArray[i3] = l3 = bigInteger.longValue();
                bigInteger = bigInteger.shiftRight(64);
            }
            return lArray;
        }
        throw new IllegalArgumentException();
    }

    public static int getBit(int[] nArray, int n3) {
        if (n3 == 0) {
            return nArray[0] & 1;
        }
        int n4 = n3 >> 5;
        if (n4 >= 0 && n4 < 4) {
            int n5 = n3 & 0x1F;
            return nArray[n4] >>> n5 & 1;
        }
        return 0;
    }

    public static boolean gte(int[] nArray, int[] nArray2) {
        for (int i3 = 3; i3 >= 0; --i3) {
            int n3 = nArray[i3] ^ Integer.MIN_VALUE;
            int n4 = nArray2[i3] ^ Integer.MIN_VALUE;
            if (n3 < n4) {
                return false;
            }
            if (n3 <= n4) continue;
            return true;
        }
        return true;
    }

    public static boolean gte(int[] nArray, int n3, int[] nArray2, int n4) {
        for (int i3 = 3; i3 >= 0; --i3) {
            int n5 = nArray[n3 + i3] ^ Integer.MIN_VALUE;
            int n6 = nArray2[n4 + i3] ^ Integer.MIN_VALUE;
            if (n5 < n6) {
                return false;
            }
            if (n5 <= n6) continue;
            return true;
        }
        return true;
    }

    public static boolean isOne(int[] nArray) {
        if (nArray[0] != 1) {
            return false;
        }
        for (int i3 = 1; i3 < 4; ++i3) {
            if (nArray[i3] == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isOne64(long[] lArray) {
        if (lArray[0] != 1L) {
            return false;
        }
        for (int i3 = 1; i3 < 2; ++i3) {
            if (lArray[i3] == 0L) continue;
            return false;
        }
        return true;
    }

    public static boolean isZero(int[] nArray) {
        for (int i3 = 0; i3 < 4; ++i3) {
            if (nArray[i3] == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isZero64(long[] lArray) {
        for (int i3 = 0; i3 < 2; ++i3) {
            if (lArray[i3] == 0L) continue;
            return false;
        }
        return true;
    }

    public static void mul(int[] nArray, int[] nArray2, int[] nArray3) {
        long l3;
        long l4 = (long)nArray2[0] & 0xFFFFFFFFL;
        long l5 = (long)nArray2[1] & 0xFFFFFFFFL;
        long l6 = (long)nArray2[2] & 0xFFFFFFFFL;
        long l7 = (long)nArray2[3] & 0xFFFFFFFFL;
        long l8 = (long)nArray[0] & 0xFFFFFFFFL;
        long l9 = l3 = l8;
        long l10 = l3;
        l3 = l3 * l4 + 0L;
        nArray3[0] = (int)l3;
        l3 >>>= 32;
        l3 = l10 * l5 + l3;
        nArray3[1] = (int)l3;
        l3 >>>= 32;
        l3 = l9 * l6 + l3;
        nArray3[2] = (int)l3;
        l3 >>>= 32;
        l3 = l8 * l7 + l3;
        nArray3[3] = (int)l3;
        nArray3[4] = (int)(l3 >>> 32);
        int n3 = 1;
        while (n3 < 4) {
            long l11 = (long)nArray[n3] & 0xFFFFFFFFL;
            long l12 = l3 = l11;
            long l13 = l3;
            int n4 = n3 + 0;
            long l14 = l3 * l4 + ((long)nArray3[n4] & 0xFFFFFFFFL) + 0L;
            nArray3[n4] = (int)l14;
            l3 = l14 >>> 32;
            int n5 = n3 + 1;
            l3 = l13 * l5 + ((long)nArray3[n5] & 0xFFFFFFFFL) + l3;
            nArray3[n5] = (int)l3;
            l3 >>>= 32;
            int n6 = n3 + 2;
            l3 = l12 * l6 + ((long)nArray3[n6] & 0xFFFFFFFFL) + l3;
            nArray3[n6] = (int)l3;
            l3 >>>= 32;
            n6 = n3 + 3;
            l3 = l11 * l7 + ((long)nArray3[n6] & 0xFFFFFFFFL) + l3;
            nArray3[n6] = (int)l3;
            nArray3[n3 += 4] = (int)(l3 >>> 32);
            n3 = n5;
        }
    }

    public static void mul(int[] nArray, int n3, int[] nArray2, int n4, int[] nArray3, int n5) {
        long l3;
        long l4 = (long)nArray2[n4 + 0] & 0xFFFFFFFFL;
        long l5 = (long)nArray2[n4 + 1] & 0xFFFFFFFFL;
        long l6 = (long)nArray2[n4 + 2] & 0xFFFFFFFFL;
        long l7 = (long)nArray2[n4 + 3] & 0xFFFFFFFFL;
        long l8 = (long)nArray[n3 + 0] & 0xFFFFFFFFL;
        long l9 = l3 = l8;
        long l10 = l3;
        l3 = l3 * l4 + 0L;
        int n6 = n5 + 0;
        nArray3[n6] = (int)l3;
        long l11 = l3 >>> 32;
        l11 = l10 * l5 + l11;
        int n7 = n5 + 1;
        nArray3[n7] = (int)l11;
        long l12 = l11 >>> 32;
        l12 = l9 * l6 + l12;
        int n8 = n5 + 2;
        nArray3[n8] = (int)l12;
        long l13 = l12 >>> 32;
        l13 = l8 * l7 + l13;
        int n9 = n5 + 3;
        nArray3[n9] = (int)l13;
        n9 = n5 + 4;
        nArray3[n9] = (int)(l13 >>> 32);
        for (n9 = 1; n9 < 4; ++n9) {
            long l14 = (long)nArray[n3 + n9] & 0xFFFFFFFFL;
            int n10 = ++n5 + 0;
            long l15 = l14 * l4 + ((long)nArray3[n10] & 0xFFFFFFFFL) + 0L;
            nArray3[n10] = (int)l15;
            long l16 = l15 >>> 32;
            int n11 = n5 + 1;
            l16 = l14 * l5 + ((long)nArray3[n11] & 0xFFFFFFFFL) + l16;
            nArray3[n11] = (int)l16;
            l16 >>>= 32;
            n11 = n5 + 2;
            l16 = l14 * l6 + ((long)nArray3[n11] & 0xFFFFFFFFL) + l16;
            nArray3[n11] = (int)l16;
            l16 >>>= 32;
            n11 = n5 + 3;
            l16 = l14 * l7 + ((long)nArray3[n11] & 0xFFFFFFFFL) + l16;
            nArray3[n11] = (int)l16;
            int n12 = n5 + 4;
            nArray3[n12] = (int)(l16 >>> 32);
        }
    }

    public static int mulAddTo(int[] nArray, int[] nArray2, int[] nArray3) {
        long l3 = (long)nArray2[0] & 0xFFFFFFFFL;
        long l4 = (long)nArray2[1] & 0xFFFFFFFFL;
        long l5 = (long)nArray2[2] & 0xFFFFFFFFL;
        long l6 = (long)nArray2[3] & 0xFFFFFFFFL;
        long l7 = 0L;
        int n3 = 0;
        while (n3 < 4) {
            long l8;
            long l9 = (long)nArray[n3] & 0xFFFFFFFFL;
            long l10 = l8 = l9;
            long l11 = l8;
            int n4 = n3 + 0;
            long l12 = l8 * l3 + ((long)nArray3[n4] & 0xFFFFFFFFL) + 0L;
            nArray3[n4] = (int)l12;
            l8 = l12 >>> 32;
            int n5 = n3 + 1;
            l8 = l11 * l4 + ((long)nArray3[n5] & 0xFFFFFFFFL) + l8;
            nArray3[n5] = (int)l8;
            l8 >>>= 32;
            int n6 = n3 + 2;
            l8 = l10 * l5 + ((long)nArray3[n6] & 0xFFFFFFFFL) + l8;
            nArray3[n6] = (int)l8;
            l8 >>>= 32;
            n6 = n3 + 3;
            l8 = l9 * l6 + ((long)nArray3[n6] & 0xFFFFFFFFL) + l8;
            nArray3[n6] = (int)l8;
            l7 = (l8 >>> 32) + ((long)nArray3[n3 += 4] & 0xFFFFFFFFL) + l7;
            nArray3[n3] = (int)l7;
            l7 >>>= 32;
            n3 = n5;
        }
        return (int)l7;
    }

    public static int mulAddTo(int[] nArray, int n3, int[] nArray2, int n4, int[] nArray3, int n5) {
        long l3 = (long)nArray2[n4 + 0] & 0xFFFFFFFFL;
        long l4 = (long)nArray2[n4 + 1] & 0xFFFFFFFFL;
        long l5 = (long)nArray2[n4 + 2] & 0xFFFFFFFFL;
        long l6 = (long)nArray2[n4 + 3] & 0xFFFFFFFFL;
        long l7 = 0L;
        for (int i3 = 0; i3 < 4; ++i3) {
            long l8;
            long l9 = (long)nArray[n3 + i3] & 0xFFFFFFFFL;
            long l10 = l8 = l9;
            long l11 = l8;
            int n6 = n5 + 0;
            long l12 = l8 * l3 + ((long)nArray3[n6] & 0xFFFFFFFFL) + 0L;
            nArray3[n6] = (int)l12;
            l8 = l12 >>> 32;
            int n7 = n5 + 1;
            l8 = l11 * l4 + ((long)nArray3[n7] & 0xFFFFFFFFL) + l8;
            nArray3[n7] = (int)l8;
            l8 >>>= 32;
            int n8 = n5 + 2;
            l8 = l10 * l5 + ((long)nArray3[n8] & 0xFFFFFFFFL) + l8;
            nArray3[n8] = (int)l8;
            l8 >>>= 32;
            n8 = n5 + 3;
            l8 = l9 * l6 + ((long)nArray3[n8] & 0xFFFFFFFFL) + l8;
            nArray3[n8] = (int)l8;
            l7 = (l8 >>> 32) + ((long)nArray3[n5 += 4] & 0xFFFFFFFFL) + l7;
            nArray3[n5] = (int)l7;
            l7 >>>= 32;
            n5 = n7;
        }
        return (int)l7;
    }

    public static long mul33Add(int n3, int[] nArray, int n4, int[] nArray2, int n5, int[] nArray3, int n6) {
        long l3 = (long)n3 & 0xFFFFFFFFL;
        long l4 = l3;
        int n7 = n4;
        long l5 = l4;
        int n8 = n4;
        long l6 = l4;
        int n9 = n4;
        long l7 = (long)nArray[n4 + 0] & 0xFFFFFFFFL;
        l4 = l4 * l7 + ((long)nArray2[n5 + 0] & 0xFFFFFFFFL) + 0L;
        n4 = n6 + 0;
        nArray3[n4] = (int)l4;
        long l8 = (long)nArray[n9 + 1] & 0xFFFFFFFFL;
        l7 = l6 * l8 + l7 + ((long)nArray2[n5 + 1] & 0xFFFFFFFFL) + (l4 >>>= 32);
        int n10 = n6 + 1;
        nArray3[n10] = (int)l7;
        long l9 = l7 >>> 32;
        l4 = (long)nArray[n8 + 2] & 0xFFFFFFFFL;
        l9 = l5 * l4 + l8 + ((long)nArray2[n5 + 2] & 0xFFFFFFFFL) + l9;
        int n11 = n6 + 2;
        nArray3[n11] = (int)l9;
        long l10 = l9 >>> 32;
        l8 = (long)nArray[n7 + 3] & 0xFFFFFFFFL;
        l10 = l3 * l8 + l4 + ((long)nArray2[n5 + 3] & 0xFFFFFFFFL) + l10;
        int n12 = n6 + 3;
        nArray3[n12] = (int)l10;
        return (l10 >>> 32) + l8;
    }

    public static int mulWordAddExt(int n3, int[] nArray, int n4, int[] nArray2, int n5) {
        long l3 = (long)n3 & 0xFFFFFFFFL;
        int n6 = n4;
        int n7 = n4;
        n3 = n5 + 0;
        long l4 = l3 * ((long)nArray[n4 + 0] & 0xFFFFFFFFL) + ((long)nArray2[n3] & 0xFFFFFFFFL) + 0L;
        nArray2[n3] = (int)l4;
        long l5 = l4 >>> 32;
        long l6 = l3 * ((long)nArray[n4 + 1] & 0xFFFFFFFFL);
        n4 = n5 + 1;
        l5 = l6 + ((long)nArray2[n4] & 0xFFFFFFFFL) + l5;
        nArray2[n4] = (int)l5;
        l5 >>>= 32;
        n4 = n5 + 2;
        l5 = l3 * ((long)nArray[n7 + 2] & 0xFFFFFFFFL) + ((long)nArray2[n4] & 0xFFFFFFFFL) + l5;
        nArray2[n4] = (int)l5;
        l5 >>>= 32;
        n4 = n5 + 3;
        l5 = l3 * ((long)nArray[n6 + 3] & 0xFFFFFFFFL) + ((long)nArray2[n4] & 0xFFFFFFFFL) + l5;
        nArray2[n4] = (int)l5;
        return (int)(l5 >>> 32);
    }

    public static int mul33DWordAdd(int n3, long l3, int[] nArray, int n4) {
        long l4 = (long)n3 & 0xFFFFFFFFL;
        long l5 = l3 & 0xFFFFFFFFL;
        int n5 = n4 + 0;
        long l6 = l4 * l5 + ((long)nArray[n5] & 0xFFFFFFFFL) + 0L;
        nArray[n5] = (int)l6;
        long l7 = l3 >>> 32;
        int n6 = n4 + 1;
        l3 = l4 * l7 + l5 + ((long)nArray[n6] & 0xFFFFFFFFL) + (l6 >>>= 32);
        nArray[n6] = (int)l3;
        long l8 = l3 >>> 32;
        n5 = n4 + 2;
        l8 = l7 + ((long)nArray[n5] & 0xFFFFFFFFL) + l8;
        nArray[n5] = (int)l8;
        int n7 = n4 + 3;
        l3 = (l8 >>> 32) + ((long)nArray[n7] & 0xFFFFFFFFL);
        nArray[n7] = (int)l3;
        return (int)(l3 >>> 32);
    }

    public static int mul33WordAdd(int n3, int n4, int[] nArray, int n5) {
        long l3 = (long)n3 & 0xFFFFFFFFL;
        long l4 = (long)n4 & 0xFFFFFFFFL;
        long l5 = l4;
        int n6 = n5 + 0;
        l5 = l5 * l3 + ((long)nArray[n6] & 0xFFFFFFFFL) + 0L;
        nArray[n6] = (int)l5;
        long l6 = l5 >>> 32;
        int n7 = n5 + 1;
        l6 = l4 + ((long)nArray[n7] & 0xFFFFFFFFL) + l6;
        nArray[n7] = (int)l6;
        int n8 = n5 + 2;
        long l7 = (l6 >>> 32) + ((long)nArray[n8] & 0xFFFFFFFFL);
        nArray[n8] = (int)l7;
        return l7 >>> 32 == 0L ? 0 : Nat.incAt(4, nArray, n5, 3);
    }

    public static int mulWordDwordAdd(int n3, long l3, int[] nArray, int n4) {
        long l4 = (long)n3 & 0xFFFFFFFFL;
        long l5 = l3;
        n3 = n4 + 0;
        l3 = l4 * (l3 & 0xFFFFFFFFL) + ((long)nArray[n3] & 0xFFFFFFFFL) + 0L;
        nArray[n3] = (int)l3;
        long l6 = l3 >>> 32;
        int n5 = n4 + 1;
        l6 = l4 * (l5 >>> 32) + ((long)nArray[n5] & 0xFFFFFFFFL) + l6;
        nArray[n5] = (int)l6;
        int n6 = n4 + 2;
        l3 = (l6 >>> 32) + ((long)nArray[n6] & 0xFFFFFFFFL);
        nArray[n6] = (int)l3;
        return l3 >>> 32 == 0L ? 0 : Nat.incAt(4, nArray, n4, 3);
    }

    public static int mulWordsAdd(int n3, int n4, int[] nArray, int n5) {
        long l3 = (long)n3 & 0xFFFFFFFFL;
        int n6 = n5 + 0;
        long l4 = ((long)n4 & 0xFFFFFFFFL) * l3 + ((long)nArray[n6] & 0xFFFFFFFFL) + 0L;
        nArray[n6] = (int)l4;
        n6 = n5 + 1;
        l4 = (l4 >>> 32) + ((long)nArray[n6] & 0xFFFFFFFFL);
        nArray[n6] = (int)l4;
        return l4 >>> 32 == 0L ? 0 : Nat.incAt(4, nArray, n5, 2);
    }

    public static int mulWord(int n3, int[] nArray, int[] nArray2, int n4) {
        long l3 = 0L;
        long l4 = (long)n3 & 0xFFFFFFFFL;
        n3 = 0;
        do {
            l3 = l4 * ((long)nArray[n3] & 0xFFFFFFFFL) + l3;
            int n5 = n4 + n3;
            nArray2[n5] = (int)l3;
            l3 >>>= 32;
        } while (++n3 < 4);
        return (int)l3;
    }

    public static void square(int[] nArray, int[] nArray2) {
        long l3 = (long)nArray[0] & 0xFFFFFFFFL;
        int n3 = 0;
        int n4 = 3;
        int n5 = 8;
        while (true) {
            int n6 = n4 + -1;
            long l4 = (long)nArray[n4] & 0xFFFFFFFFL;
            long l5 = l4 * l4;
            int n7 = n3;
            n3 = n5 + -1;
            nArray2[n3] = n7 << 31 | (int)(l5 >>> 33);
            n5 = n3 + -1;
            nArray2[n5] = (int)(l5 >>> 1);
            n3 = (int)l5;
            if (n6 <= 0) {
                long l6 = l3;
                long l7 = l6 * l6;
                long l8 = (long)(n3 << 31) & 0xFFFFFFFFL | l7 >>> 33;
                nArray2[0] = (int)l7;
                n5 = (int)(l7 >>> 32) & 1;
                long l9 = (long)nArray[1] & 0xFFFFFFFFL;
                long l10 = l9 * l3 + l8;
                int n8 = (int)l10;
                nArray2[1] = n8 << 1 | n5;
                int n9 = n8 >>> 31;
                l7 = ((long)nArray2[2] & 0xFFFFFFFFL) + (l10 >>> 32);
                long l11 = (long)nArray[2] & 0xFFFFFFFFL;
                long l12 = (long)nArray2[3] & 0xFFFFFFFFL;
                long l13 = l11 * l3 + l7;
                int n10 = (int)l13;
                nArray2[2] = n10 << 1 | n9;
                n9 = n10 >>> 31;
                l7 = a.a(l11, l9, l13 >>> 32, l12);
                long l14 = ((long)nArray2[4] & 0xFFFFFFFFL) + (l7 >>> 32);
                l12 = l14;
                l7 &= 0xFFFFFFFFL;
                long l15 = (long)nArray[3] & 0xFFFFFFFFL;
                l12 = ((long)nArray2[5] & 0xFFFFFFFFL) + (l12 >>> 32);
                long l16 = l14 & 0xFFFFFFFFL;
                long l17 = l3;
                l3 = l12 & 0xFFFFFFFFL;
                long l18 = l15 * l17 + l7;
                int n11 = (int)l18;
                nArray2[3] = n11 << 1 | n9;
                int n12 = n11 >>> 31;
                long l19 = a.a(l15, l9, l18 >>> 32, l16);
                l3 = a.a(l15, l11, l19 >>> 32, l3);
                long l20 = ((long)nArray2[6] & 0xFFFFFFFFL) + (l12 >>> 32) + (l3 >>> 32);
                int n13 = (int)l19;
                nArray2[4] = n13 << 1 | n12;
                n12 = n13 >>> 31;
                int n14 = (int)(l3 & 0xFFFFFFFFL);
                nArray2[5] = n14 << 1 | n12;
                n12 = n14 >>> 31;
                int n15 = (int)l20;
                nArray2[6] = n15 << 1 | n12;
                n12 = n15 >>> 31;
                nArray2[7] = nArray2[7] + (int)(l20 >>> 32) << 1 | n12;
                return;
            }
            n4 = n6;
        }
    }

    public static void square(int[] nArray, int n3, int[] nArray2, int n4) {
        long l3 = (long)nArray[n3 + 0] & 0xFFFFFFFFL;
        int n5 = 0;
        int n6 = 3;
        int n7 = 8;
        while (true) {
            int n8 = n6 + -1;
            long l4 = (long)nArray[n3 + n6] & 0xFFFFFFFFL;
            long l5 = l4 * l4;
            int n9 = n5;
            n5 = n7 + -1;
            n6 = n4 + n5;
            nArray2[n6] = n9 << 31 | (int)(l5 >>> 33);
            n7 = n5 + -1;
            n5 = n4 + n7;
            nArray2[n5] = (int)(l5 >>> 1);
            n5 = (int)l5;
            if (n8 <= 0) {
                long l6 = l3;
                long l7 = l6 * l6;
                long l8 = (long)(n5 << 31) & 0xFFFFFFFFL | l7 >>> 33;
                n7 = n4 + 0;
                nArray2[n7] = (int)l7;
                n7 = (int)(l7 >>> 32) & 1;
                long l9 = (long)nArray[n3 + 1] & 0xFFFFFFFFL;
                int n10 = n4 + 2;
                long l10 = l9 * l3 + l8;
                int n11 = (int)l10;
                int n12 = n4 + 1;
                nArray2[n12] = n11 << 1 | n7;
                n12 = n11 >>> 31;
                l7 = ((long)nArray2[n10] & 0xFFFFFFFFL) + (l10 >>> 32);
                long l11 = (long)nArray[n3 + 2] & 0xFFFFFFFFL;
                int n13 = n4 + 3;
                long l12 = (long)nArray2[n13] & 0xFFFFFFFFL;
                int n14 = n4 + 4;
                long l13 = l11 * l3 + l7;
                int n15 = (int)l13;
                nArray2[n10] = n15 << 1 | n12;
                n12 = n15 >>> 31;
                long l14 = a.a(l11, l9, l13 >>> 32, l12);
                long l15 = ((long)nArray2[n14] & 0xFFFFFFFFL) + (l14 >>> 32);
                l12 = l15;
                long l16 = l14 & 0xFFFFFFFFL;
                l14 = (long)nArray[n3 + 3] & 0xFFFFFFFFL;
                n10 = n4 + 5;
                l12 = ((long)nArray2[n10] & 0xFFFFFFFFL) + (l12 >>> 32);
                long l17 = l15 & 0xFFFFFFFFL;
                int n16 = n4 + 6;
                long l18 = l3;
                l3 = l12 & 0xFFFFFFFFL;
                long l19 = l14 * l18 + l16;
                int n17 = (int)l19;
                nArray2[n13] = n17 << 1 | n12;
                long l20 = a.a(l14, l9, l19 >>> 32, l17);
                l3 = a.a(l14, l11, l20 >>> 32, l3);
                long l21 = ((long)nArray2[n16] & 0xFFFFFFFFL) + (l12 >>> 32) + (l3 >>> 32);
                n3 = (int)l20;
                nArray2[n14] = n3 << 1 | (n17 >>>= 31);
                n17 = n3 >>> 31;
                n3 = (int)l3;
                nArray2[n10] = n3 << 1 | n17;
                n17 = n3 >>> 31;
                n3 = (int)l21;
                nArray2[n16] = n3 << 1 | n17;
                n17 = n3 >>> 31;
                n3 = n4 + 7;
                nArray2[n3] = nArray2[n3] + (int)(l21 >>> 32) << 1 | n17;
                return;
            }
            n6 = n8;
        }
    }

    public static int sub(int[] nArray, int[] nArray2, int[] nArray3) {
        long l3 = ((long)nArray[0] & 0xFFFFFFFFL) - ((long)nArray2[0] & 0xFFFFFFFFL) + 0L;
        nArray3[0] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray[1] & 0xFFFFFFFFL) - ((long)nArray2[1] & 0xFFFFFFFFL) + l3;
        nArray3[1] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray[2] & 0xFFFFFFFFL) - ((long)nArray2[2] & 0xFFFFFFFFL) + l3;
        nArray3[2] = (int)l3;
        long l4 = ((long)nArray[3] & 0xFFFFFFFFL) - ((long)nArray2[3] & 0xFFFFFFFFL) + (l3 >>= 32);
        nArray3[3] = (int)l4;
        return (int)(l4 >> 32);
    }

    public static int sub(int[] nArray, int n3, int[] nArray2, int n4, int[] nArray3, int n5) {
        long l3 = ((long)nArray[n3 + 0] & 0xFFFFFFFFL) - ((long)nArray2[n4 + 0] & 0xFFFFFFFFL) + 0L;
        int n6 = n5 + 0;
        nArray3[n6] = (int)l3;
        long l4 = l3 >> 32;
        l4 = ((long)nArray[n3 + 1] & 0xFFFFFFFFL) - ((long)nArray2[n4 + 1] & 0xFFFFFFFFL) + l4;
        int n7 = n5 + 1;
        nArray3[n7] = (int)l4;
        long l5 = l4 >> 32;
        l5 = ((long)nArray[n3 + 2] & 0xFFFFFFFFL) - ((long)nArray2[n4 + 2] & 0xFFFFFFFFL) + l5;
        int n8 = n5 + 2;
        nArray3[n8] = (int)l5;
        long l6 = l5 >> 32;
        l6 = ((long)nArray[n3 + 3] & 0xFFFFFFFFL) - ((long)nArray2[n4 + 3] & 0xFFFFFFFFL) + l6;
        int n9 = n5 + 3;
        nArray3[n9] = (int)l6;
        return (int)(l6 >> 32);
    }

    public static int subBothFrom(int[] nArray, int[] nArray2, int[] nArray3) {
        long l3 = ((long)nArray3[0] & 0xFFFFFFFFL) - ((long)nArray[0] & 0xFFFFFFFFL) - ((long)nArray2[0] & 0xFFFFFFFFL) + 0L;
        nArray3[0] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray3[1] & 0xFFFFFFFFL) - ((long)nArray[1] & 0xFFFFFFFFL) - ((long)nArray2[1] & 0xFFFFFFFFL) + l3;
        nArray3[1] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray3[2] & 0xFFFFFFFFL) - ((long)nArray[2] & 0xFFFFFFFFL) - ((long)nArray2[2] & 0xFFFFFFFFL) + l3;
        nArray3[2] = (int)l3;
        long l4 = ((long)nArray3[3] & 0xFFFFFFFFL) - ((long)nArray[3] & 0xFFFFFFFFL) - ((long)nArray2[3] & 0xFFFFFFFFL) + (l3 >>= 32);
        nArray3[3] = (int)l4;
        return (int)(l4 >> 32);
    }

    public static int subFrom(int[] nArray, int[] nArray2) {
        long l3 = ((long)nArray2[0] & 0xFFFFFFFFL) - ((long)nArray[0] & 0xFFFFFFFFL) + 0L;
        nArray2[0] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray2[1] & 0xFFFFFFFFL) - ((long)nArray[1] & 0xFFFFFFFFL) + l3;
        nArray2[1] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray2[2] & 0xFFFFFFFFL) - ((long)nArray[2] & 0xFFFFFFFFL) + l3;
        nArray2[2] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray2[3] & 0xFFFFFFFFL) - ((long)nArray[3] & 0xFFFFFFFFL) + l3;
        nArray2[3] = (int)l3;
        return (int)(l3 >> 32);
    }

    public static int subFrom(int[] nArray, int n3, int[] nArray2, int n4) {
        int n5 = n4 + 0;
        long l3 = ((long)nArray2[n5] & 0xFFFFFFFFL) - ((long)nArray[n3 + 0] & 0xFFFFFFFFL) + 0L;
        nArray2[n5] = (int)l3;
        long l4 = l3 >> 32;
        int n6 = n4 + 1;
        l4 = ((long)nArray2[n6] & 0xFFFFFFFFL) - ((long)nArray[n3 + 1] & 0xFFFFFFFFL) + l4;
        nArray2[n6] = (int)l4;
        l4 >>= 32;
        n6 = n4 + 2;
        l4 = ((long)nArray2[n6] & 0xFFFFFFFFL) - ((long)nArray[n3 + 2] & 0xFFFFFFFFL) + l4;
        nArray2[n6] = (int)l4;
        long l5 = ((long)nArray2[n4 += 3] & 0xFFFFFFFFL) - ((long)nArray[n3 + 3] & 0xFFFFFFFFL) + (l4 >>= 32);
        nArray2[n4] = (int)l5;
        return (int)(l5 >> 32);
    }

    public static BigInteger toBigInteger(int[] nArray) {
        byte[] byArray = new byte[16];
        for (int i3 = 0; i3 < 4; ++i3) {
            int n3 = nArray[i3];
            if (n3 == 0) continue;
            Pack.intToBigEndian(n3, byArray, 3 - i3 << 2);
        }
        return new BigInteger(1, byArray);
    }

    public static BigInteger toBigInteger64(long[] lArray) {
        byte[] byArray = new byte[16];
        for (int i3 = 0; i3 < 2; ++i3) {
            long l3 = lArray[i3];
            if (l3 == 0L) continue;
            Pack.longToBigEndian(l3, byArray, 1 - i3 << 3);
        }
        return new BigInteger(1, byArray);
    }

    public static void zero(int[] nArray) {
        int[] nArray2 = nArray;
        int[] nArray3 = nArray;
        nArray2[0] = 0;
        nArray3[1] = 0;
        nArray2[2] = 0;
        nArray3[3] = 0;
    }
}

