/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.raw;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;
import java.math.BigInteger;

public abstract class Nat224 {
    private static final long M = 0xFFFFFFFFL;

    public static int add(int[] nArray, int[] nArray2, int[] nArray3) {
        long l3 = ((long)nArray[0] & 0xFFFFFFFFL) + ((long)nArray2[0] & 0xFFFFFFFFL) + 0L;
        nArray3[0] = (int)l3;
        l3 >>>= 32;
        l3 = ((long)nArray[1] & 0xFFFFFFFFL) + ((long)nArray2[1] & 0xFFFFFFFFL) + l3;
        nArray3[1] = (int)l3;
        l3 >>>= 32;
        l3 = ((long)nArray[2] & 0xFFFFFFFFL) + ((long)nArray2[2] & 0xFFFFFFFFL) + l3;
        nArray3[2] = (int)l3;
        l3 >>>= 32;
        l3 = ((long)nArray[3] & 0xFFFFFFFFL) + ((long)nArray2[3] & 0xFFFFFFFFL) + l3;
        nArray3[3] = (int)l3;
        l3 >>>= 32;
        l3 = ((long)nArray[4] & 0xFFFFFFFFL) + ((long)nArray2[4] & 0xFFFFFFFFL) + l3;
        nArray3[4] = (int)l3;
        l3 >>>= 32;
        l3 = ((long)nArray[5] & 0xFFFFFFFFL) + ((long)nArray2[5] & 0xFFFFFFFFL) + l3;
        nArray3[5] = (int)l3;
        long l4 = ((long)nArray[6] & 0xFFFFFFFFL) + ((long)nArray2[6] & 0xFFFFFFFFL) + (l3 >>>= 32);
        nArray3[6] = (int)l4;
        return (int)(l4 >>> 32);
    }

    public static int add(int[] nArray, int n3, int[] nArray2, int n4, int[] nArray3, int n5) {
        long l3 = ((long)nArray[n3 + 0] & 0xFFFFFFFFL) + ((long)nArray2[n4 + 0] & 0xFFFFFFFFL) + 0L;
        int n6 = n5 + 0;
        nArray3[n6] = (int)l3;
        long l4 = l3 >>> 32;
        l4 = ((long)nArray[n3 + 1] & 0xFFFFFFFFL) + ((long)nArray2[n4 + 1] & 0xFFFFFFFFL) + l4;
        int n7 = n5 + 1;
        nArray3[n7] = (int)l4;
        long l5 = l4 >>> 32;
        l5 = ((long)nArray[n3 + 2] & 0xFFFFFFFFL) + ((long)nArray2[n4 + 2] & 0xFFFFFFFFL) + l5;
        int n8 = n5 + 2;
        nArray3[n8] = (int)l5;
        long l6 = l5 >>> 32;
        l6 = ((long)nArray[n3 + 3] & 0xFFFFFFFFL) + ((long)nArray2[n4 + 3] & 0xFFFFFFFFL) + l6;
        int n9 = n5 + 3;
        nArray3[n9] = (int)l6;
        long l7 = l6 >>> 32;
        l7 = ((long)nArray[n3 + 4] & 0xFFFFFFFFL) + ((long)nArray2[n4 + 4] & 0xFFFFFFFFL) + l7;
        int n10 = n5 + 4;
        nArray3[n10] = (int)l7;
        long l8 = l7 >>> 32;
        l8 = ((long)nArray[n3 + 5] & 0xFFFFFFFFL) + ((long)nArray2[n4 + 5] & 0xFFFFFFFFL) + l8;
        int n11 = n5 + 5;
        nArray3[n11] = (int)l8;
        long l9 = l8 >>> 32;
        l9 = ((long)nArray[n3 + 6] & 0xFFFFFFFFL) + ((long)nArray2[n4 + 6] & 0xFFFFFFFFL) + l9;
        int n12 = n5 + 6;
        nArray3[n12] = (int)l9;
        return (int)(l9 >>> 32);
    }

    public static int addBothTo(int[] nArray, int[] nArray2, int[] nArray3) {
        long l3 = ((long)nArray[0] & 0xFFFFFFFFL) + ((long)nArray2[0] & 0xFFFFFFFFL) + ((long)nArray3[0] & 0xFFFFFFFFL) + 0L;
        nArray3[0] = (int)l3;
        l3 >>>= 32;
        l3 = ((long)nArray[1] & 0xFFFFFFFFL) + ((long)nArray2[1] & 0xFFFFFFFFL) + ((long)nArray3[1] & 0xFFFFFFFFL) + l3;
        nArray3[1] = (int)l3;
        l3 >>>= 32;
        l3 = ((long)nArray[2] & 0xFFFFFFFFL) + ((long)nArray2[2] & 0xFFFFFFFFL) + ((long)nArray3[2] & 0xFFFFFFFFL) + l3;
        nArray3[2] = (int)l3;
        l3 >>>= 32;
        l3 = ((long)nArray[3] & 0xFFFFFFFFL) + ((long)nArray2[3] & 0xFFFFFFFFL) + ((long)nArray3[3] & 0xFFFFFFFFL) + l3;
        nArray3[3] = (int)l3;
        l3 >>>= 32;
        l3 = ((long)nArray[4] & 0xFFFFFFFFL) + ((long)nArray2[4] & 0xFFFFFFFFL) + ((long)nArray3[4] & 0xFFFFFFFFL) + l3;
        nArray3[4] = (int)l3;
        l3 >>>= 32;
        l3 = ((long)nArray[5] & 0xFFFFFFFFL) + ((long)nArray2[5] & 0xFFFFFFFFL) + ((long)nArray3[5] & 0xFFFFFFFFL) + l3;
        nArray3[5] = (int)l3;
        long l4 = ((long)nArray[6] & 0xFFFFFFFFL) + ((long)nArray2[6] & 0xFFFFFFFFL) + ((long)nArray3[6] & 0xFFFFFFFFL) + (l3 >>>= 32);
        nArray3[6] = (int)l4;
        return (int)(l4 >>> 32);
    }

    public static int addBothTo(int[] nArray, int n3, int[] nArray2, int n4, int[] nArray3, int n5) {
        int n6 = n5 + 0;
        long l3 = ((long)nArray[n3 + 0] & 0xFFFFFFFFL) + ((long)nArray2[n4 + 0] & 0xFFFFFFFFL) + ((long)nArray3[n6] & 0xFFFFFFFFL) + 0L;
        nArray3[n6] = (int)l3;
        long l4 = l3 >>> 32;
        int n7 = n5 + 1;
        l4 = ((long)nArray[n3 + 1] & 0xFFFFFFFFL) + ((long)nArray2[n4 + 1] & 0xFFFFFFFFL) + ((long)nArray3[n7] & 0xFFFFFFFFL) + l4;
        nArray3[n7] = (int)l4;
        l4 >>>= 32;
        n7 = n5 + 2;
        l4 = ((long)nArray[n3 + 2] & 0xFFFFFFFFL) + ((long)nArray2[n4 + 2] & 0xFFFFFFFFL) + ((long)nArray3[n7] & 0xFFFFFFFFL) + l4;
        nArray3[n7] = (int)l4;
        l4 >>>= 32;
        n7 = n5 + 3;
        l4 = ((long)nArray[n3 + 3] & 0xFFFFFFFFL) + ((long)nArray2[n4 + 3] & 0xFFFFFFFFL) + ((long)nArray3[n7] & 0xFFFFFFFFL) + l4;
        nArray3[n7] = (int)l4;
        l4 >>>= 32;
        n7 = n5 + 4;
        l4 = ((long)nArray[n3 + 4] & 0xFFFFFFFFL) + ((long)nArray2[n4 + 4] & 0xFFFFFFFFL) + ((long)nArray3[n7] & 0xFFFFFFFFL) + l4;
        nArray3[n7] = (int)l4;
        l4 >>>= 32;
        n7 = n5 + 5;
        l4 = ((long)nArray[n3 + 5] & 0xFFFFFFFFL) + ((long)nArray2[n4 + 5] & 0xFFFFFFFFL) + ((long)nArray3[n7] & 0xFFFFFFFFL) + l4;
        nArray3[n7] = (int)l4;
        l4 >>>= 32;
        int n8 = n5 + 6;
        l4 = ((long)nArray[n3 + 6] & 0xFFFFFFFFL) + ((long)nArray2[n4 + 6] & 0xFFFFFFFFL) + ((long)nArray3[n8] & 0xFFFFFFFFL) + l4;
        nArray3[n8] = (int)l4;
        return (int)(l4 >>> 32);
    }

    public static int addTo(int[] nArray, int[] nArray2) {
        long l3 = ((long)nArray[0] & 0xFFFFFFFFL) + ((long)nArray2[0] & 0xFFFFFFFFL) + 0L;
        nArray2[0] = (int)l3;
        l3 >>>= 32;
        l3 = ((long)nArray[1] & 0xFFFFFFFFL) + ((long)nArray2[1] & 0xFFFFFFFFL) + l3;
        nArray2[1] = (int)l3;
        l3 >>>= 32;
        l3 = ((long)nArray[2] & 0xFFFFFFFFL) + ((long)nArray2[2] & 0xFFFFFFFFL) + l3;
        nArray2[2] = (int)l3;
        l3 >>>= 32;
        l3 = ((long)nArray[3] & 0xFFFFFFFFL) + ((long)nArray2[3] & 0xFFFFFFFFL) + l3;
        nArray2[3] = (int)l3;
        l3 >>>= 32;
        l3 = ((long)nArray[4] & 0xFFFFFFFFL) + ((long)nArray2[4] & 0xFFFFFFFFL) + l3;
        nArray2[4] = (int)l3;
        l3 >>>= 32;
        l3 = ((long)nArray[5] & 0xFFFFFFFFL) + ((long)nArray2[5] & 0xFFFFFFFFL) + l3;
        nArray2[5] = (int)l3;
        l3 >>>= 32;
        l3 = ((long)nArray[6] & 0xFFFFFFFFL) + ((long)nArray2[6] & 0xFFFFFFFFL) + l3;
        nArray2[6] = (int)l3;
        return (int)(l3 >>> 32);
    }

    public static int addTo(int[] nArray, int n3, int[] nArray2, int n4, int n5) {
        long l3 = (long)n5 & 0xFFFFFFFFL;
        n5 = n4 + 0;
        l3 = ((long)nArray[n3 + 0] & 0xFFFFFFFFL) + ((long)nArray2[n5] & 0xFFFFFFFFL) + l3;
        nArray2[n5] = (int)l3;
        l3 >>>= 32;
        n5 = n4 + 1;
        l3 = ((long)nArray[n3 + 1] & 0xFFFFFFFFL) + ((long)nArray2[n5] & 0xFFFFFFFFL) + l3;
        nArray2[n5] = (int)l3;
        l3 >>>= 32;
        n5 = n4 + 2;
        l3 = ((long)nArray[n3 + 2] & 0xFFFFFFFFL) + ((long)nArray2[n5] & 0xFFFFFFFFL) + l3;
        nArray2[n5] = (int)l3;
        l3 >>>= 32;
        n5 = n4 + 3;
        l3 = ((long)nArray[n3 + 3] & 0xFFFFFFFFL) + ((long)nArray2[n5] & 0xFFFFFFFFL) + l3;
        nArray2[n5] = (int)l3;
        l3 >>>= 32;
        n5 = n4 + 4;
        l3 = ((long)nArray[n3 + 4] & 0xFFFFFFFFL) + ((long)nArray2[n5] & 0xFFFFFFFFL) + l3;
        nArray2[n5] = (int)l3;
        l3 >>>= 32;
        n5 = n4 + 5;
        l3 = ((long)nArray[n3 + 5] & 0xFFFFFFFFL) + ((long)nArray2[n5] & 0xFFFFFFFFL) + l3;
        nArray2[n5] = (int)l3;
        l3 >>>= 32;
        l3 = ((long)nArray[n3 + 6] & 0xFFFFFFFFL) + ((long)nArray2[n4 += 6] & 0xFFFFFFFFL) + l3;
        nArray2[n4] = (int)l3;
        return (int)(l3 >>> 32);
    }

    public static int addToEachOther(int[] nArray, int n3, int[] nArray2, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11 = n3 + 0;
        int n12 = n4 + 0;
        long l3 = ((long)nArray[n11] & 0xFFFFFFFFL) + ((long)nArray2[n12] & 0xFFFFFFFFL) + 0L;
        nArray[n11] = n11 = (int)l3;
        nArray2[n12] = n11;
        long l4 = l3 >>> 32;
        int n13 = n3 + 1;
        int n14 = n4 + 1;
        l4 = ((long)nArray[n13] & 0xFFFFFFFFL) + ((long)nArray2[n14] & 0xFFFFFFFFL) + l4;
        nArray[n13] = n10 = (int)l4;
        nArray2[n14] = n10;
        long l5 = l4 >>> 32;
        n13 = n3 + 2;
        n14 = n4 + 2;
        l5 = ((long)nArray[n13] & 0xFFFFFFFFL) + ((long)nArray2[n14] & 0xFFFFFFFFL) + l5;
        nArray[n13] = n9 = (int)l5;
        nArray2[n14] = n9;
        long l6 = l5 >>> 32;
        n13 = n3 + 3;
        n14 = n4 + 3;
        l6 = ((long)nArray[n13] & 0xFFFFFFFFL) + ((long)nArray2[n14] & 0xFFFFFFFFL) + l6;
        nArray[n13] = n8 = (int)l6;
        nArray2[n14] = n8;
        long l7 = l6 >>> 32;
        n13 = n3 + 4;
        n14 = n4 + 4;
        l7 = ((long)nArray[n13] & 0xFFFFFFFFL) + ((long)nArray2[n14] & 0xFFFFFFFFL) + l7;
        nArray[n13] = n7 = (int)l7;
        nArray2[n14] = n7;
        long l8 = l7 >>> 32;
        n13 = n3 + 5;
        n14 = n4 + 5;
        l8 = ((long)nArray[n13] & 0xFFFFFFFFL) + ((long)nArray2[n14] & 0xFFFFFFFFL) + l8;
        nArray[n13] = n6 = (int)l8;
        nArray2[n14] = n6;
        long l9 = l8 >>> 32;
        l9 = ((long)nArray[n3 += 6] & 0xFFFFFFFFL) + ((long)nArray2[n4 += 6] & 0xFFFFFFFFL) + l9;
        nArray[n3] = n5 = (int)l9;
        nArray2[n4] = n5;
        return (int)(l9 >>> 32);
    }

    public static void copy(int[] nArray, int[] nArray2) {
        nArray2[0] = nArray[0];
        nArray2[1] = nArray[1];
        nArray2[2] = nArray[2];
        nArray2[3] = nArray[3];
        nArray2[4] = nArray[4];
        nArray2[5] = nArray[5];
        nArray2[6] = nArray[6];
    }

    public static void copy(int[] nArray, int n3, int[] nArray2, int n4) {
        int n5 = n4 + 0;
        nArray2[n5] = nArray[n3 + 0];
        n5 = n4 + 1;
        nArray2[n5] = nArray[n3 + 1];
        n5 = n4 + 2;
        nArray2[n5] = nArray[n3 + 2];
        n5 = n4 + 3;
        nArray2[n5] = nArray[n3 + 3];
        n5 = n4 + 4;
        nArray2[n5] = nArray[n3 + 4];
        n5 = n4 + 5;
        nArray2[n5] = nArray[n3 + 5];
        n5 = n4 + 6;
        nArray2[n5] = nArray[n3 + 6];
    }

    public static int[] create() {
        return new int[7];
    }

    public static int[] createExt() {
        return new int[14];
    }

    public static boolean diff(int[] nArray, int n3, int[] nArray2, int n4, int[] nArray3, int n5) {
        boolean bl = Nat224.gte(nArray, n3, nArray2, n4);
        if (bl) {
            Nat224.sub(nArray, n3, nArray2, n4, nArray3, n5);
        } else {
            Nat224.sub(nArray2, n4, nArray, n3, nArray3, n5);
        }
        return bl;
    }

    public static boolean eq(int[] nArray, int[] nArray2) {
        for (int i3 = 6; i3 >= 0; --i3) {
            if (nArray[i3] == nArray2[i3]) continue;
            return false;
        }
        return true;
    }

    public static int[] fromBigInteger(BigInteger bigInteger) {
        if (bigInteger.signum() >= 0 && bigInteger.bitLength() <= 224) {
            int[] nArray = Nat224.create();
            for (int i3 = 0; i3 < 7; ++i3) {
                nArray[i3] = bigInteger.intValue();
                bigInteger = bigInteger.shiftRight(32);
            }
            return nArray;
        }
        throw new IllegalArgumentException();
    }

    public static int getBit(int[] nArray, int n3) {
        if (n3 == 0) {
            return nArray[0] & 1;
        }
        int n4 = n3 >> 5;
        if (n4 >= 0 && n4 < 7) {
            int n5 = n3 & 0x1F;
            return nArray[n4] >>> n5 & 1;
        }
        return 0;
    }

    public static boolean gte(int[] nArray, int[] nArray2) {
        for (int i3 = 6; i3 >= 0; --i3) {
            int n3 = nArray[i3] ^ Integer.MIN_VALUE;
            int n4 = nArray2[i3] ^ Integer.MIN_VALUE;
            if (n3 < n4) {
                return false;
            }
            if (n3 <= n4) continue;
            return true;
        }
        return true;
    }

    public static boolean gte(int[] nArray, int n3, int[] nArray2, int n4) {
        for (int i3 = 6; i3 >= 0; --i3) {
            int n5 = nArray[n3 + i3] ^ Integer.MIN_VALUE;
            int n6 = nArray2[n4 + i3] ^ Integer.MIN_VALUE;
            if (n5 < n6) {
                return false;
            }
            if (n5 <= n6) continue;
            return true;
        }
        return true;
    }

    public static boolean isOne(int[] nArray) {
        if (nArray[0] != 1) {
            return false;
        }
        for (int i3 = 1; i3 < 7; ++i3) {
            if (nArray[i3] == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isZero(int[] nArray) {
        for (int i3 = 0; i3 < 7; ++i3) {
            if (nArray[i3] == 0) continue;
            return false;
        }
        return true;
    }

    public static void mul(int[] nArray, int[] nArray2, int[] nArray3) {
        long l3;
        long l4 = (long)nArray2[0] & 0xFFFFFFFFL;
        long l5 = (long)nArray2[1] & 0xFFFFFFFFL;
        long l6 = (long)nArray2[2] & 0xFFFFFFFFL;
        long l7 = (long)nArray2[3] & 0xFFFFFFFFL;
        long l8 = (long)nArray2[4] & 0xFFFFFFFFL;
        long l9 = (long)nArray2[5] & 0xFFFFFFFFL;
        long l10 = (long)nArray2[6] & 0xFFFFFFFFL;
        long l11 = (long)nArray[0] & 0xFFFFFFFFL;
        long l12 = l3 = l11;
        long l13 = l3;
        long l14 = l3;
        long l15 = l3;
        long l16 = l3;
        l3 = l3 * l4 + 0L;
        nArray3[0] = (int)l3;
        l3 >>>= 32;
        l3 = l16 * l5 + l3;
        nArray3[1] = (int)l3;
        l3 >>>= 32;
        l3 = l15 * l6 + l3;
        nArray3[2] = (int)l3;
        l3 >>>= 32;
        l3 = l14 * l7 + l3;
        nArray3[3] = (int)l3;
        l3 >>>= 32;
        l3 = l13 * l8 + l3;
        nArray3[4] = (int)l3;
        l3 >>>= 32;
        l3 = l12 * l9 + l3;
        nArray3[5] = (int)l3;
        l3 >>>= 32;
        l3 = l11 * l10 + l3;
        nArray3[6] = (int)l3;
        nArray3[7] = (int)(l3 >>> 32);
        int n3 = 1;
        while (n3 < 7) {
            long l17 = (long)nArray[n3] & 0xFFFFFFFFL;
            long l18 = l3 = l17;
            long l19 = l3;
            long l20 = l3;
            long l21 = l3;
            long l22 = l3;
            int n4 = n3 + 0;
            long l23 = l3 * l4 + ((long)nArray3[n4] & 0xFFFFFFFFL) + 0L;
            nArray3[n4] = (int)l23;
            l3 = l23 >>> 32;
            int n5 = n3 + 1;
            l3 = l22 * l5 + ((long)nArray3[n5] & 0xFFFFFFFFL) + l3;
            nArray3[n5] = (int)l3;
            l3 >>>= 32;
            int n6 = n3 + 2;
            l3 = l21 * l6 + ((long)nArray3[n6] & 0xFFFFFFFFL) + l3;
            nArray3[n6] = (int)l3;
            l3 >>>= 32;
            n6 = n3 + 3;
            l3 = l20 * l7 + ((long)nArray3[n6] & 0xFFFFFFFFL) + l3;
            nArray3[n6] = (int)l3;
            l3 >>>= 32;
            n6 = n3 + 4;
            l3 = l19 * l8 + ((long)nArray3[n6] & 0xFFFFFFFFL) + l3;
            nArray3[n6] = (int)l3;
            l3 >>>= 32;
            n6 = n3 + 5;
            l3 = l18 * l9 + ((long)nArray3[n6] & 0xFFFFFFFFL) + l3;
            nArray3[n6] = (int)l3;
            l3 >>>= 32;
            n6 = n3 + 6;
            l3 = l17 * l10 + ((long)nArray3[n6] & 0xFFFFFFFFL) + l3;
            nArray3[n6] = (int)l3;
            nArray3[n3 += 7] = (int)(l3 >>> 32);
            n3 = n5;
        }
    }

    public static void mul(int[] nArray, int n3, int[] nArray2, int n4, int[] nArray3, int n5) {
        long l3;
        long l4 = (long)nArray2[n4 + 0] & 0xFFFFFFFFL;
        long l5 = (long)nArray2[n4 + 1] & 0xFFFFFFFFL;
        long l6 = (long)nArray2[n4 + 2] & 0xFFFFFFFFL;
        long l7 = (long)nArray2[n4 + 3] & 0xFFFFFFFFL;
        long l8 = (long)nArray2[n4 + 4] & 0xFFFFFFFFL;
        long l9 = (long)nArray2[n4 + 5] & 0xFFFFFFFFL;
        long l10 = (long)nArray2[n4 + 6] & 0xFFFFFFFFL;
        long l11 = (long)nArray[n3 + 0] & 0xFFFFFFFFL;
        long l12 = l3 = l11;
        long l13 = l3;
        long l14 = l3;
        long l15 = l3;
        long l16 = l3;
        l3 = l3 * l4 + 0L;
        int n6 = n5 + 0;
        nArray3[n6] = (int)l3;
        long l17 = l3 >>> 32;
        l17 = l16 * l5 + l17;
        int n7 = n5 + 1;
        nArray3[n7] = (int)l17;
        long l18 = l17 >>> 32;
        l18 = l15 * l6 + l18;
        int n8 = n5 + 2;
        nArray3[n8] = (int)l18;
        long l19 = l18 >>> 32;
        l19 = l14 * l7 + l19;
        int n9 = n5 + 3;
        nArray3[n9] = (int)l19;
        long l20 = l19 >>> 32;
        l20 = l13 * l8 + l20;
        int n10 = n5 + 4;
        nArray3[n10] = (int)l20;
        long l21 = l20 >>> 32;
        l21 = l12 * l9 + l21;
        int n11 = n5 + 5;
        nArray3[n11] = (int)l21;
        long l22 = l21 >>> 32;
        l22 = l11 * l10 + l22;
        int n12 = n5 + 6;
        nArray3[n12] = (int)l22;
        n12 = n5 + 7;
        nArray3[n12] = (int)(l22 >>> 32);
        for (n12 = 1; n12 < 7; ++n12) {
            long l23 = (long)nArray[n3 + n12] & 0xFFFFFFFFL;
            int n13 = ++n5 + 0;
            long l24 = l23 * l4 + ((long)nArray3[n13] & 0xFFFFFFFFL) + 0L;
            nArray3[n13] = (int)l24;
            long l25 = l24 >>> 32;
            int n14 = n5 + 1;
            l25 = l23 * l5 + ((long)nArray3[n14] & 0xFFFFFFFFL) + l25;
            nArray3[n14] = (int)l25;
            l25 >>>= 32;
            n14 = n5 + 2;
            l25 = l23 * l6 + ((long)nArray3[n14] & 0xFFFFFFFFL) + l25;
            nArray3[n14] = (int)l25;
            l25 >>>= 32;
            n14 = n5 + 3;
            l25 = l23 * l7 + ((long)nArray3[n14] & 0xFFFFFFFFL) + l25;
            nArray3[n14] = (int)l25;
            l25 >>>= 32;
            n14 = n5 + 4;
            l25 = l23 * l8 + ((long)nArray3[n14] & 0xFFFFFFFFL) + l25;
            nArray3[n14] = (int)l25;
            l25 >>>= 32;
            n14 = n5 + 5;
            l25 = l23 * l9 + ((long)nArray3[n14] & 0xFFFFFFFFL) + l25;
            nArray3[n14] = (int)l25;
            l25 >>>= 32;
            n14 = n5 + 6;
            l25 = l23 * l10 + ((long)nArray3[n14] & 0xFFFFFFFFL) + l25;
            nArray3[n14] = (int)l25;
            int n15 = n5 + 7;
            nArray3[n15] = (int)(l25 >>> 32);
        }
    }

    public static int mulAddTo(int[] nArray, int[] nArray2, int[] nArray3) {
        long l3 = (long)nArray2[0] & 0xFFFFFFFFL;
        long l4 = (long)nArray2[1] & 0xFFFFFFFFL;
        long l5 = (long)nArray2[2] & 0xFFFFFFFFL;
        long l6 = (long)nArray2[3] & 0xFFFFFFFFL;
        long l7 = (long)nArray2[4] & 0xFFFFFFFFL;
        long l8 = (long)nArray2[5] & 0xFFFFFFFFL;
        long l9 = (long)nArray2[6] & 0xFFFFFFFFL;
        long l10 = 0L;
        int n3 = 0;
        while (n3 < 7) {
            long l11;
            long l12 = (long)nArray[n3] & 0xFFFFFFFFL;
            long l13 = l11 = l12;
            long l14 = l11;
            long l15 = l11;
            long l16 = l11;
            long l17 = l11;
            int n4 = n3 + 0;
            long l18 = l11 * l3 + ((long)nArray3[n4] & 0xFFFFFFFFL) + 0L;
            nArray3[n4] = (int)l18;
            l11 = l18 >>> 32;
            int n5 = n3 + 1;
            l11 = l17 * l4 + ((long)nArray3[n5] & 0xFFFFFFFFL) + l11;
            nArray3[n5] = (int)l11;
            l11 >>>= 32;
            int n6 = n3 + 2;
            l11 = l16 * l5 + ((long)nArray3[n6] & 0xFFFFFFFFL) + l11;
            nArray3[n6] = (int)l11;
            l11 >>>= 32;
            n6 = n3 + 3;
            l11 = l15 * l6 + ((long)nArray3[n6] & 0xFFFFFFFFL) + l11;
            nArray3[n6] = (int)l11;
            l11 >>>= 32;
            n6 = n3 + 4;
            l11 = l14 * l7 + ((long)nArray3[n6] & 0xFFFFFFFFL) + l11;
            nArray3[n6] = (int)l11;
            l11 >>>= 32;
            n6 = n3 + 5;
            l11 = l13 * l8 + ((long)nArray3[n6] & 0xFFFFFFFFL) + l11;
            nArray3[n6] = (int)l11;
            l11 >>>= 32;
            n6 = n3 + 6;
            l11 = l12 * l9 + ((long)nArray3[n6] & 0xFFFFFFFFL) + l11;
            nArray3[n6] = (int)l11;
            l10 = (l11 >>> 32) + ((long)nArray3[n3 += 7] & 0xFFFFFFFFL) + l10;
            nArray3[n3] = (int)l10;
            l10 >>>= 32;
            n3 = n5;
        }
        return (int)l10;
    }

    public static int mulAddTo(int[] nArray, int n3, int[] nArray2, int n4, int[] nArray3, int n5) {
        long l3 = (long)nArray2[n4 + 0] & 0xFFFFFFFFL;
        long l4 = (long)nArray2[n4 + 1] & 0xFFFFFFFFL;
        long l5 = (long)nArray2[n4 + 2] & 0xFFFFFFFFL;
        long l6 = (long)nArray2[n4 + 3] & 0xFFFFFFFFL;
        long l7 = (long)nArray2[n4 + 4] & 0xFFFFFFFFL;
        long l8 = (long)nArray2[n4 + 5] & 0xFFFFFFFFL;
        long l9 = (long)nArray2[n4 + 6] & 0xFFFFFFFFL;
        long l10 = 0L;
        for (int i3 = 0; i3 < 7; ++i3) {
            long l11;
            long l12 = (long)nArray[n3 + i3] & 0xFFFFFFFFL;
            long l13 = l11 = l12;
            long l14 = l11;
            long l15 = l11;
            long l16 = l11;
            long l17 = l11;
            int n6 = n5 + 0;
            long l18 = l11 * l3 + ((long)nArray3[n6] & 0xFFFFFFFFL) + 0L;
            nArray3[n6] = (int)l18;
            l11 = l18 >>> 32;
            int n7 = n5 + 1;
            l11 = l17 * l4 + ((long)nArray3[n7] & 0xFFFFFFFFL) + l11;
            nArray3[n7] = (int)l11;
            l11 >>>= 32;
            int n8 = n5 + 2;
            l11 = l16 * l5 + ((long)nArray3[n8] & 0xFFFFFFFFL) + l11;
            nArray3[n8] = (int)l11;
            l11 >>>= 32;
            n8 = n5 + 3;
            l11 = l15 * l6 + ((long)nArray3[n8] & 0xFFFFFFFFL) + l11;
            nArray3[n8] = (int)l11;
            l11 >>>= 32;
            n8 = n5 + 4;
            l11 = l14 * l7 + ((long)nArray3[n8] & 0xFFFFFFFFL) + l11;
            nArray3[n8] = (int)l11;
            l11 >>>= 32;
            n8 = n5 + 5;
            l11 = l13 * l8 + ((long)nArray3[n8] & 0xFFFFFFFFL) + l11;
            nArray3[n8] = (int)l11;
            l11 >>>= 32;
            n8 = n5 + 6;
            l11 = l12 * l9 + ((long)nArray3[n8] & 0xFFFFFFFFL) + l11;
            nArray3[n8] = (int)l11;
            l10 = (l11 >>> 32) + ((long)nArray3[n5 += 7] & 0xFFFFFFFFL) + l10;
            nArray3[n5] = (int)l10;
            l10 >>>= 32;
            n5 = n7;
        }
        return (int)l10;
    }

    public static long mul33Add(int n3, int[] nArray, int n4, int[] nArray2, int n5, int[] nArray3, int n6) {
        long l3 = (long)n3 & 0xFFFFFFFFL;
        long l4 = l3;
        int n7 = n4;
        long l5 = l4;
        int n8 = n4;
        long l6 = l4;
        int n9 = n4;
        long l7 = l4;
        int n10 = n4;
        long l8 = l4;
        int n11 = n4;
        long l9 = l4;
        int n12 = n4;
        long l10 = (long)nArray[n4 + 0] & 0xFFFFFFFFL;
        l4 = l4 * l10 + ((long)nArray2[n5 + 0] & 0xFFFFFFFFL) + 0L;
        n4 = n6 + 0;
        nArray3[n4] = (int)l4;
        long l11 = (long)nArray[n12 + 1] & 0xFFFFFFFFL;
        l10 = l9 * l11 + l10 + ((long)nArray2[n5 + 1] & 0xFFFFFFFFL) + (l4 >>>= 32);
        int n13 = n6 + 1;
        nArray3[n13] = (int)l10;
        long l12 = l10 >>> 32;
        l4 = (long)nArray[n11 + 2] & 0xFFFFFFFFL;
        l12 = l8 * l4 + l11 + ((long)nArray2[n5 + 2] & 0xFFFFFFFFL) + l12;
        int n14 = n6 + 2;
        nArray3[n14] = (int)l12;
        long l13 = l12 >>> 32;
        l11 = (long)nArray[n10 + 3] & 0xFFFFFFFFL;
        l13 = l7 * l11 + l4 + ((long)nArray2[n5 + 3] & 0xFFFFFFFFL) + l13;
        int n15 = n6 + 3;
        nArray3[n15] = (int)l13;
        long l14 = l13 >>> 32;
        l4 = (long)nArray[n9 + 4] & 0xFFFFFFFFL;
        l14 = l6 * l4 + l11 + ((long)nArray2[n5 + 4] & 0xFFFFFFFFL) + l14;
        int n16 = n6 + 4;
        nArray3[n16] = (int)l14;
        long l15 = l14 >>> 32;
        l11 = (long)nArray[n8 + 5] & 0xFFFFFFFFL;
        l15 = l5 * l11 + l4 + ((long)nArray2[n5 + 5] & 0xFFFFFFFFL) + l15;
        int n17 = n6 + 5;
        nArray3[n17] = (int)l15;
        long l16 = l15 >>> 32;
        l4 = (long)nArray[n7 + 6] & 0xFFFFFFFFL;
        l16 = l3 * l4 + l11 + ((long)nArray2[n5 + 6] & 0xFFFFFFFFL) + l16;
        int n18 = n6 + 6;
        nArray3[n18] = (int)l16;
        return (l16 >>> 32) + l4;
    }

    public static int mulByWord(int n3, int[] nArray) {
        long l3;
        long l4 = (long)n3 & 0xFFFFFFFFL;
        long l5 = l3 = l4;
        long l6 = l3;
        long l7 = l3;
        long l8 = l3;
        long l9 = l3;
        l3 = l3 * ((long)nArray[0] & 0xFFFFFFFFL) + 0L;
        nArray[0] = (int)l3;
        l3 >>>= 32;
        l3 = l9 * ((long)nArray[1] & 0xFFFFFFFFL) + l3;
        nArray[1] = (int)l3;
        l3 >>>= 32;
        l3 = l8 * ((long)nArray[2] & 0xFFFFFFFFL) + l3;
        nArray[2] = (int)l3;
        l3 >>>= 32;
        l3 = l7 * ((long)nArray[3] & 0xFFFFFFFFL) + l3;
        nArray[3] = (int)l3;
        l3 >>>= 32;
        l3 = l6 * ((long)nArray[4] & 0xFFFFFFFFL) + l3;
        nArray[4] = (int)l3;
        l3 >>>= 32;
        l3 = l5 * ((long)nArray[5] & 0xFFFFFFFFL) + l3;
        nArray[5] = (int)l3;
        l3 >>>= 32;
        l3 = l4 * ((long)nArray[6] & 0xFFFFFFFFL) + l3;
        nArray[6] = (int)l3;
        return (int)(l3 >>> 32);
    }

    public static int mulByWordAddTo(int n3, int[] nArray, int[] nArray2) {
        long l3;
        long l4 = (long)n3 & 0xFFFFFFFFL;
        long l5 = l3 = l4;
        long l6 = l3;
        long l7 = l3;
        long l8 = l3;
        long l9 = l3;
        l3 = l3 * ((long)nArray2[0] & 0xFFFFFFFFL) + ((long)nArray[0] & 0xFFFFFFFFL) + 0L;
        nArray2[0] = (int)l3;
        l3 >>>= 32;
        l3 = l9 * ((long)nArray2[1] & 0xFFFFFFFFL) + ((long)nArray[1] & 0xFFFFFFFFL) + l3;
        nArray2[1] = (int)l3;
        l3 >>>= 32;
        l3 = l8 * ((long)nArray2[2] & 0xFFFFFFFFL) + ((long)nArray[2] & 0xFFFFFFFFL) + l3;
        nArray2[2] = (int)l3;
        l3 >>>= 32;
        l3 = l7 * ((long)nArray2[3] & 0xFFFFFFFFL) + ((long)nArray[3] & 0xFFFFFFFFL) + l3;
        nArray2[3] = (int)l3;
        l3 >>>= 32;
        l3 = l6 * ((long)nArray2[4] & 0xFFFFFFFFL) + ((long)nArray[4] & 0xFFFFFFFFL) + l3;
        nArray2[4] = (int)l3;
        l3 >>>= 32;
        l3 = l5 * ((long)nArray2[5] & 0xFFFFFFFFL) + ((long)nArray[5] & 0xFFFFFFFFL) + l3;
        nArray2[5] = (int)l3;
        long l10 = l4 * ((long)nArray2[6] & 0xFFFFFFFFL) + ((long)nArray[6] & 0xFFFFFFFFL) + (l3 >>>= 32);
        nArray2[6] = (int)l10;
        return (int)(l10 >>> 32);
    }

    public static int mulWordAddTo(int n3, int[] nArray, int n4, int[] nArray2, int n5) {
        long l3 = (long)n3 & 0xFFFFFFFFL;
        int n6 = n4;
        int n7 = n4;
        int n8 = n4;
        int n9 = n4;
        int n10 = n4;
        n3 = n5 + 0;
        long l4 = l3 * ((long)nArray[n4 + 0] & 0xFFFFFFFFL) + ((long)nArray2[n3] & 0xFFFFFFFFL) + 0L;
        nArray2[n3] = (int)l4;
        long l5 = l4 >>> 32;
        long l6 = l3 * ((long)nArray[n4 + 1] & 0xFFFFFFFFL);
        n4 = n5 + 1;
        l5 = l6 + ((long)nArray2[n4] & 0xFFFFFFFFL) + l5;
        nArray2[n4] = (int)l5;
        l5 >>>= 32;
        n4 = n5 + 2;
        l5 = l3 * ((long)nArray[n10 + 2] & 0xFFFFFFFFL) + ((long)nArray2[n4] & 0xFFFFFFFFL) + l5;
        nArray2[n4] = (int)l5;
        l5 >>>= 32;
        n4 = n5 + 3;
        l5 = l3 * ((long)nArray[n9 + 3] & 0xFFFFFFFFL) + ((long)nArray2[n4] & 0xFFFFFFFFL) + l5;
        nArray2[n4] = (int)l5;
        l5 >>>= 32;
        n4 = n5 + 4;
        l5 = l3 * ((long)nArray[n8 + 4] & 0xFFFFFFFFL) + ((long)nArray2[n4] & 0xFFFFFFFFL) + l5;
        nArray2[n4] = (int)l5;
        l5 >>>= 32;
        n4 = n5 + 5;
        l5 = l3 * ((long)nArray[n7 + 5] & 0xFFFFFFFFL) + ((long)nArray2[n4] & 0xFFFFFFFFL) + l5;
        nArray2[n4] = (int)l5;
        l5 >>>= 32;
        n4 = n5 + 6;
        l5 = l3 * ((long)nArray[n6 + 6] & 0xFFFFFFFFL) + ((long)nArray2[n4] & 0xFFFFFFFFL) + l5;
        nArray2[n4] = (int)l5;
        return (int)(l5 >>> 32);
    }

    public static int mul33DWordAdd(int n3, long l3, int[] nArray, int n4) {
        long l4 = (long)n3 & 0xFFFFFFFFL;
        long l5 = l3 & 0xFFFFFFFFL;
        int n5 = n4 + 0;
        long l6 = l4 * l5 + ((long)nArray[n5] & 0xFFFFFFFFL) + 0L;
        nArray[n5] = (int)l6;
        long l7 = l3 >>> 32;
        int n6 = n4 + 1;
        l3 = l4 * l7 + l5 + ((long)nArray[n6] & 0xFFFFFFFFL) + (l6 >>>= 32);
        nArray[n6] = (int)l3;
        long l8 = l3 >>> 32;
        n5 = n4 + 2;
        l8 = l7 + ((long)nArray[n5] & 0xFFFFFFFFL) + l8;
        nArray[n5] = (int)l8;
        int n7 = n4 + 3;
        l3 = (l8 >>> 32) + ((long)nArray[n7] & 0xFFFFFFFFL);
        nArray[n7] = (int)l3;
        return l3 >>> 32 == 0L ? 0 : Nat.incAt(7, nArray, n4, 4);
    }

    public static int mul33WordAdd(int n3, int n4, int[] nArray, int n5) {
        long l3 = (long)n3 & 0xFFFFFFFFL;
        long l4 = (long)n4 & 0xFFFFFFFFL;
        long l5 = l4;
        int n6 = n5 + 0;
        l5 = l5 * l3 + ((long)nArray[n6] & 0xFFFFFFFFL) + 0L;
        nArray[n6] = (int)l5;
        long l6 = l5 >>> 32;
        int n7 = n5 + 1;
        l6 = l4 + ((long)nArray[n7] & 0xFFFFFFFFL) + l6;
        nArray[n7] = (int)l6;
        int n8 = n5 + 2;
        long l7 = (l6 >>> 32) + ((long)nArray[n8] & 0xFFFFFFFFL);
        nArray[n8] = (int)l7;
        return l7 >>> 32 == 0L ? 0 : Nat.incAt(7, nArray, n5, 3);
    }

    public static int mulWordDwordAdd(int n3, long l3, int[] nArray, int n4) {
        long l4 = (long)n3 & 0xFFFFFFFFL;
        long l5 = l3;
        n3 = n4 + 0;
        l3 = l4 * (l3 & 0xFFFFFFFFL) + ((long)nArray[n3] & 0xFFFFFFFFL) + 0L;
        nArray[n3] = (int)l3;
        long l6 = l3 >>> 32;
        int n5 = n4 + 1;
        l6 = l4 * (l5 >>> 32) + ((long)nArray[n5] & 0xFFFFFFFFL) + l6;
        nArray[n5] = (int)l6;
        int n6 = n4 + 2;
        l3 = (l6 >>> 32) + ((long)nArray[n6] & 0xFFFFFFFFL);
        nArray[n6] = (int)l3;
        return l3 >>> 32 == 0L ? 0 : Nat.incAt(7, nArray, n4, 3);
    }

    public static int mulWord(int n3, int[] nArray, int[] nArray2, int n4) {
        long l3 = 0L;
        long l4 = (long)n3 & 0xFFFFFFFFL;
        n3 = 0;
        do {
            l3 = l4 * ((long)nArray[n3] & 0xFFFFFFFFL) + l3;
            int n5 = n4 + n3;
            nArray2[n5] = (int)l3;
            l3 >>>= 32;
        } while (++n3 < 7);
        return (int)l3;
    }

    public static void square(int[] nArray, int[] nArray2) {
        long l3 = (long)nArray[0] & 0xFFFFFFFFL;
        int n3 = 0;
        int n4 = 6;
        int n5 = 14;
        while (true) {
            int n6 = n4 + -1;
            long l4 = (long)nArray[n4] & 0xFFFFFFFFL;
            long l5 = l4 * l4;
            int n7 = n3;
            n3 = n5 + -1;
            nArray2[n3] = n7 << 31 | (int)(l5 >>> 33);
            n5 = n3 + -1;
            nArray2[n5] = (int)(l5 >>> 1);
            n3 = (int)l5;
            if (n6 <= 0) {
                int[] nArray3 = nArray2;
                long l6 = l3;
                long l7 = l6 * l6;
                long l8 = (long)(n3 << 31) & 0xFFFFFFFFL | l7 >>> 33;
                nArray2[0] = (int)l7;
                n5 = (int)(l7 >>> 32) & 1;
                long l9 = (long)nArray[1] & 0xFFFFFFFFL;
                long l10 = l9 * l3 + l8;
                int n8 = (int)l10;
                nArray2[1] = n8 << 1 | n5;
                int n9 = n8 >>> 31;
                l7 = ((long)nArray2[2] & 0xFFFFFFFFL) + (l10 >>> 32);
                long l11 = (long)nArray[2] & 0xFFFFFFFFL;
                long l12 = (long)nArray2[3] & 0xFFFFFFFFL;
                long l13 = l11 * l3 + l7;
                int n10 = (int)l13;
                nArray2[2] = n10 << 1 | n9;
                n9 = n10 >>> 31;
                l7 = a.a(l11, l9, l13 >>> 32, l12);
                long l14 = ((long)nArray3[4] & 0xFFFFFFFFL) + (l7 >>> 32);
                l12 = l14;
                l7 &= 0xFFFFFFFFL;
                long l15 = (long)nArray[3] & 0xFFFFFFFFL;
                l12 = ((long)nArray2[5] & 0xFFFFFFFFL) + (l12 >>> 32);
                long l16 = l14 & 0xFFFFFFFFL;
                long l17 = ((long)nArray2[6] & 0xFFFFFFFFL) + (l12 >>> 32);
                l12 &= 0xFFFFFFFFL;
                long l18 = l15 * l3 + l7;
                int n11 = (int)l18;
                nArray2[3] = n11 << 1 | n9;
                n9 = n11 >>> 31;
                l7 = a.a(l15, l9, l18 >>> 32, l16);
                l12 = a.a(l15, l11, l7 >>> 32, l12);
                l7 &= 0xFFFFFFFFL;
                long l19 = l17 + (l12 >>> 32);
                l16 = l19;
                l12 &= 0xFFFFFFFFL;
                long l20 = (long)nArray[4] & 0xFFFFFFFFL;
                l16 = ((long)nArray2[7] & 0xFFFFFFFFL) + (l16 >>> 32);
                long l21 = l19 & 0xFFFFFFFFL;
                long l22 = ((long)nArray3[8] & 0xFFFFFFFFL) + (l16 >>> 32);
                l16 &= 0xFFFFFFFFL;
                long l23 = l20 * l3 + l7;
                int n12 = (int)l23;
                nArray2[4] = n12 << 1 | n9;
                n9 = n12 >>> 31;
                l7 = a.a(l20, l9, l23 >>> 32, l12);
                l12 = a.a(l20, l11, l7 >>> 32, l21);
                l7 &= 0xFFFFFFFFL;
                l16 = a.a(l20, l15, l12 >>> 32, l16);
                l12 &= 0xFFFFFFFFL;
                long l24 = l22 + (l16 >>> 32);
                l21 = l24;
                l16 &= 0xFFFFFFFFL;
                long l25 = (long)nArray[5] & 0xFFFFFFFFL;
                l21 = ((long)nArray2[9] & 0xFFFFFFFFL) + (l21 >>> 32);
                long l26 = l24 & 0xFFFFFFFFL;
                long l27 = ((long)nArray2[10] & 0xFFFFFFFFL) + (l21 >>> 32);
                l21 &= 0xFFFFFFFFL;
                long l28 = l25 * l3 + l7;
                int n13 = (int)l28;
                nArray2[5] = n13 << 1 | n9;
                n9 = n13 >>> 31;
                l7 = a.a(l25, l9, l28 >>> 32, l12);
                l12 = a.a(l25, l11, l7 >>> 32, l16);
                l7 &= 0xFFFFFFFFL;
                l16 = a.a(l25, l15, l12 >>> 32, l26);
                l12 &= 0xFFFFFFFFL;
                l21 = a.a(l25, l20, l16 >>> 32, l21);
                l16 &= 0xFFFFFFFFL;
                long l29 = l27 + (l21 >>> 32);
                l26 = l29;
                l21 &= 0xFFFFFFFFL;
                long l30 = (long)nArray[6] & 0xFFFFFFFFL;
                l26 = ((long)nArray2[11] & 0xFFFFFFFFL) + (l26 >>> 32);
                long l31 = l29 & 0xFFFFFFFFL;
                long l32 = l3;
                l3 = l26 & 0xFFFFFFFFL;
                long l33 = l30 * l32 + l7;
                int n14 = (int)l33;
                nArray2[6] = n14 << 1 | n9;
                int n15 = n14 >>> 31;
                long l34 = a.a(l30, l9, l33 >>> 32, l12);
                long l35 = a.a(l30, l11, l34 >>> 32, l16);
                l5 = a.a(l30, l15, l35 >>> 32, l21);
                long l36 = a.a(l30, l20, l5 >>> 32, l31);
                l3 = a.a(l30, l25, l36 >>> 32, l3);
                long l37 = ((long)nArray3[12] & 0xFFFFFFFFL) + (l26 >>> 32) + (l3 >>> 32);
                int n16 = (int)l34;
                nArray2[7] = n16 << 1 | n15;
                n15 = n16 >>> 31;
                int n17 = (int)l35;
                nArray2[8] = n17 << 1 | n15;
                n15 = n17 >>> 31;
                int n18 = (int)l5;
                nArray2[9] = n18 << 1 | n15;
                n15 = n18 >>> 31;
                int n19 = (int)l36;
                nArray2[10] = n19 << 1 | n15;
                n15 = n19 >>> 31;
                int n20 = (int)l3;
                nArray2[11] = n20 << 1 | n15;
                n15 = n20 >>> 31;
                int n21 = (int)l37;
                nArray2[12] = n21 << 1 | n15;
                n15 = n21 >>> 31;
                nArray3[13] = nArray2[13] + (int)(l37 >>> 32) << 1 | n15;
                return;
            }
            n4 = n6;
        }
    }

    public static void square(int[] nArray, int n3, int[] nArray2, int n4) {
        long l3 = (long)nArray[n3 + 0] & 0xFFFFFFFFL;
        int n5 = 0;
        int n6 = 6;
        int n7 = 14;
        while (true) {
            int n8 = n6 + -1;
            long l4 = (long)nArray[n3 + n6] & 0xFFFFFFFFL;
            long l5 = l4 * l4;
            int n9 = n5;
            n5 = n7 + -1;
            n6 = n4 + n5;
            nArray2[n6] = n9 << 31 | (int)(l5 >>> 33);
            n7 = n5 + -1;
            n5 = n4 + n7;
            nArray2[n5] = (int)(l5 >>> 1);
            n5 = (int)l5;
            if (n8 <= 0) {
                int[] nArray3 = nArray2;
                long l6 = l3;
                long l7 = l6 * l6;
                long l8 = (long)(n5 << 31) & 0xFFFFFFFFL | l7 >>> 33;
                n7 = n4 + 0;
                nArray2[n7] = (int)l7;
                n7 = (int)(l7 >>> 32) & 1;
                long l9 = (long)nArray[n3 + 1] & 0xFFFFFFFFL;
                int n10 = n4 + 2;
                long l10 = l9 * l3 + l8;
                int n11 = (int)l10;
                int n12 = n4 + 1;
                nArray2[n12] = n11 << 1 | n7;
                n12 = n11 >>> 31;
                l7 = ((long)nArray2[n10] & 0xFFFFFFFFL) + (l10 >>> 32);
                long l11 = (long)nArray[n3 + 2] & 0xFFFFFFFFL;
                int n13 = n4 + 3;
                long l12 = (long)nArray2[n13] & 0xFFFFFFFFL;
                int n14 = n4 + 4;
                long l13 = l11 * l3 + l7;
                int n15 = (int)l13;
                nArray2[n10] = n15 << 1 | n12;
                n12 = n15 >>> 31;
                long l14 = a.a(l11, l9, l13 >>> 32, l12);
                long l15 = ((long)nArray3[n14] & 0xFFFFFFFFL) + (l14 >>> 32);
                l12 = l15;
                l14 &= 0xFFFFFFFFL;
                long l16 = (long)nArray[n3 + 3] & 0xFFFFFFFFL;
                n10 = n4 + 5;
                l12 = ((long)nArray2[n10] & 0xFFFFFFFFL) + (l12 >>> 32);
                long l17 = l15 & 0xFFFFFFFFL;
                int n16 = n4 + 6;
                long l18 = ((long)nArray2[n16] & 0xFFFFFFFFL) + (l12 >>> 32);
                l12 &= 0xFFFFFFFFL;
                long l19 = l16 * l3 + l14;
                int n17 = (int)l19;
                nArray2[n13] = n17 << 1 | n12;
                n12 = n17 >>> 31;
                long l20 = a.a(l16, l9, l19 >>> 32, l17);
                long l21 = a.a(l16, l11, l20 >>> 32, l12);
                l20 &= 0xFFFFFFFFL;
                long l22 = l18 + (l21 >>> 32);
                l17 = l22;
                l21 &= 0xFFFFFFFFL;
                long l23 = (long)nArray[n3 + 4] & 0xFFFFFFFFL;
                int n18 = n4 + 7;
                l17 = ((long)nArray2[n18] & 0xFFFFFFFFL) + (l17 >>> 32);
                long l24 = l22 & 0xFFFFFFFFL;
                int n19 = n4 + 8;
                long l25 = ((long)nArray3[n19] & 0xFFFFFFFFL) + (l17 >>> 32);
                l17 &= 0xFFFFFFFFL;
                long l26 = l23 * l3 + l20;
                int n20 = (int)l26;
                nArray2[n14] = n20 << 1 | n12;
                n12 = n20 >>> 31;
                long l27 = a.a(l23, l9, l26 >>> 32, l21);
                l21 = a.a(l23, l11, l27 >>> 32, l24);
                l27 &= 0xFFFFFFFFL;
                l17 = a.a(l23, l16, l21 >>> 32, l17);
                l21 &= 0xFFFFFFFFL;
                long l28 = l25 + (l17 >>> 32);
                l24 = l28;
                l17 &= 0xFFFFFFFFL;
                long l29 = (long)nArray[n3 + 5] & 0xFFFFFFFFL;
                n14 = n4 + 9;
                l24 = ((long)nArray2[n14] & 0xFFFFFFFFL) + (l24 >>> 32);
                long l30 = l28 & 0xFFFFFFFFL;
                int n21 = n4 + 10;
                long l31 = ((long)nArray2[n21] & 0xFFFFFFFFL) + (l24 >>> 32);
                l24 &= 0xFFFFFFFFL;
                long l32 = l29 * l3 + l27;
                int n22 = (int)l32;
                nArray2[n10] = n22 << 1 | n12;
                n12 = n22 >>> 31;
                long l33 = a.a(l29, l9, l32 >>> 32, l21);
                l21 = a.a(l29, l11, l33 >>> 32, l17);
                l33 &= 0xFFFFFFFFL;
                l17 = a.a(l29, l16, l21 >>> 32, l30);
                l21 &= 0xFFFFFFFFL;
                l24 = a.a(l29, l23, l17 >>> 32, l24);
                l17 &= 0xFFFFFFFFL;
                long l34 = l31 + (l24 >>> 32);
                l30 = l34;
                long l35 = l24 & 0xFFFFFFFFL;
                l24 = (long)nArray[n3 + 6] & 0xFFFFFFFFL;
                n10 = n4 + 11;
                l30 = ((long)nArray2[n10] & 0xFFFFFFFFL) + (l30 >>> 32);
                long l36 = l34 & 0xFFFFFFFFL;
                int n23 = n4 + 12;
                long l37 = l3;
                l3 = l30 & 0xFFFFFFFFL;
                long l38 = l24 * l37 + l33;
                int n24 = (int)l38;
                nArray2[n16] = n24 << 1 | n12;
                n12 = n24 >>> 31;
                long l39 = a.a(l24, l9, l38 >>> 32, l21);
                l9 = a.a(l24, l11, l39 >>> 32, l17);
                l35 = a.a(l24, l16, l9 >>> 32, l35);
                l11 = a.a(l24, l23, l35 >>> 32, l36);
                l3 = a.a(l24, l29, l11 >>> 32, l3);
                l21 = ((long)nArray3[n23] & 0xFFFFFFFFL) + (l30 >>> 32) + (l3 >>> 32);
                int n25 = (int)l39;
                nArray2[n18] = n25 << 1 | n12;
                n3 = (int)l9;
                nArray2[n19] = n3 << 1 | (n25 >>>= 31);
                n25 = n3 >>> 31;
                n3 = (int)l35;
                nArray2[n14] = n3 << 1 | n25;
                n25 = n3 >>> 31;
                n3 = (int)l11;
                nArray2[n21] = n3 << 1 | n25;
                n25 = n3 >>> 31;
                n3 = (int)l3;
                nArray2[n10] = n3 << 1 | n25;
                n25 = n3 >>> 31;
                n3 = (int)l21;
                nArray2[n23] = n3 << 1 | n25;
                n25 = n3 >>> 31;
                n3 = n4 + 13;
                nArray3[n3] = nArray2[n3] + (int)(l21 >>> 32) << 1 | n25;
                return;
            }
            n6 = n8;
        }
    }

    public static int sub(int[] nArray, int[] nArray2, int[] nArray3) {
        long l3 = ((long)nArray[0] & 0xFFFFFFFFL) - ((long)nArray2[0] & 0xFFFFFFFFL) + 0L;
        nArray3[0] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray[1] & 0xFFFFFFFFL) - ((long)nArray2[1] & 0xFFFFFFFFL) + l3;
        nArray3[1] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray[2] & 0xFFFFFFFFL) - ((long)nArray2[2] & 0xFFFFFFFFL) + l3;
        nArray3[2] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray[3] & 0xFFFFFFFFL) - ((long)nArray2[3] & 0xFFFFFFFFL) + l3;
        nArray3[3] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray[4] & 0xFFFFFFFFL) - ((long)nArray2[4] & 0xFFFFFFFFL) + l3;
        nArray3[4] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray[5] & 0xFFFFFFFFL) - ((long)nArray2[5] & 0xFFFFFFFFL) + l3;
        nArray3[5] = (int)l3;
        long l4 = ((long)nArray[6] & 0xFFFFFFFFL) - ((long)nArray2[6] & 0xFFFFFFFFL) + (l3 >>= 32);
        nArray3[6] = (int)l4;
        return (int)(l4 >> 32);
    }

    public static int sub(int[] nArray, int n3, int[] nArray2, int n4, int[] nArray3, int n5) {
        long l3 = ((long)nArray[n3 + 0] & 0xFFFFFFFFL) - ((long)nArray2[n4 + 0] & 0xFFFFFFFFL) + 0L;
        int n6 = n5 + 0;
        nArray3[n6] = (int)l3;
        long l4 = l3 >> 32;
        l4 = ((long)nArray[n3 + 1] & 0xFFFFFFFFL) - ((long)nArray2[n4 + 1] & 0xFFFFFFFFL) + l4;
        int n7 = n5 + 1;
        nArray3[n7] = (int)l4;
        long l5 = l4 >> 32;
        l5 = ((long)nArray[n3 + 2] & 0xFFFFFFFFL) - ((long)nArray2[n4 + 2] & 0xFFFFFFFFL) + l5;
        int n8 = n5 + 2;
        nArray3[n8] = (int)l5;
        long l6 = l5 >> 32;
        l6 = ((long)nArray[n3 + 3] & 0xFFFFFFFFL) - ((long)nArray2[n4 + 3] & 0xFFFFFFFFL) + l6;
        int n9 = n5 + 3;
        nArray3[n9] = (int)l6;
        long l7 = l6 >> 32;
        l7 = ((long)nArray[n3 + 4] & 0xFFFFFFFFL) - ((long)nArray2[n4 + 4] & 0xFFFFFFFFL) + l7;
        int n10 = n5 + 4;
        nArray3[n10] = (int)l7;
        long l8 = l7 >> 32;
        l8 = ((long)nArray[n3 + 5] & 0xFFFFFFFFL) - ((long)nArray2[n4 + 5] & 0xFFFFFFFFL) + l8;
        int n11 = n5 + 5;
        nArray3[n11] = (int)l8;
        long l9 = l8 >> 32;
        l9 = ((long)nArray[n3 + 6] & 0xFFFFFFFFL) - ((long)nArray2[n4 + 6] & 0xFFFFFFFFL) + l9;
        int n12 = n5 + 6;
        nArray3[n12] = (int)l9;
        return (int)(l9 >> 32);
    }

    public static int subBothFrom(int[] nArray, int[] nArray2, int[] nArray3) {
        long l3 = ((long)nArray3[0] & 0xFFFFFFFFL) - ((long)nArray[0] & 0xFFFFFFFFL) - ((long)nArray2[0] & 0xFFFFFFFFL) + 0L;
        nArray3[0] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray3[1] & 0xFFFFFFFFL) - ((long)nArray[1] & 0xFFFFFFFFL) - ((long)nArray2[1] & 0xFFFFFFFFL) + l3;
        nArray3[1] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray3[2] & 0xFFFFFFFFL) - ((long)nArray[2] & 0xFFFFFFFFL) - ((long)nArray2[2] & 0xFFFFFFFFL) + l3;
        nArray3[2] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray3[3] & 0xFFFFFFFFL) - ((long)nArray[3] & 0xFFFFFFFFL) - ((long)nArray2[3] & 0xFFFFFFFFL) + l3;
        nArray3[3] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray3[4] & 0xFFFFFFFFL) - ((long)nArray[4] & 0xFFFFFFFFL) - ((long)nArray2[4] & 0xFFFFFFFFL) + l3;
        nArray3[4] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray3[5] & 0xFFFFFFFFL) - ((long)nArray[5] & 0xFFFFFFFFL) - ((long)nArray2[5] & 0xFFFFFFFFL) + l3;
        nArray3[5] = (int)l3;
        long l4 = ((long)nArray3[6] & 0xFFFFFFFFL) - ((long)nArray[6] & 0xFFFFFFFFL) - ((long)nArray2[6] & 0xFFFFFFFFL) + (l3 >>= 32);
        nArray3[6] = (int)l4;
        return (int)(l4 >> 32);
    }

    public static int subFrom(int[] nArray, int[] nArray2) {
        long l3 = ((long)nArray2[0] & 0xFFFFFFFFL) - ((long)nArray[0] & 0xFFFFFFFFL) + 0L;
        nArray2[0] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray2[1] & 0xFFFFFFFFL) - ((long)nArray[1] & 0xFFFFFFFFL) + l3;
        nArray2[1] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray2[2] & 0xFFFFFFFFL) - ((long)nArray[2] & 0xFFFFFFFFL) + l3;
        nArray2[2] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray2[3] & 0xFFFFFFFFL) - ((long)nArray[3] & 0xFFFFFFFFL) + l3;
        nArray2[3] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray2[4] & 0xFFFFFFFFL) - ((long)nArray[4] & 0xFFFFFFFFL) + l3;
        nArray2[4] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray2[5] & 0xFFFFFFFFL) - ((long)nArray[5] & 0xFFFFFFFFL) + l3;
        nArray2[5] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray2[6] & 0xFFFFFFFFL) - ((long)nArray[6] & 0xFFFFFFFFL) + l3;
        nArray2[6] = (int)l3;
        return (int)(l3 >> 32);
    }

    public static int subFrom(int[] nArray, int n3, int[] nArray2, int n4) {
        int n5 = n4 + 0;
        long l3 = ((long)nArray2[n5] & 0xFFFFFFFFL) - ((long)nArray[n3 + 0] & 0xFFFFFFFFL) + 0L;
        nArray2[n5] = (int)l3;
        long l4 = l3 >> 32;
        int n6 = n4 + 1;
        l4 = ((long)nArray2[n6] & 0xFFFFFFFFL) - ((long)nArray[n3 + 1] & 0xFFFFFFFFL) + l4;
        nArray2[n6] = (int)l4;
        l4 >>= 32;
        n6 = n4 + 2;
        l4 = ((long)nArray2[n6] & 0xFFFFFFFFL) - ((long)nArray[n3 + 2] & 0xFFFFFFFFL) + l4;
        nArray2[n6] = (int)l4;
        l4 >>= 32;
        n6 = n4 + 3;
        l4 = ((long)nArray2[n6] & 0xFFFFFFFFL) - ((long)nArray[n3 + 3] & 0xFFFFFFFFL) + l4;
        nArray2[n6] = (int)l4;
        l4 >>= 32;
        n6 = n4 + 4;
        l4 = ((long)nArray2[n6] & 0xFFFFFFFFL) - ((long)nArray[n3 + 4] & 0xFFFFFFFFL) + l4;
        nArray2[n6] = (int)l4;
        l4 >>= 32;
        n6 = n4 + 5;
        l4 = ((long)nArray2[n6] & 0xFFFFFFFFL) - ((long)nArray[n3 + 5] & 0xFFFFFFFFL) + l4;
        nArray2[n6] = (int)l4;
        long l5 = ((long)nArray2[n4 += 6] & 0xFFFFFFFFL) - ((long)nArray[n3 + 6] & 0xFFFFFFFFL) + (l4 >>= 32);
        nArray2[n4] = (int)l5;
        return (int)(l5 >> 32);
    }

    public static BigInteger toBigInteger(int[] nArray) {
        byte[] byArray = new byte[28];
        for (int i3 = 0; i3 < 7; ++i3) {
            int n3 = nArray[i3];
            if (n3 == 0) continue;
            Pack.intToBigEndian(n3, byArray, 6 - i3 << 2);
        }
        return new BigInteger(1, byArray);
    }

    public static void zero(int[] nArray) {
        int[] nArray2 = nArray;
        nArray2[0] = 0;
        nArray2[1] = 0;
        nArray2[2] = 0;
        nArray2[3] = 0;
        nArray2[4] = 0;
        nArray2[5] = 0;
        nArray[6] = 0;
    }
}

