/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.raw;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;
import java.math.BigInteger;

public abstract class Nat256 {
    private static final long M = 0xFFFFFFFFL;

    public static int add(int[] nArray, int[] nArray2, int[] nArray3) {
        long l3 = ((long)nArray[0] & 0xFFFFFFFFL) + ((long)nArray2[0] & 0xFFFFFFFFL) + 0L;
        nArray3[0] = (int)l3;
        l3 >>>= 32;
        l3 = ((long)nArray[1] & 0xFFFFFFFFL) + ((long)nArray2[1] & 0xFFFFFFFFL) + l3;
        nArray3[1] = (int)l3;
        l3 >>>= 32;
        l3 = ((long)nArray[2] & 0xFFFFFFFFL) + ((long)nArray2[2] & 0xFFFFFFFFL) + l3;
        nArray3[2] = (int)l3;
        l3 >>>= 32;
        l3 = ((long)nArray[3] & 0xFFFFFFFFL) + ((long)nArray2[3] & 0xFFFFFFFFL) + l3;
        nArray3[3] = (int)l3;
        l3 >>>= 32;
        l3 = ((long)nArray[4] & 0xFFFFFFFFL) + ((long)nArray2[4] & 0xFFFFFFFFL) + l3;
        nArray3[4] = (int)l3;
        l3 >>>= 32;
        l3 = ((long)nArray[5] & 0xFFFFFFFFL) + ((long)nArray2[5] & 0xFFFFFFFFL) + l3;
        nArray3[5] = (int)l3;
        l3 >>>= 32;
        l3 = ((long)nArray[6] & 0xFFFFFFFFL) + ((long)nArray2[6] & 0xFFFFFFFFL) + l3;
        nArray3[6] = (int)l3;
        long l4 = ((long)nArray[7] & 0xFFFFFFFFL) + ((long)nArray2[7] & 0xFFFFFFFFL) + (l3 >>>= 32);
        nArray3[7] = (int)l4;
        return (int)(l4 >>> 32);
    }

    public static int add(int[] nArray, int n3, int[] nArray2, int n4, int[] nArray3, int n5) {
        long l3 = ((long)nArray[n3 + 0] & 0xFFFFFFFFL) + ((long)nArray2[n4 + 0] & 0xFFFFFFFFL) + 0L;
        int n6 = n5 + 0;
        nArray3[n6] = (int)l3;
        long l4 = l3 >>> 32;
        l4 = ((long)nArray[n3 + 1] & 0xFFFFFFFFL) + ((long)nArray2[n4 + 1] & 0xFFFFFFFFL) + l4;
        int n7 = n5 + 1;
        nArray3[n7] = (int)l4;
        long l5 = l4 >>> 32;
        l5 = ((long)nArray[n3 + 2] & 0xFFFFFFFFL) + ((long)nArray2[n4 + 2] & 0xFFFFFFFFL) + l5;
        int n8 = n5 + 2;
        nArray3[n8] = (int)l5;
        long l6 = l5 >>> 32;
        l6 = ((long)nArray[n3 + 3] & 0xFFFFFFFFL) + ((long)nArray2[n4 + 3] & 0xFFFFFFFFL) + l6;
        int n9 = n5 + 3;
        nArray3[n9] = (int)l6;
        long l7 = l6 >>> 32;
        l7 = ((long)nArray[n3 + 4] & 0xFFFFFFFFL) + ((long)nArray2[n4 + 4] & 0xFFFFFFFFL) + l7;
        int n10 = n5 + 4;
        nArray3[n10] = (int)l7;
        long l8 = l7 >>> 32;
        l8 = ((long)nArray[n3 + 5] & 0xFFFFFFFFL) + ((long)nArray2[n4 + 5] & 0xFFFFFFFFL) + l8;
        int n11 = n5 + 5;
        nArray3[n11] = (int)l8;
        long l9 = l8 >>> 32;
        l9 = ((long)nArray[n3 + 6] & 0xFFFFFFFFL) + ((long)nArray2[n4 + 6] & 0xFFFFFFFFL) + l9;
        int n12 = n5 + 6;
        nArray3[n12] = (int)l9;
        long l10 = l9 >>> 32;
        l10 = ((long)nArray[n3 + 7] & 0xFFFFFFFFL) + ((long)nArray2[n4 + 7] & 0xFFFFFFFFL) + l10;
        int n13 = n5 + 7;
        nArray3[n13] = (int)l10;
        return (int)(l10 >>> 32);
    }

    public static int addBothTo(int[] nArray, int[] nArray2, int[] nArray3) {
        long l3 = ((long)nArray[0] & 0xFFFFFFFFL) + ((long)nArray2[0] & 0xFFFFFFFFL) + ((long)nArray3[0] & 0xFFFFFFFFL) + 0L;
        nArray3[0] = (int)l3;
        l3 >>>= 32;
        l3 = ((long)nArray[1] & 0xFFFFFFFFL) + ((long)nArray2[1] & 0xFFFFFFFFL) + ((long)nArray3[1] & 0xFFFFFFFFL) + l3;
        nArray3[1] = (int)l3;
        l3 >>>= 32;
        l3 = ((long)nArray[2] & 0xFFFFFFFFL) + ((long)nArray2[2] & 0xFFFFFFFFL) + ((long)nArray3[2] & 0xFFFFFFFFL) + l3;
        nArray3[2] = (int)l3;
        l3 >>>= 32;
        l3 = ((long)nArray[3] & 0xFFFFFFFFL) + ((long)nArray2[3] & 0xFFFFFFFFL) + ((long)nArray3[3] & 0xFFFFFFFFL) + l3;
        nArray3[3] = (int)l3;
        l3 >>>= 32;
        l3 = ((long)nArray[4] & 0xFFFFFFFFL) + ((long)nArray2[4] & 0xFFFFFFFFL) + ((long)nArray3[4] & 0xFFFFFFFFL) + l3;
        nArray3[4] = (int)l3;
        l3 >>>= 32;
        l3 = ((long)nArray[5] & 0xFFFFFFFFL) + ((long)nArray2[5] & 0xFFFFFFFFL) + ((long)nArray3[5] & 0xFFFFFFFFL) + l3;
        nArray3[5] = (int)l3;
        l3 >>>= 32;
        l3 = ((long)nArray[6] & 0xFFFFFFFFL) + ((long)nArray2[6] & 0xFFFFFFFFL) + ((long)nArray3[6] & 0xFFFFFFFFL) + l3;
        nArray3[6] = (int)l3;
        long l4 = ((long)nArray[7] & 0xFFFFFFFFL) + ((long)nArray2[7] & 0xFFFFFFFFL) + ((long)nArray3[7] & 0xFFFFFFFFL) + (l3 >>>= 32);
        nArray3[7] = (int)l4;
        return (int)(l4 >>> 32);
    }

    public static int addBothTo(int[] nArray, int n3, int[] nArray2, int n4, int[] nArray3, int n5) {
        int n6 = n5 + 0;
        long l3 = ((long)nArray[n3 + 0] & 0xFFFFFFFFL) + ((long)nArray2[n4 + 0] & 0xFFFFFFFFL) + ((long)nArray3[n6] & 0xFFFFFFFFL) + 0L;
        nArray3[n6] = (int)l3;
        long l4 = l3 >>> 32;
        int n7 = n5 + 1;
        l4 = ((long)nArray[n3 + 1] & 0xFFFFFFFFL) + ((long)nArray2[n4 + 1] & 0xFFFFFFFFL) + ((long)nArray3[n7] & 0xFFFFFFFFL) + l4;
        nArray3[n7] = (int)l4;
        l4 >>>= 32;
        n7 = n5 + 2;
        l4 = ((long)nArray[n3 + 2] & 0xFFFFFFFFL) + ((long)nArray2[n4 + 2] & 0xFFFFFFFFL) + ((long)nArray3[n7] & 0xFFFFFFFFL) + l4;
        nArray3[n7] = (int)l4;
        l4 >>>= 32;
        n7 = n5 + 3;
        l4 = ((long)nArray[n3 + 3] & 0xFFFFFFFFL) + ((long)nArray2[n4 + 3] & 0xFFFFFFFFL) + ((long)nArray3[n7] & 0xFFFFFFFFL) + l4;
        nArray3[n7] = (int)l4;
        l4 >>>= 32;
        n7 = n5 + 4;
        l4 = ((long)nArray[n3 + 4] & 0xFFFFFFFFL) + ((long)nArray2[n4 + 4] & 0xFFFFFFFFL) + ((long)nArray3[n7] & 0xFFFFFFFFL) + l4;
        nArray3[n7] = (int)l4;
        l4 >>>= 32;
        n7 = n5 + 5;
        l4 = ((long)nArray[n3 + 5] & 0xFFFFFFFFL) + ((long)nArray2[n4 + 5] & 0xFFFFFFFFL) + ((long)nArray3[n7] & 0xFFFFFFFFL) + l4;
        nArray3[n7] = (int)l4;
        l4 >>>= 32;
        n7 = n5 + 6;
        l4 = ((long)nArray[n3 + 6] & 0xFFFFFFFFL) + ((long)nArray2[n4 + 6] & 0xFFFFFFFFL) + ((long)nArray3[n7] & 0xFFFFFFFFL) + l4;
        nArray3[n7] = (int)l4;
        l4 >>>= 32;
        int n8 = n5 + 7;
        l4 = ((long)nArray[n3 + 7] & 0xFFFFFFFFL) + ((long)nArray2[n4 + 7] & 0xFFFFFFFFL) + ((long)nArray3[n8] & 0xFFFFFFFFL) + l4;
        nArray3[n8] = (int)l4;
        return (int)(l4 >>> 32);
    }

    public static int addTo(int[] nArray, int[] nArray2) {
        long l3 = ((long)nArray[0] & 0xFFFFFFFFL) + ((long)nArray2[0] & 0xFFFFFFFFL) + 0L;
        nArray2[0] = (int)l3;
        l3 >>>= 32;
        l3 = ((long)nArray[1] & 0xFFFFFFFFL) + ((long)nArray2[1] & 0xFFFFFFFFL) + l3;
        nArray2[1] = (int)l3;
        l3 >>>= 32;
        l3 = ((long)nArray[2] & 0xFFFFFFFFL) + ((long)nArray2[2] & 0xFFFFFFFFL) + l3;
        nArray2[2] = (int)l3;
        l3 >>>= 32;
        l3 = ((long)nArray[3] & 0xFFFFFFFFL) + ((long)nArray2[3] & 0xFFFFFFFFL) + l3;
        nArray2[3] = (int)l3;
        l3 >>>= 32;
        l3 = ((long)nArray[4] & 0xFFFFFFFFL) + ((long)nArray2[4] & 0xFFFFFFFFL) + l3;
        nArray2[4] = (int)l3;
        l3 >>>= 32;
        l3 = ((long)nArray[5] & 0xFFFFFFFFL) + ((long)nArray2[5] & 0xFFFFFFFFL) + l3;
        nArray2[5] = (int)l3;
        l3 >>>= 32;
        l3 = ((long)nArray[6] & 0xFFFFFFFFL) + ((long)nArray2[6] & 0xFFFFFFFFL) + l3;
        nArray2[6] = (int)l3;
        l3 >>>= 32;
        l3 = ((long)nArray[7] & 0xFFFFFFFFL) + ((long)nArray2[7] & 0xFFFFFFFFL) + l3;
        nArray2[7] = (int)l3;
        return (int)(l3 >>> 32);
    }

    public static int addTo(int[] nArray, int n3, int[] nArray2, int n4, int n5) {
        long l3 = (long)n5 & 0xFFFFFFFFL;
        n5 = n4 + 0;
        l3 = ((long)nArray[n3 + 0] & 0xFFFFFFFFL) + ((long)nArray2[n5] & 0xFFFFFFFFL) + l3;
        nArray2[n5] = (int)l3;
        l3 >>>= 32;
        n5 = n4 + 1;
        l3 = ((long)nArray[n3 + 1] & 0xFFFFFFFFL) + ((long)nArray2[n5] & 0xFFFFFFFFL) + l3;
        nArray2[n5] = (int)l3;
        l3 >>>= 32;
        n5 = n4 + 2;
        l3 = ((long)nArray[n3 + 2] & 0xFFFFFFFFL) + ((long)nArray2[n5] & 0xFFFFFFFFL) + l3;
        nArray2[n5] = (int)l3;
        l3 >>>= 32;
        n5 = n4 + 3;
        l3 = ((long)nArray[n3 + 3] & 0xFFFFFFFFL) + ((long)nArray2[n5] & 0xFFFFFFFFL) + l3;
        nArray2[n5] = (int)l3;
        l3 >>>= 32;
        n5 = n4 + 4;
        l3 = ((long)nArray[n3 + 4] & 0xFFFFFFFFL) + ((long)nArray2[n5] & 0xFFFFFFFFL) + l3;
        nArray2[n5] = (int)l3;
        l3 >>>= 32;
        n5 = n4 + 5;
        l3 = ((long)nArray[n3 + 5] & 0xFFFFFFFFL) + ((long)nArray2[n5] & 0xFFFFFFFFL) + l3;
        nArray2[n5] = (int)l3;
        l3 >>>= 32;
        n5 = n4 + 6;
        l3 = ((long)nArray[n3 + 6] & 0xFFFFFFFFL) + ((long)nArray2[n5] & 0xFFFFFFFFL) + l3;
        nArray2[n5] = (int)l3;
        l3 >>>= 32;
        l3 = ((long)nArray[n3 + 7] & 0xFFFFFFFFL) + ((long)nArray2[n4 += 7] & 0xFFFFFFFFL) + l3;
        nArray2[n4] = (int)l3;
        return (int)(l3 >>> 32);
    }

    public static int addToEachOther(int[] nArray, int n3, int[] nArray2, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12 = n3 + 0;
        int n13 = n4 + 0;
        long l3 = ((long)nArray[n12] & 0xFFFFFFFFL) + ((long)nArray2[n13] & 0xFFFFFFFFL) + 0L;
        nArray[n12] = n12 = (int)l3;
        nArray2[n13] = n12;
        long l4 = l3 >>> 32;
        int n14 = n3 + 1;
        int n15 = n4 + 1;
        l4 = ((long)nArray[n14] & 0xFFFFFFFFL) + ((long)nArray2[n15] & 0xFFFFFFFFL) + l4;
        nArray[n14] = n11 = (int)l4;
        nArray2[n15] = n11;
        long l5 = l4 >>> 32;
        n14 = n3 + 2;
        n15 = n4 + 2;
        l5 = ((long)nArray[n14] & 0xFFFFFFFFL) + ((long)nArray2[n15] & 0xFFFFFFFFL) + l5;
        nArray[n14] = n10 = (int)l5;
        nArray2[n15] = n10;
        long l6 = l5 >>> 32;
        n14 = n3 + 3;
        n15 = n4 + 3;
        l6 = ((long)nArray[n14] & 0xFFFFFFFFL) + ((long)nArray2[n15] & 0xFFFFFFFFL) + l6;
        nArray[n14] = n9 = (int)l6;
        nArray2[n15] = n9;
        long l7 = l6 >>> 32;
        n14 = n3 + 4;
        n15 = n4 + 4;
        l7 = ((long)nArray[n14] & 0xFFFFFFFFL) + ((long)nArray2[n15] & 0xFFFFFFFFL) + l7;
        nArray[n14] = n8 = (int)l7;
        nArray2[n15] = n8;
        long l8 = l7 >>> 32;
        n14 = n3 + 5;
        n15 = n4 + 5;
        l8 = ((long)nArray[n14] & 0xFFFFFFFFL) + ((long)nArray2[n15] & 0xFFFFFFFFL) + l8;
        nArray[n14] = n7 = (int)l8;
        nArray2[n15] = n7;
        long l9 = l8 >>> 32;
        n14 = n3 + 6;
        n15 = n4 + 6;
        l9 = ((long)nArray[n14] & 0xFFFFFFFFL) + ((long)nArray2[n15] & 0xFFFFFFFFL) + l9;
        nArray[n14] = n6 = (int)l9;
        nArray2[n15] = n6;
        long l10 = l9 >>> 32;
        l10 = ((long)nArray[n3 += 7] & 0xFFFFFFFFL) + ((long)nArray2[n4 += 7] & 0xFFFFFFFFL) + l10;
        nArray[n3] = n5 = (int)l10;
        nArray2[n4] = n5;
        return (int)(l10 >>> 32);
    }

    public static void copy(int[] nArray, int[] nArray2) {
        nArray2[0] = nArray[0];
        nArray2[1] = nArray[1];
        nArray2[2] = nArray[2];
        nArray2[3] = nArray[3];
        nArray2[4] = nArray[4];
        nArray2[5] = nArray[5];
        nArray2[6] = nArray[6];
        nArray2[7] = nArray[7];
    }

    public static void copy(int[] nArray, int n3, int[] nArray2, int n4) {
        int n5 = n4 + 0;
        nArray2[n5] = nArray[n3 + 0];
        n5 = n4 + 1;
        nArray2[n5] = nArray[n3 + 1];
        n5 = n4 + 2;
        nArray2[n5] = nArray[n3 + 2];
        n5 = n4 + 3;
        nArray2[n5] = nArray[n3 + 3];
        n5 = n4 + 4;
        nArray2[n5] = nArray[n3 + 4];
        n5 = n4 + 5;
        nArray2[n5] = nArray[n3 + 5];
        n5 = n4 + 6;
        nArray2[n5] = nArray[n3 + 6];
        n5 = n4 + 7;
        nArray2[n5] = nArray[n3 + 7];
    }

    public static void copy64(long[] lArray, long[] lArray2) {
        long l3;
        lArray2[0] = l3 = lArray[0];
        lArray2[1] = l3 = lArray[1];
        lArray2[2] = l3 = lArray[2];
        lArray2[3] = l3 = lArray[3];
    }

    public static void copy64(long[] lArray, int n3, long[] lArray2, int n4) {
        long l3;
        int n5 = n4 + 0;
        lArray2[n5] = l3 = lArray[n3 + 0];
        n5 = n4 + 1;
        lArray2[n5] = l3 = lArray[n3 + 1];
        n5 = n4 + 2;
        lArray2[n5] = l3 = lArray[n3 + 2];
        n5 = n4 + 3;
        lArray2[n5] = l3 = lArray[n3 + 3];
    }

    public static int[] create() {
        return new int[8];
    }

    public static long[] create64() {
        return new long[4];
    }

    public static int[] createExt() {
        return new int[16];
    }

    public static long[] createExt64() {
        return new long[8];
    }

    public static boolean diff(int[] nArray, int n3, int[] nArray2, int n4, int[] nArray3, int n5) {
        boolean bl = Nat256.gte(nArray, n3, nArray2, n4);
        if (bl) {
            Nat256.sub(nArray, n3, nArray2, n4, nArray3, n5);
        } else {
            Nat256.sub(nArray2, n4, nArray, n3, nArray3, n5);
        }
        return bl;
    }

    public static boolean eq(int[] nArray, int[] nArray2) {
        for (int i3 = 7; i3 >= 0; --i3) {
            if (nArray[i3] == nArray2[i3]) continue;
            return false;
        }
        return true;
    }

    public static boolean eq64(long[] lArray, long[] lArray2) {
        for (int i3 = 3; i3 >= 0; --i3) {
            if (lArray[i3] == lArray2[i3]) continue;
            return false;
        }
        return true;
    }

    public static int[] fromBigInteger(BigInteger bigInteger) {
        if (bigInteger.signum() >= 0 && bigInteger.bitLength() <= 256) {
            int[] nArray = Nat256.create();
            for (int i3 = 0; i3 < 8; ++i3) {
                nArray[i3] = bigInteger.intValue();
                bigInteger = bigInteger.shiftRight(32);
            }
            return nArray;
        }
        throw new IllegalArgumentException();
    }

    public static long[] fromBigInteger64(BigInteger bigInteger) {
        if (bigInteger.signum() >= 0 && bigInteger.bitLength() <= 256) {
            long[] lArray = Nat256.create64();
            for (int i3 = 0; i3 < 4; ++i3) {
                long l3;
                lArray[i3] = l3 = bigInteger.longValue();
                bigInteger = bigInteger.shiftRight(64);
            }
            return lArray;
        }
        throw new IllegalArgumentException();
    }

    public static int getBit(int[] nArray, int n3) {
        if (n3 == 0) {
            return nArray[0] & 1;
        }
        if ((n3 & 0xFF) != n3) {
            return 0;
        }
        int n4 = n3;
        int n5 = n4 >>> 5;
        n3 = n4 & 0x1F;
        return nArray[n5] >>> n3 & 1;
    }

    public static boolean gte(int[] nArray, int[] nArray2) {
        for (int i3 = 7; i3 >= 0; --i3) {
            int n3 = nArray[i3] ^ Integer.MIN_VALUE;
            int n4 = nArray2[i3] ^ Integer.MIN_VALUE;
            if (n3 < n4) {
                return false;
            }
            if (n3 <= n4) continue;
            return true;
        }
        return true;
    }

    public static boolean gte(int[] nArray, int n3, int[] nArray2, int n4) {
        for (int i3 = 7; i3 >= 0; --i3) {
            int n5 = nArray[n3 + i3] ^ Integer.MIN_VALUE;
            int n6 = nArray2[n4 + i3] ^ Integer.MIN_VALUE;
            if (n5 < n6) {
                return false;
            }
            if (n5 <= n6) continue;
            return true;
        }
        return true;
    }

    public static boolean isOne(int[] nArray) {
        if (nArray[0] != 1) {
            return false;
        }
        for (int i3 = 1; i3 < 8; ++i3) {
            if (nArray[i3] == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isOne64(long[] lArray) {
        if (lArray[0] != 1L) {
            return false;
        }
        for (int i3 = 1; i3 < 4; ++i3) {
            if (lArray[i3] == 0L) continue;
            return false;
        }
        return true;
    }

    public static boolean isZero(int[] nArray) {
        for (int i3 = 0; i3 < 8; ++i3) {
            if (nArray[i3] == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isZero64(long[] lArray) {
        for (int i3 = 0; i3 < 4; ++i3) {
            if (lArray[i3] == 0L) continue;
            return false;
        }
        return true;
    }

    public static void mul(int[] nArray, int[] nArray2, int[] nArray3) {
        long l3;
        long l4 = (long)nArray2[0] & 0xFFFFFFFFL;
        long l5 = (long)nArray2[1] & 0xFFFFFFFFL;
        long l6 = (long)nArray2[2] & 0xFFFFFFFFL;
        long l7 = (long)nArray2[3] & 0xFFFFFFFFL;
        long l8 = (long)nArray2[4] & 0xFFFFFFFFL;
        long l9 = (long)nArray2[5] & 0xFFFFFFFFL;
        long l10 = (long)nArray2[6] & 0xFFFFFFFFL;
        long l11 = (long)nArray2[7] & 0xFFFFFFFFL;
        long l12 = (long)nArray[0] & 0xFFFFFFFFL;
        long l13 = l3 = l12;
        long l14 = l3;
        long l15 = l3;
        long l16 = l3;
        long l17 = l3;
        long l18 = l3;
        l3 = l3 * l4 + 0L;
        nArray3[0] = (int)l3;
        l3 >>>= 32;
        l3 = l18 * l5 + l3;
        nArray3[1] = (int)l3;
        l3 >>>= 32;
        l3 = l17 * l6 + l3;
        nArray3[2] = (int)l3;
        l3 >>>= 32;
        l3 = l16 * l7 + l3;
        nArray3[3] = (int)l3;
        l3 >>>= 32;
        l3 = l15 * l8 + l3;
        nArray3[4] = (int)l3;
        l3 >>>= 32;
        l3 = l14 * l9 + l3;
        nArray3[5] = (int)l3;
        l3 >>>= 32;
        l3 = l13 * l10 + l3;
        nArray3[6] = (int)l3;
        l3 >>>= 32;
        l3 = l12 * l11 + l3;
        nArray3[7] = (int)l3;
        nArray3[8] = (int)(l3 >>> 32);
        int n3 = 1;
        while (n3 < 8) {
            long l19 = (long)nArray[n3] & 0xFFFFFFFFL;
            long l20 = l3 = l19;
            long l21 = l3;
            long l22 = l3;
            long l23 = l3;
            long l24 = l3;
            long l25 = l3;
            int n4 = n3 + 0;
            long l26 = l3 * l4 + ((long)nArray3[n4] & 0xFFFFFFFFL) + 0L;
            nArray3[n4] = (int)l26;
            l3 = l26 >>> 32;
            int n5 = n3 + 1;
            l3 = l25 * l5 + ((long)nArray3[n5] & 0xFFFFFFFFL) + l3;
            nArray3[n5] = (int)l3;
            l3 >>>= 32;
            int n6 = n3 + 2;
            l3 = l24 * l6 + ((long)nArray3[n6] & 0xFFFFFFFFL) + l3;
            nArray3[n6] = (int)l3;
            l3 >>>= 32;
            n6 = n3 + 3;
            l3 = l23 * l7 + ((long)nArray3[n6] & 0xFFFFFFFFL) + l3;
            nArray3[n6] = (int)l3;
            l3 >>>= 32;
            n6 = n3 + 4;
            l3 = l22 * l8 + ((long)nArray3[n6] & 0xFFFFFFFFL) + l3;
            nArray3[n6] = (int)l3;
            l3 >>>= 32;
            n6 = n3 + 5;
            l3 = l21 * l9 + ((long)nArray3[n6] & 0xFFFFFFFFL) + l3;
            nArray3[n6] = (int)l3;
            l3 >>>= 32;
            n6 = n3 + 6;
            l3 = l20 * l10 + ((long)nArray3[n6] & 0xFFFFFFFFL) + l3;
            nArray3[n6] = (int)l3;
            l3 >>>= 32;
            n6 = n3 + 7;
            l3 = l19 * l11 + ((long)nArray3[n6] & 0xFFFFFFFFL) + l3;
            nArray3[n6] = (int)l3;
            nArray3[n3 += 8] = (int)(l3 >>> 32);
            n3 = n5;
        }
    }

    public static void mul(int[] nArray, int n3, int[] nArray2, int n4, int[] nArray3, int n5) {
        long l3;
        long l4 = (long)nArray2[n4 + 0] & 0xFFFFFFFFL;
        long l5 = (long)nArray2[n4 + 1] & 0xFFFFFFFFL;
        long l6 = (long)nArray2[n4 + 2] & 0xFFFFFFFFL;
        long l7 = (long)nArray2[n4 + 3] & 0xFFFFFFFFL;
        long l8 = (long)nArray2[n4 + 4] & 0xFFFFFFFFL;
        long l9 = (long)nArray2[n4 + 5] & 0xFFFFFFFFL;
        long l10 = (long)nArray2[n4 + 6] & 0xFFFFFFFFL;
        long l11 = (long)nArray2[n4 + 7] & 0xFFFFFFFFL;
        long l12 = (long)nArray[n3 + 0] & 0xFFFFFFFFL;
        long l13 = l3 = l12;
        long l14 = l3;
        long l15 = l3;
        long l16 = l3;
        long l17 = l3;
        long l18 = l3;
        l3 = l3 * l4 + 0L;
        int n6 = n5 + 0;
        nArray3[n6] = (int)l3;
        long l19 = l3 >>> 32;
        l19 = l18 * l5 + l19;
        int n7 = n5 + 1;
        nArray3[n7] = (int)l19;
        long l20 = l19 >>> 32;
        l20 = l17 * l6 + l20;
        int n8 = n5 + 2;
        nArray3[n8] = (int)l20;
        long l21 = l20 >>> 32;
        l21 = l16 * l7 + l21;
        int n9 = n5 + 3;
        nArray3[n9] = (int)l21;
        long l22 = l21 >>> 32;
        l22 = l15 * l8 + l22;
        int n10 = n5 + 4;
        nArray3[n10] = (int)l22;
        long l23 = l22 >>> 32;
        l23 = l14 * l9 + l23;
        int n11 = n5 + 5;
        nArray3[n11] = (int)l23;
        long l24 = l23 >>> 32;
        l24 = l13 * l10 + l24;
        int n12 = n5 + 6;
        nArray3[n12] = (int)l24;
        long l25 = l24 >>> 32;
        l25 = l12 * l11 + l25;
        int n13 = n5 + 7;
        nArray3[n13] = (int)l25;
        n13 = n5 + 8;
        nArray3[n13] = (int)(l25 >>> 32);
        for (n13 = 1; n13 < 8; ++n13) {
            long l26 = (long)nArray[n3 + n13] & 0xFFFFFFFFL;
            int n14 = ++n5 + 0;
            long l27 = l26 * l4 + ((long)nArray3[n14] & 0xFFFFFFFFL) + 0L;
            nArray3[n14] = (int)l27;
            long l28 = l27 >>> 32;
            int n15 = n5 + 1;
            l28 = l26 * l5 + ((long)nArray3[n15] & 0xFFFFFFFFL) + l28;
            nArray3[n15] = (int)l28;
            l28 >>>= 32;
            n15 = n5 + 2;
            l28 = l26 * l6 + ((long)nArray3[n15] & 0xFFFFFFFFL) + l28;
            nArray3[n15] = (int)l28;
            l28 >>>= 32;
            n15 = n5 + 3;
            l28 = l26 * l7 + ((long)nArray3[n15] & 0xFFFFFFFFL) + l28;
            nArray3[n15] = (int)l28;
            l28 >>>= 32;
            n15 = n5 + 4;
            l28 = l26 * l8 + ((long)nArray3[n15] & 0xFFFFFFFFL) + l28;
            nArray3[n15] = (int)l28;
            l28 >>>= 32;
            n15 = n5 + 5;
            l28 = l26 * l9 + ((long)nArray3[n15] & 0xFFFFFFFFL) + l28;
            nArray3[n15] = (int)l28;
            l28 >>>= 32;
            n15 = n5 + 6;
            l28 = l26 * l10 + ((long)nArray3[n15] & 0xFFFFFFFFL) + l28;
            nArray3[n15] = (int)l28;
            l28 >>>= 32;
            n15 = n5 + 7;
            l28 = l26 * l11 + ((long)nArray3[n15] & 0xFFFFFFFFL) + l28;
            nArray3[n15] = (int)l28;
            int n16 = n5 + 8;
            nArray3[n16] = (int)(l28 >>> 32);
        }
    }

    public static int mulAddTo(int[] nArray, int[] nArray2, int[] nArray3) {
        long l3 = (long)nArray2[0] & 0xFFFFFFFFL;
        long l4 = (long)nArray2[1] & 0xFFFFFFFFL;
        long l5 = (long)nArray2[2] & 0xFFFFFFFFL;
        long l6 = (long)nArray2[3] & 0xFFFFFFFFL;
        long l7 = (long)nArray2[4] & 0xFFFFFFFFL;
        long l8 = (long)nArray2[5] & 0xFFFFFFFFL;
        long l9 = (long)nArray2[6] & 0xFFFFFFFFL;
        long l10 = (long)nArray2[7] & 0xFFFFFFFFL;
        long l11 = 0L;
        int n3 = 0;
        while (n3 < 8) {
            long l12;
            long l13 = (long)nArray[n3] & 0xFFFFFFFFL;
            long l14 = l12 = l13;
            long l15 = l12;
            long l16 = l12;
            long l17 = l12;
            long l18 = l12;
            long l19 = l12;
            int n4 = n3 + 0;
            long l20 = l12 * l3 + ((long)nArray3[n4] & 0xFFFFFFFFL) + 0L;
            nArray3[n4] = (int)l20;
            l12 = l20 >>> 32;
            int n5 = n3 + 1;
            l12 = l19 * l4 + ((long)nArray3[n5] & 0xFFFFFFFFL) + l12;
            nArray3[n5] = (int)l12;
            l12 >>>= 32;
            int n6 = n3 + 2;
            l12 = l18 * l5 + ((long)nArray3[n6] & 0xFFFFFFFFL) + l12;
            nArray3[n6] = (int)l12;
            l12 >>>= 32;
            n6 = n3 + 3;
            l12 = l17 * l6 + ((long)nArray3[n6] & 0xFFFFFFFFL) + l12;
            nArray3[n6] = (int)l12;
            l12 >>>= 32;
            n6 = n3 + 4;
            l12 = l16 * l7 + ((long)nArray3[n6] & 0xFFFFFFFFL) + l12;
            nArray3[n6] = (int)l12;
            l12 >>>= 32;
            n6 = n3 + 5;
            l12 = l15 * l8 + ((long)nArray3[n6] & 0xFFFFFFFFL) + l12;
            nArray3[n6] = (int)l12;
            l12 >>>= 32;
            n6 = n3 + 6;
            l12 = l14 * l9 + ((long)nArray3[n6] & 0xFFFFFFFFL) + l12;
            nArray3[n6] = (int)l12;
            l12 >>>= 32;
            n6 = n3 + 7;
            l12 = l13 * l10 + ((long)nArray3[n6] & 0xFFFFFFFFL) + l12;
            nArray3[n6] = (int)l12;
            l11 = (l12 >>> 32) + ((long)nArray3[n3 += 8] & 0xFFFFFFFFL) + l11;
            nArray3[n3] = (int)l11;
            l11 >>>= 32;
            n3 = n5;
        }
        return (int)l11;
    }

    public static int mulAddTo(int[] nArray, int n3, int[] nArray2, int n4, int[] nArray3, int n5) {
        long l3 = (long)nArray2[n4 + 0] & 0xFFFFFFFFL;
        long l4 = (long)nArray2[n4 + 1] & 0xFFFFFFFFL;
        long l5 = (long)nArray2[n4 + 2] & 0xFFFFFFFFL;
        long l6 = (long)nArray2[n4 + 3] & 0xFFFFFFFFL;
        long l7 = (long)nArray2[n4 + 4] & 0xFFFFFFFFL;
        long l8 = (long)nArray2[n4 + 5] & 0xFFFFFFFFL;
        long l9 = (long)nArray2[n4 + 6] & 0xFFFFFFFFL;
        long l10 = (long)nArray2[n4 + 7] & 0xFFFFFFFFL;
        long l11 = 0L;
        for (int i3 = 0; i3 < 8; ++i3) {
            long l12;
            long l13 = (long)nArray[n3 + i3] & 0xFFFFFFFFL;
            long l14 = l12 = l13;
            long l15 = l12;
            long l16 = l12;
            long l17 = l12;
            long l18 = l12;
            long l19 = l12;
            int n6 = n5 + 0;
            long l20 = l12 * l3 + ((long)nArray3[n6] & 0xFFFFFFFFL) + 0L;
            nArray3[n6] = (int)l20;
            l12 = l20 >>> 32;
            int n7 = n5 + 1;
            l12 = l19 * l4 + ((long)nArray3[n7] & 0xFFFFFFFFL) + l12;
            nArray3[n7] = (int)l12;
            l12 >>>= 32;
            int n8 = n5 + 2;
            l12 = l18 * l5 + ((long)nArray3[n8] & 0xFFFFFFFFL) + l12;
            nArray3[n8] = (int)l12;
            l12 >>>= 32;
            n8 = n5 + 3;
            l12 = l17 * l6 + ((long)nArray3[n8] & 0xFFFFFFFFL) + l12;
            nArray3[n8] = (int)l12;
            l12 >>>= 32;
            n8 = n5 + 4;
            l12 = l16 * l7 + ((long)nArray3[n8] & 0xFFFFFFFFL) + l12;
            nArray3[n8] = (int)l12;
            l12 >>>= 32;
            n8 = n5 + 5;
            l12 = l15 * l8 + ((long)nArray3[n8] & 0xFFFFFFFFL) + l12;
            nArray3[n8] = (int)l12;
            l12 >>>= 32;
            n8 = n5 + 6;
            l12 = l14 * l9 + ((long)nArray3[n8] & 0xFFFFFFFFL) + l12;
            nArray3[n8] = (int)l12;
            l12 >>>= 32;
            n8 = n5 + 7;
            l12 = l13 * l10 + ((long)nArray3[n8] & 0xFFFFFFFFL) + l12;
            nArray3[n8] = (int)l12;
            l11 = (l12 >>> 32) + ((long)nArray3[n5 += 8] & 0xFFFFFFFFL) + l11;
            nArray3[n5] = (int)l11;
            l11 >>>= 32;
            n5 = n7;
        }
        return (int)l11;
    }

    public static long mul33Add(int n3, int[] nArray, int n4, int[] nArray2, int n5, int[] nArray3, int n6) {
        long l3 = (long)n3 & 0xFFFFFFFFL;
        long l4 = l3;
        int n7 = n4;
        long l5 = l4;
        int n8 = n4;
        long l6 = l4;
        int n9 = n4;
        long l7 = l4;
        int n10 = n4;
        long l8 = l4;
        int n11 = n4;
        long l9 = l4;
        int n12 = n4;
        long l10 = l4;
        int n13 = n4;
        long l11 = (long)nArray[n4 + 0] & 0xFFFFFFFFL;
        l4 = l4 * l11 + ((long)nArray2[n5 + 0] & 0xFFFFFFFFL) + 0L;
        n4 = n6 + 0;
        nArray3[n4] = (int)l4;
        long l12 = (long)nArray[n13 + 1] & 0xFFFFFFFFL;
        l11 = l10 * l12 + l11 + ((long)nArray2[n5 + 1] & 0xFFFFFFFFL) + (l4 >>>= 32);
        int n14 = n6 + 1;
        nArray3[n14] = (int)l11;
        long l13 = l11 >>> 32;
        l4 = (long)nArray[n12 + 2] & 0xFFFFFFFFL;
        l13 = l9 * l4 + l12 + ((long)nArray2[n5 + 2] & 0xFFFFFFFFL) + l13;
        int n15 = n6 + 2;
        nArray3[n15] = (int)l13;
        long l14 = l13 >>> 32;
        l12 = (long)nArray[n11 + 3] & 0xFFFFFFFFL;
        l14 = l8 * l12 + l4 + ((long)nArray2[n5 + 3] & 0xFFFFFFFFL) + l14;
        int n16 = n6 + 3;
        nArray3[n16] = (int)l14;
        long l15 = l14 >>> 32;
        l4 = (long)nArray[n10 + 4] & 0xFFFFFFFFL;
        l15 = l7 * l4 + l12 + ((long)nArray2[n5 + 4] & 0xFFFFFFFFL) + l15;
        int n17 = n6 + 4;
        nArray3[n17] = (int)l15;
        long l16 = l15 >>> 32;
        l12 = (long)nArray[n9 + 5] & 0xFFFFFFFFL;
        l16 = l6 * l12 + l4 + ((long)nArray2[n5 + 5] & 0xFFFFFFFFL) + l16;
        int n18 = n6 + 5;
        nArray3[n18] = (int)l16;
        long l17 = l16 >>> 32;
        l4 = (long)nArray[n8 + 6] & 0xFFFFFFFFL;
        l17 = l5 * l4 + l12 + ((long)nArray2[n5 + 6] & 0xFFFFFFFFL) + l17;
        int n19 = n6 + 6;
        nArray3[n19] = (int)l17;
        long l18 = l17 >>> 32;
        l12 = (long)nArray[n7 + 7] & 0xFFFFFFFFL;
        l18 = l3 * l12 + l4 + ((long)nArray2[n5 + 7] & 0xFFFFFFFFL) + l18;
        int n20 = n6 + 7;
        nArray3[n20] = (int)l18;
        return (l18 >>> 32) + l12;
    }

    public static int mulByWord(int n3, int[] nArray) {
        long l3;
        long l4 = (long)n3 & 0xFFFFFFFFL;
        long l5 = l3 = l4;
        long l6 = l3;
        long l7 = l3;
        long l8 = l3;
        long l9 = l3;
        long l10 = l3;
        l3 = l3 * ((long)nArray[0] & 0xFFFFFFFFL) + 0L;
        nArray[0] = (int)l3;
        l3 >>>= 32;
        l3 = l10 * ((long)nArray[1] & 0xFFFFFFFFL) + l3;
        nArray[1] = (int)l3;
        l3 >>>= 32;
        l3 = l9 * ((long)nArray[2] & 0xFFFFFFFFL) + l3;
        nArray[2] = (int)l3;
        l3 >>>= 32;
        l3 = l8 * ((long)nArray[3] & 0xFFFFFFFFL) + l3;
        nArray[3] = (int)l3;
        l3 >>>= 32;
        l3 = l7 * ((long)nArray[4] & 0xFFFFFFFFL) + l3;
        nArray[4] = (int)l3;
        l3 >>>= 32;
        l3 = l6 * ((long)nArray[5] & 0xFFFFFFFFL) + l3;
        nArray[5] = (int)l3;
        l3 >>>= 32;
        l3 = l5 * ((long)nArray[6] & 0xFFFFFFFFL) + l3;
        nArray[6] = (int)l3;
        l3 >>>= 32;
        l3 = l4 * ((long)nArray[7] & 0xFFFFFFFFL) + l3;
        nArray[7] = (int)l3;
        return (int)(l3 >>> 32);
    }

    public static int mulByWordAddTo(int n3, int[] nArray, int[] nArray2) {
        long l3;
        long l4 = (long)n3 & 0xFFFFFFFFL;
        long l5 = l3 = l4;
        long l6 = l3;
        long l7 = l3;
        long l8 = l3;
        long l9 = l3;
        long l10 = l3;
        l3 = l3 * ((long)nArray2[0] & 0xFFFFFFFFL) + ((long)nArray[0] & 0xFFFFFFFFL) + 0L;
        nArray2[0] = (int)l3;
        l3 >>>= 32;
        l3 = l10 * ((long)nArray2[1] & 0xFFFFFFFFL) + ((long)nArray[1] & 0xFFFFFFFFL) + l3;
        nArray2[1] = (int)l3;
        l3 >>>= 32;
        l3 = l9 * ((long)nArray2[2] & 0xFFFFFFFFL) + ((long)nArray[2] & 0xFFFFFFFFL) + l3;
        nArray2[2] = (int)l3;
        l3 >>>= 32;
        l3 = l8 * ((long)nArray2[3] & 0xFFFFFFFFL) + ((long)nArray[3] & 0xFFFFFFFFL) + l3;
        nArray2[3] = (int)l3;
        l3 >>>= 32;
        l3 = l7 * ((long)nArray2[4] & 0xFFFFFFFFL) + ((long)nArray[4] & 0xFFFFFFFFL) + l3;
        nArray2[4] = (int)l3;
        l3 >>>= 32;
        l3 = l6 * ((long)nArray2[5] & 0xFFFFFFFFL) + ((long)nArray[5] & 0xFFFFFFFFL) + l3;
        nArray2[5] = (int)l3;
        l3 >>>= 32;
        l3 = l5 * ((long)nArray2[6] & 0xFFFFFFFFL) + ((long)nArray[6] & 0xFFFFFFFFL) + l3;
        nArray2[6] = (int)l3;
        long l11 = l4 * ((long)nArray2[7] & 0xFFFFFFFFL) + ((long)nArray[7] & 0xFFFFFFFFL) + (l3 >>>= 32);
        nArray2[7] = (int)l11;
        return (int)(l11 >>> 32);
    }

    public static int mulWordAddTo(int n3, int[] nArray, int n4, int[] nArray2, int n5) {
        long l3 = (long)n3 & 0xFFFFFFFFL;
        int n6 = n4;
        int n7 = n4;
        int n8 = n4;
        int n9 = n4;
        int n10 = n4;
        int n11 = n4;
        n3 = n5 + 0;
        long l4 = l3 * ((long)nArray[n4 + 0] & 0xFFFFFFFFL) + ((long)nArray2[n3] & 0xFFFFFFFFL) + 0L;
        nArray2[n3] = (int)l4;
        long l5 = l4 >>> 32;
        long l6 = l3 * ((long)nArray[n4 + 1] & 0xFFFFFFFFL);
        n4 = n5 + 1;
        l5 = l6 + ((long)nArray2[n4] & 0xFFFFFFFFL) + l5;
        nArray2[n4] = (int)l5;
        l5 >>>= 32;
        n4 = n5 + 2;
        l5 = l3 * ((long)nArray[n11 + 2] & 0xFFFFFFFFL) + ((long)nArray2[n4] & 0xFFFFFFFFL) + l5;
        nArray2[n4] = (int)l5;
        l5 >>>= 32;
        n4 = n5 + 3;
        l5 = l3 * ((long)nArray[n10 + 3] & 0xFFFFFFFFL) + ((long)nArray2[n4] & 0xFFFFFFFFL) + l5;
        nArray2[n4] = (int)l5;
        l5 >>>= 32;
        n4 = n5 + 4;
        l5 = l3 * ((long)nArray[n9 + 4] & 0xFFFFFFFFL) + ((long)nArray2[n4] & 0xFFFFFFFFL) + l5;
        nArray2[n4] = (int)l5;
        l5 >>>= 32;
        n4 = n5 + 5;
        l5 = l3 * ((long)nArray[n8 + 5] & 0xFFFFFFFFL) + ((long)nArray2[n4] & 0xFFFFFFFFL) + l5;
        nArray2[n4] = (int)l5;
        l5 >>>= 32;
        n4 = n5 + 6;
        l5 = l3 * ((long)nArray[n7 + 6] & 0xFFFFFFFFL) + ((long)nArray2[n4] & 0xFFFFFFFFL) + l5;
        nArray2[n4] = (int)l5;
        l5 >>>= 32;
        n4 = n5 + 7;
        l5 = l3 * ((long)nArray[n6 + 7] & 0xFFFFFFFFL) + ((long)nArray2[n4] & 0xFFFFFFFFL) + l5;
        nArray2[n4] = (int)l5;
        return (int)(l5 >>> 32);
    }

    public static int mul33DWordAdd(int n3, long l3, int[] nArray, int n4) {
        long l4 = (long)n3 & 0xFFFFFFFFL;
        long l5 = l3 & 0xFFFFFFFFL;
        int n5 = n4 + 0;
        long l6 = l4 * l5 + ((long)nArray[n5] & 0xFFFFFFFFL) + 0L;
        nArray[n5] = (int)l6;
        long l7 = l3 >>> 32;
        int n6 = n4 + 1;
        l3 = l4 * l7 + l5 + ((long)nArray[n6] & 0xFFFFFFFFL) + (l6 >>>= 32);
        nArray[n6] = (int)l3;
        long l8 = l3 >>> 32;
        n5 = n4 + 2;
        l8 = l7 + ((long)nArray[n5] & 0xFFFFFFFFL) + l8;
        nArray[n5] = (int)l8;
        int n7 = n4 + 3;
        l3 = (l8 >>> 32) + ((long)nArray[n7] & 0xFFFFFFFFL);
        nArray[n7] = (int)l3;
        return l3 >>> 32 == 0L ? 0 : Nat.incAt(8, nArray, n4, 4);
    }

    public static int mul33WordAdd(int n3, int n4, int[] nArray, int n5) {
        long l3 = (long)n3 & 0xFFFFFFFFL;
        long l4 = (long)n4 & 0xFFFFFFFFL;
        long l5 = l4;
        int n6 = n5 + 0;
        l5 = l5 * l3 + ((long)nArray[n6] & 0xFFFFFFFFL) + 0L;
        nArray[n6] = (int)l5;
        long l6 = l5 >>> 32;
        int n7 = n5 + 1;
        l6 = l4 + ((long)nArray[n7] & 0xFFFFFFFFL) + l6;
        nArray[n7] = (int)l6;
        int n8 = n5 + 2;
        long l7 = (l6 >>> 32) + ((long)nArray[n8] & 0xFFFFFFFFL);
        nArray[n8] = (int)l7;
        return l7 >>> 32 == 0L ? 0 : Nat.incAt(8, nArray, n5, 3);
    }

    public static int mulWordDwordAdd(int n3, long l3, int[] nArray, int n4) {
        long l4 = (long)n3 & 0xFFFFFFFFL;
        long l5 = l3;
        n3 = n4 + 0;
        l3 = l4 * (l3 & 0xFFFFFFFFL) + ((long)nArray[n3] & 0xFFFFFFFFL) + 0L;
        nArray[n3] = (int)l3;
        long l6 = l3 >>> 32;
        int n5 = n4 + 1;
        l6 = l4 * (l5 >>> 32) + ((long)nArray[n5] & 0xFFFFFFFFL) + l6;
        nArray[n5] = (int)l6;
        int n6 = n4 + 2;
        l3 = (l6 >>> 32) + ((long)nArray[n6] & 0xFFFFFFFFL);
        nArray[n6] = (int)l3;
        return l3 >>> 32 == 0L ? 0 : Nat.incAt(8, nArray, n4, 3);
    }

    public static int mulWord(int n3, int[] nArray, int[] nArray2, int n4) {
        long l3 = 0L;
        long l4 = (long)n3 & 0xFFFFFFFFL;
        n3 = 0;
        do {
            l3 = l4 * ((long)nArray[n3] & 0xFFFFFFFFL) + l3;
            int n5 = n4 + n3;
            nArray2[n5] = (int)l3;
            l3 >>>= 32;
        } while (++n3 < 8);
        return (int)l3;
    }

    public static void square(int[] nArray, int[] nArray2) {
        long l3 = (long)nArray[0] & 0xFFFFFFFFL;
        int n3 = 0;
        int n4 = 7;
        int n5 = 16;
        while (true) {
            int n6 = n4 + -1;
            long l4 = (long)nArray[n4] & 0xFFFFFFFFL;
            long l5 = l4 * l4;
            int n7 = n3;
            n3 = n5 + -1;
            nArray2[n3] = n7 << 31 | (int)(l5 >>> 33);
            n5 = n3 + -1;
            nArray2[n5] = (int)(l5 >>> 1);
            n3 = (int)l5;
            if (n6 <= 0) {
                long l6 = l3;
                long l7 = l6 * l6;
                long l8 = (long)(n3 << 31) & 0xFFFFFFFFL | l7 >>> 33;
                nArray2[0] = (int)l7;
                n5 = (int)(l7 >>> 32) & 1;
                long l9 = (long)nArray[1] & 0xFFFFFFFFL;
                long l10 = l9 * l3 + l8;
                int n8 = (int)l10;
                nArray2[1] = n8 << 1 | n5;
                int n9 = n8 >>> 31;
                l7 = ((long)nArray2[2] & 0xFFFFFFFFL) + (l10 >>> 32);
                long l11 = (long)nArray[2] & 0xFFFFFFFFL;
                long l12 = (long)nArray2[3] & 0xFFFFFFFFL;
                long l13 = l11 * l3 + l7;
                int n10 = (int)l13;
                nArray2[2] = n10 << 1 | n9;
                n9 = n10 >>> 31;
                l7 = a.a(l11, l9, l13 >>> 32, l12);
                long l14 = ((long)nArray2[4] & 0xFFFFFFFFL) + (l7 >>> 32);
                l12 = l14;
                l7 &= 0xFFFFFFFFL;
                long l15 = (long)nArray[3] & 0xFFFFFFFFL;
                l12 = ((long)nArray2[5] & 0xFFFFFFFFL) + (l12 >>> 32);
                long l16 = l14 & 0xFFFFFFFFL;
                long l17 = ((long)nArray2[6] & 0xFFFFFFFFL) + (l12 >>> 32);
                l12 &= 0xFFFFFFFFL;
                long l18 = l15 * l3 + l7;
                int n11 = (int)l18;
                nArray2[3] = n11 << 1 | n9;
                n9 = n11 >>> 31;
                l7 = a.a(l15, l9, l18 >>> 32, l16);
                l12 = a.a(l15, l11, l7 >>> 32, l12);
                l7 &= 0xFFFFFFFFL;
                long l19 = l17 + (l12 >>> 32);
                l16 = l19;
                l12 &= 0xFFFFFFFFL;
                long l20 = (long)nArray[4] & 0xFFFFFFFFL;
                l16 = ((long)nArray2[7] & 0xFFFFFFFFL) + (l16 >>> 32);
                long l21 = l19 & 0xFFFFFFFFL;
                long l22 = ((long)nArray2[8] & 0xFFFFFFFFL) + (l16 >>> 32);
                l16 &= 0xFFFFFFFFL;
                long l23 = l20 * l3 + l7;
                int n12 = (int)l23;
                nArray2[4] = n12 << 1 | n9;
                n9 = n12 >>> 31;
                l7 = a.a(l20, l9, l23 >>> 32, l12);
                l12 = a.a(l20, l11, l7 >>> 32, l21);
                l7 &= 0xFFFFFFFFL;
                l16 = a.a(l20, l15, l12 >>> 32, l16);
                l12 &= 0xFFFFFFFFL;
                long l24 = l22 + (l16 >>> 32);
                l21 = l24;
                l16 &= 0xFFFFFFFFL;
                long l25 = (long)nArray[5] & 0xFFFFFFFFL;
                l21 = ((long)nArray2[9] & 0xFFFFFFFFL) + (l21 >>> 32);
                long l26 = l24 & 0xFFFFFFFFL;
                long l27 = ((long)nArray2[10] & 0xFFFFFFFFL) + (l21 >>> 32);
                l21 &= 0xFFFFFFFFL;
                long l28 = l25 * l3 + l7;
                int n13 = (int)l28;
                nArray2[5] = n13 << 1 | n9;
                n9 = n13 >>> 31;
                l7 = a.a(l25, l9, l28 >>> 32, l12);
                l12 = a.a(l25, l11, l7 >>> 32, l16);
                l7 &= 0xFFFFFFFFL;
                l16 = a.a(l25, l15, l12 >>> 32, l26);
                l12 &= 0xFFFFFFFFL;
                l21 = a.a(l25, l20, l16 >>> 32, l21);
                l16 &= 0xFFFFFFFFL;
                long l29 = l27 + (l21 >>> 32);
                l26 = l29;
                l21 &= 0xFFFFFFFFL;
                long l30 = (long)nArray[6] & 0xFFFFFFFFL;
                l26 = ((long)nArray2[11] & 0xFFFFFFFFL) + (l26 >>> 32);
                long l31 = l29 & 0xFFFFFFFFL;
                long l32 = ((long)nArray2[12] & 0xFFFFFFFFL) + (l26 >>> 32);
                l26 &= 0xFFFFFFFFL;
                long l33 = l30 * l3 + l7;
                int n14 = (int)l33;
                nArray2[6] = n14 << 1 | n9;
                n9 = n14 >>> 31;
                l7 = a.a(l30, l9, l33 >>> 32, l12);
                l12 = a.a(l30, l11, l7 >>> 32, l16);
                l7 &= 0xFFFFFFFFL;
                l16 = a.a(l30, l15, l12 >>> 32, l21);
                l12 &= 0xFFFFFFFFL;
                l21 = a.a(l30, l20, l16 >>> 32, l31);
                l16 &= 0xFFFFFFFFL;
                l26 = a.a(l30, l25, l21 >>> 32, l26);
                l21 &= 0xFFFFFFFFL;
                long l34 = l32 + (l26 >>> 32);
                l31 = l34;
                l26 &= 0xFFFFFFFFL;
                long l35 = (long)nArray[7] & 0xFFFFFFFFL;
                l31 = ((long)nArray2[13] & 0xFFFFFFFFL) + (l31 >>> 32);
                long l36 = l34 & 0xFFFFFFFFL;
                long l37 = l3;
                l3 = l31 & 0xFFFFFFFFL;
                long l38 = l35 * l37 + l7;
                int n15 = (int)l38;
                nArray2[7] = n15 << 1 | n9;
                int n16 = n15 >>> 31;
                long l39 = a.a(l35, l9, l38 >>> 32, l12);
                long l40 = a.a(l35, l11, l39 >>> 32, l16);
                l5 = a.a(l35, l15, l40 >>> 32, l21);
                long l41 = a.a(l35, l20, l5 >>> 32, l26);
                long l42 = a.a(l35, l25, l41 >>> 32, l36);
                l3 = a.a(l35, l30, l42 >>> 32, l3);
                long l43 = ((long)nArray2[14] & 0xFFFFFFFFL) + (l31 >>> 32) + (l3 >>> 32);
                int n17 = (int)l39;
                nArray2[8] = n17 << 1 | n16;
                n16 = n17 >>> 31;
                int n18 = (int)l40;
                nArray2[9] = n18 << 1 | n16;
                n16 = n18 >>> 31;
                int n19 = (int)l5;
                nArray2[10] = n19 << 1 | n16;
                n16 = n19 >>> 31;
                int n20 = (int)l41;
                nArray2[11] = n20 << 1 | n16;
                n16 = n20 >>> 31;
                int n21 = (int)l42;
                nArray2[12] = n21 << 1 | n16;
                n16 = n21 >>> 31;
                int n22 = (int)l3;
                nArray2[13] = n22 << 1 | n16;
                n16 = n22 >>> 31;
                int n23 = (int)l43;
                nArray2[14] = n23 << 1 | n16;
                n16 = n23 >>> 31;
                nArray2[15] = nArray2[15] + (int)(l43 >>> 32) << 1 | n16;
                return;
            }
            n4 = n6;
        }
    }

    public static void square(int[] nArray, int n3, int[] nArray2, int n4) {
        long l3 = (long)nArray[n3 + 0] & 0xFFFFFFFFL;
        int n5 = 0;
        int n6 = 7;
        int n7 = 16;
        while (true) {
            int n8 = n6 + -1;
            long l4 = (long)nArray[n3 + n6] & 0xFFFFFFFFL;
            long l5 = l4 * l4;
            int n9 = n5;
            n5 = n7 + -1;
            n6 = n4 + n5;
            nArray2[n6] = n9 << 31 | (int)(l5 >>> 33);
            n7 = n5 + -1;
            n5 = n4 + n7;
            nArray2[n5] = (int)(l5 >>> 1);
            n5 = (int)l5;
            if (n8 <= 0) {
                long l6 = l3;
                long l7 = l6 * l6;
                long l8 = (long)(n5 << 31) & 0xFFFFFFFFL | l7 >>> 33;
                n7 = n4 + 0;
                nArray2[n7] = (int)l7;
                n7 = (int)(l7 >>> 32) & 1;
                long l9 = (long)nArray[n3 + 1] & 0xFFFFFFFFL;
                int n10 = n4 + 2;
                long l10 = l9 * l3 + l8;
                int n11 = (int)l10;
                int n12 = n4 + 1;
                nArray2[n12] = n11 << 1 | n7;
                n12 = n11 >>> 31;
                l7 = ((long)nArray2[n10] & 0xFFFFFFFFL) + (l10 >>> 32);
                long l11 = (long)nArray[n3 + 2] & 0xFFFFFFFFL;
                int n13 = n4 + 3;
                long l12 = (long)nArray2[n13] & 0xFFFFFFFFL;
                int n14 = n4 + 4;
                long l13 = l11 * l3 + l7;
                int n15 = (int)l13;
                nArray2[n10] = n15 << 1 | n12;
                n12 = n15 >>> 31;
                long l14 = a.a(l11, l9, l13 >>> 32, l12);
                long l15 = ((long)nArray2[n14] & 0xFFFFFFFFL) + (l14 >>> 32);
                l12 = l15;
                l14 &= 0xFFFFFFFFL;
                long l16 = (long)nArray[n3 + 3] & 0xFFFFFFFFL;
                n10 = n4 + 5;
                l12 = ((long)nArray2[n10] & 0xFFFFFFFFL) + (l12 >>> 32);
                long l17 = l15 & 0xFFFFFFFFL;
                int n16 = n4 + 6;
                long l18 = ((long)nArray2[n16] & 0xFFFFFFFFL) + (l12 >>> 32);
                l12 &= 0xFFFFFFFFL;
                long l19 = l16 * l3 + l14;
                int n17 = (int)l19;
                nArray2[n13] = n17 << 1 | n12;
                n12 = n17 >>> 31;
                long l20 = a.a(l16, l9, l19 >>> 32, l17);
                long l21 = a.a(l16, l11, l20 >>> 32, l12);
                l20 &= 0xFFFFFFFFL;
                long l22 = l18 + (l21 >>> 32);
                l17 = l22;
                l21 &= 0xFFFFFFFFL;
                long l23 = (long)nArray[n3 + 4] & 0xFFFFFFFFL;
                int n18 = n4 + 7;
                l17 = ((long)nArray2[n18] & 0xFFFFFFFFL) + (l17 >>> 32);
                long l24 = l22 & 0xFFFFFFFFL;
                int n19 = n4 + 8;
                long l25 = ((long)nArray2[n19] & 0xFFFFFFFFL) + (l17 >>> 32);
                l17 &= 0xFFFFFFFFL;
                long l26 = l23 * l3 + l20;
                int n20 = (int)l26;
                nArray2[n14] = n20 << 1 | n12;
                n12 = n20 >>> 31;
                long l27 = a.a(l23, l9, l26 >>> 32, l21);
                l21 = a.a(l23, l11, l27 >>> 32, l24);
                l27 &= 0xFFFFFFFFL;
                l17 = a.a(l23, l16, l21 >>> 32, l17);
                l21 &= 0xFFFFFFFFL;
                long l28 = l25 + (l17 >>> 32);
                l24 = l28;
                l17 &= 0xFFFFFFFFL;
                long l29 = (long)nArray[n3 + 5] & 0xFFFFFFFFL;
                n14 = n4 + 9;
                l24 = ((long)nArray2[n14] & 0xFFFFFFFFL) + (l24 >>> 32);
                long l30 = l28 & 0xFFFFFFFFL;
                int n21 = n4 + 10;
                long l31 = ((long)nArray2[n21] & 0xFFFFFFFFL) + (l24 >>> 32);
                l24 &= 0xFFFFFFFFL;
                long l32 = l29 * l3 + l27;
                int n22 = (int)l32;
                nArray2[n10] = n22 << 1 | n12;
                n12 = n22 >>> 31;
                long l33 = a.a(l29, l9, l32 >>> 32, l21);
                l21 = a.a(l29, l11, l33 >>> 32, l17);
                l33 &= 0xFFFFFFFFL;
                l17 = a.a(l29, l16, l21 >>> 32, l30);
                l21 &= 0xFFFFFFFFL;
                l24 = a.a(l29, l23, l17 >>> 32, l24);
                l17 &= 0xFFFFFFFFL;
                long l34 = l31 + (l24 >>> 32);
                l30 = l34;
                l24 &= 0xFFFFFFFFL;
                long l35 = (long)nArray[n3 + 6] & 0xFFFFFFFFL;
                n10 = n4 + 11;
                l30 = ((long)nArray2[n10] & 0xFFFFFFFFL) + (l30 >>> 32);
                long l36 = l34 & 0xFFFFFFFFL;
                int n23 = n4 + 12;
                long l37 = ((long)nArray2[n23] & 0xFFFFFFFFL) + (l30 >>> 32);
                l30 &= 0xFFFFFFFFL;
                long l38 = l35 * l3 + l33;
                int n24 = (int)l38;
                nArray2[n16] = n24 << 1 | n12;
                n12 = n24 >>> 31;
                long l39 = a.a(l35, l9, l38 >>> 32, l21);
                l21 = a.a(l35, l11, l39 >>> 32, l17);
                l39 &= 0xFFFFFFFFL;
                l17 = a.a(l35, l16, l21 >>> 32, l24);
                l21 &= 0xFFFFFFFFL;
                l24 = a.a(l35, l23, l17 >>> 32, l36);
                l17 &= 0xFFFFFFFFL;
                l30 = a.a(l35, l29, l24 >>> 32, l30);
                l24 &= 0xFFFFFFFFL;
                long l40 = l37 + (l30 >>> 32);
                l36 = l40;
                long l41 = l30 & 0xFFFFFFFFL;
                l30 = (long)nArray[n3 + 7] & 0xFFFFFFFFL;
                n16 = n4 + 13;
                l36 = ((long)nArray2[n16] & 0xFFFFFFFFL) + (l36 >>> 32);
                long l42 = l40 & 0xFFFFFFFFL;
                int n25 = n4 + 14;
                long l43 = l3;
                l3 = l36 & 0xFFFFFFFFL;
                long l44 = l30 * l43 + l39;
                int n26 = (int)l44;
                nArray2[n18] = n26 << 1 | n12;
                n12 = n26 >>> 31;
                long l45 = a.a(l30, l9, l44 >>> 32, l21);
                l9 = a.a(l30, l11, l45 >>> 32, l17);
                l11 = a.a(l30, l16, l9 >>> 32, l24);
                l41 = a.a(l30, l23, l11 >>> 32, l41);
                l21 = a.a(l30, l29, l41 >>> 32, l42);
                l3 = a.a(l30, l35, l21 >>> 32, l3);
                l16 = ((long)nArray2[n25] & 0xFFFFFFFFL) + (l36 >>> 32) + (l3 >>> 32);
                int n27 = (int)l45;
                nArray2[n19] = n27 << 1 | n12;
                n3 = (int)l9;
                nArray2[n14] = n3 << 1 | (n27 >>>= 31);
                n27 = n3 >>> 31;
                n3 = (int)l11;
                nArray2[n21] = n3 << 1 | n27;
                n27 = n3 >>> 31;
                n3 = (int)l41;
                nArray2[n10] = n3 << 1 | n27;
                n27 = n3 >>> 31;
                n3 = (int)l21;
                nArray2[n23] = n3 << 1 | n27;
                n27 = n3 >>> 31;
                n3 = (int)l3;
                nArray2[n16] = n3 << 1 | n27;
                n27 = n3 >>> 31;
                n3 = (int)l16;
                nArray2[n25] = n3 << 1 | n27;
                n27 = n3 >>> 31;
                n3 = n4 + 15;
                nArray2[n3] = nArray2[n3] + (int)(l16 >>> 32) << 1 | n27;
                return;
            }
            n6 = n8;
        }
    }

    public static int sub(int[] nArray, int[] nArray2, int[] nArray3) {
        long l3 = ((long)nArray[0] & 0xFFFFFFFFL) - ((long)nArray2[0] & 0xFFFFFFFFL) + 0L;
        nArray3[0] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray[1] & 0xFFFFFFFFL) - ((long)nArray2[1] & 0xFFFFFFFFL) + l3;
        nArray3[1] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray[2] & 0xFFFFFFFFL) - ((long)nArray2[2] & 0xFFFFFFFFL) + l3;
        nArray3[2] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray[3] & 0xFFFFFFFFL) - ((long)nArray2[3] & 0xFFFFFFFFL) + l3;
        nArray3[3] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray[4] & 0xFFFFFFFFL) - ((long)nArray2[4] & 0xFFFFFFFFL) + l3;
        nArray3[4] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray[5] & 0xFFFFFFFFL) - ((long)nArray2[5] & 0xFFFFFFFFL) + l3;
        nArray3[5] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray[6] & 0xFFFFFFFFL) - ((long)nArray2[6] & 0xFFFFFFFFL) + l3;
        nArray3[6] = (int)l3;
        long l4 = ((long)nArray[7] & 0xFFFFFFFFL) - ((long)nArray2[7] & 0xFFFFFFFFL) + (l3 >>= 32);
        nArray3[7] = (int)l4;
        return (int)(l4 >> 32);
    }

    public static int sub(int[] nArray, int n3, int[] nArray2, int n4, int[] nArray3, int n5) {
        long l3 = ((long)nArray[n3 + 0] & 0xFFFFFFFFL) - ((long)nArray2[n4 + 0] & 0xFFFFFFFFL) + 0L;
        int n6 = n5 + 0;
        nArray3[n6] = (int)l3;
        long l4 = l3 >> 32;
        l4 = ((long)nArray[n3 + 1] & 0xFFFFFFFFL) - ((long)nArray2[n4 + 1] & 0xFFFFFFFFL) + l4;
        int n7 = n5 + 1;
        nArray3[n7] = (int)l4;
        long l5 = l4 >> 32;
        l5 = ((long)nArray[n3 + 2] & 0xFFFFFFFFL) - ((long)nArray2[n4 + 2] & 0xFFFFFFFFL) + l5;
        int n8 = n5 + 2;
        nArray3[n8] = (int)l5;
        long l6 = l5 >> 32;
        l6 = ((long)nArray[n3 + 3] & 0xFFFFFFFFL) - ((long)nArray2[n4 + 3] & 0xFFFFFFFFL) + l6;
        int n9 = n5 + 3;
        nArray3[n9] = (int)l6;
        long l7 = l6 >> 32;
        l7 = ((long)nArray[n3 + 4] & 0xFFFFFFFFL) - ((long)nArray2[n4 + 4] & 0xFFFFFFFFL) + l7;
        int n10 = n5 + 4;
        nArray3[n10] = (int)l7;
        long l8 = l7 >> 32;
        l8 = ((long)nArray[n3 + 5] & 0xFFFFFFFFL) - ((long)nArray2[n4 + 5] & 0xFFFFFFFFL) + l8;
        int n11 = n5 + 5;
        nArray3[n11] = (int)l8;
        long l9 = l8 >> 32;
        l9 = ((long)nArray[n3 + 6] & 0xFFFFFFFFL) - ((long)nArray2[n4 + 6] & 0xFFFFFFFFL) + l9;
        int n12 = n5 + 6;
        nArray3[n12] = (int)l9;
        long l10 = l9 >> 32;
        l10 = ((long)nArray[n3 + 7] & 0xFFFFFFFFL) - ((long)nArray2[n4 + 7] & 0xFFFFFFFFL) + l10;
        int n13 = n5 + 7;
        nArray3[n13] = (int)l10;
        return (int)(l10 >> 32);
    }

    public static int subBothFrom(int[] nArray, int[] nArray2, int[] nArray3) {
        long l3 = ((long)nArray3[0] & 0xFFFFFFFFL) - ((long)nArray[0] & 0xFFFFFFFFL) - ((long)nArray2[0] & 0xFFFFFFFFL) + 0L;
        nArray3[0] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray3[1] & 0xFFFFFFFFL) - ((long)nArray[1] & 0xFFFFFFFFL) - ((long)nArray2[1] & 0xFFFFFFFFL) + l3;
        nArray3[1] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray3[2] & 0xFFFFFFFFL) - ((long)nArray[2] & 0xFFFFFFFFL) - ((long)nArray2[2] & 0xFFFFFFFFL) + l3;
        nArray3[2] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray3[3] & 0xFFFFFFFFL) - ((long)nArray[3] & 0xFFFFFFFFL) - ((long)nArray2[3] & 0xFFFFFFFFL) + l3;
        nArray3[3] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray3[4] & 0xFFFFFFFFL) - ((long)nArray[4] & 0xFFFFFFFFL) - ((long)nArray2[4] & 0xFFFFFFFFL) + l3;
        nArray3[4] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray3[5] & 0xFFFFFFFFL) - ((long)nArray[5] & 0xFFFFFFFFL) - ((long)nArray2[5] & 0xFFFFFFFFL) + l3;
        nArray3[5] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray3[6] & 0xFFFFFFFFL) - ((long)nArray[6] & 0xFFFFFFFFL) - ((long)nArray2[6] & 0xFFFFFFFFL) + l3;
        nArray3[6] = (int)l3;
        long l4 = ((long)nArray3[7] & 0xFFFFFFFFL) - ((long)nArray[7] & 0xFFFFFFFFL) - ((long)nArray2[7] & 0xFFFFFFFFL) + (l3 >>= 32);
        nArray3[7] = (int)l4;
        return (int)(l4 >> 32);
    }

    public static int subFrom(int[] nArray, int[] nArray2) {
        long l3 = ((long)nArray2[0] & 0xFFFFFFFFL) - ((long)nArray[0] & 0xFFFFFFFFL) + 0L;
        nArray2[0] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray2[1] & 0xFFFFFFFFL) - ((long)nArray[1] & 0xFFFFFFFFL) + l3;
        nArray2[1] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray2[2] & 0xFFFFFFFFL) - ((long)nArray[2] & 0xFFFFFFFFL) + l3;
        nArray2[2] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray2[3] & 0xFFFFFFFFL) - ((long)nArray[3] & 0xFFFFFFFFL) + l3;
        nArray2[3] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray2[4] & 0xFFFFFFFFL) - ((long)nArray[4] & 0xFFFFFFFFL) + l3;
        nArray2[4] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray2[5] & 0xFFFFFFFFL) - ((long)nArray[5] & 0xFFFFFFFFL) + l3;
        nArray2[5] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray2[6] & 0xFFFFFFFFL) - ((long)nArray[6] & 0xFFFFFFFFL) + l3;
        nArray2[6] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray2[7] & 0xFFFFFFFFL) - ((long)nArray[7] & 0xFFFFFFFFL) + l3;
        nArray2[7] = (int)l3;
        return (int)(l3 >> 32);
    }

    public static int subFrom(int[] nArray, int n3, int[] nArray2, int n4) {
        int n5 = n4 + 0;
        long l3 = ((long)nArray2[n5] & 0xFFFFFFFFL) - ((long)nArray[n3 + 0] & 0xFFFFFFFFL) + 0L;
        nArray2[n5] = (int)l3;
        long l4 = l3 >> 32;
        int n6 = n4 + 1;
        l4 = ((long)nArray2[n6] & 0xFFFFFFFFL) - ((long)nArray[n3 + 1] & 0xFFFFFFFFL) + l4;
        nArray2[n6] = (int)l4;
        l4 >>= 32;
        n6 = n4 + 2;
        l4 = ((long)nArray2[n6] & 0xFFFFFFFFL) - ((long)nArray[n3 + 2] & 0xFFFFFFFFL) + l4;
        nArray2[n6] = (int)l4;
        l4 >>= 32;
        n6 = n4 + 3;
        l4 = ((long)nArray2[n6] & 0xFFFFFFFFL) - ((long)nArray[n3 + 3] & 0xFFFFFFFFL) + l4;
        nArray2[n6] = (int)l4;
        l4 >>= 32;
        n6 = n4 + 4;
        l4 = ((long)nArray2[n6] & 0xFFFFFFFFL) - ((long)nArray[n3 + 4] & 0xFFFFFFFFL) + l4;
        nArray2[n6] = (int)l4;
        l4 >>= 32;
        n6 = n4 + 5;
        l4 = ((long)nArray2[n6] & 0xFFFFFFFFL) - ((long)nArray[n3 + 5] & 0xFFFFFFFFL) + l4;
        nArray2[n6] = (int)l4;
        l4 >>= 32;
        n6 = n4 + 6;
        l4 = ((long)nArray2[n6] & 0xFFFFFFFFL) - ((long)nArray[n3 + 6] & 0xFFFFFFFFL) + l4;
        nArray2[n6] = (int)l4;
        long l5 = ((long)nArray2[n4 += 7] & 0xFFFFFFFFL) - ((long)nArray[n3 + 7] & 0xFFFFFFFFL) + (l4 >>= 32);
        nArray2[n4] = (int)l5;
        return (int)(l5 >> 32);
    }

    public static BigInteger toBigInteger(int[] nArray) {
        byte[] byArray = new byte[32];
        for (int i3 = 0; i3 < 8; ++i3) {
            int n3 = nArray[i3];
            if (n3 == 0) continue;
            Pack.intToBigEndian(n3, byArray, 7 - i3 << 2);
        }
        return new BigInteger(1, byArray);
    }

    public static BigInteger toBigInteger64(long[] lArray) {
        byte[] byArray = new byte[32];
        for (int i3 = 0; i3 < 4; ++i3) {
            long l3 = lArray[i3];
            if (l3 == 0L) continue;
            Pack.longToBigEndian(l3, byArray, 3 - i3 << 3);
        }
        return new BigInteger(1, byArray);
    }

    public static void zero(int[] nArray) {
        int[] nArray2 = nArray;
        int[] nArray3 = nArray;
        nArray2[0] = 0;
        nArray3[1] = 0;
        nArray2[2] = 0;
        nArray3[3] = 0;
        nArray2[4] = 0;
        nArray3[5] = 0;
        nArray2[6] = 0;
        nArray3[7] = 0;
    }
}

