/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmc.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.CMCEPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;

public class CMCEPrivateKey
extends ASN1Object {
    private int version;
    private byte[] delta;
    private byte[] C;
    private byte[] g;
    private byte[] alpha;
    private byte[] s;
    private CMCEPublicKey PublicKey;

    public CMCEPrivateKey(int n3, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5) {
        this(n3, byArray, byArray2, byArray3, byArray4, byArray5, null);
    }

    public CMCEPrivateKey(int n3, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, CMCEPublicKey cMCEPublicKey) {
        this.version = n3;
        if (n3 == 0) {
            this.delta = Arrays.clone(byArray);
            this.C = Arrays.clone(byArray2);
            this.g = Arrays.clone(byArray3);
            this.alpha = Arrays.clone(byArray4);
            this.s = Arrays.clone(byArray5);
            this.PublicKey = cMCEPublicKey;
            return;
        }
        throw new IllegalArgumentException("unrecognized version");
    }

    private CMCEPrivateKey(ASN1Sequence aSN1Sequence) {
        this.version = BigIntegers.intValueExact(ASN1Integer.getInstance(aSN1Sequence.getObjectAt(0)).getValue());
        if (this.version == 0) {
            this.delta = a.a(aSN1Sequence, 1);
            this.C = a.a(aSN1Sequence, 2);
            this.g = a.a(aSN1Sequence, 3);
            this.alpha = a.a(aSN1Sequence, 4);
            this.s = a.a(aSN1Sequence, 5);
            if (aSN1Sequence.size() == 7) {
                this.PublicKey = CMCEPublicKey.getInstance(aSN1Sequence.getObjectAt(6));
            }
            return;
        }
        throw new IllegalArgumentException("unrecognized version");
    }

    public static CMCEPrivateKey getInstance(Object object) {
        if (object instanceof CMCEPrivateKey) {
            return (CMCEPrivateKey)object;
        }
        if (object != null) {
            return new CMCEPrivateKey(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public int getVersion() {
        return this.version;
    }

    public byte[] getDelta() {
        return Arrays.clone(this.delta);
    }

    public byte[] getC() {
        return Arrays.clone(this.C);
    }

    public byte[] getG() {
        return Arrays.clone(this.g);
    }

    public byte[] getAlpha() {
        return Arrays.clone(this.alpha);
    }

    public byte[] getS() {
        return Arrays.clone(this.s);
    }

    public CMCEPublicKey getPublicKey() {
        return this.PublicKey;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        new ASN1EncodableVector().add(new ASN1Integer(((CMCEPrivateKey)aSN1Object).version));
        aSN1EncodableVector2.add(new DEROctetString(((CMCEPrivateKey)aSN1Object).delta));
        aSN1EncodableVector2.add(new DEROctetString(((CMCEPrivateKey)aSN1Object).C));
        aSN1EncodableVector2.add(new DEROctetString(((CMCEPrivateKey)aSN1Object).g));
        aSN1EncodableVector2.add(new DEROctetString(((CMCEPrivateKey)aSN1Object).alpha));
        aSN1EncodableVector2.add(new DEROctetString(((CMCEPrivateKey)aSN1Object).s));
        ASN1Object aSN1Object = ((CMCEPrivateKey)aSN1Object).PublicKey;
        if (aSN1Object != null) {
            aSN1EncodableVector2.add(new CMCEPublicKey(((CMCEPublicKey)aSN1Object).getT()));
        }
        return new DERSequence(aSN1EncodableVector2);
    }
}

