/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2mField;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.Permutation;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.PolynomialGF2mSmallM;

public class McElieceCCA2PrivateKey
extends ASN1Object {
    private int n;
    private int k;
    private byte[] encField;
    private byte[] encGp;
    private byte[] encP;
    private AlgorithmIdentifier digest;

    public McElieceCCA2PrivateKey(int n3, int n4, GF2mField gF2mField, PolynomialGF2mSmallM polynomialGF2mSmallM, Permutation permutation, AlgorithmIdentifier algorithmIdentifier) {
        this.n = n3;
        this.k = n4;
        this.encField = gF2mField.getEncoded();
        this.encGp = polynomialGF2mSmallM.getEncoded();
        this.encP = permutation.getEncoded();
        this.digest = algorithmIdentifier;
    }

    private McElieceCCA2PrivateKey(ASN1Sequence aSN1Sequence) {
        this.n = ((ASN1Integer)aSN1Sequence.getObjectAt(0)).intValueExact();
        this.k = ((ASN1Integer)aSN1Sequence.getObjectAt(1)).intValueExact();
        this.encField = ((ASN1OctetString)aSN1Sequence.getObjectAt(2)).getOctets();
        this.encGp = ((ASN1OctetString)aSN1Sequence.getObjectAt(3)).getOctets();
        this.encP = ((ASN1OctetString)aSN1Sequence.getObjectAt(4)).getOctets();
        this.digest = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(5));
    }

    public static McElieceCCA2PrivateKey getInstance(Object object) {
        if (object instanceof McElieceCCA2PrivateKey) {
            return (McElieceCCA2PrivateKey)object;
        }
        if (object != null) {
            return new McElieceCCA2PrivateKey(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public int getN() {
        return this.n;
    }

    public int getK() {
        return this.k;
    }

    public GF2mField getField() {
        return new GF2mField(this.encField);
    }

    public PolynomialGF2mSmallM getGoppaPoly() {
        McElieceCCA2PrivateKey mcElieceCCA2PrivateKey = gF2mField;
        GF2mField gF2mField = mcElieceCCA2PrivateKey.getField();
        return new PolynomialGF2mSmallM(gF2mField, mcElieceCCA2PrivateKey.encGp);
    }

    public Permutation getP() {
        return new Permutation(this.encP);
    }

    public AlgorithmIdentifier getDigest() {
        return this.digest;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2;
        ASN1EncodableVector aSN1EncodableVector3 = aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector3();
        aSN1EncodableVector3.add(new ASN1Integer(this.n));
        aSN1EncodableVector3.add(new ASN1Integer(this.k));
        aSN1EncodableVector3.add(new DEROctetString(this.encField));
        aSN1EncodableVector3.add(new DEROctetString(this.encGp));
        aSN1EncodableVector3.add(new DEROctetString(this.encP));
        aSN1EncodableVector.add(this.digest);
        return new DERSequence(aSN1EncodableVector2);
    }
}

