/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1;

import c.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.rainbow.util.RainbowUtil;

public class RainbowPublicKey
extends ASN1Object {
    private ASN1Integer version;
    private ASN1ObjectIdentifier oid;
    private ASN1Integer docLength;
    private byte[][] coeffQuadratic;
    private byte[][] coeffSingular;
    private byte[] coeffScalar;

    private RainbowPublicKey(ASN1Sequence aSN1Sequence) {
        int n3;
        if (aSN1Sequence.getObjectAt(0) instanceof ASN1Integer) {
            this.version = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(0));
        } else {
            this.oid = ASN1ObjectIdentifier.getInstance(aSN1Sequence.getObjectAt(0));
        }
        this.docLength = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(1));
        ASN1Sequence aSN1Sequence2 = ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(2));
        this.coeffQuadratic = new byte[aSN1Sequence2.size()][];
        for (n3 = 0; n3 < aSN1Sequence2.size(); ++n3) {
            this.coeffQuadratic[n3] = a.a(aSN1Sequence2, n3);
        }
        aSN1Sequence2 = (ASN1Sequence)aSN1Sequence.getObjectAt(3);
        this.coeffSingular = new byte[aSN1Sequence2.size()][];
        for (n3 = 0; n3 < aSN1Sequence2.size(); ++n3) {
            this.coeffSingular[n3] = a.a(aSN1Sequence2, n3);
        }
        this.coeffScalar = a.a((ASN1Sequence)aSN1Sequence.getObjectAt(4), 0);
    }

    public RainbowPublicKey(int n3, short[][] sArray, short[][] sArray2, short[] sArray3) {
        this.version = new ASN1Integer(0L);
        this.docLength = new ASN1Integer(n3);
        this.coeffQuadratic = RainbowUtil.convertArray(sArray);
        this.coeffSingular = RainbowUtil.convertArray(sArray2);
        this.coeffScalar = RainbowUtil.convertArray(sArray3);
    }

    public static RainbowPublicKey getInstance(Object object) {
        if (object instanceof RainbowPublicKey) {
            return (RainbowPublicKey)object;
        }
        if (object != null) {
            return new RainbowPublicKey(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public int getDocLength() {
        return this.docLength.intValueExact();
    }

    public short[][] getCoeffQuadratic() {
        return RainbowUtil.convertArray(this.coeffQuadratic);
    }

    public short[][] getCoeffSingular() {
        return RainbowUtil.convertArray(this.coeffSingular);
    }

    public short[] getCoeffScalar() {
        return RainbowUtil.convertArray(this.coeffScalar);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        byte[][] byArray;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2;
        ASN1EncodableVector aSN1EncodableVector3 = aSN1EncodableVector2;
        aSN1EncodableVector2 = new ASN1EncodableVector();
        Object object = this.version;
        if (object != null) {
            aSN1EncodableVector3.add((ASN1Encodable)object);
        } else {
            aSN1EncodableVector3.add(this.oid);
        }
        aSN1EncodableVector3.add(this.docLength);
        object = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector();
        int n3 = 0;
        while (true) {
            byArray = this.coeffQuadratic;
            if (n3 >= this.coeffQuadratic.length) break;
            ((ASN1EncodableVector)object).add(new DEROctetString(byArray[n3]));
            ++n3;
        }
        object = g.a.a((ASN1EncodableVector)object, aSN1EncodableVector3);
        n3 = 0;
        while (true) {
            byArray = this.coeffSingular;
            if (n3 >= this.coeffSingular.length) break;
            ((ASN1EncodableVector)object).add(new DEROctetString(byArray[n3]));
            ++n3;
        }
        object = g.a.a((ASN1EncodableVector)object, aSN1EncodableVector3);
        ((ASN1EncodableVector)object).add(new DEROctetString(this.coeffScalar));
        aSN1EncodableVector3.add(new DERSequence((ASN1EncodableVector)object));
        return new DERSequence(aSN1EncodableVector3);
    }
}

