/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmc.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.SABERPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;

public class SABERPrivateKey
extends ASN1Object {
    private int version;
    private byte[] z;
    private byte[] s;
    private byte[] hpk;
    private SABERPublicKey PublicKey;

    public SABERPrivateKey(int n3, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this.version = n3;
        if (n3 == 0) {
            SABERPrivateKey sABERPrivateKey = this;
            sABERPrivateKey.z = byArray;
            sABERPrivateKey.s = byArray2;
            sABERPrivateKey.hpk = byArray3;
            return;
        }
        throw new IllegalArgumentException("unrecognized version");
    }

    public SABERPrivateKey(int n3, byte[] byArray, byte[] byArray2, byte[] byArray3, SABERPublicKey sABERPublicKey) {
        this.version = n3;
        if (n3 == 0) {
            SABERPrivateKey sABERPrivateKey = this;
            sABERPrivateKey.z = byArray;
            sABERPrivateKey.s = byArray2;
            sABERPrivateKey.hpk = byArray3;
            sABERPrivateKey.PublicKey = sABERPublicKey;
            return;
        }
        throw new IllegalArgumentException("unrecognized version");
    }

    private SABERPrivateKey(ASN1Sequence aSN1Sequence) {
        this.version = BigIntegers.intValueExact(ASN1Integer.getInstance(aSN1Sequence.getObjectAt(0)).getValue());
        if (this.version == 0) {
            this.z = a.a(aSN1Sequence, 1);
            this.s = a.a(aSN1Sequence, 2);
            this.PublicKey = SABERPublicKey.getInstance(aSN1Sequence.getObjectAt(3));
            this.hpk = a.a(aSN1Sequence, 4);
            return;
        }
        throw new IllegalArgumentException("unrecognized version");
    }

    public static SABERPrivateKey getInstance(Object object) {
        if (object instanceof SABERPrivateKey) {
            return (SABERPrivateKey)object;
        }
        if (object != null) {
            return new SABERPrivateKey(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public int getVersion() {
        return this.version;
    }

    public byte[] getZ() {
        return this.z;
    }

    public byte[] getS() {
        return this.s;
    }

    public byte[] getHpk() {
        return this.hpk;
    }

    public SABERPublicKey getPublicKey() {
        return this.PublicKey;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        new ASN1EncodableVector().add(new ASN1Integer(this.version));
        aSN1EncodableVector2.add(new DEROctetString(this.z));
        aSN1EncodableVector2.add(new DEROctetString(this.s));
        aSN1EncodableVector2.add(new DEROctetString(this.hpk));
        return new DERSequence(aSN1EncodableVector2);
    }
}

