/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.cmce;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHAKEDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.cmce.BENES;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.cmce.BENES12;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.cmce.BENES13;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.cmce.GF;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.cmce.GF12;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.cmce.GF13;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.cmce.Utils;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.security.SecureRandom;

class CMCEEngine {
    private int SYS_N;
    private int SYS_T;
    private int GFBITS;
    private int IRR_BYTES;
    private int COND_BYTES;
    private int PK_NROWS;
    private int PK_NCOLS;
    private int PK_ROW_BYTES;
    private int SYND_BYTES;
    private int GFMASK;
    private int[] poly;
    private final int defaultKeySize;
    private GF gf;
    private BENES benes;
    private boolean usePadding;
    private boolean countErrorIndices;
    private boolean usePivots;

    public CMCEEngine(int n3, int n4, int n5, int[] nArray, boolean bl, int n6) {
        BENES bENES;
        CMCEEngine cMCEEngine = this;
        int n7 = n5;
        int n8 = n3;
        this.usePivots = bl;
        this.SYS_N = n4;
        this.SYS_T = n5;
        this.GFBITS = n3;
        this.poly = nArray;
        this.defaultKeySize = n6;
        this.IRR_BYTES = n5 * 2;
        n5 = 1 << n8 - 4;
        this.COND_BYTES = (n8 * 2 - 1) * n5;
        this.PK_NROWS = n5 = n7 * n3;
        this.PK_NCOLS = n4 - n5;
        this.PK_ROW_BYTES = (this.PK_NCOLS + 7) / 8;
        cMCEEngine.SYND_BYTES = (n5 + 7) / 8;
        cMCEEngine.GFMASK = (1 << n3) - 1;
        if (n3 == 12) {
            BENES12 bENES12;
            GF12 gF12;
            CMCEEngine cMCEEngine2 = this;
            GF12 gF122 = gF12;
            gF12 = new GF12(n3);
            cMCEEngine2.gf = gF122;
            bENES = bENES12;
            CMCEEngine cMCEEngine3 = this;
            int n9 = cMCEEngine3.SYS_N;
            n5 = cMCEEngine3.SYS_T;
            int n10 = cMCEEngine3.GFBITS;
            bENES12 = new BENES12(n9, n5, n10);
            cMCEEngine2.benes = bENES;
        } else {
            BENES13 bENES13;
            GF13 gF13;
            CMCEEngine cMCEEngine4 = this;
            GF13 gF132 = gF13;
            gF13 = new GF13(n3);
            cMCEEngine4.gf = gF132;
            bENES = bENES13;
            CMCEEngine cMCEEngine5 = this;
            int n11 = cMCEEngine5.SYS_N;
            n5 = cMCEEngine5.SYS_T;
            int n12 = cMCEEngine5.GFBITS;
            bENES13 = new BENES13(n11, n5, n12);
            cMCEEngine4.benes = bENES;
        }
        boolean bl2 = this.SYS_T % 8 != 0;
        this.usePadding = bl2;
        bl2 = 1 << this.GFBITS > this.SYS_N;
        this.countErrorIndices = bl2;
    }

    private void syndrome(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n3;
        CMCEEngine cMCEEngine = this;
        short[] sArray = new short[cMCEEngine.SYS_N / 8];
        int n4 = 0;
        int n5 = cMCEEngine.PK_NROWS % 8;
        for (n3 = 0; n3 < this.SYND_BYTES; ++n3) {
            byArray[n3] = 0;
        }
        for (n3 = 0; n3 < this.PK_NROWS; ++n3) {
            int n6;
            int n7;
            for (n7 = 0; n7 < this.SYS_N / 8; ++n7) {
                sArray[n7] = 0;
            }
            for (n7 = 0; n7 < (n6 = this.PK_ROW_BYTES); ++n7) {
                n6 = this.SYS_N / 8 - n6 + n7;
                sArray[n6] = byArray2[n4 + n7];
            }
            if (this.usePadding) {
                for (n7 = this.SYS_N / 8 - 1; n7 >= this.SYS_N / 8 - this.PK_ROW_BYTES; --n7) {
                    sArray[n7] = (short)(((sArray[n7] & 0xFF) << n5 | (sArray[n7 - 1] & 0xFF) >>> 8 - n5) & 0xFF);
                }
            }
            n7 = n3 / 8;
            n6 = n3 % 8;
            sArray[n7] = (short)(sArray[n7] | 1 << n6);
            int n8 = 0;
            for (int i3 = 0; i3 < this.SYS_N / 8; ++i3) {
                n8 = (byte)(n8 ^ sArray[i3] & byArray3[i3]);
            }
            int n9 = n4;
            int n10 = n8;
            byte by = (byte)(n10 ^ n10 >>> 4);
            byte by2 = (byte)(by ^ by >>> 2);
            n4 = (byte)((byte)(by2 ^ by2 >>> 1) & 1);
            byArray[n7] = (byte)(byArray[n7] | n4 << n6);
            n4 = n9 + this.PK_ROW_BYTES;
        }
    }

    private void generate_error_vector(byte[] byArray, SecureRandom secureRandom) {
        short s2;
        int n3;
        int n4 = this.SYS_T;
        short[] sArray = new short[n4 * 2];
        short[] sArray2 = new short[n4];
        byte[] byArray2 = new byte[n4];
        while (true) {
            int n5;
            int n6;
            if (this.countErrorIndices) {
                byte[] byArray3 = new byte[this.SYS_T * 4];
                secureRandom.nextBytes(byArray3);
                for (n6 = 0; n6 < this.SYS_T * 2; ++n6) {
                    n5 = n6 * 2;
                    sArray[n6] = Utils.load_gf(byArray3, n5, this.GFMASK);
                }
                n3 = 0;
                for (n6 = 0; n6 < (n5 = this.SYS_T) * 2 && n3 < n5; ++n6) {
                    n5 = sArray[n6];
                    if (n5 >= this.SYS_N) continue;
                    int n7 = n3 + 1;
                    sArray2[n3] = n5;
                    n3 = n7;
                }
                if (n3 < n5) {
                    continue;
                }
            } else {
                byte[] byArray4 = new byte[this.SYS_T * 2];
                secureRandom.nextBytes(byArray4);
                for (n6 = 0; n6 < this.SYS_T; ++n6) {
                    n5 = n6 * 2;
                    sArray2[n6] = Utils.load_gf(byArray4, n5, this.GFMASK);
                }
            }
            n3 = 0;
            block4: for (n6 = 1; n6 < this.SYS_T && n3 != 1; ++n6) {
                for (n5 = 0; n5 < n6; ++n5) {
                    if (sArray2[n6] != sArray2[n5]) continue;
                    n3 = 1;
                    continue block4;
                }
            }
            if (n3 == 0) break;
        }
        for (s2 = 0; s2 < this.SYS_T; ++s2) {
            byArray2[s2] = (byte)(1 << (sArray2[s2] & 7));
        }
        for (s2 = 0; s2 < this.SYS_N / 8; s2 = (short)((short)(s2 + 1))) {
            byArray[s2] = 0;
            for (int i3 = 0; i3 < this.SYS_T; ++i3) {
                short s3 = s2;
                n3 = (short)((short)CMCEEngine.same_mask32(s3, (short)(sArray2[i3] >> 3)) & 0xFF);
                byArray[s2] = (byte)(byArray[s3] | byArray2[i3] & n3);
            }
        }
    }

    private void encrypt(byte[] byArray, byte[] byArray2, byte[] byArray3, SecureRandom secureRandom) {
        CMCEEngine cMCEEngine = this;
        cMCEEngine.generate_error_vector(byArray3, secureRandom);
        cMCEEngine.syndrome(byArray, byArray2, byArray3);
    }

    private int decrypt(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n3;
        int n4;
        int n5;
        int n6;
        CMCEEngine cMCEEngine = this;
        int n7 = cMCEEngine.SYS_T;
        short[] sArray = new short[n7 + 1];
        int n8 = cMCEEngine.SYS_N;
        int n9 = n7;
        short[] sArray2 = new short[n8];
        short[] sArray3 = new short[n9 * 2];
        short[] sArray4 = new short[n9 * 2];
        short[] sArray5 = new short[n9 + 1];
        short[] sArray6 = new short[n8];
        byte[] byArray4 = new byte[n8 / 8];
        for (n6 = 0; n6 < (n5 = this.SYND_BYTES); ++n6) {
            byArray4[n6] = byArray3[n6];
        }
        while (n5 < this.SYS_N / 8) {
            byArray4[n5] = 0;
            ++n5;
        }
        for (n4 = 0; n4 < (n6 = this.SYS_T); ++n4) {
            n6 = n4 * 2 + 40;
            sArray[n4] = Utils.load_gf(byArray2, n6, this.GFMASK);
        }
        sArray[n6] = 1;
        this.benes.support_gen(sArray2, byArray2);
        this.synd(sArray3, sArray, sArray2, byArray4);
        this.bm(sArray5, sArray3);
        this.root(sArray6, sArray5, sArray2);
        for (n3 = 0; n3 < this.SYS_N / 8; ++n3) {
            byArray[n3] = 0;
        }
        n3 = 0;
        for (n4 = 0; n4 < this.SYS_N; ++n4) {
            int n10 = n3;
            n3 = (short)(this.gf.gf_iszero(sArray6[n4]) & 1);
            int n11 = n4 / 8;
            byArray[n11] = (byte)(byArray[n11] | n3 << n4 % 8);
            n3 = n10 + n3;
        }
        CMCEEngine cMCEEngine2 = this;
        cMCEEngine2.synd(sArray4, sArray, sArray2, byArray);
        int n12 = n3 ^ cMCEEngine2.SYS_T;
        for (n3 = 0; n3 < this.SYS_T * 2; ++n3) {
            n12 |= sArray3[n3] ^ sArray4[n3];
        }
        return n12 + -1 >> 15 & 1 ^ 1;
    }

    private static int min(short s2, int n3) {
        if (s2 < n3) {
            return s2;
        }
        return n3;
    }

    private void bm(short[] sArray, short[] sArray2) {
        int n3;
        int n4 = 0;
        int n5 = this.SYS_T;
        short[] sArray3 = new short[n5 + 1];
        short[] sArray4 = new short[n5 + 1];
        short[] sArray5 = new short[n5 + 1];
        short s2 = 1;
        for (n3 = 0; n3 < this.SYS_T + 1; ++n3) {
            sArray5[n3] = 0;
            sArray4[n3] = 0;
        }
        sArray4[0] = 1;
        sArray5[1] = 1;
        n3 = 0;
        while (n3 < this.SYS_T * 2) {
            int n6;
            int n7;
            int n8;
            short s3 = 0;
            for (n8 = 0; n8 <= CMCEEngine.min((short)n3, this.SYS_T); ++n8) {
                short s4 = s3;
                s3 = sArray4[n8];
                s3 = (short)(s4 ^ this.gf.gf_mul(s3, sArray2[n3 - n8]));
            }
            n8 = (short)((short)((short)((short)(s3 - 1) >> 15) & 1) - 1);
            short s5 = (short)((short)((short)((short)((short)(n3 - n4 * 2) >> 15) & 1) - 1) & n8);
            for (n7 = 0; n7 <= this.SYS_T; ++n7) {
                sArray3[n7] = sArray4[n7];
            }
            n7 = this.gf.gf_frac(s2, s3);
            for (n6 = 0; n6 <= this.SYS_T; ++n6) {
                sArray4[n6] = (short)(sArray4[n6] ^ this.gf.gf_mul((short)n7, sArray5[n6]) & n8);
            }
            n8 = ~s5;
            n4 = (short)(n4 & n8 | ++n3 - n4 & s5);
            for (n7 = 0; n7 <= (n6 = this.SYS_T); ++n7) {
                sArray5[n7] = (short)(sArray5[n7] & n8 | sArray3[n7] & s5);
            }
            s2 = (short)(s2 & n8 | s3 & s5);
            while (n6 >= 1) {
                sArray5[n6] = sArray5[n6 - 1];
                --n6;
            }
            sArray5[0] = 0;
            n3 = (short)n3;
        }
        for (int i3 = 0; i3 <= (n4 = this.SYS_T); ++i3) {
            sArray[i3] = sArray4[n4 - i3];
        }
    }

    private void synd(short[] sArray, short[] sArray2, short[] sArray3, byte[] byArray) {
        int n3;
        for (n3 = 0; n3 < this.SYS_T * 2; ++n3) {
            sArray[n3] = 0;
        }
        for (n3 = 0; n3 < this.SYS_N; ++n3) {
            CMCEEngine cMCEEngine = this;
            short s2 = (short)(byArray[n3 / 8] >> n3 % 8 & 1);
            short s3 = cMCEEngine.eval(sArray2, sArray3[n3]);
            GF gF = cMCEEngine.gf;
            short s4 = s3;
            s3 = gF.gf_inv(gF.gf_mul(s4, s4));
            for (int i3 = 0; i3 < this.SYS_T * 2; ++i3) {
                GF gF2 = this.gf;
                short s5 = sArray[i3];
                sArray[i3] = gF2.gf_add(s5, gF2.gf_mul(s3, s2));
                s3 = this.gf.gf_mul(s3, sArray3[n3]);
            }
        }
    }

    private int mov_columns(byte[][] byArray, short[] sArray, long[] lArray) {
        int n3;
        CMCEEngine cMCEEngine = this;
        long[] lArray2 = new long[64];
        long[] lArray3 = new long[32];
        long l3 = 1L;
        byte[] byArray2 = new byte[9];
        int n4 = cMCEEngine.PK_NROWS - 32;
        int n5 = n4 / 8;
        int n6 = n4 % 8;
        if (cMCEEngine.usePadding) {
            for (n3 = 0; n3 < 32; ++n3) {
                long l4;
                int n7;
                for (n7 = 0; n7 < 9; ++n7) {
                    byArray2[n7] = byArray[n4 + n3][n5 + n7];
                }
                n7 = 0;
                while (n7 < 8) {
                    byArray2[n7] = (byte)((byArray2[n7] & 0xFF) >> n6 | byArray2[++n7] << 8 - n6);
                }
                lArray2[n3] = l4 = Utils.load8(byArray2, 0);
            }
        } else {
            for (n3 = 0; n3 < 32; ++n3) {
                lArray2[n3] = Utils.load8(byArray[n4 + n3], n5);
            }
        }
        lArray[0] = 0L;
        n3 = 0;
        while (n3 < 32) {
            int n8;
            long l5;
            int n9;
            long l6 = lArray2[n3];
            for (int i3 = n9 = n3 + 1; i3 < 32; ++i3) {
                l6 |= lArray2[i3];
            }
            if (l6 == 0L) {
                return -1;
            }
            int n10 = CMCEEngine.ctz(l6);
            lArray3[n3] = l5 = (long)n10;
            lArray[0] = l5 = lArray[0] | l3 << (int)l5;
            for (n8 = n9; n8 < 32; ++n8) {
                long l7 = lArray2[n3];
                l5 = l7;
                l5 = (l5 >> n10 & 1L) - 1L;
                lArray2[n3] = l7 ^ lArray2[n8] & l5;
            }
            for (n8 = n9; n8 < 32; ++n8) {
                long l8 = lArray2[n8];
                l5 = l8;
                l5 = -(l5 >> n10 & 1L);
                lArray2[n8] = l8 ^ lArray2[n3] & l5;
            }
            n3 = n9;
        }
        int n11 = 0;
        while (n11 < 32) {
            int n12;
            for (int i4 = n12 = n11 + 1; i4 < 64; ++i4) {
                short[] sArray2 = sArray;
                int n13 = n4 + n11;
                n3 = n4 + i4;
                long l9 = (long)(sArray2[n13] ^ sArray[n3]) & CMCEEngine.same_mask64((short)i4, (short)lArray3[n11]);
                sArray2[n13] = (short)((long)sArray2[n13] ^ l9);
                sArray[n3] = (short)((long)sArray2[n3] ^ l9);
            }
            n11 = n12;
        }
        for (int i5 = 0; i5 < this.PK_NROWS; ++i5) {
            if (this.usePadding) {
                for (n11 = 0; n11 < 9; ++n11) {
                    byArray2[n11] = byArray[i5][n5 + n11];
                }
                n11 = 0;
                while (n11 < 8) {
                    byArray2[n11] = (byte)((byArray2[n11] & 0xFF) >> n6 | byArray2[++n11] << 8 - n6);
                }
                l3 = Utils.load8(byArray2, 0);
            } else {
                l3 = Utils.load8(byArray[i5], n5);
            }
            for (n11 = 0; n11 < 32; ++n11) {
                long l10 = l3;
                long l11 = l3;
                l3 = lArray3[n11];
                long l12 = (l10 >> n11 ^ l11 >> (int)l3) & 1L;
                l3 = l10 ^ l12 << (int)l3 ^ l12 << n11;
            }
            if (this.usePadding) {
                Utils.store8(byArray2, 0, l3);
                byte[] byArray3 = byArray[i5];
                byte[] byArray4 = byArray3;
                int n14 = n5 + 8;
                int n15 = 8 - n6;
                byArray4[n14] = (byte)((byArray4[n14] & 0xFF) >>> n6 << n6 | (byArray2[7] & 0xFF) >>> n15);
                n14 = n5 + 0;
                byArray3[n14] = (byte)((byArray2[0] & 0xFF) << n6 | (byArray4[n5] & 0xFF) << n15 >>> n15);
                for (n11 = 7; n11 >= 1; --n11) {
                    n14 = n5 + n11;
                    byArray[i5][n14] = (byte)((byArray2[n11] & 0xFF) << n6 | (byArray2[n11 - 1] & 0xFF) >>> n15);
                }
                continue;
            }
            Utils.store8(byArray[i5], n5, l3);
        }
        return 0;
    }

    private static int ctz(long l3) {
        int n3 = 0;
        int n4 = 0;
        for (int i3 = 0; i3 < 64; ++i3) {
            int n5 = n4;
            int n6 = n3;
            n3 = (int)(l3 >> i3 & 1L);
            n4 = n6 | n3;
            n3 = n5 + ((n4 ^ 1) & (n3 ^ 1));
            int n7 = n3;
            n3 = n4;
            n4 = n7;
        }
        return n4;
    }

    private static long same_mask64(short s2, short s3) {
        return -((long)(s2 ^ s3) - 1L >>> 63);
    }

    private static byte same_mask32(short s2, short s3) {
        return (byte)(-((s2 ^ s3) + -1 >>> 31) & 0xFF);
    }

    private static void layer(short[] sArray, byte[] byArray, int n3, int n4, int n5) {
        n4 = 1 << n4;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n5) {
            for (int i3 = 0; i3 < n4; ++i3) {
                short[] sArray2 = sArray;
                int n8 = n7 + i3;
                short s2 = sArray[n8];
                int n9 = (s2 ^ sArray[n8 += n4]) & -(byArray[n3 + (n6 >> 3)] >> (n6 & 7) & 1);
                sArray2[n8] = (short)(s2 ^ n9);
                sArray2[n8] = (short)(sArray[n8] ^ n9);
                ++n6;
            }
            n7 = n4 * 2 + n7;
        }
    }

    private static void controlbitsfrompermutation(byte[] byArray, short[] sArray, long l3, long l4) {
        int n3;
        long l5 = l4;
        int[] nArray = new int[(int)(l5 * 2L)];
        int n4 = (int)l5;
        short[] sArray2 = new short[n4];
        do {
            n3 = 0;
            while ((long)n3 < ((l3 * 2L - 1L) * l4 / 2L + 7L) / 8L) {
                byArray[n3] = 0;
                ++n3;
            }
            CMCEEngine.cbrecursion(byArray, 0L, 1L, sArray, 0, l3, l4, nArray);
            n3 = 0;
            while ((long)n3 < l4) {
                sArray2[n3] = (short)n3;
                ++n3;
            }
            n3 = 0;
            int n5 = 0;
            while ((long)n5 < l3) {
                CMCEEngine.layer(sArray2, byArray, n3, n5, n4);
                n3 = (int)((long)n3 + (l4 >> 4));
                ++n5;
            }
            for (n5 = (int)(l3 - 2L); n5 >= 0; --n5) {
                CMCEEngine.layer(sArray2, byArray, n3, n5, n4);
                n3 = (int)((long)n3 + (l4 >> 4));
            }
            n3 = 0;
            n5 = 0;
            while ((long)n5 < l4) {
                n3 = (short)(n3 | sArray[n5] ^ sArray2[n5]);
                ++n5;
            }
        } while (n3 != 0);
    }

    public static short get_q_short(int[] nArray, int n3) {
        int n4 = n3;
        n3 = n4 / 2;
        if (n4 % 2 == 0) {
            return (short)nArray[n3];
        }
        return (short)((nArray[n3] & 0xFFFF0000) >> 16);
    }

    public static void cbrecursion(byte[] byArray, long l3, long l4, short[] sArray, int n3, long l5, long l6, int[] nArray) {
        int n4;
        int n5;
        int n6;
        long l7;
        int n7;
        long l8;
        if (l5 == 1L) {
            int n8 = (int)(l3 >> 3);
            byArray[n8] = (byte)(byArray[n8] ^ CMCEEngine.get_q_short(nArray, n3) << (int)(l3 & 7L));
            return;
        }
        if (sArray != null) {
            for (l8 = 0L; l8 < l6; ++l8) {
                n7 = (int)l8;
                nArray[n7] = (sArray[n7] ^ 1) << 16 | sArray[(int)(l8 ^ 1L)];
            }
        } else {
            for (l8 = 0L; l8 < l6; ++l8) {
                n7 = (int)l8;
                long l9 = n3;
                nArray[n7] = (CMCEEngine.get_q_short(nArray, (int)(l9 + l8)) ^ 1) << 16 | CMCEEngine.get_q_short(nArray, (int)(l9 + (l8 ^ 1L)));
            }
        }
        int n9 = (int)l6;
        CMCEEngine.sort32(nArray, 0, n9);
        for (l7 = 0L; l7 < l6; ++l7) {
            int n10 = (int)l7;
            int n11 = nArray[n10] & 0xFFFF;
            if (l7 >= (long)n11) {
                n10 = n11;
            }
            int n12 = (int)(l6 + l7);
            nArray[n12] = n11 << 16 | n10;
        }
        for (l7 = 0L; l7 < l6; ++l7) {
            int n13 = (int)l7;
            nArray[n13] = (int)((long)(nArray[n13] << 16) | l7);
        }
        CMCEEngine.sort32(nArray, 0, n9);
        for (l7 = 0L; l7 < l6; ++l7) {
            int n14 = (int)l7;
            nArray[n14] = (nArray[n14] << 16) + (nArray[(int)(l6 + l7)] >> 16);
        }
        CMCEEngine.sort32(nArray, 0, n9);
        if (l5 <= 10L) {
            for (l7 = 0L; l7 < l6; ++l7) {
                int n15 = (int)(l6 + l7);
                nArray[n15] = (nArray[(int)l7] & 0xFFFF) << 10 | nArray[n15] & 0x3FF;
            }
            for (l7 = 1L; l7 < l5 - 1L; ++l7) {
                long l10;
                for (l10 = 0L; l10 < l6; ++l10) {
                    long l11 = l10;
                    n6 = (int)l11;
                    nArray[n6] = (int)((long)((nArray[(int)(l6 + l11)] & 0xFFFFFC00) << 6) | l10);
                }
                CMCEEngine.sort32(nArray, 0, n9);
                for (l10 = 0L; l10 < l6; ++l10) {
                    n6 = (int)l10;
                    nArray[n6] = nArray[n6] << 20 | nArray[(int)(l6 + l10)];
                }
                CMCEEngine.sort32(nArray, 0, n9);
                for (l10 = 0L; l10 < l6; ++l10) {
                    n6 = nArray[(int)l10];
                    n5 = n6 & 0xFFFFF;
                    n4 = n6 & 0xFFC00 | nArray[n6 = (int)(l6 + l10)] & 0x3FF;
                    if (n5 >= n4) {
                        n5 = n4;
                    }
                    nArray[n6] = n5;
                }
            }
            for (l7 = 0L; l7 < l6; ++l7) {
                int n16 = (int)(l6 + l7);
                nArray[n16] = nArray[n16] & 0x3FF;
            }
        } else {
            for (l7 = 0L; l7 < l6; ++l7) {
                int n17 = (int)(l6 + l7);
                nArray[n17] = nArray[(int)l7] << 16 | nArray[n17] & 0xFFFF;
            }
            for (l7 = 1L; l7 < l5 - 1L; ++l7) {
                long l12;
                for (l12 = 0L; l12 < l6; ++l12) {
                    long l13 = l12;
                    n6 = (int)l13;
                    nArray[n6] = (int)((long)(nArray[(int)(l6 + l13)] & 0xFFFF0000) | l12);
                }
                CMCEEngine.sort32(nArray, 0, n9);
                for (l12 = 0L; l12 < l6; ++l12) {
                    n6 = (int)l12;
                    nArray[n6] = nArray[n6] << 16 | nArray[(int)(l6 + l12)] & 0xFFFF;
                }
                if (l7 < l5 - 2L) {
                    for (l12 = 0L; l12 < l6; ++l12) {
                        int n18 = (int)(l6 + l12);
                        nArray[n18] = nArray[(int)l12] & 0xFFFF0000 | nArray[n18] >> 16;
                    }
                    CMCEEngine.sort32(nArray, n9, (int)(l6 * 2L));
                    for (l12 = 0L; l12 < l6; ++l12) {
                        n6 = (int)(l6 + l12);
                        nArray[n6] = nArray[n6] << 16 | nArray[(int)l12] & 0xFFFF;
                    }
                }
                CMCEEngine.sort32(nArray, 0, n9);
                for (l12 = 0L; l12 < l6; ++l12) {
                    n6 = (int)(l6 + l12);
                    n5 = nArray[n6];
                    n4 = n5 & 0xFFFF0000 | nArray[(int)l12] & 0xFFFF;
                    if (n4 >= n5) continue;
                    nArray[n6] = n4;
                }
            }
            for (l7 = 0L; l7 < l6; ++l7) {
                int n19 = (int)(l6 + l7);
                nArray[n19] = nArray[n19] & 0xFFFF;
            }
        }
        if (sArray != null) {
            for (l7 = 0L; l7 < l6; ++l7) {
                n3 = (int)l7;
                nArray[n3] = (int)((long)(sArray[n3] << 16) + l7);
            }
        } else {
            for (l7 = 0L; l7 < l6; ++l7) {
                int n20 = (int)l7;
                nArray[n20] = (int)((long)(CMCEEngine.get_q_short(nArray, (int)((long)n3 + l7)) << 16) + l7);
            }
        }
        CMCEEngine.sort32(nArray, 0, n9);
        long l14 = 0L;
        while (l14 < (l7 = l6 / 2L)) {
            long l15 = l14;
            l7 = l6 + (l14 *= 2L);
            int n21 = (int)l7;
            n3 = nArray[n21] & 1;
            int n22 = (int)(l14 + (long)n3);
            n7 = n22 ^ 1;
            int n23 = (int)(l3 >> 3);
            byArray[n23] = (byte)(byArray[n23] ^ n3 << (int)(l3 & 7L));
            l3 += l4;
            nArray[n21] = nArray[(int)l14] << 16 | n22;
            n21 = (int)(l7 + 1L);
            nArray[n21] = nArray[(int)(l14 + 1L)] << 16 | n7;
            l14 = l15 + 1L;
        }
        l14 = l6 * 2L;
        CMCEEngine.sort32(nArray, n9, (int)l14);
        long l16 = l5 * 2L;
        l3 = (l16 - 3L) * l4 * l7 + l3;
        long l17 = 0L;
        while (l17 < l7) {
            long l18 = l17;
            long l19 = l6 + (l17 *= 2L);
            int n24 = nArray[(int)l19];
            int n25 = n24 & 1;
            int n26 = (int)(l17 + (long)n25);
            int n27 = (int)(l3 >> 3);
            byArray[n27] = (byte)(byArray[n27] ^ n25 << (int)(l3 & 7L));
            l3 += l4;
            n27 = (int)l17;
            nArray[n27] = n26 << 16 | n24 & 0xFFFF;
            n27 = (int)(l17 + 1L);
            nArray[n27] = (n26 ^ 1) << 16 | nArray[(int)(l19 + 1L)] & 0xFFFF;
            l17 = l18 + 1L;
        }
        CMCEEngine.sort32(nArray, 0, n9);
        l3 -= (l16 - 2L) * l4 * l7;
        short[] sArray2 = new short[n9 * 4];
        l16 = 0L;
        while (l16 < l14) {
            long l20 = l16;
            long l21 = l16;
            l16 = l21 * 2L;
            int n28 = (int)(l16 + 0L);
            n5 = nArray[(int)l21];
            sArray2[n28] = (short)n5;
            int n29 = (int)(l16 + 1L);
            sArray2[n29] = (short)((n5 & 0xFFFF0000) >> 16);
            l16 = l20 + 1L;
        }
        for (l14 = 0L; l14 < l7; ++l14) {
            long l22 = l14;
            int n30 = (int)l22;
            long l23 = l22 * 2L;
            sArray2[n30] = (short)((nArray[(int)l23] & 0xFFFF) >>> 1);
            int n31 = (int)(l14 + l7);
            sArray2[n31] = (short)((nArray[(int)(l23 + 1L)] & 0xFFFF) >>> 1);
        }
        for (l14 = 0L; l14 < l7; ++l14) {
            int n32 = (int)(l6 / 4L + l6 + l14);
            long l24 = l14 * 2L;
            nArray[n32] = sArray2[(int)(l24 + 1L)] << 16 | sArray2[(int)l24];
        }
        l14 = l4 * 2L;
        l6 = l6 / 4L + l6;
        long l25 = l3;
        long l26 = l3;
        int n33 = (int)l6 * 2;
        l3 = l5 - 1L;
        CMCEEngine.cbrecursion(byArray, l26, l14, null, n33, l3, l7, nArray);
        l4 = l25 + l4;
        n33 = (int)(l6 * 2L + l7);
        CMCEEngine.cbrecursion(byArray, l4, l14, null, n33, l3, l7, nArray);
    }

    private int pk_gen(byte[] byArray, byte[] byArray2, int[] nArray, short[] sArray, long[] lArray) {
        block26: {
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10 = this.SYS_T;
            short[] sArray2 = new short[n10 + 1];
            short[] sArray3 = sArray2;
            sArray2[n10] = 1;
            for (n10 = 0; n10 < this.SYS_T; ++n10) {
                n9 = n10 * 2 + 40;
                sArray3[n10] = Utils.load_gf(byArray2, n9, this.GFMASK);
            }
            int n11 = 1 << this.GFBITS;
            long[] lArray2 = new long[n11];
            for (n9 = 0; n9 < 1 << this.GFBITS; ++n9) {
                long l3;
                lArray2[n9] = l3 = (long)nArray[n9];
                lArray2[n9] = l3 <<= 31;
                lArray2[n9] = l3 |= (long)n9;
                lArray2[n9] = l3 & Long.MAX_VALUE;
            }
            CMCEEngine.sort64(lArray2, 0, n11);
            for (n11 = 1; n11 < 1 << this.GFBITS; ++n11) {
                if (lArray2[n11 - 1] >> 31 != lArray2[n11] >> 31) continue;
                return -1;
            }
            short[] sArray4 = new short[this.SYS_N];
            for (n8 = 0; n8 < 1 << this.GFBITS; ++n8) {
                sArray[n8] = (short)(lArray2[n8] & (long)this.GFMASK);
            }
            for (n8 = 0; n8 < (n7 = this.SYS_N); ++n8) {
                sArray4[n8] = Utils.bitrev(sArray[n8], this.GFBITS);
            }
            short[] sArray5 = new short[n7];
            this.root(sArray5, sArray3, sArray4);
            for (n7 = 0; n7 < (n6 = this.SYS_N); ++n7) {
                sArray5[n7] = this.gf.gf_inv(sArray5[n7]);
            }
            byte[][] byArray3 = new byte[this.PK_NROWS][n6 / 8];
            for (n6 = 0; n6 < this.PK_NROWS; ++n6) {
                for (n9 = 0; n9 < this.SYS_N / 8; ++n9) {
                    byArray3[n6][n9] = 0;
                }
            }
            for (n6 = 0; n6 < this.SYS_T; ++n6) {
                int n12;
                for (n9 = 0; n9 < this.SYS_N; n9 += 8) {
                    for (n12 = 0; n12 < (n5 = this.GFBITS); ++n12) {
                        byArray3[n6 * n5 + n12][n9 / 8] = n5 = (int)((byte)((byte)((byte)((byte)((byte)((byte)((byte)((byte)((byte)((byte)((byte)((byte)((byte)((byte)((byte)(sArray5[n9 + 7] >>> n12 & 1) << 1) | sArray5[n9 + 6] >>> n12 & 1) << 1) | sArray5[n9 + 5] >>> n12 & 1) << 1) | sArray5[n9 + 4] >>> n12 & 1) << 1) | sArray5[n9 + 3] >>> n12 & 1) << 1) | sArray5[n9 + 2] >>> n12 & 1) << 1) | sArray5[n9 + 1] >>> n12 & 1) << 1) | sArray5[n9 + 0] >>> n12 & 1));
                    }
                }
                for (n9 = 0; n9 < this.SYS_N; ++n9) {
                    n12 = sArray5[n9];
                    sArray5[n9] = this.gf.gf_mul((short)n12, sArray4[n9]);
                }
            }
            for (n4 = 0; n4 < ((n3 = this.PK_NROWS) + 7) / 8; ++n4) {
                for (n3 = 0; n3 < 8 && (n6 = n4 * 8 + n3) < (n9 = this.PK_NROWS); ++n3) {
                    byte by;
                    if (this.usePivots && n6 == n9 - 32 && this.mov_columns(byArray3, sArray, lArray) != 0) {
                        return -1;
                    }
                    for (n9 = n6 + 1; n9 < this.PK_NROWS; ++n9) {
                        by = -((byte)((byte)((byte)(byArray3[n6][n4] ^ byArray3[n9][n4]) >> n3) & 1));
                        for (n5 = 0; n5 < this.SYS_N / 8; ++n5) {
                            byte[] byArray4 = byArray3[n6];
                            byArray4[n5] = (byte)(byArray4[n5] ^ byArray3[n9][n5] & by);
                        }
                    }
                    if ((byArray3[n6][n4] >> n3 & 1) == 0) {
                        return -1;
                    }
                    for (n9 = 0; n9 < this.PK_NROWS; ++n9) {
                        if (n9 == n6) continue;
                        by = -((byte)((byte)(byArray3[n9][n4] >> n3) & 1));
                        for (n5 = 0; n5 < this.SYS_N / 8; ++n5) {
                            byte[] byArray5 = byArray3[n9];
                            byArray5[n5] = (byte)(byArray5[n5] ^ byArray3[n6][n5] & by);
                        }
                    }
                }
            }
            if (byArray == null) break block26;
            if (this.usePadding) {
                int n13;
                n4 = 0;
                n3 %= 8;
                for (int i3 = 0; i3 < (n13 = this.PK_NROWS); ++i3) {
                    n13 = (n13 - 1) / 8;
                    while (n13 < this.SYS_N / 8 - 1) {
                        int n14 = n4++;
                        byte[] byArray6 = byArray3[i3];
                        byArray[n14] = (byte)((byArray6[n13] & 0xFF) >>> n3 | byArray6[++n13] << 8 - n3);
                    }
                    byArray[n4++] = (byte)((byArray3[i3][n13] & 0xFF) >>> n3);
                }
            } else {
                for (n4 = 0; n4 < this.PK_NROWS; ++n4) {
                    int n15;
                    n3 = 0;
                    for (int i4 = 0; i4 < ((n15 = this.SYS_N) - (n6 = this.PK_NROWS) + 7) / 8; ++i4) {
                        n15 = (n15 - n6 + 7) / 8 * n4 + n3;
                        byArray[n15] = byArray3[n4][n6 / 8 + i4];
                        ++n3;
                    }
                }
            }
        }
        return 0;
    }

    private short eval(short[] sArray, short s2) {
        short s3 = sArray[this.SYS_T];
        for (int i3 = (v1249981) - 1; i3 >= 0; --i3) {
            CMCEEngine cMCEEngine = this;
            s3 = cMCEEngine.gf.gf_mul(s3, s2);
            s3 = cMCEEngine.gf.gf_add(s3, sArray[i3]);
        }
        return s3;
    }

    private void root(short[] sArray, short[] sArray2, short[] sArray3) {
        for (int i3 = 0; i3 < this.SYS_N; ++i3) {
            sArray[i3] = this.eval(sArray2, sArray3[i3]);
        }
    }

    private int generate_irr_poly(short[] sArray) {
        int n3;
        int n4;
        int n5 = this.SYS_T;
        short[][] sArray2 = new short[n5 + 1][n5];
        sArray2[0][0] = 1;
        for (n4 = 1; n4 < this.SYS_T; ++n4) {
            sArray2[0][n4] = 0;
        }
        for (n4 = 0; n4 < this.SYS_T; ++n4) {
            sArray2[1][n4] = sArray[n4];
        }
        for (n4 = 2; n4 <= this.SYS_T; ++n4) {
            short[] sArray3 = sArray2[n4];
            this.GF_mul(sArray3, sArray2[n4 - 1], sArray);
        }
        n4 = 0;
        while (n4 < this.SYS_T) {
            short[] sArray4;
            int n6;
            int n7;
            int n8;
            for (n8 = n7 = n4 + 1; n8 < this.SYS_T; ++n8) {
                n6 = this.gf.gf_iszero(sArray2[n4][n4]);
                for (int i3 = n4; i3 < this.SYS_T + 1; ++i3) {
                    short[] sArray5 = sArray2[i3];
                    sArray4 = sArray5;
                    sArray5[n4] = (short)(sArray4[n4] ^ sArray4[n8] & n6);
                }
            }
            n8 = sArray2[n4][n4];
            if (n8 == 0) {
                return -1;
            }
            n8 = this.gf.gf_inv((short)n8);
            for (n6 = n4; n6 < this.SYS_T + 1; ++n6) {
                short[] sArray6 = sArray2[n6];
                short[] sArray7 = sArray6;
                sArray6[n4] = this.gf.gf_mul(sArray7[n4], (short)n8);
            }
            for (n8 = 0; n8 < this.SYS_T; ++n8) {
                if (n8 == n4) continue;
                n6 = sArray2[n4][n8];
                for (int i4 = n4; i4 < this.SYS_T + 1; ++i4) {
                    short[] sArray8 = sArray2[i4];
                    sArray4 = sArray8;
                    sArray8[n8] = (short)(sArray4[n8] ^ this.gf.gf_mul(sArray4[n4], (short)n6));
                }
            }
            n4 = n7;
        }
        for (n4 = 0; n4 < (n3 = this.SYS_T); ++n4) {
            sArray[n4] = sArray2[n3][n4];
        }
        return 0;
    }

    private void GF_mul(short[] sArray, short[] sArray2, short[] sArray3) {
        int n3;
        int n4;
        int n5;
        int n6;
        short[] sArray4 = new short[this.SYS_T * 2 - 1];
        for (n6 = 0; n6 < this.SYS_T * 2 - 1; ++n6) {
            sArray4[n6] = 0;
        }
        for (n6 = 0; n6 < (n5 = this.SYS_T); ++n6) {
            for (n5 = 0; n5 < this.SYS_T; ++n5) {
                short s2 = sArray2[n6];
                s2 = this.gf.gf_mul(s2, sArray3[n5]);
                int n7 = n6 + n5;
                sArray4[n7] = (short)(sArray4[n7] ^ s2);
            }
        }
        block3: for (n4 = (n5 - 1) * 2; n4 >= (n3 = this.SYS_T); --n4) {
            n3 = 0;
            while (true) {
                int[] nArray = this.poly;
                if (n3 == this.poly.length) continue block3;
                int n8 = nArray[n3];
                if (n8 == 0 && this.GFBITS == 12) {
                    n8 = n4 - this.SYS_T;
                    sArray4[n8] = (short)(sArray4[n8] ^ this.gf.gf_mul(sArray4[n4], (short)2));
                } else {
                    n8 = n4 - this.SYS_T + n8;
                    sArray4[n8] = (short)(sArray4[n8] ^ sArray4[n4]);
                }
                ++n3;
            }
        }
        System.arraycopy(sArray4, 0, sArray, 0, n3);
        for (n4 = 0; n4 < this.SYS_T; ++n4) {
            sArray[n4] = sArray4[n4];
        }
    }

    private static void sort32(int[] nArray, int n3, int n4) {
        if ((n4 -= n3) < 2) {
            return;
        }
        int n5 = 1;
        while (n5 < n4 - n5) {
            int n6 = n5;
            n5 = n6 + n6;
        }
        for (int i3 = n5; i3 > 0; i3 >>>= 1) {
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            for (n11 = 0; n11 < n4 - i3; ++n11) {
                if ((n11 & i3) != 0) continue;
                int[] nArray2 = nArray;
                n10 = n3 + n11;
                n9 = n10 + i3;
                n8 = nArray2[n9];
                n7 = nArray2[n10];
                int n12 = n10;
                n10 = n8 ^ n7;
                int n13 = n8 - n7;
                n10 = (n13 ^ n10 & (n13 ^ n8)) >> 31 & n10;
                nArray2[n12] = n7 ^ n10;
                nArray[n9] = nArray2[n9] ^ n10;
            }
            n11 = 0;
            for (n10 = n5; n10 > i3; n10 >>>= 1) {
                while (n11 < n4 - n10) {
                    if ((n11 & i3) == 0) {
                        n9 = n3 + n11;
                        n8 = n9 + i3;
                        n7 = nArray[n8];
                        int n14 = n10;
                        while (n14 > i3) {
                            int n15 = n14;
                            n14 = n9 + n14;
                            int n16 = nArray[n14];
                            int n17 = n14;
                            int n18 = n7;
                            int n19 = n7;
                            n7 = n16 ^ n7;
                            int n20 = n16 - n19;
                            n7 = (n20 ^ n7 & (n20 ^ n16)) >> 31 & n7;
                            n14 = n18 ^ n7;
                            nArray[n17] = n16 ^ n7;
                            int n21 = n7 = n15 >>> 1;
                            n7 = n14;
                            n14 = n21;
                        }
                        nArray[n8] = n7;
                    }
                    ++n11;
                }
            }
        }
    }

    private static void sort64(long[] lArray, int n3, int n4) {
        if ((n4 -= n3) < 2) {
            return;
        }
        int n5 = 1;
        while (n5 < n4 - n5) {
            int n6 = n5;
            n5 = n6 + n6;
        }
        for (int i3 = n5; i3 > 0; i3 >>>= 1) {
            int n7;
            int n8;
            int n9;
            for (n9 = 0; n9 < n4 - i3; ++n9) {
                if ((n9 & i3) != 0) continue;
                long[] lArray2 = lArray;
                n8 = n3 + n9;
                n7 = n8 + i3;
                long l3 = lArray2[n7];
                long l4 = lArray2[n8];
                l3 = -(l3 - l4 >>> 63) & (l4 ^ l3);
                lArray2[n8] = l4 ^ l3;
                lArray[n7] = l3 = lArray2[n7] ^ l3;
            }
            n9 = 0;
            for (n8 = n5; n8 > i3; n8 >>>= 1) {
                while (n9 < n4 - n8) {
                    if ((n9 & i3) == 0) {
                        n7 = n3 + n9;
                        int n10 = n7 + i3;
                        long l5 = lArray[n10];
                        int n11 = n8;
                        while (n11 > i3) {
                            int n12 = n11;
                            n11 = n7 + n11;
                            long l6 = lArray[n11];
                            long l7 = l5;
                            l5 = -(l6 - l5 >>> 63) & (l5 ^ l6);
                            long l8 = l7 ^ l5;
                            lArray[n11] = l6 ^ l5;
                            int n13 = n12 >>> 1;
                            l5 = l8;
                            n11 = n13;
                        }
                        lArray[n10] = l5;
                    }
                    ++n9;
                }
            }
        }
    }

    public int getIrrBytes() {
        return this.IRR_BYTES;
    }

    public int getCondBytes() {
        return this.COND_BYTES;
    }

    public int getPrivateKeySize() {
        CMCEEngine cMCEEngine = this;
        int n3 = cMCEEngine.COND_BYTES + this.IRR_BYTES;
        return cMCEEngine.SYS_N / 8 + n3 + 40;
    }

    public int getPublicKeySize() {
        if (this.usePadding) {
            CMCEEngine cMCEEngine = this;
            int n3 = cMCEEngine.PK_NROWS;
            return (cMCEEngine.SYS_N / 8 - (n3 - 1) / 8) * n3;
        }
        return this.PK_NROWS * this.PK_NCOLS / 8;
    }

    public int getCipherTextSize() {
        return this.SYND_BYTES + 32;
    }

    public byte[] generate_public_key_from_private_key(byte[] byArray) {
        SHAKEDigest sHAKEDigest;
        SHAKEDigest sHAKEDigest2;
        CMCEEngine cMCEEngine = this;
        byte[] byArray2 = new byte[cMCEEngine.getPublicKeySize()];
        int n3 = cMCEEngine.GFBITS;
        short[] sArray = new short[1 << n3];
        long[] lArray = new long[1];
        long[] lArray2 = lArray;
        lArray[0] = 0L;
        int[] nArray = new int[1 << n3];
        int n4 = (1 << n3) * 4 + cMCEEngine.SYS_N / 8;
        byte[] byArray3 = new byte[n4];
        n3 = n4 - 32 - this.IRR_BYTES - (1 << n3) * 4;
        SHAKEDigest sHAKEDigest3 = sHAKEDigest2 = sHAKEDigest;
        sHAKEDigest3(256);
        sHAKEDigest3.update((byte)64);
        sHAKEDigest2.update(byArray, 0, 32);
        sHAKEDigest.doFinal(byArray3, 0, n4);
        for (n4 = 0; n4 < 1 << this.GFBITS; ++n4) {
            nArray[n4] = Utils.load4(byArray3, n4 * 4 + n3);
        }
        this.pk_gen(byArray2, byArray, nArray, sArray, lArray2);
        return byArray2;
    }

    public byte[] decompress_private_key(byte[] byArray) {
        int n3;
        SHAKEDigest sHAKEDigest;
        CMCEEngine cMCEEngine = this;
        byte[] byArray2 = new byte[this.getPrivateKeySize()];
        int n4 = byArray.length;
        System.arraycopy(byArray, 0, byArray2, 0, n4);
        n4 = cMCEEngine.SYS_N / 8;
        n4 = (1 << cMCEEngine.GFBITS) * 4 + n4 + this.IRR_BYTES + 32;
        byte[] byArray3 = new byte[n4];
        Object object = sHAKEDigest;
        SHAKEDigest sHAKEDigest2 = object;
        sHAKEDigest2(256);
        sHAKEDigest2.update((byte)64);
        object.update(byArray, 0, 32);
        sHAKEDigest.doFinal(byArray3, 0, n4);
        if (byArray.length <= 40) {
            int n5;
            CMCEEngine cMCEEngine2 = this;
            object = new short[cMCEEngine2.SYS_T];
            int n6 = cMCEEngine2.IRR_BYTES;
            byte[] byArray4 = new byte[n6];
            n6 = n4 - 32 - n6;
            for (n5 = 0; n5 < this.SYS_T; ++n5) {
                int n7 = n5 * 2 + n6;
                object[n5] = Utils.load_gf(byArray3, n7, this.GFMASK);
            }
            this.generate_irr_poly((short[])object);
            for (n6 = 0; n6 < this.SYS_T; ++n6) {
                n5 = n6 * 2;
                Utils.store_gf(byArray4, n5, (short)object[n6]);
            }
            int n8 = this.IRR_BYTES;
            System.arraycopy(byArray4, 0, byArray2, 40, n8);
        }
        if (byArray.length <= (n3 = this.IRR_BYTES) + 40) {
            int n9;
            int n10 = n4;
            n4 = this.GFBITS;
            object = new int[1 << n4];
            short[] sArray = new short[1 << n4];
            n3 = n10 - 32 - n3 - (1 << n4) * 4;
            for (n4 = 0; n4 < 1 << (n9 = this.GFBITS); ++n4) {
                object[n4] = Utils.load4(byArray3, n4 * 4 + n3);
            }
            if (this.usePivots) {
                long[] lArray = new long[1];
                long[] lArray2 = lArray;
                lArray[0] = 0L;
                this.pk_gen(null, byArray2, (int[])object, sArray, lArray2);
            } else {
                n3 = 1 << n9;
                long[] lArray = new long[n3];
                for (n9 = 0; n9 < 1 << this.GFBITS; ++n9) {
                    long l3;
                    lArray[n9] = l3 = (long)object[n9];
                    lArray[n9] = l3 <<= 31;
                    lArray[n9] = l3 |= (long)n9;
                    lArray[n9] = l3 & Long.MAX_VALUE;
                }
                CMCEEngine.sort64(lArray, 0, n3);
                for (n3 = 0; n3 < 1 << this.GFBITS; ++n3) {
                    sArray[n3] = (short)(lArray[n3] & (long)this.GFMASK);
                }
            }
            n3 = this.COND_BYTES;
            byte[] byArray5 = new byte[n3];
            int n11 = this.GFBITS;
            long l4 = n11;
            long l5 = 1 << n11;
            CMCEEngine.controlbitsfrompermutation(byArray5, sArray, l4, l5);
            n11 = this.IRR_BYTES + 40;
            System.arraycopy(byArray5, 0, byArray2, n11, n3);
        }
        CMCEEngine cMCEEngine3 = this;
        int n12 = cMCEEngine3.getPrivateKeySize();
        int n13 = cMCEEngine3.SYS_N;
        n3 = n13 / 8;
        System.arraycopy(byArray3, 0, byArray2, n12 -= n13 / 8, n3);
        return byArray2;
    }

    public void kem_keypair(byte[] byArray, byte[] byArray2, SecureRandom secureRandom) {
        short[] sArray;
        int n3;
        SHAKEDigest sHAKEDigest;
        CMCEEngine cMCEEngine = this;
        int n4 = 1;
        byte[] byArray3 = new byte[1];
        byte[] byArray4 = byArray3;
        byte[] byArray5 = new byte[32];
        byArray3[0] = 64;
        secureRandom.nextBytes(byArray5);
        int n5 = cMCEEngine.SYS_N / 8;
        n5 = (1 << cMCEEngine.GFBITS) * 4 + n5;
        n5 = cMCEEngine.SYS_T * 2 + n5 + 32;
        byte[] byArray6 = new byte[n5];
        long[] lArray = new long[1];
        long[] lArray2 = lArray;
        lArray[0] = 0L;
        SHAKEDigest sHAKEDigest2 = sHAKEDigest;
        sHAKEDigest = new SHAKEDigest(256);
        byte[] byArray7 = byArray5;
        while (true) {
            int n6;
            int n7;
            int n8;
            sHAKEDigest2.update(byArray4, 0, n4);
            sHAKEDigest2.update(byArray5, 0, byArray5.length);
            sHAKEDigest2.doFinal(byArray6, 0, n5);
            int n9 = n8 = n5 - 32;
            byArray5 = Arrays.copyOfRange(byArray6, n9, n9 + 32);
            System.arraycopy(byArray7, 0, byArray2, 0, 32);
            byArray7 = Arrays.copyOfRange(byArray5, 0, 32);
            int n10 = this.SYS_T;
            short[] sArray2 = new short[n10];
            int n11 = n8 - n10 * 2;
            for (n7 = 0; n7 < this.SYS_T; ++n7) {
                n6 = n7 * 2 + n11;
                sArray2[n7] = Utils.load_gf(byArray6, n6, this.GFMASK);
            }
            if (this.generate_irr_poly(sArray2) == -1) continue;
            n7 = 40;
            n6 = 0;
            while (n6 < this.SYS_T) {
                int n12 = n6++;
                int n13 = n12 * 2 + n7;
                Utils.store_gf(byArray2, n13, sArray2[n12]);
            }
            n3 = this.GFBITS;
            int[] nArray = new int[1 << n3];
            n3 = n11 - (1 << n3) * 4;
            for (n7 = 0; n7 < 1 << (n6 = this.GFBITS); ++n7) {
                nArray[n7] = Utils.load4(byArray6, n7 * 4 + n3);
            }
            sArray = new short[1 << n6];
            if (this.pk_gen(byArray, byArray2, nArray, sArray, lArray2) != -1) break;
        }
        CMCEEngine cMCEEngine2 = this;
        int n14 = cMCEEngine2.COND_BYTES;
        byte[] byArray8 = new byte[n14];
        int n15 = this.GFBITS;
        long l3 = n15;
        long l4 = 1 << n15;
        CMCEEngine.controlbitsfrompermutation(byArray8, sArray, l3, l4);
        n15 = this.IRR_BYTES + 40;
        System.arraycopy(byArray8, 0, byArray2, n15, n14);
        int n16 = cMCEEngine2.SYS_N;
        n15 = n16;
        n14 = n3 - n15 / 8;
        n15 = byArray2.length - n15 / 8;
        n4 = n16 / 8;
        System.arraycopy(byArray6, n14, byArray2, n15, n4);
        if (!this.usePivots) {
            Utils.store8(byArray2, 32, 0xFFFFFFFFL);
        } else {
            long l5 = lArray2[0];
            Utils.store8(byArray2, 32, l5);
        }
    }

    public int kem_enc(byte[] byArray, byte[] byArray2, byte[] object, SecureRandom secureRandom) {
        SHAKEDigest sHAKEDigest;
        CMCEEngine cMCEEngine = this;
        int n3 = cMCEEngine.SYS_N / 8;
        byte[] byArray3 = new byte[n3];
        int n4 = 0;
        if (cMCEEngine.usePadding) {
            n4 = this.check_pk_padding((byte[])object);
        }
        CMCEEngine cMCEEngine2 = this;
        cMCEEngine2.encrypt(byArray, (byte[])object, byArray3, secureRandom);
        Object object2 = object = (Object)sHAKEDigest;
        Object object3 = object;
        ((SHAKEDigest)object3)(256);
        object3.update((byte)2);
        object.update(byArray3, 0, n3);
        object2.doFinal(byArray, this.SYND_BYTES, 32);
        object2.update((byte)1);
        object.update(byArray3, 0, n3);
        object.update(byArray, 0, byArray.length);
        sHAKEDigest.doFinal(byArray2, 0, byArray2.length);
        if (cMCEEngine2.usePadding) {
            byte by = (byte)((byte)n4 ^ 0xFF);
            for (int i3 = 0; i3 < this.SYND_BYTES + 32; ++i3) {
                byArray[i3] = (byte)(byArray[i3] & by);
            }
            for (int i4 = 0; i4 < 32; ++i4) {
                byArray2[i4] = (byte)(byArray2[i4] & by);
            }
            return n4;
        }
        return 0;
    }

    public int kem_dec(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        SHAKEDigest sHAKEDigest;
        int n3;
        SHAKEDigest sHAKEDigest2;
        SHAKEDigest sHAKEDigest3;
        CMCEEngine cMCEEngine = sHAKEDigest5;
        byte[] byArray4 = new byte[32];
        int n4 = cMCEEngine.SYS_N / 8;
        byte[] byArray5 = new byte[n4];
        int n5 = 0;
        if (cMCEEngine.usePadding) {
            n5 = ((CMCEEngine)((Object)sHAKEDigest5)).check_c_padding(byArray2);
        }
        byte by = (byte)((CMCEEngine)((Object)sHAKEDigest5)).decrypt(byArray5, byArray3, byArray2);
        SHAKEDigest sHAKEDigest4 = sHAKEDigest3 = sHAKEDigest2;
        sHAKEDigest4(256);
        sHAKEDigest4.update((byte)2);
        sHAKEDigest3.update(byArray5, 0, n4);
        sHAKEDigest2.doFinal(byArray4, 0, 32);
        n4 = 0;
        for (n3 = 0; n3 < 32; ++n3) {
            n4 = (byte)(n4 | byArray4[n3] ^ byArray2[((CMCEEngine)((Object)sHAKEDigest5)).SYND_BYTES + n3]);
        }
        CMCEEngine cMCEEngine2 = sHAKEDigest5;
        int n6 = (short)((short)((short)(by | n4) - 1) >> 8) & 0xFF;
        n4 = cMCEEngine2.SYS_N / 8 + 1;
        n4 = cMCEEngine2.SYND_BYTES + 32 + n4;
        byte[] byArray6 = new byte[n4];
        byte[] byArray7 = byArray6;
        byArray6[0] = (byte)(n6 & 1);
        n3 = 0;
        while (n3 < ((CMCEEngine)((Object)sHAKEDigest5)).SYS_N / 8) {
            int n7 = n3 + 1;
            byArray7[n7] = (byte)(~n6 & byArray3[n3 + 40 + ((CMCEEngine)((Object)sHAKEDigest5)).IRR_BYTES + ((CMCEEngine)((Object)sHAKEDigest5)).COND_BYTES] | n6 & byArray5[n3]);
            n3 = n7;
        }
        for (int i3 = 0; i3 < ((CMCEEngine)((Object)sHAKEDigest5)).SYND_BYTES + 32; ++i3) {
            n6 = ((CMCEEngine)((Object)sHAKEDigest5)).SYS_N / 8 + 1 + i3;
            byArray7[n6] = byArray2[i3];
        }
        CMCEEngine cMCEEngine3 = sHAKEDigest5;
        SHAKEDigest sHAKEDigest5 = sHAKEDigest;
        sHAKEDigest5(256);
        sHAKEDigest5.update(byArray7, 0, n4);
        sHAKEDigest.doFinal(byArray, 0, byArray.length);
        if (cMCEEngine3.usePadding) {
            byte by2 = (byte)n5;
            for (int i4 = 0; i4 < byArray.length; ++i4) {
                byArray[i4] = (byte)(byArray[i4] | by2);
            }
            return n5;
        }
        return 0;
    }

    public int check_pk_padding(byte[] byArray) {
        int n3 = 0;
        for (int i3 = 0; i3 < this.PK_NROWS; ++i3) {
            int n4 = n3;
            n3 = this.PK_ROW_BYTES;
            n3 = (byte)(n4 | byArray[i3 * n3 + n3 - 1]);
        }
        return (byte)(((byte)((byte)((n3 & 0xFF) >>> this.PK_NCOLS % 8) - 1) & 0xFF) >>> 7) - 1;
    }

    public int check_c_padding(byte[] byArray) {
        return (byte)(((byte)((byte)((byArray[this.SYND_BYTES - 1] & 0xFF) >>> this.PK_NROWS % 8) - 1) & 0xFF) >>> 7) - 1;
    }

    public int getDefaultSessionKeySize() {
        return this.defaultKeySize;
    }
}

