/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.cmce;

import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.cmce.CMCEEngine;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.cmce.CMCEKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.cmce.CMCEParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;

public class CMCEPrivateKeyParameters
extends CMCEKeyParameters {
    private final byte[] privateKey;

    public CMCEPrivateKeyParameters(CMCEParameters cMCEParameters, byte[] byArray) {
        super(true, cMCEParameters);
        this.privateKey = Arrays.clone(byArray);
    }

    public CMCEPrivateKeyParameters(CMCEParameters cMCEParameters, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5) {
        CMCEPrivateKeyParameters cMCEPrivateKeyParameters = object;
        super(true, cMCEParameters);
        byte[] byArray6 = new byte[byArray.length + byArray2.length + byArray3.length + byArray4.length + byArray5.length];
        Object object = byArray6;
        cMCEPrivateKeyParameters.privateKey = byArray6;
        int n3 = byArray.length;
        System.arraycopy(byArray, 0, object, 0, n3);
        n3 = byArray.length + 0;
        int n4 = byArray2.length;
        System.arraycopy(byArray2, 0, object, n3, n4);
        n4 = byArray3.length;
        System.arraycopy(byArray3, 0, object, n3 += byArray2.length, n4);
        n4 = byArray4.length;
        System.arraycopy(byArray4, 0, object, n3 += byArray3.length, n4);
        n4 = byArray5.length;
        System.arraycopy(byArray5, 0, object, n3 += byArray4.length, n4);
    }

    public byte[] getPrivateKey() {
        return Arrays.clone(this.privateKey);
    }

    public byte[] reconstructPublicKey() {
        CMCEEngine cMCEEngine = this.getParameters().getEngine();
        byte[] byArray = new byte[cMCEEngine.getPublicKeySize()];
        cMCEEngine.generate_public_key_from_private_key(this.privateKey);
        return byArray;
    }

    public byte[] getEncoded() {
        return Arrays.clone(this.privateKey);
    }

    public byte[] getDelta() {
        return Arrays.copyOfRange(this.privateKey, 0, 32);
    }

    public byte[] getC() {
        return Arrays.copyOfRange(this.privateKey, 32, 40);
    }

    public byte[] getG() {
        return Arrays.copyOfRange(this.privateKey, 40, this.getParameters().getT() * 2 + 40);
    }

    public byte[] getAlpha() {
        return Arrays.copyOfRange(this.privateKey, this.getParameters().getT() * 2 + 40, this.privateKey.length - 32);
    }

    public byte[] getS() {
        int n3 = this.privateKey.length - 32;
        return Arrays.copyOfRange(this.privateKey, n3, this.privateKey.length);
    }
}

