/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.frodo;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Xof;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.frodo.FrodoMatrixGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;
import java.security.SecureRandom;

class FrodoEngine {
    private static final int nbar = 8;
    private static final int mbar = 8;
    private static final int len_seedA = 128;
    private static final int len_z = 128;
    private static final int len_chi = 16;
    private static final int len_seedA_bytes = 16;
    private static final int len_z_bytes = 16;
    private static final int len_chi_bytes = 2;
    private final int D;
    private final int q;
    private final int n;
    private final int B;
    private final int len_sk_bytes;
    private final int len_pk_bytes;
    private final int len_ct_bytes;
    private final short[] T_chi;
    private final int len_mu;
    private final int len_seedSE;
    private final int len_s;
    private final int len_k;
    private final int len_pkh;
    private final int len_ss;
    private final int len_mu_bytes;
    private final int len_seedSE_bytes;
    private final int len_s_bytes;
    private final int len_k_bytes;
    private final int len_pkh_bytes;
    private final int len_ss_bytes;
    private final Xof digest;
    private final FrodoMatrixGenerator gen;

    public FrodoEngine(int n3, int n4, int n5, short[] sArray, Xof xof, FrodoMatrixGenerator frodoMatrixGenerator) {
        int n6;
        int n7 = n3;
        FrodoEngine frodoEngine = this;
        this.n = n3;
        frodoEngine.D = n4;
        frodoEngine.q = 1 << n4;
        this.B = n5;
        this.len_mu = n5 = n5 * 8 * 8;
        this.len_seedSE = n5;
        this.len_s = n5;
        this.len_k = n5;
        this.len_pkh = n5;
        this.len_ss = n5;
        this.len_mu_bytes = n5 / 8;
        this.len_seedSE_bytes = n5 / 8;
        int n8 = n5 / 8;
        FrodoEngine frodoEngine2 = this;
        int n9 = n4;
        this.len_s_bytes = n8;
        this.len_k_bytes = n5 / 8;
        this.len_pkh_bytes = n6 = n5 / 8;
        this.len_ss_bytes = n5 / 8;
        n3 = n9 * n3 * 8 / 8;
        frodoEngine2.len_ct_bytes = n9 * 8 * 8 / 8 + n3;
        frodoEngine2.len_pk_bytes = n3 += 16;
        n3 = n8 + n3;
        this.len_sk_bytes = n7 * 2 * 8 + n6 + n3;
        this.T_chi = sArray;
        this.digest = xof;
        this.gen = frodoMatrixGenerator;
    }

    private short sample(short s2) {
        int n3 = s2 & 0xFFFF;
        s2 = (short)n3;
        short s3 = (short)(n3 >>> 1);
        short s4 = 0;
        int n4 = 0;
        while (true) {
            short[] sArray = this.T_chi;
            if (n4 >= this.T_chi.length) break;
            if (s3 > sArray[n4]) {
                s4 = (short)(s4 + 1);
            }
            ++n4;
        }
        if (s2 % 2 == 1) {
            s4 = (short)(s4 * -1 & 0xFFFF);
        }
        return s4;
    }

    private short[] sample_matrix(short[] sArray, int n3, int n4, int n5) {
        short[] sArray2 = new short[n4 * n5];
        for (int i3 = 0; i3 < n4; ++i3) {
            for (int i4 = 0; i4 < n5; ++i4) {
                int n6 = i3 * n5 + i4;
                sArray2[n6] = this.sample(sArray[n6 + n3]);
            }
        }
        return sArray2;
    }

    private short[] matrix_transpose(short[] sArray, int n3, int n4) {
        Object object = new short[n3 * n4];
        for (int i3 = 0; i3 < n4; ++i3) {
            for (int i4 = 0; i4 < n3; ++i4) {
                int n5 = i3 * n3 + i4;
                object[n5] = sArray[i4 * n4 + i3];
            }
        }
        return object;
    }

    private short[] matrix_mul(short[] sArray, int n3, int n4, short[] sArray2, int n5, int n6) {
        short[] sArray3 = new short[n3 * n6];
        for (int i3 = 0; i3 < n3; ++i3) {
            for (int i4 = 0; i4 < n6; ++i4) {
                int n7;
                for (n7 = 0; n7 < n4; ++n7) {
                    int n8 = i3 * n6 + i4;
                    int n9 = sArray3[n8] & 0xFFFF;
                    sArray3[n8] = (short)((sArray[i3 * n4 + n7] & 0xFFFF) * (sArray2[n7 * n6 + i4] & 0xFFFF) + n9 & 0xFFFF);
                }
                n7 = i3 * n6 + i4;
                sArray3[n7] = (short)((sArray3[n7] & 0xFFFF) % this.q & 0xFFFF);
            }
        }
        return sArray3;
    }

    private short[] matrix_add(short[] sArray, short[] sArray2, int n3, int n4) {
        short[] sArray3 = new short[n3 * n4];
        for (int i3 = 0; i3 < n3; ++i3) {
            for (int i4 = 0; i4 < n4; ++i4) {
                int n5 = i3 * n4 + i4;
                sArray3[n5] = (short)(((sArray[n5] & 0xFFFF) + (sArray2[n5] & 0xFFFF)) % this.q);
            }
        }
        return sArray3;
    }

    private byte[] pack(short[] sArray) {
        int n3 = sArray.length;
        int n4 = this.D * n3 / 8;
        byte[] byArray = new byte[n4];
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        while (n5 < n4 && (n6 < n3 || n6 == n3 && n8 > 0)) {
            int n9 = 0;
            while (n9 < 8) {
                int n10 = n8;
                int n11 = 8 - n9;
                n8 = Math.min(n11, n8);
                short s2 = (short)((1 << n8) - 1);
                int n12 = n10 - n8;
                int n13 = n9;
                n9 = (byte)(n7 >> n12 & s2);
                byArray[n5] = (byte)(byArray[n5] + (n9 << n11 - n8));
                n9 = (byte)(n13 + n8);
                byte by = (byte)n12;
                n8 = by;
                if (by != 0) continue;
                if (n6 >= n3) break;
                int n14 = n6;
                n7 = sArray[n6];
                n6 = (byte)this.D;
                n8 = (short)(n14 + 1);
                int n15 = n6;
                n6 = n8;
                n8 = n15;
            }
            if (n9 != 8) continue;
            n5 = (short)(n5 + 1);
        }
        return byArray;
    }

    private short[] unpack(byte[] byArray, int n3, int n4) {
        short[] sArray = new short[n3 *= n4];
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        while (n5 < n3 && (n6 < byArray.length || n6 == byArray.length && n8 > 0)) {
            int n9;
            int n10 = 0;
            while (n10 < (n9 = this.D)) {
                int n11 = n8;
                n9 = Math.min(n9 - n10, n8);
                short s2 = (short)((1 << n9) - 1 & 0xFFFF);
                n8 = (byte)((n7 & 0xFF) >>> (n8 & 0xFF) - n9 & (s2 & 0xFFFF) & 0xFF);
                sArray[n5] = (short)((sArray[n5] & 0xFFFF) + ((n8 & 0xFF) << this.D - (n10 & 0xFF) - n9) & 0xFFFF);
                n10 = (byte)(n10 + n9);
                byte by = (byte)(n11 - n9);
                n8 = by;
                n7 = (byte)(n7 & ~(s2 << n8));
                if (by != 0) continue;
                if (n6 >= byArray.length) break;
                int n12 = n6;
                n6 = byArray[n6];
                n7 = 8;
                n8 = (short)(n12 + 1);
                int n13 = n6;
                n6 = n8;
                n8 = n7;
                n7 = n13;
            }
            if (n10 != this.D) continue;
            n5 = (short)(n5 + 1);
        }
        return sArray;
    }

    private short[] encode(byte[] byArray) {
        int n3 = 0;
        int n4 = 1;
        short[] sArray = new short[64];
        for (int i3 = 0; i3 < 8; ++i3) {
            for (int i4 = 0; i4 < 8; ++i4) {
                int n5;
                int n6 = 0;
                for (int i5 = 0; i5 < (n5 = this.B); ++i5) {
                    if ((byArray[n3] & n4) == n4) {
                        n6 += 1 << i5;
                    }
                    byte by = (byte)(n4 << 1);
                    n4 = by;
                    if (by != 0) continue;
                    n4 = 1;
                    ++n3;
                }
                sArray[i3 * 8 + i4] = (short)(this.q / (1 << n5) * n6);
            }
        }
        return sArray;
    }

    private short[] matrix_sub(short[] sArray, short[] sArray2, int n3, int n4) {
        short[] sArray3 = new short[n3 * n4];
        for (int i3 = 0; i3 < n3; ++i3) {
            for (int i4 = 0; i4 < n4; ++i4) {
                int n5 = i3 * n4 + i4;
                sArray3[n5] = (short)((sArray[n5] - sArray2[n5] & 0xFFFF) % this.q);
            }
        }
        return sArray3;
    }

    private byte[] decode(short[] sArray) {
        int n3 = 0;
        int n4 = 8;
        int n5 = 8;
        int n6 = this.B;
        int n7 = n6;
        n7 = (short)((1 << n7) - 1);
        short s2 = (short)((1 << this.D) - 1);
        byte[] byArray = new byte[n6 * n4];
        for (int i3 = 0; i3 < n5; ++i3) {
            int n8;
            int n9;
            long l3 = 0L;
            for (n9 = 0; n9 < n4; ++n9) {
                int n10 = this.D;
                int n11 = this.B;
                l3 |= (long)((short)((sArray[n3] & s2) + (1 << n10 - n11 - 1) >> n10 - n11) & n7) << n11 * n9;
                ++n3;
            }
            for (n9 = 0; n9 < (n8 = this.B); ++n9) {
                n8 = i3 * n8 + n9;
                byArray[n8] = (byte)(l3 >> n9 * 8 & 0xFFL);
            }
        }
        return byArray;
    }

    private short ctverify(short[] sArray, short[] sArray2, short[] sArray3, short[] sArray4) {
        int n3 = 0;
        for (int n4 = 0; n4 < sArray.length; n4 = (int)((short)(n4 + 1))) {
            n3 = (short)(n3 | sArray[n4] ^ sArray3[n4]);
        }
        for (int n5 = 0; n5 < sArray2.length; n5 = (int)((short)(n5 + 1))) {
            n3 = (short)(n3 | sArray2[n5] ^ sArray4[n5]);
        }
        if (n3 == 0) {
            return 0;
        }
        return -1;
    }

    private byte[] ctselect(byte[] byArray, byte[] byArray2, short s2) {
        Object object = new byte[byArray.length];
        for (int i3 = 0; i3 < byArray.length; ++i3) {
            object[i3] = (byte)(~s2 & byArray[i3] & 0xFF | s2 & byArray2[i3] & 0xFF);
        }
        return object;
    }

    public int getCipherTextSize() {
        return this.len_ct_bytes;
    }

    public int getSessionKeySize() {
        return this.len_ss_bytes;
    }

    public int getPrivateKeySize() {
        return this.len_sk_bytes;
    }

    public int getPublicKeySize() {
        return this.len_pk_bytes;
    }

    public void kem_keypair(byte[] byArray, byte[] byArray2, SecureRandom object) {
        FrodoEngine frodoEngine = this;
        byte[] byArray3 = new byte[frodoEngine.len_s_bytes + this.len_seedSE_bytes + 16];
        byte[] byArray4 = byArray3;
        ((SecureRandom)object).nextBytes(byArray4);
        object = Arrays.copyOfRange(byArray4, 0, this.len_s_bytes);
        int n3 = this.len_s_bytes;
        byArray4 = Arrays.copyOfRange(byArray4, n3, n3 + this.len_seedSE_bytes);
        int n4 = this.len_s_bytes;
        int n5 = this.len_seedSE_bytes;
        int n6 = n4 + n5;
        Object[] objectArray = Arrays.copyOfRange(byArray3, n6, n4 + n5 + 16);
        byte[] byArray5 = new byte[16];
        frodoEngine.digest.update((byte[])objectArray, 0, objectArray.length);
        frodoEngine.digest.doFinal(byArray5, 0, 16);
        objectArray = frodoEngine.gen.genMatrix(byArray5);
        int n7 = frodoEngine.n * 2 * 8 * 2;
        byte[] byArray6 = new byte[n7];
        frodoEngine.digest.update((byte)95);
        frodoEngine.digest.update(byArray4, 0, byArray4.length);
        frodoEngine.digest.doFinal(byArray6, 0, n7);
        int n8 = frodoEngine.n * 2 * 8;
        short[] sArray = new short[n8];
        for (int i3 = 0; i3 < n8; ++i3) {
            sArray[i3] = Pack.littleEndianToShort(byArray6, i3 * 2);
        }
        FrodoEngine frodoEngine2 = this;
        FrodoEngine frodoEngine3 = this;
        FrodoEngine frodoEngine4 = this;
        FrodoEngine frodoEngine5 = this;
        int n9 = this.n;
        short[] sArray2 = frodoEngine5.sample_matrix(sArray, 0, 8, n9);
        n8 = frodoEngine5.n;
        short[] sArray3 = frodoEngine5.matrix_transpose(sArray2, 8, n8);
        int n10 = frodoEngine5.n;
        Object[] objectArray2 = frodoEngine4.sample_matrix(sArray, n10 * 8, n10, 8);
        int n11 = frodoEngine4.n;
        sArray3 = frodoEngine3.matrix_mul((short[])objectArray, n11, n11, sArray3, n11, 8);
        int n12 = frodoEngine3.n;
        int n13 = this.len_pk_bytes;
        System.arraycopy(Arrays.concatenate(byArray5, frodoEngine3.pack(frodoEngine3.matrix_add(sArray3, (short[])objectArray2, n12, 8))), 0, byArray, 0, n13);
        n13 = frodoEngine2.len_pkh_bytes;
        objectArray2 = new byte[n13];
        frodoEngine2.digest.update(byArray, 0, byArray.length);
        frodoEngine2.digest.doFinal((byte[])objectArray2, 0, n13);
        int n14 = this.len_s_bytes + this.len_pk_bytes;
        System.arraycopy(Arrays.concatenate((byte[])object, byArray), 0, byArray2, 0, n14);
        for (n14 = 0; n14 < 8; ++n14) {
            for (n13 = 0; n13 < (n12 = this.n); ++n13) {
                byte[] byArray7 = Pack.shortToLittleEndian(sArray2[n14 * n12 + n13]);
                FrodoEngine frodoEngine6 = this;
                n12 = frodoEngine6.len_s_bytes + this.len_pk_bytes;
                n12 = n14 * frodoEngine6.n * 2 + n12;
                n12 = n13 * 2 + n12;
                System.arraycopy(byArray7, 0, byArray2, n12, 2);
            }
        }
        int n15 = this.len_pkh_bytes;
        n14 = this.len_sk_bytes - n15;
        System.arraycopy(objectArray2, 0, byArray2, n14, n15);
    }

    public void kem_enc(byte[] byArray, byte[] byArray2, byte[] byArray3, SecureRandom object) {
        int n3;
        FrodoEngine frodoEngine = this;
        SecureRandom secureRandom = object;
        object = Arrays.copyOfRange(byArray3, 0, 16);
        Object[] objectArray = Arrays.copyOfRange(byArray3, 16, this.len_pk_bytes);
        byte[] byArray4 = new byte[this.len_mu_bytes];
        secureRandom.nextBytes(byArray4);
        byte[] byArray5 = new byte[frodoEngine.len_pkh_bytes];
        frodoEngine.digest.update(byArray3, 0, this.len_pk_bytes);
        frodoEngine.digest.doFinal(byArray5, 0, this.len_pkh_bytes);
        byte[] byArray6 = new byte[frodoEngine.len_seedSE + this.len_k];
        byArray3 = byArray6;
        FrodoEngine frodoEngine2 = this;
        frodoEngine2.digest.update(byArray5, 0, this.len_pkh_bytes);
        frodoEngine2.digest.update(byArray4, 0, this.len_mu_bytes);
        frodoEngine2.digest.doFinal(byArray3, 0, this.len_seedSE_bytes + this.len_k_bytes);
        byArray3 = Arrays.copyOfRange(byArray3, 0, frodoEngine2.len_seedSE_bytes);
        int n4 = this.len_seedSE_bytes;
        byArray5 = Arrays.copyOfRange(byArray6, n4, n4 + this.len_k_bytes);
        int n5 = (frodoEngine.n * 16 + 64) * 2;
        FrodoEngine frodoEngine3 = this;
        byte[] byArray7 = new byte[n5];
        frodoEngine3.digest.update((byte)-106);
        frodoEngine3.digest.update(byArray3, 0, byArray3.length);
        frodoEngine3.digest.doFinal(byArray7, 0, n5);
        int n6 = n5 / 2;
        short[] sArray = new short[n6];
        for (n3 = 0; n3 < n6; ++n3) {
            sArray[n3] = Pack.littleEndianToShort(byArray7, n3 * 2);
        }
        FrodoEngine frodoEngine4 = this;
        FrodoEngine frodoEngine5 = this;
        n6 = this.n;
        Object[] objectArray2 = frodoEngine5.sample_matrix(sArray, 0, 8, n6);
        int n7 = frodoEngine5.n;
        short[] sArray2 = frodoEngine4.sample_matrix(sArray, n7 * 8, 8, n7);
        object = frodoEngine4.gen.genMatrix((byte[])object);
        int n8 = n3 = frodoEngine4.n;
        object = frodoEngine4.matrix_mul((short[])objectArray2, 8, n3, (short[])object, n8, n8);
        n3 = frodoEngine4.n;
        byte[] byArray8 = frodoEngine4.pack(frodoEngine4.matrix_add((short[])object, sArray2, 8, n3));
        object = byArray8;
        FrodoEngine frodoEngine6 = this;
        FrodoEngine frodoEngine7 = this;
        short[] sArray3 = objectArray2;
        FrodoEngine frodoEngine8 = this;
        FrodoEngine frodoEngine9 = this;
        objectArray2 = frodoEngine9.sample_matrix(sArray, this.n * 16, 8, 8);
        objectArray = frodoEngine8.unpack((byte[])objectArray, frodoEngine9.n, 8);
        int n9 = frodoEngine8.n;
        objectArray2 = frodoEngine7.matrix_add(frodoEngine7.matrix_mul(sArray3, 8, n9, (short[])objectArray, n9, 8), (short[])objectArray2, 8, 8);
        byte[] byArray9 = frodoEngine6.pack(frodoEngine6.matrix_add((short[])objectArray2, frodoEngine6.encode(byArray4), 8, 8));
        objectArray2 = byArray9;
        int n10 = this.len_ct_bytes;
        System.arraycopy(Arrays.concatenate(byArray8, byArray9), 0, byArray, 0, n10);
        Object object2 = object;
        frodoEngine4.digest.update((byte[])object2, 0, ((Object)object2).length);
        frodoEngine4.digest.update((byte[])objectArray2, 0, objectArray2.length);
        frodoEngine4.digest.update(byArray5, 0, this.len_k_bytes);
        frodoEngine4.digest.doFinal(byArray2, 0, this.len_s_bytes);
    }

    public void kem_dec(byte[] byArray, byte[] byArray2, byte[] objectArray) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = this.n * 8 * this.D / 8 + 0;
        byte[] byArray3 = Arrays.copyOfRange(byArray2, 0, n7);
        byte[] byArray4 = Arrays.copyOfRange(byArray2, n7, this.D * 64 / 8 + n7);
        int n8 = this.len_s_bytes + 0;
        Object[] objectArray2 = Arrays.copyOfRange(objectArray, 0, n8);
        int n9 = n8;
        n8 = n9 + 16;
        byte[] byArray5 = Arrays.copyOfRange(objectArray, n9, n8);
        int n10 = n8;
        n8 = this.D * this.n * 8 / 8 + n8;
        byte[] byArray6 = Arrays.copyOfRange(objectArray, n10, n8);
        int n11 = n8;
        n8 = this.n * 8 * 16 / 8 + n8;
        Object[] objectArray3 = Arrays.copyOfRange(objectArray, n11, n8);
        short[] sArray = new short[this.n * 8];
        for (n6 = 0; n6 < 8; ++n6) {
            int n12;
            for (n5 = 0; n5 < (n12 = this.n); ++n5) {
                int n13 = n12;
                n12 = n6 * n12 + n5;
                n4 = n6 * n13 * 2;
                sArray[n12] = Pack.littleEndianToShort(objectArray3, n5 * 2 + n4);
            }
        }
        FrodoEngine frodoEngine = this;
        byte[] byArray7 = objectArray;
        int n14 = n8;
        FrodoEngine frodoEngine2 = this;
        objectArray = frodoEngine2.matrix_transpose(sArray, 8, this.n);
        byte[] byArray8 = Arrays.copyOfRange(byArray7, n14, n14 + frodoEngine2.len_pkh_bytes);
        objectArray3 = this.unpack(byArray3, 8, this.n);
        sArray = frodoEngine.unpack(byArray4, 8, 8);
        n6 = frodoEngine.n;
        objectArray = frodoEngine.decode(frodoEngine.matrix_sub(sArray, frodoEngine.matrix_mul((short[])objectArray3, 8, n6, (short[])objectArray, n6, 8), 8, 8));
        byte[] byArray9 = new byte[frodoEngine.len_seedSE_bytes + this.len_k_bytes];
        FrodoEngine frodoEngine3 = this;
        frodoEngine3.digest.update(byArray8, 0, this.len_pkh_bytes);
        frodoEngine3.digest.update((byte[])objectArray, 0, this.len_mu_bytes);
        frodoEngine3.digest.doFinal(byArray9, 0, this.len_seedSE_bytes + this.len_k_bytes);
        int n15 = frodoEngine3.len_seedSE_bytes;
        byArray8 = Arrays.copyOfRange(byArray9, n15, n15 + this.len_k_bytes);
        n5 = (frodoEngine.n * 16 + 64) * 2;
        byte[] byArray10 = new byte[n5];
        frodoEngine.digest.update((byte)-106);
        frodoEngine.digest.update(byArray9, 0, this.len_seedSE_bytes);
        frodoEngine.digest.doFinal(byArray10, 0, n5);
        int n16 = frodoEngine.n * 16 + 64;
        short[] sArray2 = new short[n16];
        for (n4 = 0; n4 < n16; ++n4) {
            sArray2[n4] = Pack.littleEndianToShort(byArray10, n4 * 2);
        }
        FrodoEngine frodoEngine4 = this;
        byte[] byArray11 = objectArray2;
        FrodoEngine frodoEngine5 = this;
        FrodoEngine frodoEngine6 = this;
        FrodoEngine frodoEngine7 = this;
        FrodoEngine frodoEngine8 = this;
        FrodoEngine frodoEngine9 = this;
        int n17 = this.n;
        Object[] objectArray4 = frodoEngine9.sample_matrix(sArray2, 0, 8, n17);
        int n18 = frodoEngine9.n;
        short[] sArray3 = frodoEngine8.sample_matrix(sArray2, n18 * 8, 8, n18);
        objectArray2 = frodoEngine8.gen.genMatrix(byArray5);
        int n19 = n3 = frodoEngine8.n;
        objectArray2 = frodoEngine8.matrix_mul((short[])objectArray4, 8, n3, (short[])objectArray2, n19, n19);
        n3 = frodoEngine8.n;
        sArray3 = frodoEngine8.matrix_add((short[])objectArray2, sArray3, 8, n3);
        objectArray2 = frodoEngine7.sample_matrix(sArray2, frodoEngine8.n * 16, 8, 8);
        short[] sArray4 = frodoEngine6.unpack(byArray6, frodoEngine7.n, 8);
        int n20 = frodoEngine6.n;
        objectArray4 = frodoEngine6.matrix_add(frodoEngine6.matrix_mul((short[])objectArray4, 8, n20, sArray4, n20, 8), (short[])objectArray2, 8, 8);
        objectArray4 = frodoEngine4.ctselect(byArray8, byArray11, this.ctverify((short[])objectArray3, sArray, sArray3, frodoEngine5.matrix_add((short[])objectArray4, frodoEngine5.encode((byte[])objectArray), 8, 8)));
        frodoEngine4.digest.update(byArray3, 0, byArray3.length);
        frodoEngine4.digest.update(byArray4, 0, byArray4.length);
        frodoEngine4.digest.update((byte[])objectArray4, 0, objectArray4.length);
        frodoEngine4.digest.doFinal(byArray, 0, this.len_ss_bytes);
    }
}

