/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.frodo;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BufferedBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHAKEDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.AESEngine;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Exceptions;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

abstract class FrodoMatrixGenerator {
    public int n;
    public int q;

    public FrodoMatrixGenerator(int n3, int n4) {
        this.n = n3;
        this.q = n4;
    }

    public abstract short[] genMatrix(byte[] var1);

    public static class Aes128MatrixGenerator
    extends FrodoMatrixGenerator {
        public BufferedBlockCipher cipher;

        public Aes128MatrixGenerator(int n3, int n4) {
            super(n3, n4);
            AESEngine aESEngine;
            BufferedBlockCipher bufferedBlockCipher;
            BufferedBlockCipher bufferedBlockCipher2 = bufferedBlockCipher;
            AESEngine aESEngine2 = aESEngine;
            aESEngine = new AESEngine();
            bufferedBlockCipher = new BufferedBlockCipher(aESEngine2);
            v2.cipher = bufferedBlockCipher2;
        }

        @Override
        public short[] genMatrix(byte[] byArray) {
            int n3 = this.n;
            short[] sArray = new short[n3 * n3];
            byte[] byArray2 = new byte[16];
            byte[] byArray3 = new byte[16];
            for (int i3 = 0; i3 < this.n; ++i3) {
                for (int i4 = 0; i4 < this.n; i4 += 8) {
                    System.arraycopy(Pack.shortToLittleEndian((short)(i3 & 0xFFFF)), 0, byArray2, 0, 2);
                    System.arraycopy(Pack.shortToLittleEndian((short)(i4 & 0xFFFF)), 0, byArray2, 2, 2);
                    this.aes128(byArray3, byArray, byArray2);
                    for (int i5 = 0; i5 < 8; ++i5) {
                        int n4 = i3 * this.n + i4 + i5;
                        sArray[n4] = (short)(Pack.littleEndianToShort(byArray3, i5 * 2) % this.q);
                    }
                }
            }
            return sArray;
        }

        public void aes128(byte[] byArray, byte[] byArray2, byte[] byArray3) {
            KeyParameter keyParameter;
            Aes128MatrixGenerator aes128MatrixGenerator;
            Aes128MatrixGenerator aes128MatrixGenerator2;
            Aes128MatrixGenerator aes128MatrixGenerator3;
            try {
                Aes128MatrixGenerator aes128MatrixGenerator4 = keyParameter2;
                aes128MatrixGenerator3 = aes128MatrixGenerator4;
                aes128MatrixGenerator2 = aes128MatrixGenerator4;
                aes128MatrixGenerator = aes128MatrixGenerator4;
            }
            catch (InvalidCipherTextException invalidCipherTextException) {
                throw Exceptions.illegalStateException(((Object)invalidCipherTextException).toString(), invalidCipherTextException);
            }
            KeyParameter keyParameter2 = keyParameter;
            keyParameter = new KeyParameter(byArray2);
            aes128MatrixGenerator2.cipher.init(true, keyParameter2);
            BufferedBlockCipher bufferedBlockCipher = aes128MatrixGenerator.cipher;
            int n3 = 0;
            n3 = bufferedBlockCipher.processBytes(byArray3, n3, byArray3.length, byArray, 0);
            aes128MatrixGenerator3.cipher.doFinal(byArray, n3);
        }
    }

    public static class Shake128MatrixGenerator
    extends FrodoMatrixGenerator {
        public Shake128MatrixGenerator(int n3, int n4) {
            super(n3, n4);
        }

        @Override
        public short[] genMatrix(byte[] byArray) {
            int n3 = this.n;
            short[] sArray = new short[n3 * n3];
            int n4 = n3 * 16 / 8;
            byte[] byArray2 = new byte[n4];
            for (short s2 = 0; s2 < this.n; s2 = (short)(s2 + 1)) {
                int n5;
                SHAKEDigest sHAKEDigest;
                byte[] byArray3 = Arrays.concatenate(Pack.shortToLittleEndian(s2), byArray);
                SHAKEDigest sHAKEDigest2 = sHAKEDigest;
                sHAKEDigest2(128);
                sHAKEDigest2.update(byArray3, 0, byArray3.length);
                sHAKEDigest.doFinal(byArray2, 0, n4);
                int n6 = 0;
                while (n6 < (n5 = this.n)) {
                    int n7 = n6;
                    int n8 = n6;
                    n6 = s2 * n5 + n6;
                    sArray[n6] = (short)(Pack.littleEndianToShort(byArray2, n8 * 2) % this.q);
                    n6 = (short)(n7 + 1);
                }
            }
            return sArray;
        }
    }
}

