/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.KeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.GMSSDigestProvider;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.GMSSKeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.GMSSParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.GMSSPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.GMSSPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.GMSSRootCalc;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.Treehash;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.util.GMSSRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.util.WinternitzOTSVerify;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.util.WinternitzOTSignature;
import java.security.SecureRandom;
import java.util.Vector;

public class GMSSKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    public static final String OID = "1.3.6.1.4.1.8301.3.1.3.3";
    private GMSSRandom gmssRandom;
    private Digest messDigestTree;
    private byte[][] currentSeeds;
    private byte[][] nextNextSeeds;
    private byte[][] currentRootSigs;
    private GMSSDigestProvider digestProvider;
    private int mdLength;
    private int numLayer;
    private boolean initialized;
    private GMSSParameters gmssPS;
    private int[] heightOfTrees;
    private int[] otsIndex;
    private int[] K;
    private GMSSKeyGenerationParameters gmssParams;

    public GMSSKeyPairGenerator(GMSSDigestProvider object) {
        GMSSKeyPairGenerator gMSSKeyPairGenerator = this;
        this.initialized = false;
        this.digestProvider = object;
        object = object.get();
        gMSSKeyPairGenerator.messDigestTree = object;
        gMSSKeyPairGenerator.mdLength = object.getDigestSize();
        gMSSKeyPairGenerator.gmssRandom = new GMSSRandom(this.messDigestTree);
    }

    private AsymmetricCipherKeyPair genKeyPair() {
        GMSSPrivateKeyParameters gMSSPrivateKeyParameters;
        GMSSPublicKeyParameters gMSSPublicKeyParameters;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        if (!((GMSSKeyPairGenerator)object7).initialized) {
            ((GMSSKeyPairGenerator)object7).initializeDefault();
        }
        int n8 = ((GMSSKeyPairGenerator)object7).numLayer;
        byte[][][] byArrayArray = new byte[n8][][];
        byte[][][] byArrayArray2 = new byte[n8 - 1][][];
        Treehash[][] treehashArray = new Treehash[n8][];
        Treehash[][] treehashArray2 = new Treehash[n8 - 1][];
        Vector[] vectorArray = new Vector[n8];
        Vector[] vectorArray2 = new Vector[n8 - 1];
        Vector[][] vectorArray3 = new Vector[n8][];
        Vector[][] vectorArray4 = new Vector[n8 - 1][];
        for (n7 = 0; n7 < (n6 = ((GMSSKeyPairGenerator)object7).numLayer); ++n7) {
            Vector vector;
            Vector vector2;
            n6 = ((GMSSKeyPairGenerator)object7).heightOfTrees[n7];
            int n9 = ((GMSSKeyPairGenerator)object7).mdLength;
            byArrayArray[n7] = new byte[n6][n9];
            n5 = ((GMSSKeyPairGenerator)object7).K[n7];
            treehashArray[n7] = new Treehash[n6 - n5];
            if (n7 > 0) {
                int n10 = n6;
                int n11 = n6;
                n6 = n7 - 1;
                byArrayArray2[n6] = new byte[n11][n9];
                treehashArray2[n6] = new Treehash[n10 - n5];
            }
            Vector vector3 = vector2;
            vector2 = new Vector();
            vectorArray[n7] = vector3;
            if (n7 <= 0) continue;
            int n12 = n7 - 1;
            Vector vector4 = vector;
            vector = new Vector();
            vectorArray2[n12] = vector4;
        }
        int n13 = n6;
        n7 = ((GMSSKeyPairGenerator)object7).mdLength;
        Object object = new byte[n13][n7];
        byte[][] byArray = new byte[n13 - 1][n7];
        Object object2 = new byte[n13][n7];
        for (n5 = 0; n5 < (n4 = ((GMSSKeyPairGenerator)object7).numLayer); ++n5) {
            byte[] byArray2 = object2[n5];
            n3 = ((GMSSKeyPairGenerator)object7).mdLength;
            System.arraycopy(((GMSSKeyPairGenerator)object7).currentSeeds[n5], 0, byArray2, 0, n3);
        }
        ((GMSSKeyPairGenerator)object7).currentRootSigs = new byte[n4 - 1][((GMSSKeyPairGenerator)object7).mdLength];
        for (n5 = n4 - 1; n5 >= 0; --n5) {
            byte[] byArray3;
            Object object3;
            Object object4;
            if (n5 == ((GMSSKeyPairGenerator)object7).numLayer - 1) {
                object4 = vectorArray[n5];
                object3 = object2[n5];
                object4 = ((GMSSKeyPairGenerator)object7).generateCurrentAuthpathAndRoot(null, (Vector)object4, (byte[])object3, n5);
            } else {
                object4 = object[n5 + 1];
                object3 = vectorArray[n5];
                byArray3 = object2[n5];
                object4 = ((GMSSKeyPairGenerator)object7).generateCurrentAuthpathAndRoot((byte[])object4, (Vector)object3, byArray3, n5);
            }
            for (n3 = 0; n3 < ((GMSSKeyPairGenerator)object7).heightOfTrees[n5]; ++n3) {
                byArray3 = byArrayArray[n5][n3];
                int n14 = ((GMSSKeyPairGenerator)object7).mdLength;
                System.arraycopy(((GMSSRootCalc)object4).getAuthPath()[n3], 0, byArray3, 0, n14);
            }
            vectorArray3[n5] = ((GMSSRootCalc)object4).getRetain();
            treehashArray[n5] = ((GMSSRootCalc)object4).getTreehash();
            byte[] byArray4 = ((GMSSRootCalc)object4).getRoot();
            object4 = object[n5];
            n3 = ((GMSSKeyPairGenerator)object7).mdLength;
            System.arraycopy(byArray4, 0, object4, 0, n3);
        }
        for (n5 = ((GMSSKeyPairGenerator)object7).numLayer - 2; n5 >= 0; --n5) {
            Object object5 = vectorArray2[n5];
            n3 = n5 + 1;
            object5 = ((GMSSKeyPairGenerator)object7).generateNextAuthpathAndRoot((Vector)object5, object2[n3], n3);
            for (int i3 = 0; i3 < ((GMSSKeyPairGenerator)object7).heightOfTrees[n3]; ++i3) {
                byte[] byArray5 = byArrayArray2[n5][i3];
                int n15 = ((GMSSKeyPairGenerator)object7).mdLength;
                System.arraycopy(((GMSSRootCalc)object5).getAuthPath()[i3], 0, byArray5, 0, n15);
            }
            int n16 = n3;
            vectorArray4[n5] = ((GMSSRootCalc)object5).getRetain();
            treehashArray2[n5] = ((GMSSRootCalc)object5).getTreehash();
            byte[] byArray6 = ((GMSSRootCalc)object5).getRoot();
            object5 = byArray[n5];
            n3 = ((GMSSKeyPairGenerator)object7).mdLength;
            System.arraycopy(byArray6, 0, object5, 0, n3);
            Object object6 = object7;
            object5 = ((GMSSKeyPairGenerator)object6).nextNextSeeds[n5];
            n3 = ((GMSSKeyPairGenerator)object6).mdLength;
            System.arraycopy(object2[n16], 0, object5, 0, n3);
        }
        object2 = gMSSPublicKeyParameters;
        object = object[0];
        gMSSPublicKeyParameters = new GMSSPublicKeyParameters((byte[])object, ((GMSSKeyPairGenerator)object7).gmssPS);
        object = gMSSPrivateKeyParameters;
        GMSSKeyPairGenerator gMSSKeyPairGenerator = object7;
        Object object7 = gMSSKeyPairGenerator.currentSeeds;
        byte[][] byArray7 = gMSSKeyPairGenerator.nextNextSeeds;
        byte[][] byArray8 = gMSSKeyPairGenerator.currentRootSigs;
        GMSSParameters gMSSParameters = gMSSKeyPairGenerator.gmssPS;
        GMSSDigestProvider gMSSDigestProvider = gMSSKeyPairGenerator.digestProvider;
        gMSSPrivateKeyParameters = new GMSSPrivateKeyParameters((byte[][])object7, byArray7, byArrayArray, byArrayArray2, treehashArray, treehashArray2, vectorArray, vectorArray2, vectorArray3, vectorArray4, byArray, byArray8, gMSSParameters, gMSSDigestProvider);
        return new AsymmetricCipherKeyPair((AsymmetricKeyParameter)object2, (AsymmetricKeyParameter)object);
    }

    private GMSSRootCalc generateCurrentAuthpathAndRoot(byte[] object, Vector vector, byte[] byArray, int n3) {
        GMSSRootCalc gMSSRootCalc;
        GMSSKeyPairGenerator gMSSKeyPairGenerator = this;
        int n4 = gMSSKeyPairGenerator.mdLength;
        byte[] cfr_ignored_0 = new byte[n4];
        byte[] cfr_ignored_1 = new byte[n4];
        Object object2 = gMSSKeyPairGenerator.gmssRandom.nextSeed(byArray);
        GMSSRootCalc gMSSRootCalc2 = gMSSRootCalc;
        GMSSKeyPairGenerator gMSSKeyPairGenerator2 = this;
        int n5 = gMSSKeyPairGenerator2.heightOfTrees[n3];
        int n6 = gMSSKeyPairGenerator2.K[n3];
        GMSSDigestProvider gMSSDigestProvider = gMSSKeyPairGenerator2.digestProvider;
        gMSSRootCalc2(n5, n6, gMSSDigestProvider);
        gMSSRootCalc.initialize(vector);
        if (n3 == gMSSKeyPairGenerator.numLayer - 1) {
            GMSSKeyPairGenerator gMSSKeyPairGenerator3 = this;
            object = gMSSKeyPairGenerator3.digestProvider.get();
            object = new WinternitzOTSignature((byte[])object2, (Digest)object, gMSSKeyPairGenerator3.otsIndex[n3]).getPublicKey();
        } else {
            WinternitzOTSVerify winternitzOTSVerify;
            WinternitzOTSignature winternitzOTSignature;
            Object object3 = winternitzOTSignature;
            byte[] byArray2 = object2;
            GMSSKeyPairGenerator gMSSKeyPairGenerator4 = this;
            object2 = gMSSKeyPairGenerator4.digestProvider.get();
            winternitzOTSignature = new WinternitzOTSignature(byArray2, (Digest)object2, gMSSKeyPairGenerator4.otsIndex[n3]);
            this.currentRootSigs[n3] = ((WinternitzOTSignature)object3).getSignature((byte[])object);
            object3 = winternitzOTSVerify;
            ((WinternitzOTSVerify)object3)(this.digestProvider.get(), this.otsIndex[n3]);
            object = winternitzOTSVerify.Verify((byte[])object, this.currentRootSigs[n3]);
        }
        gMSSRootCalc2.update((byte[])object);
        int n7 = 3;
        int n8 = 0;
        for (int i3 = 1; i3 < 1 << (n6 = this.heightOfTrees[n3]); ++i3) {
            Object object4;
            if (i3 == n7 && n8 < n6 - this.K[n3]) {
                gMSSRootCalc2.initializeTreehashSeed(byArray, n8);
                n7 *= 2;
                ++n8;
            }
            byte[] byArray3 = object4 = this.gmssRandom.nextSeed(byArray);
            GMSSKeyPairGenerator gMSSKeyPairGenerator5 = this;
            object4 = gMSSKeyPairGenerator5.digestProvider.get();
            gMSSRootCalc2.update(new WinternitzOTSignature(byArray3, (Digest)object4, gMSSKeyPairGenerator5.otsIndex[n3]).getPublicKey());
        }
        if (gMSSRootCalc2.wasFinished()) {
            return gMSSRootCalc2;
        }
        System.err.println("Baum noch nicht fertig konstruiert!!!");
        return null;
    }

    private GMSSRootCalc generateNextAuthpathAndRoot(Vector vector, byte[] byArray, int n3) {
        int n4;
        GMSSRootCalc gMSSRootCalc;
        byte[] cfr_ignored_0 = new byte[this.numLayer];
        GMSSRootCalc gMSSRootCalc2 = gMSSRootCalc;
        GMSSKeyPairGenerator gMSSKeyPairGenerator = this;
        int n5 = gMSSKeyPairGenerator.heightOfTrees[n3];
        int n6 = gMSSKeyPairGenerator.K[n3];
        GMSSDigestProvider gMSSDigestProvider = gMSSKeyPairGenerator.digestProvider;
        gMSSRootCalc2(n5, n6, gMSSDigestProvider);
        gMSSRootCalc.initialize(vector);
        n5 = 3;
        n6 = 0;
        for (int i3 = 0; i3 < 1 << (n4 = this.heightOfTrees[n3]); ++i3) {
            Object object;
            if (i3 == n5 && n6 < n4 - this.K[n3]) {
                gMSSRootCalc2.initializeTreehashSeed(byArray, n6);
                n5 *= 2;
                ++n6;
            }
            byte[] byArray2 = object = this.gmssRandom.nextSeed(byArray);
            GMSSKeyPairGenerator gMSSKeyPairGenerator2 = this;
            object = gMSSKeyPairGenerator2.digestProvider.get();
            gMSSRootCalc2.update(new WinternitzOTSignature(byArray2, (Digest)object, gMSSKeyPairGenerator2.otsIndex[n3]).getPublicKey());
        }
        if (gMSSRootCalc2.wasFinished()) {
            return gMSSRootCalc2;
        }
        System.err.println("N\ufffdchster Baum noch nicht fertig konstruiert!!!");
        return null;
    }

    private void initializeDefault() {
        GMSSParameters gMSSParameters;
        GMSSKeyGenerationParameters gMSSKeyGenerationParameters;
        GMSSKeyPairGenerator gMSSKeyPairGenerator = object;
        int[] nArray = new int[4];
        Object object = nArray;
        nArray[0] = 10;
        nArray[1] = 10;
        nArray[2] = 10;
        nArray[3] = 10;
        int[] nArray2 = new int[4];
        int[] nArray3 = nArray2;
        nArray2[0] = 3;
        nArray2[1] = 3;
        nArray2[2] = 3;
        nArray2[3] = 3;
        int[] nArray4 = new int[4];
        int[] nArray5 = nArray4;
        nArray4[0] = 2;
        nArray4[1] = 2;
        nArray4[2] = 2;
        nArray4[3] = 2;
        GMSSKeyGenerationParameters gMSSKeyGenerationParameters2 = gMSSKeyGenerationParameters;
        GMSSParameters gMSSParameters2 = gMSSParameters;
        gMSSParameters = new GMSSParameters(4, (int[])object, nArray3, nArray5);
        gMSSKeyGenerationParameters = new GMSSKeyGenerationParameters(null, gMSSParameters2);
        gMSSKeyPairGenerator.initialize(gMSSKeyGenerationParameters2);
    }

    public void initialize(int n3, SecureRandom secureRandom) {
        GMSSKeyGenerationParameters gMSSKeyGenerationParameters;
        if (n3 <= 10) {
            GMSSParameters gMSSParameters;
            GMSSKeyGenerationParameters gMSSKeyGenerationParameters2;
            int[] nArray = new int[1];
            int[] nArray2 = nArray;
            nArray[0] = 10;
            int[] nArray3 = new int[1];
            int[] nArray4 = nArray3;
            nArray3[0] = 3;
            int[] nArray5 = new int[1];
            int[] nArray6 = nArray5;
            nArray5[0] = 2;
            gMSSKeyGenerationParameters = gMSSKeyGenerationParameters2;
            GMSSParameters gMSSParameters2 = gMSSParameters;
            gMSSParameters = new GMSSParameters(1, nArray2, nArray4, nArray6);
            gMSSKeyGenerationParameters2 = new GMSSKeyGenerationParameters(secureRandom, gMSSParameters2);
        } else if (n3 <= 20) {
            GMSSParameters gMSSParameters;
            GMSSKeyGenerationParameters gMSSKeyGenerationParameters3;
            int[] nArray = new int[2];
            int[] nArray7 = nArray;
            nArray[0] = 10;
            nArray[1] = 10;
            int[] nArray8 = new int[2];
            int[] nArray9 = nArray8;
            nArray8[0] = 5;
            nArray8[1] = 4;
            int[] nArray10 = new int[2];
            int[] nArray11 = nArray10;
            nArray10[0] = 2;
            nArray10[1] = 2;
            gMSSKeyGenerationParameters = gMSSKeyGenerationParameters3;
            GMSSParameters gMSSParameters3 = gMSSParameters;
            gMSSParameters = new GMSSParameters(2, nArray7, nArray9, nArray11);
            gMSSKeyGenerationParameters3 = new GMSSKeyGenerationParameters(secureRandom, gMSSParameters3);
        } else {
            GMSSParameters gMSSParameters;
            GMSSKeyGenerationParameters gMSSKeyGenerationParameters4;
            int[] nArray = new int[4];
            int[] nArray12 = nArray;
            nArray[0] = 10;
            nArray[1] = 10;
            nArray[2] = 10;
            nArray[3] = 10;
            int[] nArray13 = new int[4];
            int[] nArray14 = nArray13;
            nArray13[0] = 9;
            nArray13[1] = 9;
            nArray13[2] = 9;
            nArray13[3] = 3;
            int[] nArray15 = new int[4];
            int[] nArray16 = nArray15;
            nArray15[0] = 2;
            nArray15[1] = 2;
            nArray15[2] = 2;
            nArray15[3] = 2;
            gMSSKeyGenerationParameters = gMSSKeyGenerationParameters4;
            GMSSParameters gMSSParameters4 = gMSSParameters;
            gMSSParameters = new GMSSParameters(4, nArray12, nArray14, nArray16);
            gMSSKeyGenerationParameters4 = new GMSSKeyGenerationParameters(secureRandom, gMSSParameters4);
        }
        this.initialize(gMSSKeyGenerationParameters);
    }

    public void initialize(KeyGenerationParameters object) {
        GMSSParameters gMSSParameters;
        KeyGenerationParameters keyGenerationParameters = object;
        GMSSKeyPairGenerator gMSSKeyPairGenerator = this;
        object = (GMSSKeyGenerationParameters)object;
        gMSSKeyPairGenerator.gmssParams = object;
        GMSSParameters gMSSParameters2 = gMSSParameters;
        int n3 = ((GMSSKeyGenerationParameters)object).getParameters().getNumOfLayers();
        GMSSKeyPairGenerator gMSSKeyPairGenerator2 = this;
        object = gMSSKeyPairGenerator2.gmssParams.getParameters().getHeightOfTrees();
        int[] nArray = gMSSKeyPairGenerator2.gmssParams.getParameters().getWinternitzParameter();
        int[] nArray2 = gMSSKeyPairGenerator2.gmssParams.getParameters().getK();
        gMSSKeyPairGenerator.gmssPS = new GMSSParameters(n3, (int[])object, nArray, nArray2);
        gMSSKeyPairGenerator.numLayer = gMSSParameters2.getNumOfLayers();
        gMSSKeyPairGenerator.heightOfTrees = gMSSKeyPairGenerator.gmssPS.getHeightOfTrees();
        gMSSKeyPairGenerator.otsIndex = gMSSKeyPairGenerator.gmssPS.getWinternitzParameter();
        gMSSKeyPairGenerator.K = gMSSKeyPairGenerator.gmssPS.getK();
        int n4 = gMSSKeyPairGenerator.numLayer;
        int n5 = this.mdLength;
        this.currentSeeds = new byte[n4][n5];
        gMSSKeyPairGenerator.nextNextSeeds = new byte[n4 - 1][n5];
        SecureRandom secureRandom = keyGenerationParameters.getRandom();
        for (int i3 = 0; i3 < this.numLayer; ++i3) {
            secureRandom.nextBytes(this.currentSeeds[i3]);
            this.gmssRandom.nextSeed(this.currentSeeds[i3]);
        }
        this.initialized = true;
    }

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.initialize(keyGenerationParameters);
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        return this.genKeyPair();
    }
}

