/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.e;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.i;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.util.GMSSRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import d.a;

public class GMSSLeaf {
    private Digest messDigestOTS;
    private int mdsize;
    private int keysize;
    private GMSSRandom gmssRandom;
    private byte[] leaf;
    private byte[] concHashs;
    private int i;
    private int j;
    private int two_power_w;
    private int w;
    private int steps;
    private byte[] seed;
    public byte[] privateKeyOTS;

    public GMSSLeaf(Digest digest, byte[][] byArray, int[] nArray) {
        GMSSLeaf gMSSLeaf = this;
        this.i = nArray[0];
        this.j = nArray[1];
        this.steps = nArray[2];
        this.w = nArray[3];
        gMSSLeaf.messDigestOTS = digest;
        gMSSLeaf.gmssRandom = new GMSSRandom(digest);
        this.mdsize = gMSSLeaf.messDigestOTS.getDigestSize();
        int n3 = (int)Math.ceil((double)(this.mdsize << 3) / (double)this.w);
        gMSSLeaf.keysize = n3 + (int)Math.ceil((double)this.getLog((n3 << this.w) + 1) / (double)this.w);
        gMSSLeaf.two_power_w = 1 << gMSSLeaf.w;
        this.privateKeyOTS = byArray[0];
        this.seed = byArray[1];
        this.concHashs = byArray[2];
        this.leaf = byArray[3];
    }

    public GMSSLeaf(Digest digest, int n3, int n4) {
        int n5;
        GMSSLeaf gMSSLeaf = this;
        this.w = n3;
        gMSSLeaf.messDigestOTS = digest;
        gMSSLeaf.gmssRandom = new GMSSRandom(digest);
        this.mdsize = gMSSLeaf.messDigestOTS.getDigestSize();
        double d3 = n3;
        int n6 = (int)Math.ceil((double)(this.mdsize << 3) / d3);
        gMSSLeaf.keysize = n5 = n6 + (int)Math.ceil((double)this.getLog((n6 << n3) + 1) / d3);
        this.two_power_w = 1 << n3;
        gMSSLeaf.steps = (int)Math.ceil((double)((this.two_power_w - 1) * n5 + 1 + n5) / (double)n4);
        n5 = gMSSLeaf.mdsize;
        this.seed = new byte[n5];
        this.leaf = new byte[n5];
        this.privateKeyOTS = new byte[n5];
        gMSSLeaf.concHashs = new byte[n5 * this.keysize];
    }

    public GMSSLeaf(Digest digest, int n3, int n4, byte[] byArray) {
        int n5;
        GMSSLeaf gMSSLeaf = this;
        this.w = n3;
        gMSSLeaf.messDigestOTS = digest;
        gMSSLeaf.gmssRandom = new GMSSRandom(digest);
        this.mdsize = gMSSLeaf.messDigestOTS.getDigestSize();
        double d3 = n3;
        int n6 = (int)Math.ceil((double)(this.mdsize << 3) / d3);
        gMSSLeaf.keysize = n5 = n6 + (int)Math.ceil((double)this.getLog((n6 << n3) + 1) / d3);
        this.two_power_w = 1 << n3;
        gMSSLeaf.steps = (int)Math.ceil((double)((this.two_power_w - 1) * n5 + 1 + n5) / (double)n4);
        n5 = gMSSLeaf.mdsize;
        this.seed = new byte[n5];
        this.leaf = new byte[n5];
        this.privateKeyOTS = new byte[n5];
        gMSSLeaf.concHashs = new byte[n5 * this.keysize];
        this.initLeafCalc(byArray);
    }

    private GMSSLeaf(GMSSLeaf gMSSLeaf) {
        this.messDigestOTS = gMSSLeaf.messDigestOTS;
        this.mdsize = gMSSLeaf.mdsize;
        this.keysize = gMSSLeaf.keysize;
        this.gmssRandom = gMSSLeaf.gmssRandom;
        this.leaf = Arrays.clone(gMSSLeaf.leaf);
        this.concHashs = Arrays.clone(gMSSLeaf.concHashs);
        this.i = gMSSLeaf.i;
        this.j = gMSSLeaf.j;
        this.two_power_w = gMSSLeaf.two_power_w;
        this.w = gMSSLeaf.w;
        this.steps = gMSSLeaf.steps;
        this.seed = Arrays.clone(gMSSLeaf.seed);
        this.privateKeyOTS = Arrays.clone(gMSSLeaf.privateKeyOTS);
    }

    private void updateLeafCalc() {
        byte[] byArray = new byte[((GMSSLeaf)object).messDigestOTS.getDigestSize()];
        for (int i3 = 0; i3 < ((GMSSLeaf)object).steps + 10000; ++i3) {
            int n3 = ((GMSSLeaf)object).i;
            if (n3 == ((GMSSLeaf)object).keysize && ((GMSSLeaf)object).j == ((GMSSLeaf)object).two_power_w - 1) {
                GMSSLeaf gMSSLeaf = object;
                gMSSLeaf.messDigestOTS.update(((GMSSLeaf)object).concHashs, 0, ((GMSSLeaf)object).concHashs.length);
                byte[] byArray2 = new byte[gMSSLeaf.messDigestOTS.getDigestSize()];
                Object object = byArray2;
                gMSSLeaf.leaf = byArray2;
                gMSSLeaf.messDigestOTS.doFinal((byte[])object, 0);
                return;
            }
            if (n3 != 0 && ((GMSSLeaf)object).j != ((GMSSLeaf)object).two_power_w - 1) {
                GMSSLeaf gMSSLeaf = object;
                ((GMSSLeaf)object).messDigestOTS.update(((GMSSLeaf)object).privateKeyOTS, 0, ((GMSSLeaf)object).privateKeyOTS.length);
                gMSSLeaf.privateKeyOTS = byArray;
                gMSSLeaf.messDigestOTS.doFinal(byArray, 0);
                ((GMSSLeaf)object).j = n3 = gMSSLeaf.j + 1;
                if (n3 != ((GMSSLeaf)object).two_power_w - 1) continue;
                Object object = object;
                byte[] byArray3 = ((GMSSLeaf)object).concHashs;
                int n4 = ((GMSSLeaf)object).mdsize;
                int n5 = (((GMSSLeaf)object).i - 1) * n4;
                System.arraycopy(((GMSSLeaf)object).privateKeyOTS, 0, byArray3, n5, n4);
                continue;
            }
            ((GMSSLeaf)object).i = n3 + 1;
            ((GMSSLeaf)object).j = 0;
            ((GMSSLeaf)object).privateKeyOTS = ((GMSSLeaf)object).gmssRandom.nextSeed(((GMSSLeaf)object).seed);
        }
        throw new IllegalStateException(b.b.a("unable to updateLeaf in steps: ").append(((GMSSLeaf)object).steps).append(" ").append(((GMSSLeaf)object).i).append(" ").append(((GMSSLeaf)object).j).toString());
    }

    private int getLog(int n3) {
        int n4 = 1;
        int n5 = 2;
        while (n5 < n3) {
            n5 <<= 1;
            ++n4;
        }
        return n4;
    }

    public void initLeafCalc(byte[] byArray) {
        GMSSLeaf gMSSLeaf = object;
        GMSSLeaf gMSSLeaf2 = object;
        gMSSLeaf2.i = 0;
        gMSSLeaf2.j = 0;
        Object object = new byte[gMSSLeaf2.mdsize];
        int n3 = gMSSLeaf2.seed.length;
        System.arraycopy(byArray, 0, object, 0, n3);
        gMSSLeaf.seed = gMSSLeaf.gmssRandom.nextSeed((byte[])object);
    }

    public GMSSLeaf nextLeaf() {
        GMSSLeaf gMSSLeaf = new GMSSLeaf(this);
        gMSSLeaf.updateLeafCalc();
        return gMSSLeaf;
    }

    public byte[] getLeaf() {
        return Arrays.clone(this.leaf);
    }

    public byte[][] getStatByte() {
        byte[][] byArrayArray = new byte[4][];
        byte[][] byArrayArray2 = byArrayArray;
        byArrayArray2[0] = this.privateKeyOTS;
        byArrayArray2[1] = this.seed;
        byArrayArray2[2] = this.concHashs;
        byArrayArray[3] = this.leaf;
        return byArrayArray;
    }

    public int[] getStatInt() {
        int[] nArray = new int[4];
        int[] nArray2 = nArray;
        nArray2[0] = this.i;
        nArray2[1] = this.j;
        nArray2[2] = this.steps;
        nArray[3] = this.w;
        return nArray;
    }

    public String toString() {
        int n3;
        Object object = "";
        for (n3 = 0; n3 < 4; ++n3) {
            object = b.a(b.b.a((String)object), ((GMSSLeaf)object2).getStatInt()[n3], " ");
        }
        GMSSLeaf gMSSLeaf = object2;
        Object object2 = b.a(e.a((String)object, " ").append(((GMSSLeaf)object2).mdsize).append(" ").append(((GMSSLeaf)object2).keysize).append(" "), ((GMSSLeaf)object2).two_power_w, " ");
        object = gMSSLeaf.getStatByte();
        for (n3 = 0; n3 < 4; ++n3) {
            object2 = object[n3] != null ? a.a(b.b.a((String)object2), new String(Hex.encode((byte[])object[n3])), " ") : com.fis.ekyc.nfc.build_in.bouncycastle.asn1.i.a((String)object2, "null ");
        }
        return object2;
    }
}

