/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.GMSSDigestProvider;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.GMSSKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.GMSSLeaf;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.GMSSParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.GMSSRootCalc;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.GMSSRootSig;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.Treehash;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.util.GMSSRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.util.WinternitzOTSignature;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.util.Vector;

public class GMSSPrivateKeyParameters
extends GMSSKeyParameters {
    private int[] index;
    private byte[][] currentSeeds;
    private byte[][] nextNextSeeds;
    private byte[][][] currentAuthPaths;
    private byte[][][] nextAuthPaths;
    private Treehash[][] currentTreehash;
    private Treehash[][] nextTreehash;
    private Vector[] currentStack;
    private Vector[] nextStack;
    private Vector[][] currentRetain;
    private Vector[][] nextRetain;
    private byte[][][] keep;
    private GMSSLeaf[] nextNextLeaf;
    private GMSSLeaf[] upperLeaf;
    private GMSSLeaf[] upperTreehashLeaf;
    private int[] minTreehash;
    private GMSSParameters gmssPS;
    private byte[][] nextRoot;
    private GMSSRootCalc[] nextNextRoot;
    private byte[][] currentRootSig;
    private GMSSRootSig[] nextRootSig;
    private GMSSDigestProvider digestProvider;
    private boolean used;
    private int[] heightOfTrees;
    private int[] otsIndex;
    private int[] K;
    private int numLayer;
    private Digest messDigestTrees;
    private int mdLength;
    private GMSSRandom gmssRandom;
    private int[] numLeafs;

    public GMSSPrivateKeyParameters(byte[][] byArray, byte[][] byArray2, byte[][][] byArray3, byte[][][] byArray4, Treehash[][] treehashArray, Treehash[][] treehashArray2, Vector[] vectorArray, Vector[] vectorArray2, Vector[][] vectorArray3, Vector[][] vectorArray4, byte[][] byArray5, byte[][] byArray6, GMSSParameters gMSSParameters, GMSSDigestProvider gMSSDigestProvider) {
        this(null, byArray, byArray2, byArray3, byArray4, null, treehashArray, treehashArray2, vectorArray, vectorArray2, vectorArray3, vectorArray4, null, null, null, null, byArray5, null, byArray6, null, gMSSParameters, gMSSDigestProvider);
    }

    public GMSSPrivateKeyParameters(int[] nArray, byte[][] byArray, byte[][] object, byte[][][] object2, byte[][][] byArray2, byte[][][] object3, Treehash[][] treehashArray, Treehash[][] treehashArray2, Vector[] vectorArray, Vector[] vectorArray2, Vector[][] vectorArray3, Vector[][] vectorArray4, GMSSLeaf[] gMSSLeafArray, GMSSLeaf[] gMSSLeafArray2, GMSSLeaf[] gMSSLeafArray3, int[] nArray2, byte[][] byArray3, GMSSRootCalc[] gMSSRootCalcArray, byte[][] byArray4, GMSSRootSig[] gMSSRootSigArray, GMSSParameters object4, GMSSDigestProvider gMSSDigestProvider) {
        int n3;
        int n4;
        GMSSParameters gMSSParameters = object4;
        GMSSParameters gMSSParameters2 = object4;
        GMSSParameters gMSSParameters3 = object4;
        GMSSParameters gMSSParameters4 = object4;
        GMSSPrivateKeyParameters gMSSPrivateKeyParameters = this;
        super(true, (GMSSParameters)object4);
        this.used = false;
        object4 = gMSSDigestProvider.get();
        gMSSPrivateKeyParameters.messDigestTrees = object4;
        gMSSPrivateKeyParameters.mdLength = object4.getDigestSize();
        this.gmssPS = gMSSParameters4;
        this.otsIndex = gMSSParameters3.getWinternitzParameter();
        this.K = gMSSParameters2.getK();
        this.heightOfTrees = gMSSParameters.getHeightOfTrees();
        this.numLayer = n4 = this.gmssPS.getNumOfLayers();
        if (nArray == null) {
            this.index = new int[n4];
            for (int i3 = 0; i3 < this.numLayer; ++i3) {
                this.index[i3] = 0;
            }
        } else {
            this.index = nArray;
        }
        this.currentSeeds = byArray;
        this.nextNextSeeds = object;
        this.currentAuthPaths = Arrays.clone(object2);
        this.nextAuthPaths = byArray2;
        if (object3 == null) {
            this.keep = new byte[this.numLayer][][];
            for (int i4 = 0; i4 < this.numLayer; ++i4) {
                this.keep[i4] = new byte[(int)Math.floor(this.heightOfTrees[i4] / 2)][this.mdLength];
            }
        } else {
            this.keep = object3;
        }
        if (vectorArray == null) {
            this.currentStack = new Vector[this.numLayer];
            for (int i5 = 0; i5 < this.numLayer; ++i5) {
                Vector vector;
                object = vector;
                vector = new Vector();
                this.currentStack[i5] = object;
            }
        } else {
            this.currentStack = vectorArray;
        }
        if (vectorArray2 == null) {
            this.nextStack = new Vector[this.numLayer - 1];
            for (int i6 = 0; i6 < this.numLayer - 1; ++i6) {
                Vector vector;
                object = vector;
                vector = new Vector();
                this.nextStack[i6] = object;
            }
        } else {
            this.nextStack = vectorArray2;
        }
        GMSSPrivateKeyParameters gMSSPrivateKeyParameters2 = this;
        gMSSPrivateKeyParameters2.currentTreehash = treehashArray;
        gMSSPrivateKeyParameters2.nextTreehash = treehashArray2;
        gMSSPrivateKeyParameters2.currentRetain = vectorArray3;
        gMSSPrivateKeyParameters2.nextRetain = vectorArray4;
        gMSSPrivateKeyParameters2.nextRoot = byArray3;
        gMSSPrivateKeyParameters2.digestProvider = gMSSDigestProvider;
        if (gMSSRootCalcArray == null) {
            this.nextNextRoot = new GMSSRootCalc[this.numLayer - 1];
            int n5 = 0;
            while (n5 < this.numLayer - 1) {
                GMSSRootCalc gMSSRootCalc;
                object = gMSSRootCalc;
                GMSSPrivateKeyParameters gMSSPrivateKeyParameters3 = this;
                int n6 = gMSSPrivateKeyParameters3.heightOfTrees[n5];
                int n7 = gMSSPrivateKeyParameters3.K[n5];
                object3 = gMSSPrivateKeyParameters3.digestProvider;
                gMSSRootCalc = new GMSSRootCalc(n6, n7, (GMSSDigestProvider)object3);
                this.nextNextRoot[n5++] = object;
            }
        } else {
            this.nextNextRoot = gMSSRootCalcArray;
        }
        this.currentRootSig = byArray4;
        this.numLeafs = new int[this.numLayer];
        for (n3 = 0; n3 < this.numLayer; ++n3) {
            this.numLeafs[n3] = 1 << this.heightOfTrees[n3];
        }
        this.gmssRandom = new GMSSRandom(this.messDigestTrees);
        n3 = this.numLayer;
        if (n3 > 1) {
            if (gMSSLeafArray == null) {
                this.nextNextLeaf = new GMSSLeaf[n3 - 2];
                n3 = 0;
                while (n3 < this.numLayer - 2) {
                    GMSSPrivateKeyParameters gMSSPrivateKeyParameters4 = this;
                    int n8 = n3 + 1;
                    int n9 = gMSSPrivateKeyParameters4.otsIndex[n8];
                    int n10 = gMSSPrivateKeyParameters4.numLeafs[n3 + 2];
                    byte[] byArray5 = gMSSPrivateKeyParameters4.nextNextSeeds[n3];
                    this.nextNextLeaf[n3] = new GMSSLeaf(gMSSDigestProvider.get(), n9, n10, byArray5);
                    n3 = n8;
                }
            } else {
                this.nextNextLeaf = gMSSLeafArray;
            }
        } else {
            this.nextNextLeaf = new GMSSLeaf[0];
        }
        if (gMSSLeafArray2 == null) {
            this.upperLeaf = new GMSSLeaf[this.numLayer - 1];
            n3 = 0;
            while (n3 < this.numLayer - 1) {
                GMSSPrivateKeyParameters gMSSPrivateKeyParameters5 = this;
                int n11 = gMSSPrivateKeyParameters5.otsIndex[n3];
                int n12 = n3 + 1;
                int n13 = gMSSPrivateKeyParameters5.numLeafs[n12];
                byte[] byArray6 = gMSSPrivateKeyParameters5.currentSeeds[n3];
                this.upperLeaf[n3] = new GMSSLeaf(gMSSDigestProvider.get(), n11, n13, byArray6);
                n3 = n12;
            }
        } else {
            this.upperLeaf = gMSSLeafArray2;
        }
        if (gMSSLeafArray3 == null) {
            this.upperTreehashLeaf = new GMSSLeaf[this.numLayer - 1];
            n3 = 0;
            while (n3 < this.numLayer - 1) {
                GMSSPrivateKeyParameters gMSSPrivateKeyParameters6 = this;
                int n14 = gMSSPrivateKeyParameters6.otsIndex[n3];
                this.upperTreehashLeaf[n3] = new GMSSLeaf(gMSSDigestProvider.get(), n14, gMSSPrivateKeyParameters6.numLeafs[++n3]);
            }
        } else {
            this.upperTreehashLeaf = gMSSLeafArray3;
        }
        if (nArray2 == null) {
            this.minTreehash = new int[this.numLayer - 1];
            for (n3 = 0; n3 < this.numLayer - 1; ++n3) {
                this.minTreehash[n3] = -1;
            }
        } else {
            this.minTreehash = nArray2;
        }
        int n15 = this.mdLength;
        byte[] byArray7 = new byte[n15];
        byte[] cfr_ignored_0 = new byte[n15];
        if (gMSSRootSigArray == null) {
            this.nextRootSig = new GMSSRootSig[this.numLayer - 1];
            int n16 = 0;
            while (n16 < this.numLayer - 1) {
                GMSSPrivateKeyParameters gMSSPrivateKeyParameters7 = this;
                int n17 = this.mdLength;
                System.arraycopy(byArray[n16], 0, byArray7, 0, n17);
                gMSSPrivateKeyParameters7.gmssRandom.nextSeed(byArray7);
                object2 = gMSSPrivateKeyParameters7.gmssRandom.nextSeed(byArray7);
                GMSSPrivateKeyParameters gMSSPrivateKeyParameters8 = this;
                int n18 = gMSSPrivateKeyParameters8.otsIndex[n16];
                int n19 = n16 + 1;
                gMSSPrivateKeyParameters7.nextRootSig[n16] = new GMSSRootSig(gMSSDigestProvider.get(), n18, gMSSPrivateKeyParameters8.heightOfTrees[n19]);
                gMSSPrivateKeyParameters7.nextRootSig[n16].initSign((byte[])object2, byArray3[n16]);
                n16 = n19;
            }
        } else {
            this.nextRootSig = gMSSRootSigArray;
        }
    }

    private GMSSPrivateKeyParameters(GMSSPrivateKeyParameters gMSSPrivateKeyParameters) {
        super(true, gMSSPrivateKeyParameters.getParameters());
        this.used = false;
        this.index = Arrays.clone(gMSSPrivateKeyParameters.index);
        this.currentSeeds = Arrays.clone(gMSSPrivateKeyParameters.currentSeeds);
        this.nextNextSeeds = Arrays.clone(gMSSPrivateKeyParameters.nextNextSeeds);
        this.currentAuthPaths = Arrays.clone(gMSSPrivateKeyParameters.currentAuthPaths);
        this.nextAuthPaths = Arrays.clone(gMSSPrivateKeyParameters.nextAuthPaths);
        this.currentTreehash = gMSSPrivateKeyParameters.currentTreehash;
        this.nextTreehash = gMSSPrivateKeyParameters.nextTreehash;
        this.currentStack = gMSSPrivateKeyParameters.currentStack;
        this.nextStack = gMSSPrivateKeyParameters.nextStack;
        this.currentRetain = gMSSPrivateKeyParameters.currentRetain;
        this.nextRetain = gMSSPrivateKeyParameters.nextRetain;
        this.keep = Arrays.clone(gMSSPrivateKeyParameters.keep);
        this.nextNextLeaf = gMSSPrivateKeyParameters.nextNextLeaf;
        this.upperLeaf = gMSSPrivateKeyParameters.upperLeaf;
        this.upperTreehashLeaf = gMSSPrivateKeyParameters.upperTreehashLeaf;
        this.minTreehash = gMSSPrivateKeyParameters.minTreehash;
        this.gmssPS = gMSSPrivateKeyParameters.gmssPS;
        this.nextRoot = Arrays.clone(gMSSPrivateKeyParameters.nextRoot);
        this.nextNextRoot = gMSSPrivateKeyParameters.nextNextRoot;
        this.currentRootSig = gMSSPrivateKeyParameters.currentRootSig;
        this.nextRootSig = gMSSPrivateKeyParameters.nextRootSig;
        this.digestProvider = gMSSPrivateKeyParameters.digestProvider;
        this.heightOfTrees = gMSSPrivateKeyParameters.heightOfTrees;
        this.otsIndex = gMSSPrivateKeyParameters.otsIndex;
        this.K = gMSSPrivateKeyParameters.K;
        this.numLayer = gMSSPrivateKeyParameters.numLayer;
        this.messDigestTrees = gMSSPrivateKeyParameters.messDigestTrees;
        this.mdLength = gMSSPrivateKeyParameters.mdLength;
        this.gmssRandom = gMSSPrivateKeyParameters.gmssRandom;
        this.numLeafs = gMSSPrivateKeyParameters.numLeafs;
    }

    private void nextKey(int n3) {
        int n4 = this.numLayer;
        if (n3 == n4 - 1) {
            this.index[n3] = this.index[n3] + 1;
        }
        if (this.index[n3] == this.numLeafs[n3]) {
            if (n4 != 1) {
                GMSSPrivateKeyParameters gMSSPrivateKeyParameters = this;
                gMSSPrivateKeyParameters.nextTree(n3);
                gMSSPrivateKeyParameters.index[n3] = 0;
            }
        } else {
            this.updateKey(n3);
        }
    }

    private void nextTree(int n3) {
        if (n3 > 0) {
            int n4 = n3 - 1;
            this.index[n4] = this.index[n4] + 1;
            int n5 = 1;
            int n6 = n3;
            do {
                if (this.index[--n6] >= this.numLeafs[n6]) continue;
                n5 = 0;
            } while (n5 != 0 && n6 > 0);
            if (n5 == 0) {
                int n7;
                GMSSPrivateKeyParameters gMSSPrivateKeyParameters = this;
                gMSSPrivateKeyParameters.gmssRandom.nextSeed(this.currentSeeds[n3]);
                gMSSPrivateKeyParameters.nextRootSig[n4].updateSign();
                if (n3 > 1) {
                    n5 = n4 - 1;
                    this.nextNextLeaf[n5] = this.nextNextLeaf[n5].nextLeaf();
                }
                GMSSPrivateKeyParameters gMSSPrivateKeyParameters2 = this;
                gMSSPrivateKeyParameters2.upperLeaf[n4] = gMSSPrivateKeyParameters2.upperLeaf[n4].nextLeaf();
                if (gMSSPrivateKeyParameters2.minTreehash[n4] >= 0) {
                    GMSSPrivateKeyParameters gMSSPrivateKeyParameters3 = this;
                    gMSSPrivateKeyParameters3.upperTreehashLeaf[n4] = gMSSPrivateKeyParameters3.upperTreehashLeaf[n4].nextLeaf();
                    byte[] byArray = gMSSPrivateKeyParameters3.upperTreehashLeaf[n4].getLeaf();
                    try {
                        gMSSPrivateKeyParameters3.currentTreehash[n4][this.minTreehash[n4]].update(this.gmssRandom, byArray);
                        gMSSPrivateKeyParameters3.currentTreehash[n4][this.minTreehash[n4]].wasFinished();
                    }
                    catch (Exception exception) {
                        System.out.println(exception);
                    }
                }
                GMSSPrivateKeyParameters gMSSPrivateKeyParameters4 = this;
                gMSSPrivateKeyParameters4.updateNextNextAuthRoot(n3);
                gMSSPrivateKeyParameters4.currentRootSig[n4] = this.nextRootSig[n4].getSig();
                for (n7 = 0; n7 < this.heightOfTrees[n3] - this.K[n3]; ++n7) {
                    GMSSPrivateKeyParameters gMSSPrivateKeyParameters5 = this;
                    Treehash[] treehashArray = gMSSPrivateKeyParameters5.currentTreehash[n3];
                    Treehash[][] treehashArray2 = gMSSPrivateKeyParameters5.nextTreehash;
                    treehashArray[n7] = treehashArray2[n4][n7];
                    gMSSPrivateKeyParameters5.nextTreehash[n4][n7] = this.nextNextRoot[n4].getTreehash()[n7];
                }
                for (n7 = 0; n7 < this.heightOfTrees[n3]; ++n7) {
                    GMSSPrivateKeyParameters gMSSPrivateKeyParameters6 = this;
                    GMSSPrivateKeyParameters gMSSPrivateKeyParameters7 = this;
                    byte[] byArray = gMSSPrivateKeyParameters7.currentAuthPaths[n3][n7];
                    int n8 = gMSSPrivateKeyParameters7.mdLength;
                    System.arraycopy(gMSSPrivateKeyParameters6.nextAuthPaths[n4][n7], 0, byArray, 0, n8);
                    GMSSPrivateKeyParameters gMSSPrivateKeyParameters8 = this;
                    byArray = gMSSPrivateKeyParameters8.nextAuthPaths[n4][n7];
                    n8 = gMSSPrivateKeyParameters8.mdLength;
                    System.arraycopy(gMSSPrivateKeyParameters6.nextNextRoot[n4].getAuthPath()[n7], 0, byArray, 0, n8);
                }
                for (n7 = 0; n7 < this.K[n3] - 1; ++n7) {
                    GMSSPrivateKeyParameters gMSSPrivateKeyParameters9 = this;
                    Vector[] vectorArray = gMSSPrivateKeyParameters9.currentRetain[n3];
                    Vector[][] vectorArray2 = gMSSPrivateKeyParameters9.nextRetain;
                    vectorArray[n7] = vectorArray2[n4][n7];
                    gMSSPrivateKeyParameters9.nextRetain[n4][n7] = this.nextNextRoot[n4].getRetain()[n7];
                }
                GMSSPrivateKeyParameters gMSSPrivateKeyParameters10 = this;
                Object[] objectArray = gMSSPrivateKeyParameters10.currentStack;
                Vector[] vectorArray = gMSSPrivateKeyParameters10.nextStack;
                objectArray[n3] = vectorArray[n4];
                gMSSPrivateKeyParameters10.nextStack[n4] = this.nextNextRoot[n4].getStack();
                gMSSPrivateKeyParameters10.nextRoot[n4] = this.nextNextRoot[n4].getRoot();
                n3 = gMSSPrivateKeyParameters10.mdLength;
                byte[] cfr_ignored_0 = new byte[n3];
                objectArray = new byte[n3];
                System.arraycopy(gMSSPrivateKeyParameters10.currentSeeds[n4], 0, objectArray, 0, n3);
                gMSSPrivateKeyParameters10.gmssRandom.nextSeed((byte[])objectArray);
                gMSSPrivateKeyParameters10.gmssRandom.nextSeed((byte[])objectArray);
                byte[] byArray = gMSSPrivateKeyParameters10.gmssRandom.nextSeed((byte[])objectArray);
                gMSSPrivateKeyParameters10.nextRootSig[n4].initSign(byArray, this.nextRoot[n4]);
                this.nextKey(n4);
            }
        }
    }

    private void updateKey(int n3) {
        this.computeAuthPaths(n3);
        if (n3 > 0) {
            int n4;
            if (n3 > 1) {
                n4 = n3 - 1 - 1;
                this.nextNextLeaf[n4] = this.nextNextLeaf[n4].nextLeaf();
            }
            GMSSPrivateKeyParameters gMSSPrivateKeyParameters = this;
            n4 = n3 - 1;
            this.upperLeaf[n4] = this.upperLeaf[n4].nextLeaf();
            int n5 = gMSSPrivateKeyParameters.index[n3];
            int n6 = (int)Math.floor((double)(gMSSPrivateKeyParameters.getNumLeafs(n3) * 2) / (double)(this.heightOfTrees[n4] - this.K[n4]));
            if (n5 % n6 == 1) {
                if (n5 > 1 && this.minTreehash[n4] >= 0) {
                    GMSSPrivateKeyParameters gMSSPrivateKeyParameters2 = this;
                    byte[] byArray = gMSSPrivateKeyParameters2.upperTreehashLeaf[n4].getLeaf();
                    try {
                        gMSSPrivateKeyParameters2.currentTreehash[n4][this.minTreehash[n4]].update(this.gmssRandom, byArray);
                        gMSSPrivateKeyParameters2.currentTreehash[n4][this.minTreehash[n4]].wasFinished();
                    }
                    catch (Exception exception) {
                        System.out.println(exception);
                    }
                }
                GMSSPrivateKeyParameters gMSSPrivateKeyParameters3 = this;
                gMSSPrivateKeyParameters3.minTreehash[n4] = this.getMinTreehashIndex(n4);
                n5 = gMSSPrivateKeyParameters3.minTreehash[n4];
                if (n5 >= 0) {
                    GMSSPrivateKeyParameters gMSSPrivateKeyParameters4 = this;
                    byte[] byArray = gMSSPrivateKeyParameters4.currentTreehash[n4][n5].getSeedActive();
                    gMSSPrivateKeyParameters4.upperTreehashLeaf[n4] = new GMSSLeaf(this.digestProvider.get(), this.otsIndex[n4], n6, byArray);
                    gMSSPrivateKeyParameters4.upperTreehashLeaf[n4] = gMSSPrivateKeyParameters4.upperTreehashLeaf[n4].nextLeaf();
                }
            } else if (this.minTreehash[n4] >= 0) {
                this.upperTreehashLeaf[n4] = this.upperTreehashLeaf[n4].nextLeaf();
            }
            GMSSPrivateKeyParameters gMSSPrivateKeyParameters5 = this;
            gMSSPrivateKeyParameters5.nextRootSig[n4].updateSign();
            if (gMSSPrivateKeyParameters5.index[n3] == 1) {
                this.nextNextRoot[n4].initialize(new Vector());
            }
            this.updateNextNextAuthRoot(n3);
        }
    }

    private int getMinTreehashIndex(int n3) {
        int n4 = -1;
        for (int i3 = 0; i3 < this.heightOfTrees[n3] - this.K[n3]; ++i3) {
            if (!this.currentTreehash[n3][i3].wasInitialized() || this.currentTreehash[n3][i3].wasFinished() || n4 != -1 && this.currentTreehash[n3][i3].getLowestNodeHeight() >= this.currentTreehash[n3][n4].getLowestNodeHeight()) continue;
            n4 = i3;
        }
        return n4;
    }

    private void computeAuthPaths(int n3) {
        int n4;
        int n5;
        int n6;
        GMSSPrivateKeyParameters gMSSPrivateKeyParameters = this;
        int n7 = gMSSPrivateKeyParameters.index[n3];
        int n8 = gMSSPrivateKeyParameters.heightOfTrees[n3];
        int n9 = gMSSPrivateKeyParameters.K[n3];
        for (n6 = 0; n6 < (n5 = n8 - n9); ++n6) {
            this.currentTreehash[n3][n6].updateNextSeed(this.gmssRandom);
        }
        n9 = this.heightOfPhi(n7);
        GMSSPrivateKeyParameters gMSSPrivateKeyParameters2 = this;
        byte[] cfr_ignored_0 = new byte[gMSSPrivateKeyParameters2.mdLength];
        byte[] byArray = gMSSPrivateKeyParameters2.gmssRandom.nextSeed(this.currentSeeds[n3]);
        n6 = n7 >>> n9 + 1 & 1;
        int n10 = this.mdLength;
        byte[] byArray2 = new byte[n10];
        int n11 = n8 - 1;
        if (n9 < n11 && n6 == 0) {
            System.arraycopy(this.currentAuthPaths[n3][n9], 0, byArray2, 0, n10);
        }
        n10 = this.mdLength;
        byte[] cfr_ignored_1 = new byte[n10];
        if (n9 == 0) {
            Object object;
            if (n3 == this.numLayer - 1) {
                GMSSPrivateKeyParameters gMSSPrivateKeyParameters3 = this;
                object = gMSSPrivateKeyParameters3.digestProvider.get();
                object = new WinternitzOTSignature(byArray, (Digest)object, gMSSPrivateKeyParameters3.otsIndex[n3]).getPublicKey();
            } else {
                GMSSPrivateKeyParameters gMSSPrivateKeyParameters4 = this;
                object = new byte[n10];
                System.arraycopy(gMSSPrivateKeyParameters4.currentSeeds[n3], 0, object, 0, n10);
                gMSSPrivateKeyParameters4.gmssRandom.nextSeed((byte[])object);
                byArray = gMSSPrivateKeyParameters4.upperLeaf[n3].getLeaf();
                gMSSPrivateKeyParameters4.upperLeaf[n3].initLeafCalc((byte[])object);
                object = byArray;
            }
            Object object2 = object;
            GMSSPrivateKeyParameters gMSSPrivateKeyParameters5 = this;
            object = gMSSPrivateKeyParameters5.currentAuthPaths[n3][0];
            n4 = gMSSPrivateKeyParameters5.mdLength;
            System.arraycopy(object2, 0, object, 0, n4);
        } else {
            GMSSPrivateKeyParameters gMSSPrivateKeyParameters6 = this;
            n4 = n10 << 1;
            byte[] byArray3 = new byte[n4];
            int n12 = n9 - 1;
            System.arraycopy(gMSSPrivateKeyParameters6.currentAuthPaths[n3][n12], 0, byArray3, 0, n10);
            int n13 = n10 = this.mdLength;
            System.arraycopy(gMSSPrivateKeyParameters6.keep[n3][(int)Math.floor(n12 / 2)], 0, byArray3, n13, n13);
            gMSSPrivateKeyParameters6.messDigestTrees.update(byArray3, 0, n4);
            gMSSPrivateKeyParameters6.currentAuthPaths[n3][n9] = new byte[this.messDigestTrees.getDigestSize()];
            gMSSPrivateKeyParameters6.messDigestTrees.doFinal(this.currentAuthPaths[n3][n9], 0);
            for (n4 = 0; n4 < n9; ++n4) {
                int n14;
                if (n4 < n5) {
                    if (this.currentTreehash[n3][n4].wasFinished()) {
                        GMSSPrivateKeyParameters gMSSPrivateKeyParameters7 = this;
                        GMSSPrivateKeyParameters gMSSPrivateKeyParameters8 = this;
                        byte[] byArray4 = gMSSPrivateKeyParameters8.currentAuthPaths[n3][n4];
                        int n15 = gMSSPrivateKeyParameters8.mdLength;
                        System.arraycopy(gMSSPrivateKeyParameters7.currentTreehash[n3][n4].getFirstNode(), 0, byArray4, 0, n15);
                        gMSSPrivateKeyParameters7.currentTreehash[n3][n4].destroy();
                    } else {
                        System.err.println("Treehash (" + n3 + "," + n4 + ") not finished when needed in AuthPathComputation");
                    }
                }
                if (n4 < n11 && n4 >= n5 && this.currentRetain[n3][n14 = n4 - n5].size() > 0) {
                    GMSSPrivateKeyParameters gMSSPrivateKeyParameters9 = this;
                    GMSSPrivateKeyParameters gMSSPrivateKeyParameters10 = this;
                    byArray3 = gMSSPrivateKeyParameters10.currentAuthPaths[n3][n4];
                    n12 = gMSSPrivateKeyParameters10.mdLength;
                    System.arraycopy(gMSSPrivateKeyParameters9.currentRetain[n3][n14].lastElement(), 0, byArray3, 0, n12);
                    Vector vector = gMSSPrivateKeyParameters9.currentRetain[n3][n14];
                    vector.removeElementAt(vector.size() - 1);
                }
                if (n4 >= n5 || (1 << n4) * 3 + n7 >= this.numLeafs[n3]) continue;
                this.currentTreehash[n3][n4].initialize();
            }
        }
        if (n9 < n11 && n6 == 0) {
            GMSSPrivateKeyParameters gMSSPrivateKeyParameters11 = this;
            byte[] byArray5 = gMSSPrivateKeyParameters11.keep[n3][(int)Math.floor(n9 / 2)];
            n4 = gMSSPrivateKeyParameters11.mdLength;
            System.arraycopy(byArray2, 0, byArray5, 0, n4);
        }
        if (n3 == this.numLayer - 1) {
            for (int i3 = 1; i3 <= n5 / 2; ++i3) {
                WinternitzOTSignature winternitzOTSignature;
                int n16 = this.getMinTreehashIndex(n3);
                if (n16 < 0) continue;
                GMSSPrivateKeyParameters gMSSPrivateKeyParameters12 = this;
                GMSSPrivateKeyParameters gMSSPrivateKeyParameters13 = gMSSPrivateKeyParameters12;
                GMSSPrivateKeyParameters gMSSPrivateKeyParameters14 = gMSSPrivateKeyParameters12;
                GMSSPrivateKeyParameters gMSSPrivateKeyParameters15 = gMSSPrivateKeyParameters12;
                Object object = new byte[gMSSPrivateKeyParameters12.mdLength];
                byte[] byArray6 = gMSSPrivateKeyParameters13.currentTreehash[n3][n16].getSeedActive();
                n6 = 0;
                n10 = 0;
                int n17 = this.mdLength;
                System.arraycopy(byArray6, n6, object, n10, n17);
                object = gMSSPrivateKeyParameters14.gmssRandom.nextSeed((byte[])object);
                WinternitzOTSignature winternitzOTSignature2 = winternitzOTSignature;
                WinternitzOTSignature winternitzOTSignature3 = winternitzOTSignature;
                byte[] byArray7 = object;
                GMSSPrivateKeyParameters gMSSPrivateKeyParameters16 = this;
                GMSSPrivateKeyParameters gMSSPrivateKeyParameters17 = gMSSPrivateKeyParameters16;
                object = gMSSPrivateKeyParameters16.digestProvider.get();
                winternitzOTSignature2(byArray7, (Digest)object, gMSSPrivateKeyParameters17.otsIndex[n3]);
                object = winternitzOTSignature3.getPublicKey();
                try {
                    gMSSPrivateKeyParameters15.currentTreehash[n3][n16].update(this.gmssRandom, (byte[])object);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
            }
        } else {
            this.minTreehash[n3] = this.getMinTreehashIndex(n3);
        }
    }

    private int heightOfPhi(int n3) {
        if (n3 == 0) {
            return -1;
        }
        int n4 = 0;
        int n5 = 1;
        while (n3 % n5 == 0) {
            n5 *= 2;
            ++n4;
        }
        return n4 - 1;
    }

    private void updateNextNextAuthRoot(int n3) {
        GMSSPrivateKeyParameters gMSSPrivateKeyParameters = object2;
        byte[] cfr_ignored_0 = new byte[gMSSPrivateKeyParameters.mdLength];
        int n4 = n3 - 1;
        Object object = gMSSPrivateKeyParameters.gmssRandom.nextSeed(((GMSSPrivateKeyParameters)object2).nextNextSeeds[n4]);
        if (n3 == gMSSPrivateKeyParameters.numLayer - 1) {
            WinternitzOTSignature winternitzOTSignature;
            WinternitzOTSignature winternitzOTSignature2 = winternitzOTSignature;
            byte[] byArray = object;
            GMSSPrivateKeyParameters gMSSPrivateKeyParameters2 = object2;
            object = gMSSPrivateKeyParameters2.digestProvider.get();
            winternitzOTSignature = new WinternitzOTSignature(byArray, (Digest)object, gMSSPrivateKeyParameters2.otsIndex[n3]);
            Object object2 = ((GMSSPrivateKeyParameters)object2).nextNextSeeds[n4];
            ((GMSSPrivateKeyParameters)object2).nextNextRoot[n4].update((byte[])object2, winternitzOTSignature2.getPublicKey());
        } else {
            GMSSPrivateKeyParameters gMSSPrivateKeyParameters3 = object2;
            gMSSPrivateKeyParameters3.nextNextRoot[n4].update(((GMSSPrivateKeyParameters)object2).nextNextSeeds[n4], ((GMSSPrivateKeyParameters)object2).nextNextLeaf[n4].getLeaf());
            gMSSPrivateKeyParameters3.nextNextLeaf[n4].initLeafCalc(((GMSSPrivateKeyParameters)object2).nextNextSeeds[n4]);
        }
    }

    public boolean isUsed() {
        return this.used;
    }

    public void markUsed() {
        this.used = true;
    }

    public GMSSPrivateKeyParameters nextKey() {
        GMSSPrivateKeyParameters gMSSPrivateKeyParameters = new GMSSPrivateKeyParameters(this);
        gMSSPrivateKeyParameters.nextKey(this.gmssPS.getNumOfLayers() - 1);
        return gMSSPrivateKeyParameters;
    }

    public int[] getIndex() {
        return this.index;
    }

    public int getIndex(int n3) {
        return this.index[n3];
    }

    public byte[][] getCurrentSeeds() {
        return Arrays.clone(this.currentSeeds);
    }

    public byte[][][] getCurrentAuthPaths() {
        return Arrays.clone(this.currentAuthPaths);
    }

    public byte[] getSubtreeRootSig(int n3) {
        return this.currentRootSig[n3];
    }

    public GMSSDigestProvider getName() {
        return this.digestProvider;
    }

    public int getNumLeafs(int n3) {
        return this.numLeafs[n3];
    }
}

