/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.util.GMSSRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import d.a;

public class GMSSRootSig {
    private Digest messDigestOTS;
    private int mdsize;
    private int keysize;
    private byte[] privateKeyOTS;
    private byte[] hash;
    private byte[] sign;
    private int w;
    private GMSSRandom gmssRandom;
    private int messagesize;
    private int k;
    private int r;
    private int test;
    private int counter;
    private int ii;
    private long test8;
    private long big8;
    private int steps;
    private int checksum;
    private int height;
    private byte[] seed;

    public GMSSRootSig(Digest digest, byte[][] byArray, int[] nArray) {
        int n3;
        GMSSRootSig gMSSRootSig = this;
        gMSSRootSig.messDigestOTS = digest;
        gMSSRootSig.gmssRandom = new GMSSRandom(digest);
        this.counter = nArray[0];
        this.test = nArray[1];
        this.ii = nArray[2];
        this.r = nArray[3];
        this.steps = nArray[4];
        this.keysize = nArray[5];
        this.height = nArray[6];
        this.w = nArray[7];
        this.checksum = nArray[8];
        int n4 = this.messDigestOTS.getDigestSize();
        this.mdsize = n3 = n4;
        n3 = this.w;
        this.k = (1 << n3) - 1;
        this.messagesize = (int)Math.ceil((double)(n4 << 3) / (double)n3);
        this.privateKeyOTS = byArray[0];
        this.seed = byArray[1];
        this.hash = byArray[2];
        this.sign = byArray[3];
        byte[] byArray2 = byArray[4];
        this.test8 = (long)(byArray2[0] & 0xFF) | (long)(byArray2[1] & 0xFF) << 8 | (long)(byArray2[2] & 0xFF) << 16 | (long)(byArray2[3] & 0xFF) << 24 | (long)(byArray2[4] & 0xFF) << 32 | (long)(byArray2[5] & 0xFF) << 40 | (long)(byArray2[6] & 0xFF) << 48 | (long)(byArray2[7] & 0xFF) << 56;
        this.big8 = (long)(byArray2[8] & 0xFF) | (long)(byArray2[9] & 0xFF) << 8 | (long)(byArray2[10] & 0xFF) << 16 | (long)(byArray2[11] & 0xFF) << 24 | (long)(byArray2[12] & 0xFF) << 32 | (long)(byArray2[13] & 0xFF) << 40 | (long)(byArray2[14] & 0xFF) << 48 | (long)(byArray2[15] & 0xFF) << 56;
    }

    public GMSSRootSig(Digest digest, int n3, int n4) {
        this.messDigestOTS = digest;
        this.gmssRandom = new GMSSRandom(digest);
        int n5 = this.messDigestOTS.getDigestSize();
        GMSSRootSig gMSSRootSig = this;
        this.mdsize = n5;
        this.w = n3;
        gMSSRootSig.height = n4;
        gMSSRootSig.k = (1 << n3) - 1;
        this.messagesize = (int)Math.ceil((double)(n5 << 3) / (double)n3);
    }

    private void oneStep() {
        int n3 = this.w;
        if (8 % n3 == 0) {
            n3 = this.test;
            if (n3 == 0) {
                GMSSRootSig gMSSRootSig = this;
                gMSSRootSig.privateKeyOTS = gMSSRootSig.gmssRandom.nextSeed(this.seed);
                n3 = gMSSRootSig.ii;
                if (n3 < this.mdsize) {
                    n3 = this.hash[n3];
                    this.test = n3 & this.k;
                    this.hash[n3] = (byte)(n3 >>> this.w);
                } else {
                    n3 = this.checksum;
                    this.test = n3 & this.k;
                    this.checksum = n3 >>> this.w;
                }
            } else if (n3 > 0) {
                GMSSRootSig gMSSRootSig = this;
                gMSSRootSig.messDigestOTS.update(this.privateKeyOTS, 0, this.privateKeyOTS.length);
                byte[] byArray = new byte[gMSSRootSig.messDigestOTS.getDigestSize()];
                gMSSRootSig.privateKeyOTS = byArray;
                gMSSRootSig.messDigestOTS.doFinal(byArray, 0);
                --gMSSRootSig.test;
            }
            if (this.test == 0) {
                int n4;
                GMSSRootSig gMSSRootSig = this;
                GMSSRootSig gMSSRootSig2 = this;
                byte[] byArray = gMSSRootSig2.sign;
                int n5 = this.mdsize;
                int n6 = gMSSRootSig2.counter * n5;
                System.arraycopy(gMSSRootSig.privateKeyOTS, 0, byArray, n6, n5);
                this.counter = n4 = gMSSRootSig.counter + 1;
                if (n4 % (8 / this.w) == 0) {
                    ++this.ii;
                }
            }
        } else if (n3 < 8) {
            int n7;
            int n8 = this.test;
            if (n8 == 0) {
                n8 = this.counter;
                if (n8 % 8 == 0 && this.ii < (n7 = this.mdsize)) {
                    this.big8 = 0L;
                    if (n8 < n7 / n3 << 3) {
                        for (n3 = 0; n3 < this.w; ++n3) {
                            GMSSRootSig gMSSRootSig = this;
                            long l3 = gMSSRootSig.big8;
                            byte[] byArray = gMSSRootSig.hash;
                            int n9 = gMSSRootSig.ii;
                            this.big8 = l3 ^ (long)((byArray[n9] & 0xFF) << (n3 << 3));
                            gMSSRootSig.ii = n9 + 1;
                        }
                    } else {
                        for (n3 = 0; n3 < this.mdsize % this.w; ++n3) {
                            GMSSRootSig gMSSRootSig = this;
                            long l4 = gMSSRootSig.big8;
                            byte[] byArray = gMSSRootSig.hash;
                            int n10 = gMSSRootSig.ii;
                            this.big8 = l4 ^ (long)((byArray[n10] & 0xFF) << (n3 << 3));
                            gMSSRootSig.ii = n10 + 1;
                        }
                    }
                }
                if (this.counter == this.messagesize) {
                    this.big8 = this.checksum;
                }
                GMSSRootSig gMSSRootSig = this;
                gMSSRootSig.test = (int)(gMSSRootSig.big8 & (long)this.k);
                gMSSRootSig.privateKeyOTS = gMSSRootSig.gmssRandom.nextSeed(this.seed);
            } else if (n8 > 0) {
                GMSSRootSig gMSSRootSig = this;
                gMSSRootSig.messDigestOTS.update(this.privateKeyOTS, 0, this.privateKeyOTS.length);
                byte[] byArray = new byte[gMSSRootSig.messDigestOTS.getDigestSize()];
                gMSSRootSig.privateKeyOTS = byArray;
                gMSSRootSig.messDigestOTS.doFinal(byArray, 0);
                --gMSSRootSig.test;
            }
            if (this.test == 0) {
                GMSSRootSig gMSSRootSig = this;
                GMSSRootSig gMSSRootSig3 = this;
                byte[] byArray = gMSSRootSig3.sign;
                int n11 = this.mdsize;
                n7 = gMSSRootSig3.counter * n11;
                System.arraycopy(gMSSRootSig.privateKeyOTS, 0, byArray, n7, n11);
                gMSSRootSig.big8 >>>= this.w;
                ++gMSSRootSig.counter;
            }
        } else if (n3 < 57) {
            long l5 = this.test8;
            if (l5 == 0L) {
                this.big8 = 0L;
                this.ii = 0;
                int n12 = this.r;
                int n13 = n12 % 8;
                int n14 = n12 >>> 3;
                int n15 = this.mdsize;
                if (n14 < n15) {
                    long l6;
                    if (n12 <= (n15 << 3) - n3) {
                        this.r = n12 + n3;
                        n15 = this.r + 7 >>> 3;
                    } else {
                        this.r = n12 + n3;
                    }
                    while (n14 < n15) {
                        GMSSRootSig gMSSRootSig = this;
                        long l7 = gMSSRootSig.big8;
                        int n16 = gMSSRootSig.hash[n14] & 0xFF;
                        int n17 = gMSSRootSig.ii;
                        this.big8 = l7 ^ (long)(n16 << (n17 << 3));
                        gMSSRootSig.ii = n17 + 1;
                        ++n14;
                    }
                    this.big8 = l6 = this.big8 >>> n13;
                    this.test8 = l6 & (long)this.k;
                } else {
                    n12 = this.checksum;
                    this.test8 = n12 & this.k;
                    this.checksum = n12 >>> n3;
                }
                this.privateKeyOTS = this.gmssRandom.nextSeed(this.seed);
            } else if (l5 > 0L) {
                GMSSRootSig gMSSRootSig = this;
                gMSSRootSig.messDigestOTS.update(this.privateKeyOTS, 0, this.privateKeyOTS.length);
                byte[] byArray = new byte[gMSSRootSig.messDigestOTS.getDigestSize()];
                gMSSRootSig.privateKeyOTS = byArray;
                gMSSRootSig.messDigestOTS.doFinal(byArray, 0);
                --gMSSRootSig.test8;
            }
            if (this.test8 == 0L) {
                GMSSRootSig gMSSRootSig = this;
                GMSSRootSig gMSSRootSig4 = this;
                byte[] byArray = gMSSRootSig4.sign;
                int n18 = this.mdsize;
                int n19 = gMSSRootSig4.counter * n18;
                System.arraycopy(gMSSRootSig.privateKeyOTS, 0, byArray, n19, n18);
                ++gMSSRootSig.counter;
            }
        }
    }

    public void initSign(byte[] byArray, byte[] byArray2) {
        int n3;
        GMSSRootSig gMSSRootSig = object;
        gMSSRootSig.hash = new byte[gMSSRootSig.mdsize];
        gMSSRootSig.messDigestOTS.update(byArray2, 0, byArray2.length);
        byArray2 = new byte[gMSSRootSig.messDigestOTS.getDigestSize()];
        gMSSRootSig.hash = byArray2;
        gMSSRootSig.messDigestOTS.doFinal(byArray2, 0);
        int n4 = gMSSRootSig.mdsize;
        byte[] byArray3 = new byte[n4];
        System.arraycopy(gMSSRootSig.hash, 0, byArray3, 0, n4);
        n4 = 0;
        int n5 = gMSSRootSig.getLog((gMSSRootSig.messagesize << ((GMSSRootSig)object).w) + 1);
        int n6 = gMSSRootSig.w;
        if (8 % n6 == 0) {
            int n7;
            n6 = 8 / n6;
            for (int i3 = 0; i3 < ((GMSSRootSig)object).mdsize; ++i3) {
                for (int i4 = 0; i4 < n6; ++i4) {
                    byte by = byArray3[i3];
                    n4 += by & ((GMSSRootSig)object).k;
                    byArray3[i3] = (byte)(by >>> ((GMSSRootSig)object).w);
                }
            }
            ((GMSSRootSig)object).checksum = n7 = (((GMSSRootSig)object).messagesize << ((GMSSRootSig)object).w) - n4;
            n6 = 0;
            while (n6 < n5) {
                int n8 = n6;
                int n9 = n7;
                n4 += n7 & ((GMSSRootSig)object).k;
                n7 = ((GMSSRootSig)object).w;
                n6 = n9 >>> n7;
                int n10 = n7 = n8 + n7;
                n7 = n6;
                n6 = n10;
            }
        } else if (n6 < 8) {
            int n11 = 0;
            n6 = ((GMSSRootSig)object).mdsize / n6;
            for (int i5 = 0; i5 < n6; ++i5) {
                int n12;
                long l3 = 0L;
                for (n12 = 0; n12 < ((GMSSRootSig)object).w; ++n12) {
                    l3 ^= (long)((byArray3[n11] & 0xFF) << (n12 << 3));
                    ++n11;
                }
                for (n12 = 0; n12 < 8; ++n12) {
                    n4 += (int)(l3 & (long)((GMSSRootSig)object).k);
                    l3 >>>= ((GMSSRootSig)object).w;
                }
            }
            n6 = ((GMSSRootSig)object).mdsize % ((GMSSRootSig)object).w;
            long l4 = 0L;
            for (int i6 = 0; i6 < n6; ++i6) {
                l4 ^= (long)((byArray3[n11] & 0xFF) << (i6 << 3));
                ++n11;
            }
            int n13 = n6 << 3;
            n6 = 0;
            while (n6 < n13) {
                int n14 = n6;
                n4 += (int)(l4 & (long)((GMSSRootSig)object).k);
                n6 = ((GMSSRootSig)object).w;
                l4 >>>= n6;
                n6 = n14 + n6;
            }
            ((GMSSRootSig)object).checksum = n13 = (((GMSSRootSig)object).messagesize << ((GMSSRootSig)object).w) - n4;
            n6 = 0;
            while (n6 < n5) {
                int n15 = n6;
                int n16 = n13;
                n4 += n13 & ((GMSSRootSig)object).k;
                n13 = ((GMSSRootSig)object).w;
                n6 = n16 >>> n13;
                int n17 = n13 = n15 + n13;
                n13 = n6;
                n6 = n17;
            }
        } else if (n6 < 57) {
            int n18;
            int n19;
            int n20;
            n6 = 0;
            while (n6 <= ((n20 = ((GMSSRootSig)object).mdsize) << 3) - (n19 = ((GMSSRootSig)object).w)) {
                int n21 = n6;
                int n22 = n6;
                n20 = n22 % 8;
                n19 = n21 + n19;
                int n23 = n19 + 7 >>> 3;
                long l5 = 0L;
                int n24 = 0;
                for (n6 = (v1260951) >>> 3; n6 < n23; ++n6) {
                    l5 ^= (long)((byArray3[n6] & 0xFF) << (n24 << 3));
                    ++n24;
                }
                long l6 = l5 >>> n20;
                n4 = (int)((long)n4 + (l6 & (long)((GMSSRootSig)object).k));
                n6 = n19;
            }
            n19 = n6 >>> 3;
            if (n19 < n20) {
                n6 %= 8;
                long l7 = 0L;
                n20 = 0;
                while (n19 < ((GMSSRootSig)object).mdsize) {
                    l7 ^= (long)((byArray3[n19] & 0xFF) << (n20 << 3));
                    ++n20;
                    ++n19;
                }
                long l8 = l7 >>> n6;
                n4 = (int)((long)n4 + (l8 & (long)((GMSSRootSig)object).k));
            }
            ((GMSSRootSig)object).checksum = n18 = (((GMSSRootSig)object).messagesize << ((GMSSRootSig)object).w) - n4;
            int n25 = 0;
            while (n25 < n5) {
                int n26 = n25;
                int n27 = n18;
                n4 += n18 & ((GMSSRootSig)object).k;
                n18 = ((GMSSRootSig)object).w;
                n25 = n27 >>> n18;
                int n28 = n18 = n26 + n18;
                n18 = n25;
                n25 = n28;
            }
        }
        GMSSRootSig gMSSRootSig2 = object;
        ((GMSSRootSig)object).keysize = n3 = gMSSRootSig2.messagesize + (int)Math.ceil((double)n5 / (double)((GMSSRootSig)object).w);
        gMSSRootSig2.steps = (int)Math.ceil((double)(n3 + n4) / (double)(1 << ((GMSSRootSig)object).height));
        n3 = gMSSRootSig2.keysize;
        n4 = gMSSRootSig2.mdsize;
        GMSSRootSig gMSSRootSig3 = object;
        gMSSRootSig3.sign = new byte[n3 * n4];
        gMSSRootSig3.counter = 0;
        gMSSRootSig3.test = 0;
        gMSSRootSig3.ii = 0;
        gMSSRootSig3.test8 = 0L;
        gMSSRootSig3.r = 0;
        ((GMSSRootSig)object).privateKeyOTS = new byte[n4];
        byte[] byArray4 = new byte[n4];
        Object object = byArray4;
        gMSSRootSig2.seed = byArray4;
        System.arraycopy(byArray, 0, object, 0, n4);
    }

    public boolean updateSign() {
        for (int i3 = 0; i3 < this.steps; ++i3) {
            if (this.counter < this.keysize) {
                this.oneStep();
            }
            if (this.counter != this.keysize) continue;
            return true;
        }
        return false;
    }

    public byte[] getSig() {
        return this.sign;
    }

    public int getLog(int n3) {
        int n4 = 1;
        int n5 = 2;
        while (n5 < n3) {
            n5 <<= 1;
            ++n4;
        }
        return n4;
    }

    public byte[][] getStatByte() {
        byte[][] byArray = new byte[5][this.mdsize];
        byte[][] byArray2 = byArray;
        byArray2[0] = this.privateKeyOTS;
        byArray2[1] = this.seed;
        byArray2[2] = this.hash;
        byArray2[3] = this.sign;
        byArray[4] = this.getStatLong();
        return byArray;
    }

    public int[] getStatInt() {
        int[] nArray = new int[9];
        int[] nArray2 = nArray;
        nArray2[0] = this.counter;
        nArray2[1] = this.test;
        nArray2[2] = this.ii;
        nArray2[3] = this.r;
        nArray2[4] = this.steps;
        nArray2[5] = this.keysize;
        nArray2[6] = this.height;
        nArray2[7] = this.w;
        nArray[8] = this.checksum;
        return nArray;
    }

    public byte[] getStatLong() {
        byte[] byArray = new byte[16];
        byte[] byArray2 = byArray;
        long l3 = this.test8;
        byArray2[0] = (byte)(l3 & 0xFFL);
        byArray2[1] = (byte)(l3 >> 8 & 0xFFL);
        byArray2[2] = (byte)(l3 >> 16 & 0xFFL);
        byArray2[3] = (byte)(l3 >> 24 & 0xFFL);
        byArray2[4] = (byte)(l3 >> 32 & 0xFFL);
        byArray2[5] = (byte)(l3 >> 40 & 0xFFL);
        byArray2[6] = (byte)(l3 >> 48 & 0xFFL);
        byArray2[7] = (byte)(l3 >> 56 & 0xFFL);
        l3 = this.big8;
        byArray2[8] = (byte)(l3 & 0xFFL);
        byArray2[9] = (byte)(l3 >> 8 & 0xFFL);
        byArray2[10] = (byte)(l3 >> 16 & 0xFFL);
        byArray2[11] = (byte)(l3 >> 24 & 0xFFL);
        byArray2[12] = (byte)(l3 >> 32 & 0xFFL);
        byArray2[13] = (byte)(l3 >> 40 & 0xFFL);
        byArray2[14] = (byte)(l3 >> 48 & 0xFFL);
        byArray[15] = (byte)(l3 >> 56 & 0xFFL);
        return byArray;
    }

    public String toString() {
        GMSSRootSig gMSSRootSig = object;
        Object object = b.a("").append(((GMSSRootSig)object).big8).append("  ").toString();
        int[] nArray = gMSSRootSig.getStatInt();
        byte[][] byArray = new byte[5][gMSSRootSig.mdsize].getStatByte();
        for (int i3 = 0; i3 < 9; ++i3) {
            object = com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.b.a(b.a((String)object), nArray[i3], " ");
        }
        for (int i4 = 0; i4 < 5; ++i4) {
            object = a.a(b.a((String)object), new String(Hex.encode(byArray[i4])), " ");
        }
        return object;
    }
}

