/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.MessageSigner;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.GMSSDigestProvider;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.GMSSKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.GMSSParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.GMSSPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.GMSSPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.util.GMSSRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.util.GMSSUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.util.WinternitzOTSVerify;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.util.WinternitzOTSignature;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class GMSSSigner
implements MessageSigner {
    private GMSSUtil gmssUtil;
    private byte[] pubKeyBytes;
    private Digest messDigestTrees;
    private int mdLength;
    private int numLayer;
    private Digest messDigestOTS;
    private WinternitzOTSignature ots;
    private GMSSDigestProvider digestProvider;
    private int[] index;
    private byte[][][] currentAuthPaths;
    private byte[][] subtreeRootSig;
    private GMSSParameters gmssPS;
    private GMSSRandom gmssRandom;
    public GMSSKeyParameters key;
    private SecureRandom random;

    public GMSSSigner(GMSSDigestProvider object) {
        GMSSSigner gMSSSigner = this;
        this.gmssUtil = new GMSSUtil();
        this.digestProvider = object;
        object = object.get();
        gMSSSigner.messDigestTrees = object;
        gMSSSigner.messDigestOTS = object;
        gMSSSigner.mdLength = object.getDigestSize();
        gMSSSigner.gmssRandom = new GMSSRandom(this.messDigestTrees);
    }

    private void initSign() {
        GMSSSigner gMSSSigner = this;
        gMSSSigner.messDigestTrees.reset();
        GMSSPrivateKeyParameters gMSSPrivateKeyParameters = (GMSSPrivateKeyParameters)gMSSSigner.key;
        if (!gMSSPrivateKeyParameters.isUsed()) {
            if (gMSSPrivateKeyParameters.getIndex(0) < gMSSPrivateKeyParameters.getNumLeafs(0)) {
                int n3;
                int n4;
                Object object;
                GMSSParameters gMSSParameters;
                GMSSSigner gMSSSigner2 = this;
                gMSSSigner2.gmssPS = gMSSParameters = gMSSPrivateKeyParameters.getParameters();
                gMSSSigner2.numLayer = gMSSParameters.getNumOfLayers();
                int n5 = this.mdLength;
                byte[] cfr_ignored_0 = new byte[n5];
                byte[] byArray = new byte[n5];
                System.arraycopy(gMSSPrivateKeyParameters.getCurrentSeeds()[this.numLayer - 1], 0, byArray, 0, n5);
                byte[] byArray2 = object = this.gmssRandom.nextSeed(byArray);
                GMSSSigner gMSSSigner3 = this;
                object = gMSSSigner3.digestProvider.get();
                this.ots = new WinternitzOTSignature(byArray2, (Digest)object, gMSSSigner3.gmssPS.getWinternitzParameter()[this.numLayer - 1]);
                object = gMSSPrivateKeyParameters.getCurrentAuthPaths();
                this.currentAuthPaths = new byte[this.numLayer][][];
                for (n4 = 0; n4 < (n3 = this.numLayer); ++n4) {
                    Object object2;
                    this.currentAuthPaths[n4] = new byte[((byte)object[n4]).length][this.mdLength];
                    for (n3 = 0; n3 < ((byte)(object2 = object[n4])).length; ++n3) {
                        void v4 = object2[n3];
                        GMSSSigner gMSSSigner4 = this;
                        object2 = gMSSSigner4.currentAuthPaths[n4][n3];
                        int n6 = gMSSSigner4.mdLength;
                        System.arraycopy(v4, 0, object2, 0, n6);
                    }
                }
                this.index = new int[n3];
                GMSSSigner gMSSSigner5 = this;
                object = gMSSSigner5.index;
                n4 = gMSSSigner5.numLayer;
                System.arraycopy(gMSSPrivateKeyParameters.getIndex(), 0, object, 0, n4);
                this.subtreeRootSig = new byte[this.numLayer - 1][];
                for (int i3 = 0; i3 < this.numLayer - 1; ++i3) {
                    byte[] byArray3 = gMSSPrivateKeyParameters.getSubtreeRootSig(i3);
                    byte[] byArray4 = byArray3;
                    byArray4 = new byte[byArray4.length];
                    this.subtreeRootSig[i3] = byArray4;
                    n3 = byArray3.length;
                    System.arraycopy(byArray3, 0, byArray4, 0, n3);
                }
                gMSSPrivateKeyParameters.markUsed();
                return;
            }
            throw new IllegalStateException("No more signatures can be generated");
        }
        throw new IllegalStateException("Private key already used");
    }

    private void initVerify() {
        GMSSSigner gMSSSigner = gMSSParameters;
        gMSSSigner.messDigestTrees.reset();
        GMSSPublicKeyParameters gMSSPublicKeyParameters = (GMSSPublicKeyParameters)gMSSSigner.key;
        ((GMSSSigner)((Object)gMSSParameters)).pubKeyBytes = gMSSPublicKeyParameters.getPublicKey();
        GMSSParameters gMSSParameters = gMSSPublicKeyParameters.getParameters();
        gMSSSigner.gmssPS = gMSSParameters;
        gMSSSigner.numLayer = gMSSParameters.getNumOfLayers();
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        if (bl) {
            if (cipherParameters instanceof ParametersWithRandom) {
                GMSSSigner gMSSSigner = parametersWithRandom;
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
                gMSSSigner.random = parametersWithRandom.getRandom();
                gMSSSigner.key = (GMSSPrivateKeyParameters)parametersWithRandom.getParameters();
                gMSSSigner.initSign();
            } else {
                ((GMSSSigner)((Object)parametersWithRandom)).random = CryptoServicesRegistrar.getSecureRandom();
                ((GMSSSigner)((Object)parametersWithRandom)).key = (GMSSPrivateKeyParameters)cipherParameters;
                ((GMSSSigner)((Object)parametersWithRandom)).initSign();
            }
        } else {
            ((GMSSSigner)((Object)parametersWithRandom)).key = (GMSSPublicKeyParameters)cipherParameters;
            ((GMSSSigner)((Object)parametersWithRandom)).initVerify();
        }
    }

    @Override
    public byte[] generateSignature(byte[] byArray) {
        GMSSSigner gMSSSigner = object;
        byte[] cfr_ignored_0 = new byte[gMSSSigner.mdLength];
        byArray = gMSSSigner.ots.getSignature(byArray);
        byte[] byArray2 = gMSSSigner.gmssUtil.concatenateArray(((GMSSSigner)object).currentAuthPaths[((GMSSSigner)object).numLayer - 1]);
        byte[] byArray3 = ((GMSSSigner)object).gmssUtil.intToBytesLittleEndian(((GMSSSigner)object).index[((GMSSSigner)object).numLayer - 1]);
        int n3 = byArray3.length + byArray.length + byArray2.length;
        byte[] byArray4 = new byte[n3];
        int n4 = byArray3.length;
        System.arraycopy(byArray3, 0, byArray4, 0, n4);
        n4 = byArray3.length;
        int n5 = byArray.length;
        System.arraycopy(byArray, 0, byArray4, n4, n5);
        int n6 = byArray3.length + byArray.length;
        int n7 = byArray2.length;
        System.arraycopy(byArray2, 0, byArray4, n6, n7);
        byte[] byArray5 = new byte[]{};
        for (n7 = (v1261676).numLayer - 1 - 1; n7 >= 0; --n7) {
            byte[] byArray6 = ((GMSSSigner)object).gmssUtil.concatenateArray(((GMSSSigner)object).currentAuthPaths[n7]);
            byte[] byArray7 = ((GMSSSigner)object).gmssUtil.intToBytesLittleEndian(((GMSSSigner)object).index[n7]);
            int n8 = byArray5.length;
            byte[] byArray8 = new byte[n8];
            int n9 = byArray5.length;
            System.arraycopy(byArray5, 0, byArray8, 0, n9);
            byArray5 = new byte[n8 + byArray7.length + ((GMSSSigner)object).subtreeRootSig[n7].length + byArray6.length];
            System.arraycopy(byArray8, 0, byArray5, 0, n8);
            n4 = byArray7.length;
            System.arraycopy(byArray7, 0, byArray5, n8, n4);
            byte[] byArray9 = ((GMSSSigner)object).subtreeRootSig[n7];
            n4 = n8 + byArray7.length;
            n5 = byArray9.length;
            System.arraycopy(byArray9, 0, byArray5, n4, n5);
            n4 = n8 + byArray7.length + ((GMSSSigner)object).subtreeRootSig[n7].length;
            n5 = byArray6.length;
            System.arraycopy(byArray6, 0, byArray5, n4, n5);
        }
        byte[] byArray10 = new byte[n3 + byArray5.length];
        Object object = byArray10;
        System.arraycopy(byArray4, 0, object, 0, n3);
        int n10 = byArray5.length;
        System.arraycopy(byArray5, 0, object, n3, n10);
        return byArray10;
    }

    @Override
    public boolean verifySignature(byte[] byArray, byte[] byArray2) {
        this.messDigestOTS.reset();
        int n3 = 0;
        for (int i3 = (v1261871).numLayer - 1; i3 >= 0; --i3) {
            int n4;
            int n5;
            WinternitzOTSVerify winternitzOTSVerify;
            WinternitzOTSVerify winternitzOTSVerify2;
            WinternitzOTSVerify winternitzOTSVerify3 = winternitzOTSVerify2 = winternitzOTSVerify;
            winternitzOTSVerify3(this.digestProvider.get(), this.gmssPS.getWinternitzParameter()[i3]);
            int n6 = winternitzOTSVerify3.getSignatureLength();
            int n7 = this.gmssUtil.bytesToIntLittleEndian(byArray2, n3);
            byte[] byArray3 = new byte[n6];
            System.arraycopy(byArray2, n3 += 4, byArray3, 0, n6);
            n6 = n3 + n6;
            byArray3 = winternitzOTSVerify.Verify(byArray, byArray3);
            if (byArray3 == null) {
                System.err.println("OTS Public Key is null in GMSSSignature.verify");
                return false;
            }
            byte[][] byArray4 = new byte[this.gmssPS.getHeightOfTrees()[i3]][this.mdLength];
            for (n5 = 0; n5 < byArray4.length; ++n5) {
                byte[] byArray5 = byArray4[n5];
                n4 = this.mdLength;
                System.arraycopy(byArray2, n6, byArray5, 0, n4);
                n6 += this.mdLength;
            }
            byte[] cfr_ignored_0 = new byte[this.mdLength];
            n7 = (1 << byArray4.length) + n7;
            for (n5 = 0; n5 < byArray4.length; ++n5) {
                int n8;
                n4 = this.mdLength;
                int n9 = n4 << 1;
                byte[] byArray6 = new byte[n9];
                if (n7 % 2 == 0) {
                    System.arraycopy(byArray3, 0, byArray6, 0, n4);
                    int n10 = n8 = this.mdLength;
                    System.arraycopy(byArray4[n5], 0, byArray6, n10, n10);
                    n7 = n8 = n7 / 2;
                } else {
                    int n11 = n7;
                    System.arraycopy(byArray4[n5], 0, byArray6, 0, n4);
                    n8 = this.mdLength;
                    n7 = byArray3.length;
                    System.arraycopy(byArray3, 0, byArray6, n8, n7);
                    n7 = n8 = (n11 - 1) / 2;
                }
                GMSSSigner gMSSSigner = this;
                gMSSSigner.messDigestTrees.update(byArray6, 0, n9);
                byArray3 = new byte[gMSSSigner.messDigestTrees.getDigestSize()];
                gMSSSigner.messDigestTrees.doFinal(byArray3, 0);
            }
            n3 = n6;
            byArray = byArray3;
        }
        return Arrays.areEqual(this.pubKeyBytes, byArray);
    }
}

