/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.e;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.i;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.util.GMSSRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Integers;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import d.a;
import java.util.Vector;

public class Treehash {
    private int maxHeight;
    private Vector tailStack;
    private Vector heightOfNodes;
    private byte[] firstNode;
    private byte[] seedActive;
    private byte[] seedNext;
    private int tailLength;
    private int firstNodeHeight;
    private boolean isInitialized;
    private boolean isFinished;
    private boolean seedInitialized;
    private Digest messDigestTree;

    public Treehash(Digest object, byte[][] byArray, int[] nArray) {
        int n3;
        Vector vector;
        this.messDigestTree = object;
        this.maxHeight = nArray[0];
        this.tailLength = nArray[1];
        this.firstNodeHeight = nArray[2];
        this.isFinished = nArray[3] == 1;
        this.isInitialized = nArray[4] == 1;
        this.seedInitialized = nArray[5] == 1;
        object = vector;
        vector = new Vector();
        this.heightOfNodes = object;
        for (n3 = 0; n3 < this.tailLength; ++n3) {
            this.heightOfNodes.addElement(Integers.valueOf(nArray[n3 + 6]));
        }
        Treehash treehash = this;
        this.firstNode = byArray[0];
        this.seedActive = byArray[1];
        treehash.seedNext = byArray[2];
        treehash.tailStack = new Vector();
        for (n3 = 0; n3 < this.tailLength; ++n3) {
            this.tailStack.addElement(byArray[n3 + 3]);
        }
    }

    public Treehash(Vector vector, int n3, Digest digest) {
        Treehash treehash = this;
        this.tailStack = vector;
        treehash.maxHeight = n3;
        treehash.firstNode = null;
        treehash.isInitialized = false;
        treehash.isFinished = false;
        treehash.seedInitialized = false;
        this.messDigestTree = digest;
        this.seedNext = new byte[digest.getDigestSize()];
        this.seedActive = new byte[this.messDigestTree.getDigestSize()];
    }

    public void initializeSeed(byte[] byArray) {
        Treehash treehash = object;
        Treehash treehash2 = object;
        Object object = treehash2.seedNext;
        int n3 = treehash2.messDigestTree.getDigestSize();
        System.arraycopy(byArray, 0, object, 0, n3);
        treehash.seedInitialized = true;
    }

    public void initialize() {
        if (((Treehash)object).seedInitialized) {
            Treehash treehash;
            ((Treehash)object).heightOfNodes = new Vector();
            ((Treehash)object).tailLength = 0;
            ((Treehash)object).firstNode = null;
            ((Treehash)object).firstNodeHeight = -1;
            ((Treehash)object).isInitialized = true;
            Treehash treehash2 = object;
            Object object = treehash2.seedActive;
            int n3 = treehash2.messDigestTree.getDigestSize();
            System.arraycopy(treehash.seedNext, 0, object, 0, n3);
            return;
        }
        throw new IllegalStateException(b.a(b.b.a("Seed "), ((Treehash)object).maxHeight, " not initialized"));
    }

    public void update(GMSSRandom gMSSRandom, byte[] byArray) {
        if (this.isFinished) {
            System.err.println("No more update possible for treehash instance!");
            return;
        }
        if (!this.isInitialized) {
            System.err.println("Treehash instance not initialized before update");
            return;
        }
        Treehash treehash = this;
        byte[] cfr_ignored_0 = new byte[treehash.messDigestTree.getDigestSize()];
        gMSSRandom.nextSeed(treehash.seedActive);
        if (this.firstNode == null) {
            Treehash treehash2 = this;
            treehash2.firstNode = byArray;
            treehash2.firstNodeHeight = 0;
        } else {
            int n3;
            int n4 = 0;
            while (this.tailLength > 0 && n4 == (Integer)this.heightOfNodes.lastElement()) {
                Treehash treehash3 = this;
                Treehash treehash4 = this;
                int n5 = treehash4.messDigestTree.getDigestSize() << 1;
                byte[] byArray2 = new byte[n5];
                n3 = this.messDigestTree.getDigestSize();
                System.arraycopy(treehash4.tailStack.lastElement(), 0, byArray2, 0, n3);
                Vector vector = treehash4.tailStack;
                vector.removeElementAt(vector.size() - 1);
                Vector vector2 = treehash4.heightOfNodes;
                vector2.removeElementAt(vector2.size() - 1);
                n3 = treehash4.messDigestTree.getDigestSize();
                int n6 = treehash4.messDigestTree.getDigestSize();
                System.arraycopy(byArray, 0, byArray2, n3, n6);
                treehash3.messDigestTree.update(byArray2, 0, n5);
                byArray = new byte[treehash3.messDigestTree.getDigestSize()];
                treehash3.messDigestTree.doFinal(byArray, 0);
                ++n4;
                --treehash3.tailLength;
            }
            Treehash treehash5 = this;
            treehash5.tailStack.addElement(byArray);
            treehash5.heightOfNodes.addElement(Integers.valueOf(n4));
            ++treehash5.tailLength;
            if ((Integer)treehash5.heightOfNodes.lastElement() == this.firstNodeHeight) {
                Treehash treehash6 = this;
                n4 = treehash6.messDigestTree.getDigestSize() << 1;
                byArray = new byte[n4];
                int n7 = this.messDigestTree.getDigestSize();
                System.arraycopy(treehash6.firstNode, 0, byArray, 0, n7);
                Treehash treehash7 = this;
                n7 = treehash7.messDigestTree.getDigestSize();
                n3 = treehash7.messDigestTree.getDigestSize();
                System.arraycopy(treehash6.tailStack.lastElement(), 0, byArray, n7, n3);
                Vector vector = treehash6.tailStack;
                vector.removeElementAt(vector.size() - 1);
                Vector vector3 = treehash6.heightOfNodes;
                vector3.removeElementAt(vector3.size() - 1);
                treehash6.messDigestTree.update(byArray, 0, n4);
                byte[] byArray3 = new byte[treehash6.messDigestTree.getDigestSize()];
                treehash6.firstNode = byArray3;
                treehash6.messDigestTree.doFinal(byArray3, 0);
                ++treehash6.firstNodeHeight;
                treehash6.tailLength = 0;
            }
        }
        if (this.firstNodeHeight == this.maxHeight) {
            this.isFinished = true;
        }
    }

    public void destroy() {
        Treehash treehash = this;
        treehash.isInitialized = false;
        treehash.isFinished = false;
        treehash.firstNode = null;
        treehash.tailLength = 0;
        treehash.firstNodeHeight = -1;
    }

    public int getLowestNodeHeight() {
        if (this.firstNode == null) {
            return this.maxHeight;
        }
        if (this.tailLength == 0) {
            return this.firstNodeHeight;
        }
        return Math.min(this.firstNodeHeight, (Integer)this.heightOfNodes.lastElement());
    }

    public int getFirstNodeHeight() {
        if (this.firstNode == null) {
            return this.maxHeight;
        }
        return this.firstNodeHeight;
    }

    public boolean wasInitialized() {
        return this.isInitialized;
    }

    public boolean wasFinished() {
        return this.isFinished;
    }

    public byte[] getFirstNode() {
        return this.firstNode;
    }

    public byte[] getSeedActive() {
        return this.seedActive;
    }

    public void setFirstNode(byte[] byArray) {
        if (!this.isInitialized) {
            this.initialize();
        }
        this.firstNode = byArray;
        this.firstNodeHeight = this.maxHeight;
        this.isFinished = true;
    }

    public void updateNextSeed(GMSSRandom gMSSRandom) {
        gMSSRandom.nextSeed(this.seedNext);
    }

    public Vector getTailStack() {
        return this.tailStack;
    }

    public byte[][] getStatByte() {
        byte[][] byArray = new byte[this.tailLength + 3][this.messDigestTree.getDigestSize()];
        byte[][] byArray2 = byArray;
        byArray2[0] = this.firstNode;
        byArray2[1] = this.seedActive;
        byArray[2] = this.seedNext;
        for (int i3 = 0; i3 < this.tailLength; ++i3) {
            byArray2[i3 + 3] = (byte[])this.tailStack.elementAt(i3);
        }
        return byArray2;
    }

    public int[] getStatInt() {
        Treehash treehash = this;
        int n3 = treehash.tailLength;
        int[] nArray = new int[n3 + 6];
        int[] nArray2 = nArray;
        nArray2[0] = this.maxHeight;
        nArray2[1] = n3;
        nArray[2] = this.firstNodeHeight;
        nArray2[3] = treehash.isFinished ? 1 : 0;
        nArray2[4] = this.isInitialized ? 1 : 0;
        nArray2[5] = this.seedInitialized ? 1 : 0;
        for (n3 = 0; n3 < this.tailLength; ++n3) {
            nArray2[n3 + 6] = (Integer)this.heightOfNodes.elementAt(n3);
        }
        return nArray2;
    }

    public String toString() {
        int n3;
        String string2 = "Treehash    : ";
        for (n3 = 0; n3 < this.tailLength + 6; ++n3) {
            string2 = b.a(b.b.a(string2), this.getStatInt()[n3], " ");
        }
        for (n3 = 0; n3 < this.tailLength + 3; ++n3) {
            string2 = this.getStatByte()[n3] != null ? a.a(b.b.a(string2), new String(Hex.encode(this.getStatByte()[n3])), " ") : i.a(string2, "null ");
        }
        return e.a(string2, "  ").append(this.messDigestTree.getDigestSize()).toString();
    }
}

