/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.util;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.util.GMSSRandom;

public class WinternitzOTSignature {
    private Digest messDigestOTS;
    private int mdsize;
    private int keysize;
    private byte[][] privateKeyOTS;
    private int w;
    private GMSSRandom gmssRandom;
    private int messagesize;
    private int checksumsize;

    public WinternitzOTSignature(byte[] byArray, Digest object, int n3) {
        int n4;
        WinternitzOTSignature winternitzOTSignature = this;
        this.w = n3;
        winternitzOTSignature.messDigestOTS = object;
        winternitzOTSignature.gmssRandom = new GMSSRandom((Digest)object);
        this.mdsize = winternitzOTSignature.messDigestOTS.getDigestSize();
        this.messagesize = n4 = ((this.mdsize << 3) + n3 - 1) / n3;
        int n5 = winternitzOTSignature.getLog((n4 << n3) + 1);
        this.checksumsize = n4 = n5;
        n4 = this.messagesize;
        winternitzOTSignature.keysize = n4 = (n5 + n3 - 1) / n3 + n4;
        winternitzOTSignature.privateKeyOTS = new byte[n4][];
        n4 = winternitzOTSignature.mdsize;
        object = new byte[n4];
        System.arraycopy(byArray, 0, object, 0, n4);
        for (n4 = 0; n4 < this.keysize; ++n4) {
            this.privateKeyOTS[n4] = this.gmssRandom.nextSeed((byte[])object);
        }
    }

    private void hashPrivateKeyBlock(int n3, int n4, byte[] byArray, int n5) {
        if (n4 < 1) {
            int n6 = this.mdsize;
            System.arraycopy(this.privateKeyOTS[n3], 0, byArray, n5, n6);
        } else {
            WinternitzOTSignature winternitzOTSignature = this;
            WinternitzOTSignature winternitzOTSignature2 = this;
            byte[] byArray2 = winternitzOTSignature2.privateKeyOTS[n3];
            int n7 = winternitzOTSignature2.mdsize;
            winternitzOTSignature.messDigestOTS.update(byArray2, 0, n7);
            winternitzOTSignature.messDigestOTS.doFinal(byArray, n5);
            while ((n4 += -1) > 0) {
                WinternitzOTSignature winternitzOTSignature3 = this;
                winternitzOTSignature3.messDigestOTS.update(byArray, n5, this.mdsize);
                winternitzOTSignature3.messDigestOTS.doFinal(byArray, n5);
            }
        }
    }

    public byte[][] getPrivateKey() {
        return this.privateKeyOTS;
    }

    public byte[] getPublicKey() {
        WinternitzOTSignature winternitzOTSignature = this;
        int n3 = winternitzOTSignature.keysize * this.mdsize;
        byte[] byArray = new byte[n3];
        int n4 = 0;
        int n5 = (1 << winternitzOTSignature.w) - 1;
        for (int i3 = 0; i3 < this.keysize; ++i3) {
            WinternitzOTSignature winternitzOTSignature2 = this;
            winternitzOTSignature2.hashPrivateKeyBlock(i3, n5, byArray, n4);
            n4 += winternitzOTSignature2.mdsize;
        }
        WinternitzOTSignature winternitzOTSignature3 = this;
        winternitzOTSignature3.messDigestOTS.update(byArray, 0, n3);
        byte[] byArray2 = new byte[winternitzOTSignature3.mdsize];
        this.messDigestOTS.doFinal(byArray2, 0);
        return byArray2;
    }

    public byte[] getSignature(byte[] byArray) {
        byte[] byArray2;
        block18: {
            int n3;
            int n4;
            int n5;
            int n6;
            byte[] byArray3;
            int n7;
            block19: {
                int n8;
                block17: {
                    WinternitzOTSignature winternitzOTSignature = this;
                    int n9 = winternitzOTSignature.keysize;
                    n7 = winternitzOTSignature.mdsize;
                    byArray2 = new byte[n9 * n7];
                    byArray3 = new byte[n7];
                    n6 = 0;
                    n5 = 0;
                    winternitzOTSignature.messDigestOTS.update(byArray, 0, byArray.length);
                    winternitzOTSignature.messDigestOTS.doFinal(byArray3, 0);
                    n4 = winternitzOTSignature.w;
                    if (8 % n4 != 0) break block17;
                    int n10 = 8 / n4;
                    n4 = (1 << n4) - 1;
                    for (int i3 = 0; i3 < n7; ++i3) {
                        for (int i4 = 0; i4 < n10; ++i4) {
                            int n11 = n6++;
                            int n12 = n5;
                            n5 = byArray3[i3] & n4;
                            int n13 = n12 + n5;
                            int n14 = n11 * this.mdsize;
                            this.hashPrivateKeyBlock(n11, n5, byArray2, n14);
                            byArray3[i3] = (byte)(byArray3[i3] >>> this.w);
                            n5 = n13;
                        }
                    }
                    n7 = (this.messagesize << this.w) - n5;
                    int n15 = 0;
                    while (n15 < this.checksumsize) {
                        int n16 = n15;
                        int n17 = n7;
                        WinternitzOTSignature winternitzOTSignature2 = this;
                        int n18 = n6++;
                        n15 = n18 * this.mdsize;
                        winternitzOTSignature2.hashPrivateKeyBlock(n18, n7 &= n4, byArray2, n15);
                        n7 = winternitzOTSignature2.w;
                        n15 = n17 >>> n7;
                        int n19 = n7 = n16 + n7;
                        n7 = n15;
                        n15 = n19;
                    }
                    break block18;
                }
                if (n4 >= 8) break block19;
                n7 = this.mdsize / n4;
                n4 = (1 << n4) - 1;
                int n20 = 0;
                for (int i5 = 0; i5 < n7; ++i5) {
                    int n21;
                    long l3 = 0L;
                    for (n21 = 0; n21 < this.w; ++n21) {
                        l3 ^= (long)((byArray3[n20] & 0xFF) << (n21 << 3));
                        ++n20;
                    }
                    for (n21 = 0; n21 < 8; ++n21) {
                        WinternitzOTSignature winternitzOTSignature = this;
                        int n22 = n6++;
                        int n23 = n5;
                        n5 = (int)l3 & n4;
                        int n24 = n23 + n5;
                        n8 = n22 * this.mdsize;
                        winternitzOTSignature.hashPrivateKeyBlock(n22, n5, byArray2, n8);
                        long l4 = l3 >>> winternitzOTSignature.w;
                        l3 = l4;
                        n5 = n24;
                    }
                }
                n7 = this.mdsize % this.w;
                long l5 = 0L;
                for (n8 = 0; n8 < n7; ++n8) {
                    l5 ^= (long)((byArray3[n20] & 0xFF) << (n8 << 3));
                    ++n20;
                }
                n7 <<= 3;
                int n25 = 0;
                while (n25 < n7) {
                    int n26 = n25;
                    WinternitzOTSignature winternitzOTSignature = this;
                    int n27 = n6++;
                    n25 = (int)l5 & n4;
                    n5 += n25;
                    n20 = n27 * this.mdsize;
                    winternitzOTSignature.hashPrivateKeyBlock(n27, n25, byArray2, n20);
                    n25 = winternitzOTSignature.w;
                    l5 >>>= n25;
                    n25 = n26 + n25;
                }
                n7 = (this.messagesize << this.w) - n5;
                n25 = 0;
                while (n25 < this.checksumsize) {
                    int n28 = n25;
                    int n29 = n7;
                    WinternitzOTSignature winternitzOTSignature = this;
                    int n30 = n6++;
                    n25 = n30 * this.mdsize;
                    winternitzOTSignature.hashPrivateKeyBlock(n30, n7 &= n4, byArray2, n25);
                    n7 = winternitzOTSignature.w;
                    n25 = n29 >>> n7;
                    int n31 = n7 = n28 + n7;
                    n7 = n25;
                    n25 = n31;
                }
                break block18;
            }
            if (n4 >= 57) break block18;
            n7 = this.mdsize;
            int n32 = (n7 << 3) - n4;
            n4 = (1 << n4) - 1;
            byte[] byArray4 = new byte[n7];
            int n33 = 0;
            while (n33 <= n32) {
                long l6;
                int n34 = n33;
                int n35 = n33;
                int n36 = n35 % 8;
                int n37 = n34 + this.w;
                n3 = n37 + 7 >>> 3;
                long l7 = 0L;
                int n38 = 0;
                for (n33 = (v1264412) >>> 3; n33 < n3; ++n33) {
                    l7 ^= (long)((byArray3[n33] & 0xFF) << (n38 << 3));
                    ++n38;
                }
                n5 = (int)((long)n5 + l6);
                n3 = this.mdsize;
                System.arraycopy(this.privateKeyOTS[n6], 0, byArray4, 0, n3);
                for (l6 = l7 >>> n36 & (long)n4; l6 > 0L; --l6) {
                    WinternitzOTSignature winternitzOTSignature = this;
                    winternitzOTSignature.messDigestOTS.update(byArray4, 0, n7);
                    winternitzOTSignature.messDigestOTS.doFinal(byArray4, 0);
                }
                n33 = this.mdsize;
                n36 = n6 * n33;
                System.arraycopy(byArray4, 0, byArray2, n36, n33);
                ++n6;
                n33 = n37;
            }
            n32 = n33 >>> 3;
            if (n32 < this.mdsize) {
                long l8;
                int n39;
                n33 %= 8;
                long l9 = 0L;
                n3 = 0;
                while (n32 < (n39 = this.mdsize)) {
                    l9 ^= (long)((byArray3[n32] & 0xFF) << (n3 << 3));
                    ++n3;
                    ++n32;
                }
                int n40 = (int)((long)n5 + l8);
                System.arraycopy(this.privateKeyOTS[n6], 0, byArray4, 0, n39);
                for (l8 = l9 >>> n33 & (long)n4; l8 > 0L; --l8) {
                    WinternitzOTSignature winternitzOTSignature = this;
                    winternitzOTSignature.messDigestOTS.update(byArray4, 0, n7);
                    winternitzOTSignature.messDigestOTS.doFinal(byArray4, 0);
                }
                n5 = this.mdsize;
                n32 = n6 * n5;
                System.arraycopy(byArray4, 0, byArray2, n32, n5);
                ++n6;
                n5 = n40;
            }
            int n41 = (this.messagesize << this.w) - n5;
            n5 = 0;
            while (n5 < this.checksumsize) {
                n32 = this.mdsize;
                System.arraycopy(this.privateKeyOTS[n6], 0, byArray4, 0, n32);
                for (long i6 = (long)(n41 & n4); i6 > 0L; --i6) {
                    WinternitzOTSignature winternitzOTSignature = this;
                    winternitzOTSignature.messDigestOTS.update(byArray4, 0, n7);
                    winternitzOTSignature.messDigestOTS.doFinal(byArray4, 0);
                }
                int n42 = n5;
                int n43 = n41;
                n41 = this.mdsize;
                n5 = n6 * n41;
                System.arraycopy(byArray4, 0, byArray2, n5, n41);
                n41 = this.w;
                n5 = n43 >>> n41;
                ++n6;
                int n44 = n41 = n42 + n41;
                n41 = n5;
                n5 = n44;
            }
        }
        return byArray2;
    }

    public int getLog(int n3) {
        int n4 = 1;
        int n5 = 2;
        while (n5 < n3) {
            n5 <<= 1;
            ++n4;
        }
        return n4;
    }
}

