/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms;

import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.ExhaustedPrivateKeyException;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.HSSKeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.HSSPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.HSSPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.HSSSignature;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMOtsParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMOtsPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMS;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSContext;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSSignature;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSSignedPubKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSigParameters;
import java.util.Arrays;
import java.util.List;

class HSS {
    public static HSSPrivateKeyParameters generateHSSKeyPair(HSSKeyGenerationParameters hSSKeyGenerationParameters) {
        HSSKeyGenerationParameters hSSKeyGenerationParameters2 = hSSKeyGenerationParameters;
        int n3 = hSSKeyGenerationParameters2.getDepth();
        Object object = new LMSPrivateKeyParameters[n3];
        LMSSignature[] lMSSignatureArray = new LMSSignature[hSSKeyGenerationParameters2.getDepth() - 1];
        byte[] byArray = new byte[32];
        hSSKeyGenerationParameters2.getRandom().nextBytes(byArray);
        byte[] byArray2 = new byte[16];
        hSSKeyGenerationParameters2.getRandom().nextBytes(byArray2);
        byte[] byArray3 = new byte[]{};
        long l3 = 1L;
        for (int i3 = 0; i3 < n3; ++i3) {
            int n4;
            int n5;
            if (i3 == 0) {
                HSSKeyGenerationParameters hSSKeyGenerationParameters3 = hSSKeyGenerationParameters;
                LMOtsParameters lMOtsParameters = hSSKeyGenerationParameters3.getLmsParameters()[i3].getLMOTSParam();
                n5 = hSSKeyGenerationParameters3.getLmsParameters()[i3].getLMSigParam().getH();
                n4 = 1 << n5;
                object[i3] = new LMSPrivateKeyParameters(hSSKeyGenerationParameters.getLmsParameters()[i3].getLMSigParam(), lMOtsParameters, 0, byArray2, n4, byArray);
            } else {
                HSSKeyGenerationParameters hSSKeyGenerationParameters4 = hSSKeyGenerationParameters;
                LMOtsParameters lMOtsParameters = hSSKeyGenerationParameters4.getLmsParameters()[i3].getLMOTSParam();
                n5 = hSSKeyGenerationParameters4.getLmsParameters()[i3].getLMSigParam().getH();
                n4 = 1 << n5;
                object[i3] = new PlaceholderLMSPrivateKey(hSSKeyGenerationParameters.getLmsParameters()[i3].getLMSigParam(), lMOtsParameters, -1, byArray3, n4, byArray3);
            }
            l3 *= (long)(1 << hSSKeyGenerationParameters.getLmsParameters()[i3].getLMSigParam().getH());
        }
        if (l3 == 0L) {
            l3 = Long.MAX_VALUE;
        }
        int n6 = hSSKeyGenerationParameters.getDepth();
        List<LMSPrivateKeyParameters> list = Arrays.asList(object);
        object = Arrays.asList(lMSSignatureArray);
        return new HSSPrivateKeyParameters(n6, list, (List<LMSSignature>)object, 0L, l3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void incrementIndex(HSSPrivateKeyParameters hSSPrivateKeyParameters) {
        HSSPrivateKeyParameters hSSPrivateKeyParameters2 = hSSPrivateKeyParameters;
        synchronized (hSSPrivateKeyParameters2) {
            HSS.rangeTestKeys(hSSPrivateKeyParameters2);
            hSSPrivateKeyParameters2.incIndex();
            List<LMSPrivateKeyParameters> list = hSSPrivateKeyParameters2.getKeys();
            int n3 = hSSPrivateKeyParameters.getL();
            list.get(n3 - 1).incIndex();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void rangeTestKeys(HSSPrivateKeyParameters hSSPrivateKeyParameters) {
        HSSPrivateKeyParameters hSSPrivateKeyParameters2 = hSSPrivateKeyParameters;
        synchronized (hSSPrivateKeyParameters2) {
            if (hSSPrivateKeyParameters2.getIndex() >= hSSPrivateKeyParameters.getIndexLimit()) {
                ExhaustedPrivateKeyException exhaustedPrivateKeyException;
                StringBuilder stringBuilder = new StringBuilder().append("hss private key");
                String string2 = hSSPrivateKeyParameters.isShard() ? " shard" : "";
                ExhaustedPrivateKeyException exhaustedPrivateKeyException2 = exhaustedPrivateKeyException;
                exhaustedPrivateKeyException2(stringBuilder.append(string2).append(" is exhausted").toString());
                throw exhaustedPrivateKeyException2;
            }
            HSSPrivateKeyParameters hSSPrivateKeyParameters3 = hSSPrivateKeyParameters;
            int n3 = hSSPrivateKeyParameters3.getL();
            Object object = hSSPrivateKeyParameters3.getKeys();
            int n4 = n3;
            {
                int n5;
                while (object.get(n5 = n4 - 1).getIndex() == 1 << object.get(n5).getSigParameters().getH()) {
                    if (n5 == 0) {
                        ExhaustedPrivateKeyException exhaustedPrivateKeyException;
                        object = new StringBuilder().append("hss private key");
                        String string3 = hSSPrivateKeyParameters.isShard() ? " shard" : "";
                        ExhaustedPrivateKeyException exhaustedPrivateKeyException3 = exhaustedPrivateKeyException;
                        exhaustedPrivateKeyException3(((StringBuilder)object).append(string3).append(" is exhausted the maximum limit for this HSS private key").toString());
                        throw exhaustedPrivateKeyException3;
                    }
                    n4 = n5;
                }
                while (n4 < n3) {
                    hSSPrivateKeyParameters.replaceConsumedKey(n4);
                    ++n4;
                }
            }
            {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HSSSignature generateSignature(HSSPrivateKeyParameters hSSPrivateKeyParameters, byte[] byArray) {
        int n3 = hSSPrivateKeyParameters.getL();
        HSSPrivateKeyParameters hSSPrivateKeyParameters2 = hSSPrivateKeyParameters;
        synchronized (hSSPrivateKeyParameters2) {
            HSS.rangeTestKeys(hSSPrivateKeyParameters2);
            List<LMSPrivateKeyParameters> list = hSSPrivateKeyParameters2.getKeys();
            List<LMSSignature> list2 = hSSPrivateKeyParameters2.getSig();
            Object object = hSSPrivateKeyParameters2.getKeys();
            int n4 = n3 - 1;
            object = object.get(n4);
            int n5 = 0;
            LMSSignedPubKey[] lMSSignedPubKeyArray = new LMSSignedPubKey[n4];
            while (n5 < n4) {
                LMSSignedPubKey lMSSignedPubKey;
                LMSSignedPubKey[] lMSSignedPubKeyArray2 = lMSSignedPubKeyArray;
                int n6 = n5;
                LMSSignedPubKey lMSSignedPubKey2 = lMSSignedPubKey;
                List<LMSPrivateKeyParameters> list3 = list;
                LMSSignature lMSSignature = list2.get(n5);
                int n7 = n5 + 1;
                lMSSignedPubKey = new LMSSignedPubKey(lMSSignature, list3.get(n7).getPublicKey());
                lMSSignedPubKeyArray2[n6] = lMSSignedPubKey2;
                n5 = n7;
            }
            HSSPrivateKeyParameters hSSPrivateKeyParameters3 = hSSPrivateKeyParameters;
            hSSPrivateKeyParameters3.incIndex();
            // ** MonitorExit[v5] (shouldn't be in output)
            LMSContext lMSContext = ((LMSPrivateKeyParameters)object).generateLMSContext().withSignedPublicKeys(lMSSignedPubKeyArray);
            lMSContext.update(byArray, 0, byArray.length);
            return HSS.generateSignature(n3, lMSContext);
        }
    }

    public static HSSSignature generateSignature(int n3, LMSContext lMSSignedPubKeyArray) {
        lMSSignedPubKeyArray = lMSSignedPubKeyArray.getSignedPubKeys();
        LMSSignature lMSSignature = LMS.generateSign((LMSContext)lMSSignedPubKeyArray);
        return new HSSSignature(--n3, lMSSignedPubKeyArray, lMSSignature);
    }

    public static boolean verifySignature(HSSPublicKeyParameters encodable, HSSSignature hSSSignature, byte[] byArray) {
        int n3 = hSSSignature.getlMinus1();
        int n4 = n3 + 1;
        if (n4 != encodable.getL()) {
            return false;
        }
        LMSSignature[] lMSSignatureArray = new LMSSignature[n4];
        LMSPublicKeyParameters[] lMSPublicKeyParametersArray = new LMSPublicKeyParameters[n3];
        for (int i3 = 0; i3 < n3; ++i3) {
            lMSSignatureArray[i3] = hSSSignature.getSignedPubKey()[i3].getSignature();
            lMSPublicKeyParametersArray[i3] = hSSSignature.getSignedPubKey()[i3].getPublicKey();
        }
        lMSSignatureArray[n3] = hSSSignature.getSignature();
        encodable = encodable.getLMSPublicKey();
        for (int i4 = 0; i4 < n3; ++i4) {
            if (!LMS.verifySignature((LMSPublicKeyParameters)encodable, (LMSSignature)(encodable = lMSSignatureArray[i4]), lMSPublicKeyParametersArray[i4].toByteArray())) {
                return false;
            }
            try {
                encodable = lMSPublicKeyParametersArray[i4];
                continue;
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception.getMessage(), exception);
            }
        }
        return LMS.verifySignature((LMSPublicKeyParameters)encodable, lMSSignatureArray[n3], byArray);
    }

    public static class PlaceholderLMSPrivateKey
    extends LMSPrivateKeyParameters {
        public PlaceholderLMSPrivateKey(LMSigParameters lMSigParameters, LMOtsParameters lMOtsParameters, int n3, byte[] byArray, int n4, byte[] byArray2) {
            super(lMSigParameters, lMOtsParameters, n3, byArray, n4, byArray2);
        }

        @Override
        public LMOtsPrivateKey getNextOtsPrivateKey() {
            throw new RuntimeException("placeholder only");
        }

        @Override
        public LMSPublicKeyParameters getPublicKey() {
            throw new RuntimeException("placeholder only");
        }
    }
}

