/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.Composer;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.DigestUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.HSS;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.HSSPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMOtsParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMS;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSContext;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSContextBasedSigner;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSSignature;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSSignedPubKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSigParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.SeedDerive;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class HSSPrivateKeyParameters
extends LMSKeyParameters
implements LMSContextBasedSigner {
    private final int l;
    private final boolean isShard;
    private List<LMSPrivateKeyParameters> keys;
    private List<LMSSignature> sig;
    private final long indexLimit;
    private long index = 0L;
    private HSSPublicKeyParameters publicKey;

    public HSSPrivateKeyParameters(int n3, List<LMSPrivateKeyParameters> list, List<LMSSignature> list2, long l3, long l4) {
        super(true);
        this.l = n3;
        this.keys = Collections.unmodifiableList(list);
        this.sig = Collections.unmodifiableList(list2);
        this.index = l3;
        this.indexLimit = l4;
        this.isShard = false;
        this.resetKeyToIndex();
    }

    private HSSPrivateKeyParameters(int n3, List<LMSPrivateKeyParameters> list, List<LMSSignature> list2, long l3, long l4, boolean bl) {
        super(true);
        this.l = n3;
        this.keys = Collections.unmodifiableList(list);
        this.sig = Collections.unmodifiableList(list2);
        this.index = l3;
        this.indexLimit = l4;
        this.isShard = bl;
    }

    public static HSSPrivateKeyParameters getInstance(byte[] byArray, byte[] byArray2) {
        HSSPrivateKeyParameters.getInstance(byArray).publicKey = HSSPublicKeyParameters.getInstance(byArray2);
        return HSSPrivateKeyParameters.getInstance(byArray);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HSSPrivateKeyParameters getInstance(Object object) {
        if (object instanceof HSSPrivateKeyParameters) {
            return (HSSPrivateKeyParameters)object;
        }
        if (object instanceof DataInputStream) {
            int n3;
            ArrayList<LMSSignature> arrayList;
            ArrayList<LMSPrivateKeyParameters> arrayList2;
            DataInputStream dataInputStream = (DataInputStream)object;
            if (dataInputStream.readInt() != 0) {
                throw new IllegalStateException("unknown version for hss private key");
            }
            DataInputStream dataInputStream2 = dataInputStream;
            int n4 = dataInputStream2.readInt();
            long l3 = dataInputStream2.readLong();
            long l4 = dataInputStream2.readLong();
            boolean bl = dataInputStream2.readBoolean();
            ArrayList<LMSPrivateKeyParameters> arrayList3 = arrayList2;
            arrayList2 = new ArrayList<LMSPrivateKeyParameters>();
            ArrayList<LMSSignature> arrayList4 = arrayList;
            arrayList = new ArrayList<LMSSignature>();
            for (n3 = 0; n3 < n4; ++n3) {
                arrayList3.add(LMSPrivateKeyParameters.getInstance(object));
            }
            n3 = 0;
            while (true) {
                if (n3 >= n4 - 1) {
                    return new HSSPrivateKeyParameters(n4, arrayList3, arrayList4, l3, l4, bl);
                }
                arrayList4.add(LMSSignature.getInstance(object));
                ++n3;
            }
        }
        if (object instanceof byte[]) {
            void var0_3;
            InputStream inputStream;
            block14: {
                HSSPrivateKeyParameters hSSPrivateKeyParameters;
                DataInputStream dataInputStream;
                inputStream = null;
                DataInputStream dataInputStream3 = dataInputStream;
                try {
                    dataInputStream = new DataInputStream(new ByteArrayInputStream((byte[])object));
                }
                catch (Throwable throwable) {
                    // empty catch block
                    break block14;
                }
                try {
                    hSSPrivateKeyParameters = HSSPrivateKeyParameters.getInstance(dataInputStream);
                }
                catch (Throwable throwable) {
                    inputStream = dataInputStream3;
                    break block14;
                }
                ((InputStream)dataInputStream3).close();
                return hSSPrivateKeyParameters;
            }
            if (inputStream != null) {
                inputStream.close();
            }
            throw var0_3;
        }
        if (object instanceof InputStream) {
            return HSSPrivateKeyParameters.getInstance(Streams.readAll((InputStream)object));
        }
        throw new IllegalArgumentException("cannot parse " + object);
    }

    private static HSSPrivateKeyParameters makeCopy(HSSPrivateKeyParameters hSSPrivateKeyParameters) {
        try {
            return HSSPrivateKeyParameters.getInstance(hSSPrivateKeyParameters.getEncoded());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
    }

    public int getL() {
        return this.l;
    }

    public synchronized long getIndex() {
        return this.index;
    }

    public synchronized LMSParameters[] getLMSParameters() {
        int n3 = this.keys.size();
        LMSParameters[] lMSParametersArray = new LMSParameters[n3];
        for (int i3 = 0; i3 < n3; ++i3) {
            LMSParameters lMSParameters;
            Object object = this.keys.get(i3);
            LMSParameters lMSParameters2 = lMSParameters;
            LMSPrivateKeyParameters lMSPrivateKeyParameters = object;
            object = lMSPrivateKeyParameters.getSigParameters();
            lMSParameters = new LMSParameters((LMSigParameters)object, lMSPrivateKeyParameters.getOtsParameters());
            lMSParametersArray[i3] = lMSParameters2;
        }
        return lMSParametersArray;
    }

    public synchronized void incIndex() {
        ++this.index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateHierarchy(LMSPrivateKeyParameters[] lMSPrivateKeyParametersArray, LMSSignature[] lMSSignatureArray) {
        synchronized (this) {
            this.keys = Collections.unmodifiableList(java.util.Arrays.asList(lMSPrivateKeyParametersArray));
            this.sig = Collections.unmodifiableList(java.util.Arrays.asList(lMSSignatureArray));
            return;
        }
    }

    public boolean isShard() {
        return this.isShard;
    }

    public long getIndexLimit() {
        return this.indexLimit;
    }

    @Override
    public long getUsagesRemaining() {
        return this.indexLimit - this.index;
    }

    public LMSPrivateKeyParameters getRootKey() {
        return this.keys.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HSSPrivateKeyParameters extractKeyShard(int n3) {
        HSSPrivateKeyParameters hSSPrivateKeyParameters = this;
        synchronized (hSSPrivateKeyParameters) {
            ArrayList<LMSSignature> arrayList;
            ArrayList<LMSPrivateKeyParameters> arrayList2;
            long l3 = hSSPrivateKeyParameters.getUsagesRemaining();
            long l4 = n3;
            if (l3 < l4) throw new IllegalArgumentException("usageCount exceeds usages remaining in current leaf");
            HSSPrivateKeyParameters hSSPrivateKeyParameters2 = this;
            HSSPrivateKeyParameters hSSPrivateKeyParameters3 = hSSPrivateKeyParameters2;
            long l5 = hSSPrivateKeyParameters2.index;
            long l6 = l4;
            l4 = l5 + l4;
            hSSPrivateKeyParameters3.index = l5 + l6;
            ArrayList<LMSPrivateKeyParameters> arrayList3 = arrayList2;
            arrayList2 = new ArrayList<LMSPrivateKeyParameters>(this.getKeys());
            ArrayList<LMSSignature> arrayList4 = arrayList;
            arrayList = new ArrayList<LMSSignature>(this.getSig());
            HSSPrivateKeyParameters hSSPrivateKeyParameters4 = HSSPrivateKeyParameters.makeCopy(new HSSPrivateKeyParameters(this.l, arrayList3, arrayList4, l5, l4, true));
            HSSPrivateKeyParameters hSSPrivateKeyParameters5 = this;
            hSSPrivateKeyParameters5.resetKeyToIndex();
            // ** MonitorExit[v9] (shouldn't be in output)
            return hSSPrivateKeyParameters4;
        }
    }

    public synchronized List<LMSPrivateKeyParameters> getKeys() {
        return this.keys;
    }

    public synchronized List<LMSSignature> getSig() {
        return this.sig;
    }

    public void resetKeyToIndex() {
        Object object;
        HSSPrivateKeyParameters hSSPrivateKeyParameters = this;
        List<LMSPrivateKeyParameters> list = hSSPrivateKeyParameters.getKeys();
        int n3 = list.size();
        long[] lArray = new long[n3];
        long l3 = hSSPrivateKeyParameters.getIndex();
        for (int i3 = list.size() - 1; i3 >= 0; --i3) {
            LMSigParameters lMSigParameters = list.get(i3).getSigParameters();
            lArray[i3] = l3 & (long)((1 << lMSigParameters.getH()) - 1);
            l3 >>>= lMSigParameters.getH();
        }
        List<LMSPrivateKeyParameters> list2 = list;
        boolean bl = false;
        LMSPrivateKeyParameters[] lMSPrivateKeyParametersArray = list2.toArray(new LMSPrivateKeyParameters[list2.size()]);
        HSSPrivateKeyParameters hSSPrivateKeyParameters2 = this;
        List<LMSSignature> list3 = hSSPrivateKeyParameters2.sig;
        LMSSignature[] lMSSignatureArray = list3.toArray(new LMSSignature[list3.size()]);
        LMSPrivateKeyParameters lMSPrivateKeyParameters = hSSPrivateKeyParameters2.getRootKey();
        if ((long)(lMSPrivateKeyParametersArray[0].getIndex() - 1) != lArray[0]) {
            LMSPrivateKeyParameters lMSPrivateKeyParameters2 = lMSPrivateKeyParameters;
            LMOtsParameters lMOtsParameters = lMSPrivateKeyParameters.getOtsParameters();
            int n4 = (int)lArray[0];
            byte[] byArray = lMSPrivateKeyParameters2.getI();
            object = lMSPrivateKeyParameters2.getMasterSecret();
            lMSPrivateKeyParametersArray[0] = LMS.generateKeys(lMSPrivateKeyParameters.getSigParameters(), lMOtsParameters, n4, byArray, (byte[])object);
            bl = true;
        }
        for (int i4 = 1; i4 < n3; ++i4) {
            SeedDerive seedDerive;
            SeedDerive seedDerive2;
            int n5 = i4 - 1;
            object = lMSPrivateKeyParametersArray[n5];
            byte[] byArray = new byte[16];
            byte[] byArray2 = new byte[32];
            SeedDerive seedDerive3 = seedDerive2 = seedDerive;
            Object object2 = object;
            byte[] byArray3 = ((LMSPrivateKeyParameters)object2).getI();
            byte[] byArray4 = ((LMSPrivateKeyParameters)object2).getMasterSecret();
            seedDerive2(byArray3, byArray4, DigestUtil.getDigest(((LMSPrivateKeyParameters)object).getOtsParameters().getDigestOID()));
            seedDerive3.setQ((int)lArray[n5]);
            seedDerive3.setJ(-2);
            seedDerive.deriveSeed(byArray2, true);
            byte[] byArray5 = new byte[32];
            seedDerive2.deriveSeed(byArray5, false);
            System.arraycopy(byArray5, 0, byArray, 0, 16);
            boolean bl2 = i4 < n3 - 1 ? lArray[i4] == (long)(lMSPrivateKeyParametersArray[i4].getIndex() - 1) : lArray[i4] == (long)lMSPrivateKeyParametersArray[i4].getIndex();
            if (!(Arrays.areEqual(byArray, lMSPrivateKeyParametersArray[i4].getI()) && Arrays.areEqual(byArray2, lMSPrivateKeyParametersArray[i4].getMasterSecret()))) {
                Object object3 = list.get(i4).getOtsParameters();
                object3 = LMS.generateKeys(list.get(i4).getSigParameters(), (LMOtsParameters)object3, (int)lArray[i4], byArray, byArray2);
                lMSPrivateKeyParametersArray[i4] = object3;
                lMSSignatureArray[n5] = LMS.generateSign(lMSPrivateKeyParametersArray[n5], ((LMSPrivateKeyParameters)object3).getPublicKey().toByteArray());
                bl = true;
                continue;
            }
            if (bl2) continue;
            LMOtsParameters lMOtsParameters = list.get(i4).getOtsParameters();
            lMSPrivateKeyParametersArray[i4] = LMS.generateKeys(list.get(i4).getSigParameters(), lMOtsParameters, (int)lArray[i4], byArray, byArray2);
            bl = true;
        }
        if (bl) {
            this.updateHierarchy(lMSPrivateKeyParametersArray, lMSSignatureArray);
        }
    }

    public synchronized HSSPublicKeyParameters getPublicKey() {
        return new HSSPublicKeyParameters(this.l, this.getRootKey().getPublicKey());
    }

    public void replaceConsumedKey(int n3) {
        ArrayList arrayList;
        ArrayList<LMSPrivateKeyParameters> arrayList2;
        int n4 = n3 - 1;
        ArrayList<LMSSignature> arrayList3 = this.keys.get(n4).getCurrentOTSKey().getDerivationFunction();
        ((SeedDerive)((Object)arrayList3)).setJ(-2);
        byte[] byArray = new byte[32];
        ((SeedDerive)((Object)arrayList3)).deriveSeed(byArray, true);
        byte[] byArray2 = new byte[32];
        ((SeedDerive)((Object)arrayList3)).deriveSeed(byArray2, false);
        arrayList3 = (ArrayList<LMSSignature>)new byte[16];
        System.arraycopy(byArray2, 0, arrayList3, 0, 16);
        ArrayList<LMSPrivateKeyParameters> arrayList4 = arrayList2;
        arrayList4(this.keys);
        LMSPrivateKeyParameters lMSPrivateKeyParameters = this.keys.get(n3);
        arrayList2.set(n3, LMS.generateKeys(lMSPrivateKeyParameters.getSigParameters(), lMSPrivateKeyParameters.getOtsParameters(), 0, (byte[])arrayList3, byArray));
        arrayList3 = arrayList;
        arrayList3(this.sig);
        arrayList.set(n4, LMS.generateSign(arrayList4.get(n4), arrayList4.get(n3).getPublicKey().toByteArray()));
        this.keys = Collections.unmodifiableList(arrayList2);
        this.sig = Collections.unmodifiableList(arrayList3);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            object = (HSSPrivateKeyParameters)object;
            if (this.l != ((HSSPrivateKeyParameters)object).l) {
                return false;
            }
            if (this.isShard != ((HSSPrivateKeyParameters)object).isShard) {
                return false;
            }
            if (this.indexLimit != ((HSSPrivateKeyParameters)object).indexLimit) {
                return false;
            }
            if (this.index != ((HSSPrivateKeyParameters)object).index) {
                return false;
            }
            if (!this.keys.equals(((HSSPrivateKeyParameters)object).keys)) {
                return false;
            }
            return this.sig.equals(((HSSPrivateKeyParameters)object).sig);
        }
        return false;
    }

    @Override
    public synchronized byte[] getEncoded() {
        Composer composer = Composer.compose().u32str(0).u32str(((HSSPrivateKeyParameters)((Object)iterator2)).l).u64str(((HSSPrivateKeyParameters)((Object)iterator2)).index).u64str(((HSSPrivateKeyParameters)((Object)iterator2)).indexLimit).bool(((HSSPrivateKeyParameters)((Object)iterator2)).isShard);
        Iterator<LMSPrivateKeyParameters> iterator = ((HSSPrivateKeyParameters)((Object)iterator2)).keys.iterator();
        while (iterator.hasNext()) {
            composer.bytes(iterator.next());
        }
        Iterator<LMSSignature> iterator2 = ((HSSPrivateKeyParameters)((Object)iterator2)).sig.iterator();
        while (iterator2.hasNext()) {
            composer.bytes((LMSSignature)iterator2.next());
        }
        return composer.build();
    }

    public int hashCode() {
        HSSPrivateKeyParameters hSSPrivateKeyParameters = this;
        int n3 = (hSSPrivateKeyParameters.l * 31 + this.isShard) * 31;
        n3 = (hSSPrivateKeyParameters.keys.hashCode() + n3) * 31;
        long l3 = this.indexLimit;
        long l4 = this.index;
        return ((hSSPrivateKeyParameters.sig.hashCode() + n3) * 31 + (int)(l3 ^ l3 >>> 32)) * 31 + (int)(l4 ^ l4 >>> 32);
    }

    public Object clone() {
        return HSSPrivateKeyParameters.makeCopy(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LMSContext generateLMSContext() {
        int n3 = this.getL();
        HSSPrivateKeyParameters hSSPrivateKeyParameters = this;
        synchronized (hSSPrivateKeyParameters) {
            HSS.rangeTestKeys(hSSPrivateKeyParameters);
            List<LMSPrivateKeyParameters> list = hSSPrivateKeyParameters.getKeys();
            List<LMSSignature> list2 = hSSPrivateKeyParameters.getSig();
            Object object = hSSPrivateKeyParameters.getKeys();
            int n4 = n3 - 1;
            object = object.get(n4);
            int n5 = 0;
            LMSSignedPubKey[] lMSSignedPubKeyArray = new LMSSignedPubKey[n4];
            while (n5 < n4) {
                LMSSignedPubKey lMSSignedPubKey;
                LMSSignedPubKey[] lMSSignedPubKeyArray2 = lMSSignedPubKeyArray;
                int n6 = n5;
                LMSSignedPubKey lMSSignedPubKey2 = lMSSignedPubKey;
                List<LMSPrivateKeyParameters> list3 = list;
                LMSSignature lMSSignature = list2.get(n5);
                int n7 = n5 + 1;
                lMSSignedPubKey = new LMSSignedPubKey(lMSSignature, list3.get(n7).getPublicKey());
                lMSSignedPubKeyArray2[n6] = lMSSignedPubKey2;
                n5 = n7;
            }
            HSSPrivateKeyParameters hSSPrivateKeyParameters2 = this;
            hSSPrivateKeyParameters2.incIndex();
            // ** MonitorExit[v6] (shouldn't be in output)
            return ((LMSPrivateKeyParameters)object).generateLMSContext().withSignedPublicKeys(lMSSignedPubKeyArray);
        }
    }

    @Override
    public byte[] generateSignature(LMSContext lMSContext) {
        try {
            return HSS.generateSignature(this.getL(), lMSContext).getEncoded();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(b.a(iOException, b.b.a("unable to encode signature: ")), iOException);
        }
    }
}

