/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;

public class LMOtsParameters {
    public static final int reserved = 0;
    public static final LMOtsParameters sha256_n32_w1;
    public static final LMOtsParameters sha256_n32_w2;
    public static final LMOtsParameters sha256_n32_w4;
    public static final LMOtsParameters sha256_n32_w8;
    private static final Map<Object, LMOtsParameters> suppliers;
    private final int type;
    private final int n;
    private final int w;
    private final int p;
    private final int ls;
    private final int sigLen;
    private final ASN1ObjectIdentifier digestOID;

    public LMOtsParameters(int n3, int n4, int n5, int n6, int n7, int n8, ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        this.type = n3;
        this.n = n4;
        this.w = n5;
        this.p = n6;
        this.ls = n7;
        this.sigLen = n8;
        this.digestOID = aSN1ObjectIdentifier;
    }

    public static LMOtsParameters getParametersForType(int n3) {
        return suppliers.get(n3);
    }

    static {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = NISTObjectIdentifiers.id_sha256;
        sha256_n32_w1 = new LMOtsParameters(1, 32, 1, 265, 7, 8516, aSN1ObjectIdentifier);
        sha256_n32_w2 = new LMOtsParameters(2, 32, 2, 133, 6, 4292, aSN1ObjectIdentifier);
        sha256_n32_w4 = new LMOtsParameters(3, 32, 4, 67, 4, 2180, aSN1ObjectIdentifier);
        sha256_n32_w8 = new LMOtsParameters(4, 32, 8, 34, 0, 1124, aSN1ObjectIdentifier);
        suppliers = new HashMap<Object, LMOtsParameters>(){
            {
                1 v02 = object;
                Object object = sha256_n32_w1;
                ((AbstractMap)v02).put(((LMOtsParameters)object).type, object);
                object = sha256_n32_w2;
                ((AbstractMap)v02).put(((LMOtsParameters)object).type, object);
                object = sha256_n32_w4;
                ((AbstractMap)v02).put(((LMOtsParameters)object).type, object);
                object = sha256_n32_w8;
                ((AbstractMap)v02).put(((LMOtsParameters)object).type, object);
            }
        };
    }

    public int getType() {
        return this.type;
    }

    public int getN() {
        return this.n;
    }

    public int getW() {
        return this.w;
    }

    public int getP() {
        return this.p;
    }

    public int getLs() {
        return this.ls;
    }

    public int getSigLen() {
        return this.sigLen;
    }

    public ASN1ObjectIdentifier getDigestOID() {
        return this.digestOID;
    }
}

