/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.DigestUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMOtsParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSContext;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSigParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LmsUtils;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.SeedDerive;

class LMOtsPrivateKey {
    private final LMOtsParameters parameter;
    private final byte[] I;
    private final int q;
    private final byte[] masterSecret;

    public LMOtsPrivateKey(LMOtsParameters lMOtsParameters, byte[] byArray, int n3, byte[] byArray2) {
        this.parameter = lMOtsParameters;
        this.I = byArray;
        this.q = n3;
        this.masterSecret = byArray2;
    }

    public LMSContext getSignatureContext(LMSigParameters lMSigParameters, byte[][] byArray) {
        byte[] byArray2 = new byte[32];
        LMOtsPrivateKey lMOtsPrivateKey = this;
        SeedDerive seedDerive = lMOtsPrivateKey.getDerivationFunction();
        seedDerive.setJ(-3);
        seedDerive.deriveSeed(byArray2, false);
        Digest digest = DigestUtil.getDigest(lMOtsPrivateKey.parameter.getDigestOID());
        LMOtsPrivateKey lMOtsPrivateKey2 = this;
        LmsUtils.byteArray(lMOtsPrivateKey2.getI(), digest);
        LmsUtils.u32str(lMOtsPrivateKey2.getQ(), digest);
        LmsUtils.u16str((short)-32383, digest);
        LmsUtils.byteArray(byArray2, digest);
        return new LMSContext(this, lMSigParameters, digest, byArray2, byArray);
    }

    public SeedDerive getDerivationFunction() {
        LMOtsPrivateKey lMOtsPrivateKey = this;
        byte[] byArray = lMOtsPrivateKey.I;
        byte[] byArray2 = lMOtsPrivateKey.masterSecret;
        SeedDerive seedDerive = new SeedDerive(byArray, byArray2, DigestUtil.getDigest(this.parameter.getDigestOID()));
        seedDerive.setQ(this.q);
        return seedDerive;
    }

    public LMOtsParameters getParameter() {
        return this.parameter;
    }

    public byte[] getI() {
        return this.I;
    }

    public int getQ() {
        return this.q;
    }

    public byte[] getMasterSecret() {
        return this.masterSecret;
    }
}

