/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.Composer;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.DigestUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMOtsParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMOtsSignature;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSContext;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSSignature;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LmsUtils;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Arrays;

class LMOtsPublicKey
implements Encodable {
    private final LMOtsParameters parameter;
    private final byte[] I;
    private final int q;
    private final byte[] K;

    public LMOtsPublicKey(LMOtsParameters lMOtsParameters, byte[] byArray, int n3, byte[] byArray2) {
        this.parameter = lMOtsParameters;
        this.I = byArray;
        this.q = n3;
        this.K = byArray2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LMOtsPublicKey getInstance(Object object) {
        if (object instanceof LMOtsPublicKey) {
            return (LMOtsPublicKey)object;
        }
        if (object instanceof DataInputStream) {
            DataInputStream dataInputStream = (DataInputStream)object;
            object = LMOtsParameters.getParametersForType(dataInputStream.readInt());
            byte[] byArray = new byte[16];
            dataInputStream.readFully(byArray);
            int n3 = dataInputStream.readInt();
            byte[] byArray2 = new byte[((LMOtsParameters)object).getN()];
            dataInputStream.readFully(byArray2);
            return new LMOtsPublicKey((LMOtsParameters)object, byArray, n3, byArray2);
        }
        if (object instanceof byte[]) {
            void var0_3;
            InputStream inputStream;
            block10: {
                LMOtsPublicKey lMOtsPublicKey;
                DataInputStream dataInputStream;
                inputStream = null;
                DataInputStream dataInputStream2 = dataInputStream;
                try {
                    dataInputStream = new DataInputStream(new ByteArrayInputStream((byte[])object));
                }
                catch (Throwable throwable) {
                    // empty catch block
                    break block10;
                }
                try {
                    lMOtsPublicKey = LMOtsPublicKey.getInstance(dataInputStream);
                }
                catch (Throwable throwable) {
                    inputStream = dataInputStream2;
                    break block10;
                }
                ((InputStream)dataInputStream2).close();
                return lMOtsPublicKey;
            }
            if (inputStream != null) {
                inputStream.close();
            }
            throw var0_3;
        }
        if (object instanceof InputStream) {
            return LMOtsPublicKey.getInstance(Streams.readAll((InputStream)object));
        }
        throw new IllegalArgumentException("cannot parse " + object);
    }

    public LMOtsParameters getParameter() {
        return this.parameter;
    }

    public byte[] getI() {
        return this.I;
    }

    public int getQ() {
        return this.q;
    }

    public byte[] getK() {
        return this.K;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            object = (LMOtsPublicKey)object;
            if (this.q != ((LMOtsPublicKey)object).q) {
                return false;
            }
            LMOtsParameters lMOtsParameters = this.parameter;
            if (lMOtsParameters != null ? !lMOtsParameters.equals(((LMOtsPublicKey)object).parameter) : ((LMOtsPublicKey)object).parameter != null) {
                return false;
            }
            if (!Arrays.equals(this.I, ((LMOtsPublicKey)object).I)) {
                return false;
            }
            return Arrays.equals(this.K, ((LMOtsPublicKey)object).K);
        }
        return false;
    }

    public int hashCode() {
        LMOtsParameters lMOtsParameters = this.parameter;
        int n3 = (lMOtsParameters != null ? lMOtsParameters.hashCode() : 0) * 31;
        LMOtsPublicKey lMOtsPublicKey = this;
        int n4 = ((Arrays.hashCode(lMOtsPublicKey.I) + n3) * 31 + this.q) * 31;
        return Arrays.hashCode(lMOtsPublicKey.K) + n4;
    }

    @Override
    public byte[] getEncoded() {
        return Composer.compose().u32str(this.parameter.getType()).bytes(this.I).u32str(this.q).bytes(this.K).build();
    }

    public LMSContext createOtsContext(LMOtsSignature lMOtsSignature) {
        LMOtsPublicKey lMOtsPublicKey = this;
        Digest digest = DigestUtil.getDigest(lMOtsPublicKey.parameter.getDigestOID());
        LmsUtils.byteArray(lMOtsPublicKey.I, digest);
        LmsUtils.u32str(lMOtsPublicKey.q, digest);
        LmsUtils.u16str((short)-32383, digest);
        LmsUtils.byteArray(lMOtsSignature.getC(), digest);
        return new LMSContext(this, lMOtsSignature, digest);
    }

    public LMSContext createOtsContext(LMSSignature lMSSignature) {
        LMOtsPublicKey lMOtsPublicKey = this;
        Digest digest = DigestUtil.getDigest(lMOtsPublicKey.parameter.getDigestOID());
        LmsUtils.byteArray(lMOtsPublicKey.I, digest);
        LmsUtils.u32str(lMOtsPublicKey.q, digest);
        LmsUtils.u16str((short)-32383, digest);
        LmsUtils.byteArray(lMSSignature.getOtsSignature().getC(), digest);
        return new LMSContext(this, lMSSignature, digest);
    }
}

