/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMOtsPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMOtsPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSSignedPubKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSigParameters;

public class LMSContext
implements Digest {
    private final byte[] C;
    private final LMOtsPrivateKey key;
    private final LMSigParameters sigParams;
    private final byte[][] path;
    private final LMOtsPublicKey publicKey;
    private final Object signature;
    private LMSSignedPubKey[] signedPubKeys;
    private volatile Digest digest;

    public LMSContext(LMOtsPrivateKey lMOtsPrivateKey, LMSigParameters lMSigParameters, Digest digest, byte[] byArray, byte[][] byArray2) {
        this.key = lMOtsPrivateKey;
        this.sigParams = lMSigParameters;
        this.digest = digest;
        this.C = byArray;
        this.path = byArray2;
        this.publicKey = null;
        this.signature = null;
    }

    public LMSContext(LMOtsPublicKey lMOtsPublicKey, Object object, Digest digest) {
        this.publicKey = lMOtsPublicKey;
        this.signature = object;
        this.digest = digest;
        this.C = null;
        this.key = null;
        this.sigParams = null;
        this.path = null;
    }

    public byte[] getC() {
        return this.C;
    }

    public byte[] getQ() {
        byte[] byArray = new byte[34];
        this.digest.doFinal(byArray, 0);
        this.digest = null;
        return byArray;
    }

    public byte[][] getPath() {
        return this.path;
    }

    public LMOtsPrivateKey getPrivateKey() {
        return this.key;
    }

    public LMOtsPublicKey getPublicKey() {
        return this.publicKey;
    }

    public LMSigParameters getSigParams() {
        return this.sigParams;
    }

    public Object getSignature() {
        return this.signature;
    }

    public LMSSignedPubKey[] getSignedPubKeys() {
        return this.signedPubKeys;
    }

    public LMSContext withSignedPublicKeys(LMSSignedPubKey[] lMSSignedPubKeyArray) {
        this.signedPubKeys = lMSSignedPubKeyArray;
        return this;
    }

    @Override
    public String getAlgorithmName() {
        return this.digest.getAlgorithmName();
    }

    @Override
    public int getDigestSize() {
        return this.digest.getDigestSize();
    }

    @Override
    public void update(byte by) {
        this.digest.update(by);
    }

    @Override
    public void update(byte[] byArray, int n3, int n4) {
        this.digest.update(byArray, n3, n4);
    }

    @Override
    public int doFinal(byte[] byArray, int n3) {
        return this.digest.doFinal(byArray, n3);
    }

    @Override
    public void reset() {
        this.digest.reset();
    }
}

